/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import virtuoso.jdbc4.VirtuosoBlob;

class VirtuosoBlobStream
extends InputStream {
    private VirtuosoBlob blob;
    protected long pos = 1L;

    VirtuosoBlobStream(VirtuosoBlob blob) {
        this.blob = blob;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.pos > this.blob.length() ? -1 : this.blob.getBytes(this.pos++, 1)[0];
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            byte[] bytes = null;
            if (len <= 0) {
                return 0;
            }
            if (this.pos + (long)len > this.blob.length()) {
                int to_read = (int)(this.blob.length() - this.pos + 1L);
                if (to_read > 0) {
                    bytes = this.blob.getBytes(this.pos, to_read);
                }
                if (bytes != null) {
                    System.arraycopy(bytes, 0, b, off, to_read);
                    this.pos = this.blob.length() + 1L;
                    return bytes.length;
                }
                return -1;
            }
            bytes = this.blob.getBytes(this.pos, len);
            if (bytes != null) {
                System.arraycopy(bytes, 0, b, off, len);
                this.pos += (long)bytes.length;
                return bytes.length;
            }
            return -1;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            if (n <= 0L) {
                return 0L;
            }
            if (this.pos + n > this.blob.length()) {
                long _prov = this.blob.length() - this.pos + 1L;
                this.pos = this.blob.length();
                return _prov;
            }
            this.pos += n;
            return n;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return (int)(this.blob.length() - this.pos + 1L);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void reset() {
        this.pos = 1L;
    }
}

