/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.update.UpdateException;
import virtuoso.jena.driver.VirtGraph;

public class VirtuosoUpdateRequest {
    private List<String> requests = new ArrayList<String>();
    private VirtGraph graph;
    private String virt_query;
    Statement stmt = null;

    public VirtuosoUpdateRequest(VirtGraph _graph) {
        this.graph = _graph;
    }

    public VirtuosoUpdateRequest(String query, VirtGraph _graph) {
        this(_graph);
        this.virt_query = query;
        this.requests.add(query);
    }

    public void exec() {
        try {
            this.stmt = this.graph.createStatement(true);
            Iterator<String> iter = this.requests.iterator();
            while (iter.hasNext()) {
                StringBuilder sb = new StringBuilder();
                sb.append("sparql\n");
                this.graph.appendSparqlPrefixes(sb, false);
                sb.append(iter.next());
                this.stmt.addBatch(sb.toString());
            }
            this.stmt.executeBatch();
            this.stmt.clearBatch();
            this.requests.clear();
        }
        catch (Exception e) {
            throw new UpdateException("Convert results are FAILED.:", (Throwable)e);
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {}
            this.stmt = null;
        }
    }

    public void addUpdate(String update) {
        this.requests.add(update);
    }

    public Iterator<String> iterator() {
        return this.requests.iterator();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        Iterator<String> iter = this.requests.iterator();
        while (iter.hasNext()) {
            b.append(iter.next());
            b.append("\n");
        }
        return b.toString();
    }
}

