/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.util.FileManager;
import virtuoso.jena.driver.VirtDataset;
import virtuoso.jena.driver.VirtGraph;
import virtuoso.jena.driver.VirtModel;
import virtuoso.jena.driver.VirtResSetIter2;

public class VirtuosoQueryExecution
implements QueryExecution {
    private QueryIterConcat output = null;
    private String virt_graph = null;
    private VirtGraph graph;
    private String virt_query;
    private QuerySolution m_arg = null;
    private Context m_context = new Context();
    private Query mj_query = null;
    protected long timeout = -1L;
    private Statement stmt = null;

    public VirtuosoQueryExecution(Query query, VirtGraph _graph) {
        this(query.toString(), _graph);
        this.mj_query = query;
    }

    public VirtuosoQueryExecution(String query, VirtGraph _graph) {
        this.graph = _graph;
        this.virt_graph = this.graph.getGraphName();
        this.virt_query = query;
    }

    public ResultSet execSelect() {
        Object ret = null;
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            return new VResultSet(this.graph, this.stmt, rs);
        }
        catch (Exception e) {
            throw new JenaException("Can not create ResultSet.:" + e);
        }
    }

    public void setFileManager(FileManager arg) {
        throw new JenaException("UnsupportedMethodException");
    }

    public void setInitialBinding(QuerySolution arg) {
        this.m_arg = arg;
    }

    public Dataset getDataset() {
        return new VirtDataset(this.graph);
    }

    public Context getContext() {
        return this.m_context;
    }

    public Query getQuery() {
        if (this.mj_query == null) {
            try {
                this.mj_query = QueryFactory.create((String)this.virt_query);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.mj_query;
    }

    public Iterator<Quad> execConstructQuads() {
        throw new JenaException("execConstructQuads isn't supported.");
    }

    public Dataset execConstructDataset() {
        return this.execConstructDataset(DatasetFactory.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dataset execConstructDataset(Dataset dataset) {
        DatasetGraph dsg = dataset.asDatasetGraph();
        Graph g = dsg.getDefaultGraph();
        try {
            Iterator<Triple> it = this.execConstructTriples();
            while (it.hasNext()) {
                g.add(it.next());
            }
        }
        finally {
            this.close();
        }
        return dataset;
    }

    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    public Model execConstruct(Model model) {
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            while (rs.next()) {
                Node o;
                Node p;
                Node s = VirtGraph.Object2Node(rs.getObject(1));
                org.apache.jena.rdf.model.Statement st = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(s, p = VirtGraph.Object2Node(rs.getObject(2)), o = VirtGraph.Object2Node(rs.getObject(3))));
                if (st == null) continue;
                model.add(st);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException("Convert results has FAILED.:" + e);
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {}
            this.stmt = null;
        }
        return model;
    }

    public Iterator<Triple> execConstructTriples() {
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            return new VirtResSetIter2(this.graph, this.stmt, rs);
        }
        catch (Exception e) {
            throw new JenaException("execConstructTriples has FAILED.:" + e);
        }
    }

    public Model execDescribe() {
        return this.execDescribe(ModelFactory.createDefaultModel());
    }

    public Model execDescribe(Model model) {
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            while (rs.next()) {
                Node o;
                Node p;
                Node s = VirtGraph.Object2Node(rs.getObject(1));
                org.apache.jena.rdf.model.Statement st = ModelUtils.tripleToStatement((Model)model, (Triple)new Triple(s, p = VirtGraph.Object2Node(rs.getObject(2)), o = VirtGraph.Object2Node(rs.getObject(3))));
                if (st == null) continue;
                model.add(st);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException("Convert results are FAILED.:" + e);
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {}
            this.stmt = null;
        }
        return model;
    }

    public Iterator<Triple> execDescribeTriples() {
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            return new VirtResSetIter2(this.graph, this.stmt, rs);
        }
        catch (Exception e) {
            throw new JenaException("execDescribeTriples has FAILED.:" + e);
        }
    }

    public boolean execAsk() {
        boolean ret = false;
        try {
            this.stmt = this.graph.createStatement(false);
            if (this.timeout > 0L) {
                this.stmt.setQueryTimeout((int)(this.timeout / 1000L));
            }
            java.sql.ResultSet rs = this.stmt.executeQuery(this.getVosQuery());
            while (rs.next()) {
                if (rs.getInt(1) != 1) continue;
                ret = true;
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException("Convert results has FAILED.:" + e);
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (Exception e) {}
            this.stmt = null;
        }
        return ret;
    }

    public JsonArray execJson() {
        throw new JenaException("Unsupported Operation");
    }

    public Iterator<JsonObject> execJsonItems() {
        throw new JenaException("Unsupported Operation");
    }

    public void abort() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void close() {
        if (this.stmt != null) {
            try {
                this.stmt.cancel();
                this.stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isClosed() {
        return this.stmt == null;
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnits) {
        this.timeout = timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        this.timeout = timeout1;
    }

    public void setTimeout(long timeout1, long timeout2) {
        this.timeout = timeout1;
    }

    public long getTimeout1() {
        return this.timeout;
    }

    public long getTimeout2() {
        return -1L;
    }

    private String substBindings(String query) {
        if (this.m_arg == null) {
            return query;
        }
        StringBuffer buf = new StringBuffer();
        String delim = " ,)(;.}{";
        int i = 0;
        int qlen = query.length();
        block0: while (i < qlen) {
            char ch;
            if ((ch = query.charAt(i++)) == '\\') {
                buf.append(ch);
                if (i >= qlen) continue;
                buf.append(query.charAt(i++));
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                char end = ch;
                buf.append(ch);
                while (i < qlen) {
                    ch = query.charAt(i++);
                    buf.append(ch);
                    if (ch != end) continue;
                    continue block0;
                }
                continue;
            }
            if (ch == '?') {
                String varName;
                RDFNode val;
                int j;
                String varData = null;
                for (j = i; j < qlen && delim.indexOf(query.charAt(j)) < 0; ++j) {
                }
                if (j != i && (val = this.m_arg.get(varName = query.substring(i, j))) != null) {
                    varData = this.graph.Node2Str(val.asNode());
                    i = j;
                }
                if (varData != null) {
                    buf.append(varData);
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    private String getVosQuery() {
        StringBuilder sb = new StringBuilder("sparql\n ");
        this.graph.appendSparqlPrefixes(sb, true);
        if (!this.graph.getReadFromAllGraphs()) {
            sb.append(" define input:default-graph-uri <" + this.graph.getGraphName() + "> \n");
        }
        sb.append(this.substBindings(this.virt_query));
        return sb.toString();
    }

    public class VResultSet
    implements ResultSet {
        Statement stmt;
        ResultSetMetaData rsmd;
        java.sql.ResultSet rs;
        boolean v_finished = false;
        boolean v_prefetched = false;
        VirtModel m;
        BindingMap v_row;
        List<String> resVars = new LinkedList<String>();
        int row_id = 0;

        protected VResultSet(VirtGraph _g, Statement _stmt, java.sql.ResultSet _rs) {
            this.stmt = _stmt;
            this.rs = _rs;
            this.m = new VirtModel(_g);
            try {
                this.rsmd = this.rs.getMetaData();
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    this.resVars.add(this.rsmd.getColumnLabel(i));
                }
                if (VirtuosoQueryExecution.this.virt_graph != null && !VirtuosoQueryExecution.this.virt_graph.equals("virt:DEFAULT")) {
                    this.resVars.add("graph");
                }
            }
            catch (Exception e) {
                throw new JenaException("ViruosoResultBindingsToJenaResults has FAILED.:" + e);
            }
        }

        public boolean hasNext() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            return !this.v_finished;
        }

        public QuerySolution next() {
            Binding binding = this.nextBinding();
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return new ResultBinding((Model)this.m, binding);
        }

        public QuerySolution nextSolution() {
            return this.next();
        }

        public Binding nextBinding() {
            if (!this.v_finished && !this.v_prefetched) {
                this.moveForward();
            }
            this.v_prefetched = false;
            if (this.v_finished) {
                throw new NoSuchElementException();
            }
            return this.v_row;
        }

        public int getRowNumber() {
            return this.row_id;
        }

        public List<String> getResultVars() {
            return this.resVars;
        }

        public Model getResourceModel() {
            return this.m;
        }

        protected void finalize() throws Throwable {
            if (!this.v_finished) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void moveForward() throws JenaException {
            try {
                if (!this.v_finished && this.rs.next()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw new JenaException("Convert results are FAILED.:" + e);
            }
        }

        protected void extractRow() throws Exception {
            this.v_row = BindingFactory.create();
            ++this.row_id;
            try {
                for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    Node n = VirtGraph.Object2Node(this.rs.getObject(i));
                    if (n == null) continue;
                    this.v_row.add(Var.alloc((String)this.rsmd.getColumnLabel(i)), n);
                }
                if (VirtuosoQueryExecution.this.virt_graph != null && !VirtuosoQueryExecution.this.virt_graph.equals("virt:DEFAULT")) {
                    this.v_row.add(Var.alloc((String)"graph"), NodeFactory.createURI((String)VirtuosoQueryExecution.this.virt_graph));
                }
            }
            catch (Exception e) {
                throw new JenaException("ViruosoResultBindingsToJenaResults has FAILED.:" + e);
            }
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException(this.getClass().getName() + ".remove");
        }

        public void close() {
            if (!this.v_finished) {
                if (this.rs != null) {
                    try {
                        this.rs.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.rs = null;
                }
                if (this.stmt != null) {
                    try {
                        this.stmt.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stmt = null;
                }
            }
            this.v_finished = true;
        }
    }
}

