/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import virtuoso.jena.driver.VirtGraph;

public class VirtResSetQIter
implements ClosableIterator<Quad> {
    protected Quad v_row;
    protected Triple v_in;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;
    protected Iterator<Node> v_gList = null;
    protected Node v_curGraph = null;
    protected ExtendedIterator<Triple> v_curTriples = null;

    public VirtResSetQIter() {
        this.v_finished = true;
    }

    public VirtResSetQIter(VirtGraph graph, Iterator<Node> graphList, Triple in) {
        this.v_in = in;
        this.v_graph = graph;
        this.v_gList = graphList;
        if (this.v_gList.hasNext()) {
            this.v_curGraph = this.v_gList.next();
            this.v_curTriples = this.v_graph.graphBaseFind(this.v_curGraph.toString(), this.v_in);
        }
    }

    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    public Quad next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.performDelete(this.v_row.getGraph().toString(), this.v_row.getSubject(), this.v_row.getPredicate(), this.v_row.getObject());
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_curTriples != null) {
                if (this.v_curTriples.hasNext()) {
                    this.extractRow();
                    this.v_prefetched = true;
                } else if (this.v_gList.hasNext()) {
                    do {
                        this.v_curTriples.close();
                        this.v_curGraph = this.v_gList.next();
                        this.v_curTriples = this.v_graph.graphBaseFind(this.v_curGraph.toString(), this.v_in);
                    } while (!this.v_curTriples.hasNext());
                    this.extractRow();
                    this.v_prefetched = true;
                } else {
                    this.close();
                }
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    protected void extractRow() throws Exception {
        Triple t = (Triple)this.v_curTriples.next();
        this.v_row = new Quad(this.v_curGraph, t.getSubject(), t.getPredicate(), t.getObject());
    }

    protected Quad getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished && this.v_curTriples != null) {
            try {
                this.v_curTriples.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.v_curTriples = null;
        }
        this.v_finished = true;
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_curTriples != null) {
            this.close();
        }
    }
}

