/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.ListIterator;
import openlink.util.Vector;
import openlink.util.VectorOfLong;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoParameterMetaData;
import virtuoso.jdbc3.VirtuosoResultSet;
import virtuoso.jdbc3.VirtuosoResultSetMetaData;
import virtuoso.jdbc3.VirtuosoXAConnection;

public class VirtuosoStatement
implements Statement {
    protected Vector parameters;
    protected Vector objparams;
    protected LinkedList batch;
    private int concurrency;
    protected int type;
    protected int exec_type = -1;
    private int fetchDirection = 1000;
    protected VirtuosoConnection connection;
    private int maxFieldSize;
    protected int prefetch = 100;
    private int maxRows;
    protected int txn_timeout;
    protected int rpc_timeout;
    protected String statid;
    protected String cursorName;
    protected volatile boolean close_flag = false;
    protected boolean wait_result = false;
    protected boolean result_opened = false;
    protected boolean sparql_executed = false;
    protected static int req_no;
    protected VirtuosoResultSet vresultSet;
    protected VirtuosoFuture future;
    protected VirtuosoResultSetMetaData metaData;
    protected boolean isCached = false;
    protected boolean closeOnCompletion = false;
    protected VirtuosoParameterMetaData paramsMetaData = null;

    VirtuosoStatement(VirtuosoConnection connection) throws VirtuosoException {
        this.connection = connection;
        this.type = 1003;
        this.concurrency = 1007;
        this.rpc_timeout = connection.timeout;
        this.txn_timeout = connection.txn_timeout;
        this.prefetch = connection.fbs;
    }

    VirtuosoStatement(VirtuosoConnection connection, int type, int concurrency) throws VirtuosoException {
        this.connection = connection;
        if (type != 1003 && type != 1005 && type != 1004) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.type = type;
        if (concurrency != 1007 && concurrency != 1008 && concurrency != 1009) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.concurrency = concurrency;
        this.rpc_timeout = connection.timeout;
        this.txn_timeout = connection.txn_timeout;
        this.prefetch = connection.fbs;
    }

    protected VectorOfLong getStmtOpts() throws VirtuosoException {
        Object[] arrLong = new Long[11];
        arrLong[0] = this.connection.isReadOnly() ? new Long(3L) : (this.concurrency == 1009 ? new Long(4L) : new Long(this.concurrency == 1007 ? 1L : 2L));
        arrLong[1] = new Long(0L);
        arrLong[2] = new Long(this.maxRows);
        if (this.connection.getGlobalTransaction()) {
            VirtuosoXAConnection xac = this.connection.xa_connection;
            if (VirtuosoFuture.rpc_log != null) {
                VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts () xa_res=" + xac.getVirtuosoXAResource().hashCode() + " :" + this.hashCode());
            }
            arrLong[3] = new Long(xac.getVirtuosoXAResource().txn_timeout * 1000);
        } else {
            arrLong[3] = new Long(this.txn_timeout * 1000);
        }
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoStatement.getStmtOpts (txn_timeout=" + arrLong[3] + ") (con=" + this.connection.hashCode() + ") :" + this.hashCode());
        }
        arrLong[4] = new Long(this.prefetch);
        arrLong[5] = new Long(this.connection.getAutoCommit() ? 1L : 0L);
        arrLong[6] = new Long(this.rpc_timeout);
        switch (this.type) {
            case 1003: {
                arrLong[7] = new Long(0L);
                break;
            }
            case 1005: {
                arrLong[7] = new Long(2L);
                break;
            }
            case 1004: {
                arrLong[7] = new Long(3L);
            }
        }
        arrLong[8] = new Long(0L);
        arrLong[9] = new Long(1L);
        arrLong[10] = new Long(this.connection.getTransactionIsolation());
        return new VectorOfLong(arrLong);
    }

    protected VirtuosoResultSet sendQuery(String sql) throws VirtuosoException {
        this.sparql_executed = sql.trim().regionMatches(true, 0, "sparql", 0, 6);
        try {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                if (this.close_flag) {
                    throw new VirtuosoException("Statement is already closed", -13);
                }
                Object[] args = new Object[6];
                Vector vect = new Vector(1);
                if (this.future != null) {
                    this.close();
                    this.close_flag = false;
                } else {
                    this.cancel_rs();
                }
                args[0] = this.statid == null ? (this.statid = new String("s" + this.connection.hashCode() + req_no++)) : this.statid;
                args[2] = this.cursorName == null ? args[0] : this.cursorName;
                args[1] = this.connection.escapeSQL(sql);
                args[3] = vect;
                args[4] = null;
                try {
                    vect.addElement(new Vector(0));
                    args[5] = this.getStmtOpts();
                    this.future = this.connection.getFuture("EXEC", args, this.rpc_timeout);
                    this.result_opened = true;
                    return new VirtuosoResultSet(this, this.metaData, false);
                }
                catch (IOException e) {
                    throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
                }
            }
        }
        catch (Throwable e) {
            this.notify_error(e);
            return null;
        }
    }

    public void finalize() throws Throwable {
        this.close();
        if (this.metaData != null) {
            this.metaData.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws VirtuosoException {
        VirtuosoStatement virtuosoStatement = this;
        synchronized (virtuosoStatement) {
            if (this.future != null && this.wait_result) {
                this.future.sendCancelFuture();
            }
        }
        this.cancel_rs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel_rs() throws VirtuosoException {
        if (this.vresultSet != null) {
            this.vresultSet = null;
        }
        if (this.future != null) {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                this.connection.removeFuture(this.future);
            }
            this.future = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close_rs(boolean close_stmt) throws VirtuosoException {
        if (this.close_flag) {
            return;
        }
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            try {
                if (this.close_flag) {
                    return;
                }
                if (close_stmt) {
                    this.close_flag = true;
                }
                if (this.statid == null) {
                    return;
                }
                this.cancel_rs();
                if (!this.result_opened) {
                    return;
                }
                Object[] args = new Object[]{this.statid, new Long(1L)};
                this.future = this.connection.getFuture("FRST", args, this.rpc_timeout);
                this.future.nextResult();
                this.connection.removeFuture(this.future);
                this.future = null;
                this.result_opened = false;
            }
            catch (IOException e) {
                throw new VirtuosoException("Problem during closing : " + e.getMessage(), -3);
            }
        }
    }

    public void clearWarnings() throws VirtuosoException {
    }

    public void close() throws VirtuosoException {
        this.close_rs(true);
    }

    public boolean execute(String sql) throws VirtuosoException {
        this.exec_type = -1;
        this.vresultSet = this.sendQuery(sql);
        return this.vresultSet.kindop() != 0;
    }

    public ResultSet executeQuery(String sql) throws VirtuosoException {
        this.exec_type = 1;
        this.vresultSet = this.sendQuery(sql);
        return this.vresultSet;
    }

    public int executeUpdate(String sql) throws VirtuosoException {
        this.exec_type = 0;
        this.vresultSet = this.sendQuery(sql);
        return this.vresultSet.getUpdateCount();
    }

    public int getMaxFieldSize() throws VirtuosoException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws VirtuosoException {
        return this.maxRows;
    }

    public boolean getMoreResults() throws VirtuosoException {
        try {
            VirtuosoConnection virtuosoConnection = this.connection;
            synchronized (virtuosoConnection) {
                try {
                    if (this.vresultSet == null || this.vresultSet.isLastResult) {
                        if (this.vresultSet.isLastResult) {
                            this.vresultSet = null;
                        }
                        return false;
                    }
                    Object[] args = new Object[]{this.statid, new Long(this.future.hashCode())};
                    this.future.send_message("FTCH", args);
                    this.vresultSet.getMoreResults(false);
                    return true;
                }
                catch (IOException e) {
                    throw new VirtuosoException("Problem during serialization : " + e.getMessage(), -3);
                }
            }
        }
        catch (Throwable e) {
            this.notify_error(e);
            return false;
        }
    }

    public int getQueryTimeout() throws VirtuosoException {
        return this.rpc_timeout / 1000;
    }

    public ResultSet getResultSet() throws VirtuosoException {
        return this.vresultSet != null && this.vresultSet.kindop() != 0 ? this.vresultSet : null;
    }

    public int getUpdateCount() throws VirtuosoException {
        if (this.vresultSet != null) {
            switch (this.vresultSet.kindop()) {
                case 0: 
                case 2: {
                    return this.vresultSet.getUpdateCount();
                }
            }
            return -1;
        }
        return -1;
    }

    public SQLWarning getWarnings() throws VirtuosoException {
        return null;
    }

    public void setMaxFieldSize(int max) throws VirtuosoException {
        if (max < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws VirtuosoException {
        if (max < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.maxRows = max;
    }

    public void setQueryTimeout(int seconds) throws VirtuosoException {
        if (seconds < 0) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.rpc_timeout = seconds * 1000;
    }

    public Connection getConnection() throws VirtuosoException {
        return this.connection;
    }

    public int getFetchDirection() throws VirtuosoException {
        return this.fetchDirection;
    }

    public int getFetchSize() throws VirtuosoException {
        return this.prefetch;
    }

    public int getResultSetConcurrency() throws VirtuosoException {
        return this.concurrency;
    }

    public int getResultSetType() throws VirtuosoException {
        return this.type;
    }

    public void setFetchDirection(int direction) throws VirtuosoException {
        if (direction != 1000 && direction != 1001 && direction != 1002) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.fetchDirection = direction;
    }

    public void setFetchSize(int rows) throws VirtuosoException {
        if (rows < 0 || this.maxRows > 0 && rows > this.maxRows) {
            throw new VirtuosoException("Bad parameters.", -4);
        }
        this.prefetch = rows == 0 ? 100 : rows;
    }

    public void setCursorName(String name) throws VirtuosoException {
        this.cursorName = name;
    }

    public void addBatch(String sql) throws VirtuosoException {
        if (sql == null) {
            return;
        }
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(sql);
    }

    public void clearBatch() throws VirtuosoException {
        if (this.batch != null) {
            this.batch.clear();
        }
    }

    public int[] executeBatch() throws BatchUpdateException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] result = new int[this.batch.size()];
        int[] outres = null;
        int outcount = 0;
        boolean error = false;
        VirtuosoException ex = null;
        int i = 0;
        ListIterator it = this.batch.listIterator();
        while (it.hasNext()) {
            try {
                String stmt = (String)it.next();
                VirtuosoResultSet rset = this.sendQuery(stmt);
                result[i] = rset.getUpdateCount();
                if (rset.kindop() == 1) {
                    error = true;
                    break;
                }
            }
            catch (VirtuosoException e) {
                error = true;
                result[i] = -3;
                ex = e;
            }
            ++outcount;
            ++i;
        }
        this.batch.clear();
        if (error) {
            outres = new int[outcount];
            for (i = 0; i < outcount; ++i) {
                outres[i] = result[i];
            }
            if (ex != null) {
                throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), outres);
            }
            throw new BatchUpdateException(outres);
        }
        return result;
    }

    public void setEscapeProcessing(boolean enable) throws VirtuosoException {
    }

    public int getExecType() {
        return this.exec_type;
    }

    public boolean isClosed() {
        return this.close_flag;
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (current == 2) {
            throw new VirtuosoException("Keeping the current result open not supported", "IM001", -7);
        }
        return this.getMoreResults();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return new VirtuosoResultSet(this.connection);
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql);
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    protected void notify_error(Throwable e) throws VirtuosoException {
        VirtuosoConnection c = this.connection;
        if (c != null) {
            throw c.notify_error(e);
        }
        VirtuosoException ve = new VirtuosoException(e.getMessage(), -3);
        ve.initCause(e);
        throw ve;
    }
}

