/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.sql.ResultSetMetaData;
import java.util.Hashtable;
import openlink.util.Vector;
import virtuoso.jdbc3.VirtuosoColumn;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;

public class VirtuosoResultSetMetaData
implements ResultSetMetaData {
    protected Hashtable hcolumns;
    private Vector columnsMetaData = new Vector(10, 20);

    protected VirtuosoResultSetMetaData(VirtuosoConnection conn, String[] columns, int[] dtps) {
        this.hcolumns = new Hashtable();
        for (int i = 0; i < columns.length; ++i) {
            VirtuosoColumn col = new VirtuosoColumn(columns[i], dtps[i], conn);
            this.hcolumns.put(col, new Integer(i));
            this.columnsMetaData.insertElementAt(col, i);
        }
    }

    VirtuosoResultSetMetaData(Vector args, VirtuosoConnection conn) throws VirtuosoException {
        if (args == null) {
            return;
        }
        Object v = args.firstElement();
        Vector vect = null;
        if (!(v instanceof Vector)) {
            return;
        }
        vect = (Vector)v;
        this.hcolumns = new Hashtable();
        for (int i = 0; i < vect.size(); ++i) {
            VirtuosoColumn col = new VirtuosoColumn((Vector)vect.elementAt(i), conn);
            this.hcolumns.put(col, new Integer(i));
            this.columnsMetaData.insertElementAt(col, i);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public int getColumnCount() throws VirtuosoException {
        return this.columnsMetaData.size();
    }

    public boolean isAutoIncrement(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isAutoIncrement();
    }

    public boolean isCaseSensitive(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isCaseSensitive();
    }

    public boolean isSearchable(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isSearchable();
    }

    public boolean isCurrency(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isCurrency();
    }

    public int isNullable(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isNullable();
    }

    public boolean isSigned(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isSigned();
    }

    public int getColumnDisplaySize(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getColumnDisplaySize();
    }

    public String getColumnLabel(int column) throws VirtuosoException {
        return this.getColumnName(column);
    }

    public String getColumnName(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getColumnName();
    }

    public void setColumnName(int column, String name) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).setColumnName(name);
    }

    public int getPrecision(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getPrecision();
    }

    public int getScale(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getScale();
    }

    public int getColumnType(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getColumnType();
    }

    public String getColumnTypeName(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        VirtuosoColumn c = (VirtuosoColumn)this.columnsMetaData.elementAt(column - 1);
        if (c.isXml()) {
            return "XMLType";
        }
        return VirtuosoResultSetMetaData._getColumnTypeName(this.getColumnType(column));
    }

    protected static String _getColumnTypeName(int columnType) throws VirtuosoException {
        switch (columnType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -4: {
                return "LONG VARBINARY";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONG NVARCHAR";
            }
        }
        return "";
    }

    public boolean isReadOnly(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return !((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isUpdateable();
    }

    public boolean isWritable(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isUpdateable();
    }

    public boolean isDefinitelyWritable(int column) throws VirtuosoException {
        return this.isWritable(column);
    }

    public String getColumnClassName(int column) throws VirtuosoException {
        if (column < 1 || column > this.columnsMetaData.size()) {
            throw new VirtuosoException("Bad column number : " + column + " not in 1<n<" + this.columnsMetaData.size(), -4);
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getColumnClassName();
    }

    public String getSchemaName(int column) throws VirtuosoException {
        return "";
    }

    public String getTableName(int column) throws VirtuosoException {
        return "";
    }

    public String getCatalogName(int column) throws VirtuosoException {
        return "";
    }

    public void close() throws VirtuosoException {
        if (this.hcolumns != null) {
            this.hcolumns.clear();
            this.hcolumns = null;
        }
        if (this.columnsMetaData != null) {
            this.columnsMetaData.removeAllElements();
            this.columnsMetaData = null;
        }
    }

    protected int getColumnDtp(int column) {
        if (column < 1 || column > this.columnsMetaData.size()) {
            return 0;
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).getDtp();
    }

    protected boolean isXml(int column) {
        if (column < 1 || column > this.columnsMetaData.size()) {
            return false;
        }
        return ((VirtuosoColumn)this.columnsMetaData.elementAt(column - 1)).isXml();
    }
}

