/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import openlink.util.Vector;
import virtuoso.jdbc3.VirtuosoBlobStream;
import virtuoso.jdbc3.VirtuosoClobStream;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoFuture;

public class VirtuosoBlob
implements Blob,
Clob {
    private boolean request = true;
    private long length;
    private long bh_page;
    private long ask;
    private long bh_current_page;
    private long bh_start_offset;
    private long bh_position;
    private byte[] buffer;
    private Reader rd;
    private InputStream is;
    private VirtuosoConnection connection;
    protected int dtp;
    protected long key_id = 0L;
    protected long frag_no = 0L;
    protected long dir_page = 0L;
    protected long bh_timestamp = 0L;
    protected Object pages = null;

    VirtuosoBlob(InputStream is, long length, long index) throws VirtuosoException {
        this.is = is;
        this.bh_page = index;
        this.length = length;
        this.rewind();
    }

    private void rewind() {
        this.bh_current_page = this.bh_page;
        this.bh_start_offset = 0L;
        this.bh_position = 0L;
    }

    private long bh_offset() {
        return this.bh_start_offset;
    }

    VirtuosoBlob(byte[] array) throws VirtuosoException {
        this.buffer = array;
        this.request = false;
        this.length = array.length;
    }

    VirtuosoBlob() throws VirtuosoException {
    }

    VirtuosoBlob(Object obj, long index) throws VirtuosoException {
    }

    VirtuosoBlob(Reader rd, long length, long index) throws VirtuosoException {
        this.rd = rd;
        this.length = length;
        this.bh_page = index;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection connection, long ask, long index, long length) throws VirtuosoException {
        this.connection = connection;
        this.ask = ask;
        this.bh_page = index;
        this.length = length;
        this.dtp = 126;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection connection, long ask, long index, long length, long __key_id, long __frag_no, long __dir_page, long __timestamp, Object __pages, int dtp) throws VirtuosoException {
        this.connection = connection;
        this.ask = ask;
        this.bh_page = index;
        this.length = length;
        this.dtp = dtp;
        this.key_id = __key_id;
        this.frag_no = __frag_no;
        this.dir_page = __dir_page;
        this.bh_timestamp = __timestamp;
        this.pages = __pages;
        this.rewind();
    }

    protected void setInputStream(InputStream is, long length) {
        this.is = is;
        this.length = length;
    }

    protected void setReader(Reader rd, long length) {
        this.rd = rd;
        this.length = length;
    }

    protected void setObject(Object obj) {
    }

    private void checkBlobError(Vector curr) throws VirtuosoException {
        if (curr.firstElement() instanceof Long && ((Number)curr.firstElement()).longValue() == 3L) {
            throw new VirtuosoException(curr.elementAt(2).toString(), curr.elementAt(1).toString(), -8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long pos, int length) throws VirtuosoException {
        if (pos <= 0L) {
            throw new VirtuosoException("Invalid param to the getBytes", "22023", -4);
        }
        if (!this.request) {
            if (--pos > (long)this.buffer.length || pos + (long)length > (long)this.buffer.length) {
                return null;
            }
            byte[] array = new byte[length];
            System.arraycopy(this.buffer, (int)pos, array, 0, length);
            return array;
        }
        try {
            Object val;
            if (pos < 0L || length <= 0 || pos + (long)length - 1L > this.length) {
                return null;
            }
            Long init_read_len = null;
            if (pos - 1L < this.bh_offset()) {
                this.rewind();
            }
            if (pos - 1L > this.bh_offset()) {
                init_read_len = new Long(pos - this.bh_offset() - 1L);
            }
            if (init_read_len != null) {
                Vector curr = null;
                VirtuosoConnection virtuosoConnection = this.connection;
                synchronized (virtuosoConnection) {
                    Object[] args = new Object[]{new Long(this.bh_current_page), init_read_len, new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                    VirtuosoFuture future = this.connection.getFuture("GETDA", args, -1);
                    curr = future.nextResult();
                    curr = (Vector)curr.firstElement();
                    this.connection.removeFuture(future);
                }
                if (!(curr instanceof Vector)) {
                    return null;
                }
                this.checkBlobError(curr);
                for (int inx = 0; inx < curr.size(); ++inx) {
                    val = curr.elementAt(inx);
                    if (val instanceof Vector) {
                        Vector vval = (Vector)val;
                        this.bh_current_page = ((Number)vval.elementAt(1)).longValue();
                        this.bh_position = ((Number)vval.elementAt(2)).longValue();
                        break;
                    }
                    if (!(val instanceof String)) continue;
                    String sval = (String)val;
                    if (this.dtp == 133) {
                        this.bh_start_offset += (long)sval.length();
                        continue;
                    }
                    this.bh_start_offset += (long)sval.getBytes("8859_1").length;
                }
            }
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            Vector curr = null;
            val = this.connection;
            synchronized (val) {
                Object[] args = new Object[]{new Long(this.bh_current_page), new Long(length), new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                VirtuosoFuture future = this.connection.getFuture("GETDA", args, -1);
                curr = future.nextResult();
                curr = (Vector)curr.firstElement();
                this.connection.removeFuture(future);
            }
            if (!(curr instanceof Vector)) {
                return null;
            }
            this.checkBlobError(curr);
            for (int inx = 0; inx < curr.size(); ++inx) {
                Object val2 = curr.elementAt(inx);
                if (val2 instanceof Vector) {
                    Vector vval = (Vector)val2;
                    this.bh_current_page = ((Number)vval.elementAt(1)).longValue();
                    this.bh_position = ((Number)vval.elementAt(2)).longValue();
                    continue;
                }
                if (!(val2 instanceof String)) continue;
                String sval = (String)val2;
                bo.write(sval.getBytes("8859_1"));
                this.bh_start_offset += (long)sval.getBytes("8859_1").length;
            }
            byte[] ret = bo.toByteArray();
            return ret;
        }
        catch (IOException e) {
            throw new VirtuosoException("I/O error occurred : " + e.getMessage(), -3);
        }
    }

    public String getSubString(long pos, int length) throws VirtuosoException {
        byte[] bytes = this.getBytes(pos, length);
        if (this.dtp == 133) {
            try {
                return new String(bytes, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new VirtuosoException("UTF8 not supported in getSubString", -17);
            }
        }
        try {
            return new String(bytes, "8859_1");
        }
        catch (Exception e) {
            throw new VirtuosoException("8859-1 not supported in getSubString", -17);
        }
    }

    public long length() throws VirtuosoException {
        return this.length;
    }

    public InputStream getBinaryStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoBlobStream(this);
    }

    public Reader getCharacterStream() throws VirtuosoException {
        if (this.rd != null) {
            return this.rd;
        }
        if (this.buffer != null) {
            return new StringReader(new String(this.buffer));
        }
        try {
            switch (this.dtp) {
                case 132: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "UTF8");
                }
                case 131: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "8859_1");
                }
            }
            return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), this.connection.charset != null ? this.connection.charset : "8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new VirtuosoException("Unsupported charset encoding : " + e.getMessage(), -10);
        }
    }

    public InputStream getAsciiStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoClobStream(this);
    }

    public long position(byte[] pattern, long start) throws VirtuosoException {
        if (!this.request) {
            int i;
            if (start >= (long)this.buffer.length || start + (long)pattern.length >= (long)this.buffer.length) {
                return -1L;
            }
            boolean found = true;
            for (i = (int)start - 1; i < this.buffer.length && found; found &= this.buffer[i] == pattern[i], ++i) {
            }
            if (found) {
                return i;
            }
            return -1L;
        }
        try {
            VirtuosoBlobStream is = (VirtuosoBlobStream)this.getBinaryStream();
            is.skip(start - 1L);
            byte[] _array = new byte[pattern.length];
            while (is.available() > _array.length) {
                if (is.read(_array, 0, _array.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                boolean found = true;
                for (int i = 0; i < _array.length && found; found &= _array[i] == pattern[i], ++i) {
                }
                if (!found) continue;
                return is.pos;
            }
            return -1L;
        }
        catch (IOException e) {
            throw new VirtuosoException("I/O error occurred : " + e.getMessage(), -3);
        }
    }

    public long position(Blob pattern, long start) throws VirtuosoException {
        try {
            VirtuosoBlobStream is = (VirtuosoBlobStream)pattern.getBinaryStream();
            is.skip(start - 1L);
            byte[] _array = new byte[8192];
            while (is.available() > 8192) {
                if (is.read(_array, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long posi = this.position(_array, start += 8192L);
                if (posi == -1L) continue;
                return posi;
            }
            return -1L;
        }
        catch (IOException e) {
            throw new VirtuosoException("I/O error occurred : " + e.getMessage(), -3);
        }
        catch (SQLException e) {
            throw new VirtuosoException("SQL error occurred : " + e.getMessage(), -8);
        }
    }

    public long position(String searchstr, long start) throws VirtuosoException {
        try {
            VirtuosoClobStream is = (VirtuosoClobStream)this.getAsciiStream();
            is.skip(start - 1L);
            byte[] _array = new byte[searchstr.length()];
            while (is.available() > _array.length) {
                if (is.read(_array, 0, _array.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                if (!searchstr.equals(new String(_array))) continue;
                return is.pos;
            }
            return -1L;
        }
        catch (IOException e) {
            throw new VirtuosoException("I/O error occurred : " + e.getMessage(), -3);
        }
    }

    public long position(Clob searchstr, long start) throws VirtuosoException {
        try {
            VirtuosoClobStream is = (VirtuosoClobStream)searchstr.getAsciiStream();
            is.skip(start - 1L);
            byte[] _array = new byte[8192];
            while (is.available() > 8192) {
                if (is.read(_array, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long posi = this.position(new String(_array), start += 8192L);
                if (posi == -1L) continue;
                return posi;
            }
            return -1L;
        }
        catch (IOException e) {
            throw new VirtuosoException("I/O error occurred : " + e.getMessage(), -3);
        }
        catch (SQLException e) {
            throw new VirtuosoException("SQL error occurred : " + e.getMessage(), -8);
        }
    }

    public int hashCode() {
        return (int)this.bh_page;
    }

    public String toString() {
        return "Blob " + this.length + "b";
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public int setString(long pos, String str) throws SQLException {
        return this.setString(pos, str, 0, str.length());
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public void truncate(long len) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public void free() throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public Reader getCharacterStream(long pos, long len) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }
}

