/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExplicitString;
import virtuoso.jdbc4.VirtuosoFuture;
import virtuoso.jdbc4.VirtuosoPooledConnection;
import virtuoso.jdbc4.VirtuosoXid;
import virtuoso.jdbc4.XAResourceManager;
import virtuoso.jdbc4.XATransaction;

public class VirtuosoXAResource
implements XAResource {
    private static final int SQL_XA_ENLIST = 246;
    private static final int SQL_XA_PREPARE = 3841;
    private static final int SQL_XA_COMMIT = 3842;
    private static final int SQL_XA_ROLLBACK = 3843;
    private static final int SQL_XA_END = 3844;
    private static final int SQL_XA_JOIN = 3845;
    private static final int SQL_XA_RESUME = 3846;
    private static final int SQL_XA_SUSPEND = 3847;
    private static final int SQL_XA_WAIT = 3840;
    private final String GET_ALL_XIDS = "_2PC.DBA.XA_GET_ALL_XIDS()";
    private VirtuosoPooledConnection vConnection;
    private XAResourceManager manager;
    int txn_timeout = 0;
    private boolean stored_auto_commit;
    private Xid r_currentXid = null;

    VirtuosoXAResource(VirtuosoPooledConnection vConnection, String server, int port) {
        this.vConnection = vConnection;
        this.manager = XAResourceManager.getManager(server, port);
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("new VirtuosoXAResource (+ con=" + vConnection.hashCode() + ") :" + this.hashCode() + ")");
        }
    }

    void reset_XA() {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.reset_XA () :" + this.hashCode());
        }
        if (this.vConnection == null) {
            return;
        }
        if (this.r_currentXid != null) {
            try {
                this.end(this.r_currentXid, 0x20000000);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.vConnection = null;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.getTransactionTimeout () ret " + this.txn_timeout + " :" + this.hashCode() + ")");
        }
        return this.txn_timeout;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.setTransactionTimeout (" + seconds + ") :" + this.hashCode() + ")");
        }
        if (seconds < 0) {
            XAException xaex = new XAException("Invalid number of seconds : " + seconds);
            xaex.errorCode = -5;
            throw xaex;
        }
        if (seconds == 0) {
            try {
                this.txn_timeout = this.vConnection.getVirtuosoConnection().getTimeout();
            }
            catch (SQLException ex) {
                throw new XAException(ex.toString());
            }
        } else {
            this.txn_timeout = seconds;
        }
        return true;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        boolean ret;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.isSameRM (res=" + xaResource.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (xaResource == null || !(xaResource instanceof VirtuosoXAResource)) {
            ret = false;
        } else if (xaResource.equals(this)) {
            ret = true;
        } else {
            VirtuosoXAResource that = (VirtuosoXAResource)xaResource;
            ret = this.manager == that.manager;
        }
        return ret;
    }

    @Override
    public void start(Xid xid, int param) throws XAException {
        VirtuosoConnection con;
        int start_param;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.start (xid=" + xid.hashCode() + ", param=" + param + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        if (param != 0 && param != 0x200000 && param != 0x8000000) {
            throw new XAException(-5);
        }
        XATransaction transaction = null;
        if (param == 0x200000) {
            transaction = this.manager.getTransaction(xid);
            if (transaction.getStatus() != 1 && transaction.getStatus() != 2) {
                throw new XAException(-6);
            }
            start_param = 3845;
        } else if (param == 0) {
            transaction = this.manager.createTransaction(xid, 1);
            start_param = 246;
        } else if (param == 0x8000000) {
            transaction = this.manager.getTransaction(xid);
            if (transaction.getStatus() != 1) {
                throw new XAException(-6);
            }
            start_param = 3846;
        } else {
            throw new XAException("Unsupported mode");
        }
        try {
            con = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException ex) {
            throw new XAException(ex.toString());
        }
        this.enterGlobalTransaction(con);
        try {
            this.rpc(con, start_param, transaction.getXid().encode());
        }
        catch (XAException ex) {
            this.leaveGlobalTransaction(con);
            throw ex;
        }
        this.r_currentXid = xid;
    }

    @Override
    public void end(Xid xid, int param) throws XAException {
        VirtuosoConnection con;
        int end_param;
        int nstatus = 2;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.end (xid=" + xid.hashCode() + ", param=" + param + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        XATransaction ctx = this.manager.getTransaction(xid);
        if ((param & 0x2000000) != 0) {
            end_param = 3847;
            nstatus = 1;
        } else if (param == 0x4000000) {
            end_param = 3844;
        } else if (param == 0x20000000) {
            end_param = 3844;
            nstatus = 6;
        } else {
            throw new XAException("Invalid flag.");
        }
        ctx.checkNewStatus(nstatus);
        try {
            con = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException ex) {
            throw new XAException(ex.toString());
        }
        this.rpc(con, end_param, ctx.getXid().encode());
        this.leaveGlobalTransaction(con);
        ctx.changeStatus(nstatus);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        VirtuosoConnection con;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.prepare (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        XATransaction ctx = this.manager.getTransaction(xid);
        ctx.checkNewStatus(3);
        try {
            con = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException ex) {
            throw new XAException(ex.toString());
        }
        this.rpc(con, 3841, ctx.getXid().encode());
        ctx.changeStatus(3);
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.commit (xid=" + xid.hashCode() + ", onePhase=" + onePhase + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        XATransaction ctx = this.manager.getTransaction(xid);
        ctx.checkNewStatus(4, onePhase);
        this.transact(ctx, 3842);
        ctx.changeStatus(4, onePhase);
        this.manager.removeTransaction(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.rollback (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        XATransaction ctx = this.manager.getTransaction(xid);
        ctx.checkNewStatus(5);
        this.transact(ctx, 3843);
        ctx.changeStatus(5);
        this.manager.removeTransaction(xid);
    }

    @Override
    public Xid[] recover(int param) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.recover (param=" + param + ") :" + this.hashCode() + ")");
        }
        if (param != 0x1000000) {
            return new Xid[0];
        }
        java.util.Vector<VirtuosoXid> xidv = new java.util.Vector<VirtuosoXid>();
        try {
            VirtuosoConnection con = this.vConnection.getVirtuosoConnection();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("_2PC.DBA.XA_GET_ALL_XIDS()");
            while (rs.next()) {
                String s = rs.getString(1);
                VirtuosoXid xid = VirtuosoXid.decode(s);
                xidv.add(xid);
                this.manager.createTransaction(xid, 3);
            }
        }
        catch (SQLException e) {
            throw new XAException(e.toString());
        }
        Xid[] xids = new Xid[xidv.size()];
        for (int i = 0; i < xids.length; ++i) {
            xids[i] = (Xid)xidv.get(i);
        }
        return xids;
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.forget (xid=" + xid.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (xid == null) {
            throw new XAException(-5);
        }
        this.manager.removeTransaction(xid);
    }

    private void enterGlobalTransaction(VirtuosoConnection connection) {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.enterGlobalTransaction (conn=" + connection.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (connection == null) {
            return;
        }
        try {
            this.stored_auto_commit = connection.getAutoCommit();
            connection.setAutoCommit(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connection.setGlobalTransaction(true);
    }

    private void leaveGlobalTransaction(VirtuosoConnection connection) {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("VirtuosoXAResource.leaveGlobalTransaction (conn=" + connection.hashCode() + ") :" + this.hashCode() + ")");
        }
        if (connection == null) {
            return;
        }
        connection.setGlobalTransaction(false);
        try {
            connection.setAutoCommit(this.stored_auto_commit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.r_currentXid = null;
    }

    private void transact(XATransaction ctx, int action) throws XAException {
        VirtuosoConnection con;
        VirtuosoExplicitString encodedXid = ctx.getXid().encode();
        try {
            con = this.vConnection.getVirtuosoConnection();
        }
        catch (SQLException ex) {
            throw new XAException(ex.toString());
        }
        this.rpc(con, action, encodedXid);
        this.rpc(con, 3840, encodedXid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rpc(VirtuosoConnection connection, int action, Object encodedXid) throws XAException {
        Object[] args = new Object[]{new Integer(action), encodedXid};
        try {
            VirtuosoConnection virtuosoConnection = connection;
            synchronized (virtuosoConnection) {
                Object err;
                VirtuosoFuture future = connection.getFuture("TPTRX", args, connection.timeout);
                Vector res = future.nextResult();
                Object object = err = res == null ? null : res.firstElement();
                if (err instanceof Vector) {
                    throw new XAException();
                }
                connection.removeFuture(future);
            }
        }
        catch (IOException ex) {
            throw new XAException(-3);
        }
        catch (VirtuosoException ex) {
            throw new XAException(ex.toString());
        }
    }
}

