/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import virtuoso.jena.driver.VirtGraph;

public class VirtResSetIter2
implements Iterator<Triple> {
    protected Statement v_stmt;
    protected ResultSet v_resultSet;
    protected Triple v_row;
    protected boolean v_finished = false;
    protected boolean v_prefetched = false;
    protected VirtGraph v_graph = null;

    public VirtResSetIter2() {
        this.v_finished = true;
    }

    public VirtResSetIter2(VirtGraph graph, Statement stmt, ResultSet resultSet) {
        this.v_stmt = stmt;
        this.v_resultSet = resultSet;
        this.v_graph = graph;
    }

    @Override
    public boolean hasNext() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        return !this.v_finished;
    }

    @Override
    public Triple next() {
        if (!this.v_finished && !this.v_prefetched) {
            this.moveForward();
        }
        this.v_prefetched = false;
        if (this.v_finished) {
            throw new NoSuchElementException();
        }
        return this.getRow();
    }

    @Override
    public void remove() {
        if (this.v_row != null && this.v_graph != null) {
            this.v_graph.delete(this.v_row);
            this.v_row = null;
        }
    }

    protected void moveForward() {
        try {
            if (!this.v_finished && this.v_resultSet.next()) {
                this.extractRow();
                this.v_prefetched = true;
            } else {
                this.close();
            }
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
    }

    protected void extractRow() throws Exception {
        Node NodeS = VirtGraph.Object2Node(this.v_resultSet.getObject(1));
        Node NodeP = VirtGraph.Object2Node(this.v_resultSet.getObject(2));
        Node NodeO = VirtGraph.Object2Node(this.v_resultSet.getObject(3));
        this.v_row = new Triple(NodeS, NodeP, NodeO);
    }

    protected Triple getRow() {
        return this.v_row;
    }

    public void close() {
        if (!this.v_finished) {
            if (this.v_resultSet != null) {
                try {
                    this.v_resultSet.close();
                    this.v_resultSet = null;
                }
                catch (SQLException e) {
                    throw new JenaException((Throwable)e);
                }
            }
            if (this.v_stmt != null) {
                try {
                    this.v_stmt.close();
                    this.v_stmt = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.v_finished = true;
    }

    protected void finalize() throws SQLException {
        if (!this.v_finished && this.v_resultSet != null) {
            this.close();
        }
    }
}

