/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoNullParameter;
import virtuoso.jdbc3.VirtuosoPreparedStatement;
import virtuoso.jdbc3.VirtuosoTypes;

public class VirtuosoCallableStatement
extends VirtuosoPreparedStatement
implements CallableStatement {
    private boolean _wasNull = false;
    private boolean _hasOut = false;
    protected int[] param_type = new int[this.parameters.capacity()];
    protected int[] param_scale = new int[this.parameters.capacity()];

    VirtuosoCallableStatement(VirtuosoConnection connection, String sql) throws VirtuosoException {
        this(connection, sql, 1003, 1007);
    }

    VirtuosoCallableStatement(VirtuosoConnection connection, String sql, int type, int concurrency) throws VirtuosoException {
        super(connection, sql, type, concurrency);
        for (int i = 0; i < this.param_type.length; ++i) {
            this.param_type[i] = 1111;
            this.param_scale[i] = 0;
        }
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws VirtuosoException {
        this.registerOutParameter(parameterIndex, sqlType, 0);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws VirtuosoException {
        this._hasOut = true;
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.param_type[parameterIndex - 1] = sqlType;
        this.param_scale[parameterIndex - 1] = scale;
        switch (sqlType) {
            case 2002: 
            case 2003: {
                return;
            }
            case -5: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Long(Long.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                return;
            }
            case -7: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Boolean(false), parameterIndex - 1);
                }
                return;
            }
            case 2004: 
            case 2005: {
                return;
            }
            case -1: 
            case 1: 
            case 12: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new String(), parameterIndex - 1);
                }
                return;
            }
            case 91: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Date(0L), parameterIndex - 1);
                }
                return;
            }
            case 92: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Time(0L), parameterIndex - 1);
                }
                return;
            }
            case 93: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Timestamp(0L), parameterIndex - 1);
                }
                return;
            }
            case 2: 
            case 3: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new BigDecimal(0.0).setScale(scale), parameterIndex - 1);
                }
                return;
            }
            case 6: 
            case 8: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Double(Double.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case 1111: 
            case 2000: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Object(), parameterIndex - 1);
                }
                return;
            }
            case 0: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new VirtuosoNullParameter(sqlType, true), parameterIndex - 1);
                }
                return;
            }
            case 7: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Float(Float.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case 5: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Short(Short.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
            case -6: 
            case 4: {
                if (this.objparams.elementAt(parameterIndex - 1) == null) {
                    this.objparams.setElementAt(new Integer(Integer.MAX_VALUE), parameterIndex - 1);
                }
                return;
            }
        }
    }

    public boolean wasNull() throws VirtuosoException {
        return this._wasNull;
    }

    public boolean hasOut() {
        return this._hasOut;
    }

    public String getString(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return obj.toString();
    }

    public boolean getBoolean(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        boolean bl = this._wasNull = obj == null;
        if (this._wasNull) {
            return false;
        }
        Number nret = (Number)obj;
        return nret.intValue() != 0;
    }

    public byte getByte(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).byteValue();
    }

    public short getShort(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).shortValue();
    }

    public int getInt(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0;
        }
        return ((Number)obj).intValue();
    }

    public long getLong(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0L;
        }
        return ((Number)obj).longValue();
    }

    public float getFloat(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0.0f;
        }
        return ((Number)obj).floatValue();
    }

    public double getDouble(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return 0.0;
        }
        return ((Number)obj).doubleValue();
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws VirtuosoException {
        BigDecimal ret = this.getBigDecimal(parameterIndex);
        if (ret != null) {
            ret = ret.setScale(scale);
        }
        return ret;
    }

    public byte[] getBytes(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (byte[])obj;
    }

    public Date getDate(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 91, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Date)obj;
    }

    public Time getTime(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 92, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Time)obj;
    }

    public Timestamp getTimestamp(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 93, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (Timestamp)obj;
    }

    public Object getObject(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), this.param_type[parameterIndex - 1], this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        return obj;
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object obj = VirtuosoTypes.mapJavaTypeToSqlType(this.objparams.elementAt(parameterIndex - 1), 3, this.param_scale[parameterIndex - 1]);
        this._wasNull = obj == null;
        if (this._wasNull) {
            return null;
        }
        return (BigDecimal)obj;
    }

    public Object getObject(int parameterIndex, Map map) throws VirtuosoException {
        return this.getObject(parameterIndex);
    }

    public Ref getRef(int parameterIndex) throws VirtuosoException {
        throw new VirtuosoException("REF not supported", -7);
    }

    public Blob getBlob(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(parameterIndex - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Blob)this.objparams.elementAt(parameterIndex - 1);
    }

    public Clob getClob(int parameterIndex) throws VirtuosoException {
        if (parameterIndex < 1 || parameterIndex > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + parameterIndex + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this._wasNull = this.objparams.elementAt(parameterIndex - 1) == null;
        if (this._wasNull) {
            return null;
        }
        return (Clob)this.objparams.elementAt(parameterIndex - 1);
    }

    public Array getArray(int parameterIndex) throws VirtuosoException {
        throw new VirtuosoException("ARRAY not supported", -7);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws VirtuosoException {
        Date date = this.getDate(parameterIndex);
        if (cal != null && date != null) {
            date = new Date(VirtuosoTypes.timeToCal(date, cal));
        }
        return date;
    }

    public Time getTime(int parameterIndex, Calendar cal) throws VirtuosoException {
        Time _time = this.getTime(parameterIndex);
        if (cal != null && _time != null) {
            _time = new Time(VirtuosoTypes.timeToCal(_time, cal));
        }
        return _time;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Timestamp val;
        Timestamp _ts = val = this.getTimestamp(parameterIndex);
        if (cal != null && _ts != null) {
            _ts = new Timestamp(VirtuosoTypes.timeToCal(_ts, cal));
        }
        if (_ts != null) {
            _ts.setNanos(val.getNanos());
        }
        return _ts;
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws VirtuosoException {
        throw new VirtuosoException("UDTs not supported", -7);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setString(String parameterName, String x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public String getString(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public byte getByte(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public short getShort(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public int getInt(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public long getLong(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public float getFloat(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public double getDouble(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Date getDate(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Time getTime(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Object getObject(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Ref getRef(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Clob getClob(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Array getArray(String parameterName) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw new VirtuosoException("Named parameters not supported", -7);
    }

    public URL getURL(String parameterName) throws SQLException {
        throw new VirtuosoException("DATALINK type not supported", -7);
    }
}

