/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import virtuoso.jdbc3.Closeable;
import virtuoso.jdbc3.ConnectionWrapper;
import virtuoso.jdbc3.ResultSetWrapper;
import virtuoso.jdbc3.VirtuosoException;

public class StatementWrapper
implements Statement,
Closeable {
    protected Statement stmt;
    protected ConnectionWrapper wconn;
    protected HashMap objsToClose = new HashMap();
    protected volatile boolean isClosed = false;

    protected StatementWrapper(ConnectionWrapper _wconn, Statement _stmt) {
        this.wconn = _wconn;
        this.stmt = _stmt;
        this.addLink();
    }

    protected void exceptionOccurred(SQLException sqlEx) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sqlEx);
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    protected void addLink() {
        this.wconn.addObjToClose(this);
    }

    protected void removeLink() {
        this.wconn.removeObjFromClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        StatementWrapper statementWrapper = this;
        synchronized (statementWrapper) {
            try {
                this.removeLink();
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.wconn = null;
                if (this.objsToClose != null) {
                    this.objsToClose.clear();
                }
            }
            catch (SQLException ex) {
                this.exceptionOccurred(ex);
                throw ex;
            }
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.executeQuery(sql);
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxFieldSize();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.check_close();
        try {
            this.stmt.setMaxFieldSize(max);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getMaxRows() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMaxRows();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setMaxRows(int max) throws SQLException {
        this.check_close();
        try {
            this.stmt.setMaxRows(max);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.check_close();
        try {
            this.stmt.setEscapeProcessing(enable);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getQueryTimeout() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getQueryTimeout();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.check_close();
        try {
            this.stmt.setQueryTimeout(seconds);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void cancel() throws SQLException {
        this.check_close();
        try {
            this.stmt.cancel();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void clearWarnings() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearWarnings();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.check_close();
        try {
            this.stmt.setCursorName(name);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public boolean execute(String sql) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.getResultSet();
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getUpdateCount() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getUpdateCount();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.check_close();
        try {
            this.stmt.setFetchDirection(direction);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.check_close();
        try {
            this.stmt.setFetchSize(rows);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getFetchSize() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getFetchSize();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetConcurrency();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getResultSetType() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetType();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void addBatch(String sql) throws SQLException {
        this.check_close();
        try {
            this.stmt.addBatch(sql);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public void clearBatch() throws SQLException {
        this.check_close();
        try {
            this.stmt.clearBatch();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int[] executeBatch() throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeBatch();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public Connection getConnection() throws SQLException {
        this.check_close();
        return this.wconn;
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.check_close();
        try {
            return this.stmt.getMoreResults(current);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.check_close();
        try {
            ResultSet rs = this.stmt.getGeneratedKeys();
            if (rs != null) {
                return new ResultSetWrapper(this.wconn, this, rs);
            }
            return null;
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.check_close();
        try {
            return this.stmt.executeUpdate(sql, columnNames);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, columnIndexes);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.check_close();
        try {
            return this.stmt.execute(sql, columnNames);
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        this.check_close();
        try {
            return this.stmt.getResultSetHoldability();
        }
        catch (SQLException ex) {
            this.exceptionOccurred(ex);
            throw ex;
        }
    }

    protected synchronized void check_close() throws SQLException {
        if (this.isClosed) {
            throw new VirtuosoException("The statement is closed.", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObjToClose(Object obj) {
        HashMap hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.put(obj, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeObjFromClose(Object obj) {
        HashMap hashMap = this.objsToClose;
        synchronized (hashMap) {
            this.objsToClose.remove(obj);
        }
    }
}

