/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import virtuoso.jena.driver.VirtGraph;

public class VirtModel
extends ModelCom {
    private final Object lck_add = new Object();

    public VirtModel(VirtGraph base) {
        super((Graph)base);
    }

    public static VirtModel openDefaultModel(ConnectionPoolDataSource ds) {
        return new VirtModel(new VirtGraph(ds));
    }

    public static VirtModel openDatabaseModel(String graphName, ConnectionPoolDataSource ds) {
        return new VirtModel(new VirtGraph(graphName, ds));
    }

    public static VirtModel openDefaultModel(DataSource ds) {
        return new VirtModel(new VirtGraph(ds));
    }

    public static VirtModel openDatabaseModel(String graphName, DataSource ds) {
        return new VirtModel(new VirtGraph(graphName, ds));
    }

    public static VirtModel openDefaultModel(String url, String user, String password) {
        return new VirtModel(new VirtGraph(url, user, password));
    }

    public static VirtModel openDatabaseModel(String graphName, String url, String user, String password) {
        return new VirtModel(new VirtGraph(graphName, url, user, password));
    }

    public Model removeAll() {
        try {
            VirtGraph _graph = (VirtGraph)this.graph;
            _graph.clear();
        }
        catch (ClassCastException e) {
            super.removeAll();
        }
        return this;
    }

    public void createRuleSet(String ruleSetName, String uriGraphRuleSet) {
        ((VirtGraph)this.graph).createRuleSet(ruleSetName, uriGraphRuleSet);
    }

    public void removeRuleSet(String ruleSetName, String uriGraphRuleSet) {
        ((VirtGraph)this.graph).removeRuleSet(ruleSetName, uriGraphRuleSet);
    }

    public void setRuleSet(String _ruleSet) {
        ((VirtGraph)this.graph).setRuleSet(_ruleSet);
    }

    public void setSameAs(boolean _sameAs) {
        ((VirtGraph)this.graph).setSameAs(_sameAs);
    }

    public int getBatchSize() {
        return ((VirtGraph)this.graph).getBatchSize();
    }

    public void setBatchSize(int sz) {
        ((VirtGraph)this.graph).setBatchSize(sz);
    }

    public String getSparqlPrefix() {
        return ((VirtGraph)this.graph).getSparqlPrefix();
    }

    public void setSparqlPrefix(String val) {
        ((VirtGraph)this.graph).setSparqlPrefix(val);
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return ((VirtGraph)this.graph).getInsertBNodeAsVirtuosoIRI();
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        ((VirtGraph)this.graph).setInsertBNodeAsVirtuosoIRI(v);
    }

    public boolean getResetBNodesDictAfterCall() {
        return ((VirtGraph)this.graph).getResetBNodesDictAfterCall();
    }

    public void setResetBNodesDictAfterCall(boolean v) {
        ((VirtGraph)this.graph).setResetBNodesDictAfterCall(v);
    }

    public boolean getResetBNodesDictAfterCommit() {
        return ((VirtGraph)this.graph).getResetBNodesDictAfterCommit();
    }

    public void setResetBNodesDictAfterCommit(boolean v) {
        ((VirtGraph)this.graph).setResetBNodesDictAfterCommit(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(url);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(Reader reader, String base) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(reader, base);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(InputStream reader, String base) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(reader, base);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(url, lang);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(String url, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(url, base, lang);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(Reader reader, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(reader, base, lang);
            g.stopBatchAdd();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model read(InputStream reader, String base, String lang) {
        VirtGraph g = (VirtGraph)this.getGraph();
        Object object = this.lck_add;
        synchronized (object) {
            g.startBatchAdd();
            Model ret = super.read(reader, base, lang);
            g.stopBatchAdd();
            return ret;
        }
    }

    public Model add(Statement[] statements) {
        return this.add(Arrays.asList(statements).iterator());
    }

    public Model add(List<Statement> statements) {
        return this.add(statements.iterator());
    }

    public Model add(StmtIterator iter) {
        return this.add((Iterator<Statement>)iter);
    }

    protected Model add(Iterator<Statement> it) {
        VirtGraph _g = (VirtGraph)this.graph;
        _g.add(_g.getGraphName(), it);
        return this;
    }

    public Model add(Model m) {
        return this.add(m.listStatements());
    }

    public Model remove(Statement[] statements) {
        return this.remove(Arrays.asList(statements).iterator());
    }

    public Model remove(List<Statement> statements) {
        return this.remove(statements.iterator());
    }

    protected Model remove(Iterator<Statement> it) {
        VirtGraph _g = (VirtGraph)this.graph;
        _g.delete(_g.getGraphName(), it);
        return this;
    }

    public Model remove(Model m) {
        VirtGraph _g = (VirtGraph)this.graph;
        _g.md_delete_Model(m.listStatements());
        return this;
    }
}

