/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.PrintWriter;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;

class VirtuosoFuture {
    protected static final String callerid = "caller_identification";
    protected static final String scon = "SCON";
    protected static final String exec = "EXEC";
    protected static final String close = "FRST";
    protected static final String fetch = "FTCH";
    protected static final String prepare = "PREP";
    protected static final String transaction = "TRXC";
    protected static final String getdata = "GETDA";
    protected static final String extendedfetch = "EXTF";
    protected static final String cancel = "CANCEL";
    protected static final String tp_transaction = "TPTRX";
    private int req_no;
    private VirtuosoConnection connection;
    private Vector results = new Vector(5);
    private boolean is_complete = false;
    protected static PrintWriter rpc_log = null;

    VirtuosoFuture(VirtuosoConnection connection, String rpcname, Object[] args, int req_no, int timeout) throws IOException, VirtuosoException {
        this.connection = connection;
        this.req_no = req_no;
        connection.setSocketTimeout(timeout);
        this.send_message(rpcname, args);
    }

    protected void send_message(String rpcname, Object[] args) throws IOException, VirtuosoException {
        Object[] vector = new Object[5];
        if (args != null) {
            Vector v = new Vector(args);
            vector[4] = v;
        } else {
            vector[4] = null;
        }
        vector[3] = rpcname;
        vector[2] = null;
        vector[1] = new Integer(this.req_no);
        vector[0] = new Integer(1);
        this.connection.write_object(new Vector(vector));
    }

    protected void putResult(Object res) {
        this.results.addElement(res);
    }

    protected Vector nextResult() throws VirtuosoException {
        try {
            while (this.results.isEmpty()) {
                this.connection.read_request();
            }
            Vector vect = (Vector)this.results.firstElement();
            this.results.removeElementAt(0);
            return vect;
        }
        catch (IOException e) {
            this.sendCancelFuture();
            throw new VirtuosoException("Virtuoso Communications Link Failure (timeout) : " + e.getMessage(), -3);
        }
    }

    protected void sendCancelFuture() throws VirtuosoException {
        int ver = this.connection.getVersionNum();
        try {
            Object[] args = new Object[]{};
            this.connection.removeFuture(this.connection.getFuture(cancel, args, 0));
        }
        catch (IOException e) {
        }
        catch (VirtuosoException e2) {
            throw e2;
        }
    }

    protected void complete(boolean isComplete) {
        this.is_complete = isComplete;
    }

    public int hashCode() {
        return this.req_no;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VirtuosoFuture) {
            return ((VirtuosoFuture)obj).req_no == this.req_no;
        }
        return false;
    }
}

