/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.sesame4.driver.config;

import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.SimpleValueFactory;
import org.openrdf.model.util.ModelException;
import org.openrdf.model.util.Models;
import org.openrdf.repository.config.AbstractRepositoryImplConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import virtuoso.sesame4.driver.config.VirtuosoRepositorySchema;

public class VirtuosoRepositoryConfig
extends AbstractRepositoryImplConfig {
    private String hostlist;
    private String username;
    private String password;
    private String defGraph;
    private boolean useLazyAdd;
    private int fetchSize = 100;
    private boolean roundRobin;
    private String ruleSet;
    private int batchSize = 5000;
    private boolean insertBNodeAsVirtuosoIRI = false;

    public VirtuosoRepositoryConfig() {
        super("openrdf:VirtuosoRepository");
    }

    public VirtuosoRepositoryConfig(String hostlist) {
        this();
        this.setHostList(hostlist);
    }

    public String getHostList() {
        return this.hostlist;
    }

    public void setHostList(String hostlist) {
        this.hostlist = hostlist;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDefGraph() {
        return this.defGraph;
    }

    public void setDefGraph(String defGraph) {
        this.defGraph = defGraph;
    }

    public boolean getUseLazyAdd() {
        return this.useLazyAdd;
    }

    public void setUseLazyAdd(boolean useLazyAdd) {
        this.useLazyAdd = useLazyAdd;
    }

    public boolean getRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String ruleSet) {
        this.ruleSet = ruleSet != null && ruleSet.equals("null") ? null : ruleSet;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setInsertBNodeAsVirtuosoIRI(boolean v) {
        this.insertBNodeAsVirtuosoIRI = v;
    }

    public boolean getInsertBNodeAsVirtuosoIRI() {
        return this.insertBNodeAsVirtuosoIRI;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.hostlist == null) {
            throw new RepositoryConfigException("No HostList specified for Virtuoso repository");
        }
    }

    public Resource export(Model model) {
        Resource implNode = super.export(model);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        if (this.hostlist != null) {
            model.add(implNode, VirtuosoRepositorySchema.HOSTLIST, (Value)vf.createLiteral(this.hostlist), new Resource[0]);
        }
        if (this.username != null) {
            model.add(implNode, VirtuosoRepositorySchema.USERNAME, (Value)vf.createLiteral(this.username), new Resource[0]);
        }
        if (this.password != null) {
            model.add(implNode, VirtuosoRepositorySchema.PASSWORD, (Value)vf.createLiteral(this.password), new Resource[0]);
        }
        if (this.defGraph != null) {
            model.add(implNode, VirtuosoRepositorySchema.DEFGRAPH, (Value)vf.createLiteral(this.defGraph), new Resource[0]);
        }
        if (this.ruleSet != null && this.ruleSet.length() > 0 && !this.ruleSet.equals("null")) {
            model.add(implNode, VirtuosoRepositorySchema.RULESET, (Value)vf.createLiteral(this.ruleSet), new Resource[0]);
        }
        model.add(implNode, VirtuosoRepositorySchema.USELAZYADD, (Value)vf.createLiteral(this.useLazyAdd), new Resource[0]);
        model.add(implNode, VirtuosoRepositorySchema.ROUNDROBIN, (Value)vf.createLiteral(this.roundRobin), new Resource[0]);
        model.add(implNode, VirtuosoRepositorySchema.FETCHSIZE, (Value)vf.createLiteral(Integer.toString(this.fetchSize, 10)), new Resource[0]);
        model.add(implNode, VirtuosoRepositorySchema.BATCHSIZE, (Value)vf.createLiteral(Integer.toString(this.batchSize, 10)), new Resource[0]);
        model.add(implNode, VirtuosoRepositorySchema.INSERTBNodeAsVirtuosoIRI, (Value)vf.createLiteral(this.insertBNodeAsVirtuosoIRI), new Resource[0]);
        return implNode;
    }

    public void parse(Model model, Resource implNode) throws RepositoryConfigException {
        super.parse(model, implNode);
        try {
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.HOSTLIST, null, new Resource[0])).ifPresent(lit -> this.setHostList(lit.getLabel()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.USERNAME, null, new Resource[0])).ifPresent(lit -> this.setUsername(lit.getLabel()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.PASSWORD, null, new Resource[0])).ifPresent(lit -> this.setPassword(lit.getLabel()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.DEFGRAPH, null, new Resource[0])).ifPresent(lit -> this.setDefGraph(lit.getLabel()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.USELAZYADD, null, new Resource[0])).ifPresent(lit -> this.setUseLazyAdd(lit.booleanValue()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.ROUNDROBIN, null, new Resource[0])).ifPresent(lit -> this.setRoundRobin(lit.booleanValue()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.FETCHSIZE, null, new Resource[0])).ifPresent(lit -> this.setFetchSize(lit.intValue()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.RULESET, null, new Resource[0])).ifPresent(lit -> this.setRuleSet(lit.getLabel()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.BATCHSIZE, null, new Resource[0])).ifPresent(lit -> this.setBatchSize(lit.intValue()));
            Models.objectLiteral((Model)model.filter(implNode, VirtuosoRepositorySchema.INSERTBNodeAsVirtuosoIRI, null, new Resource[0])).ifPresent(lit -> this.setInsertBNodeAsVirtuosoIRI(lit.booleanValue()));
        }
        catch (ModelException e) {
            throw new RepositoryConfigException(e.getMessage(), (Throwable)e);
        }
    }
}

