/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import virtuoso.jdbc3.VirtuosoFuture;
import virtuoso.jdbc3.VirtuosoXid;
import virtuoso.jdbc3.XATransaction;

class XAResourceManager {
    private String serverName;
    private int portNumber;
    private HashMap transactions = new HashMap();
    private static ArrayList managers = new ArrayList();

    private XAResourceManager(String serverName, int portNumber) {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("new XAResourceManager (serverName=" + serverName + ", portNumber=" + portNumber + ") :" + this.hashCode());
        }
        this.serverName = serverName;
        this.portNumber = portNumber;
    }

    static synchronized XAResourceManager getManager(String serverName, int portNumber) {
        XAResourceManager manager;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("XAResourceManager.getManager (serverName=" + serverName + ", portNumber=" + portNumber + ")");
        }
        for (int i = 0; i < managers.size(); ++i) {
            manager = (XAResourceManager)managers.get(i);
            if (manager.serverName != serverName || manager.portNumber != portNumber) continue;
            return manager;
        }
        manager = new XAResourceManager(serverName, portNumber);
        managers.add(manager);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XATransaction createTransaction(Xid xid, int status) throws XAException {
        XATransaction transaction = null;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("XAResourceManager.createTransaction (xid=" + xid.hashCode() + ", status=" + status + ") :" + this.hashCode());
        }
        VirtuosoXid vxid = new VirtuosoXid(xid);
        HashMap hashMap = this.transactions;
        synchronized (hashMap) {
            if (this.transactions.containsKey(vxid) && status != 3) {
                throw new XAException(-8);
            }
            transaction = new XATransaction(vxid, status);
            this.transactions.put(vxid, transaction);
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction(Xid xid) throws XAException {
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("XAResourceManager.removeTransaction (xid=" + xid.hashCode() + ") :" + this.hashCode());
        }
        VirtuosoXid vxid = new VirtuosoXid(xid);
        HashMap hashMap = this.transactions;
        synchronized (hashMap) {
            this.transactions.remove(vxid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XATransaction getTransaction(Xid xid) throws XAException {
        XATransaction transaction;
        if (VirtuosoFuture.rpc_log != null) {
            VirtuosoFuture.rpc_log.println("XAResourceManager.getTransaction (xid=" + xid.hashCode() + ") :" + this.hashCode());
        }
        VirtuosoXid vxid = new VirtuosoXid(xid);
        HashMap hashMap = this.transactions;
        synchronized (hashMap) {
            transaction = (XATransaction)this.transactions.get(vxid);
        }
        if (transaction == null) {
            throw new XAException(-4);
        }
        return transaction;
    }
}

