/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoFNSException;
import virtuoso.jdbc4.VirtuosoTypes;

public class VirtuosoArray
implements Array {
    ArrayList<Object> data;
    String typeName;
    int typeCode;
    private static final HashMap<String, Integer> types = new HashMap();

    public VirtuosoArray(String typeName, Object[] arr_data) throws VirtuosoException {
        this.typeName = typeName;
        Integer typeId = types.get(typeName.toLowerCase());
        int n = this.typeCode = typeId != null ? typeId : 1111;
        if (arr_data != null) {
            this.data = new ArrayList(arr_data.length);
            for (int i = 0; i < arr_data.length; ++i) {
                this.data.add(VirtuosoTypes.mapJavaTypeToSqlType(arr_data[i], this.typeCode));
            }
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.typeCode;
    }

    @Override
    public Object getArray() throws SQLException {
        return this.data.toArray();
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        Object[] slice = new Object[count];
        for (int i = 0; i < count; ++i) {
            slice[i] = this.data.get((int)index + i - 1);
        }
        return slice;
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new VirtuosoFNSException("getResultSet  not supported", -7);
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new VirtuosoFNSException("getResultSet  not supported", -7);
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        return this.getResultSet(index, count);
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    static {
        types.put("varchar", 12);
        types.put("character", 1);
        types.put("nvarchar", 12);
        types.put("char", 1);
        types.put("numeric", 2);
        types.put("decimal", 3);
        types.put("integer", 4);
        types.put("int", 4);
        types.put("smallint", 5);
        types.put("float", 6);
        types.put("real", 7);
        types.put("double", 8);
        types.put("varbinary", -3);
        types.put("timestamp", 93);
        types.put("datetime", 93);
        types.put("date", 91);
        types.put("time", 92);
        types.put("any", 1111);
    }
}

