/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import virtuoso.jena.driver.VirtGraph;

public class VirtPrefixMapping
extends PrefixMappingImpl {
    protected VirtGraph m_graph = null;

    public VirtPrefixMapping(VirtGraph graph) {
        this.m_graph = graph;
        String query = "DB.DBA.XML_SELECT_ALL_NS_DECLS (3)";
        Statement stmt = null;
        try {
            stmt = this.m_graph.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                String prefix = rs.getString(1);
                String uri = rs.getString(2);
                if (uri == null || uri == null) continue;
                super.setNsPrefix(prefix, uri);
            }
            rs.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String query = "DB.DBA.XML_REMOVE_NS_BY_PREFIX(?, 2)";
        super.removeNsPrefix(prefix);
        try {
            PreparedStatement ps = this.m_graph.prepareStatement(query);
            ps.setString(1, prefix);
            ps.execute();
            ps.close();
        }
        catch (Exception e) {
            throw new JenaException((Throwable)e);
        }
        return this;
    }

    public PrefixMapping setNsPrefix(String prefix, String uri) {
        super.setNsPrefix(prefix, uri);
        String query = "DB.DBA.XML_SET_NS_DECL(?, ?, 2)";
        try {
            PreparedStatement ps = this.m_graph.prepareStatement(query);
            ps.setString(1, prefix);
            ps.setString(2, uri);
            ps.execute();
            ps.close();
        }
        catch (Exception e) {
            throw new JenaException(e.toString());
        }
        return this;
    }

    public PrefixMapping setNsPrefixes(PrefixMapping other) {
        return this.setNsPrefixes(other.getNsPrefixMap());
    }

    public PrefixMapping setNsPrefixes(Map other) {
        this.checkUnlocked();
        for (Map.Entry e : other.entrySet()) {
            this.setNsPrefix((String)e.getKey(), (String)e.getValue());
        }
        return this;
    }
}

