/*
 * Decompiled with CFR 0.152.
 */
package openlink.util;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import openlink.util.OPLMessage_u;

public class OPLHeapClob
implements Clob,
Serializable {
    static final long serialVersionUID = 6296947263965593908L;
    private char[] blobData = null;
    private long blobLength = 0L;
    private static final int buf_size = 32768;
    private Object lck = this;

    public OPLHeapClob() {
        this.blobData = new char[1];
    }

    public OPLHeapClob(String string) {
        this.blobData = string.toCharArray();
        this.blobLength = this.blobData.length;
    }

    public OPLHeapClob(char[] cArray) {
        this.blobData = new char[cArray.length];
        System.arraycopy(cArray, 0, this.blobData, 0, cArray.length);
        this.blobLength = cArray.length;
    }

    public OPLHeapClob(Reader reader) throws SQLException {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter(32768);
            BufferedReader bufferedReader = new BufferedReader(reader, 32768);
            char[] cArray = new char[32768];
            int n = bufferedReader.read(cArray, 0, 32768);
            while (n != -1) {
                charArrayWriter.write(cArray, 0, n);
                n = bufferedReader.read(cArray, 0, 32768);
            }
            this.blobData = charArrayWriter.toCharArray();
            this.blobLength = this.blobData.length;
        }
        catch (IOException iOException) {
            throw OPLMessage_u.makeException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            return this.blobLength;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (--l >= this.blobLength) {
                throw OPLMessage_u.makeException(2);
            }
            if ((long)n > this.blobLength - l) {
                n = (int)(this.blobLength - l);
            }
            return new String(this.blobData, (int)l, n);
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputReader(this.lck);
    }

    public InputStream getAsciiStream() throws SQLException {
        this.ensureOpen();
        return new BlobInputStream(this.getCharacterStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String string, long l) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            if (l < 1L) {
                throw OPLMessage_u.makeException(2);
            }
            if (--l > this.blobLength) {
                return -1L;
            }
            int n = (int)l;
            while ((long)n < this.blobLength && (long)string.length() <= this.blobLength - (long)n) {
                if (this.blobData[n] == string.charAt(0)) {
                    boolean bl = true;
                    for (int i = 1; i < string.length(); ++i) {
                        if (this.blobData[n + i] == string.charAt(i)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        return n + 1;
                    }
                }
                ++n;
            }
        }
        return -1L;
    }

    public long position(Clob clob, long l) throws SQLException {
        this.ensureOpen();
        if (l < 1L) {
            throw OPLMessage_u.makeException(2);
        }
        return this.position(clob.getSubString(0L, (int)clob.length()), l);
    }

    public int setString(long l, String string) throws SQLException {
        this.ensureOpen();
        return this.setString(l, string, 0, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            BlobOutputWriter blobOutputWriter = new BlobOutputWriter(this.lck, l);
            try {
                ((Writer)blobOutputWriter).write(string, n, n2);
            }
            catch (IOException iOException) {
                OPLMessage_u.makeException(iOException);
            }
        }
        return n2;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        this.ensureOpen();
        return new BlobOutputStream(new BlobOutputWriter(this.lck, l));
    }

    public Writer setCharacterStream(long l) throws SQLException {
        this.ensureOpen();
        return new BlobOutputWriter(this.lck, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        this.ensureOpen();
        Object object = this.lck;
        synchronized (object) {
            int n = (int)l;
            if (n < 0 || n > this.blobData.length) {
                throw OPLMessage_u.makeException(3);
            }
            if (n < this.blobData.length) {
                char[] cArray = new char[n];
                System.arraycopy(this.blobData, 0, cArray, 0, n);
                this.blobData = cArray;
            }
            this.blobLength = l;
        }
    }

    private void ensureOpen() throws SQLException {
        if (this.blobData == null) {
            throw OPLMessage_u.makeException(4);
        }
    }

    static /* synthetic */ char[] access$002(OPLHeapClob oPLHeapClob, char[] cArray) {
        oPLHeapClob.blobData = cArray;
        return cArray;
    }

    protected class BlobOutputStream
    extends OutputStream {
        private Writer out;
        private boolean isClosed = false;

        protected BlobOutputStream(Writer writer) {
            this.out = writer;
        }

        public synchronized void write(int n) throws IOException {
            this.ensureOpen();
            byte[] byArray = new byte[]{(byte)n};
            this.out.write(new String(byArray));
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.ensureOpen();
            if (n2 == 0) {
                return;
            }
            this.out.write(new String(byArray, n, n2));
        }

        public void close() throws IOException {
            this.isClosed = true;
            this.out.close();
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobOutputWriter
    extends Writer {
        protected int count;
        private boolean isClosed = false;

        protected BlobOutputWriter(Object object, long l) {
            super(object);
            this.count = (int)l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int n2 = this.count + 1;
                if (n2 > OPLHeapClob.this.blobData.length) {
                    char[] cArray = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, n2)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, cArray, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, cArray);
                }
                ((OPLHeapClob)OPLHeapClob.this).blobData[this.count] = (char)n;
                this.count = n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(char[] cArray, int n, int n2) throws IOException {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                int n3 = this.count + n2;
                if (n3 > OPLHeapClob.this.blobData.length) {
                    char[] cArray2 = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, n3)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, cArray2, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, cArray2);
                }
                System.arraycopy(cArray, n, OPLHeapClob.this.blobData, this.count, n2);
                this.count = n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String string, int n, int n2) throws IOException {
            this.ensureOpen();
            Object object = this.lock;
            synchronized (object) {
                int n3 = this.count + n2;
                if (n3 > OPLHeapClob.this.blobData.length) {
                    char[] cArray = new char[Math.max(OPLHeapClob.this.blobData.length + 32768, n3)];
                    System.arraycopy(OPLHeapClob.this.blobData, 0, cArray, 0, this.count);
                    OPLHeapClob.access$002(OPLHeapClob.this, cArray);
                }
                string.getChars(n, n + n2, OPLHeapClob.this.blobData, this.count);
                this.count = n3;
            }
        }

        public void flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() {
            Object object = this.lock;
            synchronized (object) {
                this.isClosed = true;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }

    protected class BlobInputStream
    extends InputStream {
        private static final int defBufSize = 32;
        private byte[] buf = new byte[32];
        private char[] cbuf = new char[8];
        private int pos = 0;
        private int count = 0;
        private Reader in;

        BlobInputStream(Reader reader) {
            this.in = reader;
        }

        private void ensureOpen() throws IOException {
            if (this.in == null || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }

        private void fill() throws IOException {
            this.pos = 0;
            this.count = 0;
            int n = this.in.read(this.cbuf);
            if (n == -1) {
                return;
            }
            byte[] byArray = new String(this.cbuf).getBytes();
            System.arraycopy(byArray, 0, this.buf, 0, byArray.length);
            this.count = byArray.length;
        }

        public synchronized int read() throws IOException {
            this.ensureOpen();
            if (this.pos >= this.count) {
                this.fill();
                if (this.pos >= this.count) {
                    return -1;
                }
            }
            return this.buf[this.pos++] & 0xFF;
        }

        private int read1(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.count - this.pos;
            if (n3 <= 0) {
                this.fill();
                n3 = this.count - this.pos;
                if (n3 <= 0) {
                    return -1;
                }
            }
            int n4 = n3 < n2 ? n3 : n2;
            System.arraycopy(this.buf, this.pos, byArray, n, n4);
            this.pos += n4;
            return n4;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            this.ensureOpen();
            if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n4 = this.read1(byArray, n, n2);
            if (n4 <= 0) {
                return n4;
            }
            while (n4 < n2 && (n3 = this.read1(byArray, n + n4, n2 - n4)) > 0) {
                n4 += n3;
            }
            return n4;
        }

        public synchronized int available() throws IOException {
            this.ensureOpen();
            return this.count - this.pos;
        }

        public synchronized void close() throws IOException {
            this.buf = null;
            this.cbuf = null;
            this.in.close();
            this.in = null;
        }
    }

    protected class BlobInputReader
    extends Reader {
        private boolean isClosed = false;
        private int pos = 0;
        private long length = 0L;

        protected BlobInputReader(Object object) {
            super(object);
            this.length = OPLHeapClob.this.blobData.length;
        }

        protected BlobInputReader(Object object, long l, long l2) {
            super(object);
            this.pos = (int)l;
            this.length = l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return (long)this.pos < this.length ? OPLHeapClob.this.blobData[this.pos++] : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (cArray == null) {
                    throw new NullPointerException();
                }
                if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if ((long)this.pos >= this.length) {
                    return -1;
                }
                if ((long)(this.pos + n2) > this.length) {
                    n2 = (int)(this.length - (long)this.pos);
                }
                if (n2 <= 0) {
                    return 0;
                }
                System.arraycopy(OPLHeapClob.this.blobData, this.pos, cArray, n, n2);
                this.pos += n2;
                return n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized long skip(long l) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if ((long)this.pos + l > this.length) {
                    l = this.length - (long)this.pos;
                }
                if (l < 0L) {
                    return 0L;
                }
                this.pos = (int)((long)this.pos + l);
                return l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                return true;
            }
        }

        public void close() {
            this.isClosed = true;
        }

        private void ensureOpen() throws IOException {
            if (this.isClosed || OPLHeapClob.this.blobData == null) {
                throw new IOException(OPLMessage_u.getMessage(1));
            }
        }
    }
}

