/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoDataSource;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoPoolManager;
import virtuoso.jdbc3.VirtuosoPooledConnection;

public class VirtuosoConnectionPoolDataSource
extends VirtuosoDataSource
implements ConnectionPoolDataSource,
ConnectionEventListener {
    protected static final String n_minPoolSize = "minPoolSize";
    protected static final String n_maxPoolSize = "maxPoolSize";
    protected static final String n_initialPoolSize = "initialPoolSize";
    protected static final String n_maxIdleTime = "maxIdleTime";
    protected static final String n_propertyCycle = "propertyCycle";
    protected static final String n_maxStatements = "maxStatements";
    public int minPoolSize = 0;
    public int maxPoolSize = 0;
    public int initialPoolSize = 0;
    public int maxIdleTime = 0;
    public int propertyCycle = 0;
    public int maxStatements = 0;
    private ConnCache connPool;
    private boolean isInitialized = false;
    private boolean isClosed = false;
    private Object initLock;
    private TreeSet propQueue;
    private long propEnforceTime = 0L;

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    public VirtuosoConnectionPoolDataSource() {
        this.dataSourceName = "VirtuosoConnectionPoolDataSourceName";
        this.initLock = new Object();
        this.connPool = new ConnCache(this);
        this.propQueue = new TreeSet(new Comparator(){

            public int compare(Object object, Object object2) {
                long l = ((NewProperty)object).enforceTime;
                long l2 = ((NewProperty)object2).enforceTime;
                if (l == l2) {
                    return 0;
                }
                if (l > l2) {
                    return 1;
                }
                return -1;
            }
        });
    }

    protected void checkPool() {
        if (this.isClosed) {
            return;
        }
        this.connPool.checkPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPropQueue() {
        if (this.isClosed || this.propEnforceTime == 0L) {
            return;
        }
        long l = System.currentTimeMillis();
        TreeSet treeSet = this.propQueue;
        synchronized (treeSet) {
            while (this.propEnforceTime != 0L && this.propEnforceTime < l) {
                NewProperty newProperty;
                try {
                    newProperty = (NewProperty)this.propQueue.first();
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.propEnforceTime = 0L;
                    break;
                }
                this.propQueue.remove(newProperty);
                try {
                    newProperty.fld.setInt(this, newProperty.arg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    newProperty = (NewProperty)this.propQueue.first();
                    this.propEnforceTime = newProperty.enforceTime;
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.propEnforceTime = 0L;
                    break;
                }
            }
        }
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.connPool.clear();
        this.initLock = null;
        this.propQueue.clear();
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        try {
            Object object = connectionEvent.getSource();
            if (object instanceof VirtuosoPooledConnection) {
                this.connPool.reusePooledConnection((VirtuosoPooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        try {
            Object object = connectionEvent.getSource();
            if (object instanceof VirtuosoPooledConnection) {
                this.connPool.closePooledConnection((VirtuosoPooledConnection)connectionEvent.getSource());
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void addProperties(Reference reference) {
        super.addProperties(reference);
        reference.add(new StringRefAddr(n_minPoolSize, String.valueOf(this.minPoolSize)));
        reference.add(new StringRefAddr(n_maxPoolSize, String.valueOf(this.maxPoolSize)));
        reference.add(new StringRefAddr(n_initialPoolSize, String.valueOf(this.initialPoolSize)));
        reference.add(new StringRefAddr(n_maxIdleTime, String.valueOf(this.maxIdleTime)));
        reference.add(new StringRefAddr(n_propertyCycle, String.valueOf(this.propertyCycle)));
        reference.add(new StringRefAddr(n_maxStatements, String.valueOf(this.maxStatements)));
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "virtuoso.jdbc3.VirtuosoDataSourceFactory", null);
        this.addProperties(reference);
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill() throws SQLException {
        this.check_close();
        Properties properties = this.createConnProperties();
        String string = this.create_url_key(this.create_url(), properties);
        Object object = this.initLock;
        synchronized (object) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                if (this.initialPoolSize == 0) {
                    this.initialPoolSize = this.minPoolSize;
                }
                if (this.initialPoolSize != 0) {
                    OpenHelper openHelper = new OpenHelper(this.initialPoolSize, properties);
                    openHelper.start();
                    try {
                        openHelper.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                VirtuosoPoolManager.getInstance().addPool(this);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        return this.getPooledConnection().getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getPooledConnection(string, string2).getConnection();
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        this.check_close();
        String string3 = this.create_url();
        Properties properties = this.createConnProperties();
        if (string != null) {
            properties.setProperty("user", string);
        }
        if (string2 != null) {
            properties.setProperty("password", string2);
        }
        String string4 = this.create_url_key(string3, properties);
        Object object = this.initLock;
        synchronized (object) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                if (this.initialPoolSize == 0) {
                    this.initialPoolSize = this.minPoolSize;
                }
                if (this.initialPoolSize != 0) {
                    OpenHelper openHelper = new OpenHelper(this.initialPoolSize, properties);
                    openHelper.start();
                    try {
                        openHelper.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                VirtuosoPoolManager.getInstance().addPool(this);
            }
        }
        return this.connPool.getPooledConnection(properties, string4, string3);
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int n) throws SQLException {
        try {
            Field field = this.getClass().getField(n_minPoolSize);
            this.setField(field, n);
        }
        catch (Exception exception) {
            throw new VirtuosoException("Error: " + exception.toString(), 0);
        }
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int n) throws SQLException {
        try {
            Field field = this.getClass().getField(n_maxPoolSize);
            this.setField(field, n);
        }
        catch (Exception exception) {
            throw new VirtuosoException("Error: " + exception.toString(), 0);
        }
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public void setInitialPoolSize(int n) throws SQLException {
        try {
            Field field = this.getClass().getField(n_initialPoolSize);
            this.setField(field, n);
        }
        catch (Exception exception) {
            throw new VirtuosoException("Error: " + exception.toString(), 0);
        }
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int n) throws SQLException {
        try {
            Field field = this.getClass().getField(n_maxIdleTime);
            this.setField(field, n);
        }
        catch (Exception exception) {
            throw new VirtuosoException("Error: " + exception.toString(), 0);
        }
    }

    public int getPropertyCycle() {
        return this.propertyCycle;
    }

    public void setPropertyCycle(int n) {
        this.propertyCycle = n;
    }

    public int getMaxStatements() {
        return this.maxStatements;
    }

    public void setMaxStatements(int n) throws SQLException {
        try {
            Field field = this.getClass().getField(n_maxStatements);
            this.setField(field, n);
        }
        catch (Exception exception) {
            throw new VirtuosoException("Error: " + exception.toString(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Field field, int n) throws Exception {
        if (this.propertyCycle == 0) {
            field.setInt(this, n);
        } else {
            TreeSet treeSet = this.propQueue;
            synchronized (treeSet) {
                this.propQueue.add(new NewProperty(field, n));
                this.propEnforceTime = ((NewProperty)this.propQueue.first()).enforceTime;
            }
        }
    }

    private void check_close() throws SQLException {
        if (this.isClosed) {
            throw new VirtuosoException("ConnectionPoolDataSource is closed", 0);
        }
    }

    private class ConnCache {
        private LinkedList unUsed = new LinkedList();
        private HashMap in_Use = new HashMap(32);
        private int cacheSize = 0;
        private VirtuosoConnectionPoolDataSource cpds;

        private ConnCache(VirtuosoConnectionPoolDataSource virtuosoConnectionPoolDataSource2) {
            this.cpds = virtuosoConnectionPoolDataSource2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPooledConnection(VirtuosoPooledConnection virtuosoPooledConnection) {
            ConnCache connCache = this;
            synchronized (connCache) {
                ((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.unUsed.addLast(virtuosoPooledConnection);
                ++((VirtuosoConnectionPoolDataSource)VirtuosoConnectionPoolDataSource.this).connPool.cacheSize;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clear() throws SQLException {
            ConnCache connCache = this;
            synchronized (connCache) {
                VirtuosoPooledConnection virtuosoPooledConnection;
                Iterator<Object> iterator = this.in_Use.keySet().iterator();
                while (iterator.hasNext()) {
                    virtuosoPooledConnection = (VirtuosoPooledConnection)iterator.next();
                    virtuosoPooledConnection.removeConnectionEventListener(this.cpds);
                    --this.cacheSize;
                    try {
                        virtuosoPooledConnection.close();
                    }
                    catch (Exception exception) {}
                }
                this.in_Use.clear();
                iterator = this.unUsed.iterator();
                while (iterator.hasNext()) {
                    virtuosoPooledConnection = (VirtuosoPooledConnection)iterator.next();
                    --this.cacheSize;
                    try {
                        virtuosoPooledConnection.close();
                    }
                    catch (Exception exception) {}
                }
                this.unUsed.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reusePooledConnection(VirtuosoPooledConnection virtuosoPooledConnection) throws SQLException {
            if (virtuosoPooledConnection == null) {
                return;
            }
            boolean bl = true;
            virtuosoPooledConnection.removeConnectionEventListener(this.cpds);
            Object object = this;
            synchronized (object) {
                VirtuosoPooledConnection virtuosoPooledConnection2 = null;
                virtuosoPooledConnection2 = (VirtuosoPooledConnection)this.in_Use.remove(virtuosoPooledConnection);
                if (virtuosoPooledConnection2 == null) {
                    throw new VirtuosoException("Unexpected state of cache", 0);
                }
                if (VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && this.cacheSize > VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                    --this.cacheSize;
                    bl = false;
                } else {
                    virtuosoPooledConnection2 = virtuosoPooledConnection.reuse();
                    this.unUsed.addFirst(virtuosoPooledConnection2);
                    this.notifyAll();
                }
            }
            if (!bl) {
                object = new CloseHelper(virtuosoPooledConnection);
                ((Thread)object).start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closePooledConnection(VirtuosoPooledConnection virtuosoPooledConnection) throws SQLException {
            virtuosoPooledConnection.removeConnectionEventListener(this.cpds);
            ConnCache connCache = this;
            synchronized (connCache) {
                VirtuosoPooledConnection virtuosoPooledConnection2 = (VirtuosoPooledConnection)this.in_Use.remove(virtuosoPooledConnection);
                if (virtuosoPooledConnection2 == null) {
                    throw new VirtuosoException("Unexpected state of cache", 0);
                }
                --this.cacheSize;
            }
            virtuosoPooledConnection.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VirtuosoPooledConnection lookup(String string) {
            ListIterator listIterator;
            block10: {
                CloseHelper closeHelper;
                Object object;
                LinkedList<VirtuosoPooledConnection> linkedList = new LinkedList<VirtuosoPooledConnection>();
                int n = string.hashCode();
                try {
                    listIterator = this.unUsed.listIterator();
                    while (listIterator.hasNext()) {
                        VirtuosoPooledConnection virtuosoPooledConnection = (VirtuosoPooledConnection)listIterator.next();
                        if (virtuosoPooledConnection.hashConnURL != n || !virtuosoPooledConnection.connURL.equals(string)) continue;
                        listIterator.remove();
                        if (virtuosoPooledConnection.isConnectionLost()) {
                            object = this;
                            synchronized (object) {
                                if (this.cacheSize > 1) {
                                    --this.cacheSize;
                                }
                                linkedList.add(virtuosoPooledConnection);
                                continue;
                            }
                        }
                        object = virtuosoPooledConnection;
                        Object var9_8 = null;
                        if (linkedList.size() <= 0) break block9;
                        closeHelper = new CloseHelper(linkedList);
                    }
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var9_10 = null;
                        if (linkedList.size() <= 0) break block11;
                        CloseHelper closeHelper2 = new CloseHelper(linkedList);
                        closeHelper2.start();
                    }
                    throw throwable;
                }
                {
                    block9: {
                        closeHelper.start();
                    }
                    return object;
                }
                listIterator = null;
                Object var9_9 = null;
                if (linkedList.size() <= 0) break block10;
                CloseHelper closeHelper3 = new CloseHelper(linkedList);
                closeHelper3.start();
            }
            return listIterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PooledConnection getPooledConnection(Properties properties, String string, String string2) throws SQLException {
            VirtuosoPooledConnection virtuosoPooledConnection = null;
            ConnCache connCache = this;
            synchronized (connCache) {
                if (!this.unUsed.isEmpty() && (virtuosoPooledConnection = this.lookup(string)) != null) {
                    virtuosoPooledConnection.init(this.cpds);
                    this.in_Use.put(virtuosoPooledConnection, virtuosoPooledConnection);
                    return virtuosoPooledConnection;
                }
            }
            connCache = this;
            synchronized (connCache) {
                if (VirtuosoConnectionPoolDataSource.this.maxPoolSize == 0 || this.cacheSize < VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                    VirtuosoConnection virtuosoConnection = new VirtuosoConnection(string2, "localhost", 1111, properties);
                    ++this.cacheSize;
                    virtuosoPooledConnection = new VirtuosoPooledConnection(virtuosoConnection, string, this.cpds);
                    this.in_Use.put(virtuosoPooledConnection, virtuosoPooledConnection);
                    return virtuosoPooledConnection;
                }
            }
            long l = System.currentTimeMillis();
            long l2 = (long)VirtuosoConnectionPoolDataSource.this.loginTimeout * 1000L;
            Thread thread = Thread.currentThread();
            while (virtuosoPooledConnection == null) {
                ConnCache connCache2 = this;
                synchronized (connCache2) {
                    if (!this.unUsed.isEmpty() && (virtuosoPooledConnection = this.lookup(string)) != null) {
                        virtuosoPooledConnection.init(this.cpds);
                        this.in_Use.put(virtuosoPooledConnection, virtuosoPooledConnection);
                        return virtuosoPooledConnection;
                    }
                    try {
                        if (VirtuosoConnectionPoolDataSource.this.loginTimeout > 0) {
                            this.wait(l2);
                            if ((l2 -= System.currentTimeMillis() - l) < 0L) {
                                throw new VirtuosoException("Connection failed loginTimeout has expired", -6);
                            }
                        } else {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkPool() {
            ListIterator listIterator;
            LinkedList<VirtuosoPooledConnection> linkedList = new LinkedList<VirtuosoPooledConnection>();
            if (VirtuosoConnectionPoolDataSource.this.maxIdleTime != 0) {
                long l = System.currentTimeMillis() - (long)VirtuosoConnectionPoolDataSource.this.maxIdleTime * 1000L;
                ConnCache connCache = this;
                synchronized (connCache) {
                    listIterator = this.unUsed.listIterator();
                    while (listIterator.hasNext()) {
                        VirtuosoPooledConnection virtuosoPooledConnection = (VirtuosoPooledConnection)listIterator.next();
                        if (virtuosoPooledConnection.tmClosed >= l) continue;
                        linkedList.add(virtuosoPooledConnection);
                        listIterator.remove();
                        --this.cacheSize;
                    }
                }
            }
            Object object = this;
            synchronized (object) {
                if (VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && this.cacheSize > VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                    listIterator = this.unUsed.listIterator();
                    for (int i = this.cacheSize - VirtuosoConnectionPoolDataSource.this.maxPoolSize; listIterator.hasNext() && i > 0; --i) {
                        linkedList.add((VirtuosoPooledConnection)listIterator.next());
                        listIterator.remove();
                        --this.cacheSize;
                    }
                }
            }
            if (linkedList != null && linkedList.size() > 0) {
                object = new CloseHelper(linkedList);
                ((Thread)object).start();
            }
            object = this;
            synchronized (object) {
                if (VirtuosoConnectionPoolDataSource.this.minPoolSize != 0 && this.cacheSize < VirtuosoConnectionPoolDataSource.this.minPoolSize) {
                    Properties properties = VirtuosoConnectionPoolDataSource.this.createConnProperties();
                    int n = VirtuosoConnectionPoolDataSource.this.minPoolSize - this.cacheSize;
                    OpenHelper openHelper = new OpenHelper(n, properties);
                    openHelper.start();
                }
            }
        }
    }

    private class CloseHelper
    extends Thread {
        private LinkedList connList;
        private PooledConnection pconn;

        private CloseHelper() {
            this.setName("Virtuoso CloseHelper");
        }

        protected CloseHelper(LinkedList linkedList) {
            this();
            this.connList = linkedList;
        }

        protected CloseHelper(PooledConnection pooledConnection) {
            this();
            this.pconn = pooledConnection;
        }

        public void run() {
            if (this.connList != null) {
                ListIterator listIterator = this.connList.listIterator();
                while (listIterator.hasNext()) {
                    try {
                        ((VirtuosoPooledConnection)listIterator.next()).close();
                    }
                    catch (Exception exception) {}
                }
                this.connList.clear();
            } else {
                try {
                    this.pconn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class OpenHelper
    extends Thread {
        private String conn_url;
        private Properties info;
        private String connKey;
        private int count;

        protected OpenHelper(int n, Properties properties) {
            this.count = n;
            this.info = properties;
            this.conn_url = VirtuosoConnectionPoolDataSource.this.create_url();
            this.connKey = VirtuosoConnectionPoolDataSource.this.create_url_key(this.conn_url, this.info);
            this.setName("Virtuoso OpenHelper");
        }

        public void run() {
            if (VirtuosoConnectionPoolDataSource.this.connPool.cacheSize >= this.count || VirtuosoConnectionPoolDataSource.this.maxPoolSize != 0 && VirtuosoConnectionPoolDataSource.this.connPool.cacheSize >= VirtuosoConnectionPoolDataSource.this.maxPoolSize) {
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                try {
                    VirtuosoConnection virtuosoConnection = new VirtuosoConnection(this.conn_url, "localhost", 1111, this.info);
                    VirtuosoConnectionPoolDataSource.this.connPool.addPooledConnection(new VirtuosoPooledConnection(virtuosoConnection, this.connKey));
                    if ((VirtuosoConnectionPoolDataSource.this.minPoolSize == 0 || VirtuosoConnectionPoolDataSource.this.connPool.cacheSize < VirtuosoConnectionPoolDataSource.this.minPoolSize) && (VirtuosoConnectionPoolDataSource.this.maxPoolSize == 0 || VirtuosoConnectionPoolDataSource.this.connPool.cacheSize < VirtuosoConnectionPoolDataSource.this.maxPoolSize)) continue;
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class NewProperty {
        protected long enforceTime;
        protected Field fld;
        protected int arg;

        protected NewProperty(Field field, int n) {
            this.fld = field;
            this.arg = n;
            this.enforceTime = System.currentTimeMillis() + (long)VirtuosoConnectionPoolDataSource.this.propertyCycle * 1000L;
        }
    }
}

