#include "cdk.h"
#include <limits.h>

#ifdef XCURSES
char *XCursesProgramName="cdkslider";
#endif

/*
 * Declare file local prototypes.
 */
void widgetCB (EObjectType cdktype, void *object, void *clientData, chtype key);

/*
 * Define file local variables.
 */
char *FPUsage = "-f Field Width -l Low Value -h High Value [-s Initial Value]] [-i Increment Value] [-a Accelerated Increment Value] [-F Field Character] [-T Title] [-L Label] [-B Buttons] [-O Output File] [-X X Position] [-Y Y Position] [-N] [-S]";

/*
 *
 */
int main (int argc, char **argv)
{
   /* Declare variables. */
   CDKSCREEN *cdkScreen		= (CDKSCREEN *)NULL;
   CDKSLIDER *widget		= (CDKSLIDER *)NULL;
   CDKBUTTONBOX *buttonWidget	= (CDKBUTTONBOX *)NULL;
   WINDOW *cursesWindow		= (WINDOW *)NULL;
   char *title			= (char *)NULL;
   char *label			= (char *)NULL;
   char *outputFile		= (char *)NULL;
   char *barAttribute		= (char *)NULL;
   char *buttons		= (char *)NULL;
   char *CDK_WIDGET_COLOR	= (char *)NULL;
   char *temp			= (char *)NULL;
   chtype *holder		= (chtype *)NULL;
   chtype fieldAttr		= A_REVERSE | ' ';
   int xpos			= CENTER;
   int ypos			= CENTER;
   int ret			= 0;
   boolean boxWidget		= TRUE;
   boolean shadowWidget		= FALSE;
   int fieldWidth		= 0;
   int initValue		= INT_MIN;
   int lowValue			= INT_MAX;
   int highValue		= INT_MIN;
   int incrementStep		= 1;
   int acceleratedStep		= -1;
   int answer			= 0;
   int buttonCount		= 0;
   int selection		= 0;
   int shadowHeight		= 0;
   FILE *fp			= stderr;
   char *buttonList[30];
   int j1, j2, tmp;

   /* Parse up the command line. */
   while (1)
   {
      /* If there aren't any more options, then break. */
      if ((ret = getopt (argc, argv, "F:f:l:h:s:i:a:T:L:B:O:X:Y:NS")) == -1)
      {
         break;
      }

      /* Determine which command line option we just received. */
      switch (ret)
      {
         case 'F':
              barAttribute = copyChar (optarg);
              break;

         case 'f':
              fieldWidth = atoi (optarg);
              break;

         case 'l':
              lowValue = atoi (optarg);
              break;

         case 'h':
              highValue = atoi (optarg);
              break;

         case 's':
              initValue = atoi (optarg);
              break;

         case 'i':
              incrementStep = abs (atoi (optarg));
              break;

         case 'a':
              acceleratedStep = atoi (optarg);
              break;

         case 'T':
              title = copyChar (optarg);
              break;

         case 'B':
              buttons = copyChar (optarg);
              break;

         case 'L':
              label = copyChar (optarg);
              break;

         case 'O':
              outputFile = copyChar (optarg);
              break;

         case 'X':
              if (strcmp (optarg, "TOP") == 0)
              {
                 xpos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 xpos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 xpos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 xpos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 xpos = CENTER;
              }
              else
              {
                 xpos = atoi (optarg);
              }
              break;

         case 'Y':
              if (strcmp (optarg, "TOP") == 0)
              {
                 ypos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 ypos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 ypos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 ypos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 ypos = CENTER;
              }
              else
              {
                 ypos = atoi (optarg);
              }
              break;

         case 'N':
              boxWidget = FALSE;
              break;

         case 'S':
              shadowWidget = TRUE;
              break;

         default:
              break;
      }
   }

   /* Make sure all the command line parameters were provided. */
   if (fieldWidth <= 0)
   {
      fprintf (stderr, "Usage: %s %s\n", argv[0], FPUsage);
      exit (-1);
   }

   /* Make sure the user supplied the low/high values. */
   if ((lowValue == INT_MAX) || (highValue == INT_MIN))
   {
      fprintf (stderr, "Usage: %s %s\n", argv[0], FPUsage);
      exit (-1);
   }

   /* If the user asked for an output file, try to open it. */
   if (outputFile != (char *)NULL)
   {
      if ((fp = fopen (outputFile, "w")) == NULL)
      {
         fprintf (stderr, "%s: Can not open output file %s\n", argv[0], outputFile);
         exit (-1);
      }
   }

   /* Make sure the low is lower than the high (and vice versa). */
   if (lowValue > highValue)
   {
      tmp	= lowValue;
      lowValue	= highValue;
      highValue	= tmp;
   }

   /* Make sure the starting value is in range. */
   if (initValue < lowValue)
   {
      initValue = lowValue;
   }
   else if (initValue > highValue)
   {
      initValue = highValue;
   }

   /* Check if the accelerated incremnt value was set. */
   if (acceleratedStep <= 0)
   {
      acceleratedStep = (int)((highValue - lowValue) / 10);
      acceleratedStep = MAXIMUM (1, acceleratedStep);
   }

   /* Set up CDK. */ 
   cursesWindow = initscr();
   cdkScreen = initCDKScreen (cursesWindow);

   /* Start color. */
   initCDKColor();

   /* Check if the user wants to set the background of the main screen. */
   if ((temp = getenv ("CDK_SCREEN_COLOR")) != NULL)
   {
      holder = char2Chtype (temp, &j1, &j2);
      wbkgd (cdkScreen->window, holder[0]);
      wrefresh (cdkScreen->window);
      freeChtype (holder);
   }

   /* Get the widget color background color. */
   if ((CDK_WIDGET_COLOR = getenv ("CDK_WIDGET_COLOR")) == NULL)
   {
      CDK_WIDGET_COLOR = (char *)NULL;
   }

   /* Did the user ask to change the bar attribute? */
   if (barAttribute != (char *)NULL)
   {
      holder = char2Chtype (barAttribute, &j1, &j2);
      fieldAttr = holder[0];
      freeChtype (holder);
   }

   /* Create the entry widget. */
   widget = newCDKSlider (cdkScreen, xpos, ypos,
				title, label,
				fieldAttr, fieldWidth,
				initValue, lowValue, highValue,
				incrementStep, acceleratedStep,
				boxWidget, shadowWidget);

   /* Check to make sure we created the dialog box. */
   if (widget == NULL)
   {
      /* Clean up used memory. */
      freeChar (title);
      freeChar (label);

      /* Shut down curses and CDK. */
      destroyCDKScreen (cdkScreen);
      delwin (cursesWindow);
      endCDK();

      /* Spit out the message. */
      fprintf (stderr, "Error: Could not create the numeric slider field. Is the window too small?\n");

      /* Exit with an error. */
      exit (-1);
   }

   /* Split the buttons if they supplied some. */
   if (buttons != (char *)NULL)
   {
      /* Split the button list up. */
      buttonCount = splitString (buttons, buttonList, '\n');
      freeChar (buttons);

      /* We need to create a buttonbox widget. */
      buttonWidget = newCDKButtonbox (cdkScreen,
					WIN_XPOS (widget->win),
					WIN_YPOS (widget->win) + widget->boxHeight - 1,
					1, widget->boxWidth - 1,
					NULL, 1, buttonCount,
					buttonList, buttonCount,
					A_REVERSE, boxWidget, FALSE);
      setCDKButtonboxULChar (buttonWidget, ACS_LTEE);
      setCDKButtonboxURChar (buttonWidget, ACS_RTEE);

     /*
      * We need to set the lower left and right
      * characters of the widget.
      */
      setCDKSliderLLChar (widget, ACS_LTEE);
      setCDKSliderLRChar (widget, ACS_RTEE);

     /*
      * Bind the Tab key in the widget to send a
      * Tab key to the button box widget.
      */
      bindCDKObject (vSLIDER, widget, KEY_TAB, widgetCB, buttonWidget);
      bindCDKObject (vSLIDER, widget, CDK_NEXT, widgetCB, buttonWidget);
      bindCDKObject (vSLIDER, widget, CDK_PREV, widgetCB, buttonWidget);

      /* Check if the user wants to set the background of the widget. */
      setCDKButtonboxBackgroundColor (buttonWidget, CDK_WIDGET_COLOR);

      /* Draw the button widget. */
      drawCDKButtonbox (buttonWidget, boxWidget);
   }

  /*
   * If the user asked for a shadow, we need to create one.
   * I do this instead of using the shadow parameter because
   * the button widget sin't part of the main widget and if
   * the user asks for both buttons and a shadow, we need to
   * create a shadow big enough for both widgets. We'll create
   * the shadow window using the widgets shadowWin element, so
   * screen refreshes will draw them as well.
   */
   if (shadowWidget == TRUE)
   {
      /* Determine the height of the shadow window. */
      shadowHeight = (buttonWidget == (CDKBUTTONBOX *)NULL ? 
			widget->boxHeight :
			widget->boxHeight + buttonWidget->boxHeight - 1);

      /* Create the shadow window. */
      widget->shadowWin = newwin (shadowHeight,
					widget->boxWidth,
					WIN_YPOS (widget->win) + 1,
					WIN_XPOS (widget->win) + 1);

      /* Make sure we could have created the shadow window. */
      if (widget->shadowWin != (WINDOW *)NULL)
      {
         widget->shadow = TRUE;

        /*
         * We force the widget and buttonWidget to be drawn so the
         * buttonbox widget will be drawn when the widget is activated.
         * Otherwise the shadow window will draw over the button widget.
         */
         drawCDKSlider (widget, widget->box);
         eraseCDKButtonbox (buttonWidget);
         drawCDKButtonbox (buttonWidget, buttonWidget->box);
      }
   }

   /* Check if the user wants to set the background of the widget. */
   setCDKSliderBackgroundColor (widget, CDK_WIDGET_COLOR);

   /* Activate the widget. */
   answer = activateCDKSlider (widget, NULL);

   /* If there were buttons, get the button selected. */
   if (buttonWidget != (CDKBUTTONBOX *)NULL)
   {
      selection = buttonWidget->currentButton;
      destroyCDKButtonbox (buttonWidget);
   }

   /* End CDK. */
   destroyCDKSlider (widget);
   destroyCDKScreen (cdkScreen);
   delwin (cursesWindow);
   endCDK();

   /* Print the value from the widget. */
   fprintf (fp, "%d\n", answer);

   /* Clean up. */
   freeChar (title);
   freeChar (label);

   /* Exit with the button selected. */
   exit (selection);
}

void widgetCB (EObjectType cdktype, void *object, void *clientData, chtype key)
{
   CDKBUTTONBOX *buttonbox = (CDKBUTTONBOX *)clientData;
   injectCDKButtonbox (buttonbox, key);
}
