#include "cdk.h"
#include <limits.h>

#ifdef XCURSES
char *XCursesProgramName="cdkradio";
#endif

/*
 * Declare file local prototypes.
 */
void widgetCB (EObjectType cdktype, void *object, void *clientData, chtype key);

/*
 * Define file local variables.
 */
char *FPUsage = "-l List | -f filename [-c Choice Character] [-d Default Item] [-s Scroll Bar Position] [-n Numbers] [-i Item Index] [-T Title] [-B Buttons] [-O Output File] [-X X Position] [-Y Y Position] [-H Height] [-W Width] [-N] [-S]";

/*
 * 
 */
int main (int argc, char **argv)
{
   /* Declare variables. */
   CDKSCREEN *cdkScreen		= (CDKSCREEN *)NULL;
   CDKRADIO *widget		= (CDKRADIO *)NULL;
   CDKBUTTONBOX *buttonWidget	= (CDKBUTTONBOX *)NULL;
   WINDOW *cursesWindow		= (WINDOW *)NULL;
   char *filename		= (char *)NULL;
   char *title			= (char *)NULL;
   char *list			= (char *)NULL;
   char *outputFile		= (char *)NULL;
   char *buttons		= (char *)NULL;
   char *CDK_WIDGET_COLOR	= (char *)NULL;
   char *temp			= (char *)NULL;
   chtype *holder		= (chtype *)NULL;
   char *choice			= "</R>X";
   chtype *choiceChar		= (chtype *)NULL;
   int answer			= 0;
   int xpos			= CENTER;
   int ypos			= CENTER;
   int spos			= NONE;
   int defaultItem		= 0;
   int height			= 10;
   int width			= 1;
   int ret			= 0;
   int scrollLines		= -1;
   int buttonCount		= 0;
   int selection		= 0;
   int shadowHeight		= 0;
   boolean boxWidget		= TRUE;
   boolean shadowWidget		= FALSE;
   boolean stringOutput		= TRUE;
   FILE *fp			= stderr;
   char *buttonList[30];
   char *scrollList[MAX_ITEMS];
   int x, j1, j2;

   /* Parse up the command line. */
   while (1)
   {
      /* If there aren't any more options, then break. */
      if ((ret = getopt (argc, argv, "l:f:s:c:d:iT:B:O:H:W:X:Y:NS")) == -1)
      {
         break;
      }

      /* Determine which command line option we just received. */
      switch (ret)
      {
         case 'f':
              filename = copyChar (optarg);
              break;

         case 'i':
              stringOutput = FALSE;
              break;

         case 'l':
              list = copyChar (optarg);
              break;

         case 'T':
              title = copyChar (optarg);
              break;

         case 'B':
              buttons = copyChar (optarg);
              break;

         case 'c':
              choice = copyChar (optarg);
              break;

         case 'd':
              defaultItem = atoi (optarg);
              break;

         case 's':
              if (strcmp (optarg, "LEFT") == 0)
              {
                 spos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 spos = RIGHT;
              }
              else
              {
                 spos = NONE;
              }
              break;

         case 'O':
              outputFile = copyChar (optarg);
              break;

         case 'W':
              if (strcmp (optarg, "FULL") == 0)
              {
                 width = COLS;
              }
              else
              {
                 width = atoi (optarg);
              }
              break;

         case 'H':
              if (strcmp (optarg, "FULL") == 0)
              {
                 height = LINES;
              }
              else
              {
                 height = atoi (optarg);
              }
              break;

         case 'X':
              if (strcmp (optarg, "TOP") == 0)
              {
                 xpos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 xpos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 xpos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 xpos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 xpos = CENTER;
              }
              else
              {
                 xpos = atoi (optarg);
              }
              break;

         case 'Y':
              if (strcmp (optarg, "TOP") == 0)
              {
                 ypos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 ypos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 ypos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 ypos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 ypos = CENTER;
              }
              else
              {
                 ypos = atoi (optarg);
              }
              break;

         case 'N':
              boxWidget = FALSE;
              break;

         case 'S':
              shadowWidget = TRUE;
              break;

         default:
              break;
      }
   }

   /* If the user asked for an output file, try to open it. */
   if (outputFile != (char *)NULL)
   {
      if ((fp = fopen (outputFile, "w")) == NULL)
      {
         fprintf (stderr, "%s: Can not open output file %s\n", argv[0], outputFile);
         exit (-1);
      }
   }

   /* Did they provide a list of items. */
   if (list == (char *)NULL)
   {
      /* Maybe they gave a filename to use to read. */
      if (filename != (char *)NULL)
      {
         /* Read the file in. */
         scrollLines = readFile (filename, scrollList, MAX_LINES);

         /* Check if there was an error. */
         if (scrollLines == -1)
         {
            fprintf (stderr, "Error: Could not open the file '%s'.\n", filename);
            exit (-1);
         }
      }
      else
      {
         /* They didn't provide anything. */
         fprintf (stderr, "Usage: %s %s\n", argv[0], FPUsage);
         exit (-1);
      }
   }
   else
   {
      /* Split the scroll lines up. */
      scrollLines = splitString (list, scrollList, '\n');
      freeChar (title);
   }

   /* Start curses. */
   cursesWindow = initscr();

   /* Create the CDK screen. */
   cdkScreen = initCDKScreen (cursesWindow);

   /* Start color. */
   initCDKColor();

   /* Check if the user wants to set the background of the main screen. */
   if ((temp = getenv ("CDK_SCREEN_COLOR")) != NULL)
   {
      holder = char2Chtype (temp, &j1, &j2);
      wbkgd (cdkScreen->window, holder[0]);
      wrefresh (cdkScreen->window);
      freeChtype (holder);
   }

   /* Get the widget color background color. */
   if ((CDK_WIDGET_COLOR = getenv ("CDK_WIDGET_COLOR")) == NULL)
   {
      CDK_WIDGET_COLOR = (char *)NULL;
   }

   /* Convert the char * choiceChar to a chtype * */
   choiceChar = char2Chtype (choice, &j1, &j2);

   /* Create the scrolling list. */
   widget = newCDKRadio (cdkScreen, xpos, ypos, spos,
				height, width, title,
				scrollList, scrollLines,
				choiceChar[0], defaultItem,
				A_REVERSE,
				boxWidget, shadowWidget);

   /* Make sure we could create the widget. */
   if (widget == (CDKRADIO *)NULL)
   {
      /* Clean up some memory. */
      for (x=0; x < scrollLines; x++)
      {
         freeChar (scrollList[x]);
      }
      freeChar (title);
 
      /* Shut down curses and CDK. */
      destroyCDKScreen (cdkScreen);
      delwin (cursesWindow);
      endCDK();
 
      /* Spit out the message. */
      fprintf (stderr, "Error: Could not create the radio list. Is the window too small?\n");
 
      /* Exit with an error. */
      exit (-1);
   }

   /* Split the buttons if they supplied some. */
   if (buttons != (char *)NULL)
   {
      /* Split the button list up. */
      buttonCount = splitString (buttons, buttonList, '\n');
      freeChar (buttons);

      /* We need to create a buttonbox widget. */
      buttonWidget = newCDKButtonbox (cdkScreen,
					WIN_XPOS (widget->win),
					WIN_YPOS (widget->win) + widget->boxHeight - 1,
					1, widget->boxWidth - 1,
					NULL, 1, buttonCount,
					buttonList, buttonCount,
					A_REVERSE, boxWidget, FALSE);
      setCDKButtonboxULChar (buttonWidget, ACS_LTEE);
      setCDKButtonboxURChar (buttonWidget, ACS_RTEE);

     /*
      * We need to set the lower left and right
      * characters of the widget.
      */
      setCDKRadioLLChar (widget, ACS_LTEE);
      setCDKRadioLRChar (widget, ACS_RTEE);

     /*
      * Bind the Tab key in the widget to send a
      * Tab key to the button box widget.
      */
      bindCDKObject (vRADIO, widget, KEY_TAB, widgetCB, buttonWidget);
      bindCDKObject (vRADIO, widget, CDK_NEXT, widgetCB, buttonWidget);
      bindCDKObject (vRADIO, widget, CDK_PREV, widgetCB, buttonWidget);

      /* Check if the user wants to set the background of the widget. */
      setCDKButtonboxBackgroundColor (buttonWidget, CDK_WIDGET_COLOR);

      /* Draw the button widget. */
      drawCDKButtonbox (buttonWidget, boxWidget);
   }

  /*
   * If the user asked for a shadow, we need to create one.
   * I do this instead of using the shadow parameter because
   * the button widget sin't part of the main widget and if
   * the user asks for both buttons and a shadow, we need to
   * create a shadow big enough for both widgets. We'll create
   * the shadow window using the widgets shadowWin element, so
   * screen refreshes will draw them as well.
   */
   if (shadowWidget == TRUE)
   {
      /* Determine the height of the shadow window. */
      shadowHeight = (buttonWidget == (CDKBUTTONBOX *)NULL ? 
			widget->boxHeight :
			widget->boxHeight + buttonWidget->boxHeight - 1);

      /* Create the shadow window. */
      widget->shadowWin = newwin (shadowHeight,
					widget->boxWidth,
					WIN_YPOS (widget->win) + 1,
					WIN_XPOS (widget->win) + 1);

      /* Make sure we could have created the shadow window. */
      if (widget->shadowWin != (WINDOW *)NULL)
      {
         widget->shadow = TRUE;

        /*
         * We force the widget and buttonWidget to be drawn so the
         * buttonbox widget will be drawn when the widget is activated.
         * Otherwise the shadow window will draw over the button widget.
         */
         drawCDKRadio (widget, widget->box);
         eraseCDKButtonbox (buttonWidget);
         drawCDKButtonbox (buttonWidget, buttonWidget->box);
      }
   }

   /* Check if the user wants to set the background of the widget. */
   setCDKRadioBackgroundColor (widget, CDK_WIDGET_COLOR);

   /* Activate the scrolling list. */
   answer = activateCDKRadio (widget, NULL);

   /* If there were buttons, get the button selected. */
   if (buttonWidget != (CDKBUTTONBOX *)NULL)
   {
      selection = buttonWidget->currentButton;
      destroyCDKButtonbox (buttonWidget);
   }

   /* Shut down curses. */
   destroyCDKRadio (widget);
   destroyCDKScreen (cdkScreen);
   delwin (cursesWindow);
   endCDK();

   /* Print out the answer. */
   if (answer >= 0)
   {
      if (stringOutput == TRUE)
      {
         fprintf (fp, "%s\n", scrollList[answer]);
      }
      else
      {
         fprintf (fp, "%d\n", answer);
      }
   }

   /* Exit with the button selected. */
   exit (selection);
}

void widgetCB (EObjectType cdktype, void *object, void *clientData, chtype key)
{
   CDKBUTTONBOX *buttonbox = (CDKBUTTONBOX *)clientData;
   injectCDKButtonbox (buttonbox, key);
}
