#include "cdk.h"

#ifdef XCURSES
char *XCursesProgramName="cdklabel";
#endif

/*
 * Declare file local variables.
 */
char *FPUsage = "-m Message String | -f filename [-c Command] [-p Pause Character] [-s Sleep] [-X X Position] [-Y Y Position] [-N] [-S]";

/*
 * 
 */
void main (int argc, char **argv)
{
   /* Declare variables. */
   CDKSCREEN *cdkScreen		= (CDKSCREEN *)NULL;
   CDKLABEL *widget		= (CDKLABEL *)NULL;
   WINDOW *cursesWindow		= (WINDOW *)NULL;
   char *message		= (char *)NULL;
   char *filename		= (char *)NULL;
   char *command		= (char *)NULL;
   char *CDK_WIDGET_COLOR	= (char *)NULL;
   char *temp			= (char *)NULL;
   chtype *holder		= (chtype *)NULL;
   char waitChar		= (char) NULL;
   boolean shadowWidget		= FALSE;
   boolean boxWidget		= TRUE;
   int xpos			= CENTER;
   int ypos			= CENTER;
   int messageLines		= -1;
   int sleepLength		= -1;
   char *messageList[MAX_LABEL_ROWS];
   char tempCommand[1000];
   int ret, x, j1, j2;

   /* Parse up the command line. */
   while (1)
   {
      /* If there aren't any more options, then break. */
      if ((ret = getopt (argc, argv, "m:f:p:s:c:X:Y:NS")) == -1)
      {
         break;
      }

      /* Determine which command line option we just received. */
      switch (ret)
      {
         case 'm':
              message = copyChar (optarg);
              break;

         case 'f':
              filename = copyChar (optarg);
              break;

         case 'c':
              command = copyChar (optarg);
              break;

         case 'p':
              waitChar = optarg[0];
              break;

         case 's':
              sleepLength = atoi (optarg);
              break;

         case 'X':
              if (strcmp (optarg, "TOP") == 0)
              {
                 xpos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 xpos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 xpos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 xpos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 xpos = CENTER;
              }
              else
              {
                 xpos = atoi (optarg);
              }
              break;

         case 'Y':
              if (strcmp (optarg, "TOP") == 0)
              {
                 ypos = TOP;
              }
              else if (strcmp (optarg, "BOTTOM") == 0)
              {
                 ypos = BOTTOM;
              }
              else if (strcmp (optarg, "LEFT") == 0)
              {
                 ypos = LEFT;
              }
              else if (strcmp (optarg, "RIGHT") == 0)
              {
                 ypos = RIGHT;
              }
              else if (strcmp (optarg, "CENTER") == 0)
              {
                 ypos = CENTER;
              }
              else
              {
                 ypos = atoi (optarg);
              }
              break;

         case 'N':
              boxWidget = FALSE;
              break;

         case 'S':
              shadowWidget = TRUE;
              break;

         default:
              break;
      }
   }

   /* Make sure we have a message to display. */
   if (message == (char *)NULL)
   {
      /* No message, maybe they provided a file to read. */
      if (filename != (char *)NULL)
      {
         /* Read the file in. */
         messageLines = readFile (filename, messageList, MAX_LABEL_ROWS);
         freeChar (filename);

         /* Check if there was an error. */
         if (messageLines == -1)
         {
            fprintf (stderr, "Error: Could not open the file %s\n", filename);
            exit (-1);
         }
      }
      else
      {
         /* No message, no file, it's an error. */
         fprintf (stderr, "Usage: %s %s\n", argv[0], FPUsage);
         exit (-1);
      }
   }
   else
   {
      /* Split the message up. */
      messageLines = splitString (message, messageList, '\n');
      freeChar (message);
   }

   /* Set up CDK. */ 
   cursesWindow = initscr();
   cdkScreen = initCDKScreen (cursesWindow);

   /* Start color. */
   initCDKColor();

   /* Check if the user wants to set the background of the main screen. */
   if ((temp = getenv ("CDK_SCREEN_COLOR")) != NULL)
   {
      holder = char2Chtype (temp, &j1, &j2);
      wbkgd (cdkScreen->window, holder[0]);
      wrefresh (cdkScreen->window);
      freeChtype (holder);
   }

   /* Get the widget color background color. */
   if ((CDK_WIDGET_COLOR = getenv ("CDK_WIDGET_COLOR")) == NULL)
   {
      CDK_WIDGET_COLOR = (char *)NULL;
   }

   /* Create the label widget. */
   widget = newCDKLabel (cdkScreen, xpos, ypos,
			messageList, messageLines,
			boxWidget, shadowWidget);

   /* Make sure we could create the widget. */
   if (widget == (CDKLABEL *)NULL)
   {
      /* Clean up some memory. */
      for (x=0; x < messageLines; x++)
      {
         freeChar (messageList[x]);
      }

      /* Shut down curses and CDK. */
      destroyCDKScreen (cdkScreen);
      delwin (cursesWindow);
      endCDK();

      /* Spit out the message. */
      fprintf (stderr, "Error: Could not create the label. Is the window too small?\n");

      /* Exit with an error. */
      exit (-1);
   }

   /* Check if the user wants to set the background of the widget. */
   setCDKLabelBackgroundColor (widget, CDK_WIDGET_COLOR);

   /* Draw the widget. */
   drawCDKLabel (widget, boxWidget);

   /* If they supplied a command, run it. */
   if (command != (char *)NULL)
   {
      sprintf (tempCommand, "(sh -c %s) >/dev/null 2>&1", command);
      system (tempCommand);
   }

   /* If they supplied a wait character, wait for the user to hit it. */
   if (waitChar != (char)NULL)
   {
      waitCDKLabel (widget, waitChar);
   }

   /* If they supplied a sleep time, sleep for the given length. */
   if (sleepLength != -1)
   {
      sleep (sleepLength);
   }

   /* Clean up. */
   for (x=0; x < messageLines; x++)
   {
      freeChar (messageList[x]);
   }
   destroyCDKLabel (widget);
   destroyCDKScreen (cdkScreen);
   delwin (cursesWindow);
   endCDK();

   /* Exit cleanly. */
   exit (0);
}
