// A Bison parser, made by GNU Bison 3.0.2.13-aa0e.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2013 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.
// //                    "%code top" blocks.
#line 85 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:392

  #include <cassert>

  /// Call the factory to make a Kind.
#define MAKE(Kind, ...)                         \
  driver_.ratexpset_->Kind(__VA_ARGS__)

  /// Run Stm, and bounces exceptions into parse errors at Loc.
#define TRY(Loc, Stm)                           \
  try                                           \
    {                                           \
      Stm;                                      \
    }                                           \
  catch (std::exception& e)                     \
    {                                           \
      error(Loc, e.what());                     \
      YYERROR;                                  \
    }

#line 54 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:392


// First part of user declarations.

#line 59 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:399

# ifndef YY_NULLPTR
#  if defined __cplusplus && 201103L <= __cplusplus
#   define YY_NULLPTR nullptr
#  else
#   define YY_NULLPTR 0
#  endif
# endif

#include "parse.hh"

// User implementation prologue.

#line 73 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:407
// Unqualified %code blocks.
#line 54 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:408

  #include <vcsn/dyn/ratexpset.hh>
  #include <lib/vcsn/rat/driver.hh>
  #include <lib/vcsn/rat/scan.hh>

  namespace vcsn
  {
    namespace rat
    {
      /// Generate a ratexp for "e{range.first, range.second}".
      static
      exp_t power(const dyn::ratexpset& rs, exp_t e, std::tuple<int, int> range);
      /// Generate a ratexp matching one character amongst \a chars.
      static
      exp_t char_class(const dyn::ratexpset& rs, const std::set<char>& chars);

      /// Use our local scanner object.
      static
      inline
      parser::symbol_type
      yylex(driver& driver_)
      {
        return driver_.scanner_->lex(driver_);
      }
    }
  }

#line 103 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:408


#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (/*CONSTCOND*/ false)
# endif


// Suppress unused-variable warnings by "using" E.
#define YYUSE(E) ((void) (E))

// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << std::endl;                  \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yystack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YYUSE(Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void>(0)
# define YY_STACK_PRINT()                static_cast<void>(0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyempty = true)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 11 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:474
namespace vcsn { namespace rat {
#line 189 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:474

  /* Return YYSTR after stripping away unnecessary quotes and
     backslashes, so that it's suitable for yyerror.  The heuristic is
     that double-quoting is unnecessary unless the string contains an
     apostrophe, a comma, or backslash (other than backslash-backslash).
     YYSTR is taken from yytname.  */
  std::string
  parser::yytnamerr_ (const char *yystr)
  {
    if (*yystr == '"')
      {
        std::string yyr = "";
        char const *yyp = yystr;

        for (;;)
          switch (*++yyp)
            {
            case '\'':
            case ',':
              goto do_not_strip_quotes;

            case '\\':
              if (*++yyp != '\\')
                goto do_not_strip_quotes;
              // Fall through.
            default:
              yyr += *yyp;
              break;

            case '"':
              return yyr;
            }
      do_not_strip_quotes: ;
      }

    return yystr;
  }


  /// Build a parser object.
  parser::parser (driver& driver__yyarg)
    :
#if YYDEBUG
      yydebug_ (false),
      yycdebug_ (&std::cerr),
#endif
      driver_ (driver__yyarg)
  {}

  parser::~parser ()
  {}


  /*---------------.
  | Symbol types.  |
  `---------------*/



  // by_state.
  inline
  parser::by_state::by_state ()
    : state (empty)
  {}

  inline
  parser::by_state::by_state (const by_state& other)
    : state (other.state)
  {}

  inline
  void
  parser::by_state::move (by_state& that)
  {
    state = that.state;
    that.state = empty;
  }

  inline
  parser::by_state::by_state (state_type s)
    : state (s)
  {}

  inline
  parser::symbol_number_type
  parser::by_state::type_get () const
  {
    return state == empty ? 0 : yystos_[state];
  }

  inline
  parser::stack_symbol_type::stack_symbol_type ()
  {}


  inline
  parser::stack_symbol_type::stack_symbol_type (state_type s, symbol_type& that)
    : super_type (s, that.location)
  {
      switch (that.type_get ())
    {
      case 22: // input
      case 24: // exp
      case 25: // weights
        value.move< braced_ratexp > (that.value);
        break;

      case 14: // "*"
        value.move< irange_type > (that.value);
        break;

      case 17: // "character-class"
        value.move< std::set<char> > (that.value);
        break;

      case 15: // "letter"
      case 16: // "weight"
        value.move< std::string > (that.value);
        break;

      default:
        break;
    }

    // that is emptied.
    that.type = empty;
  }

  inline
  parser::stack_symbol_type&
  parser::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
      switch (that.type_get ())
    {
      case 22: // input
      case 24: // exp
      case 25: // weights
        value.copy< braced_ratexp > (that.value);
        break;

      case 14: // "*"
        value.copy< irange_type > (that.value);
        break;

      case 17: // "character-class"
        value.copy< std::set<char> > (that.value);
        break;

      case 15: // "letter"
      case 16: // "weight"
        value.copy< std::string > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }


  template <typename Base>
  inline
  void
  parser::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
  parser::yy_print_ (std::ostream& yyo,
                                     const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YYUSE (yyoutput);
    symbol_number_type yytype = yysym.type_get ();
    yyo << (yytype < yyntokens_ ? "token" : "nterm")
        << ' ' << yytname_[yytype] << " ("
        << yysym.location << ": ";
    switch (yytype)
    {
            case 15: // "letter"

#line 110 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
        { yyo << '"' << yysym.value.template as< std::string > () << '"'; }
#line 380 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
        break;

      case 16: // "weight"

#line 113 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
        { yyo << '<' << yysym.value.template as< std::string > () << '>'; }
#line 387 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
        break;

      case 17: // "character-class"

#line 111 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
        { yyo << '['; for (auto c: yysym.value.template as< std::set<char> > ()) yyo << c; yyo << ']'; }
#line 394 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
        break;

      case 22: // input
//-
//-#line 114 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
//-        { driver_.ratexpset_->print(yyo, yysym.value.template as< braced_ratexp > ().exp); }
//-#line 401 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
//-        break;

      case 24: // exp
//-
//-#line 114 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
//-        { driver_.ratexpset_->print(yyo, yysym.value.template as< braced_ratexp > ().exp); }
//-#line 408 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
//-        break;

      case 25: // weights

#line 114 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:617
        { driver_.ratexpset_->print(yyo, yysym.value.template as< braced_ratexp > ().exp); }
#line 415 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:617
        break;


      default:
        break;
    }
    yyo << ')';
  }
#endif

  inline
  void
  parser::yypush_ (const char* m, state_type s, symbol_type& sym)
  {
    stack_symbol_type t (s, sym);
    yypush_ (m, t);
  }

  inline
  void
  parser::yypush_ (const char* m, stack_symbol_type& s)
  {
    if (m)
      YY_SYMBOL_PRINT (m, s);
    yystack_.push (s);
  }

  inline
  void
  parser::yypop_ (unsigned int n)
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
  parser::debug_stream () const
  {
    return *yycdebug_;
  }

  void
  parser::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


  parser::debug_level_type
  parser::debug_level () const
  {
    return yydebug_;
  }

  void
  parser::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

  inline parser::state_type
  parser::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - yyntokens_] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - yyntokens_];
  }

  inline bool
  parser::yy_pact_value_is_default_ (int yyvalue)
  {
    return yyvalue == yypact_ninf_;
  }

  inline bool
  parser::yy_table_value_is_error_ (int yyvalue)
  {
    return yyvalue == yytable_ninf_;
  }

  int
  parser::parse ()
  {
    /// Whether yyla contains a lookahead.
    bool yyempty = true;

    // State.
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

    // FIXME: This shoud be completely indented.  It is not yet to
    // avoid gratuitous conflicts when merging into the master branch.
    try
      {
    YYCDEBUG << "Starting parse" << std::endl;


    // User initialization code.
    #line 106 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:725
{
  yyla.location = driver_.location_;
}

#line 536 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:725

    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, yyla);

    // A new symbol was pushed on the stack.
  yynewstate:
    YYCDEBUG << "Entering state " << yystack_[0].state << std::endl;

    // Accept?
    if (yystack_[0].state == yyfinal_)
      goto yyacceptlab;

    goto yybackup;

    // Backup.
  yybackup:

    // Try to take a decision without lookahead.
    yyn = yypact_[yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyempty)
      {
        YYCDEBUG << "Reading a token: ";
        try
          {
            symbol_type yylookahead (yylex (driver_));
            yyla.move (yylookahead);
          }
        catch (const syntax_error& yyexc)
          {
            error (yyexc);
            goto yyerrlab1;
          }
        yyempty = false;
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.type_get ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.type_get ())
      goto yydefault;

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Discard the token being shifted.
    yyempty = true;

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", yyn, yyla);
    goto yynewstate;

  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;

  /*-----------------------------.
  | yyreduce -- Do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_(yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
        switch (yyr1_[yyn])
    {
      case 22: // input
      case 24: // exp
      case 25: // weights
        yylhs.value.build< braced_ratexp > ();
        break;

      case 14: // "*"
        yylhs.value.build< irange_type > ();
        break;

      case 17: // "character-class"
        yylhs.value.build< std::set<char> > ();
        break;

      case 15: // "letter"
      case 16: // "weight"
        yylhs.value.build< std::string > ();
        break;

      default:
        break;
    }


      // Compute the default @$.
      {
        slice<stack_symbol_type, stack_type> slice (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, slice, yylen);
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
      try
        {
          switch (yyn)
            {
  case 2:
#line 154 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    {
                      driver_.result_ = yystack_[0].value.as< braced_ratexp > ().exp;
                      yylhs.value.as< braced_ratexp > ().exp = yystack_[0].value.as< braced_ratexp > ().exp;
                    }
#line 672 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 3:
#line 158 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    {
                      driver_.result_ = yystack_[1].value.as< braced_ratexp > ().exp;
                      yylhs.value.as< braced_ratexp > ().exp = yystack_[1].value.as< braced_ratexp > ().exp;
                      YYACCEPT;
                    }
#line 682 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 4:
#line 166 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { driver_.scanner_->yyin->putback(','); }
#line 688 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 5:
#line 167 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { driver_.scanner_->yyin->putback(')'); }
#line 694 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 6:
#line 171 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(mul, yystack_[2].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
#line 700 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 7:
#line 172 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(intersection, yystack_[2].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
#line 706 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 8:
#line 173 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(shuffle, yystack_[2].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
#line 712 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 9:
#line 174 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(add, yystack_[2].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
#line 718 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 10:
#line 175 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(intersection,
                                          yystack_[2].value.as< braced_ratexp > ().exp, MAKE(complement, yystack_[0].value.as< braced_ratexp > ().exp)); }
#line 725 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 11:
//-#line 177 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
//-    { yylhs.value.as< braced_ratexp > () = MAKE(mul, yystack_[1].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
//-#line 731 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
//-    break;

  case 12:
#line 178 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(mul, yystack_[1].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp); }
#line 737 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 13:
#line 180 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    {
    // See README.txt.
    if (!yystack_[1].value.as< braced_ratexp > ().parens && !yystack_[0].value.as< braced_ratexp > ().parens)
      yylhs.value.as< braced_ratexp > () = MAKE(concat, yystack_[1].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp);
    else
      {
        yylhs.value.as< braced_ratexp > ().exp = MAKE(mul, yystack_[1].value.as< braced_ratexp > ().exp, yystack_[0].value.as< braced_ratexp > ().exp);
        yylhs.value.as< braced_ratexp > ().parens = yystack_[0].value.as< braced_ratexp > ().parens;
      }
  }
#line 752 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 14:
#line 190 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = power(driver_.ratexpset_, yystack_[1].value.as< braced_ratexp > ().exp, yystack_[0].value.as< irange_type > ()); }
#line 758 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 15:
#line 191 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(complement, yystack_[1].value.as< braced_ratexp > ().exp); }
#line 764 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 16:
#line 192 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(zero); }
#line 770 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 17:
#line 193 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = MAKE(one); }
#line 776 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 18:
#line 194 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { TRY(yylhs.location, yylhs.value.as< braced_ratexp > () = MAKE(atom, yystack_[0].value.as< std::string > ())); }
#line 782 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 19:
#line 195 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > () = char_class(driver_.ratexpset_, yystack_[0].value.as< std::set<char> > ()); }
#line 788 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 20:
#line 196 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { yylhs.value.as< braced_ratexp > ().exp = yystack_[1].value.as< braced_ratexp > ().exp; yylhs.value.as< braced_ratexp > ().parens = true; }
#line 794 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 21:
#line 200 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { TRY(yylhs.location + 1, yylhs.value.as< braced_ratexp > () = MAKE(lmul, yystack_[0].value.as< std::string > (), MAKE(one))); }
#line 800 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;

  case 22:
#line 201 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:847
    { TRY(yylhs.location + 1, yylhs.value.as< braced_ratexp > () = MAKE(lmul, yystack_[1].value.as< std::string > (), yystack_[0].value.as< braced_ratexp > ().exp)); }
#line 806 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
    break;


#line 810 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:847
            default:
              break;
            }
        }
      catch (const syntax_error& yyexc)
        {
          error (yyexc);
          YYERROR;
        }
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;
      YY_STACK_PRINT ();

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, yylhs);
    }
    goto yynewstate;

  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        error (yyla.location, yysyntax_error_ (yystack_[0].state,
                                           yyempty ? yyempty_ : yyla.type_get ()));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.type_get () == yyeof_)
          YYABORT;
        else if (!yyempty)
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyempty = true;
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:

    /* Pacify compilers like GCC when the user code never invokes
       YYERROR and the label yyerrorlab therefore never appears in user
       code.  */
    if (false)
      goto yyerrorlab;
    yyerror_range[1].location = yystack_[yylen - 1].location;
    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    goto yyerrlab1;

  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    {
      stack_symbol_type error_token;
      for (;;)
        {
          yyn = yypact_[yystack_[0].state];
          if (!yy_pact_value_is_default_ (yyn))
            {
              yyn += yyterror_;
              if (0 <= yyn && yyn <= yylast_ && yycheck_[yyn] == yyterror_)
                {
                  yyn = yytable_[yyn];
                  if (0 < yyn)
                    break;
                }
            }

          // Pop the current state because it cannot handle the error token.
          if (yystack_.size () == 1)
            YYABORT;

          yyerror_range[1].location = yystack_[0].location;
          yy_destroy_ ("Error: popping", yystack_[0]);
          yypop_ ();
          YY_STACK_PRINT ();
        }

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = yyn;
      yypush_ ("Shifting", error_token);
    }
    goto yynewstate;

    // Accept.
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;

    // Abort.
  yyabortlab:
    yyresult = 1;
    goto yyreturn;

  yyreturn:
    if (!yyempty)
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack"
                 << std::endl;
        // Do not try to display the values of the reclaimed symbols,
        // as their printer might throw an exception.
        if (!yyempty)
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
  }

  void
  parser::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what());
  }

  // Generate an error message.
  std::string
  parser::yysyntax_error_ (state_type yystate, symbol_number_type yytoken) const
  {
    std::string yyres;
    // Number of reported tokens (one for the "unexpected", one per
    // "expected").
    size_t yycount = 0;
    // Its maximum.
    enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
    // Arguments of yyformat.
    char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];

    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yytoken) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state
         merging (from LALR or IELR) and default reductions corrupt the
         expected token list.  However, the list is correct for
         canonical LR with one exception: it will still contain any
         token that will not be accepted due to an error action in a
         later state.
    */
    if (yytoken != yyempty_)
      {
        yyarg[yycount++] = yytname_[yytoken];
        int yyn = yypact_[yystate];
        if (!yy_pact_value_is_default_ (yyn))
          {
            /* Start YYX at -YYN if negative to avoid negative indexes in
               YYCHECK.  In other words, skip the first -YYN actions for
               this state because they are default actions.  */
            int yyxbegin = yyn < 0 ? -yyn : 0;
            // Stay within bounds of both yycheck and yytname.
            int yychecklim = yylast_ - yyn + 1;
            int yyxend = yychecklim < yyntokens_ ? yychecklim : yyntokens_;
            for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
              if (yycheck_[yyx + yyn] == yyx && yyx != yyterror_
                  && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
                {
                  if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
                    {
                      yycount = 1;
                      break;
                    }
                  else
                    yyarg[yycount++] = yytname_[yyx];
                }
          }
      }

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
        YYCASE_(0, YY_("syntax error"));
        YYCASE_(1, YY_("syntax error, unexpected %s"));
        YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    // Argument number.
    size_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += yytnamerr_ (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const signed char parser::yypact_ninf_ = -16;

  const signed char parser::yytable_ninf_ = -1;

  const signed char
  parser::yypact_[] =
  {
      22,    22,   -16,   -16,   -16,   -15,   -16,     4,    49,    22,
      64,   -16,   -16,    22,    22,   -16,   -16,    22,    22,    22,
     -16,   -16,   -16,    -4,    22,   118,   -16,     0,    94,   106,
      94,    79
  };

  const unsigned char
  parser::yydefact_[] =
  {
       0,     0,    17,    16,    18,    21,    19,     0,     2,     0,
       0,    22,     1,     0,     0,     4,    15,     0,     0,     0,
       5,    14,     3,    13,    12,    11,    20,     7,     8,     6,
      10,     9
  };

  const signed char
  parser::yypgoto_[] =
  {
     -16,   -16,   -16,    27,    -5
  };

  const signed char
  parser::yydefgoto_[] =
  {
      -1,     7,    22,    23,     9
  };

  const unsigned char
  parser::yytable_[] =
  {
      11,     5,    16,    24,    12,    24,    16,    17,     1,     2,
      21,     0,     0,     3,    21,     4,     5,     6,    24,     0,
      24,     0,    24,    24,    24,    24,    24,     8,    10,     0,
       1,     2,     0,     0,     0,     3,    25,     4,     5,     6,
      27,    28,     0,     0,    29,    30,    31,     0,     0,     0,
       0,    25,    13,    14,    15,    16,    17,     1,     2,    18,
      19,    20,     3,    21,     4,     5,     6,    13,    14,     0,
      16,    17,     1,     2,    18,    19,    26,     3,    21,     4,
       5,     6,    13,    14,     0,    16,    17,     1,     2,    18,
       0,     0,     3,    21,     4,     5,     6,    13,     0,     0,
      16,    17,     1,     2,     0,     0,     0,     3,    21,     4,
       5,     6,    16,     0,     1,     2,     0,     0,     0,     3,
      21,     4,     5,     6,    16,     0,     1,     2,     0,     0,
       0,     3,    21,     4,     0,     6
  };

  const signed char
  parser::yycheck_[] =
  {
       5,    16,     6,     8,     0,    10,     6,     7,     8,     9,
      14,    -1,    -1,    13,    14,    15,    16,    17,    23,    -1,
      25,    -1,    27,    28,    29,    30,    31,     0,     1,    -1,
       8,     9,    -1,    -1,    -1,    13,     9,    15,    16,    17,
      13,    14,    -1,    -1,    17,    18,    19,    -1,    -1,    -1,
      -1,    24,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,     3,     4,    -1,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,     3,     4,    -1,     6,     7,     8,     9,    10,
      -1,    -1,    13,    14,    15,    16,    17,     3,    -1,    -1,
       6,     7,     8,     9,    -1,    -1,    -1,    13,    14,    15,
      16,    17,     6,    -1,     8,     9,    -1,    -1,    -1,    13,
      14,    15,    16,    17,     6,    -1,     8,     9,    -1,    -1,
      -1,    13,    14,    15,    -1,    17
  };

  const unsigned char
  parser::yystos_[] =
  {
       0,     8,     9,    13,    15,    16,    17,    22,    24,    25,
      24,    25,     0,     3,     4,     5,     6,     7,    10,    11,
      12,    14,    23,    24,    25,    24,    12,    24,    24,    24,
      24,    24
  };

  const unsigned char
  parser::yyr1_[] =
  {
       0,    21,    22,    22,    23,    23,    24,    24,    24,    24,
      24,    24,    24,    24,    24,    24,    24,    24,    24,    24,
      24,    25,    25
  };

  const unsigned char
  parser::yyr2_[] =
  {
       0,     2,     1,     2,     1,     1,     3,     3,     3,     3,
       3,     2,     2,     2,     2,     2,     1,     1,     1,     1,
       3,     1,     2
  };



  // YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
  // First, the terminals, then, starting at \a yyntokens_, nonterminals.
  const char*
  const parser::yytname_[] =
  {
  "\"end\"", "error", "$undefined", "\"&\"", "\":\"", "\",\"", "\"{c}\"",
  "\".\"", "\"(\"", "\"\\\\e\"", "\"%\"", "\"+\"", "\")\"", "\"\\\\z\"",
  "\"*\"", "\"letter\"", "\"weight\"", "\"character-class\"", "RWEIGHT",
  "LWEIGHT", "CONCAT", "$accept", "input", "terminator", "exp", "weights", YY_NULLPTR
  };

#if YYDEBUG
  const unsigned char
  parser::yyrline_[] =
  {
       0,   154,   154,   158,   166,   167,   171,   172,   173,   174,
     175,   177,   178,   179,   190,   191,   192,   193,   194,   195,
     196,   200,   201
  };

  // Print the state stack on the debug stream.
  void
  parser::yystack_print_ ()
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << i->state;
    *yycdebug_ << std::endl;
  }

  // Report on the debug stream that the rule \a yyrule is going to be reduced.
  void
  parser::yy_reduce_print_ (int yyrule)
  {
    unsigned int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):" << std::endl;
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG


#line 11 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:1155
} } // vcsn::rat
#line 1216 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.cc" // lalr1.cc:1155
#line 205 "/Users/akim/src/lrde/vaucanson2/lib/vcsn/rat/parse.yy" // lalr1.cc:1156


namespace vcsn
{
  namespace rat
  {
    static
    exp_t
    power(const dyn::ratexpset& es, exp_t e, int min, int max)
    {
      exp_t res;
      if (max == -1)
        {
          res = es->star(e);
          if (min != -1)
            res = es->mul(power(es, e, min, min), res);
        }
      else
        {
          if (min == -1)
            min = 0;
          if (min == 0)
            res = es->one();
          else
            {
              res = e;
              for (int n = 1; n < min; ++n)
                res = es->mul(res, e);
            }
          if (min < max)
            {
              exp_t sum = es->one();
              for (int n = 1; n <= max - min; ++n)
                sum = es->add(sum, power(es, e, n, n));
              res = es->mul(res, sum);
            }
        }
      return res;
    }

    static
    exp_t
    power(const dyn::ratexpset& es, exp_t e, std::tuple<int, int> range)
    {
      return power(es, e, std::get<0>(range), std::get<1>(range));
    }

    static
    exp_t
    char_class(const dyn::ratexpset& rs, const std::set<char>& chars)
    {
      exp_t res = rs->zero();
      for (auto c: chars)
        res = rs->add(res, rs->atom(std::string(1, c)));
      return res;
    }

    void
    vcsn::rat::parser::error(const location_type& l, const std::string& m)
    {
      driver_.error(l, m);
    }
  }
}
