#include <vcsn/algos/enumerate.hh>
#include <vcsn/dyn/algos.hh>
#include <lib/vcsn/algos/registry.hh>

namespace vcsn
{
  namespace dyn
  {
    REGISTER_DEFINE(shortest);

    std::string
    shortest(const automaton& aut)
    {
      return detail::shortest_registry().call(aut->vname(false),
                                              aut);
    }

    REGISTER_DEFINE(enumerate);

    polynomial
    enumerate(const automaton& aut, size_t max)
    {
      return detail::enumerate_registry().call(aut->vname(false),
                                               aut, max);
    }
  }
}
