/*****************************************************************************
*
* Copyright (c) 2000 - 2009, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                             avtvdfOptions.C                              //
// ************************************************************************* //

#include <avtvdfOptions.h>

#include <DBOptionsAttributes.h>

#include <vector>
#include <string>


// ****************************************************************************
//  Function: GetvdfReadOptions
//
//  Purpose:
//      Creates the options for vdf readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: dlagreca -- generated by xml2avt
//  Creation:   Wed Apr 7 14:43:06 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetvdfReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

	// The cache size parameter which will be passed the VDF Data Manager
    rv->SetInt("Cache size [MB]", 1000);

	// Resapmling factor for WRF (layered) data, which is passed to VDF Data Manager
    rv->SetDouble("Layered data resampling factor", 4.0);

	// Weather or not to report each VDC Block as it's own domain
    rv->SetBool("MultiDomain", false);

    return rv;
/* EXAMPLE OF OPTIONS
    rv->SetBool("Binary format", true);
    rv->SetBool("Big Endian", false);
    rv->SetEnum("Dimension", 1);
    vector<string> dims;
    dims.push_back("0D");
    dims.push_back("1D");
    dims.push_back("2D");
    dims.push_back("3D");
    rv->SetEnumStrings("Dimension", dims);
    rv->SetInt("Number of variables", 5);
    rv->SetString("Name of auxiliary file", );
    rv->SetDouble("Displacement factor", 1.0);

    // When reading or writing the file, you can get the options out of this object like:
    rv->GetDouble("Displacement factor");
*/
}


// ****************************************************************************
//  Function: GetvdfWriteOptions
//
//  Purpose:
//      Creates the options for vdf writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: dlagreca -- generated by xml2avt
//  Creation:   Wed Apr 7 14:43:06 PST 2010
//
// ****************************************************************************

DBOptionsAttributes *
GetvdfWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}
