//
// $Id$
//
#include <string>
#include <iostream>
#include <sstream>
#include <cctype>
#include <cassert>
#include <sys/stat.h>
#ifdef  Darwin
#include <CoreFoundation/CFBundle.h>
#include <CoreFoundation/CFString.h>
#include <CoreServices/CoreServices.h>
#endif
#include <vapor/MyBase.h>
#include "vapor/GetAppPath.h"
#ifdef WIN32
#pragma warning(disable : 4996)
#endif
using namespace std;
using namespace VetsUtil;

#ifdef  Darwin
string get_path_from_bundle(const string &app) {
    string path;
	path.clear();

	string bundlename = app + ".app";

    //
    // Get path to document directory from the application "Bundle";
    //

    CFBundleRef mainBundle = CFBundleGetMainBundle();
    if (!mainBundle) return(".");

    CFURLRef url = CFBundleCopyBundleURL(mainBundle);
    if (! url) return(".");

    const int kBufferLength = 1024;
    UInt8 buffer[kBufferLength];
    char componentStr[kBufferLength];

    CFIndex componentLength = CFURLGetBytes(url, buffer, kBufferLength);
    if (componentLength < 0) return(false);
    buffer[componentLength] = 0;

    CFRange range;
    CFRange rangeIncludingSeparators;

    range = CFURLGetByteRangeForComponent(
        url, kCFURLComponentPath, &rangeIncludingSeparators
    );
    if (range.location == kCFNotFound) return(".");

    strncpy(componentStr, (const char *)&buffer[range.location], range.length);
    componentStr[range.length] = 0;
	string s = componentStr;

	if (s.find(bundlename) == string::npos) return(path); 

    path = s;
    return(path);

}
#endif

std::string VetsUtil::GetAppPath(
	const string &app, 
	const string &resource,
	const vector <string> &paths
) {
	ostringstream oss;

	oss << "GetAppPath(" << app << ", " << resource;
	for (int i=0; i<paths.size(); i++) {
		oss << ", " << paths[i];
	}
	oss << ")" << endl;
	MyBase::SetDiagMsg("%s", oss.str().c_str());

#ifdef	WIN32
	const string separator = "\\";
#else
	const string separator = "/";
#endif

	string path;
	path.clear();

	string myapp = app;	// upper case app name
	for (string::iterator itr = myapp.begin(); itr != myapp.end(); itr++) {
		if (islower(*itr)) *itr = toupper(*itr);
	}

	string env(myapp);
	env.append("_");
	env.append("HOME");

	if ( ! (
		(resource.compare("lib") == 0) || 
		(resource.compare("bin") == 0) ||
		(resource.compare("share") == 0) ||
		(resource.compare("plugins") == 0) ||
		(resource.compare("") == 0)
	)) {
		MyBase::SetDiagMsg("GetAppPath() return : empty (unknown resources)");
		return("");	// empty path, invalid resource
	}

	char *homestr = getenv(env.c_str());
#ifdef	Darwin
	if (homestr) {
		string s = homestr;
		if (s.find(".app") != string::npos) {
			path.assign(homestr);
			path.append(separator);
			homestr = NULL;
		} 
	}
#endif

    if (homestr) {
		path.assign(homestr);
		if (! resource.empty()) {
			path.append(separator);
			path.append(resource);
		}
	}
#ifdef	Darwin
	else {
		if (path.empty()) {
			path = get_path_from_bundle(myapp);
		}
		if (! path.empty()) {
			path.append("Contents/");
			if (
				(resource.compare("lib")==0) || 
				(resource.compare("bin")==0) || 
				(resource.compare("")==0)) {
				path.append("MacOS");
			}
			else if (resource.compare("share") == 0) {
				path.append("SharedSupport");
			}
			else {	// must be plugins
				path.append("Plugins");
			}
		}
	}
#endif
#ifndef WIN32 //For both Linux and Mac:
	if (path.empty()) {
		if (resource.compare("lib") == 0) {
			path.append(DSO_DIR);
		}
		else if (resource.compare("bin") == 0) {
			path.append(BINDIR);
		}
		else if (resource.compare("share") == 0) {
			path.append(ABS_TOP);
			path.append(separator);
			path.append("share");
		}
		else if (resource.compare("plugins") == 0) {
			path.append(QTDIR);
			path.append(separator);
			path.append("plugins");
		}
	}
#endif
	if (path.empty()) {
		MyBase::SetDiagMsg("GetAppPath() return : empty (path empty)");
		return(path);
	}

	for (int i=0; i<paths.size(); i++) {
		path.append(separator);
		path.append(paths[i]);
	}

	struct STAT64 statbuf;
	if (STAT64(path.c_str(), &statbuf) < 0) {
		MyBase::SetDiagMsg("GetAppPath() return : empty (path does not exist)");
		return("");
	}

	MyBase::SetDiagMsg("GetAppPath() return : %s", path.c_str());
	return(path);	
}
