create table PS_SCRAPER_TYPE_REF
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  NAME          TEXT NOT NULL
);

create table PS_NAMESPACE
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  NAME          TEXT NOT NULL UNIQUE
);

create table PS_CONFIG
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  NAME          TEXT NOT NULL,
  VALUE         TEXT NOT NULL
);

create table PS_RAW_DATA
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  SRC           TEXT NOT NULL,
  NS_ID         INTEGER NOT NULL,
  FIRST_SEEN    INTEGER NOT NULL,
  LAST_SEEN     INTEGER NOT NULL,
  SIG           TEXT NOT NULL,
  NAME          TEXT NOT NULL,
  RAW_DATA      TEXT NOT NULL
);
create index PS_RAW_DATA_SRC_IDX on PS_RAW_DATA (SRC);
create index PS_RAW_DATA_NS_ID_IDX on PS_RAW_DATA (NS_ID);
create index PS_RAW_DATA_NAME_IDX on PS_RAW_DATA (NAME);
-- create index PS_RAW_DATA_RAW_DATA_IDX on PS_RAW_DATA (RAW_DATA);

create table PS_RAW_REV_DATA
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  RAW_ID        INTEGER NOT NULL,
  SIG           TEXT NOT NULL,
  FOREIGN KEY (RAW_ID) REFERENCES PS_RAW_DATA(ID)
);
create index PS_RAW_REV_DATA_RAW_ID_IDX on PS_RAW_REV_DATA (RAW_ID);

create table PS_PROC_DATA
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  SCRAPER_ID    INTEGER NOT NULL,
  SCR_PARAM_ID  INTEGER,
  NS_ID         INTEGER NOT NULL,
  PROC_TYPE     TEXT NOT NULL,
  NAME          TEXT NOT NULL,
  FIRST_SEEN    INTEGER NOT NULL,
  LAST_SEEN     INTEGER NOT NULL,
  SIG           TEXT NOT NULL,
  PROC_DATA     TEXT NOT NULL,
  FOREIGN KEY (SCRAPER_ID) REFERENCES PS_SCRAPER(ID),
  FOREIGN KEY (SCR_PARAM_ID) REFERENCES PS_SCRAPER_PARAM(ID)
);
-- create index PS_PROC_DATA_SCRAPER_ID_IDX on PS_PROC_DATA(SCRAPER_ID);
create index PS_PROC_DATA_NS_ID_IDX on PS_PROC_DATA(NS_ID);
create index PS_PROC_DATA_PROC_TYPE_IDX on PS_PROC_DATA(PROC_TYPE);
create index PS_PROC_DATA_NAME_IDX on PS_PROC_DATA(NAME);

create table PS_PROC_RAW_REL
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  PROC_ID       INTEGER NOT NULL,
  RAW_ID        INTEGER NOT NULL,
  FOREIGN KEY (PROC_ID) REFERENCES PS_PROC_DATA(ID),
  FOREIGN KEY (RAW_ID) REFERENCES PS_RAW_DATA(ID)
);
create index PS_PROC_RAW_REL_PROC_ID_IDX on PS_PROC_RAW_REL (PROC_ID);
-- create index PS_PROC_RAW_REL_RAW_ID_IDX on PS_PROC_RAW_REL (RAW_ID);

create table PS_PROC_SELF_REL
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  PRE_ID        INTEGER NOT NULL,
  POST_ID       INTEGER NOT NULL
-- ,
--  FOREIGN KEY (PRE_ID) REFERENCES PS_PROC_DATA(PROC_ID),
--  FOREIGN KEY (POST_ID) REFERENCES PS_PROC_DATA(PROC_ID)
);
-- create index PS_PROC_SELF_REL_PRE_ID_IDX on PS_PROC_SELF_REL (PRE_ID);
create index PS_PROC_SELF_REL_POST_ID_IDX on PS_PROC_SELF_REL (POST_ID);

create table PS_PROC_REV_DATA
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  PROC_ID       INTEGER NOT NULL,
  SIG           TEXT NOT NULL
-- ,
--  FOREIGN KEY (PROC_ID) REFERENCES PS_PROC_DATA(ID)
);
create index PS_PROC_REV_DATA_PROC_ID_IDX on PS_PROC_REV_DATA (PROC_ID);

create table PS_SCRAPER
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  TYPE_ID       INTEGER NOT NULL,
  DESCRIPTION   TEXT,
  SIG           TEXT,
  SCRAPER       BLOB NOT NULL,
  FOREIGN KEY (TYPE_ID) REFERENCES PS_SCRAPER_TYPE_REF(ID)
);

create table PS_SCRAPER_PARAM
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  VALUE         TEXT NOT NULL
);

create table PS_FRIEND
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  URL           TEXT NOT NULL,
  NAME          TEXT NOT NULL,
  WEB_USER      TEXT,
  PASSWD        TEXT,
  FIRST_SEEN    INTEGER NOT NULL,
  LAST_SEEN     INTEGER NOT NULL,
  PUB_KEY       TEXT NOT NULL
);

create table PS_LOCAL_KEY
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  NAME          TEXT NOT NULL,
  PUB_KEY       TEXT,
  PRIV_KEY      TEXT,
  PHRASE        TEXT
);

create table DNSKEY_URL_MON_LIST
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  SCRAPER_ID    INTEGER NOT NULL,
  SCR_PARAM_ID  INTEGER,
  SRC           TEXT NOT NULL UNIQUE,
  NAME          TEXT NOT NULL,
  FIRST_POLL    INTEGER NOT NULL,
  LAST_POLL     INTEGER NOT NULL DEFAULT 0,
  NEXT_POLL     INTEGER NOT NULL DEFAULT 0,
  SUB_SRC       INTEGER NOT NULL,
  FOREIGN KEY (SCRAPER_ID) REFERENCES PS_SCRAPER(ID),
  FOREIGN KEY (SCR_PARAM_ID) REFERENCES PS_SCRAPER_PARAM(ID)
);

create table DNSKEY_RUN_STATS
(
  ID            INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
  START_TIME    INTEGER NOT NULL,
  STOP_TIME     INTEGER NOT NULL
);

