/* valacharacterliteral.c generated by valac, the Vala compiler
 * generated from valacharacterliteral.vala, do not modify */

/* valacharacterliteral.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2009  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaCharacterLiteralPrivate {
	gchar* _value;
};

static gint ValaCharacterLiteral_private_offset;
static gpointer vala_character_literal_parent_class = NULL;

static void vala_character_literal_set_value (ValaCharacterLiteral* self,
                                       const gchar* value);
static void vala_character_literal_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_character_literal_real_is_pure (ValaExpression* base);
static gchar* vala_character_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_character_literal_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_character_literal_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_character_literal_finalize (ValaCodeNode * obj);
static GType vala_character_literal_get_type_once (void);

static inline gpointer
vala_character_literal_get_instance_private (ValaCharacterLiteral* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCharacterLiteral_private_offset);
}

const gchar*
vala_character_literal_get_value (ValaCharacterLiteral* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
vala_character_literal_set_value (ValaCharacterLiteral* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	if (!g_utf8_validate (value, (gssize) -1, NULL)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
}

/**
 * Creates a new character literal.
 *
 * @param c      character
 * @param source reference to source code
 * @return       newly created character literal
 */
ValaCharacterLiteral*
vala_character_literal_construct (GType object_type,
                                  const gchar* c,
                                  ValaSourceReference* source)
{
	ValaCharacterLiteral* self = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	self = (ValaCharacterLiteral*) vala_literal_construct (object_type);
	vala_character_literal_set_value (self, c);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaCharacterLiteral*
vala_character_literal_new (const gchar* c,
                            ValaSourceReference* source)
{
	return vala_character_literal_construct (VALA_TYPE_CHARACTER_LITERAL, c, source);
}

static void
vala_character_literal_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaCharacterLiteral * self;
	self = (ValaCharacterLiteral*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_character_literal (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

/**
 * Returns the unicode character value this character literal
 * represents.
 *
 * @return unicode character value
 */
static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

gunichar
vala_character_literal_get_char (ValaCharacterLiteral* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = vala_character_literal_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_next_char (_tmp1_);
	result = string_get_char (_tmp2_, (glong) 0);
	return result;
}

static gboolean
vala_character_literal_real_is_pure (ValaExpression* base)
{
	ValaCharacterLiteral * self;
	gboolean result;
	self = (ValaCharacterLiteral*) base;
	result = TRUE;
	return result;
}

static gchar*
vala_character_literal_real_to_string (ValaCodeNode* base)
{
	ValaCharacterLiteral * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (ValaCharacterLiteral*) base;
	_tmp0_ = vala_character_literal_get_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
vala_character_literal_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaCharacterLiteral * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean result;
	self = (ValaCharacterLiteral*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (vala_character_literal_get_char (self) < ((gunichar) 128)) {
		ValaSemanticAnalyzer* _tmp4_;
		ValaSemanticAnalyzer* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp4_ = vala_code_context_get_analyzer (context);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->char_type;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp8_);
		_vala_code_node_unref0 (_tmp8_);
	} else {
		ValaSemanticAnalyzer* _tmp9_;
		ValaSemanticAnalyzer* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp9_ = vala_code_context_get_analyzer (context);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->unichar_type;
		_tmp12_ = vala_data_type_copy (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp13_);
		_vala_code_node_unref0 (_tmp13_);
	}
	_tmp14_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	result = !_tmp15_;
	return result;
}

static void
vala_character_literal_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaCharacterLiteral * self;
	self = (ValaCharacterLiteral*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_character_literal ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_character_literal_class_init (ValaCharacterLiteralClass * klass,
                                   gpointer klass_data)
{
	vala_character_literal_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_character_literal_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCharacterLiteral_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_character_literal_real_accept;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_character_literal_real_is_pure;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_character_literal_real_to_string;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_character_literal_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_character_literal_real_emit;
}

static void
vala_character_literal_instance_init (ValaCharacterLiteral * self,
                                      gpointer klass)
{
	self->priv = vala_character_literal_get_instance_private (self);
}

static void
vala_character_literal_finalize (ValaCodeNode * obj)
{
	ValaCharacterLiteral * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral);
	_g_free0 (self->priv->_value);
	VALA_CODE_NODE_CLASS (vala_character_literal_parent_class)->finalize (obj);
}

/**
 * Represents a single literal character.
 */
static GType
vala_character_literal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCharacterLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_character_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCharacterLiteral), 0, (GInstanceInitFunc) vala_character_literal_instance_init, NULL };
	GType vala_character_literal_type_id;
	vala_character_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaCharacterLiteral", &g_define_type_info, 0);
	ValaCharacterLiteral_private_offset = g_type_add_instance_private (vala_character_literal_type_id, sizeof (ValaCharacterLiteralPrivate));
	return vala_character_literal_type_id;
}

GType
vala_character_literal_get_type (void)
{
	static volatile gsize vala_character_literal_type_id__once = 0;
	if (g_once_init_enter (&vala_character_literal_type_id__once)) {
		GType vala_character_literal_type_id;
		vala_character_literal_type_id = vala_character_literal_get_type_once ();
		g_once_init_leave (&vala_character_literal_type_id__once, vala_character_literal_type_id);
	}
	return vala_character_literal_type_id__once;
}

