/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

static ValaExpression*
vala_method_call_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaMethodCall* self;
	ValaExpression* _tmp0_;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

static gboolean
vala_method_call_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_real_set_is_chainup (ValaCallableExpression* base,
                                      gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	_tmp0_ = _vala_code_node_ref0 (call);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		ValaExpression* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (new_node);
		_vala_code_node_unref0 (self->priv->_call);
		self->priv->_call = _tmp2_;
	}
	_tmp3_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp3_, old_node);
	if (index >= 0) {
		ValaList* _tmp4_;
		_tmp4_ = self->priv->argument_list;
		vala_list_set (_tmp4_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		ValaDataType* _tmp23_;
		_tmp23_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			_tmp24_ = mtype;
			_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = VALA_IS_CLASS (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			ValaMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp27_ = mtype;
			_tmp28_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp29_ = _tmp28_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_CLASS, ValaClass);
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			m = (ValaMethod*) _tmp32_;
			_tmp33_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
		} else {
			ValaDataType* _tmp34_;
			_tmp34_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp34_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp35_;
				ValaDelegate* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				_tmp35_ = mtype;
				_tmp36_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp37_ = _tmp36_;
				d = _tmp37_;
				_tmp38_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp38_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp39_;
		gint _expr_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _expr_index = 0;
		_tmp39_ = self->priv->argument_list;
		_expr_list = _tmp39_;
		_tmp40_ = _expr_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_expr_size = _tmp42_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaExpression* expr = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_expr_index = _expr_index + 1;
			_tmp43_ = _expr_index;
			_tmp44_ = _expr_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _expr_list;
			_tmp46_ = vala_list_get (_tmp45_, _expr_index);
			expr = (ValaExpression*) _tmp46_;
			_tmp47_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp47_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp111_;
	ValaExpression* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean _tmp116_ = FALSE;
	ValaProfile _tmp117_;
	ValaProfile _tmp118_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp144_;
	gboolean _tmp145_;
	gboolean _tmp247_ = FALSE;
	ValaExpression* _tmp248_;
	ValaExpression* _tmp249_;
	gboolean _tmp324_ = FALSE;
	gboolean _tmp325_;
	gboolean _tmp326_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp341_;
	ValaDataType* _tmp342_;
	ValaDataType* _tmp343_;
	ValaList* params = NULL;
	ValaDataType* _tmp344_;
	ValaList* _tmp345_;
	ValaList* _tmp346_;
	ValaDataType* _tmp347_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp409_;
	ValaIterator* _tmp410_;
	gboolean _tmp460_ = FALSE;
	ValaDataType* _tmp461_;
	gboolean _tmp482_ = FALSE;
	ValaDataType* _tmp483_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp563_ = FALSE;
	gboolean _tmp564_;
	gboolean _tmp565_;
	ValaDataType* _tmp585_;
	ValaDataType* _tmp596_;
	ValaDataType* _tmp597_;
	ValaDataType* _tmp598_;
	ValaDataType* _tmp599_;
	ValaDataType* _tmp600_;
	ValaDataType* _tmp601_;
	ValaList* _tmp602_;
	ValaDataType* _tmp603_;
	ValaDataType* _tmp604_;
	gboolean _tmp605_;
	gboolean _tmp606_;
	ValaDataType* _tmp629_;
	ValaSemanticAnalyzer* _tmp872_;
	ValaSemanticAnalyzer* _tmp873_;
	ValaDataType* _tmp874_;
	ValaList* _tmp875_;
	ValaList* _tmp876_;
	gboolean _tmp903_ = FALSE;
	gboolean _tmp904_ = FALSE;
	ValaCreationMethod* _tmp905_;
	ValaDataType* _tmp933_;
	ValaDataType* _tmp934_;
	gboolean _tmp935_;
	gboolean _tmp936_;
	gboolean _tmp997_;
	gboolean _tmp998_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				ValaAttribute* _tmp102_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp101_, "Assert");
				_tmp95_ = _tmp102_ != NULL;
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp103_ = self->priv->argument_list;
				_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
				_tmp105_ = _tmp104_;
				if (_tmp105_ == 1) {
					ValaList* _tmp106_;
					gpointer _tmp107_;
					ValaExpression* _tmp108_;
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp106_ = self->priv->argument_list;
					_tmp107_ = vala_list_get (_tmp106_, 0);
					_tmp108_ = (ValaExpression*) _tmp107_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp108_);
					_tmp110_ = _tmp109_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp110_);
					_vala_code_node_unref0 (_tmp108_);
				}
			}
		}
	}
	_tmp111_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vala_expression_get_value_type (_tmp112_);
	_tmp114_ = _tmp113_;
	_tmp115_ = _vala_code_node_ref0 (_tmp114_);
	mtype = _tmp115_;
	_tmp117_ = vala_code_context_get_profile (context);
	_tmp118_ = _tmp117_;
	if (_tmp118_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSymbol* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSemanticAnalyzer* _tmp124_;
		ValaClass* _tmp125_;
		_tmp119_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_symbol_reference (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_code_context_get_analyzer (context);
		_tmp124_ = _tmp123_;
		_tmp125_ = _tmp124_->object_type;
		_tmp116_ = _tmp122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp116_ = FALSE;
	}
	gobject_chainup = _tmp116_;
	vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp126_;
		ValaExpression* _tmp127_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp128_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		gboolean _tmp138_ = FALSE;
		ValaMemberAccess* _tmp139_;
		_tmp126_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp127_ = _tmp126_;
		expr = _tmp127_;
		_tmp128_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			ValaSymbol* _tmp132_;
			ValaSymbol* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = VALA_IS_CREATION_METHOD (_tmp133_);
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			ValaMemberAccess* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp134_ = ma;
			_tmp135_ = vala_member_access_get_inner (_tmp134_);
			_tmp136_ = _tmp135_;
			expr = _tmp136_;
			_tmp137_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL;
		}
		_tmp139_ = ma;
		if (_tmp139_ != NULL) {
			ValaMemberAccess* _tmp140_;
			const gchar* _tmp141_;
			const gchar* _tmp142_;
			_tmp140_ = ma;
			_tmp141_ = vala_member_access_get_member_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp138_ = g_strcmp0 (_tmp142_, "this") == 0;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
		} else {
			ValaExpression* _tmp143_;
			_tmp143_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp143_)) {
				vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp144_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp145_ = _tmp144_;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp157_;
		ValaDataType* _tmp158_;
		gboolean _tmp227_ = FALSE;
		gboolean _tmp228_ = FALSE;
		ValaCreationMethod* _tmp229_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		cm = VALA_IS_CREATION_METHOD (_tmp148_) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		_tmp149_ = cm;
		if (_tmp149_ == NULL) {
			ValaSourceReference* _tmp150_;
			ValaSourceReference* _tmp151_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp151_ = _tmp150_;
			vala_report_error (_tmp151_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp152_;
			gboolean _tmp153_;
			gboolean _tmp154_;
			_tmp152_ = cm;
			_tmp153_ = vala_creation_method_get_chain_up (_tmp152_);
			_tmp154_ = _tmp153_;
			if (_tmp154_) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				vala_report_error (_tmp156_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp157_ = cm;
		vala_creation_method_set_chain_up (_tmp157_, TRUE);
		_tmp158_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp158_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaTypeSymbol* _tmp161_;
			ValaClass* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			ValaCreationMethod* _tmp165_;
			_tmp159_ = mtype;
			_tmp160_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp161_ = _tmp160_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, VALA_TYPE_CLASS, ValaClass);
			_tmp162_ = cl;
			_tmp163_ = vala_class_get_default_construction_method (_tmp162_);
			_tmp164_ = _tmp163_;
			base_cm = _tmp164_;
			_tmp165_ = base_cm;
			if (_tmp165_ == NULL) {
				ValaSourceReference* _tmp166_;
				ValaSourceReference* _tmp167_;
				ValaClass* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = cl;
				_tmp169_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp168_);
				_tmp170_ = _tmp169_;
				vala_report_error (_tmp167_, "chain up to `%s' not supported", _tmp170_);
				_g_free0 (_tmp170_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp173_;
				_tmp171_ = base_cm;
				_tmp172_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp171_);
				_tmp173_ = _tmp172_;
				if (!_tmp173_) {
					ValaSourceReference* _tmp174_;
					ValaSourceReference* _tmp175_;
					ValaCreationMethod* _tmp176_;
					gchar* _tmp177_;
					gchar* _tmp178_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp175_ = _tmp174_;
					_tmp176_ = base_cm;
					_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp176_);
					_tmp178_ = _tmp177_;
					vala_report_error (_tmp175_, "chain up to `%s' not supported", _tmp178_);
					_g_free0 (_tmp178_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp179_ = FALSE;
			ValaExpression* _tmp180_;
			ValaExpression* _tmp181_;
			ValaSymbol* _tmp182_;
			ValaSymbol* _tmp183_;
			_tmp180_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp181_ = _tmp180_;
			_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
			_tmp183_ = _tmp182_;
			if (VALA_IS_CREATION_METHOD (_tmp183_)) {
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				ValaSymbol* _tmp189_;
				_tmp184_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_expression_get_symbol_reference (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_symbol_get_parent_symbol (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp179_ = VALA_IS_CLASS (_tmp189_);
			} else {
				_tmp179_ = FALSE;
			}
			if (_tmp179_) {
				ValaExpression* _tmp190_;
				ValaExpression* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaCreationMethod* _tmp194_;
				gboolean _tmp195_;
				gboolean _tmp196_;
				_tmp190_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_expression_get_symbol_reference (_tmp191_);
				_tmp193_ = _tmp192_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp193_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp194_ = base_cm;
				_tmp195_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp194_);
				_tmp196_ = _tmp195_;
				if (!_tmp196_) {
					ValaSourceReference* _tmp197_;
					ValaSourceReference* _tmp198_;
					ValaCreationMethod* _tmp199_;
					gchar* _tmp200_;
					gchar* _tmp201_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp198_ = _tmp197_;
					_tmp199_ = base_cm;
					_tmp200_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp199_);
					_tmp201_ = _tmp200_;
					vala_report_error (_tmp198_, "chain up to `%s' not supported", _tmp201_);
					_g_free0 (_tmp201_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					gboolean _tmp205_ = FALSE;
					ValaClass* _tmp206_;
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaSemanticAnalyzer* _tmp216_;
					ValaClass* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaSourceReference* _tmp219_;
					ValaObjectType* _tmp220_;
					ValaObjectType* _tmp221_;
					ValaExpression* _tmp222_;
					ValaExpression* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					ValaDataType* _tmp226_;
					_tmp202_ = cm;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					cl = VALA_IS_CLASS (_tmp204_) ? ((ValaClass*) _tmp204_) : NULL;
					_tmp206_ = cl;
					if (_tmp206_ == NULL) {
						_tmp205_ = TRUE;
					} else {
						ValaClass* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaSemanticAnalyzer* _tmp209_;
						ValaClass* _tmp210_;
						_tmp207_ = cl;
						_tmp208_ = vala_code_context_get_analyzer (context);
						_tmp209_ = _tmp208_;
						_tmp210_ = _tmp209_->object_type;
						_tmp205_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp207_, (ValaTypeSymbol*) _tmp210_);
					}
					if (_tmp205_) {
						ValaSourceReference* _tmp211_;
						ValaSourceReference* _tmp212_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						vala_report_error (_tmp212_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp213_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_code_context_get_analyzer (context);
					_tmp216_ = _tmp215_;
					_tmp217_ = _tmp216_->object_type;
					_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp217_, _tmp219_);
					_tmp221_ = _tmp220_;
					vala_expression_set_value_type (_tmp214_, (ValaDataType*) _tmp221_);
					_vala_code_node_unref0 (_tmp221_);
					_tmp222_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_expression_get_value_type (_tmp223_);
					_tmp225_ = _tmp224_;
					_tmp226_ = _vala_code_node_ref0 (_tmp225_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp226_;
				}
			}
		}
		_tmp229_ = base_cm;
		if (_tmp229_ != NULL) {
			ValaSourceReference* _tmp230_;
			ValaSourceReference* _tmp231_;
			ValaSourceFile* _tmp232_;
			ValaSourceFile* _tmp233_;
			ValaCreationMethod* _tmp234_;
			ValaSourceReference* _tmp235_;
			ValaSourceReference* _tmp236_;
			ValaSourceFile* _tmp237_;
			ValaSourceFile* _tmp238_;
			_tmp230_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_source_reference_get_file (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp234_ = base_cm;
			_tmp235_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp234_);
			_tmp236_ = _tmp235_;
			_tmp237_ = vala_source_reference_get_file (_tmp236_);
			_tmp238_ = _tmp237_;
			_tmp228_ = _tmp233_ != _tmp238_;
		} else {
			_tmp228_ = FALSE;
		}
		if (_tmp228_) {
			ValaCreationMethod* _tmp239_;
			ValaSymbolAccessibility _tmp240_;
			ValaSymbolAccessibility _tmp241_;
			_tmp239_ = base_cm;
			_tmp240_ = vala_symbol_get_access ((ValaSymbol*) _tmp239_);
			_tmp241_ = _tmp240_;
			_tmp227_ = _tmp241_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			ValaSourceReference* _tmp242_;
			ValaSourceReference* _tmp243_;
			ValaCreationMethod* _tmp244_;
			gchar* _tmp245_;
			gchar* _tmp246_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp243_ = _tmp242_;
			_tmp244_ = base_cm;
			_tmp245_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp244_);
			_tmp246_ = _tmp245_;
			vala_report_error (_tmp243_, "chain up to private `%s' not possible", _tmp246_);
			_g_free0 (_tmp246_);
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp248_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp249_ = _tmp248_;
	if (VALA_IS_MEMBER_ACCESS (_tmp249_)) {
		gboolean _tmp250_ = FALSE;
		gboolean _tmp251_ = FALSE;
		ValaExpression* _tmp252_;
		ValaExpression* _tmp253_;
		ValaSymbol* _tmp254_;
		ValaSymbol* _tmp255_;
		_tmp252_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp253_ = _tmp252_;
		_tmp254_ = vala_expression_get_symbol_reference (_tmp253_);
		_tmp255_ = _tmp254_;
		if (VALA_IS_CREATION_METHOD (_tmp255_)) {
			ValaExpression* _tmp256_;
			ValaExpression* _tmp257_;
			ValaSymbol* _tmp258_;
			ValaSymbol* _tmp259_;
			ValaSymbol* _tmp260_;
			ValaSymbol* _tmp261_;
			_tmp256_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_expression_get_symbol_reference (_tmp257_);
			_tmp259_ = _tmp258_;
			_tmp260_ = vala_symbol_get_parent_symbol (_tmp259_);
			_tmp261_ = _tmp260_;
			_tmp251_ = VALA_IS_STRUCT (_tmp261_);
		} else {
			_tmp251_ = FALSE;
		}
		if (_tmp251_) {
			_tmp250_ = TRUE;
		} else {
			ValaExpression* _tmp262_;
			ValaExpression* _tmp263_;
			ValaSymbol* _tmp264_;
			ValaSymbol* _tmp265_;
			_tmp262_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp263_ = _tmp262_;
			_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
			_tmp265_ = _tmp264_;
			_tmp250_ = VALA_IS_STRUCT (_tmp265_);
		}
		_tmp247_ = _tmp250_;
	} else {
		_tmp247_ = FALSE;
	}
	if (_tmp247_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp266_;
		ValaExpression* _tmp267_;
		ValaSymbol* _tmp268_;
		ValaSymbol* _tmp269_;
		gboolean _tmp270_ = FALSE;
		gboolean _tmp271_ = FALSE;
		ValaStruct* _tmp272_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp283_;
		ValaExpression* _tmp284_;
		ValaSourceReference* _tmp285_;
		ValaSourceReference* _tmp286_;
		ValaObjectCreationExpression* _tmp287_;
		ValaObjectCreationExpression* _tmp288_;
		ValaObjectCreationExpression* _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		ValaObjectCreationExpression* _tmp302_;
		ValaDataType* _tmp303_;
		ValaDataType* _tmp304_;
		ValaSemanticAnalyzer* _tmp305_;
		ValaSemanticAnalyzer* _tmp306_;
		ValaList* _tmp307_;
		ValaCodeNode* _tmp308_;
		ValaCodeNode* _tmp309_;
		ValaObjectCreationExpression* _tmp310_;
		ValaObjectCreationExpression* _tmp311_;
		_tmp266_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_expression_get_symbol_reference (_tmp267_);
		_tmp269_ = _tmp268_;
		st = VALA_IS_STRUCT (_tmp269_) ? ((ValaStruct*) _tmp269_) : NULL;
		_tmp272_ = st;
		if (_tmp272_ != NULL) {
			ValaStruct* _tmp273_;
			ValaCreationMethod* _tmp274_;
			ValaCreationMethod* _tmp275_;
			_tmp273_ = st;
			_tmp274_ = vala_struct_get_default_construction_method (_tmp273_);
			_tmp275_ = _tmp274_;
			_tmp271_ = _tmp275_ == NULL;
		} else {
			_tmp271_ = FALSE;
		}
		if (_tmp271_) {
			gboolean _tmp276_ = FALSE;
			gboolean _tmp277_ = FALSE;
			ValaStruct* _tmp278_;
			_tmp278_ = st;
			if (vala_struct_is_boolean_type (_tmp278_)) {
				_tmp277_ = TRUE;
			} else {
				ValaStruct* _tmp279_;
				_tmp279_ = st;
				_tmp277_ = vala_struct_is_integer_type (_tmp279_);
			}
			if (_tmp277_) {
				_tmp276_ = TRUE;
			} else {
				ValaStruct* _tmp280_;
				_tmp280_ = st;
				_tmp276_ = vala_struct_is_floating_type (_tmp280_);
			}
			_tmp270_ = _tmp276_;
		} else {
			_tmp270_ = FALSE;
		}
		if (_tmp270_) {
			ValaSourceReference* _tmp281_;
			ValaSourceReference* _tmp282_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp281_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp282_ = _tmp281_;
			vala_report_error (_tmp282_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp283_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp284_ = _tmp283_;
		_tmp285_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp284_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp286_);
		struct_creation_expression = _tmp287_;
		_tmp288_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp288_, TRUE);
		_tmp289_ = struct_creation_expression;
		_tmp290_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp291_ = _tmp290_;
		vala_callable_expression_set_is_chainup ((ValaCallableExpression*) _tmp289_, _tmp291_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp292_;
			gint _arg_size = 0;
			ValaList* _tmp293_;
			gint _tmp294_;
			gint _tmp295_;
			gint _arg_index = 0;
			_tmp292_ = self->priv->argument_list;
			_arg_list = _tmp292_;
			_tmp293_ = _arg_list;
			_tmp294_ = vala_collection_get_size ((ValaCollection*) _tmp293_);
			_tmp295_ = _tmp294_;
			_arg_size = _tmp295_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp296_;
				gint _tmp297_;
				ValaExpression* arg = NULL;
				ValaList* _tmp298_;
				gpointer _tmp299_;
				ValaObjectCreationExpression* _tmp300_;
				ValaExpression* _tmp301_;
				_arg_index = _arg_index + 1;
				_tmp296_ = _arg_index;
				_tmp297_ = _arg_size;
				if (!(_tmp296_ < _tmp297_)) {
					break;
				}
				_tmp298_ = _arg_list;
				_tmp299_ = vala_list_get (_tmp298_, _arg_index);
				arg = (ValaExpression*) _tmp299_;
				_tmp300_ = struct_creation_expression;
				_tmp301_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp300_, _tmp301_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp302_ = struct_creation_expression;
		_tmp303_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp304_ = _tmp303_;
		vala_expression_set_target_type ((ValaExpression*) _tmp302_, _tmp304_);
		_tmp305_ = vala_code_context_get_analyzer (context);
		_tmp306_ = _tmp305_;
		_tmp307_ = _tmp306_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp307_, (ValaCodeNode*) self);
		_tmp308_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp309_ = _tmp308_;
		_tmp310_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp309_, (ValaExpression*) self, (ValaExpression*) _tmp310_);
		_tmp311_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp311_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp312_ = FALSE;
		gboolean _tmp313_ = FALSE;
		gboolean _tmp314_;
		gboolean _tmp315_;
		_tmp314_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp315_ = _tmp314_;
		if (!_tmp315_) {
			ValaExpression* _tmp316_;
			ValaExpression* _tmp317_;
			_tmp316_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp317_ = _tmp316_;
			_tmp313_ = VALA_IS_MEMBER_ACCESS (_tmp317_);
		} else {
			_tmp313_ = FALSE;
		}
		if (_tmp313_) {
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			_tmp318_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp319_ = _tmp318_;
			_tmp320_ = vala_expression_get_symbol_reference (_tmp319_);
			_tmp321_ = _tmp320_;
			_tmp312_ = VALA_IS_CREATION_METHOD (_tmp321_);
		} else {
			_tmp312_ = FALSE;
		}
		if (_tmp312_) {
			ValaSourceReference* _tmp322_;
			ValaSourceReference* _tmp323_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp323_ = _tmp322_;
			vala_report_error (_tmp323_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp325_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp326_ = _tmp325_;
	if (!_tmp326_) {
		ValaDataType* _tmp327_;
		_tmp327_ = mtype;
		_tmp324_ = VALA_IS_OBJECT_TYPE (_tmp327_);
	} else {
		_tmp324_ = FALSE;
	}
	if (_tmp324_) {
		ValaSourceReference* _tmp328_;
		ValaSourceReference* _tmp329_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp329_ = _tmp328_;
		vala_report_error (_tmp329_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp330_ = FALSE;
		ValaDataType* _tmp331_;
		_tmp331_ = mtype;
		if (_tmp331_ != NULL) {
			ValaDataType* _tmp332_;
			_tmp332_ = mtype;
			_tmp330_ = vala_data_type_is_invokable (_tmp332_);
		} else {
			_tmp330_ = FALSE;
		}
		if (_tmp330_) {
		} else {
			ValaExpression* _tmp333_;
			ValaExpression* _tmp334_;
			ValaSymbol* _tmp335_;
			ValaSymbol* _tmp336_;
			_tmp333_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp334_ = _tmp333_;
			_tmp335_ = vala_expression_get_symbol_reference (_tmp334_);
			_tmp336_ = _tmp335_;
			if (VALA_IS_CLASS (_tmp336_)) {
				ValaSourceReference* _tmp337_;
				ValaSourceReference* _tmp338_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp337_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp338_ = _tmp337_;
				vala_report_error (_tmp338_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp339_;
				ValaSourceReference* _tmp340_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp339_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp340_ = _tmp339_;
				vala_report_error (_tmp340_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp341_ = mtype;
	_tmp342_ = vala_data_type_get_return_type (_tmp341_);
	_tmp343_ = _vala_code_node_ref0 (_tmp342_);
	ret_type = _tmp343_;
	_tmp344_ = mtype;
	_tmp345_ = vala_data_type_get_parameters (_tmp344_);
	_tmp346_ = _vala_iterable_ref0 (_tmp345_);
	params = _tmp346_;
	_tmp347_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp347_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp348_;
		ValaExpression* _tmp349_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp350_;
		ValaMethod* _tmp351_;
		ValaMethod* _tmp352_;
		ValaMethod* _tmp353_;
		gboolean _tmp354_;
		gboolean _tmp355_;
		gint n_type_params = 0;
		ValaMethod* _tmp387_;
		ValaList* _tmp388_;
		gint _tmp389_;
		gint _tmp390_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp391_;
		ValaList* _tmp392_;
		gint _tmp393_;
		gint _tmp394_;
		gboolean _tmp395_ = FALSE;
		_tmp348_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp349_ = _tmp348_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp349_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp350_ = mtype;
		_tmp351_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp350_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp352_ = _tmp351_;
		m = _tmp352_;
		_tmp353_ = m;
		_tmp354_ = vala_method_get_coroutine (_tmp353_);
		_tmp355_ = _tmp354_;
		if (_tmp355_) {
			gboolean _tmp356_;
			gboolean _tmp357_;
			_tmp356_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp357_ = _tmp356_;
			if (!_tmp357_) {
				ValaMemberAccess* _tmp358_;
				const gchar* _tmp359_;
				const gchar* _tmp360_;
				_tmp358_ = ma;
				_tmp359_ = vala_member_access_get_member_name (_tmp358_);
				_tmp360_ = _tmp359_;
				if (g_strcmp0 (_tmp360_, "end") != 0) {
					ValaMemberAccess* _tmp361_;
					const gchar* _tmp362_;
					const gchar* _tmp363_;
					ValaMethod* _tmp367_;
					ValaList* _tmp368_;
					ValaList* _tmp369_;
					ValaVoidType* _tmp370_;
					_tmp361_ = ma;
					_tmp362_ = vala_member_access_get_member_name (_tmp361_);
					_tmp363_ = _tmp362_;
					if (g_strcmp0 (_tmp363_, "begin") != 0) {
						ValaMemberAccess* _tmp364_;
						ValaSourceReference* _tmp365_;
						ValaSourceReference* _tmp366_;
						_tmp364_ = ma;
						_tmp365_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp364_);
						_tmp366_ = _tmp365_;
						vala_report_deprecated (_tmp366_, "implicit .begin is deprecated");
					}
					_tmp367_ = m;
					_tmp368_ = vala_method_get_async_begin_parameters (_tmp367_);
					_tmp369_ = _vala_iterable_ref0 (_tmp368_);
					_vala_iterable_unref0 (params);
					params = _tmp369_;
					_tmp370_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp370_;
				} else {
					ValaMethod* _tmp371_;
					ValaList* _tmp372_;
					ValaList* _tmp373_;
					_tmp371_ = m;
					_tmp372_ = vala_method_get_async_end_parameters (_tmp371_);
					_tmp373_ = _vala_iterable_ref0 (_tmp372_);
					_vala_iterable_unref0 (params);
					params = _tmp373_;
				}
			} else {
				gboolean _tmp374_ = FALSE;
				ValaMemberAccess* _tmp375_;
				const gchar* _tmp376_;
				const gchar* _tmp377_;
				_tmp375_ = ma;
				_tmp376_ = vala_member_access_get_member_name (_tmp375_);
				_tmp377_ = _tmp376_;
				if (g_strcmp0 (_tmp377_, "begin") == 0) {
					_tmp374_ = TRUE;
				} else {
					ValaMemberAccess* _tmp378_;
					const gchar* _tmp379_;
					const gchar* _tmp380_;
					_tmp378_ = ma;
					_tmp379_ = vala_member_access_get_member_name (_tmp378_);
					_tmp380_ = _tmp379_;
					_tmp374_ = g_strcmp0 (_tmp380_, "end") == 0;
				}
				if (_tmp374_) {
					ValaMemberAccess* _tmp381_;
					ValaSourceReference* _tmp382_;
					ValaSourceReference* _tmp383_;
					ValaMemberAccess* _tmp384_;
					const gchar* _tmp385_;
					const gchar* _tmp386_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp381_ = ma;
					_tmp382_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp381_);
					_tmp383_ = _tmp382_;
					_tmp384_ = ma;
					_tmp385_ = vala_member_access_get_member_name (_tmp384_);
					_tmp386_ = _tmp385_;
					vala_report_error (_tmp383_, "use of `%s' not allowed in yield statement", _tmp386_);
				}
			}
		}
		_tmp387_ = m;
		_tmp388_ = vala_method_get_type_parameters (_tmp387_);
		_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
		_tmp390_ = _tmp389_;
		n_type_params = _tmp390_;
		_tmp391_ = ma;
		_tmp392_ = vala_member_access_get_type_arguments (_tmp391_);
		_tmp393_ = vala_collection_get_size ((ValaCollection*) _tmp392_);
		_tmp394_ = _tmp393_;
		n_type_args = _tmp394_;
		if (n_type_args > 0) {
			_tmp395_ = n_type_args < n_type_params;
		} else {
			_tmp395_ = FALSE;
		}
		if (_tmp395_) {
			ValaMemberAccess* _tmp396_;
			ValaSourceReference* _tmp397_;
			ValaSourceReference* _tmp398_;
			ValaMethod* _tmp399_;
			gchar* _tmp400_;
			gchar* _tmp401_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp396_ = ma;
			_tmp397_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp396_);
			_tmp398_ = _tmp397_;
			_tmp399_ = m;
			_tmp400_ = vala_code_node_to_string ((ValaCodeNode*) _tmp399_);
			_tmp401_ = _tmp400_;
			vala_report_error (_tmp398_, "too few type arguments for `%s'", _tmp401_);
			_g_free0 (_tmp401_);
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp402_ = FALSE;
			if (n_type_args > 0) {
				_tmp402_ = n_type_args > n_type_params;
			} else {
				_tmp402_ = FALSE;
			}
			if (_tmp402_) {
				ValaMemberAccess* _tmp403_;
				ValaSourceReference* _tmp404_;
				ValaSourceReference* _tmp405_;
				ValaMethod* _tmp406_;
				gchar* _tmp407_;
				gchar* _tmp408_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp403_ = ma;
				_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp403_);
				_tmp405_ = _tmp404_;
				_tmp406_ = m;
				_tmp407_ = vala_code_node_to_string ((ValaCodeNode*) _tmp406_);
				_tmp408_ = _tmp407_;
				vala_report_error (_tmp405_, "too many type arguments for `%s'", _tmp408_);
				_g_free0 (_tmp408_);
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp409_ = self->priv->argument_list;
	_tmp410_ = vala_iterable_iterator ((ValaIterable*) _tmp409_);
	arg_it = _tmp410_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp411_;
		gint _param_size = 0;
		ValaList* _tmp412_;
		gint _tmp413_;
		gint _tmp414_;
		gint _param_index = 0;
		_tmp411_ = params;
		_param_list = _tmp411_;
		_tmp412_ = _param_list;
		_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
		_tmp414_ = _tmp413_;
		_param_size = _tmp414_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp415_;
			gint _tmp416_;
			ValaParameter* param = NULL;
			ValaList* _tmp417_;
			gpointer _tmp418_;
			ValaParameter* _tmp419_;
			ValaParameter* _tmp420_;
			gboolean _tmp421_;
			gboolean _tmp422_;
			ValaParameter* _tmp423_;
			gboolean _tmp424_;
			gboolean _tmp425_;
			ValaIterator* _tmp443_;
			_param_index = _param_index + 1;
			_tmp415_ = _param_index;
			_tmp416_ = _param_size;
			if (!(_tmp415_ < _tmp416_)) {
				break;
			}
			_tmp417_ = _param_list;
			_tmp418_ = vala_list_get (_tmp417_, _param_index);
			param = (ValaParameter*) _tmp418_;
			_tmp419_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp419_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp420_ = param;
			_tmp421_ = vala_parameter_get_ellipsis (_tmp420_);
			_tmp422_ = _tmp421_;
			if (_tmp422_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp423_ = param;
			_tmp424_ = vala_parameter_get_params_array (_tmp423_);
			_tmp425_ = _tmp424_;
			if (_tmp425_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp426_;
				ValaDataType* _tmp427_;
				ValaDataType* _tmp428_;
				ValaArrayType* _tmp429_;
				_tmp426_ = param;
				_tmp427_ = vala_variable_get_variable_type ((ValaVariable*) _tmp426_);
				_tmp428_ = _tmp427_;
				_tmp429_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp428_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp429_;
				while (TRUE) {
					ValaIterator* _tmp430_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp431_;
					gpointer _tmp432_;
					ValaExpression* _tmp433_;
					ValaArrayType* _tmp434_;
					ValaDataType* _tmp435_;
					ValaDataType* _tmp436_;
					ValaExpression* _tmp437_;
					ValaDataType* _tmp438_;
					ValaDataType* _tmp439_;
					ValaArrayType* _tmp440_;
					gboolean _tmp441_;
					gboolean _tmp442_;
					_tmp430_ = arg_it;
					if (!vala_iterator_next (_tmp430_)) {
						break;
					}
					_tmp431_ = arg_it;
					_tmp432_ = vala_iterator_get (_tmp431_);
					arg = (ValaExpression*) _tmp432_;
					_tmp433_ = arg;
					_tmp434_ = array_type;
					_tmp435_ = vala_array_type_get_element_type (_tmp434_);
					_tmp436_ = _tmp435_;
					vala_expression_set_target_type (_tmp433_, _tmp436_);
					_tmp437_ = arg;
					_tmp438_ = vala_expression_get_target_type (_tmp437_);
					_tmp439_ = _tmp438_;
					_tmp440_ = array_type;
					_tmp441_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp440_);
					_tmp442_ = _tmp441_;
					vala_data_type_set_value_owned (_tmp439_, _tmp442_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp443_ = arg_it;
			if (vala_iterator_next (_tmp443_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp444_;
				gpointer _tmp445_;
				ValaExpression* _tmp446_;
				ValaParameter* _tmp447_;
				ValaDataType* _tmp448_;
				ValaDataType* _tmp449_;
				ValaExpression* _tmp450_;
				ValaExpression* _tmp451_;
				ValaDataType* _tmp452_;
				ValaDataType* _tmp453_;
				ValaDataType* _tmp454_;
				ValaList* _tmp455_;
				ValaDataType* _tmp456_;
				ValaDataType* _tmp457_;
				ValaExpression* _tmp458_;
				ValaExpression* _tmp459_;
				_tmp444_ = arg_it;
				_tmp445_ = vala_iterator_get (_tmp444_);
				arg = (ValaExpression*) _tmp445_;
				_tmp446_ = arg;
				_tmp447_ = param;
				_tmp448_ = vala_variable_get_variable_type ((ValaVariable*) _tmp447_);
				_tmp449_ = _tmp448_;
				vala_expression_set_formal_target_type (_tmp446_, _tmp449_);
				_tmp450_ = arg;
				_tmp451_ = arg;
				_tmp452_ = vala_expression_get_formal_target_type (_tmp451_);
				_tmp453_ = _tmp452_;
				_tmp454_ = target_object_type;
				_tmp455_ = method_type_args;
				_tmp456_ = vala_data_type_get_actual_type (_tmp453_, _tmp454_, _tmp455_, (ValaCodeNode*) self);
				_tmp457_ = _tmp456_;
				vala_expression_set_target_type (_tmp450_, _tmp457_);
				_vala_code_node_unref0 (_tmp457_);
				_tmp458_ = arg;
				_tmp459_ = _vala_code_node_ref0 (_tmp458_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp459_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp461_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp461_)) {
		ValaDataType* _tmp462_;
		ValaMethod* _tmp463_;
		ValaMethod* _tmp464_;
		ValaAttribute* _tmp465_;
		_tmp462_ = mtype;
		_tmp463_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp464_ = _tmp463_;
		_tmp465_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp464_, "Print");
		_tmp460_ = _tmp465_ != NULL;
	} else {
		_tmp460_ = FALSE;
	}
	if (_tmp460_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp466_;
		ValaSourceReference* _tmp467_;
		ValaTemplate* _tmp468_;
		ValaList* _tmp480_;
		ValaTemplate* _tmp481_;
		_tmp466_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_template_new (_tmp467_);
		template = _tmp468_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp469_;
			gint _arg_size = 0;
			ValaList* _tmp470_;
			gint _tmp471_;
			gint _tmp472_;
			gint _arg_index = 0;
			_tmp469_ = self->priv->argument_list;
			_arg_list = _tmp469_;
			_tmp470_ = _arg_list;
			_tmp471_ = vala_collection_get_size ((ValaCollection*) _tmp470_);
			_tmp472_ = _tmp471_;
			_arg_size = _tmp472_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp473_;
				gint _tmp474_;
				ValaExpression* arg = NULL;
				ValaList* _tmp475_;
				gpointer _tmp476_;
				ValaExpression* _tmp477_;
				ValaTemplate* _tmp478_;
				ValaExpression* _tmp479_;
				_arg_index = _arg_index + 1;
				_tmp473_ = _arg_index;
				_tmp474_ = _arg_size;
				if (!(_tmp473_ < _tmp474_)) {
					break;
				}
				_tmp475_ = _arg_list;
				_tmp476_ = vala_list_get (_tmp475_, _arg_index);
				arg = (ValaExpression*) _tmp476_;
				_tmp477_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp477_, NULL);
				_tmp478_ = template;
				_tmp479_ = arg;
				vala_template_add_expression (_tmp478_, _tmp479_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp480_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp480_);
		_tmp481_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp481_);
		_vala_code_node_unref0 (template);
	}
	_tmp483_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp483_)) {
		ValaDataType* _tmp484_;
		ValaMethod* _tmp485_;
		ValaMethod* _tmp486_;
		gboolean _tmp487_;
		gboolean _tmp488_;
		_tmp484_ = mtype;
		_tmp485_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp484_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp486_ = _tmp485_;
		_tmp487_ = vala_method_get_printf_format (_tmp486_);
		_tmp488_ = _tmp487_;
		_tmp482_ = _tmp488_;
	} else {
		_tmp482_ = FALSE;
	}
	if (_tmp482_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp489_;
		ValaStringLiteral* _tmp538_;
		format_literal = NULL;
		_tmp489_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp489_)) {
		} else {
			ValaExpression* _tmp490_;
			_tmp490_ = last_arg;
			if (_tmp490_ != NULL) {
				ValaExpression* _tmp491_;
				ValaStringLiteral* _tmp492_;
				gboolean _tmp493_ = FALSE;
				ValaStringLiteral* _tmp494_;
				_tmp491_ = last_arg;
				_tmp492_ = vala_string_literal_get_format_literal (_tmp491_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp492_;
				_tmp494_ = format_literal;
				if (_tmp494_ == NULL) {
					ValaList* _tmp495_;
					gint _tmp496_;
					gint _tmp497_;
					ValaList* _tmp498_;
					gint _tmp499_;
					gint _tmp500_;
					_tmp495_ = self->priv->argument_list;
					_tmp496_ = vala_collection_get_size ((ValaCollection*) _tmp495_);
					_tmp497_ = _tmp496_;
					_tmp498_ = params;
					_tmp499_ = vala_collection_get_size ((ValaCollection*) _tmp498_);
					_tmp500_ = _tmp499_;
					_tmp493_ = _tmp497_ == (_tmp500_ - 1);
				} else {
					_tmp493_ = FALSE;
				}
				if (_tmp493_) {
					ValaStringLiteral* _tmp501_;
					ValaStringLiteral* _tmp502_;
					ValaSemanticAnalyzer* _tmp503_;
					ValaSemanticAnalyzer* _tmp504_;
					ValaDataType* _tmp505_;
					ValaDataType* _tmp506_;
					ValaDataType* _tmp507_;
					ValaList* _tmp508_;
					ValaList* _tmp509_;
					gint _tmp510_;
					gint _tmp511_;
					ValaStringLiteral* _tmp512_;
					ValaList* _tmp513_;
					ValaIterator* _tmp514_;
					_tmp501_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp501_;
					_tmp502_ = format_literal;
					_tmp503_ = vala_code_context_get_analyzer (context);
					_tmp504_ = _tmp503_;
					_tmp505_ = _tmp504_->string_type;
					_tmp506_ = vala_data_type_copy (_tmp505_);
					_tmp507_ = _tmp506_;
					vala_expression_set_target_type ((ValaExpression*) _tmp502_, _tmp507_);
					_vala_code_node_unref0 (_tmp507_);
					_tmp508_ = self->priv->argument_list;
					_tmp509_ = self->priv->argument_list;
					_tmp510_ = vala_collection_get_size ((ValaCollection*) _tmp509_);
					_tmp511_ = _tmp510_;
					_tmp512_ = format_literal;
					vala_list_insert (_tmp508_, _tmp511_ - 1, (ValaExpression*) _tmp512_);
					_tmp513_ = self->priv->argument_list;
					_tmp514_ = vala_iterable_iterator ((ValaIterable*) _tmp513_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp514_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp515_;
						gint _param_size = 0;
						ValaList* _tmp516_;
						gint _tmp517_;
						gint _tmp518_;
						gint _param_index = 0;
						_tmp515_ = params;
						_param_list = _tmp515_;
						_tmp516_ = _param_list;
						_tmp517_ = vala_collection_get_size ((ValaCollection*) _tmp516_);
						_tmp518_ = _tmp517_;
						_param_size = _tmp518_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp519_;
							gint _tmp520_;
							ValaParameter* param = NULL;
							ValaList* _tmp521_;
							gpointer _tmp522_;
							gboolean _tmp523_ = FALSE;
							ValaParameter* _tmp524_;
							gboolean _tmp525_;
							gboolean _tmp526_;
							ValaIterator* _tmp530_;
							_param_index = _param_index + 1;
							_tmp519_ = _param_index;
							_tmp520_ = _param_size;
							if (!(_tmp519_ < _tmp520_)) {
								break;
							}
							_tmp521_ = _param_list;
							_tmp522_ = vala_list_get (_tmp521_, _param_index);
							param = (ValaParameter*) _tmp522_;
							_tmp524_ = param;
							_tmp525_ = vala_parameter_get_ellipsis (_tmp524_);
							_tmp526_ = _tmp525_;
							if (_tmp526_) {
								_tmp523_ = TRUE;
							} else {
								ValaParameter* _tmp527_;
								gboolean _tmp528_;
								gboolean _tmp529_;
								_tmp527_ = param;
								_tmp528_ = vala_parameter_get_params_array (_tmp527_);
								_tmp529_ = _tmp528_;
								_tmp523_ = _tmp529_;
							}
							if (_tmp523_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp530_ = arg_it;
							vala_iterator_next (_tmp530_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaMemberAccess* _tmp533_;
				_tmp531_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp532_ = _tmp531_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp532_) ? ((ValaMemberAccess*) _tmp532_) : NULL;
				_tmp533_ = ma;
				if (_tmp533_ != NULL) {
					ValaMemberAccess* _tmp534_;
					ValaExpression* _tmp535_;
					ValaExpression* _tmp536_;
					ValaStringLiteral* _tmp537_;
					_tmp534_ = ma;
					_tmp535_ = vala_member_access_get_inner (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_string_literal_get_format_literal (_tmp536_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp537_;
				}
			}
		}
		_tmp538_ = format_literal;
		if (_tmp538_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp539_;
			gchar* _tmp540_;
			ValaSemanticAnalyzer* _tmp541_;
			ValaSemanticAnalyzer* _tmp542_;
			const gchar* _tmp543_;
			ValaIterator* _tmp544_;
			ValaSourceReference* _tmp545_;
			ValaSourceReference* _tmp546_;
			_tmp539_ = format_literal;
			_tmp540_ = vala_string_literal_eval (_tmp539_);
			format = _tmp540_;
			_tmp541_ = vala_code_context_get_analyzer (context);
			_tmp542_ = _tmp541_;
			_tmp543_ = format;
			_tmp544_ = arg_it;
			_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp546_ = _tmp545_;
			if (!vala_semantic_analyzer_check_print_format (_tmp542_, _tmp543_, _tmp544_, _tmp546_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp547_;
		gint _arg_size = 0;
		ValaList* _tmp548_;
		gint _tmp549_;
		gint _tmp550_;
		gint _arg_index = 0;
		_tmp547_ = self->priv->argument_list;
		_arg_list = _tmp547_;
		_tmp548_ = _arg_list;
		_tmp549_ = vala_collection_get_size ((ValaCollection*) _tmp548_);
		_tmp550_ = _tmp549_;
		_arg_size = _tmp550_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp551_;
			gint _tmp552_;
			ValaExpression* arg = NULL;
			ValaList* _tmp553_;
			gpointer _tmp554_;
			ValaExpression* _tmp555_;
			gboolean _tmp556_ = FALSE;
			ValaExpression* _tmp557_;
			_arg_index = _arg_index + 1;
			_tmp551_ = _arg_index;
			_tmp552_ = _arg_size;
			if (!(_tmp551_ < _tmp552_)) {
				break;
			}
			_tmp553_ = _arg_list;
			_tmp554_ = vala_list_get (_tmp553_, _arg_index);
			arg = (ValaExpression*) _tmp554_;
			_tmp555_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp555_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp557_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp557_)) {
				ValaExpression* _tmp558_;
				ValaMethod* _tmp559_;
				ValaMethod* _tmp560_;
				gboolean _tmp561_;
				gboolean _tmp562_;
				_tmp558_ = arg;
				_tmp559_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp558_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp560_ = _tmp559_;
				_tmp561_ = vala_method_get_closure (_tmp560_);
				_tmp562_ = _tmp561_;
				_tmp556_ = _tmp562_;
			} else {
				_tmp556_ = FALSE;
			}
			if (_tmp556_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp564_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp565_ = _tmp564_;
	if (!_tmp565_) {
		_tmp563_ = force_lambda_method_closure;
	} else {
		_tmp563_ = FALSE;
	}
	if (_tmp563_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp566_;
			gint _arg_size = 0;
			ValaList* _tmp567_;
			gint _tmp568_;
			gint _tmp569_;
			gint _arg_index = 0;
			_tmp566_ = self->priv->argument_list;
			_arg_list = _tmp566_;
			_tmp567_ = _arg_list;
			_tmp568_ = vala_collection_get_size ((ValaCollection*) _tmp567_);
			_tmp569_ = _tmp568_;
			_arg_size = _tmp569_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp570_;
				gint _tmp571_;
				ValaExpression* arg = NULL;
				ValaList* _tmp572_;
				gpointer _tmp573_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp574_;
				gboolean _tmp575_ = FALSE;
				ValaLambdaExpression* _tmp576_;
				_arg_index = _arg_index + 1;
				_tmp570_ = _arg_index;
				_tmp571_ = _arg_size;
				if (!(_tmp570_ < _tmp571_)) {
					break;
				}
				_tmp572_ = _arg_list;
				_tmp573_ = vala_list_get (_tmp572_, _arg_index);
				arg = (ValaExpression*) _tmp573_;
				_tmp574_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp574_) ? ((ValaLambdaExpression*) _tmp574_) : NULL;
				_tmp576_ = lambda;
				if (_tmp576_ != NULL) {
					ValaLambdaExpression* _tmp577_;
					ValaMethod* _tmp578_;
					ValaMethod* _tmp579_;
					ValaMemberBinding _tmp580_;
					ValaMemberBinding _tmp581_;
					_tmp577_ = lambda;
					_tmp578_ = vala_lambda_expression_get_method (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp580_ = vala_method_get_binding (_tmp579_);
					_tmp581_ = _tmp580_;
					_tmp575_ = _tmp581_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp575_ = FALSE;
				}
				if (_tmp575_) {
					ValaLambdaExpression* _tmp582_;
					ValaMethod* _tmp583_;
					ValaMethod* _tmp584_;
					_tmp582_ = lambda;
					_tmp583_ = vala_lambda_expression_get_method (_tmp582_);
					_tmp584_ = _tmp583_;
					vala_method_set_closure (_tmp584_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp585_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp585_)) {
		gboolean _tmp586_ = FALSE;
		gboolean _tmp587_ = FALSE;
		ValaCodeNode* _tmp588_;
		ValaCodeNode* _tmp589_;
		_tmp588_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp589_ = _tmp588_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp589_)) {
			ValaCodeNode* _tmp590_;
			ValaCodeNode* _tmp591_;
			_tmp590_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp591_ = _tmp590_;
			_tmp587_ = !VALA_IS_FOR_STATEMENT (_tmp591_);
		} else {
			_tmp587_ = FALSE;
		}
		if (_tmp587_) {
			ValaCodeNode* _tmp592_;
			ValaCodeNode* _tmp593_;
			_tmp592_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp593_ = _tmp592_;
			_tmp586_ = !VALA_IS_YIELD_STATEMENT (_tmp593_);
		} else {
			_tmp586_ = FALSE;
		}
		if (_tmp586_) {
			ValaSourceReference* _tmp594_;
			ValaSourceReference* _tmp595_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp595_ = _tmp594_;
			vala_report_error (_tmp595_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp596_ = ret_type;
	_tmp597_ = vala_data_type_copy (_tmp596_);
	_tmp598_ = _tmp597_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp598_);
	_vala_code_node_unref0 (_tmp598_);
	_tmp599_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp600_ = _tmp599_;
	_tmp601_ = target_object_type;
	_tmp602_ = method_type_args;
	_tmp603_ = vala_data_type_get_actual_type (_tmp600_, _tmp601_, _tmp602_, (ValaCodeNode*) self);
	_tmp604_ = _tmp603_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp604_);
	_vala_code_node_unref0 (_tmp604_);
	_tmp605_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp606_ = _tmp605_;
	if (_tmp606_) {
		gboolean _tmp607_ = FALSE;
		ValaDataType* _tmp608_;
		gboolean _tmp616_ = FALSE;
		ValaSemanticAnalyzer* _tmp617_;
		ValaSemanticAnalyzer* _tmp618_;
		ValaMethod* _tmp619_;
		ValaMethod* _tmp620_;
		_tmp608_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp608_)) {
			_tmp607_ = TRUE;
		} else {
			ValaDataType* _tmp609_;
			ValaMethod* _tmp610_;
			ValaMethod* _tmp611_;
			gboolean _tmp612_;
			gboolean _tmp613_;
			_tmp609_ = mtype;
			_tmp610_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp609_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp611_ = _tmp610_;
			_tmp612_ = vala_method_get_coroutine (_tmp611_);
			_tmp613_ = _tmp612_;
			_tmp607_ = !_tmp613_;
		}
		if (_tmp607_) {
			ValaSourceReference* _tmp614_;
			ValaSourceReference* _tmp615_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp614_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp615_ = _tmp614_;
			vala_report_error (_tmp615_, "yield expression requires async method");
		}
		_tmp617_ = vala_code_context_get_analyzer (context);
		_tmp618_ = _tmp617_;
		_tmp619_ = vala_semantic_analyzer_get_current_method (_tmp618_);
		_tmp620_ = _tmp619_;
		if (_tmp620_ == NULL) {
			_tmp616_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp621_;
			ValaSemanticAnalyzer* _tmp622_;
			ValaMethod* _tmp623_;
			ValaMethod* _tmp624_;
			gboolean _tmp625_;
			gboolean _tmp626_;
			_tmp621_ = vala_code_context_get_analyzer (context);
			_tmp622_ = _tmp621_;
			_tmp623_ = vala_semantic_analyzer_get_current_method (_tmp622_);
			_tmp624_ = _tmp623_;
			_tmp625_ = vala_method_get_coroutine (_tmp624_);
			_tmp626_ = _tmp625_;
			_tmp616_ = !_tmp626_;
		}
		if (_tmp616_) {
			ValaSourceReference* _tmp627_;
			ValaSourceReference* _tmp628_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp627_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp628_ = _tmp627_;
			vala_report_error (_tmp628_, "yield expression not available outside async method");
		}
	}
	_tmp629_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp629_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp630_;
		ValaMethod* _tmp631_;
		ValaMethod* _tmp632_;
		ValaMethod* _tmp633_;
		gboolean _tmp634_;
		gboolean _tmp635_;
		ValaMethod* _tmp638_;
		gboolean _tmp639_;
		gboolean _tmp640_;
		gboolean _tmp666_ = FALSE;
		gboolean _tmp667_ = FALSE;
		gboolean _tmp668_ = FALSE;
		gboolean _tmp669_;
		gboolean _tmp670_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp682_;
		ValaSymbol* _tmp683_;
		ValaSymbol* _tmp684_;
		gboolean _tmp685_ = FALSE;
		ValaSignal* _tmp686_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp699_;
		ValaSymbol* _tmp700_;
		ValaSymbol* _tmp701_;
		gboolean _tmp702_ = FALSE;
		ValaDynamicSignal* _tmp703_;
		gboolean _tmp748_ = FALSE;
		ValaMethod* _tmp749_;
		gboolean _tmp857_ = FALSE;
		ValaMethod* _tmp858_;
		_tmp630_ = mtype;
		_tmp631_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp630_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp632_ = _tmp631_;
		m = _tmp632_;
		_tmp633_ = m;
		_tmp634_ = vala_method_get_returns_floating_reference (_tmp633_);
		_tmp635_ = _tmp634_;
		if (_tmp635_) {
			ValaDataType* _tmp636_;
			ValaDataType* _tmp637_;
			_tmp636_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp637_ = _tmp636_;
			vala_data_type_set_floating_reference (_tmp637_, TRUE);
		}
		_tmp638_ = m;
		_tmp639_ = vala_method_get_returns_modified_pointer (_tmp638_);
		_tmp640_ = _tmp639_;
		if (_tmp640_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp641_;
			ValaExpression* _tmp642_;
			ValaExpression* _tmp643_;
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp646_;
			ValaSymbol* _tmp647_;
			ValaSymbol* _tmp648_;
			gboolean _tmp649_ = FALSE;
			ValaProperty* _tmp650_;
			_tmp641_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp642_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp644_ = _tmp643_;
			inner = _tmp644_;
			_tmp645_ = inner;
			vala_expression_set_lvalue (_tmp645_, TRUE);
			_tmp646_ = inner;
			_tmp647_ = vala_expression_get_symbol_reference (_tmp646_);
			_tmp648_ = _tmp647_;
			prop = VALA_IS_PROPERTY (_tmp648_) ? ((ValaProperty*) _tmp648_) : NULL;
			_tmp650_ = prop;
			if (_tmp650_ != NULL) {
				gboolean _tmp651_ = FALSE;
				ValaProperty* _tmp652_;
				ValaPropertyAccessor* _tmp653_;
				ValaPropertyAccessor* _tmp654_;
				_tmp652_ = prop;
				_tmp653_ = vala_property_get_set_accessor (_tmp652_);
				_tmp654_ = _tmp653_;
				if (_tmp654_ == NULL) {
					_tmp651_ = TRUE;
				} else {
					ValaProperty* _tmp655_;
					ValaPropertyAccessor* _tmp656_;
					ValaPropertyAccessor* _tmp657_;
					gboolean _tmp658_;
					gboolean _tmp659_;
					_tmp655_ = prop;
					_tmp656_ = vala_property_get_set_accessor (_tmp655_);
					_tmp657_ = _tmp656_;
					_tmp658_ = vala_property_accessor_get_writable (_tmp657_);
					_tmp659_ = _tmp658_;
					_tmp651_ = !_tmp659_;
				}
				_tmp649_ = _tmp651_;
			} else {
				_tmp649_ = FALSE;
			}
			if (_tmp649_) {
				ValaExpression* _tmp660_;
				ValaSourceReference* _tmp661_;
				ValaSourceReference* _tmp662_;
				ValaProperty* _tmp663_;
				gchar* _tmp664_;
				gchar* _tmp665_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp660_ = inner;
				_tmp661_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp660_);
				_tmp662_ = _tmp661_;
				_tmp663_ = prop;
				_tmp664_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp663_);
				_tmp665_ = _tmp664_;
				vala_report_error (_tmp662_, "Property `%s' is read-only", _tmp665_);
				_g_free0 (_tmp665_);
			}
		}
		_tmp669_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp670_ = _tmp669_;
		if (_tmp670_) {
			ValaDataType* _tmp671_;
			ValaDataType* _tmp672_;
			gboolean _tmp673_;
			gboolean _tmp674_;
			_tmp671_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp672_ = _tmp671_;
			_tmp673_ = vala_data_type_get_nullable (_tmp672_);
			_tmp674_ = _tmp673_;
			_tmp668_ = !_tmp674_;
		} else {
			_tmp668_ = FALSE;
		}
		if (_tmp668_) {
			ValaDataType* _tmp675_;
			ValaDataType* _tmp676_;
			gboolean _tmp677_;
			gboolean _tmp678_;
			_tmp675_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp676_ = _tmp675_;
			_tmp677_ = vala_data_type_get_floating_reference (_tmp676_);
			_tmp678_ = _tmp677_;
			_tmp667_ = _tmp678_;
		} else {
			_tmp667_ = FALSE;
		}
		if (_tmp667_) {
			ValaDataType* _tmp679_;
			_tmp679_ = ret_type;
			_tmp666_ = VALA_IS_OBJECT_TYPE (_tmp679_);
		} else {
			_tmp666_ = FALSE;
		}
		if (_tmp666_) {
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			_tmp680_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp681_ = _tmp680_;
			vala_data_type_set_nullable (_tmp681_, TRUE);
		}
		_tmp682_ = m;
		_tmp683_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp682_);
		_tmp684_ = _tmp683_;
		sig = VALA_IS_SIGNAL (_tmp684_) ? ((ValaSignal*) _tmp684_) : NULL;
		_tmp686_ = sig;
		if (_tmp686_ != NULL) {
			ValaMethod* _tmp687_;
			const gchar* _tmp688_;
			const gchar* _tmp689_;
			_tmp687_ = m;
			_tmp688_ = vala_symbol_get_name ((ValaSymbol*) _tmp687_);
			_tmp689_ = _tmp688_;
			_tmp685_ = g_strcmp0 (_tmp689_, "disconnect") == 0;
		} else {
			_tmp685_ = FALSE;
		}
		if (_tmp685_) {
			gboolean _tmp690_ = FALSE;
			ValaList* _tmp691_;
			gboolean _tmp692_;
			gboolean _tmp693_;
			_tmp691_ = self->priv->argument_list;
			_tmp692_ = vala_collection_get_is_empty ((ValaCollection*) _tmp691_);
			_tmp693_ = _tmp692_;
			if (!_tmp693_) {
				ValaList* _tmp694_;
				gpointer _tmp695_;
				ValaExpression* _tmp696_;
				_tmp694_ = self->priv->argument_list;
				_tmp695_ = vala_list_get (_tmp694_, 0);
				_tmp696_ = (ValaExpression*) _tmp695_;
				_tmp690_ = VALA_IS_LAMBDA_EXPRESSION (_tmp696_);
				_vala_code_node_unref0 (_tmp696_);
			} else {
				_tmp690_ = FALSE;
			}
			if (_tmp690_) {
				ValaSourceReference* _tmp697_;
				ValaSourceReference* _tmp698_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp697_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp698_ = _tmp697_;
				vala_report_error (_tmp698_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp699_ = m;
		_tmp700_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp699_);
		_tmp701_ = _tmp700_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp701_) ? ((ValaDynamicSignal*) _tmp701_) : NULL;
		_tmp703_ = dynamic_sig;
		if (_tmp703_ != NULL) {
			ValaDynamicSignal* _tmp704_;
			ValaExpression* _tmp705_;
			ValaExpression* _tmp706_;
			_tmp704_ = dynamic_sig;
			_tmp705_ = vala_dynamic_signal_get_handler (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp702_ = _tmp706_ != NULL;
		} else {
			_tmp702_ = FALSE;
		}
		if (_tmp702_) {
			ValaDynamicSignal* _tmp707_;
			ValaDynamicSignal* _tmp708_;
			ValaExpression* _tmp709_;
			ValaExpression* _tmp710_;
			ValaDataType* _tmp711_;
			ValaDataType* _tmp712_;
			ValaDataType* _tmp713_;
			ValaDataType* _tmp714_;
			ValaDataType* _tmp715_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp733_;
			ValaExpression* _tmp734_;
			ValaExpression* _tmp735_;
			ValaDynamicSignal* _tmp736_;
			ValaDynamicSignal* _tmp737_;
			ValaSymbol* _tmp738_;
			ValaSymbol* _tmp739_;
			ValaObjectType* _tmp740_;
			ValaObjectType* _tmp741_;
			ValaDelegate* _tmp742_;
			ValaDelegate* _tmp743_;
			ValaSourceReference* _tmp744_;
			ValaSourceReference* _tmp745_;
			ValaDelegateType* _tmp746_;
			ValaDelegateType* _tmp747_;
			_tmp707_ = dynamic_sig;
			_tmp708_ = dynamic_sig;
			_tmp709_ = vala_dynamic_signal_get_handler (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_expression_get_value_type (_tmp710_);
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_data_type_get_return_type (_tmp712_);
			_tmp714_ = vala_data_type_copy (_tmp713_);
			_tmp715_ = _tmp714_;
			vala_callable_set_return_type ((ValaCallable*) _tmp707_, _tmp715_);
			_vala_code_node_unref0 (_tmp715_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp716_;
				ValaExpression* _tmp717_;
				ValaExpression* _tmp718_;
				ValaDataType* _tmp719_;
				ValaDataType* _tmp720_;
				ValaList* _tmp721_;
				gint _param_size = 0;
				ValaList* _tmp722_;
				gint _tmp723_;
				gint _tmp724_;
				gint _param_index = 0;
				_tmp716_ = dynamic_sig;
				_tmp717_ = vala_dynamic_signal_get_handler (_tmp716_);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_expression_get_value_type (_tmp718_);
				_tmp720_ = _tmp719_;
				_tmp721_ = vala_data_type_get_parameters (_tmp720_);
				_param_list = _tmp721_;
				_tmp722_ = _param_list;
				_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
				_tmp724_ = _tmp723_;
				_param_size = _tmp724_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp725_;
					gint _tmp726_;
					ValaParameter* param = NULL;
					ValaList* _tmp727_;
					gpointer _tmp728_;
					_param_index = _param_index + 1;
					_tmp725_ = _param_index;
					_tmp726_ = _param_size;
					if (!(_tmp725_ < _tmp726_)) {
						break;
					}
					_tmp727_ = _param_list;
					_tmp728_ = vala_list_get (_tmp727_, _param_index);
					param = (ValaParameter*) _tmp728_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp729_;
						ValaParameter* _tmp730_;
						ValaParameter* _tmp731_;
						ValaParameter* _tmp732_;
						_tmp729_ = dynamic_sig;
						_tmp730_ = param;
						_tmp731_ = vala_parameter_copy (_tmp730_);
						_tmp732_ = _tmp731_;
						vala_callable_add_parameter ((ValaCallable*) _tmp729_, _tmp732_);
						_vala_code_node_unref0 (_tmp732_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp733_ = dynamic_sig;
			_tmp734_ = vala_dynamic_signal_get_handler (_tmp733_);
			_tmp735_ = _tmp734_;
			_tmp736_ = dynamic_sig;
			_tmp737_ = dynamic_sig;
			_tmp738_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp737_);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp739_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
			_tmp741_ = _tmp740_;
			_tmp742_ = vala_signal_get_delegate ((ValaSignal*) _tmp736_, (ValaDataType*) _tmp741_, (ValaCodeNode*) self);
			_tmp743_ = _tmp742_;
			_tmp744_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp745_ = _tmp744_;
			_tmp746_ = vala_delegate_type_new (_tmp743_, _tmp745_);
			_tmp747_ = _tmp746_;
			vala_expression_set_target_type (_tmp735_, (ValaDataType*) _tmp747_);
			_vala_code_node_unref0 (_tmp747_);
			_vala_code_node_unref0 (_tmp743_);
			_vala_code_node_unref0 (_tmp741_);
		}
		_tmp749_ = m;
		if (_tmp749_ != NULL) {
			ValaMethod* _tmp750_;
			_tmp750_ = m;
			_tmp748_ = vala_method_has_type_parameters (_tmp750_);
		} else {
			_tmp748_ = FALSE;
		}
		if (_tmp748_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp751_;
			ValaExpression* _tmp752_;
			ValaMemberAccess* _tmp753_;
			ValaList* _tmp754_;
			gint _tmp755_;
			gint _tmp756_;
			_tmp751_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp752_ = _tmp751_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp752_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp753_ = ma;
			_tmp754_ = vala_member_access_get_type_arguments (_tmp753_);
			_tmp755_ = vala_collection_get_size ((ValaCollection*) _tmp754_);
			_tmp756_ = _tmp755_;
			if (_tmp756_ == 0) {
				ValaList* _tmp823_;
				ValaIterator* _tmp824_;
				ValaDataType* _tmp851_;
				ValaDataType* _tmp852_;
				ValaDataType* _tmp853_;
				ValaList* _tmp854_;
				ValaDataType* _tmp855_;
				ValaDataType* _tmp856_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp757_;
					ValaList* _tmp758_;
					gint _type_param_size = 0;
					ValaList* _tmp759_;
					gint _tmp760_;
					gint _tmp761_;
					gint _type_param_index = 0;
					_tmp757_ = m;
					_tmp758_ = vala_method_get_type_parameters (_tmp757_);
					_type_param_list = _tmp758_;
					_tmp759_ = _type_param_list;
					_tmp760_ = vala_collection_get_size ((ValaCollection*) _tmp759_);
					_tmp761_ = _tmp760_;
					_type_param_size = _tmp761_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp762_;
						gint _tmp763_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp764_;
						gpointer _tmp765_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp766_;
						ValaIterator* _tmp767_;
						gboolean _tmp803_ = FALSE;
						ValaDataType* _tmp804_;
						ValaDataType* _tmp814_;
						ValaMemberAccess* _tmp821_;
						ValaDataType* _tmp822_;
						_type_param_index = _type_param_index + 1;
						_tmp762_ = _type_param_index;
						_tmp763_ = _type_param_size;
						if (!(_tmp762_ < _tmp763_)) {
							break;
						}
						_tmp764_ = _type_param_list;
						_tmp765_ = vala_list_get (_tmp764_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp765_;
						type_arg = NULL;
						_tmp766_ = self->priv->argument_list;
						_tmp767_ = vala_iterable_iterator ((ValaIterable*) _tmp766_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp767_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp768_;
							gint _param_size = 0;
							ValaList* _tmp769_;
							gint _tmp770_;
							gint _tmp771_;
							gint _param_index = 0;
							_tmp768_ = params;
							_param_list = _tmp768_;
							_tmp769_ = _param_list;
							_tmp770_ = vala_collection_get_size ((ValaCollection*) _tmp769_);
							_tmp771_ = _tmp770_;
							_param_size = _tmp771_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp772_;
								gint _tmp773_;
								ValaParameter* param = NULL;
								ValaList* _tmp774_;
								gpointer _tmp775_;
								gboolean _tmp776_ = FALSE;
								ValaParameter* _tmp777_;
								gboolean _tmp778_;
								gboolean _tmp779_;
								ValaIterator* _tmp783_;
								_param_index = _param_index + 1;
								_tmp772_ = _param_index;
								_tmp773_ = _param_size;
								if (!(_tmp772_ < _tmp773_)) {
									break;
								}
								_tmp774_ = _param_list;
								_tmp775_ = vala_list_get (_tmp774_, _param_index);
								param = (ValaParameter*) _tmp775_;
								_tmp777_ = param;
								_tmp778_ = vala_parameter_get_ellipsis (_tmp777_);
								_tmp779_ = _tmp778_;
								if (_tmp779_) {
									_tmp776_ = TRUE;
								} else {
									ValaParameter* _tmp780_;
									gboolean _tmp781_;
									gboolean _tmp782_;
									_tmp780_ = param;
									_tmp781_ = vala_parameter_get_params_array (_tmp780_);
									_tmp782_ = _tmp781_;
									_tmp776_ = _tmp782_;
								}
								if (_tmp776_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp783_ = arg_it;
								if (vala_iterator_next (_tmp783_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp784_;
									gpointer _tmp785_;
									ValaParameter* _tmp786_;
									ValaDataType* _tmp787_;
									ValaDataType* _tmp788_;
									ValaTypeParameter* _tmp789_;
									ValaExpression* _tmp790_;
									ValaDataType* _tmp791_;
									ValaDataType* _tmp792_;
									ValaDataType* _tmp793_;
									ValaDataType* _tmp794_;
									ValaExpression* _tmp795_;
									ValaExpression* _tmp796_;
									ValaDataType* _tmp797_;
									ValaDataType* _tmp798_;
									ValaDataType* _tmp799_;
									ValaList* _tmp800_;
									ValaDataType* _tmp801_;
									ValaDataType* _tmp802_;
									_tmp784_ = arg_it;
									_tmp785_ = vala_iterator_get (_tmp784_);
									arg = (ValaExpression*) _tmp785_;
									_tmp786_ = param;
									_tmp787_ = vala_variable_get_variable_type ((ValaVariable*) _tmp786_);
									_tmp788_ = _tmp787_;
									_tmp789_ = type_param;
									_tmp790_ = arg;
									_tmp791_ = vala_expression_get_value_type (_tmp790_);
									_tmp792_ = _tmp791_;
									_tmp793_ = vala_data_type_infer_type_argument (_tmp788_, _tmp789_, _tmp792_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp793_;
									_tmp794_ = type_arg;
									if (_tmp794_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp795_ = arg;
									_tmp796_ = arg;
									_tmp797_ = vala_expression_get_formal_target_type (_tmp796_);
									_tmp798_ = _tmp797_;
									_tmp799_ = target_object_type;
									_tmp800_ = method_type_args;
									_tmp801_ = vala_data_type_get_actual_type (_tmp798_, _tmp799_, _tmp800_, (ValaCodeNode*) self);
									_tmp802_ = _tmp801_;
									vala_expression_set_target_type (_tmp795_, _tmp802_);
									_vala_code_node_unref0 (_tmp802_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp804_ = type_arg;
						if (_tmp804_ == NULL) {
							ValaDataType* _tmp805_;
							ValaDataType* _tmp806_;
							_tmp805_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp806_ = _tmp805_;
							_tmp803_ = _tmp806_ != NULL;
						} else {
							_tmp803_ = FALSE;
						}
						if (_tmp803_) {
							ValaMethod* _tmp807_;
							ValaDataType* _tmp808_;
							ValaDataType* _tmp809_;
							ValaTypeParameter* _tmp810_;
							ValaDataType* _tmp811_;
							ValaDataType* _tmp812_;
							ValaDataType* _tmp813_;
							_tmp807_ = m;
							_tmp808_ = vala_callable_get_return_type ((ValaCallable*) _tmp807_);
							_tmp809_ = _tmp808_;
							_tmp810_ = type_param;
							_tmp811_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp812_ = _tmp811_;
							_tmp813_ = vala_data_type_infer_type_argument (_tmp809_, _tmp810_, _tmp812_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp813_;
						}
						_tmp814_ = type_arg;
						if (_tmp814_ == NULL) {
							ValaMemberAccess* _tmp815_;
							ValaSourceReference* _tmp816_;
							ValaSourceReference* _tmp817_;
							ValaTypeParameter* _tmp818_;
							gchar* _tmp819_;
							gchar* _tmp820_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp815_ = ma;
							_tmp816_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp815_);
							_tmp817_ = _tmp816_;
							_tmp818_ = type_param;
							_tmp819_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp818_);
							_tmp820_ = _tmp819_;
							vala_report_error (_tmp817_, "cannot infer generic type argument for type parameter `%s'", _tmp820_);
							_g_free0 (_tmp820_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp821_ = ma;
						_tmp822_ = type_arg;
						vala_member_access_add_type_argument (_tmp821_, _tmp822_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp823_ = self->priv->argument_list;
				_tmp824_ = vala_iterable_iterator ((ValaIterable*) _tmp823_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp824_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp825_;
					gint _param_size = 0;
					ValaList* _tmp826_;
					gint _tmp827_;
					gint _tmp828_;
					gint _param_index = 0;
					_tmp825_ = params;
					_param_list = _tmp825_;
					_tmp826_ = _param_list;
					_tmp827_ = vala_collection_get_size ((ValaCollection*) _tmp826_);
					_tmp828_ = _tmp827_;
					_param_size = _tmp828_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp829_;
						gint _tmp830_;
						ValaParameter* param = NULL;
						ValaList* _tmp831_;
						gpointer _tmp832_;
						gboolean _tmp833_ = FALSE;
						ValaParameter* _tmp834_;
						gboolean _tmp835_;
						gboolean _tmp836_;
						ValaIterator* _tmp840_;
						_param_index = _param_index + 1;
						_tmp829_ = _param_index;
						_tmp830_ = _param_size;
						if (!(_tmp829_ < _tmp830_)) {
							break;
						}
						_tmp831_ = _param_list;
						_tmp832_ = vala_list_get (_tmp831_, _param_index);
						param = (ValaParameter*) _tmp832_;
						_tmp834_ = param;
						_tmp835_ = vala_parameter_get_ellipsis (_tmp834_);
						_tmp836_ = _tmp835_;
						if (_tmp836_) {
							_tmp833_ = TRUE;
						} else {
							ValaParameter* _tmp837_;
							gboolean _tmp838_;
							gboolean _tmp839_;
							_tmp837_ = param;
							_tmp838_ = vala_parameter_get_params_array (_tmp837_);
							_tmp839_ = _tmp838_;
							_tmp833_ = _tmp839_;
						}
						if (_tmp833_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp840_ = arg_it;
						if (vala_iterator_next (_tmp840_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp841_;
							gpointer _tmp842_;
							ValaExpression* _tmp843_;
							ValaExpression* _tmp844_;
							ValaDataType* _tmp845_;
							ValaDataType* _tmp846_;
							ValaDataType* _tmp847_;
							ValaList* _tmp848_;
							ValaDataType* _tmp849_;
							ValaDataType* _tmp850_;
							_tmp841_ = arg_it;
							_tmp842_ = vala_iterator_get (_tmp841_);
							arg = (ValaExpression*) _tmp842_;
							_tmp843_ = arg;
							_tmp844_ = arg;
							_tmp845_ = vala_expression_get_formal_target_type (_tmp844_);
							_tmp846_ = _tmp845_;
							_tmp847_ = target_object_type;
							_tmp848_ = method_type_args;
							_tmp849_ = vala_data_type_get_actual_type (_tmp846_, _tmp847_, _tmp848_, (ValaCodeNode*) self);
							_tmp850_ = _tmp849_;
							vala_expression_set_target_type (_tmp843_, _tmp850_);
							_vala_code_node_unref0 (_tmp850_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp851_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp852_ = _tmp851_;
				_tmp853_ = target_object_type;
				_tmp854_ = method_type_args;
				_tmp855_ = vala_data_type_get_actual_type (_tmp852_, _tmp853_, _tmp854_, (ValaCodeNode*) self);
				_tmp856_ = _tmp855_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp856_);
				_vala_code_node_unref0 (_tmp856_);
			}
		}
		_tmp858_ = m;
		if (_tmp858_ != NULL) {
			ValaMethod* _tmp859_;
			gboolean _tmp860_;
			gboolean _tmp861_;
			_tmp859_ = m;
			_tmp860_ = vala_method_get_coroutine (_tmp859_);
			_tmp861_ = _tmp860_;
			_tmp857_ = _tmp861_;
		} else {
			_tmp857_ = FALSE;
		}
		if (_tmp857_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp862_;
			ValaExpression* _tmp863_;
			ValaMemberAccess* _tmp864_;
			const gchar* _tmp865_;
			const gchar* _tmp866_;
			_tmp862_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp863_ = _tmp862_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp863_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp864_ = ma;
			_tmp865_ = vala_member_access_get_member_name (_tmp864_);
			_tmp866_ = _tmp865_;
			if (g_strcmp0 (_tmp866_, "end") == 0) {
				ValaMethod* _tmp867_;
				ValaMethod* _tmp868_;
				ValaSourceReference* _tmp869_;
				ValaSourceReference* _tmp870_;
				ValaMethodType* _tmp871_;
				_tmp867_ = m;
				_tmp868_ = vala_method_get_end_method (_tmp867_);
				_tmp869_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp870_ = _tmp869_;
				_tmp871_ = vala_method_type_new (_tmp868_, _tmp870_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp871_;
			}
		}
	}
	_tmp872_ = vala_code_context_get_analyzer (context);
	_tmp873_ = _tmp872_;
	_tmp874_ = mtype;
	_tmp875_ = params;
	_tmp876_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp873_, (ValaExpression*) self, _tmp874_, _tmp875_, _tmp876_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp877_;
		gint _arg_size = 0;
		ValaList* _tmp878_;
		gint _tmp879_;
		gint _tmp880_;
		gint _arg_index = 0;
		_tmp877_ = self->priv->argument_list;
		_arg_list = _tmp877_;
		_tmp878_ = _arg_list;
		_tmp879_ = vala_collection_get_size ((ValaCollection*) _tmp878_);
		_tmp880_ = _tmp879_;
		_arg_size = _tmp880_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp881_;
			gint _tmp882_;
			ValaExpression* arg = NULL;
			ValaList* _tmp883_;
			gpointer _tmp884_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp885_;
			gboolean _tmp886_ = FALSE;
			ValaSizeofExpression* _tmp887_;
			_arg_index = _arg_index + 1;
			_tmp881_ = _arg_index;
			_tmp882_ = _arg_size;
			if (!(_tmp881_ < _tmp882_)) {
				break;
			}
			_tmp883_ = _arg_list;
			_tmp884_ = vala_list_get (_tmp883_, _arg_index);
			arg = (ValaExpression*) _tmp884_;
			_tmp885_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp885_) ? ((ValaSizeofExpression*) _tmp885_) : NULL;
			_tmp887_ = sizeof_expr;
			if (_tmp887_ != NULL) {
				ValaSizeofExpression* _tmp888_;
				ValaDataType* _tmp889_;
				ValaDataType* _tmp890_;
				_tmp888_ = sizeof_expr;
				_tmp889_ = vala_sizeof_expression_get_type_reference (_tmp888_);
				_tmp890_ = _tmp889_;
				_tmp886_ = VALA_IS_GENERIC_TYPE (_tmp890_);
			} else {
				_tmp886_ = FALSE;
			}
			if (_tmp886_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp891_;
				ValaDataType* _tmp892_;
				ValaDataType* _tmp893_;
				ValaDataType* _tmp894_;
				ValaList* _tmp895_;
				ValaDataType* _tmp896_;
				ValaExpression* _tmp897_;
				ValaDataType* _tmp898_;
				ValaSourceReference* _tmp899_;
				ValaSourceReference* _tmp900_;
				ValaSizeofExpression* _tmp901_;
				ValaSizeofExpression* _tmp902_;
				_tmp891_ = sizeof_expr;
				_tmp892_ = vala_sizeof_expression_get_type_reference (_tmp891_);
				_tmp893_ = _tmp892_;
				_tmp894_ = target_object_type;
				_tmp895_ = method_type_args;
				_tmp896_ = vala_data_type_get_actual_type (_tmp893_, _tmp894_, _tmp895_, (ValaCodeNode*) self);
				sizeof_type = _tmp896_;
				_tmp897_ = arg;
				_tmp898_ = sizeof_type;
				_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp900_ = _tmp899_;
				_tmp901_ = vala_sizeof_expression_new (_tmp898_, _tmp900_);
				_tmp902_ = _tmp901_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp897_, (ValaExpression*) _tmp902_);
				_vala_code_node_unref0 (_tmp902_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp905_ = base_cm;
	if (_tmp905_ != NULL) {
		ValaCreationMethod* _tmp906_;
		_tmp906_ = base_cm;
		_tmp904_ = vala_method_is_variadic ((ValaMethod*) _tmp906_);
	} else {
		_tmp904_ = FALSE;
	}
	if (_tmp904_) {
		ValaList* _tmp907_;
		gint _tmp908_;
		gint _tmp909_;
		ValaCreationMethod* _tmp910_;
		ValaList* _tmp911_;
		gint _tmp912_;
		gint _tmp913_;
		_tmp907_ = self->priv->argument_list;
		_tmp908_ = vala_collection_get_size ((ValaCollection*) _tmp907_);
		_tmp909_ = _tmp908_;
		_tmp910_ = base_cm;
		_tmp911_ = vala_callable_get_parameters ((ValaCallable*) _tmp910_);
		_tmp912_ = vala_collection_get_size ((ValaCollection*) _tmp911_);
		_tmp913_ = _tmp912_;
		_tmp903_ = _tmp909_ == _tmp913_;
	} else {
		_tmp903_ = FALSE;
	}
	if (_tmp903_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp914_;
		ValaList* _tmp915_;
		gint _tmp916_;
		gint _tmp917_;
		gpointer _tmp918_;
		gboolean _tmp919_ = FALSE;
		ValaExpression* _tmp920_;
		ValaDataType* _tmp921_;
		ValaDataType* _tmp922_;
		_tmp914_ = self->priv->argument_list;
		_tmp915_ = self->priv->argument_list;
		_tmp916_ = vala_collection_get_size ((ValaCollection*) _tmp915_);
		_tmp917_ = _tmp916_;
		_tmp918_ = vala_list_get (_tmp914_, _tmp917_ - 1);
		this_last_arg = (ValaExpression*) _tmp918_;
		_tmp920_ = this_last_arg;
		_tmp921_ = vala_expression_get_value_type (_tmp920_);
		_tmp922_ = _tmp921_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp922_)) {
			ValaExpression* _tmp923_;
			ValaDataType* _tmp924_;
			ValaDataType* _tmp925_;
			ValaTypeSymbol* _tmp926_;
			ValaTypeSymbol* _tmp927_;
			ValaSemanticAnalyzer* _tmp928_;
			ValaSemanticAnalyzer* _tmp929_;
			ValaDataType* _tmp930_;
			ValaTypeSymbol* _tmp931_;
			ValaTypeSymbol* _tmp932_;
			_tmp923_ = this_last_arg;
			_tmp924_ = vala_expression_get_value_type (_tmp923_);
			_tmp925_ = _tmp924_;
			_tmp926_ = vala_data_type_get_type_symbol (_tmp925_);
			_tmp927_ = _tmp926_;
			_tmp928_ = vala_code_context_get_analyzer (context);
			_tmp929_ = _tmp928_;
			_tmp930_ = _tmp929_->va_list_type;
			_tmp931_ = vala_data_type_get_type_symbol (_tmp930_);
			_tmp932_ = _tmp931_;
			_tmp919_ = _tmp927_ == _tmp932_;
		} else {
			_tmp919_ = FALSE;
		}
		if (_tmp919_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp933_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp934_ = _tmp933_;
	vala_code_node_check ((ValaCodeNode*) _tmp934_, context);
	_tmp935_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp936_ = _tmp935_;
	if (_tmp936_) {
		gboolean _tmp937_ = FALSE;
		ValaCodeNode* _tmp938_;
		ValaCodeNode* _tmp939_;
		_tmp938_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp939_ = _tmp938_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp939_)) {
			_tmp937_ = TRUE;
		} else {
			ValaCodeNode* _tmp940_;
			ValaCodeNode* _tmp941_;
			_tmp940_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp941_ = _tmp940_;
			_tmp937_ = VALA_IS_EXPRESSION_STATEMENT (_tmp941_);
		}
		if (_tmp937_) {
		} else {
			ValaSemanticAnalyzer* _tmp942_;
			ValaSemanticAnalyzer* _tmp943_;
			ValaSymbol* _tmp944_;
			ValaSymbol* _tmp945_;
			_tmp942_ = vala_code_context_get_analyzer (context);
			_tmp943_ = _tmp942_;
			_tmp944_ = vala_semantic_analyzer_get_current_symbol (_tmp943_);
			_tmp945_ = _tmp944_;
			if (!VALA_IS_BLOCK (_tmp945_)) {
				ValaSourceReference* _tmp946_;
				ValaSourceReference* _tmp947_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp946_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp947_ = _tmp946_;
				vala_report_error (_tmp947_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp948_;
				ValaCodeNode* _tmp949_;
				ValaCodeNode* _tmp950_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp951_;
				ValaDataType* _tmp952_;
				ValaDataType* _tmp953_;
				ValaDataType* _tmp954_;
				gchar* _tmp955_;
				gchar* _tmp956_;
				ValaSourceReference* _tmp957_;
				ValaSourceReference* _tmp958_;
				ValaLocalVariable* _tmp959_;
				ValaLocalVariable* _tmp960_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp961_;
				ValaSourceReference* _tmp962_;
				ValaSourceReference* _tmp963_;
				ValaDeclarationStatement* _tmp964_;
				ValaDataType* _tmp965_;
				ValaDataType* _tmp966_;
				ValaSemanticAnalyzer* _tmp970_;
				ValaSemanticAnalyzer* _tmp971_;
				ValaBlock* _tmp972_;
				ValaDeclarationStatement* _tmp973_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp974_;
				ValaDataType* _tmp975_;
				ValaDataType* _tmp976_;
				ValaExpression* _tmp977_;
				ValaExpression* _tmp978_;
				ValaDataType* _tmp979_;
				ValaDataType* _tmp980_;
				ValaLocalVariable* _tmp981_;
				ValaDeclarationStatement* _tmp982_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp983_;
				ValaSemanticAnalyzer* _tmp984_;
				ValaSymbol* _tmp985_;
				ValaSymbol* _tmp986_;
				ValaBlock* _tmp987_;
				ValaBlock* _tmp988_;
				ValaLocalVariable* _tmp989_;
				ValaSemanticAnalyzer* _tmp990_;
				ValaSemanticAnalyzer* _tmp991_;
				ValaBlock* _tmp992_;
				ValaLocalVariable* _tmp993_;
				ValaCodeNode* _tmp994_;
				ValaExpression* _tmp995_;
				ValaExpression* _tmp996_;
				_tmp948_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp949_ = _tmp948_;
				_tmp950_ = _vala_code_node_ref0 (_tmp949_);
				old_parent_node = _tmp950_;
				_tmp951_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp952_ = _tmp951_;
				_tmp953_ = vala_data_type_copy (_tmp952_);
				_tmp954_ = _tmp953_;
				_tmp955_ = vala_code_node_get_temp_name ();
				_tmp956_ = _tmp955_;
				_tmp957_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp958_ = _tmp957_;
				_tmp959_ = vala_local_variable_new (_tmp954_, _tmp956_, NULL, _tmp958_);
				_tmp960_ = _tmp959_;
				_g_free0 (_tmp956_);
				_vala_code_node_unref0 (_tmp954_);
				local = _tmp960_;
				_tmp961_ = local;
				_tmp962_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp963_ = _tmp962_;
				_tmp964_ = vala_declaration_statement_new ((ValaSymbol*) _tmp961_, _tmp963_);
				decl = _tmp964_;
				_tmp965_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp966_ = _tmp965_;
				if (_tmp966_ == NULL) {
					ValaLocalVariable* _tmp967_;
					ValaDataType* _tmp968_;
					ValaDataType* _tmp969_;
					_tmp967_ = local;
					_tmp968_ = vala_variable_get_variable_type ((ValaVariable*) _tmp967_);
					_tmp969_ = _tmp968_;
					vala_data_type_set_floating_reference (_tmp969_, FALSE);
				}
				_tmp970_ = vala_code_context_get_analyzer (context);
				_tmp971_ = _tmp970_;
				_tmp972_ = _tmp971_->insert_block;
				_tmp973_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp972_, (ValaStatement*) _tmp973_);
				_tmp974_ = local;
				_tmp975_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp976_ = _tmp975_;
				_tmp977_ = vala_semantic_analyzer_create_temp_access (_tmp974_, _tmp976_);
				temp_access = _tmp977_;
				_tmp978_ = temp_access;
				_tmp979_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp980_ = _tmp979_;
				vala_expression_set_formal_target_type (_tmp978_, _tmp980_);
				_tmp981_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp981_, (ValaExpression*) self);
				_tmp982_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp982_, context);
				_tmp983_ = vala_code_context_get_analyzer (context);
				_tmp984_ = _tmp983_;
				_tmp985_ = vala_semantic_analyzer_get_current_symbol (_tmp984_);
				_tmp986_ = _tmp985_;
				_tmp987_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp986_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp987_;
				_tmp988_ = block;
				_tmp989_ = local;
				vala_block_remove_local_variable (_tmp988_, _tmp989_);
				_tmp990_ = vala_code_context_get_analyzer (context);
				_tmp991_ = _tmp990_;
				_tmp992_ = _tmp991_->insert_block;
				_tmp993_ = local;
				vala_block_add_local_variable (_tmp992_, _tmp993_);
				_tmp994_ = old_parent_node;
				_tmp995_ = temp_access;
				vala_code_node_replace_expression (_tmp994_, (ValaExpression*) self, _tmp995_);
				_tmp996_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp996_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp997_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp998_ = _tmp997_;
	result = !_tmp998_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_call = vala_method_call_real_get_call;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
	iface->get_is_chainup = vala_method_call_real_get_is_chainup;
	iface->set_is_chainup = vala_method_call_real_set_is_chainup;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__once = 0;
	if (g_once_init_enter (&vala_method_call_type_id__once)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__once, vala_method_call_type_id);
	}
	return vala_method_call_type_id__once;
}

