/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_call (ValaMethodCall* self,
                                ValaExpression* value);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_method_call_get_call (self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		ValaDataType* _tmp22_;
		_tmp22_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp22_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp23_;
			ValaTypeSymbol* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaMethod* m = NULL;
			ValaClass* _tmp26_;
			ValaCreationMethod* _tmp27_;
			ValaCreationMethod* _tmp28_;
			ValaMethod* _tmp29_;
			_tmp23_ = mtype;
			_tmp24_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp25_ = _tmp24_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass);
			_tmp26_ = cl;
			_tmp27_ = vala_class_get_default_construction_method (_tmp26_);
			_tmp28_ = _tmp27_;
			m = (ValaMethod*) _tmp28_;
			_tmp29_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp29_, collection, source_reference);
		} else {
			ValaDataType* _tmp30_;
			_tmp30_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp30_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp31_;
				ValaDelegate* _tmp32_;
				ValaDelegate* _tmp33_;
				ValaDelegate* _tmp34_;
				_tmp31_ = mtype;
				_tmp32_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp33_ = _tmp32_;
				d = _tmp33_;
				_tmp34_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp35_;
		gint _expr_size = 0;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _expr_index = 0;
		_tmp35_ = self->priv->argument_list;
		_expr_list = _tmp35_;
		_tmp36_ = _expr_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_expr_size = _tmp38_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			ValaExpression* expr = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaExpression* _tmp43_;
			_expr_index = _expr_index + 1;
			_tmp39_ = _expr_index;
			_tmp40_ = _expr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _expr_list;
			_tmp42_ = vala_list_get (_tmp41_, _expr_index);
			expr = (ValaExpression*) _tmp42_;
			_tmp43_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp43_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp102_;
	ValaExpression* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	gboolean _tmp107_ = FALSE;
	ValaProfile _tmp108_;
	ValaProfile _tmp109_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp135_;
	gboolean _tmp215_ = FALSE;
	ValaExpression* _tmp216_;
	ValaExpression* _tmp217_;
	gboolean _tmp288_ = FALSE;
	gboolean _tmp289_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp304_;
	ValaDataType* _tmp305_;
	ValaDataType* _tmp306_;
	ValaList* params = NULL;
	ValaDataType* _tmp307_;
	ValaList* _tmp308_;
	ValaList* _tmp309_;
	ValaDataType* _tmp310_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp366_;
	ValaIterator* _tmp367_;
	gboolean _tmp417_ = FALSE;
	ValaDataType* _tmp418_;
	gboolean _tmp439_ = FALSE;
	ValaDataType* _tmp440_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp520_ = FALSE;
	gboolean _tmp521_;
	gboolean _tmp522_;
	ValaDataType* _tmp542_;
	ValaDataType* _tmp553_;
	ValaDataType* _tmp554_;
	ValaDataType* _tmp555_;
	ValaDataType* _tmp556_;
	ValaDataType* _tmp557_;
	ValaDataType* _tmp558_;
	ValaList* _tmp559_;
	ValaDataType* _tmp560_;
	ValaDataType* _tmp561_;
	gboolean _tmp562_;
	gboolean _tmp563_;
	ValaDataType* _tmp586_;
	ValaSemanticAnalyzer* _tmp825_;
	ValaSemanticAnalyzer* _tmp826_;
	ValaDataType* _tmp827_;
	ValaList* _tmp828_;
	ValaList* _tmp829_;
	gboolean _tmp856_ = FALSE;
	gboolean _tmp857_ = FALSE;
	ValaCreationMethod* _tmp858_;
	ValaDataType* _tmp886_;
	ValaDataType* _tmp887_;
	gboolean _tmp888_;
	gboolean _tmp889_;
	gboolean _tmp950_;
	gboolean _tmp951_;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaMemberAccess* _tmp30_;
			ValaList* _tmp31_;
			ValaList* _tmp32_;
			ValaMemberAccess* _tmp33_;
			ValaExpression* _tmp34_;
			ValaExpression* _tmp35_;
			gboolean _tmp86_ = FALSE;
			ValaMemberAccess* _tmp87_;
			ValaSymbol* _tmp88_;
			ValaSymbol* _tmp89_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp19_ = ma;
			_tmp20_ = vala_member_access_get_prototype_access (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaSourceReference* _tmp22_;
				ValaSourceReference* _tmp23_;
				ValaExpression* _tmp24_;
				ValaExpression* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_method_call_get_call (self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_full_name (_tmp27_);
				_tmp29_ = _tmp28_;
				vala_report_error (_tmp23_, "Access to instance member `%s' denied", _tmp29_);
				_g_free0 (_tmp29_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp30_ = ma;
			_tmp31_ = vala_member_access_get_type_arguments (_tmp30_);
			_tmp32_ = _vala_iterable_ref0 (_tmp31_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp32_;
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_inner (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ != NULL) {
				ValaMemberAccess* _tmp36_;
				ValaExpression* _tmp37_;
				ValaExpression* _tmp38_;
				ValaDataType* _tmp39_;
				ValaDataType* _tmp40_;
				ValaDataType* _tmp41_;
				ValaMemberAccess* _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				ValaSymbol* _tmp45_;
				ValaSymbol* _tmp46_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp57_;
				ValaSymbol* _tmp58_;
				ValaSymbol* _tmp59_;
				gboolean _tmp60_ = FALSE;
				ValaMethod* _tmp61_;
				_tmp36_ = ma;
				_tmp37_ = vala_member_access_get_inner (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_expression_get_value_type (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = _vala_code_node_ref0 (_tmp40_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp41_;
				_tmp42_ = ma;
				_tmp43_ = vala_member_access_get_inner (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_expression_get_symbol_reference (_tmp44_);
				_tmp46_ = _tmp45_;
				if (VALA_IS_SIGNAL (_tmp46_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp47_;
					ValaExpression* _tmp48_;
					ValaExpression* _tmp49_;
					ValaMemberAccess* _tmp50_;
					_tmp47_ = ma;
					_tmp48_ = vala_member_access_get_inner (_tmp47_);
					_tmp49_ = _tmp48_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp49_) ? ((ValaMemberAccess*) _tmp49_) : NULL;
					_tmp50_ = sig;
					if (_tmp50_ != NULL) {
						ValaMemberAccess* _tmp51_;
						ValaExpression* _tmp52_;
						ValaExpression* _tmp53_;
						ValaDataType* _tmp54_;
						ValaDataType* _tmp55_;
						ValaDataType* _tmp56_;
						_tmp51_ = sig;
						_tmp52_ = vala_member_access_get_inner (_tmp51_);
						_tmp53_ = _tmp52_;
						_tmp54_ = vala_expression_get_value_type (_tmp53_);
						_tmp55_ = _tmp54_;
						_tmp56_ = _vala_code_node_ref0 (_tmp55_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp56_;
					}
				}
				_tmp57_ = ma;
				_tmp58_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp57_);
				_tmp59_ = _tmp58_;
				m = VALA_IS_METHOD (_tmp59_) ? ((ValaMethod*) _tmp59_) : NULL;
				_tmp61_ = m;
				if (_tmp61_ != NULL) {
					ValaMethod* _tmp62_;
					gboolean _tmp63_;
					gboolean _tmp64_;
					_tmp62_ = m;
					_tmp63_ = vala_method_get_coroutine (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp60_ = _tmp64_;
				} else {
					_tmp60_ = FALSE;
				}
				if (_tmp60_) {
					gboolean _tmp65_ = FALSE;
					ValaMemberAccess* _tmp66_;
					const gchar* _tmp67_;
					const gchar* _tmp68_;
					_tmp66_ = ma;
					_tmp67_ = vala_member_access_get_member_name (_tmp66_);
					_tmp68_ = _tmp67_;
					if (g_strcmp0 (_tmp68_, "begin") == 0) {
						_tmp65_ = TRUE;
					} else {
						ValaMemberAccess* _tmp69_;
						const gchar* _tmp70_;
						const gchar* _tmp71_;
						_tmp69_ = ma;
						_tmp70_ = vala_member_access_get_member_name (_tmp69_);
						_tmp71_ = _tmp70_;
						_tmp65_ = g_strcmp0 (_tmp71_, "end") == 0;
					}
					if (_tmp65_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp72_;
						ValaExpression* _tmp73_;
						ValaExpression* _tmp74_;
						gboolean _tmp75_ = FALSE;
						ValaMemberAccess* _tmp76_;
						_tmp72_ = ma;
						_tmp73_ = vala_member_access_get_inner (_tmp72_);
						_tmp74_ = _tmp73_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp74_) ? ((ValaMemberAccess*) _tmp74_) : NULL;
						_tmp76_ = method_access;
						if (_tmp76_ != NULL) {
							ValaMemberAccess* _tmp77_;
							ValaExpression* _tmp78_;
							ValaExpression* _tmp79_;
							_tmp77_ = method_access;
							_tmp78_ = vala_member_access_get_inner (_tmp77_);
							_tmp79_ = _tmp78_;
							_tmp75_ = _tmp79_ != NULL;
						} else {
							_tmp75_ = FALSE;
						}
						if (_tmp75_) {
							ValaMemberAccess* _tmp80_;
							ValaExpression* _tmp81_;
							ValaExpression* _tmp82_;
							ValaDataType* _tmp83_;
							ValaDataType* _tmp84_;
							ValaDataType* _tmp85_;
							_tmp80_ = method_access;
							_tmp81_ = vala_member_access_get_inner (_tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = vala_expression_get_value_type (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp85_ = _vala_code_node_ref0 (_tmp84_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp85_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp87_ = ma;
			_tmp88_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp89_ != NULL) {
				ValaMemberAccess* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				ValaAttribute* _tmp93_;
				_tmp90_ = ma;
				_tmp91_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp90_);
				_tmp92_ = _tmp91_;
				_tmp93_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp92_, "Assert");
				_tmp86_ = _tmp93_ != NULL;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaList* _tmp94_;
				gint _tmp95_;
				gint _tmp96_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp94_ = self->priv->argument_list;
				_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == 1) {
					ValaList* _tmp97_;
					gpointer _tmp98_;
					ValaExpression* _tmp99_;
					ValaSourceReference* _tmp100_;
					ValaSourceReference* _tmp101_;
					_tmp97_ = self->priv->argument_list;
					_tmp98_ = vala_list_get (_tmp97_, 0);
					_tmp99_ = (ValaExpression*) _tmp98_;
					_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp99_);
					_tmp101_ = _tmp100_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp99_);
				}
			}
		}
	}
	_tmp102_ = vala_method_call_get_call (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_expression_get_value_type (_tmp103_);
	_tmp105_ = _tmp104_;
	_tmp106_ = _vala_code_node_ref0 (_tmp105_);
	mtype = _tmp106_;
	_tmp108_ = vala_code_context_get_profile (context);
	_tmp109_ = _tmp108_;
	if (_tmp109_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		ValaSymbol* _tmp112_;
		ValaSymbol* _tmp113_;
		ValaSemanticAnalyzer* _tmp114_;
		ValaSemanticAnalyzer* _tmp115_;
		ValaClass* _tmp116_;
		_tmp110_ = vala_method_call_get_call (self);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_expression_get_symbol_reference (_tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_code_context_get_analyzer (context);
		_tmp115_ = _tmp114_;
		_tmp116_ = _tmp115_->object_type;
		_tmp107_ = _tmp113_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp107_ = FALSE;
	}
	gobject_chainup = _tmp107_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp117_;
		ValaExpression* _tmp118_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp119_;
		gboolean _tmp120_ = FALSE;
		ValaMemberAccess* _tmp121_;
		gboolean _tmp129_ = FALSE;
		ValaMemberAccess* _tmp130_;
		_tmp117_ = vala_method_call_get_call (self);
		_tmp118_ = _tmp117_;
		expr = _tmp118_;
		_tmp119_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp119_) ? ((ValaMemberAccess*) _tmp119_) : NULL;
		_tmp121_ = ma;
		if (_tmp121_ != NULL) {
			ValaMemberAccess* _tmp122_;
			ValaSymbol* _tmp123_;
			ValaSymbol* _tmp124_;
			_tmp122_ = ma;
			_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp120_ = VALA_IS_CREATION_METHOD (_tmp124_);
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			ValaMemberAccess* _tmp125_;
			ValaExpression* _tmp126_;
			ValaExpression* _tmp127_;
			ValaExpression* _tmp128_;
			_tmp125_ = ma;
			_tmp126_ = vala_member_access_get_inner (_tmp125_);
			_tmp127_ = _tmp126_;
			expr = _tmp127_;
			_tmp128_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp128_) ? ((ValaMemberAccess*) _tmp128_) : NULL;
		}
		_tmp130_ = ma;
		if (_tmp130_ != NULL) {
			ValaMemberAccess* _tmp131_;
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			_tmp131_ = ma;
			_tmp132_ = vala_member_access_get_member_name (_tmp131_);
			_tmp133_ = _tmp132_;
			_tmp129_ = g_strcmp0 (_tmp133_, "this") == 0;
		} else {
			_tmp129_ = FALSE;
		}
		if (_tmp129_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp134_;
			_tmp134_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp134_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp135_ = self->priv->_is_chainup;
	if (_tmp135_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp136_;
		ValaSemanticAnalyzer* _tmp137_;
		ValaMethod* _tmp138_;
		ValaCreationMethod* _tmp139_;
		ValaCreationMethod* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp136_ = vala_code_context_get_analyzer (context);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_semantic_analyzer_find_current_method (_tmp137_);
		cm = VALA_IS_CREATION_METHOD (_tmp138_) ? ((ValaCreationMethod*) _tmp138_) : NULL;
		_tmp139_ = cm;
		if (_tmp139_ == NULL) {
			ValaSourceReference* _tmp140_;
			ValaSourceReference* _tmp141_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp140_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp141_ = _tmp140_;
			vala_report_error (_tmp141_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp142_;
			gboolean _tmp143_;
			gboolean _tmp144_;
			_tmp142_ = cm;
			_tmp143_ = vala_creation_method_get_chain_up (_tmp142_);
			_tmp144_ = _tmp143_;
			if (_tmp144_) {
				ValaSourceReference* _tmp145_;
				ValaSourceReference* _tmp146_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp146_ = _tmp145_;
				vala_report_error (_tmp146_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp147_ = cm;
		vala_creation_method_set_chain_up (_tmp147_, TRUE);
		_tmp148_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp148_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp149_;
			ValaTypeSymbol* _tmp150_;
			ValaTypeSymbol* _tmp151_;
			ValaClass* _tmp152_;
			ValaCreationMethod* _tmp153_;
			ValaCreationMethod* _tmp154_;
			ValaCreationMethod* _tmp155_;
			_tmp149_ = mtype;
			_tmp150_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp149_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp151_ = _tmp150_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, VALA_TYPE_CLASS, ValaClass);
			_tmp152_ = cl;
			_tmp153_ = vala_class_get_default_construction_method (_tmp152_);
			_tmp154_ = _tmp153_;
			base_cm = _tmp154_;
			_tmp155_ = base_cm;
			if (_tmp155_ == NULL) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				ValaClass* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				_tmp158_ = cl;
				_tmp159_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp158_);
				_tmp160_ = _tmp159_;
				vala_report_error (_tmp157_, "chain up to `%s' not supported", _tmp160_);
				_g_free0 (_tmp160_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp161_;
				gboolean _tmp162_;
				gboolean _tmp163_;
				_tmp161_ = base_cm;
				_tmp162_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp161_);
				_tmp163_ = _tmp162_;
				if (!_tmp163_) {
					ValaSourceReference* _tmp164_;
					ValaSourceReference* _tmp165_;
					ValaCreationMethod* _tmp166_;
					gchar* _tmp167_;
					gchar* _tmp168_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp165_ = _tmp164_;
					_tmp166_ = base_cm;
					_tmp167_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp166_);
					_tmp168_ = _tmp167_;
					vala_report_error (_tmp165_, "chain up to `%s' not supported", _tmp168_);
					_g_free0 (_tmp168_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp169_ = FALSE;
			ValaExpression* _tmp170_;
			ValaExpression* _tmp171_;
			ValaSymbol* _tmp172_;
			ValaSymbol* _tmp173_;
			_tmp170_ = vala_method_call_get_call (self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_expression_get_symbol_reference (_tmp171_);
			_tmp173_ = _tmp172_;
			if (VALA_IS_CREATION_METHOD (_tmp173_)) {
				ValaExpression* _tmp174_;
				ValaExpression* _tmp175_;
				ValaSymbol* _tmp176_;
				ValaSymbol* _tmp177_;
				ValaSymbol* _tmp178_;
				ValaSymbol* _tmp179_;
				_tmp174_ = vala_method_call_get_call (self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_expression_get_symbol_reference (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp178_ = vala_symbol_get_parent_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				_tmp169_ = VALA_IS_CLASS (_tmp179_);
			} else {
				_tmp169_ = FALSE;
			}
			if (_tmp169_) {
				ValaExpression* _tmp180_;
				ValaExpression* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSymbol* _tmp183_;
				ValaCreationMethod* _tmp184_;
				gboolean _tmp185_;
				gboolean _tmp186_;
				_tmp180_ = vala_method_call_get_call (self);
				_tmp181_ = _tmp180_;
				_tmp182_ = vala_expression_get_symbol_reference (_tmp181_);
				_tmp183_ = _tmp182_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp183_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp184_ = base_cm;
				_tmp185_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp184_);
				_tmp186_ = _tmp185_;
				if (!_tmp186_) {
					ValaSourceReference* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaCreationMethod* _tmp189_;
					gchar* _tmp190_;
					gchar* _tmp191_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = base_cm;
					_tmp190_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp189_);
					_tmp191_ = _tmp190_;
					vala_report_error (_tmp188_, "chain up to `%s' not supported", _tmp191_);
					_g_free0 (_tmp191_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp192_;
					ValaSymbol* _tmp193_;
					ValaSymbol* _tmp194_;
					gboolean _tmp195_ = FALSE;
					ValaClass* _tmp196_;
					ValaExpression* _tmp203_;
					ValaExpression* _tmp204_;
					ValaSemanticAnalyzer* _tmp205_;
					ValaSemanticAnalyzer* _tmp206_;
					ValaClass* _tmp207_;
					ValaObjectType* _tmp208_;
					ValaObjectType* _tmp209_;
					ValaExpression* _tmp210_;
					ValaExpression* _tmp211_;
					ValaDataType* _tmp212_;
					ValaDataType* _tmp213_;
					ValaDataType* _tmp214_;
					_tmp192_ = cm;
					_tmp193_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp192_);
					_tmp194_ = _tmp193_;
					cl = VALA_IS_CLASS (_tmp194_) ? ((ValaClass*) _tmp194_) : NULL;
					_tmp196_ = cl;
					if (_tmp196_ == NULL) {
						_tmp195_ = TRUE;
					} else {
						ValaClass* _tmp197_;
						ValaSemanticAnalyzer* _tmp198_;
						ValaSemanticAnalyzer* _tmp199_;
						ValaClass* _tmp200_;
						_tmp197_ = cl;
						_tmp198_ = vala_code_context_get_analyzer (context);
						_tmp199_ = _tmp198_;
						_tmp200_ = _tmp199_->object_type;
						_tmp195_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp197_, (ValaTypeSymbol*) _tmp200_);
					}
					if (_tmp195_) {
						ValaSourceReference* _tmp201_;
						ValaSourceReference* _tmp202_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp201_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp202_ = _tmp201_;
						vala_report_error (_tmp202_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp203_ = vala_method_call_get_call (self);
					_tmp204_ = _tmp203_;
					_tmp205_ = vala_code_context_get_analyzer (context);
					_tmp206_ = _tmp205_;
					_tmp207_ = _tmp206_->object_type;
					_tmp208_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp207_);
					_tmp209_ = _tmp208_;
					vala_expression_set_value_type (_tmp204_, (ValaDataType*) _tmp209_);
					_vala_code_node_unref0 (_tmp209_);
					_tmp210_ = vala_method_call_get_call (self);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_expression_get_value_type (_tmp211_);
					_tmp213_ = _tmp212_;
					_tmp214_ = _vala_code_node_ref0 (_tmp213_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp214_;
				}
			}
		}
	}
	_tmp216_ = vala_method_call_get_call (self);
	_tmp217_ = _tmp216_;
	if (VALA_IS_MEMBER_ACCESS (_tmp217_)) {
		gboolean _tmp218_ = FALSE;
		gboolean _tmp219_ = FALSE;
		ValaExpression* _tmp220_;
		ValaExpression* _tmp221_;
		ValaSymbol* _tmp222_;
		ValaSymbol* _tmp223_;
		_tmp220_ = vala_method_call_get_call (self);
		_tmp221_ = _tmp220_;
		_tmp222_ = vala_expression_get_symbol_reference (_tmp221_);
		_tmp223_ = _tmp222_;
		if (VALA_IS_CREATION_METHOD (_tmp223_)) {
			ValaExpression* _tmp224_;
			ValaExpression* _tmp225_;
			ValaSymbol* _tmp226_;
			ValaSymbol* _tmp227_;
			ValaSymbol* _tmp228_;
			ValaSymbol* _tmp229_;
			_tmp224_ = vala_method_call_get_call (self);
			_tmp225_ = _tmp224_;
			_tmp226_ = vala_expression_get_symbol_reference (_tmp225_);
			_tmp227_ = _tmp226_;
			_tmp228_ = vala_symbol_get_parent_symbol (_tmp227_);
			_tmp229_ = _tmp228_;
			_tmp219_ = VALA_IS_STRUCT (_tmp229_);
		} else {
			_tmp219_ = FALSE;
		}
		if (_tmp219_) {
			_tmp218_ = TRUE;
		} else {
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			ValaSymbol* _tmp232_;
			ValaSymbol* _tmp233_;
			_tmp230_ = vala_method_call_get_call (self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_expression_get_symbol_reference (_tmp231_);
			_tmp233_ = _tmp232_;
			_tmp218_ = VALA_IS_STRUCT (_tmp233_);
		}
		_tmp215_ = _tmp218_;
	} else {
		_tmp215_ = FALSE;
	}
	if (_tmp215_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSymbol* _tmp236_;
		ValaSymbol* _tmp237_;
		gboolean _tmp238_ = FALSE;
		gboolean _tmp239_ = FALSE;
		ValaStruct* _tmp240_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp251_;
		ValaExpression* _tmp252_;
		ValaSourceReference* _tmp253_;
		ValaSourceReference* _tmp254_;
		ValaObjectCreationExpression* _tmp255_;
		ValaObjectCreationExpression* _tmp256_;
		ValaObjectCreationExpression* _tmp267_;
		ValaDataType* _tmp268_;
		ValaDataType* _tmp269_;
		ValaSemanticAnalyzer* _tmp270_;
		ValaSemanticAnalyzer* _tmp271_;
		ValaList* _tmp272_;
		ValaCodeNode* _tmp273_;
		ValaCodeNode* _tmp274_;
		ValaObjectCreationExpression* _tmp275_;
		ValaObjectCreationExpression* _tmp276_;
		_tmp234_ = vala_method_call_get_call (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_expression_get_symbol_reference (_tmp235_);
		_tmp237_ = _tmp236_;
		st = VALA_IS_STRUCT (_tmp237_) ? ((ValaStruct*) _tmp237_) : NULL;
		_tmp240_ = st;
		if (_tmp240_ != NULL) {
			ValaStruct* _tmp241_;
			ValaCreationMethod* _tmp242_;
			ValaCreationMethod* _tmp243_;
			_tmp241_ = st;
			_tmp242_ = vala_struct_get_default_construction_method (_tmp241_);
			_tmp243_ = _tmp242_;
			_tmp239_ = _tmp243_ == NULL;
		} else {
			_tmp239_ = FALSE;
		}
		if (_tmp239_) {
			gboolean _tmp244_ = FALSE;
			gboolean _tmp245_ = FALSE;
			ValaStruct* _tmp246_;
			_tmp246_ = st;
			if (vala_struct_is_boolean_type (_tmp246_)) {
				_tmp245_ = TRUE;
			} else {
				ValaStruct* _tmp247_;
				_tmp247_ = st;
				_tmp245_ = vala_struct_is_integer_type (_tmp247_);
			}
			if (_tmp245_) {
				_tmp244_ = TRUE;
			} else {
				ValaStruct* _tmp248_;
				_tmp248_ = st;
				_tmp244_ = vala_struct_is_floating_type (_tmp248_);
			}
			_tmp238_ = _tmp244_;
		} else {
			_tmp238_ = FALSE;
		}
		if (_tmp238_) {
			ValaSourceReference* _tmp249_;
			ValaSourceReference* _tmp250_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp249_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp250_ = _tmp249_;
			vala_report_error (_tmp250_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp251_ = vala_method_call_get_call (self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp254_ = _tmp253_;
		_tmp255_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp252_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp254_);
		struct_creation_expression = _tmp255_;
		_tmp256_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp256_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp257_;
			gint _arg_size = 0;
			ValaList* _tmp258_;
			gint _tmp259_;
			gint _tmp260_;
			gint _arg_index = 0;
			_tmp257_ = self->priv->argument_list;
			_arg_list = _tmp257_;
			_tmp258_ = _arg_list;
			_tmp259_ = vala_collection_get_size ((ValaCollection*) _tmp258_);
			_tmp260_ = _tmp259_;
			_arg_size = _tmp260_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp261_;
				gint _tmp262_;
				ValaExpression* arg = NULL;
				ValaList* _tmp263_;
				gpointer _tmp264_;
				ValaObjectCreationExpression* _tmp265_;
				ValaExpression* _tmp266_;
				_arg_index = _arg_index + 1;
				_tmp261_ = _arg_index;
				_tmp262_ = _arg_size;
				if (!(_tmp261_ < _tmp262_)) {
					break;
				}
				_tmp263_ = _arg_list;
				_tmp264_ = vala_list_get (_tmp263_, _arg_index);
				arg = (ValaExpression*) _tmp264_;
				_tmp265_ = struct_creation_expression;
				_tmp266_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp265_, _tmp266_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp267_ = struct_creation_expression;
		_tmp268_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp269_ = _tmp268_;
		vala_expression_set_target_type ((ValaExpression*) _tmp267_, _tmp269_);
		_tmp270_ = vala_code_context_get_analyzer (context);
		_tmp271_ = _tmp270_;
		_tmp272_ = _tmp271_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp272_, (ValaCodeNode*) self);
		_tmp273_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp274_ = _tmp273_;
		_tmp275_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp274_, (ValaExpression*) self, (ValaExpression*) _tmp275_);
		_tmp276_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp276_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp277_ = FALSE;
		gboolean _tmp278_ = FALSE;
		gboolean _tmp279_;
		_tmp279_ = self->priv->_is_chainup;
		if (!_tmp279_) {
			ValaExpression* _tmp280_;
			ValaExpression* _tmp281_;
			_tmp280_ = vala_method_call_get_call (self);
			_tmp281_ = _tmp280_;
			_tmp278_ = VALA_IS_MEMBER_ACCESS (_tmp281_);
		} else {
			_tmp278_ = FALSE;
		}
		if (_tmp278_) {
			ValaExpression* _tmp282_;
			ValaExpression* _tmp283_;
			ValaSymbol* _tmp284_;
			ValaSymbol* _tmp285_;
			_tmp282_ = vala_method_call_get_call (self);
			_tmp283_ = _tmp282_;
			_tmp284_ = vala_expression_get_symbol_reference (_tmp283_);
			_tmp285_ = _tmp284_;
			_tmp277_ = VALA_IS_CREATION_METHOD (_tmp285_);
		} else {
			_tmp277_ = FALSE;
		}
		if (_tmp277_) {
			ValaSourceReference* _tmp286_;
			ValaSourceReference* _tmp287_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp286_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp287_ = _tmp286_;
			vala_report_error (_tmp287_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp289_ = self->priv->_is_chainup;
	if (!_tmp289_) {
		ValaDataType* _tmp290_;
		_tmp290_ = mtype;
		_tmp288_ = VALA_IS_OBJECT_TYPE (_tmp290_);
	} else {
		_tmp288_ = FALSE;
	}
	if (_tmp288_) {
		ValaSourceReference* _tmp291_;
		ValaSourceReference* _tmp292_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp291_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp292_ = _tmp291_;
		vala_report_error (_tmp292_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp293_ = FALSE;
		ValaDataType* _tmp294_;
		_tmp294_ = mtype;
		if (_tmp294_ != NULL) {
			ValaDataType* _tmp295_;
			_tmp295_ = mtype;
			_tmp293_ = vala_data_type_is_invokable (_tmp295_);
		} else {
			_tmp293_ = FALSE;
		}
		if (_tmp293_) {
		} else {
			ValaExpression* _tmp296_;
			ValaExpression* _tmp297_;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			_tmp296_ = vala_method_call_get_call (self);
			_tmp297_ = _tmp296_;
			_tmp298_ = vala_expression_get_symbol_reference (_tmp297_);
			_tmp299_ = _tmp298_;
			if (VALA_IS_CLASS (_tmp299_)) {
				ValaSourceReference* _tmp300_;
				ValaSourceReference* _tmp301_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp301_ = _tmp300_;
				vala_report_error (_tmp301_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp302_;
				ValaSourceReference* _tmp303_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp302_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp303_ = _tmp302_;
				vala_report_error (_tmp303_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp304_ = mtype;
	_tmp305_ = vala_data_type_get_return_type (_tmp304_);
	_tmp306_ = _vala_code_node_ref0 (_tmp305_);
	ret_type = _tmp306_;
	_tmp307_ = mtype;
	_tmp308_ = vala_data_type_get_parameters (_tmp307_);
	_tmp309_ = _vala_iterable_ref0 (_tmp308_);
	params = _tmp309_;
	_tmp310_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp310_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp311_;
		ValaExpression* _tmp312_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp313_;
		ValaMethod* _tmp314_;
		ValaMethod* _tmp315_;
		ValaMethod* _tmp316_;
		gboolean _tmp317_;
		gboolean _tmp318_;
		gint n_type_params = 0;
		ValaMethod* _tmp350_;
		ValaList* _tmp351_;
		gint _tmp352_;
		gint _tmp353_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp354_;
		ValaList* _tmp355_;
		gint _tmp356_;
		gint _tmp357_;
		gboolean _tmp358_ = FALSE;
		_tmp311_ = vala_method_call_get_call (self);
		_tmp312_ = _tmp311_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp312_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp313_ = mtype;
		_tmp314_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp313_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp315_ = _tmp314_;
		m = _tmp315_;
		_tmp316_ = m;
		_tmp317_ = vala_method_get_coroutine (_tmp316_);
		_tmp318_ = _tmp317_;
		if (_tmp318_) {
			gboolean _tmp319_;
			gboolean _tmp320_;
			_tmp319_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp320_ = _tmp319_;
			if (!_tmp320_) {
				ValaMemberAccess* _tmp321_;
				const gchar* _tmp322_;
				const gchar* _tmp323_;
				_tmp321_ = ma;
				_tmp322_ = vala_member_access_get_member_name (_tmp321_);
				_tmp323_ = _tmp322_;
				if (g_strcmp0 (_tmp323_, "end") != 0) {
					ValaMemberAccess* _tmp324_;
					const gchar* _tmp325_;
					const gchar* _tmp326_;
					ValaMethod* _tmp330_;
					ValaList* _tmp331_;
					ValaList* _tmp332_;
					ValaVoidType* _tmp333_;
					_tmp324_ = ma;
					_tmp325_ = vala_member_access_get_member_name (_tmp324_);
					_tmp326_ = _tmp325_;
					if (g_strcmp0 (_tmp326_, "begin") != 0) {
						ValaMemberAccess* _tmp327_;
						ValaSourceReference* _tmp328_;
						ValaSourceReference* _tmp329_;
						_tmp327_ = ma;
						_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp327_);
						_tmp329_ = _tmp328_;
						vala_report_deprecated (_tmp329_, "implicit .begin is deprecated");
					}
					_tmp330_ = m;
					_tmp331_ = vala_method_get_async_begin_parameters (_tmp330_);
					_tmp332_ = _vala_iterable_ref0 (_tmp331_);
					_vala_iterable_unref0 (params);
					params = _tmp332_;
					_tmp333_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp333_;
				} else {
					ValaMethod* _tmp334_;
					ValaList* _tmp335_;
					ValaList* _tmp336_;
					_tmp334_ = m;
					_tmp335_ = vala_method_get_async_end_parameters (_tmp334_);
					_tmp336_ = _vala_iterable_ref0 (_tmp335_);
					_vala_iterable_unref0 (params);
					params = _tmp336_;
				}
			} else {
				gboolean _tmp337_ = FALSE;
				ValaMemberAccess* _tmp338_;
				const gchar* _tmp339_;
				const gchar* _tmp340_;
				_tmp338_ = ma;
				_tmp339_ = vala_member_access_get_member_name (_tmp338_);
				_tmp340_ = _tmp339_;
				if (g_strcmp0 (_tmp340_, "begin") == 0) {
					_tmp337_ = TRUE;
				} else {
					ValaMemberAccess* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					_tmp341_ = ma;
					_tmp342_ = vala_member_access_get_member_name (_tmp341_);
					_tmp343_ = _tmp342_;
					_tmp337_ = g_strcmp0 (_tmp343_, "end") == 0;
				}
				if (_tmp337_) {
					ValaMemberAccess* _tmp344_;
					ValaSourceReference* _tmp345_;
					ValaSourceReference* _tmp346_;
					ValaMemberAccess* _tmp347_;
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp344_ = ma;
					_tmp345_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp344_);
					_tmp346_ = _tmp345_;
					_tmp347_ = ma;
					_tmp348_ = vala_member_access_get_member_name (_tmp347_);
					_tmp349_ = _tmp348_;
					vala_report_error (_tmp346_, "use of `%s' not allowed in yield statement", _tmp349_);
				}
			}
		}
		_tmp350_ = m;
		_tmp351_ = vala_method_get_type_parameters (_tmp350_);
		_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
		_tmp353_ = _tmp352_;
		n_type_params = _tmp353_;
		_tmp354_ = ma;
		_tmp355_ = vala_member_access_get_type_arguments (_tmp354_);
		_tmp356_ = vala_collection_get_size ((ValaCollection*) _tmp355_);
		_tmp357_ = _tmp356_;
		n_type_args = _tmp357_;
		if (n_type_args > 0) {
			_tmp358_ = n_type_args < n_type_params;
		} else {
			_tmp358_ = FALSE;
		}
		if (_tmp358_) {
			ValaMemberAccess* _tmp359_;
			ValaSourceReference* _tmp360_;
			ValaSourceReference* _tmp361_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp359_ = ma;
			_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp359_);
			_tmp361_ = _tmp360_;
			vala_report_error (_tmp361_, "too few type arguments");
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp362_ = FALSE;
			if (n_type_args > 0) {
				_tmp362_ = n_type_args > n_type_params;
			} else {
				_tmp362_ = FALSE;
			}
			if (_tmp362_) {
				ValaMemberAccess* _tmp363_;
				ValaSourceReference* _tmp364_;
				ValaSourceReference* _tmp365_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp363_ = ma;
				_tmp364_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp363_);
				_tmp365_ = _tmp364_;
				vala_report_error (_tmp365_, "too many type arguments");
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp366_ = self->priv->argument_list;
	_tmp367_ = vala_iterable_iterator ((ValaIterable*) _tmp366_);
	arg_it = _tmp367_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp368_;
		gint _param_size = 0;
		ValaList* _tmp369_;
		gint _tmp370_;
		gint _tmp371_;
		gint _param_index = 0;
		_tmp368_ = params;
		_param_list = _tmp368_;
		_tmp369_ = _param_list;
		_tmp370_ = vala_collection_get_size ((ValaCollection*) _tmp369_);
		_tmp371_ = _tmp370_;
		_param_size = _tmp371_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp372_;
			gint _tmp373_;
			ValaParameter* param = NULL;
			ValaList* _tmp374_;
			gpointer _tmp375_;
			ValaParameter* _tmp376_;
			ValaParameter* _tmp377_;
			gboolean _tmp378_;
			gboolean _tmp379_;
			ValaParameter* _tmp380_;
			gboolean _tmp381_;
			gboolean _tmp382_;
			ValaIterator* _tmp400_;
			_param_index = _param_index + 1;
			_tmp372_ = _param_index;
			_tmp373_ = _param_size;
			if (!(_tmp372_ < _tmp373_)) {
				break;
			}
			_tmp374_ = _param_list;
			_tmp375_ = vala_list_get (_tmp374_, _param_index);
			param = (ValaParameter*) _tmp375_;
			_tmp376_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp376_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp377_ = param;
			_tmp378_ = vala_parameter_get_ellipsis (_tmp377_);
			_tmp379_ = _tmp378_;
			if (_tmp379_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp380_ = param;
			_tmp381_ = vala_parameter_get_params_array (_tmp380_);
			_tmp382_ = _tmp381_;
			if (_tmp382_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp383_;
				ValaDataType* _tmp384_;
				ValaDataType* _tmp385_;
				ValaArrayType* _tmp386_;
				_tmp383_ = param;
				_tmp384_ = vala_variable_get_variable_type ((ValaVariable*) _tmp383_);
				_tmp385_ = _tmp384_;
				_tmp386_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp385_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp386_;
				while (TRUE) {
					ValaIterator* _tmp387_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp388_;
					gpointer _tmp389_;
					ValaExpression* _tmp390_;
					ValaArrayType* _tmp391_;
					ValaDataType* _tmp392_;
					ValaDataType* _tmp393_;
					ValaExpression* _tmp394_;
					ValaDataType* _tmp395_;
					ValaDataType* _tmp396_;
					ValaArrayType* _tmp397_;
					gboolean _tmp398_;
					gboolean _tmp399_;
					_tmp387_ = arg_it;
					if (!vala_iterator_next (_tmp387_)) {
						break;
					}
					_tmp388_ = arg_it;
					_tmp389_ = vala_iterator_get (_tmp388_);
					arg = (ValaExpression*) _tmp389_;
					_tmp390_ = arg;
					_tmp391_ = array_type;
					_tmp392_ = vala_array_type_get_element_type (_tmp391_);
					_tmp393_ = _tmp392_;
					vala_expression_set_target_type (_tmp390_, _tmp393_);
					_tmp394_ = arg;
					_tmp395_ = vala_expression_get_target_type (_tmp394_);
					_tmp396_ = _tmp395_;
					_tmp397_ = array_type;
					_tmp398_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp397_);
					_tmp399_ = _tmp398_;
					vala_data_type_set_value_owned (_tmp396_, _tmp399_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp400_ = arg_it;
			if (vala_iterator_next (_tmp400_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp401_;
				gpointer _tmp402_;
				ValaExpression* _tmp403_;
				ValaParameter* _tmp404_;
				ValaDataType* _tmp405_;
				ValaDataType* _tmp406_;
				ValaExpression* _tmp407_;
				ValaExpression* _tmp408_;
				ValaDataType* _tmp409_;
				ValaDataType* _tmp410_;
				ValaDataType* _tmp411_;
				ValaList* _tmp412_;
				ValaDataType* _tmp413_;
				ValaDataType* _tmp414_;
				ValaExpression* _tmp415_;
				ValaExpression* _tmp416_;
				_tmp401_ = arg_it;
				_tmp402_ = vala_iterator_get (_tmp401_);
				arg = (ValaExpression*) _tmp402_;
				_tmp403_ = arg;
				_tmp404_ = param;
				_tmp405_ = vala_variable_get_variable_type ((ValaVariable*) _tmp404_);
				_tmp406_ = _tmp405_;
				vala_expression_set_formal_target_type (_tmp403_, _tmp406_);
				_tmp407_ = arg;
				_tmp408_ = arg;
				_tmp409_ = vala_expression_get_formal_target_type (_tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = target_object_type;
				_tmp412_ = method_type_args;
				_tmp413_ = vala_data_type_get_actual_type (_tmp410_, _tmp411_, _tmp412_, (ValaCodeNode*) self);
				_tmp414_ = _tmp413_;
				vala_expression_set_target_type (_tmp407_, _tmp414_);
				_vala_code_node_unref0 (_tmp414_);
				_tmp415_ = arg;
				_tmp416_ = _vala_code_node_ref0 (_tmp415_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp416_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp418_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp418_)) {
		ValaDataType* _tmp419_;
		ValaMethod* _tmp420_;
		ValaMethod* _tmp421_;
		ValaAttribute* _tmp422_;
		_tmp419_ = mtype;
		_tmp420_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp421_ = _tmp420_;
		_tmp422_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp421_, "Print");
		_tmp417_ = _tmp422_ != NULL;
	} else {
		_tmp417_ = FALSE;
	}
	if (_tmp417_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp423_;
		ValaSourceReference* _tmp424_;
		ValaTemplate* _tmp425_;
		ValaList* _tmp437_;
		ValaTemplate* _tmp438_;
		_tmp423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp424_ = _tmp423_;
		_tmp425_ = vala_template_new (_tmp424_);
		template = _tmp425_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp426_;
			gint _arg_size = 0;
			ValaList* _tmp427_;
			gint _tmp428_;
			gint _tmp429_;
			gint _arg_index = 0;
			_tmp426_ = self->priv->argument_list;
			_arg_list = _tmp426_;
			_tmp427_ = _arg_list;
			_tmp428_ = vala_collection_get_size ((ValaCollection*) _tmp427_);
			_tmp429_ = _tmp428_;
			_arg_size = _tmp429_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp430_;
				gint _tmp431_;
				ValaExpression* arg = NULL;
				ValaList* _tmp432_;
				gpointer _tmp433_;
				ValaExpression* _tmp434_;
				ValaTemplate* _tmp435_;
				ValaExpression* _tmp436_;
				_arg_index = _arg_index + 1;
				_tmp430_ = _arg_index;
				_tmp431_ = _arg_size;
				if (!(_tmp430_ < _tmp431_)) {
					break;
				}
				_tmp432_ = _arg_list;
				_tmp433_ = vala_list_get (_tmp432_, _arg_index);
				arg = (ValaExpression*) _tmp433_;
				_tmp434_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp434_, NULL);
				_tmp435_ = template;
				_tmp436_ = arg;
				vala_template_add_expression (_tmp435_, _tmp436_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp437_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp437_);
		_tmp438_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp438_);
		_vala_code_node_unref0 (template);
	}
	_tmp440_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp440_)) {
		ValaDataType* _tmp441_;
		ValaMethod* _tmp442_;
		ValaMethod* _tmp443_;
		gboolean _tmp444_;
		gboolean _tmp445_;
		_tmp441_ = mtype;
		_tmp442_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp441_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp443_ = _tmp442_;
		_tmp444_ = vala_method_get_printf_format (_tmp443_);
		_tmp445_ = _tmp444_;
		_tmp439_ = _tmp445_;
	} else {
		_tmp439_ = FALSE;
	}
	if (_tmp439_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp446_;
		ValaStringLiteral* _tmp495_;
		format_literal = NULL;
		_tmp446_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp446_)) {
		} else {
			ValaExpression* _tmp447_;
			_tmp447_ = last_arg;
			if (_tmp447_ != NULL) {
				ValaExpression* _tmp448_;
				ValaStringLiteral* _tmp449_;
				gboolean _tmp450_ = FALSE;
				ValaStringLiteral* _tmp451_;
				_tmp448_ = last_arg;
				_tmp449_ = vala_string_literal_get_format_literal (_tmp448_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp449_;
				_tmp451_ = format_literal;
				if (_tmp451_ == NULL) {
					ValaList* _tmp452_;
					gint _tmp453_;
					gint _tmp454_;
					ValaList* _tmp455_;
					gint _tmp456_;
					gint _tmp457_;
					_tmp452_ = self->priv->argument_list;
					_tmp453_ = vala_collection_get_size ((ValaCollection*) _tmp452_);
					_tmp454_ = _tmp453_;
					_tmp455_ = params;
					_tmp456_ = vala_collection_get_size ((ValaCollection*) _tmp455_);
					_tmp457_ = _tmp456_;
					_tmp450_ = _tmp454_ == (_tmp457_ - 1);
				} else {
					_tmp450_ = FALSE;
				}
				if (_tmp450_) {
					ValaStringLiteral* _tmp458_;
					ValaStringLiteral* _tmp459_;
					ValaSemanticAnalyzer* _tmp460_;
					ValaSemanticAnalyzer* _tmp461_;
					ValaDataType* _tmp462_;
					ValaDataType* _tmp463_;
					ValaDataType* _tmp464_;
					ValaList* _tmp465_;
					ValaList* _tmp466_;
					gint _tmp467_;
					gint _tmp468_;
					ValaStringLiteral* _tmp469_;
					ValaList* _tmp470_;
					ValaIterator* _tmp471_;
					_tmp458_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp458_;
					_tmp459_ = format_literal;
					_tmp460_ = vala_code_context_get_analyzer (context);
					_tmp461_ = _tmp460_;
					_tmp462_ = _tmp461_->string_type;
					_tmp463_ = vala_data_type_copy (_tmp462_);
					_tmp464_ = _tmp463_;
					vala_expression_set_target_type ((ValaExpression*) _tmp459_, _tmp464_);
					_vala_code_node_unref0 (_tmp464_);
					_tmp465_ = self->priv->argument_list;
					_tmp466_ = self->priv->argument_list;
					_tmp467_ = vala_collection_get_size ((ValaCollection*) _tmp466_);
					_tmp468_ = _tmp467_;
					_tmp469_ = format_literal;
					vala_list_insert (_tmp465_, _tmp468_ - 1, (ValaExpression*) _tmp469_);
					_tmp470_ = self->priv->argument_list;
					_tmp471_ = vala_iterable_iterator ((ValaIterable*) _tmp470_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp471_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp472_;
						gint _param_size = 0;
						ValaList* _tmp473_;
						gint _tmp474_;
						gint _tmp475_;
						gint _param_index = 0;
						_tmp472_ = params;
						_param_list = _tmp472_;
						_tmp473_ = _param_list;
						_tmp474_ = vala_collection_get_size ((ValaCollection*) _tmp473_);
						_tmp475_ = _tmp474_;
						_param_size = _tmp475_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp476_;
							gint _tmp477_;
							ValaParameter* param = NULL;
							ValaList* _tmp478_;
							gpointer _tmp479_;
							gboolean _tmp480_ = FALSE;
							ValaParameter* _tmp481_;
							gboolean _tmp482_;
							gboolean _tmp483_;
							ValaIterator* _tmp487_;
							_param_index = _param_index + 1;
							_tmp476_ = _param_index;
							_tmp477_ = _param_size;
							if (!(_tmp476_ < _tmp477_)) {
								break;
							}
							_tmp478_ = _param_list;
							_tmp479_ = vala_list_get (_tmp478_, _param_index);
							param = (ValaParameter*) _tmp479_;
							_tmp481_ = param;
							_tmp482_ = vala_parameter_get_ellipsis (_tmp481_);
							_tmp483_ = _tmp482_;
							if (_tmp483_) {
								_tmp480_ = TRUE;
							} else {
								ValaParameter* _tmp484_;
								gboolean _tmp485_;
								gboolean _tmp486_;
								_tmp484_ = param;
								_tmp485_ = vala_parameter_get_params_array (_tmp484_);
								_tmp486_ = _tmp485_;
								_tmp480_ = _tmp486_;
							}
							if (_tmp480_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp487_ = arg_it;
							vala_iterator_next (_tmp487_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp488_;
				ValaExpression* _tmp489_;
				ValaMemberAccess* _tmp490_;
				_tmp488_ = vala_method_call_get_call (self);
				_tmp489_ = _tmp488_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp489_) ? ((ValaMemberAccess*) _tmp489_) : NULL;
				_tmp490_ = ma;
				if (_tmp490_ != NULL) {
					ValaMemberAccess* _tmp491_;
					ValaExpression* _tmp492_;
					ValaExpression* _tmp493_;
					ValaStringLiteral* _tmp494_;
					_tmp491_ = ma;
					_tmp492_ = vala_member_access_get_inner (_tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = vala_string_literal_get_format_literal (_tmp493_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp494_;
				}
			}
		}
		_tmp495_ = format_literal;
		if (_tmp495_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp496_;
			gchar* _tmp497_;
			ValaSemanticAnalyzer* _tmp498_;
			ValaSemanticAnalyzer* _tmp499_;
			const gchar* _tmp500_;
			ValaIterator* _tmp501_;
			ValaSourceReference* _tmp502_;
			ValaSourceReference* _tmp503_;
			_tmp496_ = format_literal;
			_tmp497_ = vala_string_literal_eval (_tmp496_);
			format = _tmp497_;
			_tmp498_ = vala_code_context_get_analyzer (context);
			_tmp499_ = _tmp498_;
			_tmp500_ = format;
			_tmp501_ = arg_it;
			_tmp502_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp503_ = _tmp502_;
			if (!vala_semantic_analyzer_check_print_format (_tmp499_, _tmp500_, _tmp501_, _tmp503_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp504_;
		gint _arg_size = 0;
		ValaList* _tmp505_;
		gint _tmp506_;
		gint _tmp507_;
		gint _arg_index = 0;
		_tmp504_ = self->priv->argument_list;
		_arg_list = _tmp504_;
		_tmp505_ = _arg_list;
		_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
		_tmp507_ = _tmp506_;
		_arg_size = _tmp507_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp508_;
			gint _tmp509_;
			ValaExpression* arg = NULL;
			ValaList* _tmp510_;
			gpointer _tmp511_;
			ValaExpression* _tmp512_;
			gboolean _tmp513_ = FALSE;
			ValaExpression* _tmp514_;
			_arg_index = _arg_index + 1;
			_tmp508_ = _arg_index;
			_tmp509_ = _arg_size;
			if (!(_tmp508_ < _tmp509_)) {
				break;
			}
			_tmp510_ = _arg_list;
			_tmp511_ = vala_list_get (_tmp510_, _arg_index);
			arg = (ValaExpression*) _tmp511_;
			_tmp512_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp512_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp514_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp514_)) {
				ValaExpression* _tmp515_;
				ValaMethod* _tmp516_;
				ValaMethod* _tmp517_;
				gboolean _tmp518_;
				gboolean _tmp519_;
				_tmp515_ = arg;
				_tmp516_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_method_get_closure (_tmp517_);
				_tmp519_ = _tmp518_;
				_tmp513_ = _tmp519_;
			} else {
				_tmp513_ = FALSE;
			}
			if (_tmp513_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp521_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp522_ = _tmp521_;
	if (!_tmp522_) {
		_tmp520_ = force_lambda_method_closure;
	} else {
		_tmp520_ = FALSE;
	}
	if (_tmp520_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp523_;
			gint _arg_size = 0;
			ValaList* _tmp524_;
			gint _tmp525_;
			gint _tmp526_;
			gint _arg_index = 0;
			_tmp523_ = self->priv->argument_list;
			_arg_list = _tmp523_;
			_tmp524_ = _arg_list;
			_tmp525_ = vala_collection_get_size ((ValaCollection*) _tmp524_);
			_tmp526_ = _tmp525_;
			_arg_size = _tmp526_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp527_;
				gint _tmp528_;
				ValaExpression* arg = NULL;
				ValaList* _tmp529_;
				gpointer _tmp530_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp531_;
				gboolean _tmp532_ = FALSE;
				ValaLambdaExpression* _tmp533_;
				_arg_index = _arg_index + 1;
				_tmp527_ = _arg_index;
				_tmp528_ = _arg_size;
				if (!(_tmp527_ < _tmp528_)) {
					break;
				}
				_tmp529_ = _arg_list;
				_tmp530_ = vala_list_get (_tmp529_, _arg_index);
				arg = (ValaExpression*) _tmp530_;
				_tmp531_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp531_) ? ((ValaLambdaExpression*) _tmp531_) : NULL;
				_tmp533_ = lambda;
				if (_tmp533_ != NULL) {
					ValaLambdaExpression* _tmp534_;
					ValaMethod* _tmp535_;
					ValaMethod* _tmp536_;
					ValaMemberBinding _tmp537_;
					ValaMemberBinding _tmp538_;
					_tmp534_ = lambda;
					_tmp535_ = vala_lambda_expression_get_method (_tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = vala_method_get_binding (_tmp536_);
					_tmp538_ = _tmp537_;
					_tmp532_ = _tmp538_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp532_ = FALSE;
				}
				if (_tmp532_) {
					ValaLambdaExpression* _tmp539_;
					ValaMethod* _tmp540_;
					ValaMethod* _tmp541_;
					_tmp539_ = lambda;
					_tmp540_ = vala_lambda_expression_get_method (_tmp539_);
					_tmp541_ = _tmp540_;
					vala_method_set_closure (_tmp541_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp542_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp542_)) {
		gboolean _tmp543_ = FALSE;
		gboolean _tmp544_ = FALSE;
		ValaCodeNode* _tmp545_;
		ValaCodeNode* _tmp546_;
		_tmp545_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp546_ = _tmp545_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp546_)) {
			ValaCodeNode* _tmp547_;
			ValaCodeNode* _tmp548_;
			_tmp547_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp548_ = _tmp547_;
			_tmp544_ = !VALA_IS_FOR_STATEMENT (_tmp548_);
		} else {
			_tmp544_ = FALSE;
		}
		if (_tmp544_) {
			ValaCodeNode* _tmp549_;
			ValaCodeNode* _tmp550_;
			_tmp549_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp550_ = _tmp549_;
			_tmp543_ = !VALA_IS_YIELD_STATEMENT (_tmp550_);
		} else {
			_tmp543_ = FALSE;
		}
		if (_tmp543_) {
			ValaSourceReference* _tmp551_;
			ValaSourceReference* _tmp552_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp552_ = _tmp551_;
			vala_report_error (_tmp552_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp553_ = ret_type;
	_tmp554_ = vala_data_type_copy (_tmp553_);
	_tmp555_ = _tmp554_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp555_);
	_vala_code_node_unref0 (_tmp555_);
	_tmp556_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp557_ = _tmp556_;
	_tmp558_ = target_object_type;
	_tmp559_ = method_type_args;
	_tmp560_ = vala_data_type_get_actual_type (_tmp557_, _tmp558_, _tmp559_, (ValaCodeNode*) self);
	_tmp561_ = _tmp560_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp561_);
	_vala_code_node_unref0 (_tmp561_);
	_tmp562_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp563_ = _tmp562_;
	if (_tmp563_) {
		gboolean _tmp564_ = FALSE;
		ValaDataType* _tmp565_;
		gboolean _tmp573_ = FALSE;
		ValaSemanticAnalyzer* _tmp574_;
		ValaSemanticAnalyzer* _tmp575_;
		ValaMethod* _tmp576_;
		ValaMethod* _tmp577_;
		_tmp565_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp565_)) {
			_tmp564_ = TRUE;
		} else {
			ValaDataType* _tmp566_;
			ValaMethod* _tmp567_;
			ValaMethod* _tmp568_;
			gboolean _tmp569_;
			gboolean _tmp570_;
			_tmp566_ = mtype;
			_tmp567_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp566_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp568_ = _tmp567_;
			_tmp569_ = vala_method_get_coroutine (_tmp568_);
			_tmp570_ = _tmp569_;
			_tmp564_ = !_tmp570_;
		}
		if (_tmp564_) {
			ValaSourceReference* _tmp571_;
			ValaSourceReference* _tmp572_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp572_ = _tmp571_;
			vala_report_error (_tmp572_, "yield expression requires async method");
		}
		_tmp574_ = vala_code_context_get_analyzer (context);
		_tmp575_ = _tmp574_;
		_tmp576_ = vala_semantic_analyzer_get_current_method (_tmp575_);
		_tmp577_ = _tmp576_;
		if (_tmp577_ == NULL) {
			_tmp573_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp578_;
			ValaSemanticAnalyzer* _tmp579_;
			ValaMethod* _tmp580_;
			ValaMethod* _tmp581_;
			gboolean _tmp582_;
			gboolean _tmp583_;
			_tmp578_ = vala_code_context_get_analyzer (context);
			_tmp579_ = _tmp578_;
			_tmp580_ = vala_semantic_analyzer_get_current_method (_tmp579_);
			_tmp581_ = _tmp580_;
			_tmp582_ = vala_method_get_coroutine (_tmp581_);
			_tmp583_ = _tmp582_;
			_tmp573_ = !_tmp583_;
		}
		if (_tmp573_) {
			ValaSourceReference* _tmp584_;
			ValaSourceReference* _tmp585_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp584_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp585_ = _tmp584_;
			vala_report_error (_tmp585_, "yield expression not available outside async method");
		}
	}
	_tmp586_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp586_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp587_;
		ValaMethod* _tmp588_;
		ValaMethod* _tmp589_;
		ValaMethod* _tmp590_;
		gboolean _tmp591_;
		gboolean _tmp592_;
		ValaMethod* _tmp595_;
		gboolean _tmp596_;
		gboolean _tmp597_;
		gboolean _tmp623_ = FALSE;
		gboolean _tmp624_ = FALSE;
		gboolean _tmp625_ = FALSE;
		gboolean _tmp626_;
		gboolean _tmp627_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp639_;
		ValaSymbol* _tmp640_;
		ValaSymbol* _tmp641_;
		gboolean _tmp642_ = FALSE;
		ValaSignal* _tmp643_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp656_;
		ValaSymbol* _tmp657_;
		ValaSymbol* _tmp658_;
		gboolean _tmp659_ = FALSE;
		ValaDynamicSignal* _tmp660_;
		gboolean _tmp703_ = FALSE;
		ValaMethod* _tmp704_;
		gboolean _tmp812_ = FALSE;
		ValaMethod* _tmp813_;
		_tmp587_ = mtype;
		_tmp588_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp587_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp589_ = _tmp588_;
		m = _tmp589_;
		_tmp590_ = m;
		_tmp591_ = vala_method_get_returns_floating_reference (_tmp590_);
		_tmp592_ = _tmp591_;
		if (_tmp592_) {
			ValaDataType* _tmp593_;
			ValaDataType* _tmp594_;
			_tmp593_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp594_ = _tmp593_;
			vala_data_type_set_floating_reference (_tmp594_, TRUE);
		}
		_tmp595_ = m;
		_tmp596_ = vala_method_get_returns_modified_pointer (_tmp595_);
		_tmp597_ = _tmp596_;
		if (_tmp597_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp598_;
			ValaExpression* _tmp599_;
			ValaExpression* _tmp600_;
			ValaExpression* _tmp601_;
			ValaExpression* _tmp602_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp603_;
			ValaSymbol* _tmp604_;
			ValaSymbol* _tmp605_;
			gboolean _tmp606_ = FALSE;
			ValaProperty* _tmp607_;
			_tmp598_ = vala_method_call_get_call (self);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp599_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp601_ = _tmp600_;
			inner = _tmp601_;
			_tmp602_ = inner;
			vala_expression_set_lvalue (_tmp602_, TRUE);
			_tmp603_ = inner;
			_tmp604_ = vala_expression_get_symbol_reference (_tmp603_);
			_tmp605_ = _tmp604_;
			prop = VALA_IS_PROPERTY (_tmp605_) ? ((ValaProperty*) _tmp605_) : NULL;
			_tmp607_ = prop;
			if (_tmp607_ != NULL) {
				gboolean _tmp608_ = FALSE;
				ValaProperty* _tmp609_;
				ValaPropertyAccessor* _tmp610_;
				ValaPropertyAccessor* _tmp611_;
				_tmp609_ = prop;
				_tmp610_ = vala_property_get_set_accessor (_tmp609_);
				_tmp611_ = _tmp610_;
				if (_tmp611_ == NULL) {
					_tmp608_ = TRUE;
				} else {
					ValaProperty* _tmp612_;
					ValaPropertyAccessor* _tmp613_;
					ValaPropertyAccessor* _tmp614_;
					gboolean _tmp615_;
					gboolean _tmp616_;
					_tmp612_ = prop;
					_tmp613_ = vala_property_get_set_accessor (_tmp612_);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_property_accessor_get_writable (_tmp614_);
					_tmp616_ = _tmp615_;
					_tmp608_ = !_tmp616_;
				}
				_tmp606_ = _tmp608_;
			} else {
				_tmp606_ = FALSE;
			}
			if (_tmp606_) {
				ValaExpression* _tmp617_;
				ValaSourceReference* _tmp618_;
				ValaSourceReference* _tmp619_;
				ValaProperty* _tmp620_;
				gchar* _tmp621_;
				gchar* _tmp622_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp617_ = inner;
				_tmp618_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp617_);
				_tmp619_ = _tmp618_;
				_tmp620_ = prop;
				_tmp621_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp620_);
				_tmp622_ = _tmp621_;
				vala_report_error (_tmp619_, "Property `%s' is read-only", _tmp622_);
				_g_free0 (_tmp622_);
			}
		}
		_tmp626_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp627_ = _tmp626_;
		if (_tmp627_) {
			ValaDataType* _tmp628_;
			ValaDataType* _tmp629_;
			gboolean _tmp630_;
			gboolean _tmp631_;
			_tmp628_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp629_ = _tmp628_;
			_tmp630_ = vala_data_type_get_nullable (_tmp629_);
			_tmp631_ = _tmp630_;
			_tmp625_ = !_tmp631_;
		} else {
			_tmp625_ = FALSE;
		}
		if (_tmp625_) {
			ValaDataType* _tmp632_;
			ValaDataType* _tmp633_;
			gboolean _tmp634_;
			gboolean _tmp635_;
			_tmp632_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp633_ = _tmp632_;
			_tmp634_ = vala_data_type_get_floating_reference (_tmp633_);
			_tmp635_ = _tmp634_;
			_tmp624_ = _tmp635_;
		} else {
			_tmp624_ = FALSE;
		}
		if (_tmp624_) {
			ValaDataType* _tmp636_;
			_tmp636_ = ret_type;
			_tmp623_ = VALA_IS_OBJECT_TYPE (_tmp636_);
		} else {
			_tmp623_ = FALSE;
		}
		if (_tmp623_) {
			ValaDataType* _tmp637_;
			ValaDataType* _tmp638_;
			_tmp637_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp638_ = _tmp637_;
			vala_data_type_set_nullable (_tmp638_, TRUE);
		}
		_tmp639_ = m;
		_tmp640_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp639_);
		_tmp641_ = _tmp640_;
		sig = VALA_IS_SIGNAL (_tmp641_) ? ((ValaSignal*) _tmp641_) : NULL;
		_tmp643_ = sig;
		if (_tmp643_ != NULL) {
			ValaMethod* _tmp644_;
			const gchar* _tmp645_;
			const gchar* _tmp646_;
			_tmp644_ = m;
			_tmp645_ = vala_symbol_get_name ((ValaSymbol*) _tmp644_);
			_tmp646_ = _tmp645_;
			_tmp642_ = g_strcmp0 (_tmp646_, "disconnect") == 0;
		} else {
			_tmp642_ = FALSE;
		}
		if (_tmp642_) {
			gboolean _tmp647_ = FALSE;
			ValaList* _tmp648_;
			gboolean _tmp649_;
			gboolean _tmp650_;
			_tmp648_ = self->priv->argument_list;
			_tmp649_ = vala_collection_get_is_empty ((ValaCollection*) _tmp648_);
			_tmp650_ = _tmp649_;
			if (!_tmp650_) {
				ValaList* _tmp651_;
				gpointer _tmp652_;
				ValaExpression* _tmp653_;
				_tmp651_ = self->priv->argument_list;
				_tmp652_ = vala_list_get (_tmp651_, 0);
				_tmp653_ = (ValaExpression*) _tmp652_;
				_tmp647_ = VALA_IS_LAMBDA_EXPRESSION (_tmp653_);
				_vala_code_node_unref0 (_tmp653_);
			} else {
				_tmp647_ = FALSE;
			}
			if (_tmp647_) {
				ValaSourceReference* _tmp654_;
				ValaSourceReference* _tmp655_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp654_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp655_ = _tmp654_;
				vala_report_error (_tmp655_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp656_ = m;
		_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
		_tmp658_ = _tmp657_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp658_) ? ((ValaDynamicSignal*) _tmp658_) : NULL;
		_tmp660_ = dynamic_sig;
		if (_tmp660_ != NULL) {
			ValaDynamicSignal* _tmp661_;
			ValaExpression* _tmp662_;
			ValaExpression* _tmp663_;
			_tmp661_ = dynamic_sig;
			_tmp662_ = vala_dynamic_signal_get_handler (_tmp661_);
			_tmp663_ = _tmp662_;
			_tmp659_ = _tmp663_ != NULL;
		} else {
			_tmp659_ = FALSE;
		}
		if (_tmp659_) {
			ValaDynamicSignal* _tmp664_;
			ValaDynamicSignal* _tmp665_;
			ValaExpression* _tmp666_;
			ValaExpression* _tmp667_;
			ValaDataType* _tmp668_;
			ValaDataType* _tmp669_;
			ValaDataType* _tmp670_;
			ValaDataType* _tmp671_;
			ValaDataType* _tmp672_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp690_;
			ValaExpression* _tmp691_;
			ValaExpression* _tmp692_;
			ValaDynamicSignal* _tmp693_;
			ValaDynamicSignal* _tmp694_;
			ValaSymbol* _tmp695_;
			ValaSymbol* _tmp696_;
			ValaObjectType* _tmp697_;
			ValaObjectType* _tmp698_;
			ValaDelegate* _tmp699_;
			ValaDelegate* _tmp700_;
			ValaDelegateType* _tmp701_;
			ValaDelegateType* _tmp702_;
			_tmp664_ = dynamic_sig;
			_tmp665_ = dynamic_sig;
			_tmp666_ = vala_dynamic_signal_get_handler (_tmp665_);
			_tmp667_ = _tmp666_;
			_tmp668_ = vala_expression_get_value_type (_tmp667_);
			_tmp669_ = _tmp668_;
			_tmp670_ = vala_data_type_get_return_type (_tmp669_);
			_tmp671_ = vala_data_type_copy (_tmp670_);
			_tmp672_ = _tmp671_;
			vala_callable_set_return_type ((ValaCallable*) _tmp664_, _tmp672_);
			_vala_code_node_unref0 (_tmp672_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp673_;
				ValaExpression* _tmp674_;
				ValaExpression* _tmp675_;
				ValaDataType* _tmp676_;
				ValaDataType* _tmp677_;
				ValaList* _tmp678_;
				gint _param_size = 0;
				ValaList* _tmp679_;
				gint _tmp680_;
				gint _tmp681_;
				gint _param_index = 0;
				_tmp673_ = dynamic_sig;
				_tmp674_ = vala_dynamic_signal_get_handler (_tmp673_);
				_tmp675_ = _tmp674_;
				_tmp676_ = vala_expression_get_value_type (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_data_type_get_parameters (_tmp677_);
				_param_list = _tmp678_;
				_tmp679_ = _param_list;
				_tmp680_ = vala_collection_get_size ((ValaCollection*) _tmp679_);
				_tmp681_ = _tmp680_;
				_param_size = _tmp681_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp682_;
					gint _tmp683_;
					ValaParameter* param = NULL;
					ValaList* _tmp684_;
					gpointer _tmp685_;
					_param_index = _param_index + 1;
					_tmp682_ = _param_index;
					_tmp683_ = _param_size;
					if (!(_tmp682_ < _tmp683_)) {
						break;
					}
					_tmp684_ = _param_list;
					_tmp685_ = vala_list_get (_tmp684_, _param_index);
					param = (ValaParameter*) _tmp685_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp686_;
						ValaParameter* _tmp687_;
						ValaParameter* _tmp688_;
						ValaParameter* _tmp689_;
						_tmp686_ = dynamic_sig;
						_tmp687_ = param;
						_tmp688_ = vala_parameter_copy (_tmp687_);
						_tmp689_ = _tmp688_;
						vala_callable_add_parameter ((ValaCallable*) _tmp686_, _tmp689_);
						_vala_code_node_unref0 (_tmp689_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp690_ = dynamic_sig;
			_tmp691_ = vala_dynamic_signal_get_handler (_tmp690_);
			_tmp692_ = _tmp691_;
			_tmp693_ = dynamic_sig;
			_tmp694_ = dynamic_sig;
			_tmp695_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp694_);
			_tmp696_ = _tmp695_;
			_tmp697_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp698_ = _tmp697_;
			_tmp699_ = vala_signal_get_delegate ((ValaSignal*) _tmp693_, (ValaDataType*) _tmp698_, (ValaCodeNode*) self);
			_tmp700_ = _tmp699_;
			_tmp701_ = vala_delegate_type_new (_tmp700_);
			_tmp702_ = _tmp701_;
			vala_expression_set_target_type (_tmp692_, (ValaDataType*) _tmp702_);
			_vala_code_node_unref0 (_tmp702_);
			_vala_code_node_unref0 (_tmp700_);
			_vala_code_node_unref0 (_tmp698_);
		}
		_tmp704_ = m;
		if (_tmp704_ != NULL) {
			ValaMethod* _tmp705_;
			_tmp705_ = m;
			_tmp703_ = vala_method_has_type_parameters (_tmp705_);
		} else {
			_tmp703_ = FALSE;
		}
		if (_tmp703_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			ValaMemberAccess* _tmp708_;
			ValaList* _tmp709_;
			gint _tmp710_;
			gint _tmp711_;
			_tmp706_ = vala_method_call_get_call (self);
			_tmp707_ = _tmp706_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp707_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp708_ = ma;
			_tmp709_ = vala_member_access_get_type_arguments (_tmp708_);
			_tmp710_ = vala_collection_get_size ((ValaCollection*) _tmp709_);
			_tmp711_ = _tmp710_;
			if (_tmp711_ == 0) {
				ValaList* _tmp778_;
				ValaIterator* _tmp779_;
				ValaDataType* _tmp806_;
				ValaDataType* _tmp807_;
				ValaDataType* _tmp808_;
				ValaList* _tmp809_;
				ValaDataType* _tmp810_;
				ValaDataType* _tmp811_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp712_;
					ValaList* _tmp713_;
					gint _type_param_size = 0;
					ValaList* _tmp714_;
					gint _tmp715_;
					gint _tmp716_;
					gint _type_param_index = 0;
					_tmp712_ = m;
					_tmp713_ = vala_method_get_type_parameters (_tmp712_);
					_type_param_list = _tmp713_;
					_tmp714_ = _type_param_list;
					_tmp715_ = vala_collection_get_size ((ValaCollection*) _tmp714_);
					_tmp716_ = _tmp715_;
					_type_param_size = _tmp716_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp717_;
						gint _tmp718_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp719_;
						gpointer _tmp720_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp721_;
						ValaIterator* _tmp722_;
						gboolean _tmp758_ = FALSE;
						ValaDataType* _tmp759_;
						ValaDataType* _tmp769_;
						ValaMemberAccess* _tmp776_;
						ValaDataType* _tmp777_;
						_type_param_index = _type_param_index + 1;
						_tmp717_ = _type_param_index;
						_tmp718_ = _type_param_size;
						if (!(_tmp717_ < _tmp718_)) {
							break;
						}
						_tmp719_ = _type_param_list;
						_tmp720_ = vala_list_get (_tmp719_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp720_;
						type_arg = NULL;
						_tmp721_ = self->priv->argument_list;
						_tmp722_ = vala_iterable_iterator ((ValaIterable*) _tmp721_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp722_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp723_;
							gint _param_size = 0;
							ValaList* _tmp724_;
							gint _tmp725_;
							gint _tmp726_;
							gint _param_index = 0;
							_tmp723_ = params;
							_param_list = _tmp723_;
							_tmp724_ = _param_list;
							_tmp725_ = vala_collection_get_size ((ValaCollection*) _tmp724_);
							_tmp726_ = _tmp725_;
							_param_size = _tmp726_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp727_;
								gint _tmp728_;
								ValaParameter* param = NULL;
								ValaList* _tmp729_;
								gpointer _tmp730_;
								gboolean _tmp731_ = FALSE;
								ValaParameter* _tmp732_;
								gboolean _tmp733_;
								gboolean _tmp734_;
								ValaIterator* _tmp738_;
								_param_index = _param_index + 1;
								_tmp727_ = _param_index;
								_tmp728_ = _param_size;
								if (!(_tmp727_ < _tmp728_)) {
									break;
								}
								_tmp729_ = _param_list;
								_tmp730_ = vala_list_get (_tmp729_, _param_index);
								param = (ValaParameter*) _tmp730_;
								_tmp732_ = param;
								_tmp733_ = vala_parameter_get_ellipsis (_tmp732_);
								_tmp734_ = _tmp733_;
								if (_tmp734_) {
									_tmp731_ = TRUE;
								} else {
									ValaParameter* _tmp735_;
									gboolean _tmp736_;
									gboolean _tmp737_;
									_tmp735_ = param;
									_tmp736_ = vala_parameter_get_params_array (_tmp735_);
									_tmp737_ = _tmp736_;
									_tmp731_ = _tmp737_;
								}
								if (_tmp731_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp738_ = arg_it;
								if (vala_iterator_next (_tmp738_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp739_;
									gpointer _tmp740_;
									ValaParameter* _tmp741_;
									ValaDataType* _tmp742_;
									ValaDataType* _tmp743_;
									ValaTypeParameter* _tmp744_;
									ValaExpression* _tmp745_;
									ValaDataType* _tmp746_;
									ValaDataType* _tmp747_;
									ValaDataType* _tmp748_;
									ValaDataType* _tmp749_;
									ValaExpression* _tmp750_;
									ValaExpression* _tmp751_;
									ValaDataType* _tmp752_;
									ValaDataType* _tmp753_;
									ValaDataType* _tmp754_;
									ValaList* _tmp755_;
									ValaDataType* _tmp756_;
									ValaDataType* _tmp757_;
									_tmp739_ = arg_it;
									_tmp740_ = vala_iterator_get (_tmp739_);
									arg = (ValaExpression*) _tmp740_;
									_tmp741_ = param;
									_tmp742_ = vala_variable_get_variable_type ((ValaVariable*) _tmp741_);
									_tmp743_ = _tmp742_;
									_tmp744_ = type_param;
									_tmp745_ = arg;
									_tmp746_ = vala_expression_get_value_type (_tmp745_);
									_tmp747_ = _tmp746_;
									_tmp748_ = vala_data_type_infer_type_argument (_tmp743_, _tmp744_, _tmp747_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp748_;
									_tmp749_ = type_arg;
									if (_tmp749_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp750_ = arg;
									_tmp751_ = arg;
									_tmp752_ = vala_expression_get_formal_target_type (_tmp751_);
									_tmp753_ = _tmp752_;
									_tmp754_ = target_object_type;
									_tmp755_ = method_type_args;
									_tmp756_ = vala_data_type_get_actual_type (_tmp753_, _tmp754_, _tmp755_, (ValaCodeNode*) self);
									_tmp757_ = _tmp756_;
									vala_expression_set_target_type (_tmp750_, _tmp757_);
									_vala_code_node_unref0 (_tmp757_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp759_ = type_arg;
						if (_tmp759_ == NULL) {
							ValaDataType* _tmp760_;
							ValaDataType* _tmp761_;
							_tmp760_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp761_ = _tmp760_;
							_tmp758_ = _tmp761_ != NULL;
						} else {
							_tmp758_ = FALSE;
						}
						if (_tmp758_) {
							ValaMethod* _tmp762_;
							ValaDataType* _tmp763_;
							ValaDataType* _tmp764_;
							ValaTypeParameter* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							_tmp762_ = m;
							_tmp763_ = vala_callable_get_return_type ((ValaCallable*) _tmp762_);
							_tmp764_ = _tmp763_;
							_tmp765_ = type_param;
							_tmp766_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp767_ = _tmp766_;
							_tmp768_ = vala_data_type_infer_type_argument (_tmp764_, _tmp765_, _tmp767_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp768_;
						}
						_tmp769_ = type_arg;
						if (_tmp769_ == NULL) {
							ValaMemberAccess* _tmp770_;
							ValaSourceReference* _tmp771_;
							ValaSourceReference* _tmp772_;
							ValaTypeParameter* _tmp773_;
							gchar* _tmp774_;
							gchar* _tmp775_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp770_ = ma;
							_tmp771_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp770_);
							_tmp772_ = _tmp771_;
							_tmp773_ = type_param;
							_tmp774_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp773_);
							_tmp775_ = _tmp774_;
							vala_report_error (_tmp772_, "cannot infer generic type argument for type parameter `%s'", _tmp775_);
							_g_free0 (_tmp775_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp776_ = ma;
						_tmp777_ = type_arg;
						vala_member_access_add_type_argument (_tmp776_, _tmp777_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp778_ = self->priv->argument_list;
				_tmp779_ = vala_iterable_iterator ((ValaIterable*) _tmp778_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp779_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp780_;
					gint _param_size = 0;
					ValaList* _tmp781_;
					gint _tmp782_;
					gint _tmp783_;
					gint _param_index = 0;
					_tmp780_ = params;
					_param_list = _tmp780_;
					_tmp781_ = _param_list;
					_tmp782_ = vala_collection_get_size ((ValaCollection*) _tmp781_);
					_tmp783_ = _tmp782_;
					_param_size = _tmp783_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp784_;
						gint _tmp785_;
						ValaParameter* param = NULL;
						ValaList* _tmp786_;
						gpointer _tmp787_;
						gboolean _tmp788_ = FALSE;
						ValaParameter* _tmp789_;
						gboolean _tmp790_;
						gboolean _tmp791_;
						ValaIterator* _tmp795_;
						_param_index = _param_index + 1;
						_tmp784_ = _param_index;
						_tmp785_ = _param_size;
						if (!(_tmp784_ < _tmp785_)) {
							break;
						}
						_tmp786_ = _param_list;
						_tmp787_ = vala_list_get (_tmp786_, _param_index);
						param = (ValaParameter*) _tmp787_;
						_tmp789_ = param;
						_tmp790_ = vala_parameter_get_ellipsis (_tmp789_);
						_tmp791_ = _tmp790_;
						if (_tmp791_) {
							_tmp788_ = TRUE;
						} else {
							ValaParameter* _tmp792_;
							gboolean _tmp793_;
							gboolean _tmp794_;
							_tmp792_ = param;
							_tmp793_ = vala_parameter_get_params_array (_tmp792_);
							_tmp794_ = _tmp793_;
							_tmp788_ = _tmp794_;
						}
						if (_tmp788_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp795_ = arg_it;
						if (vala_iterator_next (_tmp795_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp796_;
							gpointer _tmp797_;
							ValaExpression* _tmp798_;
							ValaExpression* _tmp799_;
							ValaDataType* _tmp800_;
							ValaDataType* _tmp801_;
							ValaDataType* _tmp802_;
							ValaList* _tmp803_;
							ValaDataType* _tmp804_;
							ValaDataType* _tmp805_;
							_tmp796_ = arg_it;
							_tmp797_ = vala_iterator_get (_tmp796_);
							arg = (ValaExpression*) _tmp797_;
							_tmp798_ = arg;
							_tmp799_ = arg;
							_tmp800_ = vala_expression_get_formal_target_type (_tmp799_);
							_tmp801_ = _tmp800_;
							_tmp802_ = target_object_type;
							_tmp803_ = method_type_args;
							_tmp804_ = vala_data_type_get_actual_type (_tmp801_, _tmp802_, _tmp803_, (ValaCodeNode*) self);
							_tmp805_ = _tmp804_;
							vala_expression_set_target_type (_tmp798_, _tmp805_);
							_vala_code_node_unref0 (_tmp805_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp806_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp807_ = _tmp806_;
				_tmp808_ = target_object_type;
				_tmp809_ = method_type_args;
				_tmp810_ = vala_data_type_get_actual_type (_tmp807_, _tmp808_, _tmp809_, (ValaCodeNode*) self);
				_tmp811_ = _tmp810_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp811_);
				_vala_code_node_unref0 (_tmp811_);
			}
		}
		_tmp813_ = m;
		if (_tmp813_ != NULL) {
			ValaMethod* _tmp814_;
			gboolean _tmp815_;
			gboolean _tmp816_;
			_tmp814_ = m;
			_tmp815_ = vala_method_get_coroutine (_tmp814_);
			_tmp816_ = _tmp815_;
			_tmp812_ = _tmp816_;
		} else {
			_tmp812_ = FALSE;
		}
		if (_tmp812_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp817_;
			ValaExpression* _tmp818_;
			ValaMemberAccess* _tmp819_;
			const gchar* _tmp820_;
			const gchar* _tmp821_;
			_tmp817_ = vala_method_call_get_call (self);
			_tmp818_ = _tmp817_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp818_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp819_ = ma;
			_tmp820_ = vala_member_access_get_member_name (_tmp819_);
			_tmp821_ = _tmp820_;
			if (g_strcmp0 (_tmp821_, "end") == 0) {
				ValaMethod* _tmp822_;
				ValaMethod* _tmp823_;
				ValaMethodType* _tmp824_;
				_tmp822_ = m;
				_tmp823_ = vala_method_get_end_method (_tmp822_);
				_tmp824_ = vala_method_type_new (_tmp823_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp824_;
			}
		}
	}
	_tmp825_ = vala_code_context_get_analyzer (context);
	_tmp826_ = _tmp825_;
	_tmp827_ = mtype;
	_tmp828_ = params;
	_tmp829_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp826_, (ValaExpression*) self, _tmp827_, _tmp828_, _tmp829_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp830_;
		gint _arg_size = 0;
		ValaList* _tmp831_;
		gint _tmp832_;
		gint _tmp833_;
		gint _arg_index = 0;
		_tmp830_ = self->priv->argument_list;
		_arg_list = _tmp830_;
		_tmp831_ = _arg_list;
		_tmp832_ = vala_collection_get_size ((ValaCollection*) _tmp831_);
		_tmp833_ = _tmp832_;
		_arg_size = _tmp833_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp834_;
			gint _tmp835_;
			ValaExpression* arg = NULL;
			ValaList* _tmp836_;
			gpointer _tmp837_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp838_;
			gboolean _tmp839_ = FALSE;
			ValaSizeofExpression* _tmp840_;
			_arg_index = _arg_index + 1;
			_tmp834_ = _arg_index;
			_tmp835_ = _arg_size;
			if (!(_tmp834_ < _tmp835_)) {
				break;
			}
			_tmp836_ = _arg_list;
			_tmp837_ = vala_list_get (_tmp836_, _arg_index);
			arg = (ValaExpression*) _tmp837_;
			_tmp838_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp838_) ? ((ValaSizeofExpression*) _tmp838_) : NULL;
			_tmp840_ = sizeof_expr;
			if (_tmp840_ != NULL) {
				ValaSizeofExpression* _tmp841_;
				ValaDataType* _tmp842_;
				ValaDataType* _tmp843_;
				_tmp841_ = sizeof_expr;
				_tmp842_ = vala_sizeof_expression_get_type_reference (_tmp841_);
				_tmp843_ = _tmp842_;
				_tmp839_ = VALA_IS_GENERIC_TYPE (_tmp843_);
			} else {
				_tmp839_ = FALSE;
			}
			if (_tmp839_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp844_;
				ValaDataType* _tmp845_;
				ValaDataType* _tmp846_;
				ValaDataType* _tmp847_;
				ValaList* _tmp848_;
				ValaDataType* _tmp849_;
				ValaExpression* _tmp850_;
				ValaDataType* _tmp851_;
				ValaSourceReference* _tmp852_;
				ValaSourceReference* _tmp853_;
				ValaSizeofExpression* _tmp854_;
				ValaSizeofExpression* _tmp855_;
				_tmp844_ = sizeof_expr;
				_tmp845_ = vala_sizeof_expression_get_type_reference (_tmp844_);
				_tmp846_ = _tmp845_;
				_tmp847_ = target_object_type;
				_tmp848_ = method_type_args;
				_tmp849_ = vala_data_type_get_actual_type (_tmp846_, _tmp847_, _tmp848_, (ValaCodeNode*) self);
				sizeof_type = _tmp849_;
				_tmp850_ = arg;
				_tmp851_ = sizeof_type;
				_tmp852_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp853_ = _tmp852_;
				_tmp854_ = vala_sizeof_expression_new (_tmp851_, _tmp853_);
				_tmp855_ = _tmp854_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp850_, (ValaExpression*) _tmp855_);
				_vala_code_node_unref0 (_tmp855_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp858_ = base_cm;
	if (_tmp858_ != NULL) {
		ValaCreationMethod* _tmp859_;
		_tmp859_ = base_cm;
		_tmp857_ = vala_method_is_variadic ((ValaMethod*) _tmp859_);
	} else {
		_tmp857_ = FALSE;
	}
	if (_tmp857_) {
		ValaList* _tmp860_;
		gint _tmp861_;
		gint _tmp862_;
		ValaCreationMethod* _tmp863_;
		ValaList* _tmp864_;
		gint _tmp865_;
		gint _tmp866_;
		_tmp860_ = self->priv->argument_list;
		_tmp861_ = vala_collection_get_size ((ValaCollection*) _tmp860_);
		_tmp862_ = _tmp861_;
		_tmp863_ = base_cm;
		_tmp864_ = vala_callable_get_parameters ((ValaCallable*) _tmp863_);
		_tmp865_ = vala_collection_get_size ((ValaCollection*) _tmp864_);
		_tmp866_ = _tmp865_;
		_tmp856_ = _tmp862_ == _tmp866_;
	} else {
		_tmp856_ = FALSE;
	}
	if (_tmp856_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp867_;
		ValaList* _tmp868_;
		gint _tmp869_;
		gint _tmp870_;
		gpointer _tmp871_;
		gboolean _tmp872_ = FALSE;
		ValaExpression* _tmp873_;
		ValaDataType* _tmp874_;
		ValaDataType* _tmp875_;
		_tmp867_ = self->priv->argument_list;
		_tmp868_ = self->priv->argument_list;
		_tmp869_ = vala_collection_get_size ((ValaCollection*) _tmp868_);
		_tmp870_ = _tmp869_;
		_tmp871_ = vala_list_get (_tmp867_, _tmp870_ - 1);
		this_last_arg = (ValaExpression*) _tmp871_;
		_tmp873_ = this_last_arg;
		_tmp874_ = vala_expression_get_value_type (_tmp873_);
		_tmp875_ = _tmp874_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp875_)) {
			ValaExpression* _tmp876_;
			ValaDataType* _tmp877_;
			ValaDataType* _tmp878_;
			ValaTypeSymbol* _tmp879_;
			ValaTypeSymbol* _tmp880_;
			ValaSemanticAnalyzer* _tmp881_;
			ValaSemanticAnalyzer* _tmp882_;
			ValaDataType* _tmp883_;
			ValaTypeSymbol* _tmp884_;
			ValaTypeSymbol* _tmp885_;
			_tmp876_ = this_last_arg;
			_tmp877_ = vala_expression_get_value_type (_tmp876_);
			_tmp878_ = _tmp877_;
			_tmp879_ = vala_data_type_get_type_symbol (_tmp878_);
			_tmp880_ = _tmp879_;
			_tmp881_ = vala_code_context_get_analyzer (context);
			_tmp882_ = _tmp881_;
			_tmp883_ = _tmp882_->va_list_type;
			_tmp884_ = vala_data_type_get_type_symbol (_tmp883_);
			_tmp885_ = _tmp884_;
			_tmp872_ = _tmp880_ == _tmp885_;
		} else {
			_tmp872_ = FALSE;
		}
		if (_tmp872_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp886_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp887_ = _tmp886_;
	vala_code_node_check ((ValaCodeNode*) _tmp887_, context);
	_tmp888_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp889_ = _tmp888_;
	if (_tmp889_) {
		gboolean _tmp890_ = FALSE;
		ValaCodeNode* _tmp891_;
		ValaCodeNode* _tmp892_;
		_tmp891_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp892_ = _tmp891_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp892_)) {
			_tmp890_ = TRUE;
		} else {
			ValaCodeNode* _tmp893_;
			ValaCodeNode* _tmp894_;
			_tmp893_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp894_ = _tmp893_;
			_tmp890_ = VALA_IS_EXPRESSION_STATEMENT (_tmp894_);
		}
		if (_tmp890_) {
		} else {
			ValaSemanticAnalyzer* _tmp895_;
			ValaSemanticAnalyzer* _tmp896_;
			ValaSymbol* _tmp897_;
			ValaSymbol* _tmp898_;
			_tmp895_ = vala_code_context_get_analyzer (context);
			_tmp896_ = _tmp895_;
			_tmp897_ = vala_semantic_analyzer_get_current_symbol (_tmp896_);
			_tmp898_ = _tmp897_;
			if (!VALA_IS_BLOCK (_tmp898_)) {
				ValaSourceReference* _tmp899_;
				ValaSourceReference* _tmp900_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp900_ = _tmp899_;
				vala_report_error (_tmp900_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp901_;
				ValaCodeNode* _tmp902_;
				ValaCodeNode* _tmp903_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp904_;
				ValaDataType* _tmp905_;
				ValaDataType* _tmp906_;
				ValaDataType* _tmp907_;
				gchar* _tmp908_;
				gchar* _tmp909_;
				ValaSourceReference* _tmp910_;
				ValaSourceReference* _tmp911_;
				ValaLocalVariable* _tmp912_;
				ValaLocalVariable* _tmp913_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp914_;
				ValaSourceReference* _tmp915_;
				ValaSourceReference* _tmp916_;
				ValaDeclarationStatement* _tmp917_;
				ValaDataType* _tmp918_;
				ValaDataType* _tmp919_;
				ValaSemanticAnalyzer* _tmp923_;
				ValaSemanticAnalyzer* _tmp924_;
				ValaBlock* _tmp925_;
				ValaDeclarationStatement* _tmp926_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp927_;
				ValaDataType* _tmp928_;
				ValaDataType* _tmp929_;
				ValaExpression* _tmp930_;
				ValaExpression* _tmp931_;
				ValaDataType* _tmp932_;
				ValaDataType* _tmp933_;
				ValaLocalVariable* _tmp934_;
				ValaDeclarationStatement* _tmp935_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp936_;
				ValaSemanticAnalyzer* _tmp937_;
				ValaSymbol* _tmp938_;
				ValaSymbol* _tmp939_;
				ValaBlock* _tmp940_;
				ValaBlock* _tmp941_;
				ValaLocalVariable* _tmp942_;
				ValaSemanticAnalyzer* _tmp943_;
				ValaSemanticAnalyzer* _tmp944_;
				ValaBlock* _tmp945_;
				ValaLocalVariable* _tmp946_;
				ValaCodeNode* _tmp947_;
				ValaExpression* _tmp948_;
				ValaExpression* _tmp949_;
				_tmp901_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp902_ = _tmp901_;
				_tmp903_ = _vala_code_node_ref0 (_tmp902_);
				old_parent_node = _tmp903_;
				_tmp904_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp905_ = _tmp904_;
				_tmp906_ = vala_data_type_copy (_tmp905_);
				_tmp907_ = _tmp906_;
				_tmp908_ = vala_code_node_get_temp_name ();
				_tmp909_ = _tmp908_;
				_tmp910_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp911_ = _tmp910_;
				_tmp912_ = vala_local_variable_new (_tmp907_, _tmp909_, NULL, _tmp911_);
				_tmp913_ = _tmp912_;
				_g_free0 (_tmp909_);
				_vala_code_node_unref0 (_tmp907_);
				local = _tmp913_;
				_tmp914_ = local;
				_tmp915_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp916_ = _tmp915_;
				_tmp917_ = vala_declaration_statement_new ((ValaSymbol*) _tmp914_, _tmp916_);
				decl = _tmp917_;
				_tmp918_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp919_ = _tmp918_;
				if (_tmp919_ == NULL) {
					ValaLocalVariable* _tmp920_;
					ValaDataType* _tmp921_;
					ValaDataType* _tmp922_;
					_tmp920_ = local;
					_tmp921_ = vala_variable_get_variable_type ((ValaVariable*) _tmp920_);
					_tmp922_ = _tmp921_;
					vala_data_type_set_floating_reference (_tmp922_, FALSE);
				}
				_tmp923_ = vala_code_context_get_analyzer (context);
				_tmp924_ = _tmp923_;
				_tmp925_ = _tmp924_->insert_block;
				_tmp926_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp925_, (ValaStatement*) _tmp926_);
				_tmp927_ = local;
				_tmp928_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp929_ = _tmp928_;
				_tmp930_ = vala_semantic_analyzer_create_temp_access (_tmp927_, _tmp929_);
				temp_access = _tmp930_;
				_tmp931_ = temp_access;
				_tmp932_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp933_ = _tmp932_;
				vala_expression_set_formal_target_type (_tmp931_, _tmp933_);
				_tmp934_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp934_, (ValaExpression*) self);
				_tmp935_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp935_, context);
				_tmp936_ = vala_code_context_get_analyzer (context);
				_tmp937_ = _tmp936_;
				_tmp938_ = vala_semantic_analyzer_get_current_symbol (_tmp937_);
				_tmp939_ = _tmp938_;
				_tmp940_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp939_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp940_;
				_tmp941_ = block;
				_tmp942_ = local;
				vala_block_remove_local_variable (_tmp941_, _tmp942_);
				_tmp943_ = vala_code_context_get_analyzer (context);
				_tmp944_ = _tmp943_;
				_tmp945_ = _tmp944_->insert_block;
				_tmp946_ = local;
				vala_block_add_local_variable (_tmp945_, _tmp946_);
				_tmp947_ = old_parent_node;
				_tmp948_ = temp_access;
				vala_code_node_replace_expression (_tmp947_, (ValaExpression*) self, _tmp948_);
				_tmp949_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp949_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp950_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp951_ = _tmp950_;
	result = !_tmp951_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_method_call_get_call (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result = NULL;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

