/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp602_ = FALSE;
	gboolean _tmp603_ = FALSE;
	gboolean _tmp604_ = FALSE;
	ValaExpression* _tmp605_;
	ValaExpression* _tmp606_;
	ValaSymbol* _tmp632_;
	ValaSymbol* _tmp633_;
	ValaSymbol* _tmp687_;
	ValaSymbol* _tmp688_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp726_;
	ValaSymbol* _tmp727_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp728_;
	ValaSymbol* _tmp729_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1116_;
	ValaSymbol* _tmp1117_;
	ValaSymbol* _tmp1119_;
	ValaVersionAttribute* _tmp1120_;
	ValaVersionAttribute* _tmp1121_;
	ValaSourceReference* _tmp1122_;
	ValaSourceReference* _tmp1123_;
	gboolean _tmp1124_ = FALSE;
	ValaSymbolAccessibility _tmp1125_;
	gboolean _tmp1181_ = FALSE;
	gboolean _tmp1208_ = FALSE;
	gboolean _tmp1209_ = FALSE;
	ValaDataType* _tmp1486_;
	ValaDataType* _tmp1487_;
	gboolean _tmp1490_;
	gboolean _tmp1491_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaUsingDirective* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp156_;
						ValaSymbol* _tmp157_;
						ValaSymbol* _tmp158_;
						ValaScope* _tmp159_;
						ValaScope* _tmp160_;
						const gchar* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaSymbol* _tmp163_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_code_node_get_error ((ValaCodeNode*) _tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp156_ = ns;
						_tmp157_ = vala_using_directive_get_namespace_symbol (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_symbol_get_scope (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = self->priv->_member_name;
						_tmp162_ = vala_scope_lookup (_tmp160_, _tmp161_);
						local_sym = _tmp162_;
						_tmp163_ = local_sym;
						if (_tmp163_ != NULL) {
							gboolean _tmp164_ = FALSE;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							ValaSymbol* _tmp184_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp204_;
							ValaExpression* _tmp205_;
							ValaExpression* _tmp206_;
							ValaSymbol* _tmp207_;
							_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp166_ = _tmp165_;
							if (_tmp166_ != NULL) {
								ValaSymbol* _tmp167_;
								ValaSymbol* _tmp168_;
								ValaSymbol* _tmp169_;
								_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = local_sym;
								_tmp164_ = _tmp168_ != _tmp169_;
							} else {
								_tmp164_ = FALSE;
							}
							if (_tmp164_) {
								ValaSourceReference* _tmp170_;
								ValaSourceReference* _tmp171_;
								const gchar* _tmp172_;
								ValaSymbol* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								gchar* _tmp181_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = self->priv->_member_name;
								_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp174_ = _tmp173_;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = local_sym;
								_tmp178_ = vala_symbol_get_full_name (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp180_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp172_, _tmp176_, _tmp179_);
								_tmp181_ = _tmp180_;
								vala_report_error (_tmp171_, _tmp181_);
								_g_free0 (_tmp181_);
								_g_free0 (_tmp179_);
								_g_free0 (_tmp176_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp182_ = local_sym;
							_tmp183_ = vala_symbol_get_parent_symbol (_tmp182_);
							_tmp184_ = _tmp183_;
							inner_sym = _tmp184_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp185_ = FALSE;
								ValaSymbol* _tmp186_;
								ValaMemberAccess* _tmp190_;
								ValaSymbol* _tmp191_;
								const gchar* _tmp192_;
								const gchar* _tmp193_;
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								ValaMemberAccess* _tmp196_;
								ValaMemberAccess* _tmp197_;
								ValaMemberAccess* _tmp198_;
								ValaExpression* _tmp199_;
								ValaExpression* _tmp200_;
								ValaSymbol* _tmp201_;
								ValaSymbol* _tmp202_;
								ValaSymbol* _tmp203_;
								_tmp186_ = inner_sym;
								if (_tmp186_ != NULL) {
									ValaSymbol* _tmp187_;
									const gchar* _tmp188_;
									const gchar* _tmp189_;
									_tmp187_ = inner_sym;
									_tmp188_ = vala_symbol_get_name (_tmp187_);
									_tmp189_ = _tmp188_;
									_tmp185_ = _tmp189_ != NULL;
								} else {
									_tmp185_ = FALSE;
								}
								if (!_tmp185_) {
									break;
								}
								_tmp190_ = inner_ma;
								_tmp191_ = inner_sym;
								_tmp192_ = vala_symbol_get_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_member_access_new (NULL, _tmp193_, _tmp195_);
								_tmp197_ = _tmp196_;
								vala_member_access_set_inner (_tmp190_, (ValaExpression*) _tmp197_);
								_vala_code_node_unref0 (_tmp197_);
								_tmp198_ = inner_ma;
								_tmp199_ = vala_member_access_get_inner (_tmp198_);
								_tmp200_ = _tmp199_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp201_ = inner_sym;
								_tmp202_ = vala_symbol_get_parent_symbol (_tmp201_);
								_tmp203_ = _tmp202_;
								inner_sym = _tmp203_;
							}
							_tmp204_ = inner_ma;
							vala_member_access_set_qualified (_tmp204_, TRUE);
							_tmp205_ = vala_member_access_get_inner (self);
							_tmp206_ = _tmp205_;
							vala_code_node_check ((ValaCodeNode*) _tmp206_, context);
							_tmp207_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp207_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			gboolean _tmp210_;
			gboolean _tmp211_;
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			ValaDataType* _tmp214_;
			ValaDataType* _tmp215_;
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			gboolean _tmp249_ = FALSE;
			ValaExpression* _tmp250_;
			ValaExpression* _tmp251_;
			gboolean _tmp258_ = FALSE;
			ValaExpression* _tmp259_;
			ValaExpression* _tmp260_;
			gboolean _tmp281_ = FALSE;
			ValaExpression* _tmp282_;
			ValaExpression* _tmp283_;
			gboolean _tmp302_ = FALSE;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			gboolean _tmp338_ = FALSE;
			gboolean _tmp339_ = FALSE;
			ValaSymbol* _tmp340_;
			ValaSymbol* _tmp341_;
			gboolean _tmp573_ = FALSE;
			ValaSymbol* _tmp574_;
			ValaSymbol* _tmp575_;
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_code_node_get_error ((ValaCodeNode*) _tmp209_);
			_tmp211_ = _tmp210_;
			if (_tmp211_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp212_ = vala_member_access_get_inner (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_expression_get_value_type (_tmp213_);
			_tmp215_ = _tmp214_;
			if (VALA_IS_POINTER_TYPE (_tmp215_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp216_;
				ValaExpression* _tmp217_;
				ValaDataType* _tmp218_;
				ValaDataType* _tmp219_;
				gboolean _tmp220_ = FALSE;
				ValaPointerType* _tmp221_;
				_tmp216_ = vala_member_access_get_inner (self);
				_tmp217_ = _tmp216_;
				_tmp218_ = vala_expression_get_value_type (_tmp217_);
				_tmp219_ = _tmp218_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp219_) ? ((ValaPointerType*) _tmp219_) : NULL;
				_tmp221_ = pointer_type;
				if (_tmp221_ != NULL) {
					ValaPointerType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					_tmp222_ = pointer_type;
					_tmp223_ = vala_pointer_type_get_base_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp220_ = VALA_IS_VALUE_TYPE (_tmp224_);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaPointerIndirection* _tmp229_;
					ValaPointerIndirection* _tmp230_;
					ValaExpression* _tmp231_;
					ValaExpression* _tmp232_;
					_tmp225_ = vala_member_access_get_inner (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_pointer_indirection_new (_tmp226_, _tmp228_);
					_tmp230_ = _tmp229_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp230_);
					_vala_code_node_unref0 (_tmp230_);
					_tmp231_ = vala_member_access_get_inner (self);
					_tmp232_ = _tmp231_;
					vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp233_ = vala_member_access_get_inner (self);
			_tmp234_ = _tmp233_;
			if (VALA_IS_MEMBER_ACCESS (_tmp234_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaMemberAccess* _tmp237_;
				gboolean _tmp238_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp237_ = ma;
				_tmp238_ = _tmp237_->priv->_prototype_access;
				if (_tmp238_) {
					ValaSourceReference* _tmp239_;
					ValaSourceReference* _tmp240_;
					ValaExpression* _tmp241_;
					ValaExpression* _tmp242_;
					ValaSymbol* _tmp243_;
					ValaSymbol* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_member_access_get_inner (self);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_expression_get_symbol_reference (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_symbol_get_full_name (_tmp244_);
					_tmp246_ = _tmp245_;
					_tmp247_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp246_);
					_tmp248_ = _tmp247_;
					vala_report_error (_tmp240_, _tmp248_);
					_g_free0 (_tmp248_);
					_g_free0 (_tmp246_);
					result = FALSE;
					return result;
				}
			}
			_tmp250_ = vala_member_access_get_inner (self);
			_tmp251_ = _tmp250_;
			if (VALA_IS_CAST_EXPRESSION (_tmp251_)) {
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				gboolean _tmp254_;
				gboolean _tmp255_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp253_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp255_ = _tmp254_;
				_tmp249_ = _tmp255_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaSourceReference* _tmp256_;
				ValaSourceReference* _tmp257_;
				_tmp256_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp257_ = _tmp256_;
				vala_report_warning (_tmp257_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp259_ = vala_member_access_get_inner (self);
			_tmp260_ = _tmp259_;
			if (VALA_IS_MEMBER_ACCESS (_tmp260_)) {
				_tmp258_ = TRUE;
			} else {
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				_tmp261_ = vala_member_access_get_inner (self);
				_tmp262_ = _tmp261_;
				_tmp258_ = VALA_IS_BASE_ACCESS (_tmp262_);
			}
			if (_tmp258_) {
				ValaExpression* _tmp263_;
				ValaExpression* _tmp264_;
				ValaSymbol* _tmp265_;
				ValaSymbol* _tmp266_;
				gboolean _tmp267_ = FALSE;
				ValaSymbol* _tmp268_;
				ValaSymbol* _tmp269_;
				_tmp263_ = vala_member_access_get_inner (self);
				_tmp264_ = _tmp263_;
				_tmp265_ = vala_expression_get_symbol_reference (_tmp264_);
				_tmp266_ = _tmp265_;
				base_symbol = _tmp266_;
				_tmp268_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp269_ = _tmp268_;
				if (_tmp269_ == NULL) {
					gboolean _tmp270_ = FALSE;
					ValaSymbol* _tmp271_;
					_tmp271_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp271_)) {
						_tmp270_ = TRUE;
					} else {
						ValaSymbol* _tmp272_;
						_tmp272_ = base_symbol;
						_tmp270_ = VALA_IS_TYPESYMBOL (_tmp272_);
					}
					_tmp267_ = _tmp270_;
				} else {
					_tmp267_ = FALSE;
				}
				if (_tmp267_) {
					ValaSymbol* _tmp273_;
					ValaScope* _tmp274_;
					ValaScope* _tmp275_;
					const gchar* _tmp276_;
					ValaSymbol* _tmp277_;
					ValaSymbol* _tmp278_;
					ValaExpression* _tmp279_;
					ValaExpression* _tmp280_;
					_tmp273_ = base_symbol;
					_tmp274_ = vala_symbol_get_scope (_tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = self->priv->_member_name;
					_tmp277_ = vala_scope_lookup (_tmp275_, _tmp276_);
					_tmp278_ = _tmp277_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp278_);
					_vala_code_node_unref0 (_tmp278_);
					_tmp279_ = vala_member_access_get_inner (self);
					_tmp280_ = _tmp279_;
					if (VALA_IS_BASE_ACCESS (_tmp280_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp282_ = vala_member_access_get_inner (self);
			_tmp283_ = _tmp282_;
			if (VALA_IS_MEMBER_ACCESS (_tmp283_)) {
				ValaExpression* _tmp284_;
				ValaExpression* _tmp285_;
				ValaSymbol* _tmp286_;
				ValaSymbol* _tmp287_;
				_tmp284_ = vala_member_access_get_inner (self);
				_tmp285_ = _tmp284_;
				_tmp286_ = vala_expression_get_symbol_reference (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp281_ = VALA_IS_TYPEPARAMETER (_tmp287_);
			} else {
				_tmp281_ = FALSE;
			}
			if (_tmp281_) {
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaExpression* _tmp290_;
				ValaExpression* _tmp291_;
				ValaSymbol* _tmp292_;
				ValaSymbol* _tmp293_;
				ValaGenericType* _tmp294_;
				ValaGenericType* _tmp295_;
				ValaExpression* _tmp296_;
				ValaExpression* _tmp297_;
				ValaDataType* _tmp298_;
				ValaDataType* _tmp299_;
				ValaSourceReference* _tmp300_;
				ValaSourceReference* _tmp301_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_member_access_get_inner (self);
				_tmp291_ = _tmp290_;
				_tmp292_ = vala_expression_get_symbol_reference (_tmp291_);
				_tmp293_ = _tmp292_;
				_tmp294_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp293_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp295_ = _tmp294_;
				vala_expression_set_value_type (_tmp289_, (ValaDataType*) _tmp295_);
				_vala_code_node_unref0 (_tmp295_);
				_tmp296_ = vala_member_access_get_inner (self);
				_tmp297_ = _tmp296_;
				_tmp298_ = vala_expression_get_value_type (_tmp297_);
				_tmp299_ = _tmp298_;
				_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp301_ = _tmp300_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp299_, _tmp301_);
			}
			_tmp303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp304_ = _tmp303_;
			if (_tmp304_ == NULL) {
				ValaExpression* _tmp305_;
				ValaExpression* _tmp306_;
				ValaDataType* _tmp307_;
				ValaDataType* _tmp308_;
				_tmp305_ = vala_member_access_get_inner (self);
				_tmp306_ = _tmp305_;
				_tmp307_ = vala_expression_get_value_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp302_ = _tmp308_ != NULL;
			} else {
				_tmp302_ = FALSE;
			}
			if (_tmp302_) {
				gboolean _tmp309_;
				ValaSymbol* _tmp336_;
				ValaSymbol* _tmp337_;
				_tmp309_ = self->priv->_pointer_member_access;
				if (_tmp309_) {
					ValaExpression* _tmp310_;
					ValaExpression* _tmp311_;
					ValaDataType* _tmp312_;
					ValaDataType* _tmp313_;
					const gchar* _tmp314_;
					ValaSymbol* _tmp315_;
					ValaSymbol* _tmp316_;
					_tmp310_ = vala_member_access_get_inner (self);
					_tmp311_ = _tmp310_;
					_tmp312_ = vala_expression_get_value_type (_tmp311_);
					_tmp313_ = _tmp312_;
					_tmp314_ = self->priv->_member_name;
					_tmp315_ = vala_data_type_get_pointer_member (_tmp313_, _tmp314_);
					_tmp316_ = _tmp315_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp316_);
					_vala_code_node_unref0 (_tmp316_);
				} else {
					ValaExpression* _tmp317_;
					ValaExpression* _tmp318_;
					ValaDataType* _tmp319_;
					ValaDataType* _tmp320_;
					ValaTypeSymbol* _tmp321_;
					ValaTypeSymbol* _tmp322_;
					ValaExpression* _tmp329_;
					ValaExpression* _tmp330_;
					ValaDataType* _tmp331_;
					ValaDataType* _tmp332_;
					const gchar* _tmp333_;
					ValaSymbol* _tmp334_;
					ValaSymbol* _tmp335_;
					_tmp317_ = vala_member_access_get_inner (self);
					_tmp318_ = _tmp317_;
					_tmp319_ = vala_expression_get_value_type (_tmp318_);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_data_type_get_type_symbol (_tmp320_);
					_tmp322_ = _tmp321_;
					if (_tmp322_ != NULL) {
						ValaExpression* _tmp323_;
						ValaExpression* _tmp324_;
						ValaDataType* _tmp325_;
						ValaDataType* _tmp326_;
						ValaTypeSymbol* _tmp327_;
						ValaTypeSymbol* _tmp328_;
						_tmp323_ = vala_member_access_get_inner (self);
						_tmp324_ = _tmp323_;
						_tmp325_ = vala_expression_get_value_type (_tmp324_);
						_tmp326_ = _tmp325_;
						_tmp327_ = vala_data_type_get_type_symbol (_tmp326_);
						_tmp328_ = _tmp327_;
						base_symbol = (ValaSymbol*) _tmp328_;
					}
					_tmp329_ = vala_member_access_get_inner (self);
					_tmp330_ = _tmp329_;
					_tmp331_ = vala_expression_get_value_type (_tmp330_);
					_tmp332_ = _tmp331_;
					_tmp333_ = self->priv->_member_name;
					_tmp334_ = vala_data_type_get_member (_tmp332_, _tmp333_);
					_tmp335_ = _tmp334_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp335_);
					_vala_code_node_unref0 (_tmp335_);
				}
				_tmp336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp337_ = _tmp336_;
				if (_tmp337_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp340_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp341_ = _tmp340_;
			if (_tmp341_ == NULL) {
				ValaExpression* _tmp342_;
				ValaExpression* _tmp343_;
				ValaDataType* _tmp344_;
				ValaDataType* _tmp345_;
				_tmp342_ = vala_member_access_get_inner (self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_expression_get_value_type (_tmp343_);
				_tmp345_ = _tmp344_;
				_tmp339_ = _tmp345_ != NULL;
			} else {
				_tmp339_ = FALSE;
			}
			if (_tmp339_) {
				ValaExpression* _tmp346_;
				ValaExpression* _tmp347_;
				ValaDataType* _tmp348_;
				ValaDataType* _tmp349_;
				gboolean _tmp350_;
				gboolean _tmp351_;
				_tmp346_ = vala_member_access_get_inner (self);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_expression_get_value_type (_tmp347_);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_data_type_get_is_dynamic (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp338_ = _tmp351_;
			} else {
				_tmp338_ = FALSE;
			}
			if (_tmp338_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp352_;
				ValaExpression* _tmp353_;
				ValaDataType* _tmp354_;
				ValaDataType* _tmp355_;
				ValaObjectType* _tmp356_;
				ValaCodeNode* _tmp357_;
				ValaCodeNode* _tmp358_;
				ValaSymbol* _tmp521_;
				ValaSymbol* _tmp522_;
				ValaSymbol* _tmp571_;
				ValaSymbol* _tmp572_;
				_tmp352_ = vala_member_access_get_inner (self);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_expression_get_value_type (_tmp353_);
				_tmp355_ = _tmp354_;
				_tmp356_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp355_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp356_;
				_tmp357_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp358_ = _tmp357_;
				if (VALA_IS_METHOD_CALL (_tmp358_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp359_;
					ValaCodeNode* _tmp360_;
					ValaMethodCall* _tmp361_;
					ValaExpression* _tmp362_;
					ValaExpression* _tmp363_;
					_tmp359_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp360_ = _tmp359_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp361_ = invoc;
					_tmp362_ = vala_method_call_get_call (_tmp361_);
					_tmp363_ = _tmp362_;
					if (_tmp363_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp364_;
						ValaDataType* _tmp365_;
						ValaDataType* _tmp366_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp381_;
						ValaExpression* _tmp382_;
						ValaDataType* _tmp383_;
						ValaDataType* _tmp384_;
						const gchar* _tmp385_;
						ValaDataType* _tmp386_;
						ValaSourceReference* _tmp387_;
						ValaSourceReference* _tmp388_;
						ValaDynamicMethod* _tmp389_;
						ValaDynamicMethod* _tmp390_;
						ValaMethodCall* _tmp391_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp392_;
						ValaErrorType* _tmp393_;
						ValaDynamicMethod* _tmp394_;
						ValaErrorType* _tmp395_;
						ValaDynamicMethod* _tmp396_;
						ValaDynamicMethod* _tmp397_;
						ValaParameter* _tmp398_;
						ValaParameter* _tmp399_;
						ValaDynamicMethod* _tmp400_;
						ValaObjectType* _tmp401_;
						ValaDataType* _tmp402_;
						ValaDataType* _tmp403_;
						ValaParameter* _tmp404_;
						ValaParameter* _tmp405_;
						ValaObjectType* _tmp406_;
						ValaTypeSymbol* _tmp407_;
						ValaTypeSymbol* _tmp408_;
						ValaScope* _tmp409_;
						ValaScope* _tmp410_;
						ValaDynamicMethod* _tmp411_;
						ValaDynamicMethod* _tmp412_;
						_tmp364_ = invoc;
						_tmp365_ = vala_expression_get_target_type ((ValaExpression*) _tmp364_);
						_tmp366_ = _tmp365_;
						if (_tmp366_ != NULL) {
							ValaMethodCall* _tmp367_;
							ValaDataType* _tmp368_;
							ValaDataType* _tmp369_;
							ValaDataType* _tmp370_;
							ValaDataType* _tmp371_;
							_tmp367_ = invoc;
							_tmp368_ = vala_expression_get_target_type ((ValaExpression*) _tmp367_);
							_tmp369_ = _tmp368_;
							_tmp370_ = vala_data_type_copy (_tmp369_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp370_;
							_tmp371_ = ret_type;
							vala_data_type_set_value_owned (_tmp371_, TRUE);
						} else {
							ValaMethodCall* _tmp372_;
							ValaCodeNode* _tmp373_;
							ValaCodeNode* _tmp374_;
							_tmp372_ = invoc;
							_tmp373_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp372_);
							_tmp374_ = _tmp373_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp374_)) {
								ValaVoidType* _tmp375_;
								_tmp375_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp375_;
							} else {
								ValaExpression* _tmp376_;
								ValaExpression* _tmp377_;
								ValaDataType* _tmp378_;
								ValaDataType* _tmp379_;
								ValaDataType* _tmp380_;
								_tmp376_ = vala_member_access_get_inner (self);
								_tmp377_ = _tmp376_;
								_tmp378_ = vala_expression_get_value_type (_tmp377_);
								_tmp379_ = _tmp378_;
								_tmp380_ = vala_data_type_copy (_tmp379_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp380_;
							}
						}
						_tmp381_ = vala_member_access_get_inner (self);
						_tmp382_ = _tmp381_;
						_tmp383_ = vala_expression_get_value_type (_tmp382_);
						_tmp384_ = _tmp383_;
						_tmp385_ = self->priv->_member_name;
						_tmp386_ = ret_type;
						_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp388_ = _tmp387_;
						_tmp389_ = vala_dynamic_method_new (_tmp384_, _tmp385_, _tmp386_, _tmp388_, NULL);
						m = _tmp389_;
						_tmp390_ = m;
						_tmp391_ = invoc;
						vala_dynamic_method_set_invocation (_tmp390_, _tmp391_);
						_tmp392_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp392_;
						_tmp393_ = err;
						vala_error_type_set_dynamic_error (_tmp393_, TRUE);
						_tmp394_ = m;
						_tmp395_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp394_, (ValaDataType*) _tmp395_);
						_tmp396_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp396_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp397_ = m;
						_tmp398_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp399_ = _tmp398_;
						vala_callable_add_parameter ((ValaCallable*) _tmp397_, _tmp399_);
						_vala_code_node_unref0 (_tmp399_);
						_tmp400_ = m;
						_tmp401_ = dynamic_object_type;
						_tmp402_ = vala_data_type_copy ((ValaDataType*) _tmp401_);
						_tmp403_ = _tmp402_;
						_tmp404_ = vala_parameter_new ("this", _tmp403_, NULL);
						_tmp405_ = _tmp404_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp400_, _tmp405_);
						_vala_code_node_unref0 (_tmp405_);
						_vala_code_node_unref0 (_tmp403_);
						_tmp406_ = dynamic_object_type;
						_tmp407_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp406_);
						_tmp408_ = _tmp407_;
						_tmp409_ = vala_symbol_get_scope ((ValaSymbol*) _tmp408_);
						_tmp410_ = _tmp409_;
						_tmp411_ = m;
						vala_scope_add (_tmp410_, NULL, (ValaSymbol*) _tmp411_);
						_tmp412_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp412_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp413_;
					ValaCodeNode* _tmp414_;
					_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp414_ = _tmp413_;
					if (VALA_IS_ASSIGNMENT (_tmp414_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp415_;
						ValaCodeNode* _tmp416_;
						ValaAssignment* _tmp417_;
						ValaExpression* _tmp418_;
						ValaExpression* _tmp419_;
						_tmp415_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp416_ = _tmp415_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp416_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp417_ = a;
						_tmp418_ = vala_assignment_get_left (_tmp417_);
						_tmp419_ = _tmp418_;
						if (_tmp419_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp420_;
							ValaExpression* _tmp421_;
							ValaDataType* _tmp422_;
							ValaDataType* _tmp423_;
							const gchar* _tmp424_;
							ValaSourceReference* _tmp425_;
							ValaSourceReference* _tmp426_;
							ValaDynamicProperty* _tmp427_;
							ValaDynamicProperty* _tmp428_;
							ValaDynamicProperty* _tmp429_;
							ValaDynamicProperty* _tmp430_;
							ValaSourceReference* _tmp431_;
							ValaSourceReference* _tmp432_;
							ValaPropertyAccessor* _tmp433_;
							ValaPropertyAccessor* _tmp434_;
							ValaDynamicProperty* _tmp435_;
							ValaExpression* _tmp436_;
							ValaExpression* _tmp437_;
							ValaDataType* _tmp438_;
							ValaDataType* _tmp439_;
							ValaTypeSymbol* _tmp440_;
							ValaTypeSymbol* _tmp441_;
							ValaScope* _tmp442_;
							ValaScope* _tmp443_;
							ValaObjectType* _tmp444_;
							ValaTypeSymbol* _tmp445_;
							ValaTypeSymbol* _tmp446_;
							ValaScope* _tmp447_;
							ValaScope* _tmp448_;
							ValaDynamicProperty* _tmp449_;
							ValaDynamicProperty* _tmp450_;
							_tmp420_ = vala_member_access_get_inner (self);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_expression_get_value_type (_tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = self->priv->_member_name;
							_tmp425_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp426_ = _tmp425_;
							_tmp427_ = vala_dynamic_property_new (_tmp423_, _tmp424_, _tmp426_, NULL);
							prop = _tmp427_;
							_tmp428_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp428_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp429_ = prop;
							_tmp430_ = prop;
							_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp430_);
							_tmp432_ = _tmp431_;
							_tmp433_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp432_, NULL);
							_tmp434_ = _tmp433_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp429_, _tmp434_);
							_vala_code_node_unref0 (_tmp434_);
							_tmp435_ = prop;
							_tmp436_ = vala_member_access_get_inner (self);
							_tmp437_ = _tmp436_;
							_tmp438_ = vala_expression_get_value_type (_tmp437_);
							_tmp439_ = _tmp438_;
							_tmp440_ = vala_data_type_get_type_symbol (_tmp439_);
							_tmp441_ = _tmp440_;
							_tmp442_ = vala_symbol_get_scope ((ValaSymbol*) _tmp441_);
							_tmp443_ = _tmp442_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp435_, _tmp443_);
							_tmp444_ = dynamic_object_type;
							_tmp445_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp444_);
							_tmp446_ = _tmp445_;
							_tmp447_ = vala_symbol_get_scope ((ValaSymbol*) _tmp446_);
							_tmp448_ = _tmp447_;
							_tmp449_ = prop;
							vala_scope_add (_tmp448_, NULL, (ValaSymbol*) _tmp449_);
							_tmp450_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp450_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp451_ = FALSE;
						gboolean _tmp452_ = FALSE;
						ValaCodeNode* _tmp453_;
						ValaCodeNode* _tmp454_;
						_tmp453_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp454_ = _tmp453_;
						if (VALA_IS_MEMBER_ACCESS (_tmp454_)) {
							ValaExpression* _tmp455_;
							ValaExpression* _tmp456_;
							_tmp455_ = vala_member_access_get_inner (self);
							_tmp456_ = _tmp455_;
							_tmp452_ = VALA_IS_MEMBER_ACCESS (_tmp456_);
						} else {
							_tmp452_ = FALSE;
						}
						if (_tmp452_) {
							ValaCodeNode* _tmp457_;
							ValaCodeNode* _tmp458_;
							ValaCodeNode* _tmp459_;
							ValaCodeNode* _tmp460_;
							_tmp457_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp458_ = _tmp457_;
							_tmp459_ = vala_code_node_get_parent_node (_tmp458_);
							_tmp460_ = _tmp459_;
							_tmp451_ = VALA_IS_METHOD_CALL (_tmp460_);
						} else {
							_tmp451_ = FALSE;
						}
						if (_tmp451_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp461_;
							ValaCodeNode* _tmp462_;
							gboolean _tmp463_ = FALSE;
							ValaMemberAccess* _tmp464_;
							const gchar* _tmp465_;
							_tmp461_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp462_ = _tmp461_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp464_ = ma;
							_tmp465_ = _tmp464_->priv->_member_name;
							if (g_strcmp0 (_tmp465_, "connect") == 0) {
								_tmp463_ = TRUE;
							} else {
								ValaMemberAccess* _tmp466_;
								const gchar* _tmp467_;
								_tmp466_ = ma;
								_tmp467_ = _tmp466_->priv->_member_name;
								_tmp463_ = g_strcmp0 (_tmp467_, "connect_after") == 0;
							}
							if (_tmp463_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp468_;
								ValaExpression* _tmp469_;
								ValaDataType* _tmp470_;
								ValaDataType* _tmp471_;
								const gchar* _tmp472_;
								ValaVoidType* _tmp473_;
								ValaVoidType* _tmp474_;
								ValaSourceReference* _tmp475_;
								ValaSourceReference* _tmp476_;
								ValaDynamicSignal* _tmp477_;
								ValaDynamicSignal* _tmp478_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp479_;
								ValaCodeNode* _tmp480_;
								ValaCodeNode* _tmp481_;
								ValaCodeNode* _tmp482_;
								ValaMethodCall* _tmp483_;
								ValaMethodCall* _tmp484_;
								ValaList* _tmp485_;
								gint _tmp486_;
								gint _tmp487_;
								ValaDynamicSignal* _tmp513_;
								ValaObjectType* _tmp514_;
								ValaTypeSymbol* _tmp515_;
								ValaTypeSymbol* _tmp516_;
								ValaScope* _tmp517_;
								ValaScope* _tmp518_;
								ValaDynamicSignal* _tmp519_;
								ValaDynamicSignal* _tmp520_;
								_tmp468_ = vala_member_access_get_inner (self);
								_tmp469_ = _tmp468_;
								_tmp470_ = vala_expression_get_value_type (_tmp469_);
								_tmp471_ = _tmp470_;
								_tmp472_ = self->priv->_member_name;
								_tmp473_ = vala_void_type_new (NULL);
								_tmp474_ = _tmp473_;
								_tmp475_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp476_ = _tmp475_;
								_tmp477_ = vala_dynamic_signal_new (_tmp471_, _tmp472_, (ValaDataType*) _tmp474_, _tmp476_, NULL);
								_tmp478_ = _tmp477_;
								_vala_code_node_unref0 (_tmp474_);
								s = _tmp478_;
								_tmp479_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp480_ = _tmp479_;
								_tmp481_ = vala_code_node_get_parent_node (_tmp480_);
								_tmp482_ = _tmp481_;
								_tmp483_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp483_;
								_tmp484_ = mcall;
								_tmp485_ = vala_method_call_get_argument_list (_tmp484_);
								_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
								_tmp487_ = _tmp486_;
								if (_tmp487_ > 0) {
									ValaDynamicSignal* _tmp488_;
									ValaMethodCall* _tmp489_;
									ValaList* _tmp490_;
									gpointer _tmp491_;
									ValaExpression* _tmp492_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp493_;
									ValaExpression* _tmp494_;
									ValaExpression* _tmp495_;
									gboolean _tmp496_ = FALSE;
									gboolean _tmp497_ = FALSE;
									ValaMemberAccess* _tmp498_;
									_tmp488_ = s;
									_tmp489_ = mcall;
									_tmp490_ = vala_method_call_get_argument_list (_tmp489_);
									_tmp491_ = vala_list_get (_tmp490_, 0);
									_tmp492_ = (ValaExpression*) _tmp491_;
									vala_dynamic_signal_set_handler (_tmp488_, _tmp492_);
									_vala_code_node_unref0 (_tmp492_);
									_tmp493_ = s;
									_tmp494_ = vala_dynamic_signal_get_handler (_tmp493_);
									_tmp495_ = _tmp494_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp495_) ? ((ValaMemberAccess*) _tmp495_) : NULL;
									_tmp498_ = arg;
									if (_tmp498_ == NULL) {
										_tmp497_ = TRUE;
									} else {
										ValaMemberAccess* _tmp499_;
										_tmp499_ = arg;
										_tmp497_ = !vala_code_node_check ((ValaCodeNode*) _tmp499_, context);
									}
									if (_tmp497_) {
										_tmp496_ = TRUE;
									} else {
										ValaMemberAccess* _tmp500_;
										ValaSymbol* _tmp501_;
										ValaSymbol* _tmp502_;
										_tmp500_ = arg;
										_tmp501_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp500_);
										_tmp502_ = _tmp501_;
										_tmp496_ = !VALA_IS_METHOD (_tmp502_);
									}
									if (_tmp496_) {
										ValaDynamicSignal* _tmp503_;
										ValaExpression* _tmp504_;
										ValaExpression* _tmp505_;
										ValaSourceReference* _tmp506_;
										ValaSourceReference* _tmp507_;
										ValaDynamicSignal* _tmp508_;
										gchar* _tmp509_;
										gchar* _tmp510_;
										gchar* _tmp511_;
										gchar* _tmp512_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp503_ = s;
										_tmp504_ = vala_dynamic_signal_get_handler (_tmp503_);
										_tmp505_ = _tmp504_;
										_tmp506_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp505_);
										_tmp507_ = _tmp506_;
										_tmp508_ = s;
										_tmp509_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp508_);
										_tmp510_ = _tmp509_;
										_tmp511_ = g_strdup_printf ("Invalid handler for `%s'", _tmp510_);
										_tmp512_ = _tmp511_;
										vala_report_error (_tmp507_, _tmp512_);
										_g_free0 (_tmp512_);
										_g_free0 (_tmp510_);
									}
								}
								_tmp513_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp513_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp514_ = dynamic_object_type;
								_tmp515_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp514_);
								_tmp516_ = _tmp515_;
								_tmp517_ = vala_symbol_get_scope ((ValaSymbol*) _tmp516_);
								_tmp518_ = _tmp517_;
								_tmp519_ = s;
								vala_scope_add (_tmp518_, NULL, (ValaSymbol*) _tmp519_);
								_tmp520_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp520_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp521_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp522_ = _tmp521_;
				if (_tmp522_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp523_;
					ValaExpression* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDataType* _tmp526_;
					const gchar* _tmp527_;
					ValaSourceReference* _tmp528_;
					ValaSourceReference* _tmp529_;
					ValaDynamicProperty* _tmp530_;
					ValaDataType* _tmp531_;
					ValaDataType* _tmp532_;
					ValaDynamicProperty* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					ValaDynamicProperty* _tmp545_;
					ValaDataType* _tmp546_;
					ValaDataType* _tmp547_;
					ValaDataType* _tmp548_;
					ValaDataType* _tmp549_;
					ValaDynamicProperty* _tmp550_;
					ValaSourceReference* _tmp551_;
					ValaSourceReference* _tmp552_;
					ValaPropertyAccessor* _tmp553_;
					ValaPropertyAccessor* _tmp554_;
					ValaDynamicProperty* _tmp555_;
					ValaExpression* _tmp556_;
					ValaExpression* _tmp557_;
					ValaDataType* _tmp558_;
					ValaDataType* _tmp559_;
					ValaTypeSymbol* _tmp560_;
					ValaTypeSymbol* _tmp561_;
					ValaScope* _tmp562_;
					ValaScope* _tmp563_;
					ValaObjectType* _tmp564_;
					ValaTypeSymbol* _tmp565_;
					ValaTypeSymbol* _tmp566_;
					ValaScope* _tmp567_;
					ValaScope* _tmp568_;
					ValaDynamicProperty* _tmp569_;
					ValaDynamicProperty* _tmp570_;
					_tmp523_ = vala_member_access_get_inner (self);
					_tmp524_ = _tmp523_;
					_tmp525_ = vala_expression_get_value_type (_tmp524_);
					_tmp526_ = _tmp525_;
					_tmp527_ = self->priv->_member_name;
					_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp529_ = _tmp528_;
					_tmp530_ = vala_dynamic_property_new (_tmp526_, _tmp527_, _tmp529_, NULL);
					prop = _tmp530_;
					_tmp531_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp532_ = _tmp531_;
					if (_tmp532_ != NULL) {
						ValaDynamicProperty* _tmp533_;
						ValaDataType* _tmp534_;
						ValaDataType* _tmp535_;
						_tmp533_ = prop;
						_tmp534_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp535_ = _tmp534_;
						vala_property_set_property_type ((ValaProperty*) _tmp533_, _tmp535_);
					} else {
						ValaDynamicProperty* _tmp536_;
						ValaExpression* _tmp537_;
						ValaExpression* _tmp538_;
						ValaDataType* _tmp539_;
						ValaDataType* _tmp540_;
						ValaDataType* _tmp541_;
						ValaDataType* _tmp542_;
						_tmp536_ = prop;
						_tmp537_ = vala_member_access_get_inner (self);
						_tmp538_ = _tmp537_;
						_tmp539_ = vala_expression_get_value_type (_tmp538_);
						_tmp540_ = _tmp539_;
						_tmp541_ = vala_data_type_copy (_tmp540_);
						_tmp542_ = _tmp541_;
						vala_property_set_property_type ((ValaProperty*) _tmp536_, _tmp542_);
						_vala_code_node_unref0 (_tmp542_);
					}
					_tmp543_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp543_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp544_ = prop;
					_tmp545_ = prop;
					_tmp546_ = vala_property_get_property_type ((ValaProperty*) _tmp545_);
					_tmp547_ = _tmp546_;
					_tmp548_ = vala_data_type_copy (_tmp547_);
					_tmp549_ = _tmp548_;
					_tmp550_ = prop;
					_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp549_, NULL, _tmp552_, NULL);
					_tmp554_ = _tmp553_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp544_, _tmp554_);
					_vala_code_node_unref0 (_tmp554_);
					_vala_code_node_unref0 (_tmp549_);
					_tmp555_ = prop;
					_tmp556_ = vala_member_access_get_inner (self);
					_tmp557_ = _tmp556_;
					_tmp558_ = vala_expression_get_value_type (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_data_type_get_type_symbol (_tmp559_);
					_tmp561_ = _tmp560_;
					_tmp562_ = vala_symbol_get_scope ((ValaSymbol*) _tmp561_);
					_tmp563_ = _tmp562_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp555_, _tmp563_);
					_tmp564_ = dynamic_object_type;
					_tmp565_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp564_);
					_tmp566_ = _tmp565_;
					_tmp567_ = vala_symbol_get_scope ((ValaSymbol*) _tmp566_);
					_tmp568_ = _tmp567_;
					_tmp569_ = prop;
					vala_scope_add (_tmp568_, NULL, (ValaSymbol*) _tmp569_);
					_tmp570_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp570_);
					_vala_code_node_unref0 (prop);
				}
				_tmp571_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp572_ = _tmp571_;
				if (_tmp572_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp574_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp575_ = _tmp574_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp575_)) {
				ValaExpression* _tmp576_;
				ValaExpression* _tmp577_;
				ValaSymbol* _tmp578_;
				ValaSymbol* _tmp579_;
				_tmp576_ = vala_member_access_get_inner (self);
				_tmp577_ = _tmp576_;
				_tmp578_ = vala_expression_get_symbol_reference (_tmp577_);
				_tmp579_ = _tmp578_;
				_tmp573_ = VALA_IS_VARIABLE (_tmp579_);
			} else {
				_tmp573_ = FALSE;
			}
			if (_tmp573_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp580_;
				ValaSemanticAnalyzer* _tmp581_;
				ValaExpression* _tmp582_;
				ValaExpression* _tmp583_;
				ValaSymbol* _tmp584_;
				ValaSymbol* _tmp585_;
				ValaDataType* _tmp586_;
				ValaArrayType* _tmp587_;
				gboolean _tmp588_ = FALSE;
				ValaArrayType* _tmp589_;
				_tmp580_ = vala_code_context_get_analyzer (context);
				_tmp581_ = _tmp580_;
				_tmp582_ = vala_member_access_get_inner (self);
				_tmp583_ = _tmp582_;
				_tmp584_ = vala_expression_get_symbol_reference (_tmp583_);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp581_, _tmp585_, TRUE);
				_tmp587_ = VALA_IS_ARRAY_TYPE (_tmp586_) ? ((ValaArrayType*) _tmp586_) : NULL;
				if (_tmp587_ == NULL) {
					_vala_code_node_unref0 (_tmp586_);
				}
				inner_type = _tmp587_;
				_tmp589_ = inner_type;
				if (_tmp589_ != NULL) {
					ValaArrayType* _tmp590_;
					gboolean _tmp591_;
					gboolean _tmp592_;
					_tmp590_ = inner_type;
					_tmp591_ = vala_array_type_get_inline_allocated (_tmp590_);
					_tmp592_ = _tmp591_;
					_tmp588_ = _tmp592_;
				} else {
					_tmp588_ = FALSE;
				}
				if (_tmp588_) {
					ValaSourceReference* _tmp593_;
					ValaSourceReference* _tmp594_;
					_tmp593_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp594_ = _tmp593_;
					vala_report_error (_tmp594_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp595_ = FALSE;
					ValaArrayType* _tmp596_;
					_tmp596_ = inner_type;
					if (_tmp596_ != NULL) {
						ValaArrayType* _tmp597_;
						gboolean _tmp598_;
						gboolean _tmp599_;
						_tmp597_ = inner_type;
						_tmp598_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp597_);
						_tmp599_ = _tmp598_;
						_tmp595_ = !_tmp599_;
					} else {
						_tmp595_ = FALSE;
					}
					if (_tmp595_) {
						ValaSourceReference* _tmp600_;
						ValaSourceReference* _tmp601_;
						_tmp600_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp601_ = _tmp600_;
						vala_report_error (_tmp601_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp605_ = vala_member_access_get_inner (self);
	_tmp606_ = _tmp605_;
	if (_tmp606_ == NULL) {
		ValaSymbol* _tmp607_;
		ValaSymbol* _tmp608_;
		_tmp607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp608_ = _tmp607_;
		_tmp604_ = _tmp608_ == NULL;
	} else {
		_tmp604_ = FALSE;
	}
	if (_tmp604_) {
		ValaDataType* _tmp609_;
		ValaDataType* _tmp610_;
		_tmp609_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp610_ = _tmp609_;
		_tmp603_ = _tmp610_ != NULL;
	} else {
		_tmp603_ = FALSE;
	}
	if (_tmp603_) {
		ValaDataType* _tmp611_;
		ValaDataType* _tmp612_;
		ValaTypeSymbol* _tmp613_;
		ValaTypeSymbol* _tmp614_;
		_tmp611_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp612_ = _tmp611_;
		_tmp613_ = vala_data_type_get_type_symbol (_tmp612_);
		_tmp614_ = _tmp613_;
		_tmp602_ = VALA_IS_ENUM (_tmp614_);
	} else {
		_tmp602_ = FALSE;
	}
	if (_tmp602_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp615_;
		ValaDataType* _tmp616_;
		ValaTypeSymbol* _tmp617_;
		ValaTypeSymbol* _tmp618_;
		_tmp615_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp616_ = _tmp615_;
		_tmp617_ = vala_data_type_get_type_symbol (_tmp616_);
		_tmp618_ = _tmp617_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp618_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp619_;
			ValaList* _tmp620_;
			ValaList* _tmp621_;
			gint _val_size = 0;
			ValaList* _tmp622_;
			gint _tmp623_;
			gint _tmp624_;
			gint _val_index = 0;
			_tmp619_ = enum_type;
			_tmp620_ = vala_enum_get_values (_tmp619_);
			_tmp621_ = _vala_iterable_ref0 (_tmp620_);
			_val_list = _tmp621_;
			_tmp622_ = _val_list;
			_tmp623_ = vala_collection_get_size ((ValaCollection*) _tmp622_);
			_tmp624_ = _tmp623_;
			_val_size = _tmp624_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp625_;
				gpointer _tmp626_;
				const gchar* _tmp627_;
				ValaEnumValue* _tmp628_;
				const gchar* _tmp629_;
				const gchar* _tmp630_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp625_ = _val_list;
				_tmp626_ = vala_list_get (_tmp625_, _val_index);
				val = (ValaEnumValue*) _tmp626_;
				_tmp627_ = self->priv->_member_name;
				_tmp628_ = val;
				_tmp629_ = vala_symbol_get_name ((ValaSymbol*) _tmp628_);
				_tmp630_ = _tmp629_;
				if (g_strcmp0 (_tmp627_, _tmp630_) == 0) {
					ValaEnumValue* _tmp631_;
					_tmp631_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp631_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp632_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp633_ = _tmp632_;
	if (_tmp633_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp634_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp635_ = FALSE;
		ValaExpression* _tmp636_;
		ValaExpression* _tmp637_;
		gchar* base_type_package = NULL;
		gchar* _tmp657_;
		gboolean _tmp658_ = FALSE;
		ValaSymbol* _tmp659_;
		ValaSourceReference* _tmp674_;
		ValaSourceReference* _tmp675_;
		const gchar* _tmp676_;
		const gchar* _tmp677_;
		const gchar* _tmp678_;
		gchar* _tmp679_;
		gchar* _tmp680_;
		ValaInvalidType* _tmp681_;
		ValaInvalidType* _tmp682_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp634_ = g_strdup ("(null)");
		base_type_name = _tmp634_;
		base_type = NULL;
		_tmp636_ = vala_member_access_get_inner (self);
		_tmp637_ = _tmp636_;
		if (_tmp637_ != NULL) {
			ValaExpression* _tmp638_;
			ValaExpression* _tmp639_;
			ValaDataType* _tmp640_;
			ValaDataType* _tmp641_;
			_tmp638_ = vala_member_access_get_inner (self);
			_tmp639_ = _tmp638_;
			_tmp640_ = vala_expression_get_value_type (_tmp639_);
			_tmp641_ = _tmp640_;
			_tmp635_ = _tmp641_ != NULL;
		} else {
			_tmp635_ = FALSE;
		}
		if (_tmp635_) {
			ValaExpression* _tmp642_;
			ValaExpression* _tmp643_;
			ValaDataType* _tmp644_;
			ValaDataType* _tmp645_;
			gchar* _tmp646_;
			ValaExpression* _tmp647_;
			ValaExpression* _tmp648_;
			ValaDataType* _tmp649_;
			ValaDataType* _tmp650_;
			ValaTypeSymbol* _tmp651_;
			ValaTypeSymbol* _tmp652_;
			_tmp642_ = vala_member_access_get_inner (self);
			_tmp643_ = _tmp642_;
			_tmp644_ = vala_expression_get_value_type (_tmp643_);
			_tmp645_ = _tmp644_;
			_tmp646_ = vala_code_node_to_string ((ValaCodeNode*) _tmp645_);
			_g_free0 (base_type_name);
			base_type_name = _tmp646_;
			_tmp647_ = vala_member_access_get_inner (self);
			_tmp648_ = _tmp647_;
			_tmp649_ = vala_expression_get_value_type (_tmp648_);
			_tmp650_ = _tmp649_;
			_tmp651_ = vala_data_type_get_type_symbol (_tmp650_);
			_tmp652_ = _tmp651_;
			base_type = (ValaSymbol*) _tmp652_;
		} else {
			ValaSymbol* _tmp653_;
			_tmp653_ = base_symbol;
			if (_tmp653_ != NULL) {
				ValaSymbol* _tmp654_;
				gchar* _tmp655_;
				ValaSymbol* _tmp656_;
				_tmp654_ = base_symbol;
				_tmp655_ = vala_symbol_get_full_name (_tmp654_);
				_g_free0 (base_type_name);
				base_type_name = _tmp655_;
				_tmp656_ = base_symbol;
				base_type = _tmp656_;
			}
		}
		_tmp657_ = g_strdup ("");
		base_type_package = _tmp657_;
		_tmp659_ = base_type;
		if (_tmp659_ != NULL) {
			ValaSymbol* _tmp660_;
			gboolean _tmp661_;
			gboolean _tmp662_;
			_tmp660_ = base_type;
			_tmp661_ = vala_symbol_get_external_package (_tmp660_);
			_tmp662_ = _tmp661_;
			_tmp658_ = _tmp662_;
		} else {
			_tmp658_ = FALSE;
		}
		if (_tmp658_) {
			ValaSymbol* _tmp663_;
			ValaSourceReference* _tmp664_;
			ValaSourceReference* _tmp665_;
			ValaSourceFile* _tmp666_;
			ValaSourceFile* _tmp667_;
			const gchar* _tmp668_;
			const gchar* _tmp669_;
			gchar* _tmp670_;
			const gchar* _tmp671_;
			_tmp663_ = base_symbol;
			_tmp664_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp663_);
			_tmp665_ = _tmp664_;
			_tmp666_ = vala_source_reference_get_file (_tmp665_);
			_tmp667_ = _tmp666_;
			_tmp668_ = vala_source_file_get_package_name (_tmp667_);
			_tmp669_ = _tmp668_;
			_tmp670_ = g_strdup (_tmp669_);
			_g_free0 (base_type_package);
			base_type_package = _tmp670_;
			_tmp671_ = base_type_package;
			if (_tmp671_ != NULL) {
				const gchar* _tmp672_;
				gchar* _tmp673_;
				_tmp672_ = base_type_package;
				_tmp673_ = g_strdup_printf (" (%s)", _tmp672_);
				_g_free0 (base_type_package);
				base_type_package = _tmp673_;
			}
		}
		_tmp674_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp675_ = _tmp674_;
		_tmp676_ = self->priv->_member_name;
		_tmp677_ = base_type_name;
		_tmp678_ = base_type_package;
		_tmp679_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp676_, _tmp677_, _tmp678_);
		_tmp680_ = _tmp679_;
		vala_report_error (_tmp675_, _tmp680_);
		_g_free0 (_tmp680_);
		_tmp681_ = vala_invalid_type_new ();
		_tmp682_ = _tmp681_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp682_);
		_vala_code_node_unref0 (_tmp682_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp683_;
		ValaSymbol* _tmp684_;
		gboolean _tmp685_;
		gboolean _tmp686_;
		_tmp683_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp684_ = _tmp683_;
		_tmp685_ = vala_code_node_get_error ((ValaCodeNode*) _tmp684_);
		_tmp686_ = _tmp685_;
		if (_tmp686_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp687_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp688_ = _tmp687_;
	if (VALA_IS_SIGNAL (_tmp688_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp689_;
		ValaSymbol* _tmp690_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp697_;
		ValaCodeNode* _tmp698_;
		ValaCodeNode* _tmp699_;
		gboolean _tmp700_ = FALSE;
		gboolean _tmp701_ = FALSE;
		gboolean _tmp702_ = FALSE;
		ValaCodeNode* _tmp703_;
		_tmp689_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp690_ = _tmp689_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp690_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp691_;
			ValaCodeNode* _tmp692_;
			ValaCodeNode* _tmp693_;
			ValaCodeNode* _tmp694_;
			ValaCodeNode* _tmp695_;
			ValaCodeNode* _tmp696_;
			_tmp691_ = ma;
			_tmp692_ = vala_code_node_get_parent_node (_tmp691_);
			_tmp693_ = _tmp692_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp693_)) {
				break;
			}
			_tmp694_ = ma;
			_tmp695_ = vala_code_node_get_parent_node (_tmp694_);
			_tmp696_ = _tmp695_;
			ma = _tmp696_;
		}
		_tmp697_ = ma;
		_tmp698_ = vala_code_node_get_parent_node (_tmp697_);
		_tmp699_ = _tmp698_;
		parent = _tmp699_;
		_tmp703_ = parent;
		if (_tmp703_ != NULL) {
			ValaCodeNode* _tmp704_;
			_tmp704_ = parent;
			_tmp702_ = !VALA_IS_ELEMENT_ACCESS (_tmp704_);
		} else {
			_tmp702_ = FALSE;
		}
		if (_tmp702_) {
			ValaCodeNode* _tmp705_;
			ValaExpression* _tmp706_;
			ValaExpression* _tmp707_;
			_tmp705_ = ma;
			_tmp706_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp705_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp707_ = _tmp706_;
			_tmp701_ = !VALA_IS_BASE_ACCESS (_tmp707_);
		} else {
			_tmp701_ = FALSE;
		}
		if (_tmp701_) {
			gboolean _tmp708_ = FALSE;
			ValaCodeNode* _tmp709_;
			_tmp709_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp709_)) {
				_tmp708_ = TRUE;
			} else {
				ValaCodeNode* _tmp710_;
				ValaList* _tmp711_;
				_tmp710_ = parent;
				_tmp711_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp710_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp708_ = vala_collection_contains ((ValaCollection*) _tmp711_, (ValaExpression*) self);
			}
			_tmp700_ = _tmp708_;
		} else {
			_tmp700_ = FALSE;
		}
		if (_tmp700_) {
			ValaSignal* _tmp712_;
			ValaAttribute* _tmp713_;
			_tmp712_ = sig;
			_tmp713_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp712_, "HasEmitter");
			if (_tmp713_ != NULL) {
				ValaSignal* _tmp714_;
				ValaSignal* _tmp715_;
				ValaMethod* _tmp716_;
				ValaMethod* _tmp717_;
				_tmp714_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp714_, context)) {
					result = FALSE;
					return result;
				}
				_tmp715_ = sig;
				_tmp716_ = vala_signal_get_emitter (_tmp715_);
				_tmp717_ = _tmp716_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp717_);
			} else {
				ValaSourceReference* _tmp718_;
				ValaSourceReference* _tmp719_;
				ValaSymbol* _tmp720_;
				ValaSymbol* _tmp721_;
				gchar* _tmp722_;
				gchar* _tmp723_;
				gchar* _tmp724_;
				gchar* _tmp725_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp718_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp719_ = _tmp718_;
				_tmp720_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp721_ = _tmp720_;
				_tmp722_ = vala_symbol_get_full_name (_tmp721_);
				_tmp723_ = _tmp722_;
				_tmp724_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp723_);
				_tmp725_ = _tmp724_;
				vala_report_error (_tmp719_, _tmp725_);
				_g_free0 (_tmp725_);
				_g_free0 (_tmp723_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp726_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp727_ = _tmp726_;
	member = _tmp727_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp728_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp728_, context)) {
		result = FALSE;
		return result;
	}
	_tmp729_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp729_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp730_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp731_;
		ValaSymbol* _tmp732_;
		ValaSymbol* _tmp733_;
		gboolean _tmp734_ = FALSE;
		ValaBlock* _tmp735_;
		_tmp730_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp730_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp731_ = local;
		_tmp732_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp731_);
		_tmp733_ = _tmp732_;
		block = VALA_IS_BLOCK (_tmp733_) ? ((ValaBlock*) _tmp733_) : NULL;
		_tmp735_ = block;
		if (_tmp735_ != NULL) {
			ValaBlock* _tmp736_;
			ValaSymbol* _tmp737_;
			ValaSemanticAnalyzer* _tmp738_;
			ValaSemanticAnalyzer* _tmp739_;
			ValaSymbol* _tmp740_;
			ValaSymbol* _tmp741_;
			_tmp736_ = block;
			_tmp737_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp736_);
			_tmp738_ = vala_code_context_get_analyzer (context);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp739_);
			_tmp741_ = _tmp740_;
			_tmp734_ = _tmp737_ != _tmp741_;
		} else {
			_tmp734_ = FALSE;
		}
		if (_tmp734_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp742_;
			ValaSemanticAnalyzer* _tmp743_;
			ValaSymbol* _tmp744_;
			ValaSymbol* _tmp745_;
			ValaLocalVariable* _tmp756_;
			ValaBlock* _tmp757_;
			_tmp742_ = vala_code_context_get_analyzer (context);
			_tmp743_ = _tmp742_;
			_tmp744_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp743_);
			_tmp745_ = _tmp744_;
			sym = _tmp745_;
			while (TRUE) {
				ValaSymbol* _tmp746_;
				ValaBlock* _tmp747_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp748_;
				ValaMethod* _tmp749_;
				ValaSymbol* _tmp753_;
				ValaSymbol* _tmp754_;
				ValaSymbol* _tmp755_;
				_tmp746_ = sym;
				_tmp747_ = block;
				if (!(_tmp746_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp747_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp748_ = sym;
				method = VALA_IS_METHOD (_tmp748_) ? ((ValaMethod*) _tmp748_) : NULL;
				_tmp749_ = method;
				if (_tmp749_ != NULL) {
					ValaMethod* _tmp750_;
					ValaMethod* _tmp751_;
					ValaLocalVariable* _tmp752_;
					_tmp750_ = method;
					vala_method_set_closure (_tmp750_, TRUE);
					_tmp751_ = method;
					_tmp752_ = local;
					vala_method_add_captured_variable (_tmp751_, _tmp752_);
				}
				_tmp753_ = sym;
				_tmp754_ = vala_symbol_get_parent_symbol (_tmp753_);
				_tmp755_ = _tmp754_;
				sym = _tmp755_;
			}
			_tmp756_ = local;
			vala_local_variable_set_captured (_tmp756_, TRUE);
			_tmp757_ = block;
			vala_block_set_captured (_tmp757_, TRUE);
		}
	} else {
		ValaSymbol* _tmp758_;
		_tmp758_ = member;
		if (VALA_IS_PARAMETER (_tmp758_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp759_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp760_;
			ValaSymbol* _tmp761_;
			ValaSymbol* _tmp762_;
			gboolean _tmp763_ = FALSE;
			gboolean _tmp764_ = FALSE;
			ValaMethod* _tmp765_;
			_tmp759_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp759_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp760_ = param;
			_tmp761_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp760_);
			_tmp762_ = _tmp761_;
			m = VALA_IS_METHOD (_tmp762_) ? ((ValaMethod*) _tmp762_) : NULL;
			_tmp765_ = m;
			if (_tmp765_ != NULL) {
				ValaMethod* _tmp766_;
				ValaSemanticAnalyzer* _tmp767_;
				ValaSemanticAnalyzer* _tmp768_;
				ValaSymbol* _tmp769_;
				ValaSymbol* _tmp770_;
				_tmp766_ = m;
				_tmp767_ = vala_code_context_get_analyzer (context);
				_tmp768_ = _tmp767_;
				_tmp769_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp768_);
				_tmp770_ = _tmp769_;
				_tmp764_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp766_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp770_;
			} else {
				_tmp764_ = FALSE;
			}
			if (_tmp764_) {
				ValaParameter* _tmp771_;
				ValaMethod* _tmp772_;
				ValaParameter* _tmp773_;
				ValaParameter* _tmp774_;
				_tmp771_ = param;
				_tmp772_ = m;
				_tmp773_ = vala_method_get_this_parameter (_tmp772_);
				_tmp774_ = _tmp773_;
				_tmp763_ = _tmp771_ != _tmp774_;
			} else {
				_tmp763_ = FALSE;
			}
			if (_tmp763_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp775_;
				ValaSemanticAnalyzer* _tmp776_;
				ValaSymbol* _tmp777_;
				ValaSymbol* _tmp778_;
				ValaParameter* _tmp787_;
				ValaMethod* _tmp788_;
				ValaBlock* _tmp789_;
				ValaBlock* _tmp790_;
				ValaParameter* _tmp791_;
				ValaParameterDirection _tmp792_;
				ValaParameterDirection _tmp793_;
				_tmp775_ = vala_code_context_get_analyzer (context);
				_tmp776_ = _tmp775_;
				_tmp777_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp776_);
				_tmp778_ = _tmp777_;
				sym = _tmp778_;
				while (TRUE) {
					ValaSymbol* _tmp779_;
					ValaMethod* _tmp780_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp781_;
					ValaMethod* _tmp782_;
					ValaSymbol* _tmp784_;
					ValaSymbol* _tmp785_;
					ValaSymbol* _tmp786_;
					_tmp779_ = sym;
					_tmp780_ = m;
					if (!(_tmp779_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp781_ = sym;
					method = VALA_IS_METHOD (_tmp781_) ? ((ValaMethod*) _tmp781_) : NULL;
					_tmp782_ = method;
					if (_tmp782_ != NULL) {
						ValaMethod* _tmp783_;
						_tmp783_ = method;
						vala_method_set_closure (_tmp783_, TRUE);
					}
					_tmp784_ = sym;
					_tmp785_ = vala_symbol_get_parent_symbol (_tmp784_);
					_tmp786_ = _tmp785_;
					sym = _tmp786_;
				}
				_tmp787_ = param;
				vala_parameter_set_captured (_tmp787_, TRUE);
				_tmp788_ = m;
				_tmp789_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp788_);
				_tmp790_ = _tmp789_;
				vala_block_set_captured (_tmp790_, TRUE);
				_tmp791_ = param;
				_tmp792_ = vala_parameter_get_direction (_tmp791_);
				_tmp793_ = _tmp792_;
				if (_tmp793_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp794_;
					ValaSourceReference* _tmp795_;
					ValaParameter* _tmp796_;
					gchar* _tmp797_;
					gchar* _tmp798_;
					gchar* _tmp799_;
					gchar* _tmp800_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp794_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp795_ = _tmp794_;
					_tmp796_ = param;
					_tmp797_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp796_);
					_tmp798_ = _tmp797_;
					_tmp799_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp798_);
					_tmp800_ = _tmp799_;
					vala_report_error (_tmp795_, _tmp800_);
					_g_free0 (_tmp800_);
					_g_free0 (_tmp798_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp801_;
				ValaSymbol* _tmp802_;
				ValaSymbol* _tmp803_;
				ValaSymbol* _tmp804_;
				ValaSymbol* _tmp805_;
				gboolean _tmp806_ = FALSE;
				gboolean _tmp807_ = FALSE;
				ValaPropertyAccessor* _tmp808_;
				_tmp801_ = param;
				_tmp802_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_symbol_get_parent_symbol (_tmp803_);
				_tmp805_ = _tmp804_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp805_) ? ((ValaPropertyAccessor*) _tmp805_) : NULL;
				_tmp808_ = acc;
				if (_tmp808_ != NULL) {
					ValaPropertyAccessor* _tmp809_;
					ValaSemanticAnalyzer* _tmp810_;
					ValaSemanticAnalyzer* _tmp811_;
					ValaSymbol* _tmp812_;
					ValaSymbol* _tmp813_;
					_tmp809_ = acc;
					_tmp810_ = vala_code_context_get_analyzer (context);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp811_);
					_tmp813_ = _tmp812_;
					_tmp807_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp809_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp813_;
				} else {
					_tmp807_ = FALSE;
				}
				if (_tmp807_) {
					ValaParameter* _tmp814_;
					ValaPropertyAccessor* _tmp815_;
					ValaProperty* _tmp816_;
					ValaProperty* _tmp817_;
					ValaParameter* _tmp818_;
					ValaParameter* _tmp819_;
					_tmp814_ = param;
					_tmp815_ = acc;
					_tmp816_ = vala_property_accessor_get_prop (_tmp815_);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_property_get_this_parameter (_tmp817_);
					_tmp819_ = _tmp818_;
					_tmp806_ = _tmp814_ != _tmp819_;
				} else {
					_tmp806_ = FALSE;
				}
				if (_tmp806_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp820_;
					ValaSemanticAnalyzer* _tmp821_;
					ValaSymbol* _tmp822_;
					ValaSymbol* _tmp823_;
					ValaParameter* _tmp832_;
					ValaPropertyAccessor* _tmp833_;
					ValaBlock* _tmp834_;
					ValaBlock* _tmp835_;
					_tmp820_ = vala_code_context_get_analyzer (context);
					_tmp821_ = _tmp820_;
					_tmp822_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp821_);
					_tmp823_ = _tmp822_;
					sym = _tmp823_;
					while (TRUE) {
						ValaSymbol* _tmp824_;
						ValaMethod* _tmp825_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp826_;
						ValaMethod* _tmp827_;
						ValaSymbol* _tmp829_;
						ValaSymbol* _tmp830_;
						ValaSymbol* _tmp831_;
						_tmp824_ = sym;
						_tmp825_ = m;
						if (!(_tmp824_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp825_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp826_ = sym;
						method = VALA_IS_METHOD (_tmp826_) ? ((ValaMethod*) _tmp826_) : NULL;
						_tmp827_ = method;
						if (_tmp827_ != NULL) {
							ValaMethod* _tmp828_;
							_tmp828_ = method;
							vala_method_set_closure (_tmp828_, TRUE);
						}
						_tmp829_ = sym;
						_tmp830_ = vala_symbol_get_parent_symbol (_tmp829_);
						_tmp831_ = _tmp830_;
						sym = _tmp831_;
					}
					_tmp832_ = param;
					vala_parameter_set_captured (_tmp832_, TRUE);
					_tmp833_ = acc;
					_tmp834_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp833_);
					_tmp835_ = _tmp834_;
					vala_block_set_captured (_tmp835_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp836_;
			_tmp836_ = member;
			if (VALA_IS_FIELD (_tmp836_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp837_;
				ValaField* _tmp838_;
				ValaSymbolAccessibility _tmp839_;
				ValaSymbolAccessibility _tmp840_;
				ValaField* _tmp841_;
				ValaMemberBinding _tmp842_;
				ValaMemberBinding _tmp843_;
				ValaField* _tmp844_;
				ValaMemberBinding _tmp845_;
				ValaMemberBinding _tmp846_;
				ValaField* _tmp847_;
				ValaDataType* _tmp848_;
				ValaDataType* _tmp849_;
				_tmp837_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp837_, VALA_TYPE_FIELD, ValaField);
				_tmp838_ = f;
				_tmp839_ = vala_symbol_get_access ((ValaSymbol*) _tmp838_);
				_tmp840_ = _tmp839_;
				access = _tmp840_;
				_tmp841_ = f;
				_tmp842_ = vala_field_get_binding (_tmp841_);
				_tmp843_ = _tmp842_;
				instance = _tmp843_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp844_ = f;
				_tmp845_ = vala_field_get_binding (_tmp844_);
				_tmp846_ = _tmp845_;
				klass = _tmp846_ == VALA_MEMBER_BINDING_CLASS;
				_tmp847_ = f;
				_tmp848_ = vala_variable_get_variable_type ((ValaVariable*) _tmp847_);
				_tmp849_ = _tmp848_;
				if (VALA_IS_GENERIC_TYPE (_tmp849_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp850_;
				_tmp850_ = member;
				if (VALA_IS_CONSTANT (_tmp850_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp851_;
					ValaConstant* _tmp852_;
					ValaSymbolAccessibility _tmp853_;
					ValaSymbolAccessibility _tmp854_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp855_;
					ValaSymbol* _tmp856_;
					ValaSymbol* _tmp857_;
					gboolean _tmp858_ = FALSE;
					ValaBlock* _tmp859_;
					_tmp851_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp851_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp852_ = c;
					_tmp853_ = vala_symbol_get_access ((ValaSymbol*) _tmp852_);
					_tmp854_ = _tmp853_;
					access = _tmp854_;
					_tmp855_ = c;
					_tmp856_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp855_);
					_tmp857_ = _tmp856_;
					block = VALA_IS_BLOCK (_tmp857_) ? ((ValaBlock*) _tmp857_) : NULL;
					_tmp859_ = block;
					if (_tmp859_ != NULL) {
						ValaBlock* _tmp860_;
						ValaSymbol* _tmp861_;
						ValaSemanticAnalyzer* _tmp862_;
						ValaSemanticAnalyzer* _tmp863_;
						ValaSymbol* _tmp864_;
						ValaSymbol* _tmp865_;
						_tmp860_ = block;
						_tmp861_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp860_);
						_tmp862_ = vala_code_context_get_analyzer (context);
						_tmp863_ = _tmp862_;
						_tmp864_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp863_);
						_tmp865_ = _tmp864_;
						_tmp858_ = _tmp861_ != _tmp865_;
					} else {
						_tmp858_ = FALSE;
					}
					if (_tmp858_) {
						ValaSourceReference* _tmp866_;
						ValaSourceReference* _tmp867_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp866_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp867_ = _tmp866_;
						vala_report_error (_tmp867_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp868_;
					_tmp868_ = member;
					if (VALA_IS_METHOD (_tmp868_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp869_;
						ValaMethod* _tmp870_;
						gboolean _tmp871_;
						gboolean _tmp872_;
						ValaMethod* _tmp961_;
						ValaSymbolAccessibility _tmp962_;
						ValaSymbolAccessibility _tmp963_;
						ValaMethod* _tmp964_;
						ValaMethod* _tmp968_;
						ValaMemberBinding _tmp969_;
						ValaMemberBinding _tmp970_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp989_;
						ValaDataType* _tmp990_;
						ValaDataType* _tmp991_;
						gboolean _tmp992_ = FALSE;
						ValaGenericType* _tmp993_;
						_tmp869_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp869_, VALA_TYPE_METHOD, ValaMethod);
						_tmp870_ = m;
						_tmp871_ = vala_method_get_is_async_callback (_tmp870_);
						_tmp872_ = _tmp871_;
						if (_tmp872_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp873_;
							ValaSemanticAnalyzer* _tmp874_;
							ValaMethod* _tmp875_;
							ValaMethod* _tmp876_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp877_;
							ValaMethod* _tmp906_;
							ValaSemanticAnalyzer* _tmp907_;
							ValaSemanticAnalyzer* _tmp908_;
							ValaMethod* _tmp909_;
							ValaMethod* _tmp910_;
							ValaMethod* _tmp926_;
							ValaMethod* _tmp927_;
							ValaMethod* _tmp928_;
							ValaSymbol* _tmp929_;
							ValaSymbol* _tmp930_;
							_tmp873_ = vala_code_context_get_analyzer (context);
							_tmp874_ = _tmp873_;
							_tmp875_ = vala_semantic_analyzer_get_current_async_method (_tmp874_);
							_tmp876_ = _tmp875_;
							async_method = _tmp876_;
							is_valid_access = FALSE;
							_tmp877_ = async_method;
							if (_tmp877_ != NULL) {
								ValaMethod* _tmp878_;
								ValaMethod* _tmp879_;
								ValaMethod* _tmp880_;
								_tmp878_ = m;
								_tmp879_ = async_method;
								_tmp880_ = vala_method_get_callback_method (_tmp879_);
								if (_tmp878_ == _tmp880_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp881_ = FALSE;
									ValaMethod* _tmp882_;
									ValaMethod* _tmp883_;
									ValaMethod* _tmp884_;
									_tmp882_ = async_method;
									_tmp883_ = vala_method_get_base_method (_tmp882_);
									_tmp884_ = _tmp883_;
									if (_tmp884_ != NULL) {
										ValaMethod* _tmp885_;
										ValaMethod* _tmp886_;
										ValaMethod* _tmp887_;
										ValaMethod* _tmp888_;
										ValaMethod* _tmp889_;
										_tmp885_ = m;
										_tmp886_ = async_method;
										_tmp887_ = vala_method_get_base_method (_tmp886_);
										_tmp888_ = _tmp887_;
										_tmp889_ = vala_method_get_callback_method (_tmp888_);
										_tmp881_ = _tmp885_ == _tmp889_;
									} else {
										_tmp881_ = FALSE;
									}
									if (_tmp881_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp890_ = FALSE;
										ValaMethod* _tmp891_;
										ValaMethod* _tmp892_;
										ValaMethod* _tmp893_;
										_tmp891_ = async_method;
										_tmp892_ = vala_method_get_base_interface_method (_tmp891_);
										_tmp893_ = _tmp892_;
										if (_tmp893_ != NULL) {
											ValaMethod* _tmp894_;
											ValaMethod* _tmp895_;
											ValaMethod* _tmp896_;
											ValaMethod* _tmp897_;
											ValaMethod* _tmp898_;
											_tmp894_ = m;
											_tmp895_ = async_method;
											_tmp896_ = vala_method_get_base_interface_method (_tmp895_);
											_tmp897_ = _tmp896_;
											_tmp898_ = vala_method_get_callback_method (_tmp897_);
											_tmp890_ = _tmp894_ == _tmp898_;
										} else {
											_tmp890_ = FALSE;
										}
										if (_tmp890_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp899_;
								ValaSourceReference* _tmp900_;
								ValaMethod* _tmp901_;
								gchar* _tmp902_;
								gchar* _tmp903_;
								gchar* _tmp904_;
								gchar* _tmp905_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp899_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp900_ = _tmp899_;
								_tmp901_ = m;
								_tmp902_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp901_);
								_tmp903_ = _tmp902_;
								_tmp904_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp903_);
								_tmp905_ = _tmp904_;
								vala_report_error (_tmp900_, _tmp905_);
								_g_free0 (_tmp905_);
								_g_free0 (_tmp903_);
								result = FALSE;
								return result;
							}
							_tmp906_ = async_method;
							_tmp907_ = vala_code_context_get_analyzer (context);
							_tmp908_ = _tmp907_;
							_tmp909_ = vala_semantic_analyzer_get_current_method (_tmp908_);
							_tmp910_ = _tmp909_;
							if (_tmp906_ != _tmp910_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp911_;
								ValaSemanticAnalyzer* _tmp912_;
								ValaMethod* _tmp913_;
								ValaMethod* _tmp914_;
								ValaMethod* _tmp923_;
								ValaBlock* _tmp924_;
								ValaBlock* _tmp925_;
								_tmp911_ = vala_code_context_get_analyzer (context);
								_tmp912_ = _tmp911_;
								_tmp913_ = vala_semantic_analyzer_get_current_method (_tmp912_);
								_tmp914_ = _tmp913_;
								sym = (ValaSymbol*) _tmp914_;
								while (TRUE) {
									ValaSymbol* _tmp915_;
									ValaMethod* _tmp916_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp917_;
									ValaMethod* _tmp918_;
									ValaSymbol* _tmp920_;
									ValaSymbol* _tmp921_;
									ValaSymbol* _tmp922_;
									_tmp915_ = sym;
									_tmp916_ = async_method;
									if (!(_tmp915_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp916_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp917_ = sym;
									method = VALA_IS_METHOD (_tmp917_) ? ((ValaMethod*) _tmp917_) : NULL;
									_tmp918_ = method;
									if (_tmp918_ != NULL) {
										ValaMethod* _tmp919_;
										_tmp919_ = method;
										vala_method_set_closure (_tmp919_, TRUE);
									}
									_tmp920_ = sym;
									_tmp921_ = vala_symbol_get_parent_symbol (_tmp920_);
									_tmp922_ = _tmp921_;
									sym = _tmp922_;
								}
								_tmp923_ = async_method;
								_tmp924_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp923_);
								_tmp925_ = _tmp924_;
								vala_block_set_captured (_tmp925_, TRUE);
							}
							_tmp926_ = async_method;
							_tmp927_ = vala_method_get_callback_method (_tmp926_);
							m = _tmp927_;
							_tmp928_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp928_);
							_tmp929_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp930_ = _tmp929_;
							member = _tmp930_;
						} else {
							ValaMethod* _tmp931_;
							ValaMethod* _tmp932_;
							ValaMethod* _tmp933_;
							_tmp931_ = m;
							_tmp932_ = vala_method_get_base_method (_tmp931_);
							_tmp933_ = _tmp932_;
							if (_tmp933_ != NULL) {
								ValaMethod* _tmp934_;
								ValaMethod* _tmp935_;
								ValaMethod* _tmp936_;
								ValaMethod* _tmp937_;
								ValaSignal* _tmp938_;
								ValaSignal* _tmp939_;
								ValaSymbol* _tmp944_;
								ValaSymbol* _tmp945_;
								_tmp934_ = m;
								_tmp935_ = vala_method_get_base_method (_tmp934_);
								_tmp936_ = _tmp935_;
								m = _tmp936_;
								_tmp937_ = m;
								_tmp938_ = vala_method_get_signal_reference (_tmp937_);
								_tmp939_ = _tmp938_;
								if (_tmp939_ != NULL) {
									ValaMethod* _tmp940_;
									ValaSignal* _tmp941_;
									ValaSignal* _tmp942_;
									_tmp940_ = m;
									_tmp941_ = vala_method_get_signal_reference (_tmp940_);
									_tmp942_ = _tmp941_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp942_);
								} else {
									ValaMethod* _tmp943_;
									_tmp943_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp943_);
								}
								_tmp944_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp945_ = _tmp944_;
								member = _tmp945_;
							} else {
								ValaMethod* _tmp946_;
								ValaMethod* _tmp947_;
								ValaMethod* _tmp948_;
								_tmp946_ = m;
								_tmp947_ = vala_method_get_base_interface_method (_tmp946_);
								_tmp948_ = _tmp947_;
								if (_tmp948_ != NULL) {
									ValaMethod* _tmp949_;
									ValaMethod* _tmp950_;
									ValaMethod* _tmp951_;
									ValaMethod* _tmp952_;
									ValaSignal* _tmp953_;
									ValaSignal* _tmp954_;
									ValaSymbol* _tmp959_;
									ValaSymbol* _tmp960_;
									_tmp949_ = m;
									_tmp950_ = vala_method_get_base_interface_method (_tmp949_);
									_tmp951_ = _tmp950_;
									m = _tmp951_;
									_tmp952_ = m;
									_tmp953_ = vala_method_get_signal_reference (_tmp952_);
									_tmp954_ = _tmp953_;
									if (_tmp954_ != NULL) {
										ValaMethod* _tmp955_;
										ValaSignal* _tmp956_;
										ValaSignal* _tmp957_;
										_tmp955_ = m;
										_tmp956_ = vala_method_get_signal_reference (_tmp955_);
										_tmp957_ = _tmp956_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp957_);
									} else {
										ValaMethod* _tmp958_;
										_tmp958_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp958_);
									}
									_tmp959_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp960_ = _tmp959_;
									member = _tmp960_;
								}
							}
						}
						_tmp961_ = m;
						_tmp962_ = vala_symbol_get_access ((ValaSymbol*) _tmp961_);
						_tmp963_ = _tmp962_;
						access = _tmp963_;
						_tmp964_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp964_)) {
							ValaMethod* _tmp965_;
							ValaMemberBinding _tmp966_;
							ValaMemberBinding _tmp967_;
							_tmp965_ = m;
							_tmp966_ = vala_method_get_binding (_tmp965_);
							_tmp967_ = _tmp966_;
							instance = _tmp967_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp968_ = m;
						_tmp969_ = vala_method_get_binding (_tmp968_);
						_tmp970_ = _tmp969_;
						klass = _tmp970_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp971_;
							ValaList* _tmp972_;
							ValaList* _tmp973_;
							gint _param_size = 0;
							ValaList* _tmp974_;
							gint _tmp975_;
							gint _tmp976_;
							gint _param_index = 0;
							_tmp971_ = m;
							_tmp972_ = vala_callable_get_parameters ((ValaCallable*) _tmp971_);
							_tmp973_ = _vala_iterable_ref0 (_tmp972_);
							_param_list = _tmp973_;
							_tmp974_ = _param_list;
							_tmp975_ = vala_collection_get_size ((ValaCollection*) _tmp974_);
							_tmp976_ = _tmp975_;
							_param_size = _tmp976_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp977_;
								gpointer _tmp978_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp979_;
								ValaDataType* _tmp980_;
								ValaDataType* _tmp981_;
								gboolean _tmp982_ = FALSE;
								ValaGenericType* _tmp983_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp977_ = _param_list;
								_tmp978_ = vala_list_get (_tmp977_, _param_index);
								param = (ValaParameter*) _tmp978_;
								_tmp979_ = param;
								_tmp980_ = vala_variable_get_variable_type ((ValaVariable*) _tmp979_);
								_tmp981_ = _tmp980_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp981_) ? ((ValaGenericType*) _tmp981_) : NULL;
								_tmp983_ = generic_type;
								if (_tmp983_ != NULL) {
									ValaGenericType* _tmp984_;
									ValaTypeParameter* _tmp985_;
									ValaTypeParameter* _tmp986_;
									ValaSymbol* _tmp987_;
									ValaSymbol* _tmp988_;
									_tmp984_ = generic_type;
									_tmp985_ = vala_generic_type_get_type_parameter (_tmp984_);
									_tmp986_ = _tmp985_;
									_tmp987_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp986_);
									_tmp988_ = _tmp987_;
									_tmp982_ = VALA_IS_TYPESYMBOL (_tmp988_);
								} else {
									_tmp982_ = FALSE;
								}
								if (_tmp982_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp989_ = m;
						_tmp990_ = vala_callable_get_return_type ((ValaCallable*) _tmp989_);
						_tmp991_ = _tmp990_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp991_) ? ((ValaGenericType*) _tmp991_) : NULL;
						_tmp993_ = generic_type;
						if (_tmp993_ != NULL) {
							ValaGenericType* _tmp994_;
							ValaTypeParameter* _tmp995_;
							ValaTypeParameter* _tmp996_;
							ValaSymbol* _tmp997_;
							ValaSymbol* _tmp998_;
							_tmp994_ = generic_type;
							_tmp995_ = vala_generic_type_get_type_parameter (_tmp994_);
							_tmp996_ = _tmp995_;
							_tmp997_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp996_);
							_tmp998_ = _tmp997_;
							_tmp992_ = VALA_IS_TYPESYMBOL (_tmp998_);
						} else {
							_tmp992_ = FALSE;
						}
						if (_tmp992_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp999_;
						_tmp999_ = member;
						if (VALA_IS_PROPERTY (_tmp999_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1000_;
							ValaProperty* _tmp1001_;
							ValaProperty* _tmp1002_;
							ValaProperty* _tmp1003_;
							ValaProperty* _tmp1004_;
							ValaProperty* _tmp1020_;
							ValaSymbolAccessibility _tmp1021_;
							ValaSymbolAccessibility _tmp1022_;
							gboolean _tmp1023_;
							gboolean _tmp1024_;
							ValaProperty* _tmp1089_;
							ValaMemberBinding _tmp1090_;
							ValaMemberBinding _tmp1091_;
							ValaProperty* _tmp1092_;
							ValaDataType* _tmp1093_;
							ValaDataType* _tmp1094_;
							_tmp1000_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1000_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1001_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1001_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1002_ = prop;
							_tmp1003_ = vala_property_get_base_property (_tmp1002_);
							_tmp1004_ = _tmp1003_;
							if (_tmp1004_ != NULL) {
								ValaProperty* _tmp1005_;
								ValaProperty* _tmp1006_;
								ValaProperty* _tmp1007_;
								ValaProperty* _tmp1008_;
								ValaSymbol* _tmp1009_;
								ValaSymbol* _tmp1010_;
								_tmp1005_ = prop;
								_tmp1006_ = vala_property_get_base_property (_tmp1005_);
								_tmp1007_ = _tmp1006_;
								prop = _tmp1007_;
								_tmp1008_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1008_);
								_tmp1009_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1010_ = _tmp1009_;
								member = _tmp1010_;
							} else {
								ValaProperty* _tmp1011_;
								ValaProperty* _tmp1012_;
								ValaProperty* _tmp1013_;
								_tmp1011_ = prop;
								_tmp1012_ = vala_property_get_base_interface_property (_tmp1011_);
								_tmp1013_ = _tmp1012_;
								if (_tmp1013_ != NULL) {
									ValaProperty* _tmp1014_;
									ValaProperty* _tmp1015_;
									ValaProperty* _tmp1016_;
									ValaProperty* _tmp1017_;
									ValaSymbol* _tmp1018_;
									ValaSymbol* _tmp1019_;
									_tmp1014_ = prop;
									_tmp1015_ = vala_property_get_base_interface_property (_tmp1014_);
									_tmp1016_ = _tmp1015_;
									prop = _tmp1016_;
									_tmp1017_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1017_);
									_tmp1018_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1019_ = _tmp1018_;
									member = _tmp1019_;
								}
							}
							_tmp1020_ = prop;
							_tmp1021_ = vala_symbol_get_access ((ValaSymbol*) _tmp1020_);
							_tmp1022_ = _tmp1021_;
							access = _tmp1022_;
							_tmp1023_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1024_ = _tmp1023_;
							if (_tmp1024_) {
								ValaProperty* _tmp1025_;
								ValaPropertyAccessor* _tmp1026_;
								ValaPropertyAccessor* _tmp1027_;
								ValaProperty* _tmp1035_;
								ValaSymbolAccessibility _tmp1036_;
								ValaSymbolAccessibility _tmp1037_;
								_tmp1025_ = prop;
								_tmp1026_ = vala_property_get_set_accessor (_tmp1025_);
								_tmp1027_ = _tmp1026_;
								if (_tmp1027_ == NULL) {
									ValaSourceReference* _tmp1028_;
									ValaSourceReference* _tmp1029_;
									ValaProperty* _tmp1030_;
									gchar* _tmp1031_;
									gchar* _tmp1032_;
									gchar* _tmp1033_;
									gchar* _tmp1034_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1028_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1029_ = _tmp1028_;
									_tmp1030_ = prop;
									_tmp1031_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1030_);
									_tmp1032_ = _tmp1031_;
									_tmp1033_ = g_strdup_printf ("Property `%s' is read-only", _tmp1032_);
									_tmp1034_ = _tmp1033_;
									vala_report_error (_tmp1029_, _tmp1034_);
									_g_free0 (_tmp1034_);
									_g_free0 (_tmp1032_);
									result = FALSE;
									return result;
								}
								_tmp1035_ = prop;
								_tmp1036_ = vala_symbol_get_access ((ValaSymbol*) _tmp1035_);
								_tmp1037_ = _tmp1036_;
								if (_tmp1037_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1038_;
									ValaPropertyAccessor* _tmp1039_;
									ValaPropertyAccessor* _tmp1040_;
									ValaSymbolAccessibility _tmp1041_;
									ValaSymbolAccessibility _tmp1042_;
									_tmp1038_ = prop;
									_tmp1039_ = vala_property_get_set_accessor (_tmp1038_);
									_tmp1040_ = _tmp1039_;
									_tmp1041_ = vala_symbol_get_access ((ValaSymbol*) _tmp1040_);
									_tmp1042_ = _tmp1041_;
									access = _tmp1042_;
								} else {
									gboolean _tmp1043_ = FALSE;
									ValaProperty* _tmp1044_;
									ValaSymbolAccessibility _tmp1045_;
									ValaSymbolAccessibility _tmp1046_;
									_tmp1044_ = prop;
									_tmp1045_ = vala_symbol_get_access ((ValaSymbol*) _tmp1044_);
									_tmp1046_ = _tmp1045_;
									if (_tmp1046_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1047_;
										ValaPropertyAccessor* _tmp1048_;
										ValaPropertyAccessor* _tmp1049_;
										ValaSymbolAccessibility _tmp1050_;
										ValaSymbolAccessibility _tmp1051_;
										_tmp1047_ = prop;
										_tmp1048_ = vala_property_get_set_accessor (_tmp1047_);
										_tmp1049_ = _tmp1048_;
										_tmp1050_ = vala_symbol_get_access ((ValaSymbol*) _tmp1049_);
										_tmp1051_ = _tmp1050_;
										_tmp1043_ = _tmp1051_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1043_ = FALSE;
									}
									if (_tmp1043_) {
										ValaProperty* _tmp1052_;
										ValaPropertyAccessor* _tmp1053_;
										ValaPropertyAccessor* _tmp1054_;
										ValaSymbolAccessibility _tmp1055_;
										ValaSymbolAccessibility _tmp1056_;
										_tmp1052_ = prop;
										_tmp1053_ = vala_property_get_set_accessor (_tmp1052_);
										_tmp1054_ = _tmp1053_;
										_tmp1055_ = vala_symbol_get_access ((ValaSymbol*) _tmp1054_);
										_tmp1056_ = _tmp1055_;
										access = _tmp1056_;
									}
								}
							} else {
								ValaProperty* _tmp1057_;
								ValaPropertyAccessor* _tmp1058_;
								ValaPropertyAccessor* _tmp1059_;
								ValaProperty* _tmp1067_;
								ValaSymbolAccessibility _tmp1068_;
								ValaSymbolAccessibility _tmp1069_;
								_tmp1057_ = prop;
								_tmp1058_ = vala_property_get_get_accessor (_tmp1057_);
								_tmp1059_ = _tmp1058_;
								if (_tmp1059_ == NULL) {
									ValaSourceReference* _tmp1060_;
									ValaSourceReference* _tmp1061_;
									ValaProperty* _tmp1062_;
									gchar* _tmp1063_;
									gchar* _tmp1064_;
									gchar* _tmp1065_;
									gchar* _tmp1066_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1060_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1061_ = _tmp1060_;
									_tmp1062_ = prop;
									_tmp1063_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1062_);
									_tmp1064_ = _tmp1063_;
									_tmp1065_ = g_strdup_printf ("Property `%s' is write-only", _tmp1064_);
									_tmp1066_ = _tmp1065_;
									vala_report_error (_tmp1061_, _tmp1066_);
									_g_free0 (_tmp1066_);
									_g_free0 (_tmp1064_);
									result = FALSE;
									return result;
								}
								_tmp1067_ = prop;
								_tmp1068_ = vala_symbol_get_access ((ValaSymbol*) _tmp1067_);
								_tmp1069_ = _tmp1068_;
								if (_tmp1069_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1070_;
									ValaPropertyAccessor* _tmp1071_;
									ValaPropertyAccessor* _tmp1072_;
									ValaSymbolAccessibility _tmp1073_;
									ValaSymbolAccessibility _tmp1074_;
									_tmp1070_ = prop;
									_tmp1071_ = vala_property_get_get_accessor (_tmp1070_);
									_tmp1072_ = _tmp1071_;
									_tmp1073_ = vala_symbol_get_access ((ValaSymbol*) _tmp1072_);
									_tmp1074_ = _tmp1073_;
									access = _tmp1074_;
								} else {
									gboolean _tmp1075_ = FALSE;
									ValaProperty* _tmp1076_;
									ValaSymbolAccessibility _tmp1077_;
									ValaSymbolAccessibility _tmp1078_;
									_tmp1076_ = prop;
									_tmp1077_ = vala_symbol_get_access ((ValaSymbol*) _tmp1076_);
									_tmp1078_ = _tmp1077_;
									if (_tmp1078_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1079_;
										ValaPropertyAccessor* _tmp1080_;
										ValaPropertyAccessor* _tmp1081_;
										ValaSymbolAccessibility _tmp1082_;
										ValaSymbolAccessibility _tmp1083_;
										_tmp1079_ = prop;
										_tmp1080_ = vala_property_get_get_accessor (_tmp1079_);
										_tmp1081_ = _tmp1080_;
										_tmp1082_ = vala_symbol_get_access ((ValaSymbol*) _tmp1081_);
										_tmp1083_ = _tmp1082_;
										_tmp1075_ = _tmp1083_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1075_ = FALSE;
									}
									if (_tmp1075_) {
										ValaProperty* _tmp1084_;
										ValaPropertyAccessor* _tmp1085_;
										ValaPropertyAccessor* _tmp1086_;
										ValaSymbolAccessibility _tmp1087_;
										ValaSymbolAccessibility _tmp1088_;
										_tmp1084_ = prop;
										_tmp1085_ = vala_property_get_get_accessor (_tmp1084_);
										_tmp1086_ = _tmp1085_;
										_tmp1087_ = vala_symbol_get_access ((ValaSymbol*) _tmp1086_);
										_tmp1088_ = _tmp1087_;
										access = _tmp1088_;
									}
								}
							}
							_tmp1089_ = prop;
							_tmp1090_ = vala_property_get_binding (_tmp1089_);
							_tmp1091_ = _tmp1090_;
							instance = _tmp1091_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1092_ = prop;
							_tmp1093_ = vala_property_get_property_type (_tmp1092_);
							_tmp1094_ = _tmp1093_;
							if (VALA_IS_GENERIC_TYPE (_tmp1094_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1095_;
							_tmp1095_ = member;
							if (VALA_IS_SIGNAL (_tmp1095_)) {
								ValaSymbol* _tmp1096_;
								ValaSymbolAccessibility _tmp1097_;
								ValaSymbolAccessibility _tmp1098_;
								instance = TRUE;
								_tmp1096_ = member;
								_tmp1097_ = vala_symbol_get_access (_tmp1096_);
								_tmp1098_ = _tmp1097_;
								access = _tmp1098_;
							} else {
								gboolean _tmp1099_ = FALSE;
								gboolean _tmp1100_;
								_tmp1100_ = self->priv->_creation_member;
								if (!_tmp1100_) {
									ValaSymbol* _tmp1101_;
									_tmp1101_ = member;
									_tmp1099_ = VALA_IS_ERROR_CODE (_tmp1101_);
								} else {
									_tmp1099_ = FALSE;
								}
								if (_tmp1099_) {
									ValaSymbol* _tmp1102_;
									ValaConstant* _tmp1103_;
									ValaConstant* _tmp1104_;
									ValaSymbol* _tmp1105_;
									ValaSymbol* _tmp1106_;
									_tmp1102_ = member;
									_tmp1103_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1102_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1104_ = _tmp1103_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1104_);
									_tmp1105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1106_ = _tmp1105_;
									member = _tmp1106_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1107_;
		ValaSymbol* _tmp1108_;
		ValaCodeNode* _tmp1109_;
		ValaCodeNode* _tmp1110_;
		ValaCodeNode* _tmp1111_;
		gboolean _tmp1112_ = FALSE;
		ValaCodeNode* _tmp1113_;
		_tmp1107_ = parent;
		_tmp1108_ = member;
		if (!(_tmp1107_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1108_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1109_ = parent;
		_tmp1110_ = vala_code_node_get_parent_node (_tmp1109_);
		_tmp1111_ = _tmp1110_;
		parent = _tmp1111_;
		_tmp1113_ = parent;
		if (_tmp1113_ == NULL) {
			_tmp1112_ = TRUE;
		} else {
			ValaCodeNode* _tmp1114_;
			ValaSymbol* _tmp1115_;
			_tmp1114_ = parent;
			_tmp1115_ = member;
			_tmp1112_ = _tmp1114_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1115_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1112_) {
			break;
		}
	}
	_tmp1116_ = parent;
	_tmp1117_ = member;
	if (_tmp1116_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1117_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1118_;
		_tmp1118_ = member;
		vala_symbol_set_used (_tmp1118_, TRUE);
	}
	_tmp1119_ = member;
	_tmp1120_ = vala_symbol_get_version (_tmp1119_);
	_tmp1121_ = _tmp1120_;
	_tmp1122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1123_ = _tmp1122_;
	vala_version_attribute_check (_tmp1121_, _tmp1123_);
	_tmp1125_ = access;
	if (_tmp1125_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1126_;
		ValaSymbol* _tmp1127_;
		ValaSymbol* _tmp1128_;
		_tmp1126_ = member;
		_tmp1127_ = vala_symbol_get_parent_symbol (_tmp1126_);
		_tmp1128_ = _tmp1127_;
		_tmp1124_ = VALA_IS_TYPESYMBOL (_tmp1128_);
	} else {
		_tmp1124_ = FALSE;
	}
	if (_tmp1124_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1129_;
		ValaSymbol* _tmp1130_;
		ValaSymbol* _tmp1131_;
		gboolean in_subtype = FALSE;
		_tmp1129_ = member;
		_tmp1130_ = vala_symbol_get_parent_symbol (_tmp1129_);
		_tmp1131_ = _tmp1130_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1131_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1132_;
			ValaSemanticAnalyzer* _tmp1133_;
			ValaSymbol* _tmp1134_;
			ValaSymbol* _tmp1135_;
			ValaSymbol* _tmp1136_;
			_tmp1132_ = vala_code_context_get_analyzer (context);
			_tmp1133_ = _tmp1132_;
			_tmp1134_ = vala_semantic_analyzer_get_current_symbol (_tmp1133_);
			_tmp1135_ = _tmp1134_;
			_tmp1136_ = _vala_code_node_ref0 (_tmp1135_);
			this_symbol = _tmp1136_;
			{
				gboolean _tmp1137_ = FALSE;
				_tmp1137_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1142_;
					ValaSymbol* _tmp1143_;
					ValaTypeSymbol* _tmp1144_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1145_;
					gboolean _tmp1146_ = FALSE;
					ValaClass* _tmp1147_;
					if (!_tmp1137_) {
						ValaSymbol* _tmp1138_;
						ValaSymbol* _tmp1139_;
						ValaSymbol* _tmp1140_;
						ValaSymbol* _tmp1141_;
						_tmp1138_ = this_symbol;
						_tmp1139_ = vala_symbol_get_parent_symbol (_tmp1138_);
						_tmp1140_ = _tmp1139_;
						_tmp1141_ = _vala_code_node_ref0 (_tmp1140_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1141_;
					}
					_tmp1137_ = FALSE;
					_tmp1142_ = this_symbol;
					if (!(_tmp1142_ != NULL)) {
						break;
					}
					_tmp1143_ = this_symbol;
					_tmp1144_ = target_type;
					if (_tmp1143_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1144_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1145_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1145_) ? ((ValaClass*) _tmp1145_) : NULL;
					_tmp1147_ = cl;
					if (_tmp1147_ != NULL) {
						ValaClass* _tmp1148_;
						ValaTypeSymbol* _tmp1149_;
						_tmp1148_ = cl;
						_tmp1149_ = target_type;
						_tmp1146_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1148_, _tmp1149_);
					} else {
						_tmp1146_ = FALSE;
					}
					if (_tmp1146_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1150_;
			ValaSourceReference* _tmp1151_;
			ValaSymbol* _tmp1152_;
			gchar* _tmp1153_;
			gchar* _tmp1154_;
			gchar* _tmp1155_;
			gchar* _tmp1156_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1151_ = _tmp1150_;
			_tmp1152_ = member;
			_tmp1153_ = vala_symbol_get_full_name (_tmp1152_);
			_tmp1154_ = _tmp1153_;
			_tmp1155_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1154_);
			_tmp1156_ = _tmp1155_;
			vala_report_error (_tmp1151_, _tmp1156_);
			_g_free0 (_tmp1156_);
			_g_free0 (_tmp1154_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1157_;
		_tmp1157_ = access;
		if (_tmp1157_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1158_;
			ValaSymbol* _tmp1159_;
			ValaSymbol* _tmp1160_;
			gboolean in_target_type = FALSE;
			_tmp1158_ = member;
			_tmp1159_ = vala_symbol_get_parent_symbol (_tmp1158_);
			_tmp1160_ = _tmp1159_;
			target_type = _tmp1160_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1161_;
				ValaSemanticAnalyzer* _tmp1162_;
				ValaSymbol* _tmp1163_;
				ValaSymbol* _tmp1164_;
				ValaSymbol* _tmp1165_;
				_tmp1161_ = vala_code_context_get_analyzer (context);
				_tmp1162_ = _tmp1161_;
				_tmp1163_ = vala_semantic_analyzer_get_current_symbol (_tmp1162_);
				_tmp1164_ = _tmp1163_;
				_tmp1165_ = _vala_code_node_ref0 (_tmp1164_);
				this_symbol = _tmp1165_;
				{
					gboolean _tmp1166_ = FALSE;
					_tmp1166_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1171_;
						ValaSymbol* _tmp1172_;
						ValaSymbol* _tmp1173_;
						if (!_tmp1166_) {
							ValaSymbol* _tmp1167_;
							ValaSymbol* _tmp1168_;
							ValaSymbol* _tmp1169_;
							ValaSymbol* _tmp1170_;
							_tmp1167_ = this_symbol;
							_tmp1168_ = vala_symbol_get_parent_symbol (_tmp1167_);
							_tmp1169_ = _tmp1168_;
							_tmp1170_ = _vala_code_node_ref0 (_tmp1169_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1170_;
						}
						_tmp1166_ = FALSE;
						_tmp1171_ = this_symbol;
						if (!(_tmp1171_ != NULL)) {
							break;
						}
						_tmp1172_ = target_type;
						_tmp1173_ = this_symbol;
						if (_tmp1172_ == _tmp1173_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1174_;
				ValaSourceReference* _tmp1175_;
				ValaSymbol* _tmp1176_;
				gchar* _tmp1177_;
				gchar* _tmp1178_;
				gchar* _tmp1179_;
				gchar* _tmp1180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1175_ = _tmp1174_;
				_tmp1176_ = member;
				_tmp1177_ = vala_symbol_get_full_name (_tmp1176_);
				_tmp1178_ = _tmp1177_;
				_tmp1179_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1178_);
				_tmp1180_ = _tmp1179_;
				vala_report_error (_tmp1175_, _tmp1180_);
				_g_free0 (_tmp1180_);
				_g_free0 (_tmp1178_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1182_;
		ValaExpression* _tmp1183_;
		_tmp1182_ = vala_member_access_get_inner (self);
		_tmp1183_ = _tmp1182_;
		_tmp1181_ = _tmp1183_ != NULL;
	} else {
		_tmp1181_ = FALSE;
	}
	if (_tmp1181_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1184_;
		ValaExpression* _tmp1185_;
		ValaDataType* _tmp1186_;
		ValaDataType* _tmp1187_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1188_;
		ValaExpression* _tmp1189_;
		ValaDataType* _tmp1190_;
		ValaDataType* _tmp1191_;
		ValaPointerType* _tmp1192_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1196_;
		gboolean _tmp1197_ = FALSE;
		gboolean _tmp1198_ = FALSE;
		ValaObjectType* _tmp1199_;
		_tmp1184_ = vala_member_access_get_inner (self);
		_tmp1185_ = _tmp1184_;
		_tmp1186_ = vala_expression_get_value_type (_tmp1185_);
		_tmp1187_ = _tmp1186_;
		instance_type = _tmp1187_;
		_tmp1188_ = vala_member_access_get_inner (self);
		_tmp1189_ = _tmp1188_;
		_tmp1190_ = vala_expression_get_value_type (_tmp1189_);
		_tmp1191_ = _tmp1190_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1191_) ? ((ValaPointerType*) _tmp1191_) : NULL;
		_tmp1192_ = pointer_type;
		if (_tmp1192_ != NULL) {
			ValaPointerType* _tmp1193_;
			ValaDataType* _tmp1194_;
			ValaDataType* _tmp1195_;
			_tmp1193_ = pointer_type;
			_tmp1194_ = vala_pointer_type_get_base_type (_tmp1193_);
			_tmp1195_ = _tmp1194_;
			instance_type = _tmp1195_;
		}
		_tmp1196_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1196_) ? ((ValaObjectType*) _tmp1196_) : NULL;
		_tmp1199_ = object_type;
		if (_tmp1199_ != NULL) {
			ValaObjectType* _tmp1200_;
			ValaObjectTypeSymbol* _tmp1201_;
			ValaObjectTypeSymbol* _tmp1202_;
			_tmp1200_ = object_type;
			_tmp1201_ = vala_object_type_get_object_type_symbol (_tmp1200_);
			_tmp1202_ = _tmp1201_;
			_tmp1198_ = vala_object_type_symbol_has_type_parameters (_tmp1202_);
		} else {
			_tmp1198_ = FALSE;
		}
		if (_tmp1198_) {
			ValaDataType* _tmp1203_;
			_tmp1203_ = instance_type;
			_tmp1197_ = !vala_data_type_has_type_arguments (_tmp1203_);
		} else {
			_tmp1197_ = FALSE;
		}
		if (_tmp1197_) {
			ValaExpression* _tmp1204_;
			ValaExpression* _tmp1205_;
			ValaSourceReference* _tmp1206_;
			ValaSourceReference* _tmp1207_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1204_ = vala_member_access_get_inner (self);
			_tmp1205_ = _tmp1204_;
			_tmp1206_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1205_);
			_tmp1207_ = _tmp1206_;
			vala_report_error (_tmp1207_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1209_ = !may_access_instance_members;
	} else {
		_tmp1209_ = FALSE;
	}
	if (_tmp1209_) {
		_tmp1208_ = TRUE;
	} else {
		gboolean _tmp1210_ = FALSE;
		if (klass) {
			_tmp1210_ = !may_access_klass_members;
		} else {
			_tmp1210_ = FALSE;
		}
		_tmp1208_ = _tmp1210_;
	}
	if (_tmp1208_) {
		ValaSymbol* _tmp1211_;
		ValaSymbol* _tmp1212_;
		ValaDataType* _tmp1235_;
		ValaDataType* _tmp1236_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1211_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1212_ = _tmp1211_;
		if (VALA_IS_METHOD (_tmp1212_)) {
			ValaSemanticAnalyzer* _tmp1213_;
			ValaSemanticAnalyzer* _tmp1214_;
			ValaSymbol* _tmp1215_;
			ValaSymbol* _tmp1216_;
			gboolean _tmp1217_;
			gboolean _tmp1218_;
			ValaDataType* _tmp1219_;
			ValaDataType* _tmp1220_;
			_tmp1213_ = vala_code_context_get_analyzer (context);
			_tmp1214_ = _tmp1213_;
			_tmp1215_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1216_ = _tmp1215_;
			_tmp1217_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1218_ = _tmp1217_;
			_tmp1219_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1214_, _tmp1216_, _tmp1218_);
			_tmp1220_ = _tmp1219_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1220_);
			_vala_code_node_unref0 (_tmp1220_);
		} else {
			ValaSymbol* _tmp1221_;
			ValaSymbol* _tmp1222_;
			_tmp1221_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1222_ = _tmp1221_;
			if (VALA_IS_FIELD (_tmp1222_)) {
				ValaSymbol* _tmp1223_;
				ValaSymbol* _tmp1224_;
				ValaFieldPrototype* _tmp1225_;
				ValaFieldPrototype* _tmp1226_;
				_tmp1223_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1224_ = _tmp1223_;
				_tmp1225_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1224_, VALA_TYPE_FIELD, ValaField));
				_tmp1226_ = _tmp1225_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1226_);
				_vala_code_node_unref0 (_tmp1226_);
			} else {
				ValaSymbol* _tmp1227_;
				ValaSymbol* _tmp1228_;
				_tmp1227_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1228_ = _tmp1227_;
				if (VALA_IS_PROPERTY (_tmp1228_)) {
					ValaSymbol* _tmp1229_;
					ValaSymbol* _tmp1230_;
					ValaPropertyPrototype* _tmp1231_;
					ValaPropertyPrototype* _tmp1232_;
					_tmp1229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1230_ = _tmp1229_;
					_tmp1231_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1230_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1232_ = _tmp1231_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1232_);
					_vala_code_node_unref0 (_tmp1232_);
				} else {
					ValaInvalidType* _tmp1233_;
					ValaInvalidType* _tmp1234_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1233_ = vala_invalid_type_new ();
					_tmp1234_ = _tmp1233_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1234_);
					_vala_code_node_unref0 (_tmp1234_);
				}
			}
		}
		_tmp1235_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1236_ = _tmp1235_;
		if (_tmp1236_ != NULL) {
			ValaDataType* _tmp1237_;
			ValaDataType* _tmp1238_;
			ValaDataType* _tmp1239_;
			ValaDataType* _tmp1240_;
			gboolean _tmp1241_;
			gboolean _tmp1242_;
			_tmp1237_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1238_ = _tmp1237_;
			_tmp1239_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1240_ = _tmp1239_;
			_tmp1241_ = vala_data_type_get_value_owned (_tmp1240_);
			_tmp1242_ = _tmp1241_;
			vala_data_type_set_value_owned (_tmp1238_, _tmp1242_);
		}
	} else {
		gboolean _tmp1243_ = FALSE;
		gboolean _tmp1264_ = FALSE;
		gboolean _tmp1265_ = FALSE;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1267_ = FALSE;
		gboolean _tmp1309_ = FALSE;
		gboolean _tmp1310_ = FALSE;
		gboolean _tmp1311_ = FALSE;
		gboolean _tmp1312_ = FALSE;
		gboolean _tmp1313_ = FALSE;
		gboolean _tmp1314_;
		gboolean _tmp1315_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1342_;
		ValaSymbol* _tmp1343_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1344_;
		ValaExpression* _tmp1345_;
		gboolean _tmp1346_ = FALSE;
		gboolean _tmp1347_ = FALSE;
		gboolean _tmp1348_ = FALSE;
		gboolean _tmp1349_ = FALSE;
		gboolean _tmp1350_ = FALSE;
		ValaMethod* _tmp1351_;
		ValaSemanticAnalyzer* _tmp1388_;
		ValaSemanticAnalyzer* _tmp1389_;
		ValaSymbol* _tmp1390_;
		ValaSymbol* _tmp1391_;
		gboolean _tmp1392_;
		gboolean _tmp1393_;
		ValaDataType* _tmp1394_;
		ValaDataType* _tmp1395_;
		gboolean _tmp1396_ = FALSE;
		ValaExpression* _tmp1397_;
		ValaExpression* _tmp1398_;
		ValaSymbol* _tmp1411_;
		ValaSymbol* _tmp1412_;
		if (instance) {
			ValaExpression* _tmp1244_;
			ValaExpression* _tmp1245_;
			_tmp1244_ = vala_member_access_get_inner (self);
			_tmp1245_ = _tmp1244_;
			_tmp1243_ = _tmp1245_ == NULL;
		} else {
			_tmp1243_ = FALSE;
		}
		if (_tmp1243_) {
			ValaSourceReference* _tmp1246_;
			ValaSourceReference* _tmp1247_;
			ValaMemberAccess* _tmp1248_;
			ValaMemberAccess* _tmp1249_;
			ValaExpression* _tmp1250_;
			ValaExpression* _tmp1251_;
			ValaParameter* _tmp1252_;
			ValaDataType* _tmp1253_;
			ValaDataType* _tmp1254_;
			ValaDataType* _tmp1255_;
			ValaDataType* _tmp1256_;
			ValaExpression* _tmp1257_;
			ValaExpression* _tmp1258_;
			ValaDataType* _tmp1259_;
			ValaDataType* _tmp1260_;
			ValaExpression* _tmp1261_;
			ValaExpression* _tmp1262_;
			ValaParameter* _tmp1263_;
			_tmp1246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1247_ = _tmp1246_;
			_tmp1248_ = vala_member_access_new (NULL, "this", _tmp1247_);
			_tmp1249_ = _tmp1248_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1249_);
			_vala_code_node_unref0 (_tmp1249_);
			_tmp1250_ = vala_member_access_get_inner (self);
			_tmp1251_ = _tmp1250_;
			_tmp1252_ = this_parameter;
			_tmp1253_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1252_);
			_tmp1254_ = _tmp1253_;
			_tmp1255_ = vala_data_type_copy (_tmp1254_);
			_tmp1256_ = _tmp1255_;
			vala_expression_set_value_type (_tmp1251_, _tmp1256_);
			_vala_code_node_unref0 (_tmp1256_);
			_tmp1257_ = vala_member_access_get_inner (self);
			_tmp1258_ = _tmp1257_;
			_tmp1259_ = vala_expression_get_value_type (_tmp1258_);
			_tmp1260_ = _tmp1259_;
			vala_data_type_set_value_owned (_tmp1260_, FALSE);
			_tmp1261_ = vala_member_access_get_inner (self);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1262_, (ValaSymbol*) _tmp1263_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1267_ = !klass;
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaSymbol* _tmp1268_;
			ValaSymbol* _tmp1269_;
			_tmp1268_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1269_ = _tmp1268_;
			_tmp1266_ = !VALA_IS_CREATION_METHOD (_tmp1269_);
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			_tmp1265_ = may_access_instance_members;
		} else {
			_tmp1265_ = FALSE;
		}
		if (_tmp1265_) {
			ValaExpression* _tmp1270_;
			ValaExpression* _tmp1271_;
			_tmp1270_ = vala_member_access_get_inner (self);
			_tmp1271_ = _tmp1270_;
			_tmp1264_ = _tmp1271_ != NULL;
		} else {
			_tmp1264_ = FALSE;
		}
		if (_tmp1264_) {
			ValaExpression* _tmp1272_;
			ValaExpression* _tmp1273_;
			ValaSymbol* _tmp1274_;
			ValaSymbol* _tmp1275_;
			_tmp1272_ = vala_member_access_get_inner (self);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = vala_expression_get_symbol_reference (_tmp1273_);
			_tmp1275_ = _tmp1274_;
			if (VALA_IS_METHOD (_tmp1275_)) {
			} else {
				ValaSourceReference* _tmp1276_;
				ValaSourceReference* _tmp1277_;
				ValaSymbol* _tmp1278_;
				ValaSymbol* _tmp1279_;
				gchar* _tmp1280_;
				gchar* _tmp1281_;
				gchar* _tmp1282_;
				gchar* _tmp1283_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1284_;
				ValaSymbol* _tmp1285_;
				ValaSymbol* _tmp1286_;
				ValaSymbol* _tmp1287_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1307_;
				ValaExpression* _tmp1308_;
				_tmp1276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1277_ = _tmp1276_;
				_tmp1278_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1279_ = _tmp1278_;
				_tmp1280_ = vala_symbol_get_full_name (_tmp1279_);
				_tmp1281_ = _tmp1280_;
				_tmp1282_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1281_);
				_tmp1283_ = _tmp1282_;
				vala_report_warning (_tmp1277_, _tmp1283_);
				_g_free0 (_tmp1283_);
				_g_free0 (_tmp1281_);
				_tmp1284_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = vala_symbol_get_parent_symbol (_tmp1285_);
				_tmp1287_ = _tmp1286_;
				inner_sym = _tmp1287_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1288_ = FALSE;
					ValaSymbol* _tmp1289_;
					ValaMemberAccess* _tmp1293_;
					ValaSymbol* _tmp1294_;
					const gchar* _tmp1295_;
					const gchar* _tmp1296_;
					ValaSourceReference* _tmp1297_;
					ValaSourceReference* _tmp1298_;
					ValaMemberAccess* _tmp1299_;
					ValaMemberAccess* _tmp1300_;
					ValaMemberAccess* _tmp1301_;
					ValaExpression* _tmp1302_;
					ValaExpression* _tmp1303_;
					ValaSymbol* _tmp1304_;
					ValaSymbol* _tmp1305_;
					ValaSymbol* _tmp1306_;
					_tmp1289_ = inner_sym;
					if (_tmp1289_ != NULL) {
						ValaSymbol* _tmp1290_;
						const gchar* _tmp1291_;
						const gchar* _tmp1292_;
						_tmp1290_ = inner_sym;
						_tmp1291_ = vala_symbol_get_name (_tmp1290_);
						_tmp1292_ = _tmp1291_;
						_tmp1288_ = _tmp1292_ != NULL;
					} else {
						_tmp1288_ = FALSE;
					}
					if (!_tmp1288_) {
						break;
					}
					_tmp1293_ = inner_ma;
					_tmp1294_ = inner_sym;
					_tmp1295_ = vala_symbol_get_name (_tmp1294_);
					_tmp1296_ = _tmp1295_;
					_tmp1297_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1298_ = _tmp1297_;
					_tmp1299_ = vala_member_access_new (NULL, _tmp1296_, _tmp1298_);
					_tmp1300_ = _tmp1299_;
					vala_member_access_set_inner (_tmp1293_, (ValaExpression*) _tmp1300_);
					_vala_code_node_unref0 (_tmp1300_);
					_tmp1301_ = inner_ma;
					_tmp1302_ = vala_member_access_get_inner (_tmp1301_);
					_tmp1303_ = _tmp1302_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1303_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1304_ = inner_sym;
					_tmp1305_ = vala_symbol_get_parent_symbol (_tmp1304_);
					_tmp1306_ = _tmp1305_;
					inner_sym = _tmp1306_;
				}
				_tmp1307_ = vala_member_access_get_inner (self);
				_tmp1308_ = _tmp1307_;
				vala_code_node_check ((ValaCodeNode*) _tmp1308_, context);
			}
		}
		_tmp1314_ = vala_code_context_get_experimental_non_null (context);
		_tmp1315_ = _tmp1314_;
		if (_tmp1315_) {
			_tmp1313_ = instance;
		} else {
			_tmp1313_ = FALSE;
		}
		if (_tmp1313_) {
			ValaExpression* _tmp1316_;
			ValaExpression* _tmp1317_;
			ValaDataType* _tmp1318_;
			ValaDataType* _tmp1319_;
			gboolean _tmp1320_;
			gboolean _tmp1321_;
			_tmp1316_ = vala_member_access_get_inner (self);
			_tmp1317_ = _tmp1316_;
			_tmp1318_ = vala_expression_get_value_type (_tmp1317_);
			_tmp1319_ = _tmp1318_;
			_tmp1320_ = vala_data_type_get_nullable (_tmp1319_);
			_tmp1321_ = _tmp1320_;
			_tmp1312_ = _tmp1321_;
		} else {
			_tmp1312_ = FALSE;
		}
		if (_tmp1312_) {
			ValaExpression* _tmp1322_;
			ValaExpression* _tmp1323_;
			ValaDataType* _tmp1324_;
			ValaDataType* _tmp1325_;
			_tmp1322_ = vala_member_access_get_inner (self);
			_tmp1323_ = _tmp1322_;
			_tmp1324_ = vala_expression_get_value_type (_tmp1323_);
			_tmp1325_ = _tmp1324_;
			_tmp1311_ = !VALA_IS_POINTER_TYPE (_tmp1325_);
		} else {
			_tmp1311_ = FALSE;
		}
		if (_tmp1311_) {
			ValaExpression* _tmp1326_;
			ValaExpression* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			_tmp1326_ = vala_member_access_get_inner (self);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = vala_expression_get_value_type (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			_tmp1310_ = !VALA_IS_GENERIC_TYPE (_tmp1329_);
		} else {
			_tmp1310_ = FALSE;
		}
		if (_tmp1310_) {
			ValaExpression* _tmp1330_;
			ValaExpression* _tmp1331_;
			ValaDataType* _tmp1332_;
			ValaDataType* _tmp1333_;
			_tmp1330_ = vala_member_access_get_inner (self);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = vala_expression_get_value_type (_tmp1331_);
			_tmp1333_ = _tmp1332_;
			_tmp1309_ = !VALA_IS_ARRAY_TYPE (_tmp1333_);
		} else {
			_tmp1309_ = FALSE;
		}
		if (_tmp1309_) {
			ValaSourceReference* _tmp1334_;
			ValaSourceReference* _tmp1335_;
			ValaSymbol* _tmp1336_;
			ValaSymbol* _tmp1337_;
			gchar* _tmp1338_;
			gchar* _tmp1339_;
			gchar* _tmp1340_;
			gchar* _tmp1341_;
			_tmp1334_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1335_ = _tmp1334_;
			_tmp1336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = vala_symbol_get_full_name (_tmp1337_);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1339_);
			_tmp1341_ = _tmp1340_;
			vala_report_error (_tmp1335_, _tmp1341_);
			_g_free0 (_tmp1341_);
			_g_free0 (_tmp1339_);
		}
		_tmp1342_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1343_ = _tmp1342_;
		m = VALA_IS_METHOD (_tmp1343_) ? ((ValaMethod*) _tmp1343_) : NULL;
		_tmp1344_ = vala_member_access_get_inner (self);
		_tmp1345_ = _tmp1344_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1345_) ? ((ValaMemberAccess*) _tmp1345_) : NULL;
		_tmp1351_ = m;
		if (_tmp1351_ != NULL) {
			ValaMethod* _tmp1352_;
			ValaMemberBinding _tmp1353_;
			ValaMemberBinding _tmp1354_;
			_tmp1352_ = m;
			_tmp1353_ = vala_method_get_binding (_tmp1352_);
			_tmp1354_ = _tmp1353_;
			_tmp1350_ = _tmp1354_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1350_ = FALSE;
		}
		if (_tmp1350_) {
			ValaMethod* _tmp1355_;
			ValaSymbol* _tmp1356_;
			ValaSymbol* _tmp1357_;
			_tmp1355_ = m;
			_tmp1356_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1355_);
			_tmp1357_ = _tmp1356_;
			_tmp1349_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1357_);
		} else {
			_tmp1349_ = FALSE;
		}
		if (_tmp1349_) {
			ValaExpression* _tmp1358_;
			ValaExpression* _tmp1359_;
			_tmp1358_ = vala_member_access_get_inner (self);
			_tmp1359_ = _tmp1358_;
			_tmp1348_ = _tmp1359_ != NULL;
		} else {
			_tmp1348_ = FALSE;
		}
		if (_tmp1348_) {
			ValaExpression* _tmp1360_;
			ValaExpression* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			_tmp1360_ = vala_member_access_get_inner (self);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_value_type (_tmp1361_);
			_tmp1363_ = _tmp1362_;
			_tmp1347_ = _tmp1363_ == NULL;
		} else {
			_tmp1347_ = FALSE;
		}
		if (_tmp1347_) {
			ValaMemberAccess* _tmp1364_;
			ValaList* _tmp1365_;
			gint _tmp1366_;
			gint _tmp1367_;
			_tmp1364_ = inner_ma;
			_tmp1365_ = _tmp1364_->priv->type_argument_list;
			_tmp1366_ = vala_collection_get_size ((ValaCollection*) _tmp1365_);
			_tmp1367_ = _tmp1366_;
			_tmp1346_ = _tmp1367_ > 0;
		} else {
			_tmp1346_ = FALSE;
		}
		if (_tmp1346_) {
			ValaExpression* _tmp1368_;
			ValaExpression* _tmp1369_;
			ValaMethod* _tmp1370_;
			ValaSymbol* _tmp1371_;
			ValaSymbol* _tmp1372_;
			ValaObjectType* _tmp1373_;
			ValaObjectType* _tmp1374_;
			_tmp1368_ = vala_member_access_get_inner (self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = m;
			_tmp1371_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1370_);
			_tmp1372_ = _tmp1371_;
			_tmp1373_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1372_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1374_ = _tmp1373_;
			vala_expression_set_value_type (_tmp1369_, (ValaDataType*) _tmp1374_);
			_vala_code_node_unref0 (_tmp1374_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1375_;
				ValaList* _tmp1376_;
				ValaList* _tmp1377_;
				gint _type_argument_size = 0;
				ValaList* _tmp1378_;
				gint _tmp1379_;
				gint _tmp1380_;
				gint _type_argument_index = 0;
				_tmp1375_ = inner_ma;
				_tmp1376_ = _tmp1375_->priv->type_argument_list;
				_tmp1377_ = _vala_iterable_ref0 (_tmp1376_);
				_type_argument_list = _tmp1377_;
				_tmp1378_ = _type_argument_list;
				_tmp1379_ = vala_collection_get_size ((ValaCollection*) _tmp1378_);
				_tmp1380_ = _tmp1379_;
				_type_argument_size = _tmp1380_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1381_;
					gpointer _tmp1382_;
					ValaExpression* _tmp1383_;
					ValaExpression* _tmp1384_;
					ValaDataType* _tmp1385_;
					ValaDataType* _tmp1386_;
					ValaDataType* _tmp1387_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1381_ = _type_argument_list;
					_tmp1382_ = vala_list_get (_tmp1381_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1382_;
					_tmp1383_ = vala_member_access_get_inner (self);
					_tmp1384_ = _tmp1383_;
					_tmp1385_ = vala_expression_get_value_type (_tmp1384_);
					_tmp1386_ = _tmp1385_;
					_tmp1387_ = type_argument;
					vala_data_type_add_type_argument (_tmp1386_, _tmp1387_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1388_ = vala_code_context_get_analyzer (context);
		_tmp1389_ = _tmp1388_;
		_tmp1390_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1391_ = _tmp1390_;
		_tmp1392_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1393_ = _tmp1392_;
		_tmp1394_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1389_, _tmp1391_, _tmp1393_);
		_tmp1395_ = _tmp1394_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1395_);
		_vala_code_node_unref0 (_tmp1395_);
		_tmp1397_ = vala_member_access_get_inner (self);
		_tmp1398_ = _tmp1397_;
		if (_tmp1398_ != NULL) {
			ValaDataType* _tmp1399_;
			ValaDataType* _tmp1400_;
			_tmp1399_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1400_ = _tmp1399_;
			_tmp1396_ = _tmp1400_ != NULL;
		} else {
			_tmp1396_ = FALSE;
		}
		if (_tmp1396_) {
			ValaDataType* _tmp1401_;
			ValaDataType* _tmp1402_;
			ValaExpression* _tmp1403_;
			ValaExpression* _tmp1404_;
			ValaDataType* _tmp1405_;
			ValaDataType* _tmp1406_;
			ValaDataType* _tmp1407_;
			ValaDataType* _tmp1408_;
			_tmp1401_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1402_ = _tmp1401_;
			_tmp1403_ = vala_member_access_get_inner (self);
			_tmp1404_ = _tmp1403_;
			_tmp1405_ = vala_expression_get_value_type (_tmp1404_);
			_tmp1406_ = _tmp1405_;
			_tmp1407_ = vala_data_type_get_actual_type (_tmp1402_, _tmp1406_, NULL, (ValaCodeNode*) self);
			_tmp1408_ = _tmp1407_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1408_);
			_vala_code_node_unref0 (_tmp1408_);
		} else {
			ValaDataType* _tmp1409_;
			ValaDataType* _tmp1410_;
			_tmp1409_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1410_ = _tmp1409_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1410_);
		}
		_tmp1411_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1412_ = _tmp1411_;
		if (VALA_IS_METHOD (_tmp1412_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1413_;
			ValaSymbol* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaDataType* _tmp1416_;
			gboolean _tmp1423_ = FALSE;
			_tmp1413_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1414_ = _tmp1413_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1414_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1415_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1416_ = _tmp1415_;
			if (_tmp1416_ != NULL) {
				ValaDataType* _tmp1417_;
				ValaDataType* _tmp1418_;
				ValaDataType* _tmp1419_;
				ValaDataType* _tmp1420_;
				gboolean _tmp1421_;
				gboolean _tmp1422_;
				_tmp1417_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1418_ = _tmp1417_;
				_tmp1419_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1420_ = _tmp1419_;
				_tmp1421_ = vala_data_type_get_value_owned (_tmp1420_);
				_tmp1422_ = _tmp1421_;
				vala_data_type_set_value_owned (_tmp1418_, _tmp1422_);
			}
			if (instance) {
				ValaMethod* _tmp1424_;
				ValaSymbol* _tmp1425_;
				ValaSymbol* _tmp1426_;
				_tmp1424_ = method;
				_tmp1425_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1424_);
				_tmp1426_ = _tmp1425_;
				_tmp1423_ = VALA_IS_TYPESYMBOL (_tmp1426_);
			} else {
				_tmp1423_ = FALSE;
			}
			if (_tmp1423_) {
				ValaExpression* _tmp1427_;
				ValaExpression* _tmp1428_;
				ValaMethod* _tmp1429_;
				ValaSymbol* _tmp1430_;
				ValaSymbol* _tmp1431_;
				ValaDataType* _tmp1432_;
				ValaDataType* _tmp1433_;
				ValaExpression* _tmp1434_;
				ValaExpression* _tmp1435_;
				ValaDataType* _tmp1436_;
				ValaDataType* _tmp1437_;
				ValaMethod* _tmp1438_;
				ValaParameter* _tmp1439_;
				ValaParameter* _tmp1440_;
				ValaDataType* _tmp1441_;
				ValaDataType* _tmp1442_;
				gboolean _tmp1443_;
				gboolean _tmp1444_;
				_tmp1427_ = vala_member_access_get_inner (self);
				_tmp1428_ = _tmp1427_;
				_tmp1429_ = method;
				_tmp1430_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1429_);
				_tmp1431_ = _tmp1430_;
				_tmp1432_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1431_);
				_tmp1433_ = _tmp1432_;
				vala_expression_set_target_type (_tmp1428_, _tmp1433_);
				_vala_code_node_unref0 (_tmp1433_);
				_tmp1434_ = vala_member_access_get_inner (self);
				_tmp1435_ = _tmp1434_;
				_tmp1436_ = vala_expression_get_target_type (_tmp1435_);
				_tmp1437_ = _tmp1436_;
				_tmp1438_ = method;
				_tmp1439_ = vala_method_get_this_parameter (_tmp1438_);
				_tmp1440_ = _tmp1439_;
				_tmp1441_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1440_);
				_tmp1442_ = _tmp1441_;
				_tmp1443_ = vala_data_type_get_value_owned (_tmp1442_);
				_tmp1444_ = _tmp1443_;
				vala_data_type_set_value_owned (_tmp1437_, _tmp1444_);
			}
		} else {
			gboolean _tmp1445_ = FALSE;
			gboolean _tmp1446_ = FALSE;
			ValaSymbol* _tmp1447_;
			ValaSymbol* _tmp1448_;
			_tmp1447_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1448_ = _tmp1447_;
			if (VALA_IS_PROPERTY (_tmp1448_)) {
				_tmp1446_ = instance;
			} else {
				_tmp1446_ = FALSE;
			}
			if (_tmp1446_) {
				ValaSymbol* _tmp1449_;
				ValaSymbol* _tmp1450_;
				ValaSymbol* _tmp1451_;
				ValaSymbol* _tmp1452_;
				_tmp1449_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1450_ = _tmp1449_;
				_tmp1451_ = vala_symbol_get_parent_symbol (_tmp1450_);
				_tmp1452_ = _tmp1451_;
				_tmp1445_ = _tmp1452_ != NULL;
			} else {
				_tmp1445_ = FALSE;
			}
			if (_tmp1445_) {
				ValaExpression* _tmp1453_;
				ValaExpression* _tmp1454_;
				ValaSymbol* _tmp1455_;
				ValaSymbol* _tmp1456_;
				ValaSymbol* _tmp1457_;
				ValaSymbol* _tmp1458_;
				ValaDataType* _tmp1459_;
				ValaDataType* _tmp1460_;
				_tmp1453_ = vala_member_access_get_inner (self);
				_tmp1454_ = _tmp1453_;
				_tmp1455_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1456_ = _tmp1455_;
				_tmp1457_ = vala_symbol_get_parent_symbol (_tmp1456_);
				_tmp1458_ = _tmp1457_;
				_tmp1459_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1458_);
				_tmp1460_ = _tmp1459_;
				vala_expression_set_target_type (_tmp1454_, _tmp1460_);
				_vala_code_node_unref0 (_tmp1460_);
			} else {
				gboolean _tmp1461_ = FALSE;
				gboolean _tmp1462_ = FALSE;
				gboolean _tmp1463_ = FALSE;
				ValaSymbol* _tmp1464_;
				ValaSymbol* _tmp1465_;
				_tmp1464_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1465_ = _tmp1464_;
				if (VALA_IS_FIELD (_tmp1465_)) {
					_tmp1463_ = TRUE;
				} else {
					ValaSymbol* _tmp1466_;
					ValaSymbol* _tmp1467_;
					_tmp1466_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1467_ = _tmp1466_;
					_tmp1463_ = VALA_IS_SIGNAL (_tmp1467_);
				}
				if (_tmp1463_) {
					_tmp1462_ = instance;
				} else {
					_tmp1462_ = FALSE;
				}
				if (_tmp1462_) {
					ValaSymbol* _tmp1468_;
					ValaSymbol* _tmp1469_;
					ValaSymbol* _tmp1470_;
					ValaSymbol* _tmp1471_;
					_tmp1468_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1469_ = _tmp1468_;
					_tmp1470_ = vala_symbol_get_parent_symbol (_tmp1469_);
					_tmp1471_ = _tmp1470_;
					_tmp1461_ = _tmp1471_ != NULL;
				} else {
					_tmp1461_ = FALSE;
				}
				if (_tmp1461_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1472_;
					ValaSymbol* _tmp1473_;
					ValaSymbol* _tmp1474_;
					ValaSymbol* _tmp1475_;
					ValaDataType* _tmp1476_;
					ValaExpression* _tmp1477_;
					ValaExpression* _tmp1478_;
					ValaDataType* _tmp1479_;
					ValaExpression* _tmp1480_;
					ValaExpression* _tmp1481_;
					ValaDataType* _tmp1482_;
					ValaDataType* _tmp1483_;
					ValaDataType* _tmp1484_;
					ValaDataType* _tmp1485_;
					_tmp1472_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1473_ = _tmp1472_;
					_tmp1474_ = vala_symbol_get_parent_symbol (_tmp1473_);
					_tmp1475_ = _tmp1474_;
					_tmp1476_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1475_);
					parent_type = _tmp1476_;
					_tmp1477_ = vala_member_access_get_inner (self);
					_tmp1478_ = _tmp1477_;
					_tmp1479_ = parent_type;
					_tmp1480_ = vala_member_access_get_inner (self);
					_tmp1481_ = _tmp1480_;
					_tmp1482_ = vala_expression_get_value_type (_tmp1481_);
					_tmp1483_ = _tmp1482_;
					_tmp1484_ = vala_data_type_get_actual_type (_tmp1479_, _tmp1483_, NULL, (ValaCodeNode*) self);
					_tmp1485_ = _tmp1484_;
					vala_expression_set_target_type (_tmp1478_, _tmp1485_);
					_vala_code_node_unref0 (_tmp1485_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1486_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1487_ = _tmp1486_;
	if (_tmp1487_ != NULL) {
		ValaDataType* _tmp1488_;
		ValaDataType* _tmp1489_;
		_tmp1488_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1489_ = _tmp1488_;
		vala_code_node_check ((ValaCodeNode*) _tmp1489_, context);
	}
	_tmp1490_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1491_ = _tmp1490_;
	result = !_tmp1491_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

