/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp290_ = FALSE;
	ValaMethod* _tmp291_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	gboolean _tmp457_ = FALSE;
	ValaMethod* _tmp458_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp486_ = FALSE;
	ValaMethod* _tmp487_;
	gboolean _tmp644_ = FALSE;
	ValaMethod* _tmp645_;
	ValaMethod* _tmp695_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp883_;
	ValaIterator* _tmp884_;
	ValaIterator* _tmp1296_;
	gboolean _tmp1306_ = FALSE;
	gboolean _tmp1307_ = FALSE;
	ValaMethod* _tmp1308_;
	gboolean _tmp1433_ = FALSE;
	ValaDelegate* _tmp1434_;
	gboolean _tmp1534_ = FALSE;
	ValaMethod* _tmp1535_;
	gboolean _tmp1551_;
	gboolean _tmp1552_;
	gboolean _tmp1595_ = FALSE;
	ValaDelegate* _tmp1596_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1614_;
	ValaDataType* _tmp1615_;
	gboolean _tmp1616_ = FALSE;
	ValaDataType* _tmp1617_;
	ValaCCodeFunctionCall* _tmp1645_;
	ValaCCodeFunctionCall* _tmp1646_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1659_;
	ValaCCodeFunctionCall* _tmp1660_;
	ValaCCodeFunctionCall* _tmp1675_;
	gboolean _tmp1690_;
	gboolean _tmp1691_;
	gboolean _tmp1715_;
	gboolean _tmp1716_;
	gboolean _tmp1751_ = FALSE;
	gboolean _tmp1752_ = FALSE;
	ValaMethod* _tmp1753_;
	gboolean _tmp1791_ = FALSE;
	gboolean _tmp1792_ = FALSE;
	gboolean _tmp1793_ = FALSE;
	gboolean _tmp1794_ = FALSE;
	gboolean _tmp1795_ = FALSE;
	ValaMethod* _tmp1796_;
	gboolean _tmp1813_ = FALSE;
	gboolean _tmp1814_ = FALSE;
	ValaMethod* _tmp1815_;
	ValaMethod* _tmp1834_;
	gboolean _tmp1950_ = FALSE;
	ValaCodeNode* _tmp1951_;
	ValaCodeNode* _tmp1952_;
	ValaList* _tmp2052_;
	ValaIterator* _tmp2053_;
	gboolean _tmp2200_ = FALSE;
	gboolean _tmp2201_ = FALSE;
	ValaMethod* _tmp2202_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp240_ = FALSE;
		ValaMemberAccess* _tmp241_;
		const gchar* _tmp242_;
		const gchar* _tmp243_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp241_ = ma;
		_tmp242_ = vala_member_access_get_member_name (_tmp241_);
		_tmp243_ = _tmp242_;
		if (g_strcmp0 (_tmp243_, "begin") == 0) {
			ValaMemberAccess* _tmp244_;
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			_tmp244_ = ma;
			_tmp245_ = vala_member_access_get_inner (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp249_ = ma;
			_tmp250_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp249_);
			_tmp251_ = _tmp250_;
			_tmp240_ = _tmp248_ == _tmp251_;
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			ValaCCodeFunctionCall* _tmp252_;
			ValaCCodeFunctionCall* _tmp253_;
			ValaMethod* _tmp254_;
			ValaList* _tmp255_;
			_tmp252_ = async_call;
			_tmp253_ = _vala_ccode_node_ref0 (_tmp252_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp253_;
			_tmp254_ = m;
			_tmp255_ = vala_method_get_async_begin_parameters (_tmp254_);
			_vala_iterable_unref0 (params);
			params = _tmp255_;
		} else {
			gboolean _tmp256_ = FALSE;
			ValaMemberAccess* _tmp257_;
			const gchar* _tmp258_;
			const gchar* _tmp259_;
			_tmp257_ = ma;
			_tmp258_ = vala_member_access_get_member_name (_tmp257_);
			_tmp259_ = _tmp258_;
			if (g_strcmp0 (_tmp259_, "end") == 0) {
				ValaMemberAccess* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaSymbol* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaMemberAccess* _tmp265_;
				ValaSymbol* _tmp266_;
				ValaSymbol* _tmp267_;
				_tmp260_ = ma;
				_tmp261_ = vala_member_access_get_inner (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = ma;
				_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp265_);
				_tmp267_ = _tmp266_;
				_tmp256_ = _tmp264_ == _tmp267_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaCCodeFunctionCall* _tmp268_;
				ValaCCodeFunctionCall* _tmp269_;
				ValaMethod* _tmp270_;
				ValaList* _tmp271_;
				_tmp268_ = finish_call;
				_tmp269_ = _vala_ccode_node_ref0 (_tmp268_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp269_;
				_tmp270_ = m;
				_tmp271_ = vala_method_get_async_end_parameters (_tmp270_);
				_vala_iterable_unref0 (params);
				params = _tmp271_;
			} else {
				gboolean _tmp272_;
				gboolean _tmp273_;
				_tmp272_ = vala_method_call_get_is_yield_expression (expr);
				_tmp273_ = _tmp272_;
				if (!_tmp273_) {
					ValaCCodeFunctionCall* _tmp274_;
					ValaCCodeFunctionCall* _tmp275_;
					ValaMethod* _tmp276_;
					ValaList* _tmp277_;
					_tmp274_ = async_call;
					_tmp275_ = _vala_ccode_node_ref0 (_tmp274_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp275_;
					_tmp276_ = m;
					_tmp277_ = vala_method_get_async_begin_parameters (_tmp276_);
					_vala_iterable_unref0 (params);
					params = _tmp277_;
				} else {
					ValaCCodeFunctionCall* _tmp278_;
					ValaCCodeFunctionCall* _tmp279_;
					GHashFunc _tmp280_;
					GEqualFunc _tmp281_;
					GEqualFunc _tmp282_;
					ValaHashMap* _tmp283_;
					ValaHashMap* _tmp284_;
					ValaMethod* _tmp285_;
					ValaCCodeIdentifier* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeMemberAccess* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					_tmp278_ = finish_call;
					_tmp279_ = _vala_ccode_node_ref0 (_tmp278_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp279_;
					_tmp280_ = g_direct_hash;
					_tmp281_ = g_direct_equal;
					_tmp282_ = g_direct_equal;
					_tmp283_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp280_, _tmp281_, _tmp282_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp283_;
					_tmp284_ = out_arg_map;
					_tmp285_ = m;
					_tmp286_ = vala_ccode_identifier_new ("_data_");
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp287_, "_res_");
					_tmp289_ = _tmp288_;
					vala_map_set ((ValaMap*) _tmp284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp285_), FALSE)), (ValaCCodeExpression*) _tmp289_);
					_vala_ccode_node_unref0 (_tmp289_);
					_vala_ccode_node_unref0 (_tmp287_);
				}
			}
		}
	}
	_tmp291_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		_tmp292_ = m;
		_tmp293_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp292_);
		_tmp294_ = _tmp293_;
		_tmp290_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, VALA_TYPE_CLASS);
	} else {
		_tmp290_ = FALSE;
	}
	if (_tmp290_) {
		ValaCodeContext* _tmp295_;
		ValaCodeContext* _tmp296_;
		ValaProfile _tmp297_;
		ValaProfile _tmp298_;
		ValaClass* _tmp310_;
		ValaClass* _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		_tmp295_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_context_get_profile (_tmp296_);
		_tmp298_ = _tmp297_;
		if (_tmp298_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp302_;
			gboolean _tmp303_;
			_tmp299_ = m;
			_tmp300_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_CLASS, ValaClass));
			_tmp303_ = _tmp302_;
			if (!_tmp303_) {
				ValaCCodeFunctionCall* _tmp304_;
				ValaCCodeExpression* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				_tmp304_ = ccall;
				_tmp305_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp306_ = _tmp305_;
				vala_ccode_function_call_add_argument (_tmp304_, _tmp306_);
				_vala_ccode_node_unref0 (_tmp306_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp307_;
			ValaCCodeExpression* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			_tmp307_ = ccall;
			_tmp308_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp309_ = _tmp308_;
			vala_ccode_function_call_add_argument (_tmp307_, _tmp309_);
			_vala_ccode_node_unref0 (_tmp309_);
		}
		_tmp310_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp311_ = _tmp310_;
		_tmp312_ = vala_class_get_is_compact (_tmp311_);
		_tmp313_ = _tmp312_;
		if (!_tmp313_) {
			ValaClass* _tmp314_;
			ValaClass* _tmp315_;
			ValaMethod* _tmp316_;
			ValaSymbol* _tmp317_;
			ValaSymbol* _tmp318_;
			_tmp314_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp315_ = _tmp314_;
			_tmp316_ = m;
			_tmp317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp316_);
			_tmp318_ = _tmp317_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp318_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp319_;
					ValaClass* _tmp320_;
					ValaList* _tmp321_;
					ValaList* _tmp322_;
					gint _base_type_size = 0;
					ValaList* _tmp323_;
					gint _tmp324_;
					gint _tmp325_;
					gint _base_type_index = 0;
					_tmp319_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_class_get_base_types (_tmp320_);
					_tmp322_ = _vala_iterable_ref0 (_tmp321_);
					_base_type_list = _tmp322_;
					_tmp323_ = _base_type_list;
					_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
					_tmp325_ = _tmp324_;
					_base_type_size = _tmp325_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp326_;
						gpointer _tmp327_;
						ValaDataType* _tmp328_;
						ValaTypeSymbol* _tmp329_;
						ValaTypeSymbol* _tmp330_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp326_ = _base_type_list;
						_tmp327_ = vala_list_get (_tmp326_, _base_type_index);
						base_type = (ValaDataType*) _tmp327_;
						_tmp328_ = base_type;
						_tmp329_ = vala_data_type_get_type_symbol (_tmp328_);
						_tmp330_ = _tmp329_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp331_;
							gchar* _tmp332_;
							gchar* _tmp333_;
							gboolean _tmp334_;
							ValaHashMap* _tmp340_;
							ValaDataType* _tmp341_;
							ValaList* _tmp342_;
							ValaList* _tmp343_;
							type_parameters = NULL;
							_tmp331_ = m;
							_tmp332_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = g_strcmp0 (_tmp333_, "g_object_new") == 0;
							_g_free0 (_tmp333_);
							if (_tmp334_) {
								ValaDataType* _tmp335_;
								ValaTypeSymbol* _tmp336_;
								ValaTypeSymbol* _tmp337_;
								ValaList* _tmp338_;
								ValaList* _tmp339_;
								_tmp335_ = base_type;
								_tmp336_ = vala_data_type_get_type_symbol (_tmp335_);
								_tmp337_ = _tmp336_;
								_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, VALA_TYPE_CLASS, ValaClass));
								_tmp339_ = _vala_iterable_ref0 (_tmp338_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp339_;
							}
							_tmp340_ = in_arg_map;
							_tmp341_ = base_type;
							_tmp342_ = vala_data_type_get_type_arguments (_tmp341_);
							_tmp343_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp340_, _tmp342_, (ValaCodeNode*) expr, TRUE, _tmp343_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp344_;
				ValaSymbol* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaClass* _tmp347_;
				type_param_index = 0;
				_tmp344_ = m;
				_tmp345_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp344_);
				_tmp346_ = _tmp345_;
				_tmp347_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp346_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp347_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp348_;
					ValaList* _tmp349_;
					ValaList* _tmp350_;
					gint _type_param_size = 0;
					ValaList* _tmp351_;
					gint _tmp352_;
					gint _tmp353_;
					gint _type_param_index = 0;
					_tmp348_ = cl;
					_tmp349_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp348_);
					_tmp350_ = _vala_iterable_ref0 (_tmp349_);
					_type_param_list = _tmp350_;
					_tmp351_ = _type_param_list;
					_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
					_tmp353_ = _tmp352_;
					_type_param_size = _tmp353_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp354_;
						gpointer _tmp355_;
						ValaHashMap* _tmp356_;
						ValaTypeParameter* _tmp357_;
						const gchar* _tmp358_;
						const gchar* _tmp359_;
						gchar* _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						gchar* _tmp363_;
						ValaCCodeIdentifier* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaHashMap* _tmp366_;
						ValaTypeParameter* _tmp367_;
						const gchar* _tmp368_;
						const gchar* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						ValaCCodeIdentifier* _tmp374_;
						ValaCCodeIdentifier* _tmp375_;
						ValaHashMap* _tmp376_;
						ValaTypeParameter* _tmp377_;
						const gchar* _tmp378_;
						const gchar* _tmp379_;
						gchar* _tmp380_;
						gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						ValaCCodeIdentifier* _tmp384_;
						ValaCCodeIdentifier* _tmp385_;
						gint _tmp386_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp354_ = _type_param_list;
						_tmp355_ = vala_list_get (_tmp354_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp355_;
						_tmp356_ = in_arg_map;
						_tmp357_ = type_param;
						_tmp358_ = vala_symbol_get_name ((ValaSymbol*) _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = g_utf8_strdown (_tmp359_, (gssize) -1);
						_tmp361_ = _tmp360_;
						_tmp362_ = g_strdup_printf ("%s_type", _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_ccode_identifier_new (_tmp363_);
						_tmp365_ = _tmp364_;
						vala_map_set ((ValaMap*) _tmp356_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp365_);
						_vala_ccode_node_unref0 (_tmp365_);
						_g_free0 (_tmp363_);
						_g_free0 (_tmp361_);
						_tmp366_ = in_arg_map;
						_tmp367_ = type_param;
						_tmp368_ = vala_symbol_get_name ((ValaSymbol*) _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = g_utf8_strdown (_tmp369_, (gssize) -1);
						_tmp371_ = _tmp370_;
						_tmp372_ = g_strdup_printf ("%s_dup_func", _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_ccode_identifier_new (_tmp373_);
						_tmp375_ = _tmp374_;
						vala_map_set ((ValaMap*) _tmp366_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp375_);
						_vala_ccode_node_unref0 (_tmp375_);
						_g_free0 (_tmp373_);
						_g_free0 (_tmp371_);
						_tmp376_ = in_arg_map;
						_tmp377_ = type_param;
						_tmp378_ = vala_symbol_get_name ((ValaSymbol*) _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = g_utf8_strdown (_tmp379_, (gssize) -1);
						_tmp381_ = _tmp380_;
						_tmp382_ = g_strdup_printf ("%s_destroy_func", _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_ccode_identifier_new (_tmp383_);
						_tmp385_ = _tmp384_;
						vala_map_set ((ValaMap*) _tmp376_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp385_);
						_vala_ccode_node_unref0 (_tmp385_);
						_g_free0 (_tmp383_);
						_g_free0 (_tmp381_);
						_tmp386_ = type_param_index;
						type_param_index = _tmp386_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp387_;
			ValaClass* _tmp388_;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaClass* _tmp391_;
			_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp388_ = _tmp387_;
			_tmp389_ = vala_class_get_base_class (_tmp388_);
			_tmp390_ = _tmp389_;
			_tmp391_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp390_ == _tmp391_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp392_;
				ValaClass* _tmp393_;
				gchar* _tmp394_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp395_;
				ValaCCodeDeclaration* _tmp396_;
				ValaCCodeDeclaration* _tmp397_;
				const gchar* _tmp398_;
				const gchar* _tmp399_;
				const gchar* _tmp400_;
				const gchar* _tmp401_;
				gchar* _tmp402_;
				gchar* _tmp403_;
				ValaCCodeConstant* _tmp404_;
				ValaCCodeConstant* _tmp405_;
				ValaCCodeVariableDeclarator* _tmp406_;
				ValaCCodeVariableDeclarator* _tmp407_;
				ValaCCodeFunction* _tmp408_;
				ValaCCodeFunction* _tmp409_;
				ValaCCodeDeclaration* _tmp410_;
				ValaCCodeFunctionCall* _tmp411_;
				ValaCCodeIdentifier* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeUnaryExpression* _tmp414_;
				ValaCCodeUnaryExpression* _tmp415_;
				ValaCCodeCastExpression* _tmp416_;
				ValaCCodeCastExpression* _tmp417_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeFunctionCall* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				ValaClass* _tmp423_;
				ValaClass* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeIdentifier* _tmp427_;
				ValaCCodeIdentifier* _tmp428_;
				ValaCCodeFunctionCall* _tmp429_;
				ValaCCodeFunctionCall* _tmp430_;
				_tmp392_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp393_ = _tmp392_;
				_tmp394_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp393_, NULL);
				class_prefix = _tmp394_;
				_tmp395_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp395_;
				_tmp396_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp396_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp397_ = funcs;
				_tmp398_ = class_prefix;
				_tmp399_ = class_prefix;
				_tmp400_ = class_prefix;
				_tmp401_ = class_prefix;
				_tmp402_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp398_, _tmp399_, _tmp400_, _tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_ccode_constant_new (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp406_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp405_, NULL);
				_tmp407_ = _tmp406_;
				vala_ccode_declaration_add_declarator (_tmp397_, (ValaCCodeDeclarator*) _tmp407_);
				_vala_ccode_node_unref0 (_tmp407_);
				_vala_ccode_node_unref0 (_tmp405_);
				_g_free0 (_tmp403_);
				_tmp408_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp409_ = _tmp408_;
				_tmp410_ = funcs;
				vala_ccode_function_add_statement (_tmp409_, (ValaCCodeNode*) _tmp410_);
				_tmp411_ = ccall;
				_tmp412_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp415_, "GSourceFuncs *");
				_tmp417_ = _tmp416_;
				vala_ccode_function_call_add_argument (_tmp411_, (ValaCCodeExpression*) _tmp417_);
				_vala_ccode_node_unref0 (_tmp417_);
				_vala_ccode_node_unref0 (_tmp415_);
				_vala_ccode_node_unref0 (_tmp413_);
				_tmp418_ = vala_ccode_identifier_new ("sizeof");
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp419_);
				_tmp421_ = _tmp420_;
				_vala_ccode_node_unref0 (_tmp419_);
				csizeof = _tmp421_;
				_tmp422_ = csizeof;
				_tmp423_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp424_ = _tmp423_;
				_tmp425_ = vala_get_ccode_name ((ValaCodeNode*) _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_identifier_new (_tmp426_);
				_tmp428_ = _tmp427_;
				vala_ccode_function_call_add_argument (_tmp422_, (ValaCCodeExpression*) _tmp428_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp429_ = ccall;
				_tmp430_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp429_, (ValaCCodeExpression*) _tmp430_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp431_ = FALSE;
		ValaMethod* _tmp432_;
		_tmp432_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp432_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp433_;
			ValaSymbol* _tmp434_;
			ValaSymbol* _tmp435_;
			_tmp433_ = m;
			_tmp434_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp433_);
			_tmp435_ = _tmp434_;
			_tmp431_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp435_, VALA_TYPE_STRUCT);
		} else {
			_tmp431_ = FALSE;
		}
		if (_tmp431_) {
			ValaCCodeFunctionCall* _tmp436_;
			ValaCCodeExpression* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			_tmp436_ = ccall;
			_tmp437_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp438_ = _tmp437_;
			vala_ccode_function_call_add_argument (_tmp436_, _tmp438_);
			_vala_ccode_node_unref0 (_tmp438_);
		} else {
			gboolean _tmp439_ = FALSE;
			gboolean _tmp440_ = FALSE;
			gboolean _tmp441_ = FALSE;
			gboolean _tmp442_ = FALSE;
			ValaMethod* _tmp443_;
			_tmp443_ = m;
			if (_tmp443_ != NULL) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp442_ = vala_method_has_type_parameters (_tmp444_);
			} else {
				_tmp442_ = FALSE;
			}
			if (_tmp442_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp441_ = !vala_get_ccode_has_generic_type_parameter (_tmp445_);
			} else {
				_tmp441_ = FALSE;
			}
			if (_tmp441_) {
				ValaMethod* _tmp446_;
				_tmp446_ = m;
				_tmp440_ = !vala_get_ccode_simple_generics (_tmp446_);
			} else {
				_tmp440_ = FALSE;
			}
			if (_tmp440_) {
				gboolean _tmp447_ = FALSE;
				ValaCCodeFunctionCall* _tmp448_;
				ValaCCodeFunctionCall* _tmp449_;
				_tmp448_ = ccall;
				_tmp449_ = finish_call;
				if (_tmp448_ != _tmp449_) {
					_tmp447_ = TRUE;
				} else {
					gboolean _tmp450_;
					gboolean _tmp451_;
					_tmp450_ = vala_method_call_get_is_yield_expression (expr);
					_tmp451_ = _tmp450_;
					_tmp447_ = _tmp451_;
				}
				_tmp439_ = _tmp447_;
			} else {
				_tmp439_ = FALSE;
			}
			if (_tmp439_) {
				ValaHashMap* _tmp452_;
				ValaMemberAccess* _tmp453_;
				ValaList* _tmp454_;
				_tmp452_ = in_arg_map;
				_tmp453_ = ma;
				_tmp454_ = vala_member_access_get_type_arguments (_tmp453_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp452_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp458_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp459_;
		ValaCodeContext* _tmp460_;
		ValaProfile _tmp461_;
		ValaProfile _tmp462_;
		_tmp459_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_code_context_get_profile (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp457_ = _tmp462_ != VALA_PROFILE_POSIX;
	} else {
		_tmp457_ = FALSE;
	}
	if (_tmp457_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp463_;
		ValaExpression* _tmp464_;
		ValaExpression* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		ValaArrayType* _tmp468_;
		ValaHashMap* _tmp469_;
		ValaArrayType* _tmp470_;
		ValaDataType* _tmp471_;
		ValaDataType* _tmp472_;
		gchar* _tmp473_;
		gchar* _tmp474_;
		ValaCCodeIdentifier* _tmp475_;
		ValaCCodeIdentifier* _tmp476_;
		_tmp463_ = ma;
		_tmp464_ = vala_member_access_get_inner (_tmp463_);
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_expression_get_value_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp468_;
		_tmp469_ = in_arg_map;
		_tmp470_ = array_type;
		_tmp471_ = vala_array_type_get_element_type (_tmp470_);
		_tmp472_ = _tmp471_;
		_tmp473_ = vala_get_ccode_name ((ValaCodeNode*) _tmp472_);
		_tmp474_ = _tmp473_;
		_tmp475_ = vala_ccode_identifier_new (_tmp474_);
		_tmp476_ = _tmp475_;
		vala_map_set ((ValaMap*) _tmp469_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp476_);
		_vala_ccode_node_unref0 (_tmp476_);
		_g_free0 (_tmp474_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp477_;
		_tmp477_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp477_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp478_;
			_tmp478_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp479_;
				ValaExpression* _tmp480_;
				ValaExpression* _tmp481_;
				ValaTargetValue* _tmp482_;
				ValaTargetValue* _tmp483_;
				ValaTargetValue* _tmp484_;
				ValaTargetValue* _tmp485_;
				_tmp479_ = ma;
				_tmp480_ = vala_member_access_get_inner (_tmp479_);
				_tmp481_ = _tmp480_;
				_tmp482_ = vala_expression_get_target_value (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp483_, (ValaCodeNode*) expr);
				_tmp485_ = _tmp484_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp485_);
				_vala_target_value_unref0 (_tmp485_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp487_ = m;
	if (_tmp487_ != NULL) {
		ValaMethod* _tmp488_;
		gboolean _tmp489_;
		gboolean _tmp490_;
		_tmp488_ = m;
		_tmp489_ = vala_method_get_is_async_callback (_tmp488_);
		_tmp490_ = _tmp489_;
		_tmp486_ = _tmp490_;
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaMethod* _tmp491_;
		ValaMethod* _tmp492_;
		gboolean _tmp493_;
		gboolean _tmp494_;
		ValaHashMap* _tmp508_;
		ValaMethod* _tmp509_;
		ValaCCodeExpression* _tmp510_;
		ValaHashMap* _tmp511_;
		ValaMethod* _tmp512_;
		ValaCCodeExpression* _tmp513_;
		_tmp491_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_method_get_closure (_tmp492_);
		_tmp494_ = _tmp493_;
		if (_tmp494_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaSymbol* _tmp497_;
			ValaBlock* _tmp498_;
			ValaBlock* _tmp499_;
			ValaBlock* _tmp500_;
			ValaBlock* _tmp501_;
			gchar* _tmp502_;
			gchar* _tmp503_;
			ValaCCodeExpression* _tmp504_;
			ValaCCodeExpression* _tmp505_;
			ValaCCodeMemberAccess* _tmp506_;
			_tmp495_ = m;
			_tmp496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp497_, VALA_TYPE_METHOD, ValaMethod));
			_tmp499_ = _tmp498_;
			_tmp500_ = _vala_code_node_ref0 (_tmp499_);
			block = _tmp500_;
			_tmp501_ = block;
			_tmp502_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp501_));
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp503_);
			_tmp505_ = _tmp504_;
			_tmp506_ = vala_ccode_member_access_new_pointer (_tmp505_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp506_;
			_vala_ccode_node_unref0 (_tmp505_);
			_g_free0 (_tmp503_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp507_;
			_tmp507_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp507_;
		}
		_tmp508_ = in_arg_map;
		_tmp509_ = m;
		_tmp510_ = instance;
		vala_map_set ((ValaMap*) _tmp508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp509_), FALSE)), _tmp510_);
		_tmp511_ = out_arg_map;
		_tmp512_ = m;
		_tmp513_ = instance;
		vala_map_set ((ValaMap*) _tmp511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp512_), FALSE)), _tmp513_);
	} else {
		gboolean _tmp514_ = FALSE;
		gboolean _tmp515_ = FALSE;
		ValaMethod* _tmp516_;
		_tmp516_ = m;
		if (_tmp516_ != NULL) {
			ValaMethod* _tmp517_;
			ValaMemberBinding _tmp518_;
			ValaMemberBinding _tmp519_;
			_tmp517_ = m;
			_tmp518_ = vala_method_get_binding (_tmp517_);
			_tmp519_ = _tmp518_;
			_tmp515_ = _tmp519_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaMethod* _tmp520_;
			_tmp520_ = m;
			_tmp514_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp514_ = FALSE;
		}
		if (_tmp514_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp521_;
			ValaExpression* _tmp522_;
			ValaExpression* _tmp523_;
			ValaTargetValue* _tmp524_;
			ValaTargetValue* _tmp525_;
			ValaTargetValue* _tmp526_;
			gboolean _tmp527_ = FALSE;
			gboolean _tmp528_ = FALSE;
			ValaMemberAccess* _tmp529_;
			const gchar* _tmp530_;
			const gchar* _tmp531_;
			ValaTargetValue* _tmp553_;
			ValaCCodeExpression* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp556_;
			ValaSymbol* _tmp557_;
			ValaSymbol* _tmp558_;
			ValaStruct* _tmp559_;
			gboolean _tmp560_ = FALSE;
			ValaStruct* _tmp561_;
			ValaMethod* _tmp569_;
			gboolean _tmp570_;
			gboolean _tmp571_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_inner (_tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_expression_get_target_value (_tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = _vala_target_value_ref0 (_tmp525_);
			instance_value = _tmp526_;
			_tmp529_ = ma;
			_tmp530_ = vala_member_access_get_member_name (_tmp529_);
			_tmp531_ = _tmp530_;
			if (g_strcmp0 (_tmp531_, "begin") == 0) {
				_tmp528_ = TRUE;
			} else {
				ValaMemberAccess* _tmp532_;
				const gchar* _tmp533_;
				const gchar* _tmp534_;
				_tmp532_ = ma;
				_tmp533_ = vala_member_access_get_member_name (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp528_ = g_strcmp0 (_tmp534_, "end") == 0;
			}
			if (_tmp528_) {
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaSymbol* _tmp538_;
				ValaSymbol* _tmp539_;
				ValaMemberAccess* _tmp540_;
				ValaSymbol* _tmp541_;
				ValaSymbol* _tmp542_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_expression_get_symbol_reference (_tmp537_);
				_tmp539_ = _tmp538_;
				_tmp540_ = ma;
				_tmp541_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp540_);
				_tmp542_ = _tmp541_;
				_tmp527_ = _tmp539_ == _tmp542_;
			} else {
				_tmp527_ = FALSE;
			}
			if (_tmp527_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp543_;
				ValaExpression* _tmp544_;
				ValaExpression* _tmp545_;
				ValaMemberAccess* _tmp546_;
				ValaMemberAccess* _tmp547_;
				ValaExpression* _tmp548_;
				ValaExpression* _tmp549_;
				ValaTargetValue* _tmp550_;
				ValaTargetValue* _tmp551_;
				ValaTargetValue* _tmp552_;
				_tmp543_ = ma;
				_tmp544_ = vala_member_access_get_inner (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp545_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp546_;
				_tmp547_ = inner_ma;
				_tmp548_ = vala_member_access_get_inner (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = vala_expression_get_target_value (_tmp549_);
				_tmp551_ = _tmp550_;
				_tmp552_ = _vala_target_value_ref0 (_tmp551_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp552_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp553_ = instance_value;
			_tmp554_ = vala_get_cvalue_ (_tmp553_);
			_tmp555_ = _vala_ccode_node_ref0 (_tmp554_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp555_;
			_tmp556_ = m;
			_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp558_) : NULL);
			st = _tmp559_;
			_tmp561_ = st;
			if (_tmp561_ != NULL) {
				ValaStruct* _tmp562_;
				_tmp562_ = st;
				_tmp560_ = !vala_struct_is_simple_type (_tmp562_);
			} else {
				_tmp560_ = FALSE;
			}
			if (_tmp560_) {
				ValaTargetValue* _tmp563_;
				ValaTargetValue* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaCCodeUnaryExpression* _tmp568_;
				_tmp563_ = instance_value;
				if (!vala_get_lvalue (_tmp563_)) {
					ValaTargetValue* _tmp564_;
					ValaTargetValue* _tmp565_;
					_tmp564_ = instance_value;
					_tmp565_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp564_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp565_;
				}
				_tmp566_ = instance_value;
				_tmp567_ = vala_get_cvalue_ (_tmp566_);
				_tmp568_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp567_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp568_;
			}
			_tmp569_ = m;
			_tmp570_ = vala_method_get_coroutine (_tmp569_);
			_tmp571_ = _tmp570_;
			if (!_tmp571_) {
				ValaHashMap* _tmp572_;
				ValaMethod* _tmp573_;
				ValaCCodeExpression* _tmp574_;
				_tmp572_ = in_arg_map;
				_tmp573_ = m;
				_tmp574_ = instance;
				vala_map_set ((ValaMap*) _tmp572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp573_), FALSE)), _tmp574_);
			} else {
				gboolean _tmp575_;
				gboolean _tmp576_;
				_tmp575_ = vala_method_call_get_is_yield_expression (expr);
				_tmp576_ = _tmp575_;
				if (_tmp576_) {
					ValaHashMap* _tmp577_;
					ValaMethod* _tmp578_;
					ValaCCodeExpression* _tmp579_;
					ValaMethod* _tmp580_;
					_tmp577_ = in_arg_map;
					_tmp578_ = m;
					_tmp579_ = instance;
					vala_map_set ((ValaMap*) _tmp577_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp578_), FALSE)), _tmp579_);
					_tmp580_ = m;
					if (vala_get_ccode_finish_instance (_tmp580_)) {
						ValaHashMap* _tmp581_;
						ValaMethod* _tmp582_;
						ValaCCodeExpression* _tmp583_;
						_tmp581_ = out_arg_map;
						_tmp582_ = m;
						_tmp583_ = instance;
						vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
					}
				} else {
					gboolean _tmp584_ = FALSE;
					ValaMemberAccess* _tmp585_;
					const gchar* _tmp586_;
					const gchar* _tmp587_;
					_tmp585_ = ma;
					_tmp586_ = vala_member_access_get_member_name (_tmp585_);
					_tmp587_ = _tmp586_;
					if (g_strcmp0 (_tmp587_, "end") != 0) {
						_tmp584_ = TRUE;
					} else {
						ValaMethod* _tmp588_;
						_tmp588_ = m;
						_tmp584_ = vala_get_ccode_finish_instance (_tmp588_);
					}
					if (_tmp584_) {
						ValaHashMap* _tmp589_;
						ValaMethod* _tmp590_;
						ValaCCodeExpression* _tmp591_;
						ValaHashMap* _tmp592_;
						ValaMethod* _tmp593_;
						ValaCCodeExpression* _tmp594_;
						_tmp589_ = out_arg_map;
						_tmp590_ = m;
						_tmp591_ = instance;
						vala_map_set ((ValaMap*) _tmp589_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp590_), FALSE)), _tmp591_);
						_tmp592_ = in_arg_map;
						_tmp593_ = m;
						_tmp594_ = instance;
						vala_map_set ((ValaMap*) _tmp592_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp593_), FALSE)), _tmp594_);
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp595_ = FALSE;
			ValaMethod* _tmp596_;
			_tmp596_ = m;
			if (_tmp596_ != NULL) {
				ValaMethod* _tmp597_;
				ValaMemberBinding _tmp598_;
				ValaMemberBinding _tmp599_;
				_tmp597_ = m;
				_tmp598_ = vala_method_get_binding (_tmp597_);
				_tmp599_ = _tmp598_;
				_tmp595_ = _tmp599_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp595_ = FALSE;
			}
			if (_tmp595_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp600_;
				ValaSymbol* _tmp601_;
				ValaSymbol* _tmp602_;
				ValaClass* _tmp603_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp604_;
				gchar* _tmp605_;
				gchar* _tmp606_;
				ValaCCodeIdentifier* _tmp607_;
				ValaCCodeIdentifier* _tmp608_;
				ValaCCodeFunctionCall* _tmp609_;
				ValaCCodeFunctionCall* _tmp610_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp611_;
				ValaExpression* _tmp612_;
				ValaExpression* _tmp613_;
				ValaCCodeFunctionCall* _tmp636_;
				ValaCCodeExpression* _tmp637_;
				ValaHashMap* _tmp638_;
				ValaMethod* _tmp639_;
				ValaCCodeFunctionCall* _tmp640_;
				ValaHashMap* _tmp641_;
				ValaMethod* _tmp642_;
				ValaCCodeFunctionCall* _tmp643_;
				_tmp600_ = m;
				_tmp601_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp602_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp603_;
				_tmp604_ = cl;
				_tmp605_ = vala_get_ccode_class_type_function (_tmp604_);
				_tmp606_ = _tmp605_;
				_tmp607_ = vala_ccode_identifier_new (_tmp606_);
				_tmp608_ = _tmp607_;
				_tmp609_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp608_);
				_tmp610_ = _tmp609_;
				_vala_ccode_node_unref0 (_tmp608_);
				_g_free0 (_tmp606_);
				cast = _tmp610_;
				_tmp611_ = ma;
				_tmp612_ = vala_member_access_get_inner (_tmp611_);
				_tmp613_ = _tmp612_;
				if (_tmp613_ == NULL) {
					ValaDataType* _tmp614_;
					_tmp614_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp614_ == NULL) {
						ValaCCodeIdentifier* _tmp615_;
						_tmp615_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp615_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp616_;
						ValaCCodeIdentifier* _tmp617_;
						ValaCCodeFunctionCall* _tmp618_;
						ValaCCodeFunctionCall* _tmp619_;
						ValaCCodeFunctionCall* _tmp620_;
						ValaCCodeExpression* _tmp621_;
						ValaCCodeExpression* _tmp622_;
						ValaCCodeFunctionCall* _tmp623_;
						ValaCCodeExpression* _tmp624_;
						_tmp616_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp617_ = _tmp616_;
						_tmp618_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp617_);
						_tmp619_ = _tmp618_;
						_vala_ccode_node_unref0 (_tmp617_);
						k = _tmp619_;
						_tmp620_ = k;
						_tmp621_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp622_ = _tmp621_;
						vala_ccode_function_call_add_argument (_tmp620_, _tmp622_);
						_vala_ccode_node_unref0 (_tmp622_);
						_tmp623_ = k;
						_tmp624_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp623_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp624_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp625_;
					ValaCCodeIdentifier* _tmp626_;
					ValaCCodeFunctionCall* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeFunctionCall* _tmp629_;
					ValaMemberAccess* _tmp630_;
					ValaExpression* _tmp631_;
					ValaExpression* _tmp632_;
					ValaCCodeExpression* _tmp633_;
					ValaCCodeFunctionCall* _tmp634_;
					ValaCCodeExpression* _tmp635_;
					_tmp625_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp626_);
					_tmp628_ = _tmp627_;
					_vala_ccode_node_unref0 (_tmp626_);
					k = _tmp628_;
					_tmp629_ = k;
					_tmp630_ = ma;
					_tmp631_ = vala_member_access_get_inner (_tmp630_);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_get_cvalue (_tmp632_);
					vala_ccode_function_call_add_argument (_tmp629_, _tmp633_);
					_tmp634_ = k;
					_tmp635_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp634_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp635_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp636_ = cast;
				_tmp637_ = klass;
				vala_ccode_function_call_add_argument (_tmp636_, _tmp637_);
				_tmp638_ = in_arg_map;
				_tmp639_ = m;
				_tmp640_ = cast;
				vala_map_set ((ValaMap*) _tmp638_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp639_), FALSE)), (ValaCCodeExpression*) _tmp640_);
				_tmp641_ = out_arg_map;
				_tmp642_ = m;
				_tmp643_ = cast;
				vala_map_set ((ValaMap*) _tmp641_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp642_), FALSE)), (ValaCCodeExpression*) _tmp643_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp645_ = m;
	if (_tmp645_ != NULL) {
		ValaMethod* _tmp646_;
		_tmp646_ = m;
		_tmp644_ = vala_get_ccode_has_generic_type_parameter (_tmp646_);
	} else {
		_tmp644_ = FALSE;
	}
	if (_tmp644_) {
		ValaMethod* _tmp647_;
		_tmp647_ = m;
		if (vala_method_has_type_parameters (_tmp647_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp648_;
				ValaList* _tmp649_;
				ValaList* _tmp650_;
				gint _type_arg_size = 0;
				ValaList* _tmp651_;
				gint _tmp652_;
				gint _tmp653_;
				gint _type_arg_index = 0;
				_tmp648_ = ma;
				_tmp649_ = vala_member_access_get_type_arguments (_tmp648_);
				_tmp650_ = _vala_iterable_ref0 (_tmp649_);
				_type_arg_list = _tmp650_;
				_tmp651_ = _type_arg_list;
				_tmp652_ = vala_collection_get_size ((ValaCollection*) _tmp651_);
				_tmp653_ = _tmp652_;
				_type_arg_size = _tmp653_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp654_;
					gpointer _tmp655_;
					gboolean _tmp656_ = FALSE;
					gboolean _tmp657_ = FALSE;
					gboolean _tmp658_ = FALSE;
					ValaMethod* _tmp659_;
					ValaHashMap* _tmp667_;
					ValaMethod* _tmp668_;
					ValaDataType* _tmp669_;
					gchar* _tmp670_;
					gchar* _tmp671_;
					ValaCCodeIdentifier* _tmp672_;
					ValaCCodeIdentifier* _tmp673_;
					gint _tmp674_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp654_ = _type_arg_list;
					_tmp655_ = vala_list_get (_tmp654_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp655_;
					_tmp659_ = m;
					if (vala_get_ccode_simple_generics (_tmp659_)) {
						ValaDataType* _tmp660_;
						_tmp660_ = type_arg;
						_tmp658_ = vala_data_type_is_real_struct_type (_tmp660_);
					} else {
						_tmp658_ = FALSE;
					}
					if (_tmp658_) {
						ValaDataType* _tmp661_;
						gboolean _tmp662_;
						gboolean _tmp663_;
						_tmp661_ = type_arg;
						_tmp662_ = vala_data_type_get_nullable (_tmp661_);
						_tmp663_ = _tmp662_;
						_tmp657_ = !_tmp663_;
					} else {
						_tmp657_ = FALSE;
					}
					if (_tmp657_) {
						ValaDataType* _tmp664_;
						_tmp664_ = type_arg;
						_tmp656_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp664_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp656_ = FALSE;
					}
					if (_tmp656_) {
						ValaDataType* _tmp665_;
						ValaPointerType* _tmp666_;
						_tmp665_ = type_arg;
						_tmp666_ = vala_pointer_type_new (_tmp665_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp666_;
					}
					_tmp667_ = in_arg_map;
					_tmp668_ = m;
					_tmp669_ = type_arg;
					_tmp670_ = vala_get_ccode_name ((ValaCodeNode*) _tmp669_);
					_tmp671_ = _tmp670_;
					_tmp672_ = vala_ccode_identifier_new (_tmp671_);
					_tmp673_ = _tmp672_;
					vala_map_set ((ValaMap*) _tmp667_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp668_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp673_);
					_vala_ccode_node_unref0 (_tmp673_);
					_g_free0 (_tmp671_);
					_tmp674_ = type_param_index;
					type_param_index = _tmp674_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp675_;
				ValaExpression* _tmp676_;
				ValaExpression* _tmp677_;
				ValaDataType* _tmp678_;
				ValaDataType* _tmp679_;
				ValaList* _tmp680_;
				ValaList* _tmp681_;
				gint _type_arg_size = 0;
				ValaList* _tmp682_;
				gint _tmp683_;
				gint _tmp684_;
				gint _type_arg_index = 0;
				_tmp675_ = ma;
				_tmp676_ = vala_member_access_get_inner (_tmp675_);
				_tmp677_ = _tmp676_;
				_tmp678_ = vala_expression_get_value_type (_tmp677_);
				_tmp679_ = _tmp678_;
				_tmp680_ = vala_data_type_get_type_arguments (_tmp679_);
				_tmp681_ = _vala_iterable_ref0 (_tmp680_);
				_type_arg_list = _tmp681_;
				_tmp682_ = _type_arg_list;
				_tmp683_ = vala_collection_get_size ((ValaCollection*) _tmp682_);
				_tmp684_ = _tmp683_;
				_type_arg_size = _tmp684_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp685_;
					gpointer _tmp686_;
					ValaHashMap* _tmp687_;
					ValaMethod* _tmp688_;
					ValaDataType* _tmp689_;
					gchar* _tmp690_;
					gchar* _tmp691_;
					ValaCCodeIdentifier* _tmp692_;
					ValaCCodeIdentifier* _tmp693_;
					gint _tmp694_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp685_ = _type_arg_list;
					_tmp686_ = vala_list_get (_tmp685_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp686_;
					_tmp687_ = in_arg_map;
					_tmp688_ = m;
					_tmp689_ = type_arg;
					_tmp690_ = vala_get_ccode_name ((ValaCodeNode*) _tmp689_);
					_tmp691_ = _tmp690_;
					_tmp692_ = vala_ccode_identifier_new (_tmp691_);
					_tmp693_ = _tmp692_;
					vala_map_set ((ValaMap*) _tmp687_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp688_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp693_);
					_vala_ccode_node_unref0 (_tmp693_);
					_g_free0 (_tmp691_);
					_tmp694_ = type_param_index;
					type_param_index = _tmp694_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp695_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp695_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp696_;
		ValaExpression* _tmp697_;
		ValaExpression* _tmp698_;
		ValaDataType* _tmp699_;
		ValaDataType* _tmp700_;
		ValaArrayType* _tmp701_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp702_;
		ValaCCodeIdentifier* _tmp703_;
		ValaCCodeFunctionCall* _tmp704_;
		ValaCCodeFunctionCall* _tmp705_;
		ValaCCodeFunctionCall* _tmp706_;
		ValaArrayType* _tmp707_;
		ValaDataType* _tmp708_;
		ValaDataType* _tmp709_;
		gchar* _tmp710_;
		gchar* _tmp711_;
		ValaCCodeIdentifier* _tmp712_;
		ValaCCodeIdentifier* _tmp713_;
		ValaHashMap* _tmp714_;
		ValaCCodeFunctionCall* _tmp715_;
		_tmp696_ = ma;
		_tmp697_ = vala_member_access_get_inner (_tmp696_);
		_tmp698_ = _tmp697_;
		_tmp699_ = vala_expression_get_value_type (_tmp698_);
		_tmp700_ = _tmp699_;
		_tmp701_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp700_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp701_;
		_tmp702_ = vala_ccode_identifier_new ("sizeof");
		_tmp703_ = _tmp702_;
		_tmp704_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp703_);
		_tmp705_ = _tmp704_;
		_vala_ccode_node_unref0 (_tmp703_);
		csizeof = _tmp705_;
		_tmp706_ = csizeof;
		_tmp707_ = array_type;
		_tmp708_ = vala_array_type_get_element_type (_tmp707_);
		_tmp709_ = _tmp708_;
		_tmp710_ = vala_get_ccode_name ((ValaCodeNode*) _tmp709_);
		_tmp711_ = _tmp710_;
		_tmp712_ = vala_ccode_identifier_new (_tmp711_);
		_tmp713_ = _tmp712_;
		vala_ccode_function_call_add_argument (_tmp706_, (ValaCCodeExpression*) _tmp713_);
		_vala_ccode_node_unref0 (_tmp713_);
		_g_free0 (_tmp711_);
		_tmp714_ = in_arg_map;
		_tmp715_ = csizeof;
		vala_map_set ((ValaMap*) _tmp714_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp715_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp716_;
		_tmp716_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp716_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp717_;
			ValaMethod* _tmp718_;
			ValaMethod* _tmp719_;
			gint param_nr = 0;
			ValaMethod* _tmp781_;
			ValaCCodeBaseModuleEmitContext* _tmp782_;
			_tmp717_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp718_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp717_, (ValaSymbol*) _tmp718_);
			_tmp719_ = m;
			vala_method_clear_parameters (_tmp719_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp720_;
				ValaList* _tmp721_;
				gint _arg_size = 0;
				ValaList* _tmp722_;
				gint _tmp723_;
				gint _tmp724_;
				gint _arg_index = 0;
				_tmp720_ = vala_method_call_get_argument_list (expr);
				_tmp721_ = _vala_iterable_ref0 (_tmp720_);
				_arg_list = _tmp721_;
				_tmp722_ = _arg_list;
				_tmp723_ = vala_collection_get_size ((ValaCollection*) _tmp722_);
				_tmp724_ = _tmp723_;
				_arg_size = _tmp724_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp725_;
					gpointer _tmp726_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp727_;
					ValaUnaryExpression* _tmp728_;
					gboolean _tmp729_ = FALSE;
					ValaUnaryExpression* _tmp730_;
					gint _tmp771_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp725_ = _arg_list;
					_tmp726_ = vala_list_get (_tmp725_, _arg_index);
					arg = (ValaExpression*) _tmp726_;
					_tmp727_ = arg;
					_tmp728_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp727_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp727_) : NULL);
					unary = _tmp728_;
					_tmp730_ = unary;
					if (_tmp730_ != NULL) {
						ValaUnaryExpression* _tmp731_;
						ValaUnaryOperator _tmp732_;
						ValaUnaryOperator _tmp733_;
						_tmp731_ = unary;
						_tmp732_ = vala_unary_expression_get_operator (_tmp731_);
						_tmp733_ = _tmp732_;
						_tmp729_ = _tmp733_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp729_ = FALSE;
					}
					if (_tmp729_) {
						ValaParameter* param = NULL;
						gchar* _tmp734_;
						gchar* _tmp735_;
						ValaUnaryExpression* _tmp736_;
						ValaExpression* _tmp737_;
						ValaExpression* _tmp738_;
						ValaDataType* _tmp739_;
						ValaDataType* _tmp740_;
						ValaParameter* _tmp741_;
						ValaParameter* _tmp742_;
						ValaParameter* _tmp743_;
						ValaMethod* _tmp744_;
						ValaParameter* _tmp745_;
						_tmp734_ = g_strdup_printf ("param%d", param_nr);
						_tmp735_ = _tmp734_;
						_tmp736_ = unary;
						_tmp737_ = vala_unary_expression_get_inner (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_expression_get_value_type (_tmp738_);
						_tmp740_ = _tmp739_;
						_tmp741_ = vala_parameter_new (_tmp735_, _tmp740_, NULL);
						_tmp742_ = _tmp741_;
						_g_free0 (_tmp735_);
						param = _tmp742_;
						_tmp743_ = param;
						vala_parameter_set_direction (_tmp743_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp744_ = m;
						_tmp745_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp744_, _tmp745_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp746_ = FALSE;
						ValaUnaryExpression* _tmp747_;
						_tmp747_ = unary;
						if (_tmp747_ != NULL) {
							ValaUnaryExpression* _tmp748_;
							ValaUnaryOperator _tmp749_;
							ValaUnaryOperator _tmp750_;
							_tmp748_ = unary;
							_tmp749_ = vala_unary_expression_get_operator (_tmp748_);
							_tmp750_ = _tmp749_;
							_tmp746_ = _tmp750_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp746_ = FALSE;
						}
						if (_tmp746_) {
							ValaParameter* param = NULL;
							gchar* _tmp751_;
							gchar* _tmp752_;
							ValaUnaryExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaExpression* _tmp755_;
							ValaDataType* _tmp756_;
							ValaDataType* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaParameter* _tmp760_;
							ValaMethod* _tmp761_;
							ValaParameter* _tmp762_;
							_tmp751_ = g_strdup_printf ("param%d", param_nr);
							_tmp752_ = _tmp751_;
							_tmp753_ = unary;
							_tmp754_ = vala_unary_expression_get_inner (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = vala_expression_get_value_type (_tmp755_);
							_tmp757_ = _tmp756_;
							_tmp758_ = vala_parameter_new (_tmp752_, _tmp757_, NULL);
							_tmp759_ = _tmp758_;
							_g_free0 (_tmp752_);
							param = _tmp759_;
							_tmp760_ = param;
							vala_parameter_set_direction (_tmp760_, VALA_PARAMETER_DIRECTION_REF);
							_tmp761_ = m;
							_tmp762_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp761_, _tmp762_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp763_;
							gchar* _tmp764_;
							gchar* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							_tmp763_ = m;
							_tmp764_ = g_strdup_printf ("param%d", param_nr);
							_tmp765_ = _tmp764_;
							_tmp766_ = arg;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp765_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							vala_callable_add_parameter ((ValaCallable*) _tmp763_, _tmp770_);
							_vala_code_node_unref0 (_tmp770_);
							_g_free0 (_tmp765_);
						}
					}
					_tmp771_ = param_nr;
					param_nr = _tmp771_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp772_;
				ValaList* _tmp773_;
				ValaList* _tmp774_;
				gint _param_size = 0;
				ValaList* _tmp775_;
				gint _tmp776_;
				gint _tmp777_;
				gint _param_index = 0;
				_tmp772_ = m;
				_tmp773_ = vala_callable_get_parameters ((ValaCallable*) _tmp772_);
				_tmp774_ = _vala_iterable_ref0 (_tmp773_);
				_param_list = _tmp774_;
				_tmp775_ = _param_list;
				_tmp776_ = vala_collection_get_size ((ValaCollection*) _tmp775_);
				_tmp777_ = _tmp776_;
				_param_size = _tmp777_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp778_;
					gpointer _tmp779_;
					ValaParameter* _tmp780_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp778_ = _param_list;
					_tmp779_ = vala_list_get (_tmp778_, _param_index);
					param = (ValaParameter*) _tmp779_;
					_tmp780_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp780_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp781_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp781_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp782_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp782_);
		} else {
			gboolean _tmp783_ = FALSE;
			gboolean _tmp784_ = FALSE;
			ValaMethod* _tmp785_;
			_tmp785_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp785_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp786_;
				ValaCodeContext* _tmp787_;
				ValaProfile _tmp788_;
				ValaProfile _tmp789_;
				_tmp786_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp787_ = _tmp786_;
				_tmp788_ = vala_code_context_get_profile (_tmp787_);
				_tmp789_ = _tmp788_;
				_tmp784_ = _tmp789_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp784_ = FALSE;
			}
			if (_tmp784_) {
				ValaMethod* _tmp790_;
				ValaSymbol* _tmp791_;
				ValaSymbol* _tmp792_;
				_tmp790_ = m;
				_tmp791_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp790_);
				_tmp792_ = _tmp791_;
				_tmp783_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp792_, VALA_TYPE_CLASS);
			} else {
				_tmp783_ = FALSE;
			}
			if (_tmp783_) {
				ValaCCodeFunction* _tmp793_;
				ValaCCodeFunction* _tmp794_;
				ValaCCodeExpression* _tmp795_;
				ValaCCodeExpression* _tmp796_;
				ValaCCodeFunctionCall* _tmp797_;
				ValaClass* _tmp798_;
				ValaClass* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				gchar* _tmp802_;
				gchar* _tmp803_;
				ValaCCodeCastExpression* _tmp804_;
				ValaCCodeCastExpression* _tmp805_;
				ValaMethod* _tmp806_;
				ValaMethod* _tmp807_;
				ValaBlock* _tmp808_;
				ValaBlock* _tmp809_;
				gboolean _tmp810_;
				gboolean _tmp811_;
				gboolean _tmp838_ = FALSE;
				ValaClass* _tmp839_;
				ValaClass* _tmp840_;
				gboolean _tmp841_;
				gboolean _tmp842_;
				_tmp793_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp794_ = _tmp793_;
				_tmp795_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = ccall;
				_tmp798_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp799_ = _tmp798_;
				_tmp800_ = vala_get_ccode_name ((ValaCodeNode*) _tmp799_);
				_tmp801_ = _tmp800_;
				_tmp802_ = g_strconcat (_tmp801_, "*", NULL);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp797_, _tmp803_);
				_tmp805_ = _tmp804_;
				vala_ccode_function_add_assignment (_tmp794_, _tmp796_, (ValaCCodeExpression*) _tmp805_);
				_vala_ccode_node_unref0 (_tmp805_);
				_g_free0 (_tmp803_);
				_g_free0 (_tmp801_);
				_vala_ccode_node_unref0 (_tmp796_);
				_tmp806_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp807_ = _tmp806_;
				_tmp808_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp807_);
				_tmp809_ = _tmp808_;
				_tmp810_ = vala_block_get_captured (_tmp809_);
				_tmp811_ = _tmp810_;
				if (_tmp811_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp812_;
					ValaClass* _tmp813_;
					ValaObjectType* _tmp814_;
					ValaObjectType* _tmp815_;
					ValaSourceReference* _tmp816_;
					ValaSourceReference* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeExpression* _tmp819_;
					ValaCCodeFunctionCall* _tmp820_;
					ValaCCodeFunctionCall* _tmp821_;
					ValaCCodeFunctionCall* _tmp822_;
					ValaCCodeExpression* _tmp823_;
					ValaCCodeExpression* _tmp824_;
					ValaCCodeFunction* _tmp825_;
					ValaCCodeFunction* _tmp826_;
					ValaMethod* _tmp827_;
					ValaMethod* _tmp828_;
					ValaBlock* _tmp829_;
					ValaBlock* _tmp830_;
					gchar* _tmp831_;
					gchar* _tmp832_;
					ValaCCodeExpression* _tmp833_;
					ValaCCodeExpression* _tmp834_;
					ValaCCodeMemberAccess* _tmp835_;
					ValaCCodeMemberAccess* _tmp836_;
					ValaCCodeFunctionCall* _tmp837_;
					_tmp812_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp813_);
					_tmp815_ = _tmp814_;
					_tmp816_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp815_, _tmp817_, FALSE);
					_tmp819_ = _tmp818_;
					_tmp820_ = vala_ccode_function_call_new (_tmp819_);
					_tmp821_ = _tmp820_;
					_vala_ccode_node_unref0 (_tmp819_);
					_vala_code_node_unref0 (_tmp815_);
					ref_call = _tmp821_;
					_tmp822_ = ref_call;
					_tmp823_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp824_ = _tmp823_;
					vala_ccode_function_call_add_argument (_tmp822_, _tmp824_);
					_vala_ccode_node_unref0 (_tmp824_);
					_tmp825_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp828_);
					_tmp830_ = _tmp829_;
					_tmp831_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp830_));
					_tmp832_ = _tmp831_;
					_tmp833_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp832_);
					_tmp834_ = _tmp833_;
					_tmp835_ = vala_ccode_member_access_new_pointer (_tmp834_, "self");
					_tmp836_ = _tmp835_;
					_tmp837_ = ref_call;
					vala_ccode_function_add_assignment (_tmp826_, (ValaCCodeExpression*) _tmp836_, (ValaCCodeExpression*) _tmp837_);
					_vala_ccode_node_unref0 (_tmp836_);
					_vala_ccode_node_unref0 (_tmp834_);
					_g_free0 (_tmp832_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp839_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_class_get_is_compact (_tmp840_);
				_tmp842_ = _tmp841_;
				if (!_tmp842_) {
					ValaClass* _tmp843_;
					ValaClass* _tmp844_;
					_tmp843_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp844_ = _tmp843_;
					_tmp838_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp844_);
				} else {
					_tmp838_ = FALSE;
				}
				if (_tmp838_) {
					gchar** suffices = NULL;
					gchar* _tmp845_;
					gchar* _tmp846_;
					gchar* _tmp847_;
					gchar** _tmp848_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp845_ = g_strdup ("type");
					_tmp846_ = g_strdup ("dup_func");
					_tmp847_ = g_strdup ("destroy_func");
					_tmp848_ = g_new0 (gchar*, 3 + 1);
					_tmp848_[0] = _tmp845_;
					_tmp848_[1] = _tmp846_;
					_tmp848_[2] = _tmp847_;
					suffices = _tmp848_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp849_;
						ValaClass* _tmp850_;
						ValaList* _tmp851_;
						ValaList* _tmp852_;
						gint _type_param_size = 0;
						ValaList* _tmp853_;
						gint _tmp854_;
						gint _tmp855_;
						gint _type_param_index = 0;
						_tmp849_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp850_ = _tmp849_;
						_tmp851_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp850_);
						_tmp852_ = _vala_iterable_ref0 (_tmp851_);
						_type_param_list = _tmp852_;
						_tmp853_ = _type_param_list;
						_tmp854_ = vala_collection_get_size ((ValaCollection*) _tmp853_);
						_tmp855_ = _tmp854_;
						_type_param_size = _tmp855_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp856_;
							gpointer _tmp857_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp858_;
							ValaCCodeIdentifier* _tmp859_;
							ValaCCodeMemberAccess* _tmp860_;
							ValaCCodeMemberAccess* _tmp861_;
							gchar** _tmp862_;
							gint _tmp862__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp856_ = _type_param_list;
							_tmp857_ = vala_list_get (_tmp856_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp857_;
							_tmp858_ = vala_ccode_identifier_new ("self");
							_tmp859_ = _tmp858_;
							_tmp860_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp859_, "priv");
							_tmp861_ = _tmp860_;
							_vala_ccode_node_unref0 (_tmp859_);
							priv_access = _tmp861_;
							_tmp862_ = suffices;
							_tmp862__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp862_;
								suffix_collection_length1 = _tmp862__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp863_;
									gchar* suffix = NULL;
									_tmp863_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp863_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp864_;
										const gchar* _tmp865_;
										const gchar* _tmp866_;
										gchar* _tmp867_;
										gchar* _tmp868_;
										const gchar* _tmp869_;
										gchar* _tmp870_;
										gchar* _tmp871_;
										ValaCCodeIdentifier* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										ValaCCodeFunction* _tmp874_;
										ValaCCodeFunction* _tmp875_;
										ValaCCodeMemberAccess* _tmp876_;
										ValaCCodeIdentifier* _tmp877_;
										const gchar* _tmp878_;
										const gchar* _tmp879_;
										ValaCCodeMemberAccess* _tmp880_;
										ValaCCodeMemberAccess* _tmp881_;
										ValaCCodeIdentifier* _tmp882_;
										_tmp864_ = type_param;
										_tmp865_ = vala_symbol_get_name ((ValaSymbol*) _tmp864_);
										_tmp866_ = _tmp865_;
										_tmp867_ = g_utf8_strdown (_tmp866_, (gssize) -1);
										_tmp868_ = _tmp867_;
										_tmp869_ = suffix;
										_tmp870_ = g_strdup_printf ("%s_%s", _tmp868_, _tmp869_);
										_tmp871_ = _tmp870_;
										_tmp872_ = vala_ccode_identifier_new (_tmp871_);
										_tmp873_ = _tmp872_;
										_g_free0 (_tmp871_);
										_g_free0 (_tmp868_);
										param_name = _tmp873_;
										_tmp874_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp875_ = _tmp874_;
										_tmp876_ = priv_access;
										_tmp877_ = param_name;
										_tmp878_ = vala_ccode_identifier_get_name (_tmp877_);
										_tmp879_ = _tmp878_;
										_tmp880_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp876_, _tmp879_);
										_tmp881_ = _tmp880_;
										_tmp882_ = param_name;
										vala_ccode_function_add_assignment (_tmp875_, (ValaCCodeExpression*) _tmp881_, (ValaCCodeExpression*) _tmp882_);
										_vala_ccode_node_unref0 (_tmp881_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp883_ = params;
	_tmp884_ = vala_iterable_iterator ((ValaIterable*) _tmp883_);
	params_it = _tmp884_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp885_;
		ValaList* _tmp886_;
		gint _arg_size = 0;
		ValaList* _tmp887_;
		gint _tmp888_;
		gint _tmp889_;
		gint _arg_index = 0;
		_tmp885_ = vala_method_call_get_argument_list (expr);
		_tmp886_ = _vala_iterable_ref0 (_tmp885_);
		_arg_list = _tmp886_;
		_tmp887_ = _arg_list;
		_tmp888_ = vala_collection_get_size ((ValaCollection*) _tmp887_);
		_tmp889_ = _tmp888_;
		_arg_size = _tmp889_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp890_;
			gpointer _tmp891_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp892_;
			ValaCCodeExpression* _tmp893_;
			ValaCCodeExpression* _tmp894_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp895_;
			ValaHashMap* _tmp896_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp897_;
			gboolean _tmp907_ = FALSE;
			ValaParameter* _tmp908_;
			gdouble _tmp1245_ = 0.0;
			gboolean _tmp1246_ = FALSE;
			ValaParameter* _tmp1247_;
			ValaHashMap* _tmp1249_;
			ValaCCodeExpression* _tmp1250_;
			gboolean _tmp1251_ = FALSE;
			ValaMethod* _tmp1252_;
			gboolean _tmp1277_ = FALSE;
			ValaExpression* _tmp1278_;
			gint _tmp1295_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp890_ = _arg_list;
			_tmp891_ = vala_list_get (_tmp890_, _arg_index);
			arg = (ValaExpression*) _tmp891_;
			_tmp892_ = arg;
			_tmp893_ = vala_get_cvalue (_tmp892_);
			_tmp894_ = _vala_ccode_node_ref0 (_tmp893_);
			cexpr = _tmp894_;
			_tmp895_ = in_arg_map;
			_tmp896_ = _vala_map_ref0 (_tmp895_);
			carg_map = _tmp896_;
			param = NULL;
			_tmp897_ = params_it;
			if (vala_iterator_next (_tmp897_)) {
				ValaIterator* _tmp898_;
				gpointer _tmp899_;
				gboolean _tmp900_ = FALSE;
				ValaParameter* _tmp901_;
				gboolean _tmp902_;
				gboolean _tmp903_;
				_tmp898_ = params_it;
				_tmp899_ = vala_iterator_get (_tmp898_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp899_;
				_tmp901_ = param;
				_tmp902_ = vala_parameter_get_params_array (_tmp901_);
				_tmp903_ = _tmp902_;
				if (_tmp903_) {
					_tmp900_ = TRUE;
				} else {
					ValaParameter* _tmp904_;
					gboolean _tmp905_;
					gboolean _tmp906_;
					_tmp904_ = param;
					_tmp905_ = vala_parameter_get_ellipsis (_tmp904_);
					_tmp906_ = _tmp905_;
					_tmp900_ = _tmp906_;
				}
				ellipsis = _tmp900_;
			}
			_tmp908_ = param;
			if (_tmp908_ != NULL) {
				_tmp907_ = !ellipsis;
			} else {
				_tmp907_ = FALSE;
			}
			if (_tmp907_) {
				ValaParameter* _tmp909_;
				ValaParameterDirection _tmp910_;
				ValaParameterDirection _tmp911_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp914_;
				ValaUnaryExpression* _tmp915_;
				gboolean _tmp916_ = FALSE;
				ValaUnaryExpression* _tmp917_;
				ValaParameter* _tmp1175_;
				gchar* _tmp1176_;
				gchar* _tmp1177_;
				gboolean _tmp1178_;
				_tmp909_ = param;
				_tmp910_ = vala_parameter_get_direction (_tmp909_);
				_tmp911_ = _tmp910_;
				if (_tmp911_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp912_;
					ValaHashMap* _tmp913_;
					_tmp912_ = out_arg_map;
					_tmp913_ = _vala_map_ref0 (_tmp912_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp913_;
				}
				_tmp914_ = arg;
				_tmp915_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp914_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp914_) : NULL);
				unary = _tmp915_;
				_tmp917_ = unary;
				if (_tmp917_ == NULL) {
					_tmp916_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp918_;
					ValaUnaryOperator _tmp919_;
					ValaUnaryOperator _tmp920_;
					_tmp918_ = unary;
					_tmp919_ = vala_unary_expression_get_operator (_tmp918_);
					_tmp920_ = _tmp919_;
					_tmp916_ = _tmp920_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp916_) {
					gboolean _tmp921_ = FALSE;
					gboolean _tmp922_ = FALSE;
					ValaParameter* _tmp923_;
					ValaParameter* _tmp1055_;
					ValaExpression* _tmp1056_;
					ValaCCodeExpression* _tmp1057_;
					ValaCCodeExpression* _tmp1058_;
					_tmp923_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp923_)) {
						ValaParameter* _tmp924_;
						ValaDataType* _tmp925_;
						ValaDataType* _tmp926_;
						_tmp924_ = param;
						_tmp925_ = vala_variable_get_variable_type ((ValaVariable*) _tmp924_);
						_tmp926_ = _tmp925_;
						_tmp922_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp926_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp922_ = FALSE;
					}
					if (_tmp922_) {
						ValaParameter* _tmp927_;
						ValaDataType* _tmp928_;
						ValaDataType* _tmp929_;
						gboolean _tmp930_;
						gboolean _tmp931_;
						_tmp927_ = param;
						_tmp928_ = vala_variable_get_variable_type ((ValaVariable*) _tmp927_);
						_tmp929_ = _tmp928_;
						_tmp930_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp929_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp931_ = _tmp930_;
						_tmp921_ = !_tmp931_;
					} else {
						_tmp921_ = FALSE;
					}
					if (_tmp921_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp932_;
						ValaDataType* _tmp933_;
						ValaDataType* _tmp934_;
						ValaArrayType* _tmp935_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp936_;
						gchar* _tmp937_;
						gboolean _tmp938_ = FALSE;
						ValaUnaryExpression* _tmp939_;
						_tmp932_ = param;
						_tmp933_ = vala_variable_get_variable_type ((ValaVariable*) _tmp932_);
						_tmp934_ = _tmp933_;
						_tmp935_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp934_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp935_;
						_tmp936_ = param;
						_tmp937_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp936_);
						length_ctype = _tmp937_;
						_tmp939_ = unary;
						if (_tmp939_ != NULL) {
							ValaUnaryExpression* _tmp940_;
							ValaUnaryOperator _tmp941_;
							ValaUnaryOperator _tmp942_;
							_tmp940_ = unary;
							_tmp941_ = vala_unary_expression_get_operator (_tmp940_);
							_tmp942_ = _tmp941_;
							_tmp938_ = _tmp942_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp938_ = FALSE;
						}
						if (_tmp938_) {
							const gchar* _tmp943_;
							gchar* _tmp944_;
							_tmp943_ = length_ctype;
							_tmp944_ = g_strdup_printf ("%s*", _tmp943_);
							_g_free0 (length_ctype);
							length_ctype = _tmp944_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp945_ = FALSE;
								_tmp945_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp947_;
									gint _tmp948_;
									gint _tmp949_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp950_;
									ValaCCodeExpression* _tmp951_;
									ValaCCodeExpression* _tmp952_;
									const gchar* _tmp953_;
									ValaCCodeCastExpression* _tmp954_;
									ValaCCodeCastExpression* _tmp955_;
									ValaHashMap* _tmp956_;
									ValaParameter* _tmp957_;
									ValaCCodeCastExpression* _tmp958_;
									if (!_tmp945_) {
										gint _tmp946_;
										_tmp946_ = dim;
										dim = _tmp946_ + 1;
									}
									_tmp945_ = FALSE;
									_tmp947_ = array_type;
									_tmp948_ = vala_array_type_get_rank (_tmp947_);
									_tmp949_ = _tmp948_;
									if (!(dim <= _tmp949_)) {
										break;
									}
									_tmp950_ = arg;
									_tmp951_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp950_, dim);
									_tmp952_ = _tmp951_;
									_tmp953_ = length_ctype;
									_tmp954_ = vala_ccode_cast_expression_new (_tmp952_, _tmp953_);
									_tmp955_ = _tmp954_;
									_vala_ccode_node_unref0 (_tmp952_);
									array_length_expr = _tmp955_;
									_tmp956_ = carg_map;
									_tmp957_ = param;
									_tmp958_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp956_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp957_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp958_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp959_ = FALSE;
						ValaParameter* _tmp960_;
						_tmp960_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp960_)) {
							ValaParameter* _tmp961_;
							ValaDataType* _tmp962_;
							ValaDataType* _tmp963_;
							_tmp961_ = param;
							_tmp962_ = vala_variable_get_variable_type ((ValaVariable*) _tmp961_);
							_tmp963_ = _tmp962_;
							_tmp959_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp963_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp959_ = FALSE;
						}
						if (_tmp959_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp964_;
							ValaDataType* _tmp965_;
							ValaDataType* _tmp966_;
							ValaDelegateType* _tmp967_;
							ValaDelegateType* _tmp968_;
							ValaDelegate* _tmp969_;
							ValaDelegate* _tmp970_;
							gboolean _tmp971_;
							gboolean _tmp972_;
							_tmp964_ = param;
							_tmp965_ = vala_variable_get_variable_type ((ValaVariable*) _tmp964_);
							_tmp966_ = _tmp965_;
							_tmp967_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp966_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp967_;
							_tmp968_ = deleg_type;
							_tmp969_ = vala_delegate_type_get_delegate_symbol (_tmp968_);
							_tmp970_ = _tmp969_;
							_tmp971_ = vala_delegate_get_has_target (_tmp970_);
							_tmp972_ = _tmp971_;
							if (_tmp972_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp973_;
								ValaCCodeExpression* _tmp974_ = NULL;
								ValaCCodeExpression* _tmp975_;
								ValaCCodeExpression* _tmp976_;
								ValaParameter* _tmp977_;
								gchar* _tmp978_;
								gchar* _tmp979_;
								gboolean _tmp980_;
								_tmp973_ = arg;
								_tmp975_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp973_, &_tmp974_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp974_;
								delegate_target = _tmp975_;
								_tmp976_ = delegate_target;
								_vala_assert (_tmp976_ != NULL, "delegate_target != null");
								_tmp977_ = param;
								_tmp978_ = vala_get_ccode_type ((ValaCodeNode*) _tmp977_);
								_tmp979_ = _tmp978_;
								_tmp980_ = g_strcmp0 (_tmp979_, "GClosure*") == 0;
								_g_free0 (_tmp979_);
								if (_tmp980_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp981_;
									ValaCCodeIdentifier* _tmp982_;
									ValaCCodeFunctionCall* _tmp983_;
									ValaCCodeFunctionCall* _tmp984_;
									ValaCCodeFunctionCall* _tmp985_;
									ValaCCodeExpression* _tmp986_;
									ValaCCodeCastExpression* _tmp987_;
									ValaCCodeCastExpression* _tmp988_;
									ValaCCodeFunctionCall* _tmp989_;
									ValaCCodeExpression* _tmp990_;
									ValaCCodeFunctionCall* _tmp991_;
									ValaCCodeExpression* _tmp992_;
									ValaCCodeCastExpression* _tmp993_;
									ValaCCodeCastExpression* _tmp994_;
									ValaCCodeExpression* _tmp995_;
									ValaCCodeIdentifier* _tmp996_;
									ValaCCodeIdentifier* _tmp997_;
									ValaCCodeBinaryExpression* _tmp998_;
									ValaCCodeBinaryExpression* _tmp999_;
									ValaCCodeIdentifier* _tmp1000_;
									ValaCCodeIdentifier* _tmp1001_;
									ValaCCodeFunctionCall* _tmp1002_;
									ValaCCodeConditionalExpression* _tmp1003_;
									_tmp981_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp982_ = _tmp981_;
									_tmp983_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp982_);
									_tmp984_ = _tmp983_;
									_vala_ccode_node_unref0 (_tmp982_);
									closure_new = _tmp984_;
									_tmp985_ = closure_new;
									_tmp986_ = cexpr;
									_tmp987_ = vala_ccode_cast_expression_new (_tmp986_, "GCallback");
									_tmp988_ = _tmp987_;
									vala_ccode_function_call_add_argument (_tmp985_, (ValaCCodeExpression*) _tmp988_);
									_vala_ccode_node_unref0 (_tmp988_);
									_tmp989_ = closure_new;
									_tmp990_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp989_, _tmp990_);
									_tmp991_ = closure_new;
									_tmp992_ = delegate_target_destroy_notify;
									_tmp993_ = vala_ccode_cast_expression_new (_tmp992_, "GClosureNotify");
									_tmp994_ = _tmp993_;
									vala_ccode_function_call_add_argument (_tmp991_, (ValaCCodeExpression*) _tmp994_);
									_vala_ccode_node_unref0 (_tmp994_);
									_tmp995_ = cexpr;
									_tmp996_ = vala_ccode_identifier_new ("NULL");
									_tmp997_ = _tmp996_;
									_tmp998_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp995_, (ValaCCodeExpression*) _tmp997_);
									_tmp999_ = _tmp998_;
									_tmp1000_ = vala_ccode_identifier_new ("NULL");
									_tmp1001_ = _tmp1000_;
									_tmp1002_ = closure_new;
									_tmp1003_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp999_, (ValaCCodeExpression*) _tmp1001_, (ValaCCodeExpression*) _tmp1002_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1003_;
									_vala_ccode_node_unref0 (_tmp1001_);
									_vala_ccode_node_unref0 (_tmp999_);
									_vala_ccode_node_unref0 (_tmp997_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1004_;
									ValaParameter* _tmp1005_;
									ValaCCodeExpression* _tmp1006_;
									ValaDelegateType* _tmp1007_;
									_tmp1004_ = carg_map;
									_tmp1005_ = param;
									_tmp1006_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1004_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1005_), FALSE)), _tmp1006_);
									_tmp1007_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1007_)) {
										ValaCCodeExpression* _tmp1008_;
										ValaHashMap* _tmp1009_;
										ValaParameter* _tmp1010_;
										ValaCCodeExpression* _tmp1011_;
										_tmp1008_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1008_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1009_ = carg_map;
										_tmp1010_ = param;
										_tmp1011_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1009_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1010_) + 0.01, FALSE)), _tmp1011_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1012_;
							ValaDataType* _tmp1013_;
							ValaDataType* _tmp1014_;
							_tmp1012_ = param;
							_tmp1013_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1012_);
							_tmp1014_ = _tmp1013_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1014_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1015_;
								ValaParameter* _tmp1016_;
								ValaExpression* _tmp1017_;
								ValaCCodeExpression* _tmp1018_ = NULL;
								ValaCCodeExpression* _tmp1019_;
								ValaCCodeExpression* _tmp1020_;
								_tmp1015_ = carg_map;
								_tmp1016_ = param;
								_tmp1017_ = arg;
								_tmp1019_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1017_, &_tmp1018_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1018_;
								_tmp1020_ = _tmp1019_;
								vala_map_set ((ValaMap*) _tmp1015_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1016_), FALSE)), _tmp1020_);
								_vala_ccode_node_unref0 (_tmp1020_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1021_;
								ValaDataType* _tmp1022_;
								ValaDataType* _tmp1023_;
								_tmp1021_ = param;
								_tmp1022_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1021_);
								_tmp1023_ = _tmp1022_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1023_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1024_ = FALSE;
									ValaMethod* _tmp1025_;
									_tmp1025_ = m;
									if (_tmp1025_ != NULL) {
										ValaMethod* _tmp1026_;
										_tmp1026_ = m;
										_tmp1024_ = vala_get_ccode_simple_generics (_tmp1026_);
									} else {
										_tmp1024_ = FALSE;
									}
									if (_tmp1024_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1027_;
										ValaDataType* _tmp1028_;
										ValaDataType* _tmp1029_;
										ValaGenericType* _tmp1030_;
										gint type_param_index = 0;
										ValaMethod* _tmp1031_;
										ValaGenericType* _tmp1032_;
										ValaTypeParameter* _tmp1033_;
										ValaTypeParameter* _tmp1034_;
										const gchar* _tmp1035_;
										const gchar* _tmp1036_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1037_;
										ValaList* _tmp1038_;
										gpointer _tmp1039_;
										ValaParameter* _tmp1040_;
										ValaDataType* _tmp1041_;
										ValaDataType* _tmp1042_;
										gboolean _tmp1043_;
										gboolean _tmp1044_;
										_tmp1027_ = param;
										_tmp1028_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1027_);
										_tmp1029_ = _tmp1028_;
										_tmp1030_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1029_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1030_;
										_tmp1031_ = m;
										_tmp1032_ = generic_type;
										_tmp1033_ = vala_generic_type_get_type_parameter (_tmp1032_);
										_tmp1034_ = _tmp1033_;
										_tmp1035_ = vala_symbol_get_name ((ValaSymbol*) _tmp1034_);
										_tmp1036_ = _tmp1035_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1031_, _tmp1036_);
										_tmp1037_ = ma;
										_tmp1038_ = vala_member_access_get_type_arguments (_tmp1037_);
										_tmp1039_ = vala_list_get (_tmp1038_, type_param_index);
										type_arg = (ValaDataType*) _tmp1039_;
										_tmp1040_ = param;
										_tmp1041_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1043_ = vala_data_type_get_value_owned (_tmp1042_);
										_tmp1044_ = _tmp1043_;
										if (_tmp1044_) {
											ValaDataType* _tmp1045_;
											_tmp1045_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1045_)) {
												ValaHashMap* _tmp1046_;
												ValaParameter* _tmp1047_;
												ValaDataType* _tmp1048_;
												ValaCCodeExpression* _tmp1049_;
												ValaCCodeExpression* _tmp1050_;
												_tmp1046_ = carg_map;
												_tmp1047_ = param;
												_tmp1048_ = type_arg;
												_tmp1049_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1048_, FALSE);
												_tmp1050_ = _tmp1049_;
												vala_map_set ((ValaMap*) _tmp1046_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1047_), FALSE)), _tmp1050_);
												_vala_ccode_node_unref0 (_tmp1050_);
											} else {
												ValaHashMap* _tmp1051_;
												ValaParameter* _tmp1052_;
												ValaCCodeConstant* _tmp1053_;
												ValaCCodeConstant* _tmp1054_;
												_tmp1051_ = carg_map;
												_tmp1052_ = param;
												_tmp1053_ = vala_ccode_constant_new ("NULL");
												_tmp1054_ = _tmp1053_;
												vala_map_set ((ValaMap*) _tmp1051_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1052_), FALSE)), (ValaCCodeExpression*) _tmp1054_);
												_vala_ccode_node_unref0 (_tmp1054_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1055_ = param;
					_tmp1056_ = arg;
					_tmp1057_ = cexpr;
					_tmp1058_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1055_, _tmp1056_, _tmp1057_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1058_;
				} else {
					ValaExpression* _tmp1059_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1060_;
					ValaDataType* _tmp1061_;
					ValaDataType* _tmp1062_;
					ValaParameter* _tmp1063_;
					ValaDataType* _tmp1064_;
					ValaDataType* _tmp1065_;
					gboolean _tmp1066_;
					gboolean _tmp1067_;
					ValaLocalVariable* _tmp1068_;
					ValaLocalVariable* _tmp1069_;
					ValaExpression* _tmp1070_;
					ValaLocalVariable* _tmp1071_;
					const gchar* _tmp1072_;
					const gchar* _tmp1073_;
					ValaCCodeExpression* _tmp1074_;
					ValaCCodeExpression* _tmp1075_;
					ValaExpression* _tmp1076_;
					ValaTargetValue* _tmp1077_;
					ValaTargetValue* _tmp1078_;
					ValaExpression* _tmp1079_;
					ValaDataType* _tmp1080_;
					ValaDataType* _tmp1081_;
					ValaExpression* _tmp1082_;
					ValaCCodeExpression* _tmp1083_;
					ValaCCodeUnaryExpression* _tmp1084_;
					gboolean _tmp1085_ = FALSE;
					gboolean _tmp1086_ = FALSE;
					ValaParameter* _tmp1087_;
					_tmp1059_ = arg;
					vala_expression_set_target_value (_tmp1059_, NULL);
					_tmp1060_ = param;
					_tmp1061_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1060_);
					_tmp1062_ = _tmp1061_;
					_tmp1063_ = param;
					_tmp1064_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1063_);
					_tmp1065_ = _tmp1064_;
					_tmp1066_ = vala_data_type_get_value_owned (_tmp1065_);
					_tmp1067_ = _tmp1066_;
					_tmp1068_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1062_, _tmp1067_, NULL, TRUE);
					temp_var = _tmp1068_;
					_tmp1069_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1069_, FALSE);
					_tmp1070_ = arg;
					_tmp1071_ = temp_var;
					_tmp1072_ = vala_symbol_get_name ((ValaSymbol*) _tmp1071_);
					_tmp1073_ = _tmp1072_;
					_tmp1074_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1073_);
					_tmp1075_ = _tmp1074_;
					vala_set_cvalue (_tmp1070_, _tmp1075_);
					_vala_ccode_node_unref0 (_tmp1075_);
					_tmp1076_ = arg;
					_tmp1077_ = vala_expression_get_target_value (_tmp1076_);
					_tmp1078_ = _tmp1077_;
					_tmp1079_ = arg;
					_tmp1080_ = vala_expression_get_target_type (_tmp1079_);
					_tmp1081_ = _tmp1080_;
					vala_target_value_set_value_type (_tmp1078_, _tmp1081_);
					_tmp1082_ = arg;
					_tmp1083_ = vala_get_cvalue (_tmp1082_);
					_tmp1084_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1083_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1084_;
					_tmp1087_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1087_)) {
						ValaParameter* _tmp1088_;
						ValaDataType* _tmp1089_;
						ValaDataType* _tmp1090_;
						_tmp1088_ = param;
						_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
						_tmp1090_ = _tmp1089_;
						_tmp1086_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1090_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1086_ = FALSE;
					}
					if (_tmp1086_) {
						ValaParameter* _tmp1091_;
						ValaDataType* _tmp1092_;
						ValaDataType* _tmp1093_;
						gboolean _tmp1094_;
						gboolean _tmp1095_;
						_tmp1091_ = param;
						_tmp1092_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1091_);
						_tmp1093_ = _tmp1092_;
						_tmp1094_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1093_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1095_ = _tmp1094_;
						_tmp1085_ = !_tmp1095_;
					} else {
						_tmp1085_ = FALSE;
					}
					if (_tmp1085_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1096_;
						ValaDataType* _tmp1097_;
						ValaDataType* _tmp1098_;
						ValaArrayType* _tmp1099_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1100_;
						gchar* _tmp1101_;
						_tmp1096_ = param;
						_tmp1097_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1096_);
						_tmp1098_ = _tmp1097_;
						_tmp1099_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1098_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1099_;
						_tmp1100_ = param;
						_tmp1101_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1100_);
						length_ctype = _tmp1101_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1102_ = FALSE;
								_tmp1102_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1104_;
									gint _tmp1105_;
									gint _tmp1106_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1107_;
									ValaCType* _tmp1108_;
									ValaCType* _tmp1109_;
									ValaLocalVariable* _tmp1110_;
									ValaLocalVariable* _tmp1111_;
									ValaLocalVariable* _tmp1112_;
									ValaExpression* _tmp1113_;
									ValaLocalVariable* _tmp1114_;
									const gchar* _tmp1115_;
									const gchar* _tmp1116_;
									ValaCCodeExpression* _tmp1117_;
									ValaCCodeExpression* _tmp1118_;
									ValaHashMap* _tmp1119_;
									ValaParameter* _tmp1120_;
									ValaExpression* _tmp1121_;
									ValaList* _tmp1122_;
									gpointer _tmp1123_;
									ValaCCodeExpression* _tmp1124_;
									ValaCCodeUnaryExpression* _tmp1125_;
									ValaCCodeUnaryExpression* _tmp1126_;
									if (!_tmp1102_) {
										gint _tmp1103_;
										_tmp1103_ = dim;
										dim = _tmp1103_ + 1;
									}
									_tmp1102_ = FALSE;
									_tmp1104_ = array_type;
									_tmp1105_ = vala_array_type_get_rank (_tmp1104_);
									_tmp1106_ = _tmp1105_;
									if (!(dim <= _tmp1106_)) {
										break;
									}
									_tmp1107_ = length_ctype;
									_tmp1108_ = vala_ctype_new (_tmp1107_, "0");
									_tmp1109_ = _tmp1108_;
									_tmp1110_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1109_, TRUE, NULL, TRUE);
									_tmp1111_ = _tmp1110_;
									_vala_code_node_unref0 (_tmp1109_);
									temp_array_length = _tmp1111_;
									_tmp1112_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1112_, FALSE);
									_tmp1113_ = arg;
									_tmp1114_ = temp_array_length;
									_tmp1115_ = vala_symbol_get_name ((ValaSymbol*) _tmp1114_);
									_tmp1116_ = _tmp1115_;
									_tmp1117_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1116_);
									_tmp1118_ = _tmp1117_;
									vala_append_array_length (_tmp1113_, _tmp1118_);
									_vala_ccode_node_unref0 (_tmp1118_);
									_tmp1119_ = carg_map;
									_tmp1120_ = param;
									_tmp1121_ = arg;
									_tmp1122_ = vala_get_array_lengths (_tmp1121_);
									_tmp1123_ = vala_list_get (_tmp1122_, dim - 1);
									_tmp1124_ = (ValaCCodeExpression*) _tmp1123_;
									_tmp1125_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1124_);
									_tmp1126_ = _tmp1125_;
									vala_map_set ((ValaMap*) _tmp1119_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1120_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1126_);
									_vala_ccode_node_unref0 (_tmp1126_);
									_vala_ccode_node_unref0 (_tmp1124_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1127_ = FALSE;
						ValaParameter* _tmp1128_;
						_tmp1128_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1128_)) {
							ValaParameter* _tmp1129_;
							ValaDataType* _tmp1130_;
							ValaDataType* _tmp1131_;
							_tmp1129_ = param;
							_tmp1130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1129_);
							_tmp1131_ = _tmp1130_;
							_tmp1127_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1131_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1127_ = FALSE;
						}
						if (_tmp1127_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1132_;
							ValaDataType* _tmp1133_;
							ValaDataType* _tmp1134_;
							ValaDelegateType* _tmp1135_;
							ValaDelegateType* _tmp1136_;
							ValaDelegate* _tmp1137_;
							ValaDelegate* _tmp1138_;
							gboolean _tmp1139_;
							gboolean _tmp1140_;
							_tmp1132_ = param;
							_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
							_tmp1134_ = _tmp1133_;
							_tmp1135_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1134_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1135_;
							_tmp1136_ = deleg_type;
							_tmp1137_ = vala_delegate_type_get_delegate_symbol (_tmp1136_);
							_tmp1138_ = _tmp1137_;
							_tmp1139_ = vala_delegate_get_has_target (_tmp1138_);
							_tmp1140_ = _tmp1139_;
							if (_tmp1140_) {
								ValaVoidType* _tmp1141_;
								ValaVoidType* _tmp1142_;
								ValaPointerType* _tmp1143_;
								ValaPointerType* _tmp1144_;
								ValaLocalVariable* _tmp1145_;
								ValaLocalVariable* _tmp1146_;
								ValaExpression* _tmp1147_;
								ValaLocalVariable* _tmp1148_;
								const gchar* _tmp1149_;
								const gchar* _tmp1150_;
								ValaCCodeExpression* _tmp1151_;
								ValaCCodeExpression* _tmp1152_;
								ValaHashMap* _tmp1153_;
								ValaParameter* _tmp1154_;
								ValaExpression* _tmp1155_;
								ValaCCodeExpression* _tmp1156_;
								ValaCCodeUnaryExpression* _tmp1157_;
								ValaCCodeUnaryExpression* _tmp1158_;
								ValaDelegateType* _tmp1159_;
								_tmp1141_ = vala_void_type_new (NULL);
								_tmp1142_ = _tmp1141_;
								_tmp1143_ = vala_pointer_type_new ((ValaDataType*) _tmp1142_, NULL);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1144_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1145_;
								_vala_code_node_unref0 (_tmp1144_);
								_vala_code_node_unref0 (_tmp1142_);
								_tmp1146_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1146_, FALSE);
								_tmp1147_ = arg;
								_tmp1148_ = temp_var;
								_tmp1149_ = vala_symbol_get_name ((ValaSymbol*) _tmp1148_);
								_tmp1150_ = _tmp1149_;
								_tmp1151_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1150_);
								_tmp1152_ = _tmp1151_;
								vala_set_delegate_target (_tmp1147_, _tmp1152_);
								_vala_ccode_node_unref0 (_tmp1152_);
								_tmp1153_ = carg_map;
								_tmp1154_ = param;
								_tmp1155_ = arg;
								_tmp1156_ = vala_get_delegate_target (_tmp1155_);
								_tmp1157_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1156_);
								_tmp1158_ = _tmp1157_;
								vala_map_set ((ValaMap*) _tmp1153_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1154_), FALSE)), (ValaCCodeExpression*) _tmp1158_);
								_vala_ccode_node_unref0 (_tmp1158_);
								_tmp1159_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1159_)) {
									ValaDataType* _tmp1160_;
									ValaLocalVariable* _tmp1161_;
									ValaLocalVariable* _tmp1162_;
									ValaExpression* _tmp1163_;
									ValaLocalVariable* _tmp1164_;
									const gchar* _tmp1165_;
									const gchar* _tmp1166_;
									ValaCCodeExpression* _tmp1167_;
									ValaCCodeExpression* _tmp1168_;
									ValaHashMap* _tmp1169_;
									ValaParameter* _tmp1170_;
									ValaExpression* _tmp1171_;
									ValaCCodeExpression* _tmp1172_;
									ValaCCodeUnaryExpression* _tmp1173_;
									ValaCCodeUnaryExpression* _tmp1174_;
									_tmp1160_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1161_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1160_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1161_;
									_tmp1162_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1162_, FALSE);
									_tmp1163_ = arg;
									_tmp1164_ = temp_var;
									_tmp1165_ = vala_symbol_get_name ((ValaSymbol*) _tmp1164_);
									_tmp1166_ = _tmp1165_;
									_tmp1167_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1166_);
									_tmp1168_ = _tmp1167_;
									vala_set_delegate_target_destroy_notify (_tmp1163_, _tmp1168_);
									_vala_ccode_node_unref0 (_tmp1168_);
									_tmp1169_ = carg_map;
									_tmp1170_ = param;
									_tmp1171_ = arg;
									_tmp1172_ = vala_get_delegate_target_destroy_notify (_tmp1171_);
									_tmp1173_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1172_);
									_tmp1174_ = _tmp1173_;
									vala_map_set ((ValaMap*) _tmp1169_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1170_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1174_);
									_vala_ccode_node_unref0 (_tmp1174_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1175_ = param;
				_tmp1176_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1175_);
				_tmp1177_ = _tmp1176_;
				_tmp1178_ = _tmp1177_ != NULL;
				_g_free0 (_tmp1177_);
				if (_tmp1178_) {
					ValaCCodeExpression* _tmp1179_;
					ValaParameter* _tmp1180_;
					gchar* _tmp1181_;
					gchar* _tmp1182_;
					ValaCCodeCastExpression* _tmp1183_;
					_tmp1179_ = cexpr;
					_tmp1180_ = param;
					_tmp1181_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1180_);
					_tmp1182_ = _tmp1181_;
					_tmp1183_ = vala_ccode_cast_expression_new (_tmp1179_, _tmp1182_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1183_;
					_g_free0 (_tmp1182_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1184_;
				ValaUnaryExpression* _tmp1185_;
				gboolean _tmp1186_ = FALSE;
				gboolean _tmp1187_ = FALSE;
				_tmp1184_ = arg;
				_tmp1185_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1184_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1184_) : NULL);
				unary = _tmp1185_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1188_;
					_tmp1188_ = unary;
					_tmp1187_ = _tmp1188_ != NULL;
				} else {
					_tmp1187_ = FALSE;
				}
				if (_tmp1187_) {
					ValaUnaryExpression* _tmp1189_;
					ValaUnaryOperator _tmp1190_;
					ValaUnaryOperator _tmp1191_;
					_tmp1189_ = unary;
					_tmp1190_ = vala_unary_expression_get_operator (_tmp1189_);
					_tmp1191_ = _tmp1190_;
					_tmp1186_ = _tmp1191_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1186_ = FALSE;
				}
				if (_tmp1186_) {
					ValaHashMap* _tmp1192_;
					ValaHashMap* _tmp1193_;
					ValaExpression* _tmp1194_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1195_;
					ValaDataType* _tmp1196_;
					ValaDataType* _tmp1197_;
					ValaExpression* _tmp1198_;
					ValaDataType* _tmp1199_;
					ValaDataType* _tmp1200_;
					gboolean _tmp1201_;
					gboolean _tmp1202_;
					ValaLocalVariable* _tmp1203_;
					ValaLocalVariable* _tmp1204_;
					ValaExpression* _tmp1205_;
					ValaLocalVariable* _tmp1206_;
					const gchar* _tmp1207_;
					const gchar* _tmp1208_;
					ValaCCodeExpression* _tmp1209_;
					ValaCCodeExpression* _tmp1210_;
					ValaExpression* _tmp1211_;
					ValaTargetValue* _tmp1212_;
					ValaTargetValue* _tmp1213_;
					ValaExpression* _tmp1214_;
					ValaDataType* _tmp1215_;
					ValaDataType* _tmp1216_;
					gboolean _tmp1217_ = FALSE;
					ValaExpression* _tmp1218_;
					ValaDataType* _tmp1219_;
					ValaDataType* _tmp1220_;
					ValaExpression* _tmp1239_;
					ValaCCodeExpression* _tmp1240_;
					ValaCCodeUnaryExpression* _tmp1241_;
					_tmp1192_ = out_arg_map;
					_tmp1193_ = _vala_map_ref0 (_tmp1192_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1193_;
					_tmp1194_ = arg;
					vala_expression_set_target_value (_tmp1194_, NULL);
					_tmp1195_ = arg;
					_tmp1196_ = vala_expression_get_value_type (_tmp1195_);
					_tmp1197_ = _tmp1196_;
					_tmp1198_ = arg;
					_tmp1199_ = vala_expression_get_value_type (_tmp1198_);
					_tmp1200_ = _tmp1199_;
					_tmp1201_ = vala_data_type_get_value_owned (_tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1197_, _tmp1202_, NULL, TRUE);
					temp_var = _tmp1203_;
					_tmp1204_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1204_, FALSE);
					_tmp1205_ = arg;
					_tmp1206_ = temp_var;
					_tmp1207_ = vala_symbol_get_name ((ValaSymbol*) _tmp1206_);
					_tmp1208_ = _tmp1207_;
					_tmp1209_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1208_);
					_tmp1210_ = _tmp1209_;
					vala_set_cvalue (_tmp1205_, _tmp1210_);
					_vala_ccode_node_unref0 (_tmp1210_);
					_tmp1211_ = arg;
					_tmp1212_ = vala_expression_get_target_value (_tmp1211_);
					_tmp1213_ = _tmp1212_;
					_tmp1214_ = arg;
					_tmp1215_ = vala_expression_get_value_type (_tmp1214_);
					_tmp1216_ = _tmp1215_;
					vala_target_value_set_value_type (_tmp1213_, _tmp1216_);
					_tmp1218_ = arg;
					_tmp1219_ = vala_expression_get_value_type (_tmp1218_);
					_tmp1220_ = _tmp1219_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1220_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1221_;
						ValaDataType* _tmp1222_;
						ValaDataType* _tmp1223_;
						ValaDelegate* _tmp1224_;
						ValaDelegate* _tmp1225_;
						gboolean _tmp1226_;
						gboolean _tmp1227_;
						_tmp1221_ = arg;
						_tmp1222_ = vala_expression_get_value_type (_tmp1221_);
						_tmp1223_ = _tmp1222_;
						_tmp1224_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1223_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1225_ = _tmp1224_;
						_tmp1226_ = vala_delegate_get_has_target (_tmp1225_);
						_tmp1227_ = _tmp1226_;
						_tmp1217_ = _tmp1227_;
					} else {
						_tmp1217_ = FALSE;
					}
					if (_tmp1217_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1228_;
						ValaTargetValue* _tmp1229_;
						ValaTargetValue* _tmp1230_;
						ValaGLibValue* _tmp1231_;
						ValaCCodeExpression* _tmp1232_;
						ValaGLibValue* _tmp1235_;
						ValaCCodeExpression* _tmp1236_;
						_tmp1228_ = arg;
						_tmp1229_ = vala_expression_get_target_value (_tmp1228_);
						_tmp1230_ = _tmp1229_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1230_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1231_ = arg_value;
						_tmp1232_ = _tmp1231_->delegate_target_cvalue;
						if (_tmp1232_ == NULL) {
							ValaGLibValue* _tmp1233_;
							ValaCCodeConstant* _tmp1234_;
							_tmp1233_ = arg_value;
							_tmp1234_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1233_->delegate_target_cvalue);
							_tmp1233_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1234_;
						}
						_tmp1235_ = arg_value;
						_tmp1236_ = _tmp1235_->delegate_target_destroy_notify_cvalue;
						if (_tmp1236_ == NULL) {
							ValaGLibValue* _tmp1237_;
							ValaCCodeConstant* _tmp1238_;
							_tmp1237_ = arg_value;
							_tmp1238_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1237_->delegate_target_destroy_notify_cvalue);
							_tmp1237_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1238_;
						}
					}
					_tmp1239_ = arg;
					_tmp1240_ = vala_get_cvalue (_tmp1239_);
					_tmp1241_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1240_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1241_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1242_;
					ValaCCodeExpression* _tmp1243_;
					ValaCCodeExpression* _tmp1244_;
					_tmp1242_ = arg;
					_tmp1243_ = cexpr;
					_tmp1244_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1242_, _tmp1243_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1244_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1247_ = param;
			if (_tmp1247_ != NULL) {
				_tmp1246_ = !ellipsis;
			} else {
				_tmp1246_ = FALSE;
			}
			if (_tmp1246_) {
				ValaParameter* _tmp1248_;
				_tmp1248_ = param;
				_tmp1245_ = vala_get_ccode_pos (_tmp1248_);
			} else {
				_tmp1245_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1245_, ellipsis);
			_tmp1249_ = carg_map;
			_tmp1250_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1249_, (gpointer) ((gintptr) arg_pos), _tmp1250_);
			_tmp1252_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1252_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1253_;
				ValaCodeContext* _tmp1254_;
				ValaProfile _tmp1255_;
				ValaProfile _tmp1256_;
				_tmp1253_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1254_ = _tmp1253_;
				_tmp1255_ = vala_code_context_get_profile (_tmp1254_);
				_tmp1256_ = _tmp1255_;
				_tmp1251_ = _tmp1256_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1251_ = FALSE;
			}
			if (_tmp1251_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1257_;
				ValaExpression* _tmp1258_;
				ValaExpression* _tmp1259_;
				ValaDataType* _tmp1260_;
				ValaDataType* _tmp1261_;
				ValaDataType* _tmp1262_;
				ValaDataType* _tmp1263_;
				gchar* _tmp1264_;
				gchar* _tmp1265_;
				gchar* _tmp1266_;
				gchar* _tmp1267_;
				ValaCCodeIdentifier* _tmp1268_;
				ValaCCodeIdentifier* _tmp1269_;
				ValaHashMap* _tmp1270_;
				ValaCCodeIdentifier* _tmp1271_;
				ValaCCodeExpression* _tmp1272_;
				ValaCCodeBinaryExpression* _tmp1273_;
				ValaCCodeBinaryExpression* _tmp1274_;
				_tmp1257_ = ma;
				_tmp1258_ = vala_member_access_get_inner (_tmp1257_);
				_tmp1259_ = _tmp1258_;
				_tmp1260_ = vala_expression_get_value_type (_tmp1259_);
				_tmp1261_ = _tmp1260_;
				_tmp1262_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1261_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1263_ = _tmp1262_;
				_tmp1264_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1263_);
				_tmp1265_ = _tmp1264_;
				_tmp1266_ = g_strdup_printf ("sizeof (%s)", _tmp1265_);
				_tmp1267_ = _tmp1266_;
				_tmp1268_ = vala_ccode_identifier_new (_tmp1267_);
				_tmp1269_ = _tmp1268_;
				_g_free0 (_tmp1267_);
				_g_free0 (_tmp1265_);
				csizeof = _tmp1269_;
				_tmp1270_ = carg_map;
				_tmp1271_ = csizeof;
				_tmp1272_ = cexpr;
				_tmp1273_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1271_, _tmp1272_);
				_tmp1274_ = _tmp1273_;
				vala_map_set ((ValaMap*) _tmp1270_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1274_);
				_vala_ccode_node_unref0 (_tmp1274_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1275_;
				ValaCCodeExpression* _tmp1276_;
				_tmp1275_ = carg_map;
				_tmp1276_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1275_, (gpointer) ((gintptr) arg_pos), _tmp1276_);
			}
			_tmp1278_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1278_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1277_ = ellipsis;
			} else {
				_tmp1277_ = FALSE;
			}
			if (_tmp1277_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1279_;
				ValaNamedArgument* _tmp1280_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1281_;
				const gchar* _tmp1282_;
				const gchar* _tmp1283_;
				gchar** _tmp1284_;
				gchar** _tmp1285_;
				gchar** _tmp1286_;
				gint _tmp1286__length1;
				gchar* _tmp1287_;
				gchar* _tmp1288_;
				ValaHashMap* _tmp1289_;
				const gchar* _tmp1290_;
				gchar* _tmp1291_;
				gchar* _tmp1292_;
				ValaCCodeConstant* _tmp1293_;
				ValaCCodeConstant* _tmp1294_;
				_tmp1279_ = arg;
				_tmp1280_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1279_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1280_;
				_tmp1281_ = named_arg;
				_tmp1282_ = vala_named_argument_get_name (_tmp1281_);
				_tmp1283_ = _tmp1282_;
				_tmp1285_ = _tmp1284_ = g_strsplit (_tmp1283_, "_", 0);
				_tmp1286_ = _tmp1285_;
				_tmp1286__length1 = _vala_array_length (_tmp1284_);
				_tmp1287_ = _vala_g_strjoinv ("-", _tmp1286_, (gint) _vala_array_length (_tmp1284_));
				_tmp1288_ = _tmp1287_;
				_tmp1286_ = (_vala_array_free (_tmp1286_, _tmp1286__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1288_;
				_tmp1289_ = carg_map;
				_tmp1290_ = name;
				_tmp1291_ = g_strdup_printf ("\"%s\"", _tmp1290_);
				_tmp1292_ = _tmp1291_;
				_tmp1293_ = vala_ccode_constant_new (_tmp1292_);
				_tmp1294_ = _tmp1293_;
				vala_map_set ((ValaMap*) _tmp1289_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1294_);
				_vala_ccode_node_unref0 (_tmp1294_);
				_g_free0 (_tmp1292_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1295_ = i;
			i = _tmp1295_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1296_ = params_it;
	if (vala_iterator_next (_tmp1296_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1297_;
		gpointer _tmp1298_;
		gboolean _tmp1299_ = FALSE;
		ValaParameter* _tmp1300_;
		gboolean _tmp1301_;
		gboolean _tmp1302_;
		_tmp1297_ = params_it;
		_tmp1298_ = vala_iterator_get (_tmp1297_);
		param = (ValaParameter*) _tmp1298_;
		_tmp1300_ = param;
		_tmp1301_ = vala_parameter_get_params_array (_tmp1300_);
		_tmp1302_ = _tmp1301_;
		if (_tmp1302_) {
			_tmp1299_ = TRUE;
		} else {
			ValaParameter* _tmp1303_;
			gboolean _tmp1304_;
			gboolean _tmp1305_;
			_tmp1303_ = param;
			_tmp1304_ = vala_parameter_get_ellipsis (_tmp1303_);
			_tmp1305_ = _tmp1304_;
			_tmp1299_ = _tmp1305_;
		}
		_vala_assert (_tmp1299_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1308_ = m;
	if (_tmp1308_ != NULL) {
		ValaMethod* _tmp1309_;
		ValaDataType* _tmp1310_;
		ValaDataType* _tmp1311_;
		_tmp1309_ = m;
		_tmp1310_ = vala_callable_get_return_type ((ValaCallable*) _tmp1309_);
		_tmp1311_ = _tmp1310_;
		_tmp1307_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1311_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1307_ = FALSE;
	}
	if (_tmp1307_) {
		ValaCCodeFunctionCall* _tmp1312_;
		ValaCCodeFunctionCall* _tmp1313_;
		_tmp1312_ = async_call;
		_tmp1313_ = ccall;
		_tmp1306_ = _tmp1312_ != _tmp1313_;
	} else {
		_tmp1306_ = FALSE;
	}
	if (_tmp1306_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1314_;
		ValaDataType* _tmp1315_;
		ValaDataType* _tmp1316_;
		ValaArrayType* _tmp1317_;
		_tmp1314_ = m;
		_tmp1315_ = vala_callable_get_return_type ((ValaCallable*) _tmp1314_);
		_tmp1316_ = _tmp1315_;
		_tmp1317_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1316_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1317_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1318_ = FALSE;
				_tmp1318_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1320_;
					gint _tmp1321_;
					gint _tmp1322_;
					ValaMethod* _tmp1323_;
					if (!_tmp1318_) {
						gint _tmp1319_;
						_tmp1319_ = dim;
						dim = _tmp1319_ + 1;
					}
					_tmp1318_ = FALSE;
					_tmp1320_ = array_type;
					_tmp1321_ = vala_array_type_get_rank (_tmp1320_);
					_tmp1322_ = _tmp1321_;
					if (!(dim <= _tmp1322_)) {
						break;
					}
					_tmp1323_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1323_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1324_;
						ValaDataType* _tmp1325_;
						ValaLocalVariable* _tmp1326_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1327_;
						const gchar* _tmp1328_;
						const gchar* _tmp1329_;
						ValaCCodeExpression* _tmp1330_;
						ValaLocalVariable* _tmp1331_;
						ValaCCodeExpression* _tmp1332_;
						ValaCCodeExpression* _tmp1333_;
						ValaCCodeAssignment* _tmp1334_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1335_;
						ValaCCodeIdentifier* _tmp1336_;
						ValaCCodeFunctionCall* _tmp1337_;
						ValaCCodeFunctionCall* _tmp1338_;
						ValaCCodeFunctionCall* _tmp1339_;
						ValaCCodeExpression* _tmp1340_;
						ValaCCodeFunctionCall* _tmp1341_;
						_tmp1324_ = itype;
						_tmp1325_ = vala_data_type_get_return_type (_tmp1324_);
						_tmp1326_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1325_, TRUE, NULL, FALSE);
						temp_var = _tmp1326_;
						_tmp1327_ = temp_var;
						_tmp1328_ = vala_symbol_get_name ((ValaSymbol*) _tmp1327_);
						_tmp1329_ = _tmp1328_;
						_tmp1330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1329_);
						temp_ref = _tmp1330_;
						_tmp1331_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1331_, FALSE);
						_tmp1332_ = temp_ref;
						_tmp1333_ = ccall_expr;
						_tmp1334_ = vala_ccode_assignment_new (_tmp1332_, _tmp1333_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1334_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1335_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1336_ = _tmp1335_;
						_tmp1337_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1336_);
						_tmp1338_ = _tmp1337_;
						_vala_ccode_node_unref0 (_tmp1336_);
						len_call = _tmp1338_;
						_tmp1339_ = len_call;
						_tmp1340_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1339_, _tmp1340_);
						_tmp1341_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1341_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1342_;
						_tmp1342_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1342_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1343_;
							gchar* _tmp1344_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1345_;
							ValaCType* _tmp1346_;
							ValaCType* _tmp1347_;
							ValaLocalVariable* _tmp1348_;
							ValaLocalVariable* _tmp1349_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1350_;
							const gchar* _tmp1351_;
							const gchar* _tmp1352_;
							ValaCCodeExpression* _tmp1353_;
							ValaLocalVariable* _tmp1354_;
							ValaHashMap* _tmp1355_;
							ValaMethod* _tmp1356_;
							ValaCCodeExpression* _tmp1357_;
							ValaCCodeUnaryExpression* _tmp1358_;
							ValaCCodeUnaryExpression* _tmp1359_;
							ValaCCodeExpression* _tmp1360_;
							_tmp1343_ = m;
							_tmp1344_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1343_);
							length_ctype = _tmp1344_;
							_tmp1345_ = length_ctype;
							_tmp1346_ = vala_ctype_new (_tmp1345_, "0");
							_tmp1347_ = _tmp1346_;
							_tmp1348_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1347_, TRUE, NULL, TRUE);
							_tmp1349_ = _tmp1348_;
							_vala_code_node_unref0 (_tmp1347_);
							temp_var = _tmp1349_;
							_tmp1350_ = temp_var;
							_tmp1351_ = vala_symbol_get_name ((ValaSymbol*) _tmp1350_);
							_tmp1352_ = _tmp1351_;
							_tmp1353_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1352_);
							temp_ref = _tmp1353_;
							_tmp1354_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1354_, FALSE);
							_tmp1355_ = out_arg_map;
							_tmp1356_ = m;
							_tmp1357_ = temp_ref;
							_tmp1358_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1357_);
							_tmp1359_ = _tmp1358_;
							vala_map_set ((ValaMap*) _tmp1355_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1356_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1359_);
							_vala_ccode_node_unref0 (_tmp1359_);
							_tmp1360_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1360_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1361_;
							gchar* _tmp1362_;
							gchar* _tmp1363_;
							gboolean _tmp1364_;
							_tmp1361_ = m;
							_tmp1362_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1361_);
							_tmp1363_ = _tmp1362_;
							_tmp1364_ = _tmp1363_ != NULL;
							_g_free0 (_tmp1363_);
							if (_tmp1364_) {
								ValaMethod* _tmp1365_;
								gchar* _tmp1366_;
								gchar* _tmp1367_;
								ValaCCodeConstant* _tmp1368_;
								ValaCCodeConstant* _tmp1369_;
								_tmp1365_ = m;
								_tmp1366_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1365_);
								_tmp1367_ = _tmp1366_;
								_tmp1368_ = vala_ccode_constant_new (_tmp1367_);
								_tmp1369_ = _tmp1368_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1369_);
								_vala_ccode_node_unref0 (_tmp1369_);
								_g_free0 (_tmp1367_);
							} else {
								ValaCCodeConstant* _tmp1370_;
								ValaCCodeConstant* _tmp1371_;
								_tmp1370_ = vala_ccode_constant_new ("-1");
								_tmp1371_ = _tmp1370_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1371_);
								_vala_ccode_node_unref0 (_tmp1371_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1372_ = FALSE;
		gboolean _tmp1373_ = FALSE;
		ValaMethod* _tmp1374_;
		_tmp1374_ = m;
		if (_tmp1374_ != NULL) {
			ValaMethod* _tmp1375_;
			ValaDataType* _tmp1376_;
			ValaDataType* _tmp1377_;
			_tmp1375_ = m;
			_tmp1376_ = vala_callable_get_return_type ((ValaCallable*) _tmp1375_);
			_tmp1377_ = _tmp1376_;
			_tmp1373_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1377_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1373_ = FALSE;
		}
		if (_tmp1373_) {
			ValaCCodeFunctionCall* _tmp1378_;
			ValaCCodeFunctionCall* _tmp1379_;
			_tmp1378_ = async_call;
			_tmp1379_ = ccall;
			_tmp1372_ = _tmp1378_ != _tmp1379_;
		} else {
			_tmp1372_ = FALSE;
		}
		if (_tmp1372_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1380_;
			ValaDataType* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDelegateType* _tmp1383_;
			gboolean _tmp1384_ = FALSE;
			ValaMethod* _tmp1385_;
			_tmp1380_ = m;
			_tmp1381_ = vala_callable_get_return_type ((ValaCallable*) _tmp1380_);
			_tmp1382_ = _tmp1381_;
			_tmp1383_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1382_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1383_;
			_tmp1385_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1385_)) {
				ValaDelegateType* _tmp1386_;
				ValaDelegate* _tmp1387_;
				ValaDelegate* _tmp1388_;
				gboolean _tmp1389_;
				gboolean _tmp1390_;
				_tmp1386_ = deleg_type;
				_tmp1387_ = vala_delegate_type_get_delegate_symbol (_tmp1386_);
				_tmp1388_ = _tmp1387_;
				_tmp1389_ = vala_delegate_get_has_target (_tmp1388_);
				_tmp1390_ = _tmp1389_;
				_tmp1384_ = _tmp1390_;
			} else {
				_tmp1384_ = FALSE;
			}
			if (_tmp1384_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1391_;
				ValaVoidType* _tmp1392_;
				ValaPointerType* _tmp1393_;
				ValaPointerType* _tmp1394_;
				ValaLocalVariable* _tmp1395_;
				ValaLocalVariable* _tmp1396_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1397_;
				const gchar* _tmp1398_;
				const gchar* _tmp1399_;
				ValaCCodeExpression* _tmp1400_;
				ValaLocalVariable* _tmp1401_;
				ValaHashMap* _tmp1402_;
				ValaMethod* _tmp1403_;
				ValaCCodeExpression* _tmp1404_;
				ValaCCodeUnaryExpression* _tmp1405_;
				ValaCCodeUnaryExpression* _tmp1406_;
				ValaCCodeExpression* _tmp1407_;
				ValaDelegateType* _tmp1408_;
				_tmp1391_ = vala_void_type_new (NULL);
				_tmp1392_ = _tmp1391_;
				_tmp1393_ = vala_pointer_type_new ((ValaDataType*) _tmp1392_, NULL);
				_tmp1394_ = _tmp1393_;
				_tmp1395_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1394_, TRUE, NULL, TRUE);
				_tmp1396_ = _tmp1395_;
				_vala_code_node_unref0 (_tmp1394_);
				_vala_code_node_unref0 (_tmp1392_);
				temp_var = _tmp1396_;
				_tmp1397_ = temp_var;
				_tmp1398_ = vala_symbol_get_name ((ValaSymbol*) _tmp1397_);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1399_);
				temp_ref = _tmp1400_;
				_tmp1401_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1401_, FALSE);
				_tmp1402_ = out_arg_map;
				_tmp1403_ = m;
				_tmp1404_ = temp_ref;
				_tmp1405_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1404_);
				_tmp1406_ = _tmp1405_;
				vala_map_set ((ValaMap*) _tmp1402_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1403_), FALSE)), (ValaCCodeExpression*) _tmp1406_);
				_vala_ccode_node_unref0 (_tmp1406_);
				_tmp1407_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1407_);
				_tmp1408_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1408_)) {
					ValaDataType* _tmp1409_;
					ValaLocalVariable* _tmp1410_;
					ValaLocalVariable* _tmp1411_;
					const gchar* _tmp1412_;
					const gchar* _tmp1413_;
					ValaCCodeExpression* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					ValaHashMap* _tmp1416_;
					ValaMethod* _tmp1417_;
					ValaCCodeExpression* _tmp1418_;
					ValaCCodeUnaryExpression* _tmp1419_;
					ValaCCodeUnaryExpression* _tmp1420_;
					ValaCCodeExpression* _tmp1421_;
					_tmp1409_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1410_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1409_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1410_;
					_tmp1411_ = temp_var;
					_tmp1412_ = vala_symbol_get_name ((ValaSymbol*) _tmp1411_);
					_tmp1413_ = _tmp1412_;
					_tmp1414_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1413_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1414_;
					_tmp1415_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1415_, FALSE);
					_tmp1416_ = out_arg_map;
					_tmp1417_ = m;
					_tmp1418_ = temp_ref;
					_tmp1419_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1418_);
					_tmp1420_ = _tmp1419_;
					vala_map_set ((ValaMap*) _tmp1416_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1417_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1420_);
					_vala_ccode_node_unref0 (_tmp1420_);
					_tmp1421_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1421_);
				} else {
					ValaCCodeConstant* _tmp1422_;
					ValaCCodeConstant* _tmp1423_;
					_tmp1422_ = vala_ccode_constant_new ("NULL");
					_tmp1423_ = _tmp1422_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1423_);
					_vala_ccode_node_unref0 (_tmp1423_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1424_;
				ValaCCodeConstant* _tmp1425_;
				ValaDelegateType* _tmp1426_;
				ValaDelegate* _tmp1427_;
				ValaDelegate* _tmp1428_;
				gboolean _tmp1429_;
				gboolean _tmp1430_;
				_tmp1424_ = vala_ccode_constant_new ("NULL");
				_tmp1425_ = _tmp1424_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1425_);
				_vala_ccode_node_unref0 (_tmp1425_);
				_tmp1426_ = deleg_type;
				_tmp1427_ = vala_delegate_type_get_delegate_symbol (_tmp1426_);
				_tmp1428_ = _tmp1427_;
				_tmp1429_ = vala_delegate_get_has_target (_tmp1428_);
				_tmp1430_ = _tmp1429_;
				if (_tmp1430_) {
					ValaCCodeConstant* _tmp1431_;
					ValaCCodeConstant* _tmp1432_;
					_tmp1431_ = vala_ccode_constant_new ("NULL");
					_tmp1432_ = _tmp1431_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1432_);
					_vala_ccode_node_unref0 (_tmp1432_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1434_ = deleg;
	if (_tmp1434_ != NULL) {
		ValaDelegate* _tmp1435_;
		ValaDataType* _tmp1436_;
		ValaDataType* _tmp1437_;
		_tmp1435_ = deleg;
		_tmp1436_ = vala_callable_get_return_type ((ValaCallable*) _tmp1435_);
		_tmp1437_ = _tmp1436_;
		_tmp1433_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1437_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1433_ = FALSE;
	}
	if (_tmp1433_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1438_;
		ValaDataType* _tmp1439_;
		ValaDataType* _tmp1440_;
		ValaArrayType* _tmp1441_;
		_tmp1438_ = deleg;
		_tmp1439_ = vala_callable_get_return_type ((ValaCallable*) _tmp1438_);
		_tmp1440_ = _tmp1439_;
		_tmp1441_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1440_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1441_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1442_ = FALSE;
				_tmp1442_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1444_;
					gint _tmp1445_;
					gint _tmp1446_;
					ValaDelegate* _tmp1447_;
					if (!_tmp1442_) {
						gint _tmp1443_;
						_tmp1443_ = dim;
						dim = _tmp1443_ + 1;
					}
					_tmp1442_ = FALSE;
					_tmp1444_ = array_type;
					_tmp1445_ = vala_array_type_get_rank (_tmp1444_);
					_tmp1446_ = _tmp1445_;
					if (!(dim <= _tmp1446_)) {
						break;
					}
					_tmp1447_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1447_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1448_;
						ValaDataType* _tmp1449_;
						ValaLocalVariable* _tmp1450_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1451_;
						const gchar* _tmp1452_;
						const gchar* _tmp1453_;
						ValaCCodeExpression* _tmp1454_;
						ValaLocalVariable* _tmp1455_;
						ValaCCodeExpression* _tmp1456_;
						ValaCCodeExpression* _tmp1457_;
						ValaCCodeAssignment* _tmp1458_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1459_;
						ValaCCodeIdentifier* _tmp1460_;
						ValaCCodeFunctionCall* _tmp1461_;
						ValaCCodeFunctionCall* _tmp1462_;
						ValaCCodeFunctionCall* _tmp1463_;
						ValaCCodeExpression* _tmp1464_;
						ValaCCodeFunctionCall* _tmp1465_;
						_tmp1448_ = itype;
						_tmp1449_ = vala_data_type_get_return_type (_tmp1448_);
						_tmp1450_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1449_, TRUE, NULL, FALSE);
						temp_var = _tmp1450_;
						_tmp1451_ = temp_var;
						_tmp1452_ = vala_symbol_get_name ((ValaSymbol*) _tmp1451_);
						_tmp1453_ = _tmp1452_;
						_tmp1454_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1453_);
						temp_ref = _tmp1454_;
						_tmp1455_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1455_, FALSE);
						_tmp1456_ = temp_ref;
						_tmp1457_ = ccall_expr;
						_tmp1458_ = vala_ccode_assignment_new (_tmp1456_, _tmp1457_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1458_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1459_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1460_ = _tmp1459_;
						_tmp1461_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1460_);
						_tmp1462_ = _tmp1461_;
						_vala_ccode_node_unref0 (_tmp1460_);
						len_call = _tmp1462_;
						_tmp1463_ = len_call;
						_tmp1464_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1463_, _tmp1464_);
						_tmp1465_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1465_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1466_;
						_tmp1466_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1466_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1467_;
							gchar* _tmp1468_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1469_;
							ValaCType* _tmp1470_;
							ValaCType* _tmp1471_;
							ValaLocalVariable* _tmp1472_;
							ValaLocalVariable* _tmp1473_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1474_;
							const gchar* _tmp1475_;
							const gchar* _tmp1476_;
							ValaCCodeExpression* _tmp1477_;
							ValaLocalVariable* _tmp1478_;
							ValaHashMap* _tmp1479_;
							ValaDelegate* _tmp1480_;
							ValaCCodeExpression* _tmp1481_;
							ValaCCodeUnaryExpression* _tmp1482_;
							ValaCCodeUnaryExpression* _tmp1483_;
							ValaCCodeExpression* _tmp1484_;
							_tmp1467_ = deleg;
							_tmp1468_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1467_);
							length_ctype = _tmp1468_;
							_tmp1469_ = length_ctype;
							_tmp1470_ = vala_ctype_new (_tmp1469_, "0");
							_tmp1471_ = _tmp1470_;
							_tmp1472_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1471_, TRUE, NULL, TRUE);
							_tmp1473_ = _tmp1472_;
							_vala_code_node_unref0 (_tmp1471_);
							temp_var = _tmp1473_;
							_tmp1474_ = temp_var;
							_tmp1475_ = vala_symbol_get_name ((ValaSymbol*) _tmp1474_);
							_tmp1476_ = _tmp1475_;
							_tmp1477_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1476_);
							temp_ref = _tmp1477_;
							_tmp1478_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1478_, FALSE);
							_tmp1479_ = out_arg_map;
							_tmp1480_ = deleg;
							_tmp1481_ = temp_ref;
							_tmp1482_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1481_);
							_tmp1483_ = _tmp1482_;
							vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1480_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1483_);
							_vala_ccode_node_unref0 (_tmp1483_);
							_tmp1484_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1484_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1485_;
							ValaCCodeConstant* _tmp1486_;
							_tmp1485_ = vala_ccode_constant_new ("-1");
							_tmp1486_ = _tmp1485_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1486_);
							_vala_ccode_node_unref0 (_tmp1486_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1487_ = FALSE;
		gboolean _tmp1488_ = FALSE;
		ValaDelegate* _tmp1489_;
		_tmp1489_ = deleg;
		if (_tmp1489_ != NULL) {
			ValaDelegate* _tmp1490_;
			ValaDataType* _tmp1491_;
			ValaDataType* _tmp1492_;
			_tmp1490_ = deleg;
			_tmp1491_ = vala_callable_get_return_type ((ValaCallable*) _tmp1490_);
			_tmp1492_ = _tmp1491_;
			_tmp1488_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1492_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1488_ = FALSE;
		}
		if (_tmp1488_) {
			ValaDelegate* _tmp1493_;
			_tmp1493_ = deleg;
			_tmp1487_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1493_);
		} else {
			_tmp1487_ = FALSE;
		}
		if (_tmp1487_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1494_;
			ValaDataType* _tmp1495_;
			ValaDataType* _tmp1496_;
			ValaDelegateType* _tmp1497_;
			ValaDelegateType* _tmp1498_;
			ValaDelegate* _tmp1499_;
			ValaDelegate* _tmp1500_;
			gboolean _tmp1501_;
			gboolean _tmp1502_;
			_tmp1494_ = deleg;
			_tmp1495_ = vala_callable_get_return_type ((ValaCallable*) _tmp1494_);
			_tmp1496_ = _tmp1495_;
			_tmp1497_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1496_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1497_;
			_tmp1498_ = deleg_type;
			_tmp1499_ = vala_delegate_type_get_delegate_symbol (_tmp1498_);
			_tmp1500_ = _tmp1499_;
			_tmp1501_ = vala_delegate_get_has_target (_tmp1500_);
			_tmp1502_ = _tmp1501_;
			if (_tmp1502_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1503_;
				ValaVoidType* _tmp1504_;
				ValaPointerType* _tmp1505_;
				ValaPointerType* _tmp1506_;
				ValaLocalVariable* _tmp1507_;
				ValaLocalVariable* _tmp1508_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1509_;
				const gchar* _tmp1510_;
				const gchar* _tmp1511_;
				ValaCCodeExpression* _tmp1512_;
				ValaLocalVariable* _tmp1513_;
				ValaHashMap* _tmp1514_;
				ValaDelegate* _tmp1515_;
				ValaCCodeExpression* _tmp1516_;
				ValaCCodeUnaryExpression* _tmp1517_;
				ValaCCodeUnaryExpression* _tmp1518_;
				ValaCCodeExpression* _tmp1519_;
				ValaDelegateType* _tmp1520_;
				_tmp1503_ = vala_void_type_new (NULL);
				_tmp1504_ = _tmp1503_;
				_tmp1505_ = vala_pointer_type_new ((ValaDataType*) _tmp1504_, NULL);
				_tmp1506_ = _tmp1505_;
				_tmp1507_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1506_, TRUE, NULL, TRUE);
				_tmp1508_ = _tmp1507_;
				_vala_code_node_unref0 (_tmp1506_);
				_vala_code_node_unref0 (_tmp1504_);
				temp_var = _tmp1508_;
				_tmp1509_ = temp_var;
				_tmp1510_ = vala_symbol_get_name ((ValaSymbol*) _tmp1509_);
				_tmp1511_ = _tmp1510_;
				_tmp1512_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1511_);
				temp_ref = _tmp1512_;
				_tmp1513_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1513_, FALSE);
				_tmp1514_ = out_arg_map;
				_tmp1515_ = deleg;
				_tmp1516_ = temp_ref;
				_tmp1517_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1516_);
				_tmp1518_ = _tmp1517_;
				vala_map_set ((ValaMap*) _tmp1514_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1515_), FALSE)), (ValaCCodeExpression*) _tmp1518_);
				_vala_ccode_node_unref0 (_tmp1518_);
				_tmp1519_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1519_);
				_tmp1520_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1520_)) {
					ValaDataType* _tmp1521_;
					ValaLocalVariable* _tmp1522_;
					ValaLocalVariable* _tmp1523_;
					const gchar* _tmp1524_;
					const gchar* _tmp1525_;
					ValaCCodeExpression* _tmp1526_;
					ValaLocalVariable* _tmp1527_;
					ValaHashMap* _tmp1528_;
					ValaDelegate* _tmp1529_;
					ValaCCodeExpression* _tmp1530_;
					ValaCCodeUnaryExpression* _tmp1531_;
					ValaCCodeUnaryExpression* _tmp1532_;
					ValaCCodeExpression* _tmp1533_;
					_tmp1521_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1522_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1521_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1522_;
					_tmp1523_ = temp_var;
					_tmp1524_ = vala_symbol_get_name ((ValaSymbol*) _tmp1523_);
					_tmp1525_ = _tmp1524_;
					_tmp1526_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1525_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1526_;
					_tmp1527_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1527_, FALSE);
					_tmp1528_ = out_arg_map;
					_tmp1529_ = deleg;
					_tmp1530_ = temp_ref;
					_tmp1531_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1530_);
					_tmp1532_ = _tmp1531_;
					vala_map_set ((ValaMap*) _tmp1528_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1529_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1532_);
					_vala_ccode_node_unref0 (_tmp1532_);
					_tmp1533_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1533_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1535_ = m;
	if (_tmp1535_ != NULL) {
		ValaMethod* _tmp1536_;
		gboolean _tmp1537_;
		gboolean _tmp1538_;
		_tmp1536_ = m;
		_tmp1537_ = vala_method_get_coroutine (_tmp1536_);
		_tmp1538_ = _tmp1537_;
		_tmp1534_ = _tmp1538_;
	} else {
		_tmp1534_ = FALSE;
	}
	if (_tmp1534_) {
		gboolean _tmp1539_;
		gboolean _tmp1540_;
		_tmp1539_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1540_ = _tmp1539_;
		if (_tmp1540_) {
			ValaHashMap* _tmp1541_;
			ValaMethod* _tmp1542_;
			ValaMethod* _tmp1543_;
			gchar* _tmp1544_;
			gchar* _tmp1545_;
			ValaCCodeIdentifier* _tmp1546_;
			ValaCCodeIdentifier* _tmp1547_;
			ValaHashMap* _tmp1548_;
			ValaCCodeIdentifier* _tmp1549_;
			ValaCCodeIdentifier* _tmp1550_;
			_tmp1541_ = in_arg_map;
			_tmp1542_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1543_ = _tmp1542_;
			_tmp1544_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1543_);
			_tmp1545_ = _tmp1544_;
			_tmp1546_ = vala_ccode_identifier_new (_tmp1545_);
			_tmp1547_ = _tmp1546_;
			vala_map_set ((ValaMap*) _tmp1541_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1547_);
			_vala_ccode_node_unref0 (_tmp1547_);
			_g_free0 (_tmp1545_);
			_tmp1548_ = in_arg_map;
			_tmp1549_ = vala_ccode_identifier_new ("_data_");
			_tmp1550_ = _tmp1549_;
			vala_map_set ((ValaMap*) _tmp1548_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1550_);
			_vala_ccode_node_unref0 (_tmp1550_);
		}
	}
	_tmp1551_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1552_ = _tmp1551_;
	if (_tmp1552_) {
		ValaCallable* _tmp1553_ = NULL;
		ValaMethod* _tmp1554_;
		ValaHashMap* _tmp1556_;
		ValaCCodeExpression* _tmp1557_;
		ValaCCodeExpression* _tmp1558_;
		ValaCCodeUnaryExpression* _tmp1559_;
		ValaCCodeUnaryExpression* _tmp1560_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1554_ = m;
		_tmp1553_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1554_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1553_ == NULL) {
			ValaDelegate* _tmp1555_;
			_tmp1555_ = deleg;
			_tmp1553_ = (ValaCallable*) _tmp1555_;
		}
		_tmp1556_ = out_arg_map;
		_tmp1557_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1558_ = _tmp1557_;
		_tmp1559_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1558_);
		_tmp1560_ = _tmp1559_;
		vala_map_set ((ValaMap*) _tmp1556_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1553_), FALSE)), (ValaCCodeExpression*) _tmp1560_);
		_vala_ccode_node_unref0 (_tmp1560_);
		_vala_ccode_node_unref0 (_tmp1558_);
	} else {
		gboolean _tmp1561_ = FALSE;
		gboolean _tmp1562_ = FALSE;
		ValaMethod* _tmp1563_;
		_tmp1563_ = m;
		if (_tmp1563_ != NULL) {
			ValaMethod* _tmp1564_;
			_tmp1564_ = m;
			_tmp1562_ = vala_method_has_error_type_parameter (_tmp1564_);
		} else {
			_tmp1562_ = FALSE;
		}
		if (_tmp1562_) {
			ValaCCodeFunctionCall* _tmp1565_;
			ValaCCodeFunctionCall* _tmp1566_;
			_tmp1565_ = async_call;
			_tmp1566_ = ccall;
			_tmp1561_ = _tmp1565_ != _tmp1566_;
		} else {
			_tmp1561_ = FALSE;
		}
		if (_tmp1561_) {
			ValaHashMap* _tmp1567_;
			ValaMethod* _tmp1568_;
			ValaCCodeConstant* _tmp1569_;
			ValaCCodeConstant* _tmp1570_;
			_tmp1567_ = out_arg_map;
			_tmp1568_ = m;
			_tmp1569_ = vala_ccode_constant_new ("NULL");
			_tmp1570_ = _tmp1569_;
			vala_map_set ((ValaMap*) _tmp1567_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1568_), FALSE)), (ValaCCodeExpression*) _tmp1570_);
			_vala_ccode_node_unref0 (_tmp1570_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1571_;
		_tmp1571_ = m;
		if (_tmp1571_ == NULL) {
			ValaHashMap* _tmp1572_;
			ValaCCodeConstant* _tmp1573_;
			ValaCCodeConstant* _tmp1574_;
			_tmp1572_ = in_arg_map;
			_tmp1573_ = vala_ccode_constant_new ("NULL");
			_tmp1574_ = _tmp1573_;
			vala_map_set ((ValaMap*) _tmp1572_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1574_);
			_vala_ccode_node_unref0 (_tmp1574_);
		} else {
			gboolean _tmp1575_ = FALSE;
			gboolean _tmp1576_ = FALSE;
			gboolean _tmp1577_ = FALSE;
			ValaMethod* _tmp1578_;
			gboolean _tmp1579_;
			gboolean _tmp1580_;
			_tmp1578_ = m;
			_tmp1579_ = vala_method_get_printf_format (_tmp1578_);
			_tmp1580_ = _tmp1579_;
			if (!_tmp1580_) {
				ValaMethod* _tmp1581_;
				gboolean _tmp1582_;
				gboolean _tmp1583_;
				_tmp1581_ = m;
				_tmp1582_ = vala_method_get_scanf_format (_tmp1581_);
				_tmp1583_ = _tmp1582_;
				_tmp1577_ = !_tmp1583_;
			} else {
				_tmp1577_ = FALSE;
			}
			if (_tmp1577_) {
				ValaMethod* _tmp1584_;
				gchar* _tmp1585_;
				gchar* _tmp1586_;
				_tmp1584_ = m;
				_tmp1585_ = vala_get_ccode_sentinel (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				_tmp1576_ = g_strcmp0 (_tmp1586_, "") != 0;
				_g_free0 (_tmp1586_);
			} else {
				_tmp1576_ = FALSE;
			}
			if (_tmp1576_) {
				gboolean _tmp1587_;
				gboolean _tmp1588_;
				_tmp1587_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1588_ = _tmp1587_;
				_tmp1575_ = !_tmp1588_;
			} else {
				_tmp1575_ = FALSE;
			}
			if (_tmp1575_) {
				ValaHashMap* _tmp1589_;
				ValaMethod* _tmp1590_;
				gchar* _tmp1591_;
				gchar* _tmp1592_;
				ValaCCodeConstant* _tmp1593_;
				ValaCCodeConstant* _tmp1594_;
				_tmp1589_ = in_arg_map;
				_tmp1590_ = m;
				_tmp1591_ = vala_get_ccode_sentinel (_tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_ccode_constant_new (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				vala_map_set ((ValaMap*) _tmp1589_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1594_);
				_vala_ccode_node_unref0 (_tmp1594_);
				_g_free0 (_tmp1592_);
			}
		}
	}
	_tmp1596_ = deleg;
	if (_tmp1596_ != NULL) {
		ValaDelegate* _tmp1597_;
		gboolean _tmp1598_;
		gboolean _tmp1599_;
		_tmp1597_ = deleg;
		_tmp1598_ = vala_delegate_get_has_target (_tmp1597_);
		_tmp1599_ = _tmp1598_;
		_tmp1595_ = _tmp1599_;
	} else {
		_tmp1595_ = FALSE;
	}
	if (_tmp1595_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1600_;
		ValaDelegate* _tmp1601_;
		ValaExpression* _tmp1602_;
		ValaExpression* _tmp1603_;
		ValaCCodeExpression* _tmp1604_ = NULL;
		ValaCCodeExpression* _tmp1605_;
		ValaCCodeExpression* _tmp1606_;
		ValaHashMap* _tmp1607_;
		ValaDelegate* _tmp1608_;
		ValaExpression* _tmp1609_;
		ValaExpression* _tmp1610_;
		ValaCCodeExpression* _tmp1611_ = NULL;
		ValaCCodeExpression* _tmp1612_;
		ValaCCodeExpression* _tmp1613_;
		_tmp1600_ = in_arg_map;
		_tmp1601_ = deleg;
		_tmp1602_ = vala_method_call_get_call (expr);
		_tmp1603_ = _tmp1602_;
		_tmp1605_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1603_, &_tmp1604_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1604_;
		_tmp1606_ = _tmp1605_;
		vala_map_set ((ValaMap*) _tmp1600_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1601_), FALSE)), _tmp1606_);
		_vala_ccode_node_unref0 (_tmp1606_);
		_tmp1607_ = out_arg_map;
		_tmp1608_ = deleg;
		_tmp1609_ = vala_method_call_get_call (expr);
		_tmp1610_ = _tmp1609_;
		_tmp1612_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1610_, &_tmp1611_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1611_;
		_tmp1613_ = _tmp1612_;
		vala_map_set ((ValaMap*) _tmp1607_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1608_), FALSE)), _tmp1613_);
		_vala_ccode_node_unref0 (_tmp1613_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1614_ = itype;
	_tmp1615_ = vala_data_type_get_return_type (_tmp1614_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1615_);
	_tmp1617_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1617_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1618_;
		ValaDataType* _tmp1619_;
		_tmp1618_ = itype;
		_tmp1619_ = vala_data_type_get_return_type (_tmp1618_);
		_tmp1616_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1619_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1616_ = FALSE;
	}
	if (_tmp1616_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1620_;
		ValaSignal* _tmp1621_;
		ValaSignal* _tmp1622_;
		ValaSignal* _tmp1623_;
		gboolean _tmp1624_ = FALSE;
		gboolean _tmp1625_ = FALSE;
		ValaMemberAccess* _tmp1626_;
		_tmp1620_ = itype;
		_tmp1621_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1620_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1622_ = _tmp1621_;
		_tmp1623_ = _vala_code_node_ref0 (_tmp1622_);
		sig = _tmp1623_;
		_tmp1626_ = ma;
		if (_tmp1626_ != NULL) {
			ValaMemberAccess* _tmp1627_;
			ValaExpression* _tmp1628_;
			ValaExpression* _tmp1629_;
			_tmp1627_ = ma;
			_tmp1628_ = vala_member_access_get_inner (_tmp1627_);
			_tmp1629_ = _tmp1628_;
			_tmp1625_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1629_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1625_ = FALSE;
		}
		if (_tmp1625_) {
			ValaSignal* _tmp1630_;
			gboolean _tmp1631_;
			gboolean _tmp1632_;
			_tmp1630_ = sig;
			_tmp1631_ = vala_signal_get_is_virtual (_tmp1630_);
			_tmp1632_ = _tmp1631_;
			_tmp1624_ = _tmp1632_;
		} else {
			_tmp1624_ = FALSE;
		}
		if (_tmp1624_) {
		} else {
			gboolean _tmp1633_ = FALSE;
			ValaSignal* _tmp1634_;
			_tmp1634_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1634_)) {
				_tmp1633_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1635_;
				ValaSourceReference* _tmp1636_;
				ValaSourceReference* _tmp1637_;
				ValaSourceFile* _tmp1638_;
				ValaSourceFile* _tmp1639_;
				ValaSignal* _tmp1640_;
				ValaSourceReference* _tmp1641_;
				ValaSourceReference* _tmp1642_;
				ValaSourceFile* _tmp1643_;
				ValaSourceFile* _tmp1644_;
				_tmp1635_ = ma;
				_tmp1636_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1635_);
				_tmp1637_ = _tmp1636_;
				_tmp1638_ = vala_source_reference_get_file (_tmp1637_);
				_tmp1639_ = _tmp1638_;
				_tmp1640_ = sig;
				_tmp1641_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1640_);
				_tmp1642_ = _tmp1641_;
				_tmp1643_ = vala_source_reference_get_file (_tmp1642_);
				_tmp1644_ = _tmp1643_;
				_tmp1633_ = _tmp1639_ == _tmp1644_;
			}
			if (_tmp1633_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1645_ = async_call;
	_tmp1646_ = ccall;
	if (_tmp1645_ == _tmp1646_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1647_;
		ValaDataType* _tmp1648_;
		ValaLocalVariable* _tmp1649_;
		ValaLocalVariable* _tmp1650_;
		const gchar* _tmp1651_;
		const gchar* _tmp1652_;
		ValaCCodeExpression* _tmp1653_;
		ValaLocalVariable* _tmp1654_;
		ValaHashMap* _tmp1655_;
		ValaCCodeExpression* _tmp1656_;
		ValaCCodeUnaryExpression* _tmp1657_;
		ValaCCodeUnaryExpression* _tmp1658_;
		_tmp1647_ = itype;
		_tmp1648_ = vala_data_type_get_return_type (_tmp1647_);
		_tmp1649_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1648_, TRUE, NULL, TRUE);
		out_param_var = _tmp1649_;
		_tmp1650_ = out_param_var;
		_tmp1651_ = vala_symbol_get_name ((ValaSymbol*) _tmp1650_);
		_tmp1652_ = _tmp1651_;
		_tmp1653_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1652_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1653_;
		_tmp1654_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1654_, FALSE);
		_tmp1655_ = out_arg_map;
		_tmp1656_ = out_param_ref;
		_tmp1657_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1656_);
		_tmp1658_ = _tmp1657_;
		vala_map_set ((ValaMap*) _tmp1655_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1658_);
		_vala_ccode_node_unref0 (_tmp1658_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1659_ = async_call;
	_tmp1660_ = ccall;
	if (_tmp1659_ != _tmp1660_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1671_;
			ValaHashMap* _tmp1672_;
			gpointer _tmp1673_;
			ValaCCodeExpression* _tmp1674_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1661_;
				ValaSet* _tmp1662_;
				ValaSet* _tmp1663_;
				ValaIterator* _tmp1664_;
				ValaIterator* _tmp1665_;
				_tmp1661_ = out_arg_map;
				_tmp1662_ = vala_map_get_keys ((ValaMap*) _tmp1661_);
				_tmp1663_ = _tmp1662_;
				_tmp1664_ = vala_iterable_iterator ((ValaIterable*) _tmp1663_);
				_tmp1665_ = _tmp1664_;
				_vala_iterable_unref0 (_tmp1663_);
				_pos_it = _tmp1665_;
				while (TRUE) {
					ValaIterator* _tmp1666_;
					gint pos = 0;
					ValaIterator* _tmp1667_;
					gpointer _tmp1668_;
					gboolean _tmp1669_ = FALSE;
					_tmp1666_ = _pos_it;
					if (!vala_iterator_next (_tmp1666_)) {
						break;
					}
					_tmp1667_ = _pos_it;
					_tmp1668_ = vala_iterator_get (_tmp1667_);
					pos = (gint) ((gintptr) _tmp1668_);
					if (pos > last_pos) {
						gboolean _tmp1670_ = FALSE;
						if (min_pos == -1) {
							_tmp1670_ = TRUE;
						} else {
							_tmp1670_ = pos < min_pos;
						}
						_tmp1669_ = _tmp1670_;
					} else {
						_tmp1669_ = FALSE;
					}
					if (_tmp1669_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1671_ = ccall;
			_tmp1672_ = out_arg_map;
			_tmp1673_ = vala_map_get ((ValaMap*) _tmp1672_, (gpointer) ((gintptr) min_pos));
			_tmp1674_ = (ValaCCodeExpression*) _tmp1673_;
			vala_ccode_function_call_add_argument (_tmp1671_, _tmp1674_);
			_vala_ccode_node_unref0 (_tmp1674_);
			last_pos = min_pos;
		}
	}
	_tmp1675_ = async_call;
	if (_tmp1675_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1686_;
			ValaHashMap* _tmp1687_;
			gpointer _tmp1688_;
			ValaCCodeExpression* _tmp1689_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1676_;
				ValaSet* _tmp1677_;
				ValaSet* _tmp1678_;
				ValaIterator* _tmp1679_;
				ValaIterator* _tmp1680_;
				_tmp1676_ = in_arg_map;
				_tmp1677_ = vala_map_get_keys ((ValaMap*) _tmp1676_);
				_tmp1678_ = _tmp1677_;
				_tmp1679_ = vala_iterable_iterator ((ValaIterable*) _tmp1678_);
				_tmp1680_ = _tmp1679_;
				_vala_iterable_unref0 (_tmp1678_);
				_pos_it = _tmp1680_;
				while (TRUE) {
					ValaIterator* _tmp1681_;
					gint pos = 0;
					ValaIterator* _tmp1682_;
					gpointer _tmp1683_;
					gboolean _tmp1684_ = FALSE;
					_tmp1681_ = _pos_it;
					if (!vala_iterator_next (_tmp1681_)) {
						break;
					}
					_tmp1682_ = _pos_it;
					_tmp1683_ = vala_iterator_get (_tmp1682_);
					pos = (gint) ((gintptr) _tmp1683_);
					if (pos > last_pos) {
						gboolean _tmp1685_ = FALSE;
						if (min_pos == -1) {
							_tmp1685_ = TRUE;
						} else {
							_tmp1685_ = pos < min_pos;
						}
						_tmp1684_ = _tmp1685_;
					} else {
						_tmp1684_ = FALSE;
					}
					if (_tmp1684_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1686_ = async_call;
			_tmp1687_ = in_arg_map;
			_tmp1688_ = vala_map_get ((ValaMap*) _tmp1687_, (gpointer) ((gintptr) min_pos));
			_tmp1689_ = (ValaCCodeExpression*) _tmp1688_;
			vala_ccode_function_call_add_argument (_tmp1686_, _tmp1689_);
			_vala_ccode_node_unref0 (_tmp1689_);
			last_pos = min_pos;
		}
	}
	_tmp1690_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1691_ = _tmp1690_;
	if (_tmp1691_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1692_;
		gint _tmp1693_;
		ValaCCodeFunction* _tmp1694_;
		ValaCCodeFunction* _tmp1695_;
		ValaCCodeIdentifier* _tmp1696_;
		ValaCCodeIdentifier* _tmp1697_;
		ValaCCodeMemberAccess* _tmp1698_;
		ValaCCodeMemberAccess* _tmp1699_;
		gchar* _tmp1700_;
		gchar* _tmp1701_;
		ValaCCodeConstant* _tmp1702_;
		ValaCCodeConstant* _tmp1703_;
		ValaCCodeFunction* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeFunctionCall* _tmp1706_;
		ValaCCodeFunction* _tmp1707_;
		ValaCCodeFunction* _tmp1708_;
		ValaCCodeConstant* _tmp1709_;
		ValaCCodeConstant* _tmp1710_;
		ValaCCodeFunction* _tmp1711_;
		ValaCCodeFunction* _tmp1712_;
		gchar* _tmp1713_;
		gchar* _tmp1714_;
		_tmp1692_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1693_ = _tmp1692_->next_coroutine_state;
		_tmp1692_->next_coroutine_state = _tmp1693_ + 1;
		state = _tmp1693_;
		_tmp1694_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1695_ = _tmp1694_;
		_tmp1696_ = vala_ccode_identifier_new ("_data_");
		_tmp1697_ = _tmp1696_;
		_tmp1698_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1697_, "_state_");
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = g_strdup_printf ("%i", state);
		_tmp1701_ = _tmp1700_;
		_tmp1702_ = vala_ccode_constant_new (_tmp1701_);
		_tmp1703_ = _tmp1702_;
		vala_ccode_function_add_assignment (_tmp1695_, (ValaCCodeExpression*) _tmp1699_, (ValaCCodeExpression*) _tmp1703_);
		_vala_ccode_node_unref0 (_tmp1703_);
		_g_free0 (_tmp1701_);
		_vala_ccode_node_unref0 (_tmp1699_);
		_vala_ccode_node_unref0 (_tmp1697_);
		_tmp1704_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1705_ = _tmp1704_;
		_tmp1706_ = async_call;
		vala_ccode_function_add_expression (_tmp1705_, (ValaCCodeExpression*) _tmp1706_);
		_tmp1707_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1708_ = _tmp1707_;
		_tmp1709_ = vala_ccode_constant_new ("FALSE");
		_tmp1710_ = _tmp1709_;
		vala_ccode_function_add_return (_tmp1708_, (ValaCCodeExpression*) _tmp1710_);
		_vala_ccode_node_unref0 (_tmp1710_);
		_tmp1711_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1712_ = _tmp1711_;
		_tmp1713_ = g_strdup_printf ("_state_%d", state);
		_tmp1714_ = _tmp1713_;
		vala_ccode_function_add_label (_tmp1712_, _tmp1714_);
		_g_free0 (_tmp1714_);
	}
	_tmp1715_ = vala_method_call_get_is_assert (expr);
	_tmp1716_ = _tmp1715_;
	if (_tmp1716_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1717_;
		ValaSourceReference* _tmp1718_;
		ValaSourceLocation _tmp1719_ = {0};
		ValaSourceLocation _tmp1720_;
		gchar* _tmp1721_;
		ValaSourceReference* _tmp1722_;
		ValaSourceReference* _tmp1723_;
		ValaSourceLocation _tmp1724_ = {0};
		ValaSourceLocation _tmp1725_;
		gchar* _tmp1726_;
		ValaSourceReference* _tmp1727_;
		ValaSourceReference* _tmp1728_;
		ValaSourceLocation _tmp1729_ = {0};
		ValaSourceLocation _tmp1730_;
		gchar* _tmp1731_;
		gchar* _tmp1732_;
		ValaCCodeFunctionCall* _tmp1733_;
		ValaCCodeIdentifier* _tmp1734_;
		ValaCCodeIdentifier* _tmp1735_;
		ValaCCodeFunctionCall* _tmp1736_;
		const gchar* _tmp1737_;
		gchar* _tmp1738_;
		gchar* _tmp1739_;
		gchar* _tmp1740_;
		gchar* _tmp1741_;
		gchar* _tmp1742_;
		gchar* _tmp1743_;
		ValaCCodeConstant* _tmp1744_;
		ValaCCodeConstant* _tmp1745_;
		_tmp1717_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1718_ = _tmp1717_;
		vala_source_reference_get_begin (_tmp1718_, &_tmp1719_);
		_tmp1720_ = _tmp1719_;
		_tmp1721_ = _tmp1720_.pos;
		_tmp1722_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1723_ = _tmp1722_;
		vala_source_reference_get_end (_tmp1723_, &_tmp1724_);
		_tmp1725_ = _tmp1724_;
		_tmp1726_ = _tmp1725_.pos;
		_tmp1727_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1728_ = _tmp1727_;
		vala_source_reference_get_begin (_tmp1728_, &_tmp1729_);
		_tmp1730_ = _tmp1729_;
		_tmp1731_ = _tmp1730_.pos;
		_tmp1732_ = string_substring ((const gchar*) _tmp1721_, (glong) 0, (glong) ((gint) (_tmp1726_ - _tmp1731_)));
		message = _tmp1732_;
		_tmp1733_ = ccall;
		_tmp1734_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1735_ = _tmp1734_;
		vala_ccode_function_call_set_call (_tmp1733_, (ValaCCodeExpression*) _tmp1735_);
		_vala_ccode_node_unref0 (_tmp1735_);
		_tmp1736_ = ccall;
		_tmp1737_ = message;
		_tmp1738_ = string_replace (_tmp1737_, "\n", " ");
		_tmp1739_ = _tmp1738_;
		_tmp1740_ = g_strescape (_tmp1739_, "");
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = g_strdup_printf ("\"%s\"", _tmp1741_);
		_tmp1743_ = _tmp1742_;
		_tmp1744_ = vala_ccode_constant_new (_tmp1743_);
		_tmp1745_ = _tmp1744_;
		vala_ccode_function_call_add_argument (_tmp1736_, (ValaCCodeExpression*) _tmp1745_);
		_vala_ccode_node_unref0 (_tmp1745_);
		_g_free0 (_tmp1743_);
		_g_free0 (_tmp1741_);
		_g_free0 (_tmp1739_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1746_;
		ValaCCodeFunction* _tmp1747_;
		ValaCCodeExpression* _tmp1748_;
		ValaCCodeExpression* _tmp1749_;
		ValaCCodeExpression* _tmp1750_;
		_tmp1746_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1747_ = _tmp1746_;
		_tmp1748_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1747_, _tmp1748_);
		_tmp1749_ = out_param_ref;
		_tmp1750_ = _vala_ccode_node_ref0 (_tmp1749_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1750_;
	}
	_tmp1753_ = m;
	if (_tmp1753_ != NULL) {
		ValaMethod* _tmp1754_;
		ValaMemberBinding _tmp1755_;
		ValaMemberBinding _tmp1756_;
		_tmp1754_ = m;
		_tmp1755_ = vala_method_get_binding (_tmp1754_);
		_tmp1756_ = _tmp1755_;
		_tmp1752_ = _tmp1756_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1752_ = FALSE;
	}
	if (_tmp1752_) {
		ValaMethod* _tmp1757_;
		gboolean _tmp1758_;
		gboolean _tmp1759_;
		_tmp1757_ = m;
		_tmp1758_ = vala_method_get_returns_modified_pointer (_tmp1757_);
		_tmp1759_ = _tmp1758_;
		_tmp1751_ = _tmp1759_;
	} else {
		_tmp1751_ = FALSE;
	}
	if (_tmp1751_) {
		gboolean _tmp1760_ = FALSE;
		gboolean _tmp1761_ = FALSE;
		ValaMemberAccess* _tmp1762_;
		_tmp1762_ = ma;
		if (_tmp1762_ != NULL) {
			ValaMemberAccess* _tmp1763_;
			ValaExpression* _tmp1764_;
			ValaExpression* _tmp1765_;
			ValaSymbol* _tmp1766_;
			ValaSymbol* _tmp1767_;
			_tmp1763_ = ma;
			_tmp1764_ = vala_member_access_get_inner (_tmp1763_);
			_tmp1765_ = _tmp1764_;
			_tmp1766_ = vala_expression_get_symbol_reference (_tmp1765_);
			_tmp1767_ = _tmp1766_;
			_tmp1761_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1767_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1761_ = FALSE;
		}
		if (_tmp1761_) {
			ValaMemberAccess* _tmp1768_;
			ValaExpression* _tmp1769_;
			ValaExpression* _tmp1770_;
			_tmp1768_ = ma;
			_tmp1769_ = vala_member_access_get_inner (_tmp1768_);
			_tmp1770_ = _tmp1769_;
			_tmp1760_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1770_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1760_ = FALSE;
		}
		if (_tmp1760_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1771_;
			ValaExpression* _tmp1772_;
			ValaExpression* _tmp1773_;
			ValaSymbol* _tmp1774_;
			ValaSymbol* _tmp1775_;
			ValaProperty* _tmp1776_;
			ValaProperty* _tmp1777_;
			ValaMemberAccess* _tmp1778_;
			ValaExpression* _tmp1779_;
			ValaExpression* _tmp1780_;
			ValaExpression* _tmp1781_;
			ValaExpression* _tmp1782_;
			ValaDataType* _tmp1783_;
			ValaDataType* _tmp1784_;
			ValaCCodeExpression* _tmp1785_;
			ValaGLibValue* _tmp1786_;
			ValaGLibValue* _tmp1787_;
			_tmp1771_ = ma;
			_tmp1772_ = vala_member_access_get_inner (_tmp1771_);
			_tmp1773_ = _tmp1772_;
			_tmp1774_ = vala_expression_get_symbol_reference (_tmp1773_);
			_tmp1775_ = _tmp1774_;
			_tmp1776_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1775_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1776_;
			_tmp1777_ = prop;
			_tmp1778_ = ma;
			_tmp1779_ = vala_member_access_get_inner (_tmp1778_);
			_tmp1780_ = _tmp1779_;
			_tmp1781_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1780_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1782_ = _tmp1781_;
			_tmp1783_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1784_ = _tmp1783_;
			_tmp1785_ = ccall_expr;
			_tmp1786_ = vala_glib_value_new (_tmp1784_, _tmp1785_, FALSE);
			_tmp1787_ = _tmp1786_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1777_, _tmp1782_, (ValaTargetValue*) _tmp1787_);
			_vala_target_value_unref0 (_tmp1787_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1788_;
			ValaCCodeExpression* _tmp1789_;
			ValaCCodeAssignment* _tmp1790_;
			_tmp1788_ = instance;
			_tmp1789_ = ccall_expr;
			_tmp1790_ = vala_ccode_assignment_new (_tmp1788_, _tmp1789_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1790_;
		}
	}
	_tmp1796_ = m;
	if (_tmp1796_ != NULL) {
		ValaMethod* _tmp1797_;
		_tmp1797_ = m;
		_tmp1795_ = vala_get_ccode_simple_generics (_tmp1797_);
	} else {
		_tmp1795_ = FALSE;
	}
	if (_tmp1795_) {
		ValaMethod* _tmp1798_;
		ValaDataType* _tmp1799_;
		ValaDataType* _tmp1800_;
		_tmp1798_ = m;
		_tmp1799_ = vala_callable_get_return_type ((ValaCallable*) _tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1794_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1800_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1794_ = FALSE;
	}
	if (_tmp1794_) {
		ValaDataType* _tmp1801_;
		ValaDataType* _tmp1802_;
		_tmp1801_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1802_ = _tmp1801_;
		_tmp1793_ = vala_data_type_is_real_struct_type (_tmp1802_);
	} else {
		_tmp1793_ = FALSE;
	}
	if (_tmp1793_) {
		ValaDataType* _tmp1803_;
		ValaDataType* _tmp1804_;
		gboolean _tmp1805_;
		gboolean _tmp1806_;
		_tmp1803_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1804_ = _tmp1803_;
		_tmp1805_ = vala_data_type_get_nullable (_tmp1804_);
		_tmp1806_ = _tmp1805_;
		_tmp1792_ = !_tmp1806_;
	} else {
		_tmp1792_ = FALSE;
	}
	if (_tmp1792_) {
		ValaDataType* _tmp1807_;
		ValaDataType* _tmp1808_;
		_tmp1807_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1808_ = _tmp1807_;
		_tmp1791_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1808_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1791_ = FALSE;
	}
	if (_tmp1791_) {
		ValaCCodeExpression* _tmp1809_;
		ValaCCodeParenthesizedExpression* _tmp1810_;
		ValaCCodeParenthesizedExpression* _tmp1811_;
		ValaCCodeUnaryExpression* _tmp1812_;
		_tmp1809_ = ccall_expr;
		_tmp1810_ = vala_ccode_parenthesized_expression_new (_tmp1809_);
		_tmp1811_ = _tmp1810_;
		_tmp1812_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1811_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1812_;
		_vala_ccode_node_unref0 (_tmp1811_);
	}
	_tmp1815_ = m;
	if (_tmp1815_ != NULL) {
		ValaMethod* _tmp1816_;
		gchar* _tmp1817_;
		gchar* _tmp1818_;
		_tmp1816_ = m;
		_tmp1817_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1814_ = _tmp1818_ != NULL;
		_g_free0 (_tmp1818_);
	} else {
		_tmp1814_ = FALSE;
	}
	if (_tmp1814_) {
		ValaMethod* _tmp1819_;
		gchar* _tmp1820_;
		gchar* _tmp1821_;
		ValaMethod* _tmp1822_;
		ValaDataType* _tmp1823_;
		ValaDataType* _tmp1824_;
		gchar* _tmp1825_;
		gchar* _tmp1826_;
		_tmp1819_ = m;
		_tmp1820_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1822_ = m;
		_tmp1823_ = vala_callable_get_return_type ((ValaCallable*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1825_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1813_ = g_strcmp0 (_tmp1821_, _tmp1826_) != 0;
		_g_free0 (_tmp1826_);
		_g_free0 (_tmp1821_);
	} else {
		_tmp1813_ = FALSE;
	}
	if (_tmp1813_) {
		ValaCCodeExpression* _tmp1827_;
		ValaMethod* _tmp1828_;
		ValaDataType* _tmp1829_;
		ValaDataType* _tmp1830_;
		gchar* _tmp1831_;
		gchar* _tmp1832_;
		ValaCCodeCastExpression* _tmp1833_;
		_tmp1827_ = ccall_expr;
		_tmp1828_ = m;
		_tmp1829_ = vala_callable_get_return_type ((ValaCallable*) _tmp1828_);
		_tmp1830_ = _tmp1829_;
		_tmp1831_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1830_);
		_tmp1832_ = _tmp1831_;
		_tmp1833_ = vala_ccode_cast_expression_new (_tmp1827_, _tmp1832_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1833_;
		_g_free0 (_tmp1832_);
	}
	_tmp1834_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1834_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1835_;
		ValaIterator* _tmp1836_;
		ValaIterator* _tmp1837_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1838_;
		gpointer _tmp1839_;
		ValaExpression* _tmp1840_;
		ValaCCodeExpression* _tmp1841_;
		ValaCCodeExpression* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1844_;
		ValaLocalVariable* _tmp1845_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1846_;
		const gchar* _tmp1847_;
		const gchar* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaLocalVariable* _tmp1850_;
		ValaCCodeFile* _tmp1851_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1852_;
		ValaExpression* _tmp1853_;
		ValaExpression* _tmp1854_;
		ValaCCodeExpression* _tmp1855_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaExpression* _tmp1858_;
		ValaCCodeExpression* _tmp1859_;
		ValaCCodeExpression* _tmp1860_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1861_;
		ValaExpression* _tmp1862_;
		ValaExpression* _tmp1863_;
		ValaDataType* _tmp1864_;
		ValaDataType* _tmp1865_;
		ValaArrayType* _tmp1866_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1867_;
		ValaDataType* _tmp1868_;
		ValaDataType* _tmp1869_;
		gchar* _tmp1870_;
		gchar* _tmp1871_;
		gchar* _tmp1872_;
		gchar* _tmp1873_;
		ValaCCodeIdentifier* _tmp1874_;
		ValaCCodeIdentifier* _tmp1875_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1876_;
		ValaCCodeExpression* _tmp1877_;
		ValaCCodeBinaryExpression* _tmp1878_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1879_;
		ValaCCodeExpression* _tmp1880_;
		ValaCCodeBinaryExpression* _tmp1881_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1882_;
		ValaCCodeIdentifier* _tmp1883_;
		ValaCCodeFunctionCall* _tmp1884_;
		ValaCCodeFunctionCall* _tmp1885_;
		ValaCCodeFunctionCall* _tmp1886_;
		ValaCCodeExpression* _tmp1887_;
		ValaCCodeExpression* _tmp1888_;
		ValaCCodeBinaryExpression* _tmp1889_;
		ValaCCodeBinaryExpression* _tmp1890_;
		ValaCCodeFunctionCall* _tmp1891_;
		ValaCCodeConstant* _tmp1892_;
		ValaCCodeConstant* _tmp1893_;
		ValaCCodeFunctionCall* _tmp1894_;
		ValaCCodeIdentifier* _tmp1895_;
		ValaCCodeBinaryExpression* _tmp1896_;
		ValaCCodeBinaryExpression* _tmp1897_;
		ValaCCodeBinaryExpression* _tmp1898_;
		ValaCCodeFunction* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeExpression* _tmp1901_;
		ValaCCodeExpression* _tmp1902_;
		ValaCCodeFunction* _tmp1903_;
		ValaCCodeFunction* _tmp1904_;
		ValaCCodeExpression* _tmp1905_;
		ValaCCodeFunction* _tmp1906_;
		ValaCCodeFunction* _tmp1907_;
		ValaCCodeBinaryExpression* _tmp1908_;
		ValaCCodeFunctionCall* _tmp1909_;
		ValaCCodeConstant* _tmp1910_;
		ValaCCodeConstant* _tmp1911_;
		ValaCCodeConditionalExpression* _tmp1912_;
		ValaCCodeConditionalExpression* _tmp1913_;
		ValaCCodeFunction* _tmp1914_;
		ValaCCodeFunction* _tmp1915_;
		ValaMemberAccess* _tmp1916_;
		ValaExpression* _tmp1917_;
		ValaExpression* _tmp1918_;
		ValaCCodeExpression* _tmp1919_;
		ValaCCodeExpression* _tmp1920_;
		ValaCCodeExpression* _tmp1921_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1922_;
		ValaExpression* _tmp1923_;
		ValaExpression* _tmp1924_;
		ValaSymbol* _tmp1925_;
		ValaSymbol* _tmp1926_;
		ValaSymbol* _tmp1927_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1928_;
		ValaLocalVariable* _tmp1929_;
		gboolean _tmp1930_ = FALSE;
		gboolean _tmp1931_ = FALSE;
		ValaSymbol* _tmp1932_;
		_tmp1835_ = vala_method_call_get_argument_list (expr);
		_tmp1836_ = vala_iterable_iterator ((ValaIterable*) _tmp1835_);
		arg_it = _tmp1836_;
		_tmp1837_ = arg_it;
		vala_iterator_next (_tmp1837_);
		_tmp1838_ = arg_it;
		_tmp1839_ = vala_iterator_get (_tmp1838_);
		_tmp1840_ = (ValaExpression*) _tmp1839_;
		_tmp1841_ = vala_get_cvalue (_tmp1840_);
		_tmp1842_ = _vala_ccode_node_ref0 (_tmp1841_);
		_tmp1843_ = _tmp1842_;
		_vala_code_node_unref0 (_tmp1840_);
		new_size = _tmp1843_;
		_tmp1844_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1845_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1844_, TRUE, NULL, FALSE);
		temp_decl = _tmp1845_;
		_tmp1846_ = temp_decl;
		_tmp1847_ = vala_symbol_get_name ((ValaSymbol*) _tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1848_);
		temp_ref = _tmp1849_;
		_tmp1850_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1850_, FALSE);
		_tmp1851_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1851_, "string.h", FALSE);
		_tmp1852_ = ma;
		_tmp1853_ = vala_member_access_get_inner (_tmp1852_);
		_tmp1854_ = _tmp1853_;
		_tmp1855_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1854_, 1);
		clen = _tmp1855_;
		_tmp1856_ = ma;
		_tmp1857_ = vala_member_access_get_inner (_tmp1856_);
		_tmp1858_ = _tmp1857_;
		_tmp1859_ = vala_get_cvalue (_tmp1858_);
		_tmp1860_ = _vala_ccode_node_ref0 (_tmp1859_);
		celems = _tmp1860_;
		_tmp1861_ = ma;
		_tmp1862_ = vala_member_access_get_inner (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_expression_get_value_type (_tmp1863_);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1865_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1866_;
		_tmp1867_ = array_type;
		_tmp1868_ = vala_array_type_get_element_type (_tmp1867_);
		_tmp1869_ = _tmp1868_;
		_tmp1870_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1869_);
		_tmp1871_ = _tmp1870_;
		_tmp1872_ = g_strdup_printf ("sizeof (%s)", _tmp1871_);
		_tmp1873_ = _tmp1872_;
		_tmp1874_ = vala_ccode_identifier_new (_tmp1873_);
		_tmp1875_ = _tmp1874_;
		_g_free0 (_tmp1873_);
		_g_free0 (_tmp1871_);
		csizeof = _tmp1875_;
		_tmp1876_ = temp_ref;
		_tmp1877_ = clen;
		_tmp1878_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1876_, _tmp1877_);
		cdelta = _tmp1878_;
		_tmp1879_ = temp_ref;
		_tmp1880_ = clen;
		_tmp1881_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1879_, _tmp1880_);
		ccheck = _tmp1881_;
		_tmp1882_ = vala_ccode_identifier_new ("memset");
		_tmp1883_ = _tmp1882_;
		_tmp1884_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1883_);
		_tmp1885_ = _tmp1884_;
		_vala_ccode_node_unref0 (_tmp1883_);
		czero = _tmp1885_;
		_tmp1886_ = czero;
		_tmp1887_ = celems;
		_tmp1888_ = clen;
		_tmp1889_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1887_, _tmp1888_);
		_tmp1890_ = _tmp1889_;
		vala_ccode_function_call_add_argument (_tmp1886_, (ValaCCodeExpression*) _tmp1890_);
		_vala_ccode_node_unref0 (_tmp1890_);
		_tmp1891_ = czero;
		_tmp1892_ = vala_ccode_constant_new ("0");
		_tmp1893_ = _tmp1892_;
		vala_ccode_function_call_add_argument (_tmp1891_, (ValaCCodeExpression*) _tmp1893_);
		_vala_ccode_node_unref0 (_tmp1893_);
		_tmp1894_ = czero;
		_tmp1895_ = csizeof;
		_tmp1896_ = cdelta;
		_tmp1897_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1895_, (ValaCCodeExpression*) _tmp1896_);
		_tmp1898_ = _tmp1897_;
		vala_ccode_function_call_add_argument (_tmp1894_, (ValaCCodeExpression*) _tmp1898_);
		_vala_ccode_node_unref0 (_tmp1898_);
		_tmp1899_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1900_ = _tmp1899_;
		_tmp1901_ = temp_ref;
		_tmp1902_ = new_size;
		vala_ccode_function_add_assignment (_tmp1900_, _tmp1901_, _tmp1902_);
		_tmp1903_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1904_ = _tmp1903_;
		_tmp1905_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1904_, _tmp1905_);
		_tmp1906_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1907_ = _tmp1906_;
		_tmp1908_ = ccheck;
		_tmp1909_ = czero;
		_tmp1910_ = vala_ccode_constant_new ("NULL");
		_tmp1911_ = _tmp1910_;
		_tmp1912_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1908_, (ValaCCodeExpression*) _tmp1909_, (ValaCCodeExpression*) _tmp1911_);
		_tmp1913_ = _tmp1912_;
		vala_ccode_function_add_expression (_tmp1907_, (ValaCCodeExpression*) _tmp1913_);
		_vala_ccode_node_unref0 (_tmp1913_);
		_vala_ccode_node_unref0 (_tmp1911_);
		_tmp1914_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1915_ = _tmp1914_;
		_tmp1916_ = ma;
		_tmp1917_ = vala_member_access_get_inner (_tmp1916_);
		_tmp1918_ = _tmp1917_;
		_tmp1919_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1918_, 1);
		_tmp1920_ = _tmp1919_;
		_tmp1921_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1915_, _tmp1920_, _tmp1921_);
		_vala_ccode_node_unref0 (_tmp1920_);
		_tmp1922_ = ma;
		_tmp1923_ = vala_member_access_get_inner (_tmp1922_);
		_tmp1924_ = _tmp1923_;
		_tmp1925_ = vala_expression_get_symbol_reference (_tmp1924_);
		_tmp1926_ = _tmp1925_;
		_tmp1927_ = _vala_code_node_ref0 (_tmp1926_);
		array_var = _tmp1927_;
		_tmp1928_ = array_var;
		_tmp1929_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1928_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1928_) : NULL);
		array_local = _tmp1929_;
		_tmp1932_ = array_var;
		if (_tmp1932_ != NULL) {
			ValaSymbol* _tmp1933_;
			_tmp1933_ = array_var;
			_tmp1931_ = vala_symbol_is_internal_symbol (_tmp1933_);
		} else {
			_tmp1931_ = FALSE;
		}
		if (_tmp1931_) {
			gboolean _tmp1934_ = FALSE;
			gboolean _tmp1935_ = FALSE;
			ValaSymbol* _tmp1936_;
			_tmp1936_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1936_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1937_;
				gboolean _tmp1938_;
				gboolean _tmp1939_;
				_tmp1937_ = array_local;
				_tmp1938_ = vala_local_variable_get_captured (_tmp1937_);
				_tmp1939_ = _tmp1938_;
				_tmp1935_ = !_tmp1939_;
			} else {
				_tmp1935_ = FALSE;
			}
			if (_tmp1935_) {
				_tmp1934_ = TRUE;
			} else {
				ValaSymbol* _tmp1940_;
				_tmp1940_ = array_var;
				_tmp1934_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1940_, VALA_TYPE_FIELD);
			}
			_tmp1930_ = _tmp1934_;
		} else {
			_tmp1930_ = FALSE;
		}
		if (_tmp1930_) {
			ValaCCodeFunction* _tmp1941_;
			ValaCCodeFunction* _tmp1942_;
			ValaMemberAccess* _tmp1943_;
			ValaExpression* _tmp1944_;
			ValaExpression* _tmp1945_;
			ValaTargetValue* _tmp1946_;
			ValaTargetValue* _tmp1947_;
			ValaCCodeExpression* _tmp1948_;
			ValaCCodeExpression* _tmp1949_;
			_tmp1941_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1942_ = _tmp1941_;
			_tmp1943_ = ma;
			_tmp1944_ = vala_member_access_get_inner (_tmp1943_);
			_tmp1945_ = _tmp1944_;
			_tmp1946_ = vala_expression_get_target_value (_tmp1945_);
			_tmp1947_ = _tmp1946_;
			_tmp1948_ = vala_get_array_size_cvalue (_tmp1947_);
			_tmp1949_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1942_, _tmp1948_, _tmp1949_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1951_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1952_ = _tmp1951_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1952_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1953_;
		ValaDataType* _tmp1954_;
		_tmp1953_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1954_ = _tmp1953_;
		_tmp1950_ = !vala_data_type_is_disposable (_tmp1954_);
	} else {
		_tmp1950_ = FALSE;
	}
	if (_tmp1950_) {
		gboolean _tmp1955_ = FALSE;
		ValaCCodeExpression* _tmp1956_;
		_tmp1956_ = ccall_expr;
		if (_tmp1956_ != NULL) {
			_tmp1955_ = !return_result_via_out_param;
		} else {
			_tmp1955_ = FALSE;
		}
		if (_tmp1955_) {
			ValaCCodeFunction* _tmp1957_;
			ValaCCodeFunction* _tmp1958_;
			ValaCCodeExpression* _tmp1959_;
			_tmp1957_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1958_ = _tmp1957_;
			_tmp1959_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1958_, _tmp1959_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1960_;
		ValaDataType* _tmp1961_;
		ValaDataType* _tmp1962_;
		gboolean _tmp1963_ = FALSE;
		ValaDataType* _tmp1964_;
		ValaDataType* _tmp1965_;
		gboolean _tmp2018_ = FALSE;
		ValaMethod* _tmp2019_;
		_tmp1960_ = itype;
		_tmp1961_ = vala_data_type_get_return_type (_tmp1960_);
		_tmp1962_ = _vala_code_node_ref0 (_tmp1961_);
		result_type = _tmp1962_;
		_tmp1964_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1965_ = _tmp1964_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1965_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1966_;
			ValaDataType* _tmp1967_;
			_tmp1966_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1967_ = _tmp1966_;
			_tmp1963_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1967_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1963_ = FALSE;
		}
		if (_tmp1963_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1968_;
			ValaDataType* _tmp1969_;
			ValaTypeParameter* _tmp1970_;
			ValaTypeParameter* _tmp1971_;
			ValaTypeParameter* _tmp1972_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1973_;
			ValaSymbol* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaSymbol* _tmp1977_;
			ValaStruct* _tmp1978_;
			gboolean _tmp1979_ = FALSE;
			ValaTypeParameter* _tmp1980_;
			ValaSymbol* _tmp1981_;
			ValaSymbol* _tmp1982_;
			ValaTypeSymbol* _tmp1983_;
			gboolean _tmp1992_ = FALSE;
			gboolean _tmp1993_ = FALSE;
			ValaStruct* _tmp1994_;
			_tmp1968_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1969_ = _tmp1968_;
			_tmp1970_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1969_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = _vala_code_node_ref0 (_tmp1971_);
			type_parameter = _tmp1972_;
			_tmp1973_ = type_parameter;
			_tmp1974_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1973_);
			_tmp1975_ = _tmp1974_;
			_tmp1976_ = vala_symbol_get_parent_symbol (_tmp1975_);
			_tmp1977_ = _tmp1976_;
			_tmp1978_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1977_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1977_) : NULL);
			st = _tmp1978_;
			_tmp1980_ = type_parameter;
			_tmp1981_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1980_);
			_tmp1982_ = _tmp1981_;
			_tmp1983_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1982_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1983_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1979_ = TRUE;
			} else {
				gboolean _tmp1984_ = FALSE;
				ValaStruct* _tmp1985_;
				_tmp1985_ = st;
				if (_tmp1985_ != NULL) {
					ValaStruct* _tmp1986_;
					gchar* _tmp1987_;
					gchar* _tmp1988_;
					_tmp1986_ = st;
					_tmp1987_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1986_);
					_tmp1988_ = _tmp1987_;
					_tmp1984_ = g_strcmp0 (_tmp1988_, "va_list") == 0;
					_g_free0 (_tmp1988_);
				} else {
					_tmp1984_ = FALSE;
				}
				_tmp1979_ = _tmp1984_;
			}
			if (_tmp1979_) {
				ValaDataType* _tmp1989_;
				ValaDataType* _tmp1990_;
				ValaDataType* _tmp1991_;
				_tmp1989_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1990_ = _tmp1989_;
				_tmp1991_ = _vala_code_node_ref0 (_tmp1990_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1991_;
			}
			_tmp1994_ = st;
			if (_tmp1994_ != NULL) {
				ValaStruct* _tmp1995_;
				gchar* _tmp1996_;
				gchar* _tmp1997_;
				_tmp1995_ = st;
				_tmp1996_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1995_);
				_tmp1997_ = _tmp1996_;
				_tmp1993_ = g_strcmp0 (_tmp1997_, "va_list") == 0;
				_g_free0 (_tmp1997_);
			} else {
				_tmp1993_ = FALSE;
			}
			if (_tmp1993_) {
				ValaMemberAccess* _tmp1998_;
				const gchar* _tmp1999_;
				const gchar* _tmp2000_;
				_tmp1998_ = ma;
				_tmp1999_ = vala_member_access_get_member_name (_tmp1998_);
				_tmp2000_ = _tmp1999_;
				_tmp1992_ = g_strcmp0 (_tmp2000_, "arg") == 0;
			} else {
				_tmp1992_ = FALSE;
			}
			if (_tmp1992_) {
				gboolean _tmp2001_ = FALSE;
				ValaDataType* _tmp2002_;
				_tmp2002_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2002_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp2003_;
					ValaDelegate* _tmp2004_;
					ValaDelegate* _tmp2005_;
					gboolean _tmp2006_;
					gboolean _tmp2007_;
					_tmp2003_ = result_type;
					_tmp2004_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp2003_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp2005_ = _tmp2004_;
					_tmp2006_ = vala_delegate_get_has_target (_tmp2005_);
					_tmp2007_ = _tmp2006_;
					_tmp2001_ = _tmp2007_;
				} else {
					_tmp2001_ = FALSE;
				}
				if (_tmp2001_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2008_;
					ValaTargetValue* _tmp2009_;
					ValaGLibValue* _tmp2010_;
					ValaCCodeExpression* _tmp2011_;
					ValaGLibValue* _tmp2014_;
					ValaCCodeExpression* _tmp2015_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2008_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2009_ = _tmp2008_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2009_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2010_ = arg_value;
					_tmp2011_ = _tmp2010_->delegate_target_cvalue;
					if (_tmp2011_ == NULL) {
						ValaGLibValue* _tmp2012_;
						ValaCCodeConstant* _tmp2013_;
						_tmp2012_ = arg_value;
						_tmp2013_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2012_->delegate_target_cvalue);
						_tmp2012_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2013_;
					}
					_tmp2014_ = arg_value;
					_tmp2015_ = _tmp2014_->delegate_target_destroy_notify_cvalue;
					if (_tmp2015_ == NULL) {
						ValaGLibValue* _tmp2016_;
						ValaCCodeConstant* _tmp2017_;
						_tmp2016_ = arg_value;
						_tmp2017_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2016_->delegate_target_destroy_notify_cvalue);
						_tmp2016_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2017_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2019_ = m;
		if (_tmp2019_ != NULL) {
			ValaMethod* _tmp2020_;
			_tmp2020_ = m;
			_tmp2018_ = vala_method_get_format_arg_index (_tmp2020_) >= 0;
		} else {
			_tmp2018_ = FALSE;
		}
		if (_tmp2018_) {
			ValaCCodeExpression* _tmp2021_;
			_tmp2021_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2021_);
		} else {
			gboolean _tmp2022_ = FALSE;
			ValaMethod* _tmp2023_;
			_tmp2023_ = m;
			if (_tmp2023_ != NULL) {
				ValaMethod* _tmp2024_;
				_tmp2024_ = m;
				_tmp2022_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2024_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2022_ = FALSE;
			}
			if (_tmp2022_) {
				ValaCCodeExpression* _tmp2025_;
				_tmp2025_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2025_);
			} else {
				gboolean _tmp2026_ = FALSE;
				gboolean _tmp2027_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2027_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2027_ = FALSE;
				}
				if (_tmp2027_) {
					gboolean _tmp2028_ = FALSE;
					ValaDataType* _tmp2029_;
					_tmp2029_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2029_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2030_;
						_tmp2030_ = result_type;
						_tmp2028_ = !vala_data_type_is_disposable (_tmp2030_);
					} else {
						_tmp2028_ = FALSE;
					}
					_tmp2026_ = _tmp2028_;
				} else {
					_tmp2026_ = FALSE;
				}
				if (_tmp2026_) {
					ValaCCodeExpression* _tmp2031_;
					_tmp2031_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2031_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2032_;
						ValaDataType* _tmp2033_;
						gboolean _tmp2034_;
						gboolean _tmp2035_;
						ValaLocalVariable* _tmp2036_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2037_;
						const gchar* _tmp2038_;
						const gchar* _tmp2039_;
						ValaCCodeExpression* _tmp2040_;
						ValaLocalVariable* _tmp2041_;
						ValaCCodeFunction* _tmp2042_;
						ValaCCodeFunction* _tmp2043_;
						ValaCCodeExpression* _tmp2044_;
						ValaCCodeExpression* _tmp2045_;
						ValaCCodeExpression* _tmp2046_;
						ValaTargetValue* _tmp2047_;
						ValaTargetValue* _tmp2048_;
						_tmp2032_ = result_type;
						_tmp2033_ = result_type;
						_tmp2034_ = vala_data_type_get_value_owned (_tmp2033_);
						_tmp2035_ = _tmp2034_;
						_tmp2036_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2032_, _tmp2035_, NULL, FALSE);
						temp_var = _tmp2036_;
						_tmp2037_ = temp_var;
						_tmp2038_ = vala_symbol_get_name ((ValaSymbol*) _tmp2037_);
						_tmp2039_ = _tmp2038_;
						_tmp2040_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2039_);
						temp_ref = _tmp2040_;
						_tmp2041_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2041_, FALSE);
						_tmp2042_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2043_ = _tmp2042_;
						_tmp2044_ = temp_ref;
						_tmp2045_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2043_, _tmp2044_, _tmp2045_);
						_tmp2046_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2046_);
						_tmp2047_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2048_ = _tmp2047_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2048_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2049_;
						ValaTargetValue* _tmp2050_;
						ValaTargetValue* _tmp2051_;
						_tmp2049_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2049_);
						_tmp2050_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2051_ = _tmp2050_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2051_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2052_ = params;
	_tmp2053_ = vala_iterable_iterator ((ValaIterable*) _tmp2052_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2053_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2054_;
		ValaList* _tmp2055_;
		gint _arg_size = 0;
		ValaList* _tmp2056_;
		gint _tmp2057_;
		gint _tmp2058_;
		gint _arg_index = 0;
		_tmp2054_ = vala_method_call_get_argument_list (expr);
		_tmp2055_ = _vala_iterable_ref0 (_tmp2054_);
		_arg_list = _tmp2055_;
		_tmp2056_ = _arg_list;
		_tmp2057_ = vala_collection_get_size ((ValaCollection*) _tmp2056_);
		_tmp2058_ = _tmp2057_;
		_arg_size = _tmp2058_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2059_;
			gpointer _tmp2060_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2061_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2064_;
			ValaUnaryExpression* _tmp2065_;
			gboolean _tmp2066_ = FALSE;
			ValaUnaryExpression* _tmp2067_;
			gboolean _tmp2120_ = FALSE;
			ValaUnaryExpression* _tmp2121_;
			ValaUnaryExpression* _tmp2125_;
			ValaExpression* _tmp2126_;
			ValaExpression* _tmp2127_;
			ValaDataType* _tmp2128_;
			ValaDataType* _tmp2129_;
			gboolean _tmp2139_ = FALSE;
			ValaMemberAccess* _tmp2140_;
			ValaSymbol* _tmp2141_;
			ValaSymbol* _tmp2142_;
			ValaUnaryExpression* _tmp2158_;
			ValaExpression* _tmp2159_;
			ValaExpression* _tmp2160_;
			ValaTargetValue* _tmp2161_;
			ValaTargetValue* _tmp2162_;
			ValaUnaryExpression* _tmp2163_;
			ValaTargetValue* _tmp2164_;
			ValaTargetValue* _tmp2165_;
			ValaUnaryExpression* _tmp2166_;
			ValaExpression* _tmp2167_;
			ValaExpression* _tmp2168_;
			ValaDataType* _tmp2169_;
			ValaDataType* _tmp2170_;
			ValaExpression* _tmp2171_;
			ValaTargetValue* _tmp2172_;
			ValaTargetValue* _tmp2173_;
			ValaSourceReference* _tmp2174_;
			ValaSourceReference* _tmp2175_;
			gboolean _tmp2176_ = FALSE;
			ValaParameter* _tmp2177_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2059_ = _arg_list;
			_tmp2060_ = vala_list_get (_tmp2059_, _arg_index);
			arg = (ValaExpression*) _tmp2060_;
			param = NULL;
			_tmp2061_ = params_it;
			if (vala_iterator_next (_tmp2061_)) {
				ValaIterator* _tmp2062_;
				gpointer _tmp2063_;
				_tmp2062_ = params_it;
				_tmp2063_ = vala_iterator_get (_tmp2062_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2063_;
			}
			_tmp2064_ = arg;
			_tmp2065_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2064_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2064_) : NULL);
			unary = _tmp2065_;
			_tmp2067_ = unary;
			if (_tmp2067_ != NULL) {
				ValaUnaryExpression* _tmp2068_;
				ValaUnaryOperator _tmp2069_;
				ValaUnaryOperator _tmp2070_;
				_tmp2068_ = unary;
				_tmp2069_ = vala_unary_expression_get_operator (_tmp2068_);
				_tmp2070_ = _tmp2069_;
				_tmp2066_ = _tmp2070_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2066_ = FALSE;
			}
			if (_tmp2066_) {
				gboolean _tmp2071_ = FALSE;
				gboolean _tmp2072_ = FALSE;
				gboolean _tmp2073_ = FALSE;
				ValaParameter* _tmp2074_;
				_tmp2074_ = param;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp2074_)) {
					ValaParameter* _tmp2075_;
					ValaDataType* _tmp2076_;
					ValaDataType* _tmp2077_;
					_tmp2075_ = param;
					_tmp2076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2075_);
					_tmp2077_ = _tmp2076_;
					_tmp2073_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2077_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2073_ = FALSE;
				}
				if (_tmp2073_) {
					ValaParameter* _tmp2078_;
					ValaDataType* _tmp2079_;
					ValaDataType* _tmp2080_;
					gboolean _tmp2081_;
					gboolean _tmp2082_;
					_tmp2078_ = param;
					_tmp2079_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2078_);
					_tmp2080_ = _tmp2079_;
					_tmp2081_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2080_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2082_ = _tmp2081_;
					_tmp2072_ = !_tmp2082_;
				} else {
					_tmp2072_ = FALSE;
				}
				if (_tmp2072_) {
					ValaParameter* _tmp2083_;
					ValaDataType* _tmp2084_;
					ValaDataType* _tmp2085_;
					gint _tmp2086_;
					gint _tmp2087_;
					_tmp2083_ = param;
					_tmp2084_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2083_);
					_tmp2085_ = _tmp2084_;
					_tmp2086_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2085_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2087_ = _tmp2086_;
					_tmp2071_ = _tmp2087_ == 1;
				} else {
					_tmp2071_ = FALSE;
				}
				if (_tmp2071_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2088_;
					ValaExpression* _tmp2089_;
					ValaExpression* _tmp2090_;
					ValaSymbol* _tmp2091_;
					ValaSymbol* _tmp2092_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2093_;
					gboolean _tmp2094_ = FALSE;
					gboolean _tmp2095_ = FALSE;
					ValaSymbol* _tmp2096_;
					_tmp2088_ = unary;
					_tmp2089_ = vala_unary_expression_get_inner (_tmp2088_);
					_tmp2090_ = _tmp2089_;
					_tmp2091_ = vala_expression_get_symbol_reference (_tmp2090_);
					_tmp2092_ = _tmp2091_;
					array_var = _tmp2092_;
					_tmp2093_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2093_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2093_) : NULL;
					_tmp2096_ = array_var;
					if (_tmp2096_ != NULL) {
						ValaSymbol* _tmp2097_;
						_tmp2097_ = array_var;
						_tmp2095_ = vala_symbol_is_internal_symbol (_tmp2097_);
					} else {
						_tmp2095_ = FALSE;
					}
					if (_tmp2095_) {
						gboolean _tmp2098_ = FALSE;
						gboolean _tmp2099_ = FALSE;
						ValaLocalVariable* _tmp2100_;
						_tmp2100_ = array_local;
						if (_tmp2100_ != NULL) {
							ValaLocalVariable* _tmp2101_;
							gboolean _tmp2102_;
							gboolean _tmp2103_;
							_tmp2101_ = array_local;
							_tmp2102_ = vala_local_variable_get_captured (_tmp2101_);
							_tmp2103_ = _tmp2102_;
							_tmp2099_ = !_tmp2103_;
						} else {
							_tmp2099_ = FALSE;
						}
						if (_tmp2099_) {
							_tmp2098_ = TRUE;
						} else {
							ValaSymbol* _tmp2104_;
							_tmp2104_ = array_var;
							_tmp2098_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2104_, VALA_TYPE_FIELD);
						}
						_tmp2094_ = _tmp2098_;
					} else {
						_tmp2094_ = FALSE;
					}
					if (_tmp2094_) {
						ValaCCodeFunction* _tmp2105_;
						ValaCCodeFunction* _tmp2106_;
						ValaUnaryExpression* _tmp2107_;
						ValaExpression* _tmp2108_;
						ValaExpression* _tmp2109_;
						ValaTargetValue* _tmp2110_;
						ValaTargetValue* _tmp2111_;
						ValaCCodeExpression* _tmp2112_;
						ValaUnaryExpression* _tmp2113_;
						ValaExpression* _tmp2114_;
						ValaExpression* _tmp2115_;
						ValaTargetValue* _tmp2116_;
						ValaTargetValue* _tmp2117_;
						ValaCCodeExpression* _tmp2118_;
						ValaCCodeExpression* _tmp2119_;
						_tmp2105_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2106_ = _tmp2105_;
						_tmp2107_ = unary;
						_tmp2108_ = vala_unary_expression_get_inner (_tmp2107_);
						_tmp2109_ = _tmp2108_;
						_tmp2110_ = vala_expression_get_target_value (_tmp2109_);
						_tmp2111_ = _tmp2110_;
						_tmp2112_ = vala_get_array_size_cvalue (_tmp2111_);
						_tmp2113_ = unary;
						_tmp2114_ = vala_unary_expression_get_inner (_tmp2113_);
						_tmp2115_ = _tmp2114_;
						_tmp2116_ = vala_expression_get_target_value (_tmp2115_);
						_tmp2117_ = _tmp2116_;
						_tmp2118_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2117_, 1);
						_tmp2119_ = _tmp2118_;
						vala_ccode_function_add_assignment (_tmp2106_, _tmp2112_, _tmp2119_);
						_vala_ccode_node_unref0 (_tmp2119_);
					}
				}
			}
			_tmp2121_ = unary;
			if (_tmp2121_ == NULL) {
				_tmp2120_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2122_;
				ValaUnaryOperator _tmp2123_;
				ValaUnaryOperator _tmp2124_;
				_tmp2122_ = unary;
				_tmp2123_ = vala_unary_expression_get_operator (_tmp2122_);
				_tmp2124_ = _tmp2123_;
				_tmp2120_ = _tmp2124_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2120_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2125_ = unary;
			_tmp2126_ = vala_unary_expression_get_inner (_tmp2125_);
			_tmp2127_ = _tmp2126_;
			_tmp2128_ = vala_expression_get_value_type (_tmp2127_);
			_tmp2129_ = _tmp2128_;
			if (vala_ccode_base_module_requires_destroy (_tmp2129_)) {
				ValaCCodeFunction* _tmp2130_;
				ValaCCodeFunction* _tmp2131_;
				ValaUnaryExpression* _tmp2132_;
				ValaExpression* _tmp2133_;
				ValaExpression* _tmp2134_;
				ValaTargetValue* _tmp2135_;
				ValaTargetValue* _tmp2136_;
				ValaCCodeExpression* _tmp2137_;
				ValaCCodeExpression* _tmp2138_;
				_tmp2130_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2131_ = _tmp2130_;
				_tmp2132_ = unary;
				_tmp2133_ = vala_unary_expression_get_inner (_tmp2132_);
				_tmp2134_ = _tmp2133_;
				_tmp2135_ = vala_expression_get_target_value (_tmp2134_);
				_tmp2136_ = _tmp2135_;
				_tmp2137_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2136_, FALSE);
				_tmp2138_ = _tmp2137_;
				vala_ccode_function_add_expression (_tmp2131_, _tmp2138_);
				_vala_ccode_node_unref0 (_tmp2138_);
			}
			_tmp2140_ = ma;
			_tmp2141_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2140_);
			_tmp2142_ = _tmp2141_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2142_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2143_;
				ValaTargetValue* _tmp2144_;
				ValaTargetValue* _tmp2145_;
				ValaDataType* _tmp2146_;
				ValaDataType* _tmp2147_;
				_tmp2143_ = unary;
				_tmp2144_ = vala_expression_get_target_value ((ValaExpression*) _tmp2143_);
				_tmp2145_ = _tmp2144_;
				_tmp2146_ = vala_target_value_get_value_type (_tmp2145_);
				_tmp2147_ = _tmp2146_;
				_tmp2139_ = _tmp2147_ == NULL;
			} else {
				_tmp2139_ = FALSE;
			}
			if (_tmp2139_) {
				ValaUnaryExpression* _tmp2148_;
				ValaTargetValue* _tmp2149_;
				ValaTargetValue* _tmp2150_;
				ValaUnaryExpression* _tmp2151_;
				ValaExpression* _tmp2152_;
				ValaExpression* _tmp2153_;
				ValaDataType* _tmp2154_;
				ValaDataType* _tmp2155_;
				ValaDataType* _tmp2156_;
				ValaDataType* _tmp2157_;
				_tmp2148_ = unary;
				_tmp2149_ = vala_expression_get_target_value ((ValaExpression*) _tmp2148_);
				_tmp2150_ = _tmp2149_;
				_tmp2151_ = unary;
				_tmp2152_ = vala_unary_expression_get_inner (_tmp2151_);
				_tmp2153_ = _tmp2152_;
				_tmp2154_ = vala_expression_get_value_type (_tmp2153_);
				_tmp2155_ = _tmp2154_;
				_tmp2156_ = vala_data_type_copy (_tmp2155_);
				_tmp2157_ = _tmp2156_;
				vala_target_value_set_value_type (_tmp2150_, _tmp2157_);
				_vala_code_node_unref0 (_tmp2157_);
			}
			_tmp2158_ = unary;
			_tmp2159_ = vala_unary_expression_get_inner (_tmp2158_);
			_tmp2160_ = _tmp2159_;
			_tmp2161_ = vala_expression_get_target_value (_tmp2160_);
			_tmp2162_ = _tmp2161_;
			_tmp2163_ = unary;
			_tmp2164_ = vala_expression_get_target_value ((ValaExpression*) _tmp2163_);
			_tmp2165_ = _tmp2164_;
			_tmp2166_ = unary;
			_tmp2167_ = vala_unary_expression_get_inner (_tmp2166_);
			_tmp2168_ = _tmp2167_;
			_tmp2169_ = vala_expression_get_value_type (_tmp2168_);
			_tmp2170_ = _tmp2169_;
			_tmp2171_ = arg;
			_tmp2172_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2165_, _tmp2170_, (ValaCodeNode*) _tmp2171_);
			_tmp2173_ = _tmp2172_;
			_tmp2174_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2175_ = _tmp2174_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2162_, _tmp2173_, _tmp2175_);
			_vala_target_value_unref0 (_tmp2173_);
			_tmp2177_ = param;
			if (_tmp2177_ != NULL) {
				ValaParameter* _tmp2178_;
				_tmp2178_ = param;
				_tmp2176_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2178_);
			} else {
				_tmp2176_ = FALSE;
			}
			if (_tmp2176_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2179_;
				ValaCCodeIdentifier* _tmp2180_;
				ValaCCodeFunctionCall* _tmp2181_;
				ValaCCodeFunctionCall* _tmp2182_;
				ValaCCodeFunctionCall* _tmp2183_;
				ValaUnaryExpression* _tmp2184_;
				ValaExpression* _tmp2185_;
				ValaExpression* _tmp2186_;
				ValaTargetValue* _tmp2187_;
				ValaTargetValue* _tmp2188_;
				ValaCCodeExpression* _tmp2189_;
				ValaCCodeFunction* _tmp2190_;
				ValaCCodeFunction* _tmp2191_;
				ValaUnaryExpression* _tmp2192_;
				ValaExpression* _tmp2193_;
				ValaExpression* _tmp2194_;
				ValaTargetValue* _tmp2195_;
				ValaTargetValue* _tmp2196_;
				ValaCCodeExpression* _tmp2197_;
				ValaCCodeExpression* _tmp2198_;
				ValaCCodeFunctionCall* _tmp2199_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2179_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2180_ = _tmp2179_;
				_tmp2181_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2180_);
				_tmp2182_ = _tmp2181_;
				_vala_ccode_node_unref0 (_tmp2180_);
				len_call = _tmp2182_;
				_tmp2183_ = len_call;
				_tmp2184_ = unary;
				_tmp2185_ = vala_unary_expression_get_inner (_tmp2184_);
				_tmp2186_ = _tmp2185_;
				_tmp2187_ = vala_expression_get_target_value (_tmp2186_);
				_tmp2188_ = _tmp2187_;
				_tmp2189_ = vala_get_cvalue_ (_tmp2188_);
				vala_ccode_function_call_add_argument (_tmp2183_, _tmp2189_);
				_tmp2190_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2191_ = _tmp2190_;
				_tmp2192_ = unary;
				_tmp2193_ = vala_unary_expression_get_inner (_tmp2192_);
				_tmp2194_ = _tmp2193_;
				_tmp2195_ = vala_expression_get_target_value (_tmp2194_);
				_tmp2196_ = _tmp2195_;
				_tmp2197_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2196_, 1);
				_tmp2198_ = _tmp2197_;
				_tmp2199_ = len_call;
				vala_ccode_function_add_assignment (_tmp2191_, _tmp2198_, (ValaCCodeExpression*) _tmp2199_);
				_vala_ccode_node_unref0 (_tmp2198_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2202_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2202_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2203_;
		ValaSymbol* _tmp2204_;
		ValaSymbol* _tmp2205_;
		_tmp2203_ = m;
		_tmp2204_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2203_);
		_tmp2205_ = _tmp2204_;
		_tmp2201_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2205_, VALA_TYPE_CLASS);
	} else {
		_tmp2201_ = FALSE;
	}
	if (_tmp2201_) {
		gboolean _tmp2206_ = FALSE;
		gboolean _tmp2207_ = FALSE;
		ValaClass* _tmp2208_;
		ValaClass* _tmp2209_;
		gboolean _tmp2210_;
		gboolean _tmp2211_;
		_tmp2208_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2209_ = _tmp2208_;
		_tmp2210_ = vala_class_get_is_compact (_tmp2209_);
		_tmp2211_ = _tmp2210_;
		if (_tmp2211_) {
			ValaClass* _tmp2212_;
			ValaClass* _tmp2213_;
			ValaClass* _tmp2214_;
			ValaClass* _tmp2215_;
			_tmp2212_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2213_ = _tmp2212_;
			_tmp2214_ = vala_class_get_base_class (_tmp2213_);
			_tmp2215_ = _tmp2214_;
			_tmp2207_ = _tmp2215_ != NULL;
		} else {
			_tmp2207_ = FALSE;
		}
		if (_tmp2207_) {
			_tmp2206_ = TRUE;
		} else {
			ValaClass* _tmp2216_;
			ValaClass* _tmp2217_;
			ValaClass* _tmp2218_;
			ValaClass* _tmp2219_;
			ValaClass* _tmp2220_;
			_tmp2216_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2217_ = _tmp2216_;
			_tmp2218_ = vala_class_get_base_class (_tmp2217_);
			_tmp2219_ = _tmp2218_;
			_tmp2220_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2206_ = _tmp2219_ == _tmp2220_;
		}
		_tmp2200_ = _tmp2206_;
	} else {
		_tmp2200_ = FALSE;
	}
	if (_tmp2200_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2221_;
		ValaClass* _tmp2222_;
		gchar* _tmp2223_;
		gchar* _tmp2224_;
		gchar* _tmp2225_;
		gchar* _tmp2226_;
		ValaCCodeIdentifier* _tmp2227_;
		ValaCCodeIdentifier* _tmp2228_;
		ValaCCodeFunctionCall* _tmp2229_;
		ValaCCodeFunctionCall* _tmp2230_;
		ValaCCodeFunctionCall* _tmp2231_;
		ValaCCodeExpression* _tmp2232_;
		ValaCCodeExpression* _tmp2233_;
		ValaClass* _tmp2234_;
		ValaClass* _tmp2235_;
		gboolean _tmp2236_;
		gboolean _tmp2237_;
		ValaCCodeFunction* _tmp2241_;
		ValaCCodeFunction* _tmp2242_;
		ValaCCodeFunctionCall* _tmp2243_;
		_tmp2221_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2222_ = _tmp2221_;
		_tmp2223_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2222_, NULL);
		_tmp2224_ = _tmp2223_;
		_tmp2225_ = g_strdup_printf ("%s_instance_init", _tmp2224_);
		_tmp2226_ = _tmp2225_;
		_tmp2227_ = vala_ccode_identifier_new (_tmp2226_);
		_tmp2228_ = _tmp2227_;
		_tmp2229_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2228_);
		_tmp2230_ = _tmp2229_;
		_vala_ccode_node_unref0 (_tmp2228_);
		_g_free0 (_tmp2226_);
		_g_free0 (_tmp2224_);
		cinitcall = _tmp2230_;
		_tmp2231_ = cinitcall;
		_tmp2232_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2233_ = _tmp2232_;
		vala_ccode_function_call_add_argument (_tmp2231_, _tmp2233_);
		_vala_ccode_node_unref0 (_tmp2233_);
		_tmp2234_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2235_ = _tmp2234_;
		_tmp2236_ = vala_class_get_is_compact (_tmp2235_);
		_tmp2237_ = _tmp2236_;
		if (!_tmp2237_) {
			ValaCCodeFunctionCall* _tmp2238_;
			ValaCCodeConstant* _tmp2239_;
			ValaCCodeConstant* _tmp2240_;
			_tmp2238_ = cinitcall;
			_tmp2239_ = vala_ccode_constant_new ("NULL");
			_tmp2240_ = _tmp2239_;
			vala_ccode_function_call_add_argument (_tmp2238_, (ValaCCodeExpression*) _tmp2240_);
			_vala_ccode_node_unref0 (_tmp2240_);
		}
		_tmp2241_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2242_ = _tmp2241_;
		_tmp2243_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2242_, (ValaCCodeExpression*) _tmp2243_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaEnumValue* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaEnumValue* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp25_ = _enum_value_list;
			_tmp26_ = vala_list_get (_tmp25_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp26_;
			_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = enum_value;
			_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_case (_tmp28_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = enum_value;
			_tmp37_ = vala_get_ccode_name ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_return (_tmp35_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	vala_ccode_function_close (_tmp46_);
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_constant_new ("NULL");
	_tmp50_ = _tmp49_;
	vala_ccode_function_add_return (_tmp48_, (ValaCCodeExpression*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = function;
	vala_ccode_file_add_function_declaration (_tmp51_, _tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function (_tmp53_, _tmp54_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaUnaryExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp7_) : NULL;
			_tmp9_ = unary;
			if (_tmp9_ != NULL) {
				gboolean _tmp10_ = FALSE;
				ValaUnaryExpression* _tmp11_;
				ValaUnaryOperator _tmp12_;
				ValaUnaryOperator _tmp13_;
				_tmp11_ = unary;
				_tmp12_ = vala_unary_expression_get_operator (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp10_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp14_;
					ValaUnaryOperator _tmp15_;
					ValaUnaryOperator _tmp16_;
					_tmp14_ = unary;
					_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = _tmp16_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

