/* valacodewriter.c generated by valac, the Vala compiler
 * generated from valacodewriter.vala, do not modify */

/* valacodewriter.vala
 *
 * Copyright (C) 2006-2014  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 * Copyright (C) 2014       Richard Wiedenhöft
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <stdio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_scope_unref0(var) ((var == NULL) ? NULL : (var = (vala_scope_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_unref0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_sequence_free0(var) ((var == NULL) ? NULL : (var = (g_sequence_free (var), NULL)))

struct _ValaCodeWriterPrivate {
	ValaCodeContext* context;
	FILE* stream;
	gint indent;
	gboolean bol;
	ValaScope* current_scope;
	ValaCodeWriterType type;
	gchar* override_header;
	gchar* header_to_override;
};

static gint ValaCodeWriter_private_offset;
static gpointer vala_code_writer_parent_class = NULL;
static GRegex* vala_code_writer_fix_indent_regex;
static GRegex* vala_code_writer_fix_indent_regex = NULL;

static void vala_code_writer_write_string (ValaCodeWriter* self,
                                    const gchar* s);
static void vala_code_writer_write_newline (ValaCodeWriter* self);
static void vala_code_writer_real_visit_using_directive (ValaCodeVisitor* base,
                                                  ValaUsingDirective* ns);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_code_writer_real_visit_namespace (ValaCodeVisitor* base,
                                            ValaNamespace* ns);
static void vala_code_writer_write_comment (ValaCodeWriter* self,
                                     ValaComment* comment);
static void vala_code_writer_write_attributes (ValaCodeWriter* self,
                                        ValaCodeNode* node);
static void vala_code_writer_write_indent (ValaCodeWriter* self);
static void vala_code_writer_write_identifier (ValaCodeWriter* self,
                                        const gchar* s);
static void vala_code_writer_write_begin_block (ValaCodeWriter* self);
static void vala_code_writer_visit_sorted (ValaCodeWriter* self,
                                    ValaList* symbols);
static void vala_code_writer_write_end_block (ValaCodeWriter* self);
static gchar* vala_code_writer_get_cheaders (ValaCodeWriter* self,
                                      ValaSymbol* sym);
static void vala_code_writer_real_visit_class (ValaCodeVisitor* base,
                                        ValaClass* cl);
static gboolean vala_code_writer_check_accessibility (ValaCodeWriter* self,
                                               ValaSymbol* sym);
static void vala_code_writer_write_accessibility (ValaCodeWriter* self,
                                           ValaSymbol* sym);
static void vala_code_writer_write_type_parameters (ValaCodeWriter* self,
                                             ValaList* type_params);
static void vala_code_writer_write_type (ValaCodeWriter* self,
                                  ValaDataType* type);
static gint __lambda6_ (ValaCodeWriter* self,
                 ValaSymbol* a,
                 ValaSymbol* b);
static gint ___lambda6__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static void vala_code_writer_real_visit_struct (ValaCodeVisitor* base,
                                         ValaStruct* st);
static void vala_code_writer_real_visit_interface (ValaCodeVisitor* base,
                                            ValaInterface* iface);
static void vala_code_writer_real_visit_enum (ValaCodeVisitor* base,
                                       ValaEnum* en);
static void vala_code_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                               ValaErrorDomain* edomain);
static void vala_code_writer_real_visit_constant (ValaCodeVisitor* base,
                                           ValaConstant* c);
static void vala_code_writer_write_type_suffix (ValaCodeWriter* self,
                                         ValaDataType* type);
static void vala_code_writer_real_visit_field (ValaCodeVisitor* base,
                                        ValaField* f);
static void vala_code_writer_write_error_domains (ValaCodeWriter* self,
                                           ValaList* error_domains);
static void vala_code_writer_write_params (ValaCodeWriter* self,
                                    ValaList* params);
static void vala_code_writer_real_visit_delegate (ValaCodeVisitor* base,
                                           ValaDelegate* cb);
static void vala_code_writer_write_return_type (ValaCodeWriter* self,
                                         ValaDataType* type);
static void vala_code_writer_real_visit_constructor (ValaCodeVisitor* base,
                                              ValaConstructor* c);
static void vala_code_writer_write_code_block (ValaCodeWriter* self,
                                        ValaBlock* block);
static void vala_code_writer_real_visit_method (ValaCodeVisitor* base,
                                         ValaMethod* m);
static void vala_code_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                                  ValaCreationMethod* m);
static void vala_code_writer_real_visit_property (ValaCodeVisitor* base,
                                           ValaProperty* prop);
static void vala_code_writer_write_property_accessor_accessibility (ValaCodeWriter* self,
                                                             ValaSymbol* sym);
static void vala_code_writer_real_visit_signal (ValaCodeVisitor* base,
                                         ValaSignal* sig);
static void vala_code_writer_real_visit_block (ValaCodeVisitor* base,
                                        ValaBlock* b);
static void vala_code_writer_real_visit_empty_statement (ValaCodeVisitor* base,
                                                  ValaEmptyStatement* stmt);
static void vala_code_writer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                        ValaDeclarationStatement* stmt);
static void vala_code_writer_real_visit_local_variable (ValaCodeVisitor* base,
                                                 ValaLocalVariable* local);
static void vala_code_writer_real_visit_initializer_list (ValaCodeVisitor* base,
                                                   ValaInitializerList* list);
static void vala_code_writer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                       ValaExpressionStatement* stmt);
static void vala_code_writer_real_visit_if_statement (ValaCodeVisitor* base,
                                               ValaIfStatement* stmt);
static void vala_code_writer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                   ValaSwitchStatement* stmt);
static void vala_code_writer_real_visit_switch_section (ValaCodeVisitor* base,
                                                 ValaSwitchSection* section);
static void vala_code_writer_real_visit_switch_label (ValaCodeVisitor* base,
                                               ValaSwitchLabel* label);
static void vala_code_writer_real_visit_loop (ValaCodeVisitor* base,
                                       ValaLoop* stmt);
static void vala_code_writer_real_visit_while_statement (ValaCodeVisitor* base,
                                                  ValaWhileStatement* stmt);
static void vala_code_writer_real_visit_do_statement (ValaCodeVisitor* base,
                                               ValaDoStatement* stmt);
static void vala_code_writer_real_visit_for_statement (ValaCodeVisitor* base,
                                                ValaForStatement* stmt);
static void vala_code_writer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                    ValaForeachStatement* stmt);
static void vala_code_writer_real_visit_break_statement (ValaCodeVisitor* base,
                                                  ValaBreakStatement* stmt);
static void vala_code_writer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                     ValaContinueStatement* stmt);
static void vala_code_writer_real_visit_return_statement (ValaCodeVisitor* base,
                                                   ValaReturnStatement* stmt);
static void vala_code_writer_real_visit_yield_statement (ValaCodeVisitor* base,
                                                  ValaYieldStatement* y);
static void vala_code_writer_real_visit_throw_statement (ValaCodeVisitor* base,
                                                  ValaThrowStatement* stmt);
static void vala_code_writer_real_visit_try_statement (ValaCodeVisitor* base,
                                                ValaTryStatement* stmt);
static void vala_code_writer_real_visit_catch_clause (ValaCodeVisitor* base,
                                               ValaCatchClause* clause);
static void vala_code_writer_real_visit_lock_statement (ValaCodeVisitor* base,
                                                 ValaLockStatement* stmt);
static void vala_code_writer_real_visit_delete_statement (ValaCodeVisitor* base,
                                                   ValaDeleteStatement* stmt);
static void vala_code_writer_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                            ValaArrayCreationExpression* expr);
static void vala_code_writer_real_visit_boolean_literal (ValaCodeVisitor* base,
                                                  ValaBooleanLiteral* lit);
static void vala_code_writer_real_visit_character_literal (ValaCodeVisitor* base,
                                                    ValaCharacterLiteral* lit);
static void vala_code_writer_real_visit_integer_literal (ValaCodeVisitor* base,
                                                  ValaIntegerLiteral* lit);
static void vala_code_writer_real_visit_real_literal (ValaCodeVisitor* base,
                                               ValaRealLiteral* lit);
static void vala_code_writer_real_visit_string_literal (ValaCodeVisitor* base,
                                                 ValaStringLiteral* lit);
static void vala_code_writer_real_visit_null_literal (ValaCodeVisitor* base,
                                               ValaNullLiteral* lit);
static void vala_code_writer_real_visit_member_access (ValaCodeVisitor* base,
                                                ValaMemberAccess* expr);
static void vala_code_writer_real_visit_method_call (ValaCodeVisitor* base,
                                              ValaMethodCall* expr);
static void vala_code_writer_real_visit_element_access (ValaCodeVisitor* base,
                                                 ValaElementAccess* expr);
static void vala_code_writer_real_visit_slice_expression (ValaCodeVisitor* base,
                                                   ValaSliceExpression* expr);
static void vala_code_writer_real_visit_base_access (ValaCodeVisitor* base,
                                              ValaBaseAccess* expr);
static void vala_code_writer_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                     ValaPostfixExpression* expr);
static void vala_code_writer_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                             ValaObjectCreationExpression* expr);
static void vala_code_writer_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                                    ValaSizeofExpression* expr);
static void vala_code_writer_real_visit_typeof_expression (ValaCodeVisitor* base,
                                                    ValaTypeofExpression* expr);
static void vala_code_writer_real_visit_unary_expression (ValaCodeVisitor* base,
                                                   ValaUnaryExpression* expr);
static void vala_code_writer_real_visit_cast_expression (ValaCodeVisitor* base,
                                                  ValaCastExpression* expr);
static void vala_code_writer_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                      ValaPointerIndirection* expr);
static void vala_code_writer_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                       ValaAddressofExpression* expr);
static void vala_code_writer_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                                ValaReferenceTransferExpression* expr);
static void vala_code_writer_real_visit_binary_expression (ValaCodeVisitor* base,
                                                    ValaBinaryExpression* expr);
static void vala_code_writer_real_visit_type_check (ValaCodeVisitor* base,
                                             ValaTypeCheck* expr);
static void vala_code_writer_real_visit_conditional_expression (ValaCodeVisitor* base,
                                                         ValaConditionalExpression* expr);
static void vala_code_writer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                    ValaLambdaExpression* expr);
static void vala_code_writer_real_visit_assignment (ValaCodeVisitor* base,
                                             ValaAssignment* a);
static gboolean vala_code_writer_skip_since_tag_check (ValaCodeWriter* self,
                                                ValaSymbol* sym,
                                                const gchar* since_val);
static gint ____lambda4_ (ValaCodeWriter* self,
                   ValaAttribute* a,
                   ValaAttribute* b);
static gint _____lambda4__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gint ___lambda5_ (ValaCodeWriter* self,
                  ValaAttribute* a,
                  ValaAttribute* b);
static gint ____lambda5__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void _g_free0_ (gpointer var);
static void vala_code_writer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_code_writer_get_instance_private (ValaCodeWriter* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCodeWriter_private_offset);
}

ValaCodeWriter*
vala_code_writer_construct (GType object_type,
                            ValaCodeWriterType type)
{
	ValaCodeWriter* self = NULL;
	self = (ValaCodeWriter*) vala_code_visitor_construct (object_type);
	self->priv->type = type;
	return self;
}

ValaCodeWriter*
vala_code_writer_new (ValaCodeWriterType type)
{
	return vala_code_writer_construct (VALA_TYPE_CODE_WRITER, type);
}

/**
 * Allows overriding of a specific cheader in the output
 * @param original orignal cheader to override
 * @param replacement cheader to replace original with
 */
void
vala_code_writer_set_cheader_override (ValaCodeWriter* self,
                                       const gchar* original,
                                       const gchar* replacement)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (original != NULL);
	g_return_if_fail (replacement != NULL);
	_tmp0_ = g_strdup (original);
	_g_free0 (self->priv->header_to_override);
	self->priv->header_to_override = _tmp0_;
	_tmp1_ = g_strdup (replacement);
	_g_free0 (self->priv->override_header);
	self->priv->override_header = _tmp1_;
}

/**
 * Writes the public interface of the specified code context into the
 * specified file.
 *
 * @param context  a code context
 * @param filename a relative or absolute filename
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_scope_ref0 (gpointer self)
{
	return self ? vala_scope_ref (self) : NULL;
}

void
vala_code_writer_write_file (ValaCodeWriter* self,
                             ValaCodeContext* context,
                             const gchar* filename)
{
	gboolean file_exists = FALSE;
	gchar* temp_filename = NULL;
	gchar* _tmp0_;
	ValaCodeContext* _tmp1_;
	FILE* _tmp5_;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gchar* header = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaNamespace* _tmp21_;
	ValaNamespace* _tmp22_;
	ValaScope* _tmp23_;
	ValaScope* _tmp24_;
	ValaScope* _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (filename != NULL);
	file_exists = g_file_test (filename, G_FILE_TEST_EXISTS);
	_tmp0_ = g_strdup_printf ("%s.valatmp", filename);
	temp_filename = _tmp0_;
	_tmp1_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp1_;
	if (file_exists) {
		const gchar* _tmp2_;
		FILE* _tmp3_;
		_tmp2_ = temp_filename;
		_tmp3_ = g_fopen (_tmp2_, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp3_;
	} else {
		FILE* _tmp4_;
		_tmp4_ = g_fopen (filename, "w");
		_fclose0 (self->priv->stream);
		self->priv->stream = _tmp4_;
	}
	_tmp5_ = self->priv->stream;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup_printf ("unable to open `%s' for writing", filename);
		_tmp7_ = _tmp6_;
		vala_report_error (NULL, _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (temp_filename);
		return;
	}
	_tmp9_ = vala_code_context_get_version_header (context);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = g_path_get_basename (filename);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_get_prgname ();
		_tmp14_ = g_strdup_printf ("/* %s generated by %s %s, do not modify. */", _tmp12_, _tmp13_, VALA_BUILD_VERSION);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp14_;
		_g_free0 (_tmp12_);
	} else {
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp15_ = g_path_get_basename (filename);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_get_prgname ();
		_tmp18_ = g_strdup_printf ("/* %s generated by %s, do not modify. */", _tmp16_, _tmp17_);
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp18_;
		_g_free0 (_tmp16_);
	}
	_tmp19_ = g_strdup (_tmp8_);
	header = _tmp19_;
	_tmp20_ = header;
	vala_code_writer_write_string (self, _tmp20_);
	vala_code_writer_write_newline (self);
	vala_code_writer_write_newline (self);
	_tmp21_ = vala_code_context_get_root (context);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_symbol_get_scope ((ValaSymbol*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_scope_ref0 (_tmp24_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp25_;
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = NULL;
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
	if (file_exists) {
		gboolean changed = FALSE;
		changed = TRUE;
		{
			GMappedFile* old_file = NULL;
			GMappedFile* _tmp26_;
			GMappedFile* new_file = NULL;
			const gchar* _tmp27_;
			GMappedFile* _tmp28_;
			gsize len = 0UL;
			GMappedFile* _tmp29_;
			GMappedFile* _tmp30_;
			_tmp26_ = g_mapped_file_new (filename, FALSE, &_inner_error0_);
			old_file = _tmp26_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch4_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp8_);
				_g_free0 (temp_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp27_ = temp_filename;
			_tmp28_ = g_mapped_file_new (_tmp27_, FALSE, &_inner_error0_);
			new_file = _tmp28_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_mapped_file_unref0 (old_file);
				if (_inner_error0_->domain == G_FILE_ERROR) {
					goto __catch4_g_file_error;
				}
				_g_free0 (header);
				_g_free0 (_tmp8_);
				_g_free0 (temp_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp29_ = old_file;
			len = g_mapped_file_get_length (_tmp29_);
			_tmp30_ = new_file;
			if (len == g_mapped_file_get_length (_tmp30_)) {
				GMappedFile* _tmp31_;
				gchar* _tmp32_;
				GMappedFile* _tmp33_;
				gchar* _tmp34_;
				_tmp31_ = old_file;
				_tmp32_ = g_mapped_file_get_contents (_tmp31_);
				_tmp33_ = new_file;
				_tmp34_ = g_mapped_file_get_contents (_tmp33_);
				if (memcmp (_tmp32_, _tmp34_, len) == 0) {
					changed = FALSE;
				}
			}
			_g_mapped_file_unref0 (old_file);
			old_file = NULL;
			_g_mapped_file_unref0 (new_file);
			new_file = NULL;
			_g_mapped_file_unref0 (new_file);
			_g_mapped_file_unref0 (old_file);
		}
		goto __finally4;
		__catch4_g_file_error:
		{
			GError* e = NULL;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_g_error_free0 (e);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (header);
			_g_free0 (_tmp8_);
			_g_free0 (temp_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (changed) {
			const gchar* _tmp35_;
			_tmp35_ = temp_filename;
			g_rename (_tmp35_, filename);
		} else {
			const gchar* _tmp36_;
			_tmp36_ = temp_filename;
			g_unlink (_tmp36_);
		}
	}
	_g_free0 (header);
	_g_free0 (_tmp8_);
	_g_free0 (temp_filename);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static void
vala_code_writer_real_visit_using_directive (ValaCodeVisitor* base,
                                             ValaUsingDirective* ns)
{
	ValaCodeWriter * self;
	ValaCodeWriterType _tmp0_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->type;
	if (_tmp0_ == VALA_CODE_WRITER_TYPE_FAST) {
		GList* symbols = NULL;
		ValaUnresolvedSymbol* sym = NULL;
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		GList* _tmp13_;
		gconstpointer _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		vala_code_writer_write_string (self, "using ");
		symbols = NULL;
		_tmp1_ = vala_using_directive_get_namespace_symbol (ns);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
		sym = _tmp3_;
		_tmp4_ = sym;
		_tmp5_ = _vala_code_node_ref0 (_tmp4_);
		symbols = g_list_prepend (symbols, _tmp5_);
		while (TRUE) {
			ValaUnresolvedSymbol* _tmp6_;
			ValaUnresolvedSymbol* _tmp7_;
			ValaUnresolvedSymbol* _tmp8_;
			ValaUnresolvedSymbol* _tmp9_;
			ValaUnresolvedSymbol* _tmp10_;
			ValaUnresolvedSymbol* _tmp11_;
			ValaUnresolvedSymbol* _tmp12_;
			_tmp6_ = sym;
			_tmp7_ = vala_unresolved_symbol_get_inner (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (_tmp8_);
			_vala_code_node_unref0 (sym);
			sym = _tmp9_;
			_tmp10_ = sym;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = sym;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			symbols = g_list_prepend (symbols, _tmp12_);
		}
		_tmp13_ = symbols;
		_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) ((ValaUnresolvedSymbol*) _tmp14_));
		_tmp16_ = _tmp15_;
		vala_code_writer_write_string (self, _tmp16_);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					GList* _tmp19_;
					GList* _tmp20_;
					gconstpointer _tmp21_;
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = symbols;
					if (!(((guint) i) < g_list_length (_tmp19_))) {
						break;
					}
					vala_code_writer_write_string (self, ".");
					_tmp20_ = symbols;
					_tmp21_ = g_list_nth_data (_tmp20_, (guint) i);
					_tmp22_ = vala_symbol_get_name ((ValaSymbol*) ((ValaUnresolvedSymbol*) _tmp21_));
					_tmp23_ = _tmp22_;
					vala_code_writer_write_string (self, _tmp23_);
				}
			}
		}
		vala_code_writer_write_string (self, ";\n");
		_vala_code_node_unref0 (sym);
		(symbols == NULL) ? NULL : (symbols = (_g_list_free__vala_code_node_unref0_ (symbols), NULL));
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static void
vala_code_writer_real_visit_namespace (ValaCodeVisitor* base,
                                       ValaNamespace* ns)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaList* comments = NULL;
	ValaList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ValaScope* _tmp37_;
	ValaScope* _tmp38_;
	ValaScope* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	ValaList* _tmp42_;
	ValaList* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	ValaList* _tmp48_;
	ValaList* _tmp49_;
	ValaList* _tmp50_;
	ValaList* _tmp51_;
	ValaList* _tmp52_;
	ValaList* _tmp53_;
	ValaList* _tmp54_;
	ValaList* _tmp55_;
	ValaList* _tmp56_;
	ValaList* _tmp57_;
	ValaList* _tmp58_;
	ValaList* _tmp59_;
	ValaScope* _tmp60_;
	ValaScope* _tmp61_;
	ValaScope* _tmp62_;
	ValaScope* _tmp63_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		vala_code_node_accept_children ((ValaCodeNode*) ns, (ValaCodeVisitor*) self);
		return;
	}
	_tmp4_ = vala_namespace_get_comments (ns);
	comments = _tmp4_;
	_tmp6_ = self->priv->context;
	_tmp7_ = vala_code_context_get_vapi_comments (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		ValaList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = comments;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp11_ > 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean first = FALSE;
		ValaSourceReference* first_reference = NULL;
		first = TRUE;
		first_reference = NULL;
		{
			ValaList* _comment_list = NULL;
			ValaList* _tmp12_;
			ValaList* _tmp13_;
			gint _comment_size = 0;
			ValaList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _comment_index = 0;
			_tmp12_ = comments;
			_tmp13_ = _vala_iterable_ref0 (_tmp12_);
			_comment_list = _tmp13_;
			_tmp14_ = _comment_list;
			_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_comment_size = _tmp16_;
			_comment_index = -1;
			while (TRUE) {
				ValaComment* comment = NULL;
				ValaList* _tmp17_;
				gpointer _tmp18_;
				ValaComment* _tmp19_;
				ValaSourceReference* _tmp20_;
				ValaSourceReference* _tmp21_;
				ValaSourceFile* _tmp22_;
				ValaSourceFile* _tmp23_;
				ValaSourceFileType _tmp24_;
				ValaSourceFileType _tmp25_;
				_comment_index = _comment_index + 1;
				if (!(_comment_index < _comment_size)) {
					break;
				}
				_tmp17_ = _comment_list;
				_tmp18_ = vala_list_get (_tmp17_, _comment_index);
				comment = (ValaComment*) _tmp18_;
				_tmp19_ = comment;
				_tmp20_ = vala_comment_get_source_reference (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_source_reference_get_file (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_source_file_get_file_type (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
					if (first) {
						ValaComment* _tmp26_;
						ValaComment* _tmp27_;
						ValaSourceReference* _tmp28_;
						ValaSourceReference* _tmp29_;
						ValaSourceReference* _tmp30_;
						_tmp26_ = comment;
						vala_code_writer_write_comment (self, _tmp26_);
						first = FALSE;
						_tmp27_ = comment;
						_tmp28_ = vala_comment_get_source_reference (_tmp27_);
						_tmp29_ = _tmp28_;
						_tmp30_ = _vala_source_reference_ref0 (_tmp29_);
						_vala_source_reference_unref0 (first_reference);
						first_reference = _tmp30_;
					} else {
						ValaComment* _tmp31_;
						ValaSourceReference* _tmp32_;
						ValaSourceReference* _tmp33_;
						ValaSourceReference* _tmp34_;
						_tmp31_ = comment;
						_tmp32_ = vala_comment_get_source_reference (_tmp31_);
						_tmp33_ = _tmp32_;
						vala_report_warning (_tmp33_, "Comment describes namespace, that was already described by another com" \
"ment.");
						_tmp34_ = first_reference;
						vala_report_notice (_tmp34_, "Previous comment was here.");
					}
				}
				_vala_comment_unref0 (comment);
			}
			_vala_iterable_unref0 (_comment_list);
		}
		_vala_source_reference_unref0 (first_reference);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) ns);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "namespace ");
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp36_ = _tmp35_;
	vala_code_writer_write_identifier (self, _tmp36_);
	vala_code_writer_write_begin_block (self);
	_tmp37_ = vala_symbol_get_scope ((ValaSymbol*) ns);
	_tmp38_ = _tmp37_;
	_tmp39_ = _vala_scope_ref0 (_tmp38_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp39_;
	_tmp40_ = vala_namespace_get_namespaces (ns);
	_tmp41_ = _tmp40_;
	vala_code_writer_visit_sorted (self, _tmp41_);
	_vala_iterable_unref0 (_tmp41_);
	_tmp42_ = vala_namespace_get_classes (ns);
	_tmp43_ = _tmp42_;
	vala_code_writer_visit_sorted (self, _tmp43_);
	_vala_iterable_unref0 (_tmp43_);
	_tmp44_ = vala_namespace_get_interfaces (ns);
	_tmp45_ = _tmp44_;
	vala_code_writer_visit_sorted (self, _tmp45_);
	_vala_iterable_unref0 (_tmp45_);
	_tmp46_ = vala_namespace_get_structs (ns);
	_tmp47_ = _tmp46_;
	vala_code_writer_visit_sorted (self, _tmp47_);
	_vala_iterable_unref0 (_tmp47_);
	_tmp48_ = vala_namespace_get_enums (ns);
	_tmp49_ = _tmp48_;
	vala_code_writer_visit_sorted (self, _tmp49_);
	_vala_iterable_unref0 (_tmp49_);
	_tmp50_ = vala_namespace_get_error_domains (ns);
	_tmp51_ = _tmp50_;
	vala_code_writer_visit_sorted (self, _tmp51_);
	_vala_iterable_unref0 (_tmp51_);
	_tmp52_ = vala_namespace_get_delegates (ns);
	_tmp53_ = _tmp52_;
	vala_code_writer_visit_sorted (self, _tmp53_);
	_vala_iterable_unref0 (_tmp53_);
	_tmp54_ = vala_namespace_get_fields (ns);
	_tmp55_ = _tmp54_;
	vala_code_writer_visit_sorted (self, _tmp55_);
	_vala_iterable_unref0 (_tmp55_);
	_tmp56_ = vala_namespace_get_constants (ns);
	_tmp57_ = _tmp56_;
	vala_code_writer_visit_sorted (self, _tmp57_);
	_vala_iterable_unref0 (_tmp57_);
	_tmp58_ = vala_namespace_get_methods (ns);
	_tmp59_ = _tmp58_;
	vala_code_writer_visit_sorted (self, _tmp59_);
	_vala_iterable_unref0 (_tmp59_);
	_tmp60_ = self->priv->current_scope;
	_tmp61_ = vala_scope_get_parent_scope (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = _vala_scope_ref0 (_tmp62_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp63_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
	_vala_iterable_unref0 (comments);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static gchar*
vala_code_writer_get_cheaders (ValaCodeWriter* self,
                               ValaSymbol* sym)
{
	gchar* cheaders = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaCodeWriterType _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = g_strdup ("");
	cheaders = _tmp0_;
	_tmp2_ = self->priv->type;
	if (_tmp2_ != VALA_CODE_WRITER_TYPE_FAST) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = vala_symbol_get_external_package (sym);
		_tmp4_ = _tmp3_;
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		const gchar* _tmp34_;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "cheader_filename", NULL);
		_tmp5_ = _tmp6_;
		if (_tmp5_ == NULL) {
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("");
			_g_free0 (_tmp5_);
			_tmp5_ = _tmp7_;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (cheaders);
		cheaders = _tmp8_;
		_tmp11_ = cheaders;
		if (g_strcmp0 (_tmp11_, "") == 0) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp12_ = vala_symbol_get_parent_symbol (sym);
			_tmp13_ = _tmp12_;
			_tmp10_ = _tmp13_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaNamespace* _tmp17_;
			ValaNamespace* _tmp18_;
			_tmp14_ = vala_symbol_get_parent_symbol (sym);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_root (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_SYMBOL, ValaSymbol);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = vala_symbol_get_parent_symbol (sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_writer_get_cheaders (self, _tmp20_);
			_g_free0 (cheaders);
			cheaders = _tmp21_;
		}
		_tmp24_ = cheaders;
		if (g_strcmp0 (_tmp24_, "") == 0) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
			_tmp26_ = _tmp25_;
			_tmp23_ = _tmp26_ != NULL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gboolean _tmp27_;
			gboolean _tmp28_;
			_tmp27_ = vala_symbol_get_external_package (sym);
			_tmp28_ = _tmp27_;
			_tmp22_ = !_tmp28_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaSourceReference* _tmp29_;
			ValaSourceReference* _tmp30_;
			ValaSourceFile* _tmp31_;
			ValaSourceFile* _tmp32_;
			gchar* _tmp33_;
			_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_source_reference_get_file (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_source_file_get_cinclude_filename (_tmp32_);
			_g_free0 (cheaders);
			cheaders = _tmp33_;
		}
		_tmp34_ = self->priv->header_to_override;
		if (_tmp34_ != NULL) {
			gchar** cheaders_array = NULL;
			const gchar* _tmp35_;
			gchar** _tmp36_;
			gchar** _tmp37_;
			gint cheaders_array_length1;
			gint _cheaders_array_size_;
			gchar** _tmp47_;
			gint _tmp47__length1;
			gchar* _tmp48_;
			_tmp35_ = cheaders;
			_tmp37_ = _tmp36_ = g_strsplit (_tmp35_, ",", 0);
			cheaders_array = _tmp37_;
			cheaders_array_length1 = _vala_array_length (_tmp36_);
			_cheaders_array_size_ = cheaders_array_length1;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp38_ = FALSE;
					_tmp38_ = TRUE;
					while (TRUE) {
						gchar** _tmp40_;
						gint _tmp40__length1;
						gchar** _tmp41_;
						gint _tmp41__length1;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						if (!_tmp38_) {
							gint _tmp39_;
							_tmp39_ = i;
							i = _tmp39_ + 1;
						}
						_tmp38_ = FALSE;
						_tmp40_ = cheaders_array;
						_tmp40__length1 = cheaders_array_length1;
						if (!(i < _tmp40__length1)) {
							break;
						}
						_tmp41_ = cheaders_array;
						_tmp41__length1 = cheaders_array_length1;
						_tmp42_ = _tmp41_[i];
						_tmp43_ = self->priv->header_to_override;
						if (g_strcmp0 (_tmp42_, _tmp43_) == 0) {
							gchar** _tmp44_;
							gint _tmp44__length1;
							const gchar* _tmp45_;
							gchar* _tmp46_;
							_tmp44_ = cheaders_array;
							_tmp44__length1 = cheaders_array_length1;
							_tmp45_ = self->priv->override_header;
							_tmp46_ = g_strdup (_tmp45_);
							_g_free0 (_tmp44_[i]);
							_tmp44_[i] = _tmp46_;
						}
					}
				}
			}
			_tmp47_ = cheaders_array;
			_tmp47__length1 = cheaders_array_length1;
			_tmp48_ = _vala_g_strjoinv (",", _tmp47_, (gint) _tmp47__length1);
			_g_free0 (cheaders);
			cheaders = _tmp48_;
			cheaders_array = (_vala_array_free (cheaders_array, cheaders_array_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (_tmp5_);
	}
	result = cheaders;
	return result;
}

static void
vala_code_writer_real_visit_class (ValaCodeVisitor* base,
                                   ValaClass* cl)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	ValaList* base_types = NULL;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	ValaScope* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	ValaList* _tmp33_;
	ValaList* _tmp34_;
	ValaList* _tmp35_;
	ValaList* _tmp36_;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	ValaList* _tmp42_;
	ValaList* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	ValaList* _tmp48_;
	ValaConstructor* _tmp49_;
	ValaConstructor* _tmp50_;
	ValaScope* _tmp53_;
	ValaScope* _tmp54_;
	ValaScope* _tmp55_;
	ValaScope* _tmp56_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) cl)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) cl);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) cl);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) cl);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) cl);
	_tmp10_ = vala_class_get_is_abstract (cl);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		vala_code_writer_write_string (self, "abstract ");
	}
	vala_code_writer_write_string (self, "class ");
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_identifier (self, _tmp13_);
	_tmp14_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl);
	_tmp15_ = _tmp14_;
	vala_code_writer_write_type_parameters (self, _tmp15_);
	_vala_iterable_unref0 (_tmp15_);
	_tmp16_ = vala_class_get_base_types (cl);
	base_types = _tmp16_;
	_tmp17_ = base_types;
	_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ > 0) {
		gboolean first = FALSE;
		vala_code_writer_write_string (self, " : ");
		first = TRUE;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp20_;
			ValaList* _tmp21_;
			gint _base_type_size = 0;
			ValaList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _base_type_index = 0;
			_tmp20_ = base_types;
			_tmp21_ = _vala_iterable_ref0 (_tmp20_);
			_base_type_list = _tmp21_;
			_tmp22_ = _base_type_list;
			_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_base_type_size = _tmp24_;
			_base_type_index = -1;
			while (TRUE) {
				ValaDataType* base_type = NULL;
				ValaList* _tmp25_;
				gpointer _tmp26_;
				ValaDataType* _tmp27_;
				_base_type_index = _base_type_index + 1;
				if (!(_base_type_index < _base_type_size)) {
					break;
				}
				_tmp25_ = _base_type_list;
				_tmp26_ = vala_list_get (_tmp25_, _base_type_index);
				base_type = (ValaDataType*) _tmp26_;
				if (!first) {
					vala_code_writer_write_string (self, ", ");
				} else {
					first = FALSE;
				}
				_tmp27_ = base_type;
				vala_code_writer_write_type (self, _tmp27_);
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	vala_code_writer_write_begin_block (self);
	_tmp28_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp29_ = _tmp28_;
	_tmp30_ = _vala_scope_ref0 (_tmp29_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp30_;
	_tmp31_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) cl);
	_tmp32_ = _tmp31_;
	vala_code_writer_visit_sorted (self, _tmp32_);
	_vala_iterable_unref0 (_tmp32_);
	_tmp33_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) cl);
	_tmp34_ = _tmp33_;
	vala_code_writer_visit_sorted (self, _tmp34_);
	_vala_iterable_unref0 (_tmp34_);
	_tmp35_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) cl);
	_tmp36_ = _tmp35_;
	vala_code_writer_visit_sorted (self, _tmp36_);
	_vala_iterable_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) cl);
	_tmp38_ = _tmp37_;
	vala_code_writer_visit_sorted (self, _tmp38_);
	_vala_iterable_unref0 (_tmp38_);
	_tmp39_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) cl);
	_tmp40_ = _tmp39_;
	vala_code_writer_visit_sorted (self, _tmp40_);
	_vala_iterable_unref0 (_tmp40_);
	_tmp41_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) cl);
	_tmp42_ = _tmp41_;
	vala_code_writer_visit_sorted (self, _tmp42_);
	_vala_iterable_unref0 (_tmp42_);
	_tmp43_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
	_tmp44_ = _tmp43_;
	vala_code_writer_visit_sorted (self, _tmp44_);
	_vala_iterable_unref0 (_tmp44_);
	_tmp45_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	_tmp46_ = _tmp45_;
	vala_code_writer_visit_sorted (self, _tmp46_);
	_vala_iterable_unref0 (_tmp46_);
	_tmp47_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl);
	_tmp48_ = _tmp47_;
	vala_code_writer_visit_sorted (self, _tmp48_);
	_vala_iterable_unref0 (_tmp48_);
	_tmp49_ = vala_class_get_constructor (cl);
	_tmp50_ = _tmp49_;
	if (_tmp50_ != NULL) {
		ValaConstructor* _tmp51_;
		ValaConstructor* _tmp52_;
		_tmp51_ = vala_class_get_constructor (cl);
		_tmp52_ = _tmp51_;
		vala_code_node_accept ((ValaCodeNode*) _tmp52_, (ValaCodeVisitor*) self);
	}
	_tmp53_ = self->priv->current_scope;
	_tmp54_ = vala_scope_get_parent_scope (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _vala_scope_ref0 (_tmp55_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp56_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
	_vala_iterable_unref0 (base_types);
}

static gint
__lambda6_ (ValaCodeWriter* self,
            ValaSymbol* a,
            ValaSymbol* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = vala_symbol_get_name (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gint
___lambda6__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda6_ ((ValaCodeWriter*) self, (ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

static void
vala_code_writer_visit_sorted (ValaCodeWriter* self,
                               ValaList* symbols)
{
	gboolean _tmp0_ = FALSE;
	ValaCodeWriterType _tmp1_;
	ValaArrayList* sorted_symbols = NULL;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	ValaArrayList* _tmp12_;
	ValaArrayList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbols != NULL);
	_tmp1_ = self->priv->type;
	if (_tmp1_ != VALA_CODE_WRITER_TYPE_EXTERNAL) {
		ValaCodeWriterType _tmp2_;
		_tmp2_ = self->priv->type;
		_tmp0_ = _tmp2_ != VALA_CODE_WRITER_TYPE_VAPIGEN;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaList* _sym_list = NULL;
			ValaList* _tmp3_;
			gint _sym_size = 0;
			ValaList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _sym_index = 0;
			_tmp3_ = _vala_iterable_ref0 (symbols);
			_sym_list = _tmp3_;
			_tmp4_ = _sym_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_sym_size = _tmp6_;
			_sym_index = -1;
			while (TRUE) {
				ValaSymbol* sym = NULL;
				ValaList* _tmp7_;
				gpointer _tmp8_;
				ValaSymbol* _tmp9_;
				_sym_index = _sym_index + 1;
				if (!(_sym_index < _sym_size)) {
					break;
				}
				_tmp7_ = _sym_list;
				_tmp8_ = vala_list_get (_tmp7_, _sym_index);
				sym = (ValaSymbol*) _tmp8_;
				_tmp9_ = sym;
				vala_code_node_accept ((ValaCodeNode*) _tmp9_, (ValaCodeVisitor*) self);
				_vala_code_node_unref0 (sym);
			}
			_vala_iterable_unref0 (_sym_list);
		}
		return;
	}
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	sorted_symbols = _tmp11_;
	_tmp12_ = sorted_symbols;
	vala_collection_add_all ((ValaCollection*) _tmp12_, (ValaCollection*) symbols);
	_tmp13_ = sorted_symbols;
	vala_list_sort ((ValaList*) _tmp13_, ___lambda6__gcompare_data_func, vala_code_visitor_ref (self), vala_code_visitor_unref);
	{
		ValaArrayList* _sym_list = NULL;
		ValaArrayList* _tmp14_;
		ValaArrayList* _tmp15_;
		gint _sym_size = 0;
		ValaArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _sym_index = 0;
		_tmp14_ = sorted_symbols;
		_tmp15_ = _vala_iterable_ref0 (_tmp14_);
		_sym_list = _tmp15_;
		_tmp16_ = _sym_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_sym_size = _tmp18_;
		_sym_index = -1;
		while (TRUE) {
			ValaSymbol* sym = NULL;
			ValaArrayList* _tmp19_;
			gpointer _tmp20_;
			ValaSymbol* _tmp21_;
			_sym_index = _sym_index + 1;
			if (!(_sym_index < _sym_size)) {
				break;
			}
			_tmp19_ = _sym_list;
			_tmp20_ = vala_list_get ((ValaList*) _tmp19_, _sym_index);
			sym = (ValaSymbol*) _tmp20_;
			_tmp21_ = sym;
			vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_vala_iterable_unref0 (sorted_symbols);
}

static void
vala_code_writer_real_visit_struct (ValaCodeVisitor* base,
                                    ValaStruct* st)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaScope* _tmp18_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	ValaList* _tmp28_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	ValaList* _tmp33_;
	ValaScope* _tmp34_;
	ValaScope* _tmp35_;
	ValaScope* _tmp36_;
	ValaScope* _tmp37_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) st)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) st);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) st);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) st);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) st);
	vala_code_writer_write_string (self, "struct ");
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp11_ = _tmp10_;
	vala_code_writer_write_identifier (self, _tmp11_);
	_tmp12_ = vala_struct_get_type_parameters (st);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_type_parameters (self, _tmp13_);
	_vala_iterable_unref0 (_tmp13_);
	_tmp14_ = vala_struct_get_base_type (st);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		vala_code_writer_write_string (self, " : ");
		_tmp16_ = vala_struct_get_base_type (st);
		_tmp17_ = _tmp16_;
		vala_code_writer_write_type (self, _tmp17_);
	}
	vala_code_writer_write_begin_block (self);
	_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) st);
	_tmp19_ = _tmp18_;
	_tmp20_ = _vala_scope_ref0 (_tmp19_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp20_;
	{
		ValaList* _field_list = NULL;
		ValaList* _tmp21_;
		gint _field_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _field_index = 0;
		_tmp21_ = vala_struct_get_fields (st);
		_field_list = _tmp21_;
		_tmp22_ = _field_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_field_size = _tmp24_;
		_field_index = -1;
		while (TRUE) {
			ValaField* field = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaField* _tmp27_;
			_field_index = _field_index + 1;
			if (!(_field_index < _field_size)) {
				break;
			}
			_tmp25_ = _field_list;
			_tmp26_ = vala_list_get (_tmp25_, _field_index);
			field = (ValaField*) _tmp26_;
			_tmp27_ = field;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (field);
		}
		_vala_iterable_unref0 (_field_list);
	}
	_tmp28_ = vala_struct_get_constants (st);
	_tmp29_ = _tmp28_;
	vala_code_writer_visit_sorted (self, _tmp29_);
	_vala_iterable_unref0 (_tmp29_);
	_tmp30_ = vala_struct_get_methods (st);
	_tmp31_ = _tmp30_;
	vala_code_writer_visit_sorted (self, _tmp31_);
	_vala_iterable_unref0 (_tmp31_);
	_tmp32_ = vala_struct_get_properties (st);
	_tmp33_ = _tmp32_;
	vala_code_writer_visit_sorted (self, _tmp33_);
	_vala_iterable_unref0 (_tmp33_);
	_tmp34_ = self->priv->current_scope;
	_tmp35_ = vala_scope_get_parent_scope (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = _vala_scope_ref0 (_tmp36_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp37_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_interface (ValaCodeVisitor* base,
                                       ValaInterface* iface)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaList* _tmp12_;
	ValaList* _tmp13_;
	ValaList* prerequisites = NULL;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ValaScope* _tmp26_;
	ValaScope* _tmp27_;
	ValaScope* _tmp28_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	ValaList* _tmp32_;
	ValaList* _tmp33_;
	ValaList* _tmp34_;
	ValaList* _tmp35_;
	ValaList* _tmp36_;
	ValaList* _tmp37_;
	ValaList* _tmp38_;
	ValaList* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	ValaList* _tmp42_;
	ValaList* _tmp43_;
	ValaList* _tmp44_;
	ValaList* _tmp45_;
	ValaList* _tmp46_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	ValaScope* _tmp50_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) iface)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) iface);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) iface);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) iface);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) iface);
	vala_code_writer_write_string (self, "interface ");
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp11_ = _tmp10_;
	vala_code_writer_write_identifier (self, _tmp11_);
	_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) iface);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_type_parameters (self, _tmp13_);
	_vala_iterable_unref0 (_tmp13_);
	_tmp14_ = vala_interface_get_prerequisites (iface);
	prerequisites = _tmp14_;
	_tmp15_ = prerequisites;
	_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		gboolean first = FALSE;
		vala_code_writer_write_string (self, " : ");
		first = TRUE;
		{
			ValaList* _prerequisite_list = NULL;
			ValaList* _tmp18_;
			ValaList* _tmp19_;
			gint _prerequisite_size = 0;
			ValaList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _prerequisite_index = 0;
			_tmp18_ = prerequisites;
			_tmp19_ = _vala_iterable_ref0 (_tmp18_);
			_prerequisite_list = _tmp19_;
			_tmp20_ = _prerequisite_list;
			_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			_prerequisite_size = _tmp22_;
			_prerequisite_index = -1;
			while (TRUE) {
				ValaDataType* prerequisite = NULL;
				ValaList* _tmp23_;
				gpointer _tmp24_;
				ValaDataType* _tmp25_;
				_prerequisite_index = _prerequisite_index + 1;
				if (!(_prerequisite_index < _prerequisite_size)) {
					break;
				}
				_tmp23_ = _prerequisite_list;
				_tmp24_ = vala_list_get (_tmp23_, _prerequisite_index);
				prerequisite = (ValaDataType*) _tmp24_;
				if (!first) {
					vala_code_writer_write_string (self, ", ");
				} else {
					first = FALSE;
				}
				_tmp25_ = prerequisite;
				vala_code_writer_write_type (self, _tmp25_);
				_vala_code_node_unref0 (prerequisite);
			}
			_vala_iterable_unref0 (_prerequisite_list);
		}
	}
	vala_code_writer_write_begin_block (self);
	_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) iface);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_scope_ref0 (_tmp27_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp28_;
	_tmp29_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) iface);
	_tmp30_ = _tmp29_;
	vala_code_writer_visit_sorted (self, _tmp30_);
	_vala_iterable_unref0 (_tmp30_);
	_tmp31_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) iface);
	_tmp32_ = _tmp31_;
	vala_code_writer_visit_sorted (self, _tmp32_);
	_vala_iterable_unref0 (_tmp32_);
	_tmp33_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) iface);
	_tmp34_ = _tmp33_;
	vala_code_writer_visit_sorted (self, _tmp34_);
	_vala_iterable_unref0 (_tmp34_);
	_tmp35_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) iface);
	_tmp36_ = _tmp35_;
	vala_code_writer_visit_sorted (self, _tmp36_);
	_vala_iterable_unref0 (_tmp36_);
	_tmp37_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) iface);
	_tmp38_ = _tmp37_;
	vala_code_writer_visit_sorted (self, _tmp38_);
	_vala_iterable_unref0 (_tmp38_);
	_tmp39_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) iface);
	_tmp40_ = _tmp39_;
	vala_code_writer_visit_sorted (self, _tmp40_);
	_vala_iterable_unref0 (_tmp40_);
	_tmp41_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface);
	_tmp42_ = _tmp41_;
	vala_code_writer_visit_sorted (self, _tmp42_);
	_vala_iterable_unref0 (_tmp42_);
	_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface);
	_tmp44_ = _tmp43_;
	vala_code_writer_visit_sorted (self, _tmp44_);
	_vala_iterable_unref0 (_tmp44_);
	_tmp45_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) iface);
	_tmp46_ = _tmp45_;
	vala_code_writer_visit_sorted (self, _tmp46_);
	_vala_iterable_unref0 (_tmp46_);
	_tmp47_ = self->priv->current_scope;
	_tmp48_ = vala_scope_get_parent_scope (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _vala_scope_ref0 (_tmp49_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp50_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
	_vala_iterable_unref0 (prerequisites);
}

static void
vala_code_writer_real_visit_enum (ValaCodeVisitor* base,
                                  ValaEnum* en)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean first = FALSE;
	ValaScope* _tmp54_;
	ValaScope* _tmp55_;
	ValaScope* _tmp56_;
	ValaScope* _tmp71_;
	ValaScope* _tmp72_;
	ValaScope* _tmp73_;
	ValaScope* _tmp74_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) en)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) en);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) en);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) en);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) en);
	vala_code_writer_write_string (self, "enum ");
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp11_ = _tmp10_;
	vala_code_writer_write_identifier (self, _tmp11_);
	vala_code_writer_write_begin_block (self);
	first = TRUE;
	{
		ValaList* _ev_list = NULL;
		ValaList* _tmp12_;
		gint _ev_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _ev_index = 0;
		_tmp12_ = vala_enum_get_values (en);
		_ev_list = _tmp12_;
		_tmp13_ = _ev_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_ev_size = _tmp15_;
		_ev_index = -1;
		while (TRUE) {
			ValaEnumValue* ev = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_ = FALSE;
			ValaCodeContext* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaEnumValue* _tmp28_;
			ValaEnumValue* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_ = FALSE;
			ValaCodeWriterType _tmp34_;
			_ev_index = _ev_index + 1;
			if (!(_ev_index < _ev_size)) {
				break;
			}
			_tmp16_ = _ev_list;
			_tmp17_ = vala_list_get (_tmp16_, _ev_index);
			ev = (ValaEnumValue*) _tmp17_;
			if (first) {
				first = FALSE;
			} else {
				vala_code_writer_write_string (self, ",");
				vala_code_writer_write_newline (self);
			}
			_tmp19_ = self->priv->context;
			_tmp20_ = vala_code_context_get_vapi_comments (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaEnumValue* _tmp22_;
				ValaComment* _tmp23_;
				ValaComment* _tmp24_;
				_tmp22_ = ev;
				_tmp23_ = vala_symbol_get_comment ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp18_ = _tmp24_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaEnumValue* _tmp25_;
				ValaComment* _tmp26_;
				ValaComment* _tmp27_;
				_tmp25_ = ev;
				_tmp26_ = vala_symbol_get_comment ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				vala_code_writer_write_comment (self, _tmp27_);
			}
			_tmp28_ = ev;
			vala_code_writer_write_attributes (self, (ValaCodeNode*) _tmp28_);
			vala_code_writer_write_indent (self);
			_tmp29_ = ev;
			_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
			_tmp31_ = _tmp30_;
			vala_code_writer_write_identifier (self, _tmp31_);
			_tmp34_ = self->priv->type;
			if (_tmp34_ == VALA_CODE_WRITER_TYPE_FAST) {
				ValaEnumValue* _tmp35_;
				ValaExpression* _tmp36_;
				ValaExpression* _tmp37_;
				_tmp35_ = ev;
				_tmp36_ = vala_constant_get_value ((ValaConstant*) _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp33_ = _tmp37_ != NULL;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				ValaEnumValue* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				_tmp38_ = ev;
				_tmp39_ = vala_constant_get_value ((ValaConstant*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp32_ = vala_expression_is_constant (_tmp40_);
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				ValaEnumValue* _tmp41_;
				ValaExpression* _tmp42_;
				ValaExpression* _tmp43_;
				vala_code_writer_write_string (self, " = ");
				_tmp41_ = ev;
				_tmp42_ = vala_constant_get_value ((ValaConstant*) _tmp41_);
				_tmp43_ = _tmp42_;
				vala_code_node_accept ((ValaCodeNode*) _tmp43_, (ValaCodeVisitor*) self);
			}
			_vala_code_node_unref0 (ev);
		}
		_vala_iterable_unref0 (_ev_list);
	}
	if (!first) {
		gboolean _tmp44_ = FALSE;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gboolean _tmp49_;
		_tmp45_ = vala_enum_get_methods (en);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_ > 0;
		_vala_iterable_unref0 (_tmp46_);
		if (_tmp49_) {
			_tmp44_ = TRUE;
		} else {
			ValaList* _tmp50_;
			ValaList* _tmp51_;
			gint _tmp52_;
			gint _tmp53_;
			_tmp50_ = vala_enum_get_constants (en);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp44_ = _tmp53_ > 0;
			_vala_iterable_unref0 (_tmp51_);
		}
		if (_tmp44_) {
			vala_code_writer_write_string (self, ";");
		}
		vala_code_writer_write_newline (self);
	}
	_tmp54_ = vala_symbol_get_scope ((ValaSymbol*) en);
	_tmp55_ = _tmp54_;
	_tmp56_ = _vala_scope_ref0 (_tmp55_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp56_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp57_;
		gint _m_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _m_index = 0;
		_tmp57_ = vala_enum_get_methods (en);
		_m_list = _tmp57_;
		_tmp58_ = _m_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_m_size = _tmp60_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaMethod* _tmp63_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp61_ = _m_list;
			_tmp62_ = vala_list_get (_tmp61_, _m_index);
			m = (ValaMethod*) _tmp62_;
			_tmp63_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp63_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp64_;
		gint _c_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _c_index = 0;
		_tmp64_ = vala_enum_get_constants (en);
		_c_list = _tmp64_;
		_tmp65_ = _c_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_c_size = _tmp67_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaConstant* _tmp70_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp68_ = _c_list;
			_tmp69_ = vala_list_get (_tmp68_, _c_index);
			c = (ValaConstant*) _tmp69_;
			_tmp70_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp71_ = self->priv->current_scope;
	_tmp72_ = vala_scope_get_parent_scope (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = _vala_scope_ref0 (_tmp73_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp74_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_error_domain (ValaCodeVisitor* base,
                                          ValaErrorDomain* edomain)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean first = FALSE;
	ValaScope* _tmp37_;
	ValaScope* _tmp38_;
	ValaScope* _tmp39_;
	ValaScope* _tmp47_;
	ValaScope* _tmp48_;
	ValaScope* _tmp49_;
	ValaScope* _tmp50_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) edomain)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) edomain);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) edomain);
	vala_code_writer_write_string (self, "errordomain ");
	_tmp10_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp11_ = _tmp10_;
	vala_code_writer_write_identifier (self, _tmp11_);
	vala_code_writer_write_begin_block (self);
	first = TRUE;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp12_;
		gint _ecode_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _ecode_index = 0;
		_tmp12_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp12_;
		_tmp13_ = _ecode_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_ecode_size = _tmp15_;
		_ecode_index = -1;
		while (TRUE) {
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			gboolean _tmp18_ = FALSE;
			ValaCodeContext* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp21_;
			ValaErrorCode* _tmp28_;
			ValaErrorCode* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_ecode_index = _ecode_index + 1;
			if (!(_ecode_index < _ecode_size)) {
				break;
			}
			_tmp16_ = _ecode_list;
			_tmp17_ = vala_list_get (_tmp16_, _ecode_index);
			ecode = (ValaErrorCode*) _tmp17_;
			if (first) {
				first = FALSE;
			} else {
				vala_code_writer_write_string (self, ",");
				vala_code_writer_write_newline (self);
			}
			_tmp19_ = self->priv->context;
			_tmp20_ = vala_code_context_get_vapi_comments (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				ValaErrorCode* _tmp22_;
				ValaComment* _tmp23_;
				ValaComment* _tmp24_;
				_tmp22_ = ecode;
				_tmp23_ = vala_symbol_get_comment ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp18_ = _tmp24_ != NULL;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaErrorCode* _tmp25_;
				ValaComment* _tmp26_;
				ValaComment* _tmp27_;
				_tmp25_ = ecode;
				_tmp26_ = vala_symbol_get_comment ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				vala_code_writer_write_comment (self, _tmp27_);
			}
			_tmp28_ = ecode;
			vala_code_writer_write_attributes (self, (ValaCodeNode*) _tmp28_);
			vala_code_writer_write_indent (self);
			_tmp29_ = ecode;
			_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
			_tmp31_ = _tmp30_;
			vala_code_writer_write_identifier (self, _tmp31_);
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	if (!first) {
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gboolean _tmp36_;
		_tmp32_ = vala_error_domain_get_methods (edomain);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = _tmp35_ > 0;
		_vala_iterable_unref0 (_tmp33_);
		if (_tmp36_) {
			vala_code_writer_write_string (self, ";");
		}
		vala_code_writer_write_newline (self);
	}
	_tmp37_ = vala_symbol_get_scope ((ValaSymbol*) edomain);
	_tmp38_ = _tmp37_;
	_tmp39_ = _vala_scope_ref0 (_tmp38_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp39_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp40_;
		gint _m_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _m_index = 0;
		_tmp40_ = vala_error_domain_get_methods (edomain);
		_m_list = _tmp40_;
		_tmp41_ = _m_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_m_size = _tmp43_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp44_;
			gpointer _tmp45_;
			ValaMethod* _tmp46_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp44_ = _m_list;
			_tmp45_ = vala_list_get (_tmp44_, _m_index);
			m = (ValaMethod*) _tmp45_;
			_tmp46_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp46_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	_tmp47_ = self->priv->current_scope;
	_tmp48_ = vala_scope_get_parent_scope (_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _vala_scope_ref0 (_tmp49_);
	_vala_scope_unref0 (self->priv->current_scope);
	self->priv->current_scope = _tmp50_;
	vala_code_writer_write_end_block (self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_constant (ValaCodeVisitor* base,
                                      ValaConstant* c)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	ValaCodeWriterType _tmp20_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) c);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) c)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) c);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) c);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) c);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) c);
	_tmp10_ = vala_symbol_get_hides ((ValaSymbol*) c);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		vala_code_writer_write_string (self, "new ");
	}
	vala_code_writer_write_string (self, "const ");
	_tmp12_ = vala_constant_get_type_reference (c);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_type (self, _tmp13_);
	vala_code_writer_write_string (self, " ");
	_tmp14_ = vala_symbol_get_name ((ValaSymbol*) c);
	_tmp15_ = _tmp14_;
	vala_code_writer_write_identifier (self, _tmp15_);
	_tmp16_ = vala_constant_get_type_reference (c);
	_tmp17_ = _tmp16_;
	vala_code_writer_write_type_suffix (self, _tmp17_);
	_tmp20_ = self->priv->type;
	if (_tmp20_ == VALA_CODE_WRITER_TYPE_FAST) {
		ValaExpression* _tmp21_;
		ValaExpression* _tmp22_;
		_tmp21_ = vala_constant_get_value (c);
		_tmp22_ = _tmp21_;
		_tmp19_ = _tmp22_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp23_ = vala_constant_get_value (c);
		_tmp24_ = _tmp23_;
		_tmp18_ = vala_expression_is_constant (_tmp24_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		vala_code_writer_write_string (self, " = ");
		_tmp25_ = vala_constant_get_value (c);
		_tmp26_ = _tmp25_;
		vala_code_node_accept ((ValaCodeNode*) _tmp26_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_field (ValaCodeVisitor* base,
                                   ValaField* f)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaMemberBinding _tmp12_;
	ValaMemberBinding _tmp13_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) f);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) f)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) f);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) f);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) f);
	_tmp10_ = vala_symbol_get_hides ((ValaSymbol*) f);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		vala_code_writer_write_string (self, "new ");
	}
	_tmp12_ = vala_field_get_binding (f);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == VALA_MEMBER_BINDING_STATIC) {
		vala_code_writer_write_string (self, "static ");
	} else {
		ValaMemberBinding _tmp14_;
		ValaMemberBinding _tmp15_;
		_tmp14_ = vala_field_get_binding (f);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == VALA_MEMBER_BINDING_CLASS) {
			vala_code_writer_write_string (self, "class ");
		}
	}
	_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp17_ = _tmp16_;
	if (vala_data_type_is_weak (_tmp17_)) {
		vala_code_writer_write_string (self, "weak ");
	}
	_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp19_ = _tmp18_;
	vala_code_writer_write_type (self, _tmp19_);
	vala_code_writer_write_string (self, " ");
	_tmp20_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp21_ = _tmp20_;
	vala_code_writer_write_identifier (self, _tmp21_);
	_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) f);
	_tmp23_ = _tmp22_;
	vala_code_writer_write_type_suffix (self, _tmp23_);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_write_error_domains (ValaCodeWriter* self,
                                      ValaList* error_domains)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_domains != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) error_domains);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		gboolean first = FALSE;
		vala_code_writer_write_string (self, " throws ");
		first = TRUE;
		{
			ValaList* _type_list = NULL;
			ValaList* _tmp2_;
			gint _type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _type_index = 0;
			_tmp2_ = _vala_iterable_ref0 (error_domains);
			_type_list = _tmp2_;
			_tmp3_ = _type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_type_size = _tmp5_;
			_type_index = -1;
			while (TRUE) {
				ValaDataType* type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaDataType* _tmp8_;
				_type_index = _type_index + 1;
				if (!(_type_index < _type_size)) {
					break;
				}
				_tmp6_ = _type_list;
				_tmp7_ = vala_list_get (_tmp6_, _type_index);
				type = (ValaDataType*) _tmp7_;
				if (!first) {
					vala_code_writer_write_string (self, ", ");
				} else {
					first = FALSE;
				}
				_tmp8_ = type;
				vala_code_writer_write_type (self, _tmp8_);
				_vala_code_node_unref0 (type);
			}
			_vala_iterable_unref0 (_type_list);
		}
	}
}

static void
vala_code_writer_write_params (ValaCodeWriter* self,
                               ValaList* params)
{
	gint i = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	vala_code_writer_write_string (self, "(");
	i = 1;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = _vala_iterable_ref0 (params);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			ValaParameter* _tmp9_;
			ValaParameter* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			ValaParameter* _tmp13_;
			ValaParameterDirection _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameter* _tmp30_;
			ValaDataType* _tmp31_;
			ValaDataType* _tmp32_;
			ValaParameter* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			ValaParameter* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaParameter* _tmp39_;
			ValaExpression* _tmp40_;
			ValaExpression* _tmp41_;
			gint _tmp45_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			if (i > 1) {
				vala_code_writer_write_string (self, ", ");
			}
			_tmp6_ = param;
			_tmp7_ = vala_parameter_get_ellipsis (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				vala_code_writer_write_string (self, "...");
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp9_ = param;
			vala_code_writer_write_attributes (self, (ValaCodeNode*) _tmp9_);
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_params_array (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				vala_code_writer_write_string (self, "params ");
			}
			_tmp13_ = param;
			_tmp14_ = vala_parameter_get_direction (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == VALA_PARAMETER_DIRECTION_IN) {
				ValaParameter* _tmp16_;
				ValaDataType* _tmp17_;
				ValaDataType* _tmp18_;
				gboolean _tmp19_;
				gboolean _tmp20_;
				_tmp16_ = param;
				_tmp17_ = vala_variable_get_variable_type ((ValaVariable*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_data_type_get_value_owned (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_) {
					vala_code_writer_write_string (self, "owned ");
				}
			} else {
				ValaParameter* _tmp21_;
				ValaParameterDirection _tmp22_;
				ValaParameterDirection _tmp23_;
				ValaParameter* _tmp27_;
				ValaDataType* _tmp28_;
				ValaDataType* _tmp29_;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_get_direction (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == VALA_PARAMETER_DIRECTION_REF) {
					vala_code_writer_write_string (self, "ref ");
				} else {
					ValaParameter* _tmp24_;
					ValaParameterDirection _tmp25_;
					ValaParameterDirection _tmp26_;
					_tmp24_ = param;
					_tmp25_ = vala_parameter_get_direction (_tmp24_);
					_tmp26_ = _tmp25_;
					if (_tmp26_ == VALA_PARAMETER_DIRECTION_OUT) {
						vala_code_writer_write_string (self, "out ");
					}
				}
				_tmp27_ = param;
				_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
				_tmp29_ = _tmp28_;
				if (vala_data_type_is_weak (_tmp29_)) {
					vala_code_writer_write_string (self, "unowned ");
				}
			}
			_tmp30_ = param;
			_tmp31_ = vala_variable_get_variable_type ((ValaVariable*) _tmp30_);
			_tmp32_ = _tmp31_;
			vala_code_writer_write_type (self, _tmp32_);
			vala_code_writer_write_string (self, " ");
			_tmp33_ = param;
			_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
			_tmp35_ = _tmp34_;
			vala_code_writer_write_identifier (self, _tmp35_);
			_tmp36_ = param;
			_tmp37_ = vala_variable_get_variable_type ((ValaVariable*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_code_writer_write_type_suffix (self, _tmp38_);
			_tmp39_ = param;
			_tmp40_ = vala_variable_get_initializer ((ValaVariable*) _tmp39_);
			_tmp41_ = _tmp40_;
			if (_tmp41_ != NULL) {
				ValaParameter* _tmp42_;
				ValaExpression* _tmp43_;
				ValaExpression* _tmp44_;
				vala_code_writer_write_string (self, " = ");
				_tmp42_ = param;
				_tmp43_ = vala_variable_get_initializer ((ValaVariable*) _tmp42_);
				_tmp44_ = _tmp43_;
				vala_code_node_accept ((ValaCodeNode*) _tmp44_, (ValaCodeVisitor*) self);
			}
			_tmp45_ = i;
			i = _tmp45_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	vala_code_writer_write_string (self, ")");
}

static void
vala_code_writer_real_visit_delegate (ValaCodeVisitor* base,
                                      ValaDelegate* cb)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaCodeContext* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaList* _tmp14_;
	ValaList* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	ValaArrayList* _tmp20_;
	ValaArrayList* _tmp21_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (cb != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) cb);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) cb)) {
		return;
	}
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_code_context_get_vapi_comments (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) cb);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaComment* _tmp8_;
		ValaComment* _tmp9_;
		_tmp8_ = vala_symbol_get_comment ((ValaSymbol*) cb);
		_tmp9_ = _tmp8_;
		vala_code_writer_write_comment (self, _tmp9_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) cb);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) cb);
	vala_code_writer_write_string (self, "delegate ");
	_tmp10_ = vala_callable_get_return_type ((ValaCallable*) cb);
	_tmp11_ = _tmp10_;
	vala_code_writer_write_return_type (self, _tmp11_);
	vala_code_writer_write_string (self, " ");
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) cb);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_identifier (self, _tmp13_);
	_tmp14_ = vala_delegate_get_type_parameters (cb);
	_tmp15_ = _tmp14_;
	vala_code_writer_write_type_parameters (self, _tmp15_);
	_vala_iterable_unref0 (_tmp15_);
	vala_code_writer_write_string (self, " ");
	_tmp16_ = vala_callable_get_parameters ((ValaCallable*) cb);
	_tmp17_ = _tmp16_;
	vala_code_writer_write_params (self, _tmp17_);
	_vala_iterable_unref0 (_tmp17_);
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	error_types = _tmp19_;
	_tmp20_ = error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) cb, (ValaCollection*) _tmp20_, NULL);
	_tmp21_ = error_types;
	vala_code_writer_write_error_domains (self, (ValaList*) _tmp21_);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
	_vala_iterable_unref0 (error_types);
}

static void
vala_code_writer_real_visit_constructor (ValaCodeVisitor* base,
                                         ValaConstructor* c)
{
	ValaCodeWriter * self;
	ValaCodeWriterType _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->type;
	if (_tmp0_ != VALA_CODE_WRITER_TYPE_DUMP) {
		return;
	}
	_tmp2_ = self->priv->context;
	_tmp3_ = vala_code_context_get_vapi_comments (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp5_ = vala_symbol_get_comment ((ValaSymbol*) c);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaComment* _tmp7_;
		ValaComment* _tmp8_;
		_tmp7_ = vala_symbol_get_comment ((ValaSymbol*) c);
		_tmp8_ = _tmp7_;
		vala_code_writer_write_comment (self, _tmp8_);
	}
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "construct");
	_tmp9_ = vala_subroutine_get_body ((ValaSubroutine*) c);
	_tmp10_ = _tmp9_;
	vala_code_writer_write_code_block (self, _tmp10_);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_method (ValaCodeVisitor* base,
                                    ValaMethod* m)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ValaCodeContext* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaList* _tmp52_;
	ValaList* _tmp53_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp54_;
	ValaArrayList* _tmp55_;
	ValaArrayList* _tmp56_;
	ValaArrayList* _tmp57_;
	ValaBlock* _tmp58_;
	ValaBlock* _tmp59_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) m)) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValaMethod* _tmp5_;
		ValaMethod* _tmp6_;
		_tmp5_ = vala_method_get_base_interface_method (m);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp7_ = vala_method_get_is_abstract (m);
			_tmp8_ = _tmp7_;
			_tmp4_ = !_tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = vala_method_get_is_virtual (m);
			_tmp10_ = _tmp9_;
			_tmp3_ = !_tmp10_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp2_ = _tmp3_;
	}
	if (_tmp2_) {
		ValaCodeWriterType _tmp11_;
		_tmp11_ = self->priv->type;
		if (_tmp11_ != VALA_CODE_WRITER_TYPE_DUMP) {
			return;
		}
	}
	_tmp13_ = self->priv->context;
	_tmp14_ = vala_code_context_get_vapi_comments (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		ValaComment* _tmp16_;
		ValaComment* _tmp17_;
		_tmp16_ = vala_symbol_get_comment ((ValaSymbol*) m);
		_tmp17_ = _tmp16_;
		_tmp12_ = _tmp17_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaComment* _tmp18_;
		ValaComment* _tmp19_;
		_tmp18_ = vala_symbol_get_comment ((ValaSymbol*) m);
		_tmp19_ = _tmp18_;
		vala_code_writer_write_comment (self, _tmp19_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) m);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) m);
	if (VALA_IS_CREATION_METHOD (m)) {
		gboolean _tmp20_;
		gboolean _tmp21_;
		ValaTypeSymbol* datatype = NULL;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp20_ = vala_method_get_coroutine (m);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			vala_code_writer_write_string (self, "async ");
		}
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
		_tmp23_ = _tmp22_;
		_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		datatype = _tmp24_;
		_tmp25_ = datatype;
		_tmp26_ = vala_symbol_get_name ((ValaSymbol*) _tmp25_);
		_tmp27_ = _tmp26_;
		vala_code_writer_write_identifier (self, _tmp27_);
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp29_ = _tmp28_;
		if (g_strcmp0 (_tmp29_, ".new") != 0) {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			vala_code_writer_write_string (self, ".");
			_tmp30_ = vala_symbol_get_name ((ValaSymbol*) m);
			_tmp31_ = _tmp30_;
			vala_code_writer_write_identifier (self, _tmp31_);
		}
		vala_code_writer_write_string (self, " ");
		_vala_code_node_unref0 (datatype);
	} else {
		gboolean _tmp32_;
		gboolean _tmp33_;
		ValaMemberBinding _tmp34_;
		ValaMemberBinding _tmp35_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaList* _tmp50_;
		ValaList* _tmp51_;
		_tmp32_ = vala_symbol_get_hides ((ValaSymbol*) m);
		_tmp33_ = _tmp32_;
		if (_tmp33_) {
			vala_code_writer_write_string (self, "new ");
		}
		_tmp34_ = vala_method_get_binding (m);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == VALA_MEMBER_BINDING_STATIC) {
			vala_code_writer_write_string (self, "static ");
		} else {
			ValaMemberBinding _tmp36_;
			ValaMemberBinding _tmp37_;
			_tmp36_ = vala_method_get_binding (m);
			_tmp37_ = _tmp36_;
			if (_tmp37_ == VALA_MEMBER_BINDING_CLASS) {
				vala_code_writer_write_string (self, "class ");
			} else {
				gboolean _tmp38_;
				gboolean _tmp39_;
				_tmp38_ = vala_method_get_is_abstract (m);
				_tmp39_ = _tmp38_;
				if (_tmp39_) {
					vala_code_writer_write_string (self, "abstract ");
				} else {
					gboolean _tmp40_;
					gboolean _tmp41_;
					_tmp40_ = vala_method_get_is_virtual (m);
					_tmp41_ = _tmp40_;
					if (_tmp41_) {
						vala_code_writer_write_string (self, "virtual ");
					} else {
						gboolean _tmp42_;
						gboolean _tmp43_;
						_tmp42_ = vala_method_get_overrides (m);
						_tmp43_ = _tmp42_;
						if (_tmp43_) {
							vala_code_writer_write_string (self, "override ");
						}
					}
				}
			}
		}
		_tmp44_ = vala_method_get_coroutine (m);
		_tmp45_ = _tmp44_;
		if (_tmp45_) {
			vala_code_writer_write_string (self, "async ");
		}
		_tmp46_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp47_ = _tmp46_;
		vala_code_writer_write_return_type (self, _tmp47_);
		vala_code_writer_write_string (self, " ");
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		vala_code_writer_write_identifier (self, _tmp49_);
		_tmp50_ = vala_method_get_type_parameters (m);
		_tmp51_ = _tmp50_;
		vala_code_writer_write_type_parameters (self, _tmp51_);
		_vala_iterable_unref0 (_tmp51_);
		vala_code_writer_write_string (self, " ");
	}
	_tmp52_ = vala_callable_get_parameters ((ValaCallable*) m);
	_tmp53_ = _tmp52_;
	vala_code_writer_write_params (self, _tmp53_);
	_vala_iterable_unref0 (_tmp53_);
	_tmp54_ = g_direct_equal;
	_tmp55_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp54_);
	error_types = _tmp55_;
	_tmp56_ = error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) m, (ValaCollection*) _tmp56_, NULL);
	_tmp57_ = error_types;
	vala_code_writer_write_error_domains (self, (ValaList*) _tmp57_);
	_tmp58_ = vala_subroutine_get_body ((ValaSubroutine*) m);
	_tmp59_ = _tmp58_;
	vala_code_writer_write_code_block (self, _tmp59_);
	vala_code_writer_write_newline (self);
	_vala_iterable_unref0 (error_types);
}

static void
vala_code_writer_real_visit_creation_method (ValaCodeVisitor* base,
                                             ValaCreationMethod* m)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}

static void
vala_code_writer_real_visit_property (ValaCodeVisitor* base,
                                      ValaProperty* prop)
{
	ValaCodeWriter * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	ValaMemberBinding _tmp19_;
	ValaMemberBinding _tmp20_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	ValaPropertyAccessor* _tmp33_;
	ValaPropertyAccessor* _tmp34_;
	ValaPropertyAccessor* _tmp49_;
	ValaPropertyAccessor* _tmp50_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (prop != NULL);
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) prop)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		ValaProperty* _tmp3_;
		ValaProperty* _tmp4_;
		_tmp3_ = vala_property_get_base_interface_property (prop);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp5_ = vala_property_get_is_abstract (prop);
			_tmp6_ = _tmp5_;
			_tmp2_ = !_tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp7_ = vala_property_get_is_virtual (prop);
			_tmp8_ = _tmp7_;
			_tmp1_ = !_tmp8_;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp10_ = self->priv->context;
	_tmp11_ = vala_code_context_get_vapi_comments (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		ValaComment* _tmp13_;
		ValaComment* _tmp14_;
		_tmp13_ = vala_symbol_get_comment ((ValaSymbol*) prop);
		_tmp14_ = _tmp13_;
		_tmp9_ = _tmp14_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaComment* _tmp15_;
		ValaComment* _tmp16_;
		_tmp15_ = vala_symbol_get_comment ((ValaSymbol*) prop);
		_tmp16_ = _tmp15_;
		vala_code_writer_write_comment (self, _tmp16_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) prop);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) prop);
	_tmp17_ = vala_symbol_get_hides ((ValaSymbol*) prop);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		vala_code_writer_write_string (self, "new ");
	}
	_tmp19_ = vala_property_get_binding (prop);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
		vala_code_writer_write_string (self, "static ");
	} else {
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp21_ = vala_property_get_is_abstract (prop);
		_tmp22_ = _tmp21_;
		if (_tmp22_) {
			vala_code_writer_write_string (self, "abstract ");
		} else {
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp23_ = vala_property_get_is_virtual (prop);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				vala_code_writer_write_string (self, "virtual ");
			} else {
				gboolean _tmp25_;
				gboolean _tmp26_;
				_tmp25_ = vala_property_get_overrides (prop);
				_tmp26_ = _tmp25_;
				if (_tmp26_) {
					vala_code_writer_write_string (self, "override ");
				}
			}
		}
	}
	_tmp27_ = vala_property_get_property_type (prop);
	_tmp28_ = _tmp27_;
	if (vala_data_type_is_weak (_tmp28_)) {
		vala_code_writer_write_string (self, "weak ");
	}
	_tmp29_ = vala_property_get_property_type (prop);
	_tmp30_ = _tmp29_;
	vala_code_writer_write_type (self, _tmp30_);
	vala_code_writer_write_string (self, " ");
	_tmp31_ = vala_symbol_get_name ((ValaSymbol*) prop);
	_tmp32_ = _tmp31_;
	vala_code_writer_write_identifier (self, _tmp32_);
	vala_code_writer_write_string (self, " {");
	_tmp33_ = vala_property_get_get_accessor (prop);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaPropertyAccessor* _tmp35_;
		ValaPropertyAccessor* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaPropertyAccessor* _tmp38_;
		ValaPropertyAccessor* _tmp39_;
		ValaPropertyAccessor* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		ValaPropertyAccessor* _tmp45_;
		ValaPropertyAccessor* _tmp46_;
		ValaBlock* _tmp47_;
		ValaBlock* _tmp48_;
		_tmp35_ = vala_property_get_get_accessor (prop);
		_tmp36_ = _tmp35_;
		vala_code_writer_write_attributes (self, (ValaCodeNode*) _tmp36_);
		_tmp37_ = vala_property_get_get_accessor (prop);
		_tmp38_ = _tmp37_;
		vala_code_writer_write_property_accessor_accessibility (self, (ValaSymbol*) _tmp38_);
		_tmp39_ = vala_property_get_get_accessor (prop);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_property_accessor_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_data_type_get_value_owned (_tmp42_);
		_tmp44_ = _tmp43_;
		if (_tmp44_) {
			vala_code_writer_write_string (self, " owned");
		}
		vala_code_writer_write_string (self, " get");
		_tmp45_ = vala_property_get_get_accessor (prop);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp46_);
		_tmp48_ = _tmp47_;
		vala_code_writer_write_code_block (self, _tmp48_);
	}
	_tmp49_ = vala_property_get_set_accessor (prop);
	_tmp50_ = _tmp49_;
	if (_tmp50_ != NULL) {
		ValaPropertyAccessor* _tmp51_;
		ValaPropertyAccessor* _tmp52_;
		ValaPropertyAccessor* _tmp53_;
		ValaPropertyAccessor* _tmp54_;
		ValaPropertyAccessor* _tmp55_;
		ValaPropertyAccessor* _tmp56_;
		ValaDataType* _tmp57_;
		ValaDataType* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		ValaPropertyAccessor* _tmp61_;
		ValaPropertyAccessor* _tmp62_;
		gboolean _tmp63_;
		gboolean _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		ValaPropertyAccessor* _tmp66_;
		gboolean _tmp67_;
		gboolean _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		ValaPropertyAccessor* _tmp70_;
		ValaBlock* _tmp71_;
		ValaBlock* _tmp72_;
		_tmp51_ = vala_property_get_set_accessor (prop);
		_tmp52_ = _tmp51_;
		vala_code_writer_write_attributes (self, (ValaCodeNode*) _tmp52_);
		_tmp53_ = vala_property_get_set_accessor (prop);
		_tmp54_ = _tmp53_;
		vala_code_writer_write_property_accessor_accessibility (self, (ValaSymbol*) _tmp54_);
		_tmp55_ = vala_property_get_set_accessor (prop);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_property_accessor_get_value_type (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_data_type_get_value_owned (_tmp58_);
		_tmp60_ = _tmp59_;
		if (_tmp60_) {
			vala_code_writer_write_string (self, " owned");
		}
		_tmp61_ = vala_property_get_set_accessor (prop);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_property_accessor_get_writable (_tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_) {
			vala_code_writer_write_string (self, " set");
		}
		_tmp65_ = vala_property_get_set_accessor (prop);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_property_accessor_get_construction (_tmp66_);
		_tmp68_ = _tmp67_;
		if (_tmp68_) {
			vala_code_writer_write_string (self, " construct");
		}
		_tmp69_ = vala_property_get_set_accessor (prop);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp70_);
		_tmp72_ = _tmp71_;
		vala_code_writer_write_code_block (self, _tmp72_);
	}
	vala_code_writer_write_string (self, " }");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_signal (ValaCodeVisitor* base,
                                    ValaSignal* sig)
{
	ValaCodeWriter * self;
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValaList* _tmp16_;
	ValaList* _tmp17_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (sig != NULL);
	if (!vala_code_writer_check_accessibility (self, (ValaSymbol*) sig)) {
		return;
	}
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_vapi_comments (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaComment* _tmp4_;
		ValaComment* _tmp5_;
		_tmp4_ = vala_symbol_get_comment ((ValaSymbol*) sig);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaComment* _tmp6_;
		ValaComment* _tmp7_;
		_tmp6_ = vala_symbol_get_comment ((ValaSymbol*) sig);
		_tmp7_ = _tmp6_;
		vala_code_writer_write_comment (self, _tmp7_);
	}
	vala_code_writer_write_attributes (self, (ValaCodeNode*) sig);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_accessibility (self, (ValaSymbol*) sig);
	_tmp8_ = vala_symbol_get_hides ((ValaSymbol*) sig);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		vala_code_writer_write_string (self, "new ");
	}
	_tmp10_ = vala_signal_get_is_virtual (sig);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		vala_code_writer_write_string (self, "virtual ");
	}
	vala_code_writer_write_string (self, "signal ");
	_tmp12_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp13_ = _tmp12_;
	vala_code_writer_write_return_type (self, _tmp13_);
	vala_code_writer_write_string (self, " ");
	_tmp14_ = vala_symbol_get_name ((ValaSymbol*) sig);
	_tmp15_ = _tmp14_;
	vala_code_writer_write_identifier (self, _tmp15_);
	vala_code_writer_write_string (self, " ");
	_tmp16_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp17_ = _tmp16_;
	vala_code_writer_write_params (self, _tmp17_);
	_vala_iterable_unref0 (_tmp17_);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_block (ValaCodeVisitor* base,
                                   ValaBlock* b)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (b != NULL);
	vala_code_writer_write_begin_block (self);
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp0_;
		gint _stmt_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _stmt_index = 0;
		_tmp0_ = vala_block_get_statements (b);
		_stmt_list = _tmp0_;
		_tmp1_ = _stmt_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_stmt_size = _tmp3_;
		_stmt_index = -1;
		while (TRUE) {
			ValaStatement* stmt = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaStatement* _tmp6_;
			_stmt_index = _stmt_index + 1;
			if (!(_stmt_index < _stmt_size)) {
				break;
			}
			_tmp4_ = _stmt_list;
			_tmp5_ = vala_list_get (_tmp4_, _stmt_index);
			stmt = (ValaStatement*) _tmp5_;
			_tmp6_ = stmt;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	vala_code_writer_write_end_block (self);
}

static void
vala_code_writer_real_visit_empty_statement (ValaCodeVisitor* base,
                                             ValaEmptyStatement* stmt)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
}

static void
vala_code_writer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                   ValaDeclarationStatement* stmt)
{
	ValaCodeWriter * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	_tmp0_ = vala_declaration_statement_get_declaration (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_local_variable (ValaCodeVisitor* base,
                                            ValaLocalVariable* local)
{
	ValaCodeWriter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (vala_data_type_is_weak (_tmp1_)) {
		vala_code_writer_write_string (self, "unowned ");
	}
	_tmp2_ = vala_variable_get_variable_type ((ValaVariable*) local);
	_tmp3_ = _tmp2_;
	vala_code_writer_write_type (self, _tmp3_);
	vala_code_writer_write_string (self, " ");
	_tmp4_ = vala_symbol_get_name ((ValaSymbol*) local);
	_tmp5_ = _tmp4_;
	vala_code_writer_write_identifier (self, _tmp5_);
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) local);
	_tmp7_ = _tmp6_;
	vala_code_writer_write_type_suffix (self, _tmp7_);
	_tmp8_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		vala_code_writer_write_string (self, " = ");
		_tmp10_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp11_ = _tmp10_;
		vala_code_node_accept ((ValaCodeNode*) _tmp11_, (ValaCodeVisitor*) self);
	}
}

static void
vala_code_writer_real_visit_initializer_list (ValaCodeVisitor* base,
                                              ValaInitializerList* list)
{
	ValaCodeWriter * self;
	gboolean first = FALSE;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (list != NULL);
	vala_code_writer_write_string (self, "{");
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = vala_initializer_list_get_initializers (list);
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaExpression* _tmp6_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp4_ = _initializer_list;
			_tmp5_ = vala_list_get (_tmp4_, _initializer_index);
			initializer = (ValaExpression*) _tmp5_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			} else {
				vala_code_writer_write_string (self, " ");
			}
			first = FALSE;
			_tmp6_ = initializer;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	vala_code_writer_write_string (self, " }");
}

static void
vala_code_writer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                  ValaExpressionStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	_tmp0_ = vala_expression_statement_get_expression (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_if_statement (ValaCodeVisitor* base,
                                          ValaIfStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBlock* _tmp2_;
	ValaBlock* _tmp3_;
	ValaBlock* _tmp4_;
	ValaBlock* _tmp5_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "if (");
	_tmp0_ = vala_if_statement_get_condition (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ")");
	_tmp2_ = vala_if_statement_get_true_statement (stmt);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	_tmp4_ = vala_if_statement_get_false_statement (stmt);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaBlock* _tmp6_;
		ValaBlock* _tmp7_;
		vala_code_writer_write_string (self, " else");
		_tmp6_ = vala_if_statement_get_false_statement (stmt);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_switch_statement (ValaCodeVisitor* base,
                                              ValaSwitchStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "switch (");
	_tmp0_ = vala_switch_statement_get_expression (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ") {");
	vala_code_writer_write_newline (self);
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp2_;
		gint _section_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _section_index = 0;
		_tmp2_ = vala_switch_statement_get_sections (stmt);
		_section_list = _tmp2_;
		_tmp3_ = _section_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_section_size = _tmp5_;
		_section_index = -1;
		while (TRUE) {
			ValaSwitchSection* section = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaSwitchSection* _tmp8_;
			_section_index = _section_index + 1;
			if (!(_section_index < _section_size)) {
				break;
			}
			_tmp6_ = _section_list;
			_tmp7_ = vala_list_get (_tmp6_, _section_index);
			section = (ValaSwitchSection*) _tmp7_;
			_tmp8_ = section;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "}");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_switch_section (ValaCodeVisitor* base,
                                            ValaSwitchSection* section)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (section != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		gint _label_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _label_index = 0;
		_tmp0_ = vala_switch_section_get_labels (section);
		_label_list = _tmp0_;
		_tmp1_ = _label_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_label_size = _tmp3_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaSwitchLabel* _tmp6_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp4_ = _label_list;
			_tmp5_ = vala_list_get (_tmp4_, _label_index);
			label = (ValaSwitchLabel*) _tmp5_;
			_tmp6_ = label;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	vala_code_visitor_visit_block ((ValaCodeVisitor*) self, (ValaBlock*) section);
}

static void
vala_code_writer_real_visit_switch_label (ValaCodeVisitor* base,
                                          ValaSwitchLabel* label)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (label != NULL);
	_tmp0_ = vala_switch_label_get_expression (label);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		vala_code_writer_write_indent (self);
		vala_code_writer_write_string (self, "case ");
		_tmp2_ = vala_switch_label_get_expression (label);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
		vala_code_writer_write_string (self, ":");
		vala_code_writer_write_newline (self);
	} else {
		vala_code_writer_write_indent (self);
		vala_code_writer_write_string (self, "default:");
		vala_code_writer_write_newline (self);
	}
}

static void
vala_code_writer_real_visit_loop (ValaCodeVisitor* base,
                                  ValaLoop* stmt)
{
	ValaCodeWriter * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "loop");
	_tmp0_ = vala_loop_get_body (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_while_statement (ValaCodeVisitor* base,
                                             ValaWhileStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBlock* _tmp2_;
	ValaBlock* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "while (");
	_tmp0_ = vala_while_statement_get_condition (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ")");
	_tmp2_ = vala_while_statement_get_body (stmt);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_do_statement (ValaCodeVisitor* base,
                                          ValaDoStatement* stmt)
{
	ValaCodeWriter * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "do");
	_tmp0_ = vala_do_statement_get_body (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "while (");
	_tmp2_ = vala_do_statement_get_condition (stmt);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ");");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_for_statement (ValaCodeVisitor* base,
                                           ValaForStatement* stmt)
{
	ValaCodeWriter * self;
	gboolean first = FALSE;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp16_;
	ValaBlock* _tmp17_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "for (");
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		gint _initializer_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _initializer_index = 0;
		_tmp0_ = vala_for_statement_get_initializer (stmt);
		_initializer_list = _tmp0_;
		_tmp1_ = _initializer_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_initializer_size = _tmp3_;
		_initializer_index = -1;
		while (TRUE) {
			ValaExpression* initializer = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaExpression* _tmp6_;
			_initializer_index = _initializer_index + 1;
			if (!(_initializer_index < _initializer_size)) {
				break;
			}
			_tmp4_ = _initializer_list;
			_tmp5_ = vala_list_get (_tmp4_, _initializer_index);
			initializer = (ValaExpression*) _tmp5_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp6_ = initializer;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	vala_code_writer_write_string (self, "; ");
	_tmp7_ = vala_for_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "; ");
	first = TRUE;
	{
		ValaList* _iterator_list = NULL;
		ValaList* _tmp9_;
		gint _iterator_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _iterator_index = 0;
		_tmp9_ = vala_for_statement_get_iterator (stmt);
		_iterator_list = _tmp9_;
		_tmp10_ = _iterator_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_iterator_size = _tmp12_;
		_iterator_index = -1;
		while (TRUE) {
			ValaExpression* iterator = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_iterator_index = _iterator_index + 1;
			if (!(_iterator_index < _iterator_size)) {
				break;
			}
			_tmp13_ = _iterator_list;
			_tmp14_ = vala_list_get (_tmp13_, _iterator_index);
			iterator = (ValaExpression*) _tmp14_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp15_ = iterator;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (iterator);
		}
		_vala_iterable_unref0 (_iterator_list);
	}
	vala_code_writer_write_string (self, ")");
	_tmp16_ = vala_for_statement_get_body (stmt);
	_tmp17_ = _tmp16_;
	vala_code_node_accept ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                               ValaForeachStatement* stmt)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
}

static void
vala_code_writer_real_visit_break_statement (ValaCodeVisitor* base,
                                             ValaBreakStatement* stmt)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "break;");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                ValaContinueStatement* stmt)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "continue;");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_return_statement (ValaCodeVisitor* base,
                                              ValaReturnStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "return");
	_tmp0_ = vala_return_statement_get_return_expression (stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		vala_code_writer_write_string (self, " ");
		_tmp2_ = vala_return_statement_get_return_expression (stmt);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_yield_statement (ValaCodeVisitor* base,
                                             ValaYieldStatement* y)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (y != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "yield");
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_throw_statement (ValaCodeVisitor* base,
                                             ValaThrowStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "throw");
	_tmp0_ = vala_throw_statement_get_error_expression (stmt);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		vala_code_writer_write_string (self, " ");
		_tmp2_ = vala_throw_statement_get_error_expression (stmt);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_try_statement (ValaCodeVisitor* base,
                                           ValaTryStatement* stmt)
{
	ValaCodeWriter * self;
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "try");
	_tmp0_ = vala_try_statement_get_body (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp2_;
		gint _clause_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _clause_index = 0;
		_tmp2_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp2_;
		_tmp3_ = _clause_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_clause_size = _tmp5_;
		_clause_index = -1;
		while (TRUE) {
			ValaCatchClause* clause = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaCatchClause* _tmp8_;
			_clause_index = _clause_index + 1;
			if (!(_clause_index < _clause_size)) {
				break;
			}
			_tmp6_ = _clause_list;
			_tmp7_ = vala_list_get (_tmp6_, _clause_index);
			clause = (ValaCatchClause*) _tmp7_;
			_tmp8_ = clause;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp9_ = vala_try_statement_get_finally_body (stmt);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaBlock* _tmp11_;
		ValaBlock* _tmp12_;
		vala_code_writer_write_string (self, " finally");
		_tmp11_ = vala_try_statement_get_finally_body (stmt);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_catch_clause (ValaCodeVisitor* base,
                                          ValaCatchClause* clause)
{
	ValaCodeWriter * self;
	gchar* _tmp0_ = NULL;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	gchar* type_name = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* var_name = NULL;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ValaBlock* _tmp17_;
	ValaBlock* _tmp18_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (clause != NULL);
	_tmp1_ = vala_catch_clause_get_error_type (clause);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("GLib.Error");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = vala_catch_clause_get_error_type (clause);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp0_);
	type_name = _tmp7_;
	_tmp9_ = vala_catch_clause_get_variable_name (clause);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == NULL) {
		_tmp8_ = "_";
	} else {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = vala_catch_clause_get_variable_name (clause);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	}
	_tmp13_ = g_strdup (_tmp8_);
	var_name = _tmp13_;
	_tmp14_ = type_name;
	_tmp15_ = g_strdup_printf (" catch (%s %s)", _tmp14_, var_name);
	_tmp16_ = _tmp15_;
	vala_code_writer_write_string (self, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = vala_catch_clause_get_body (clause);
	_tmp18_ = _tmp17_;
	vala_code_node_accept ((ValaCodeNode*) _tmp18_, (ValaCodeVisitor*) self);
	_g_free0 (var_name);
	_g_free0 (type_name);
	_g_free0 (_tmp0_);
}

static void
vala_code_writer_real_visit_lock_statement (ValaCodeVisitor* base,
                                            ValaLockStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBlock* _tmp2_;
	ValaBlock* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "lock (");
	_tmp0_ = vala_lock_statement_get_resource (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ")");
	_tmp2_ = vala_lock_statement_get_body (stmt);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		vala_code_writer_write_string (self, ";");
	} else {
		ValaBlock* _tmp4_;
		ValaBlock* _tmp5_;
		_tmp4_ = vala_lock_statement_get_body (stmt);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, (ValaCodeVisitor*) self);
	}
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_delete_statement (ValaCodeVisitor* base,
                                              ValaDeleteStatement* stmt)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "delete ");
	_tmp0_ = vala_delete_statement_get_expression (stmt);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ";");
	vala_code_writer_write_newline (self);
}

static void
vala_code_writer_real_visit_array_creation_expression (ValaCodeVisitor* base,
                                                       ValaArrayCreationExpression* expr)
{
	ValaCodeWriter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	gboolean first = FALSE;
	ValaInitializerList* _tmp9_;
	ValaInitializerList* _tmp10_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "new ");
	_tmp0_ = vala_array_creation_expression_get_element_type (expr);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_type (self, _tmp1_);
	vala_code_writer_write_string (self, "[");
	first = TRUE;
	{
		ValaList* _size_list = NULL;
		ValaList* _tmp2_;
		gint _size_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _size_index = 0;
		_tmp2_ = vala_array_creation_expression_get_sizes (expr);
		_size_list = _tmp2_;
		_tmp3_ = _size_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_size_size = _tmp5_;
		_size_index = -1;
		while (TRUE) {
			ValaExpression* size = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_size_index = _size_index + 1;
			if (!(_size_index < _size_size)) {
				break;
			}
			_tmp6_ = _size_list;
			_tmp7_ = vala_list_get (_tmp6_, _size_index);
			size = (ValaExpression*) _tmp7_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp8_ = size;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (size);
		}
		_vala_iterable_unref0 (_size_list);
	}
	vala_code_writer_write_string (self, "]");
	_tmp9_ = vala_array_creation_expression_get_initializer_list (expr);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaInitializerList* _tmp11_;
		ValaInitializerList* _tmp12_;
		vala_code_writer_write_string (self, " ");
		_tmp11_ = vala_array_creation_expression_get_initializer_list (expr);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, (ValaCodeVisitor*) self);
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
vala_code_writer_real_visit_boolean_literal (ValaCodeVisitor* base,
                                             ValaBooleanLiteral* lit)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = vala_boolean_literal_get_value (lit);
	_tmp1_ = _tmp0_;
	_tmp2_ = bool_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_code_writer_write_string (self, _tmp3_);
	_g_free0 (_tmp3_);
}

static void
vala_code_writer_real_visit_character_literal (ValaCodeVisitor* base,
                                               ValaCharacterLiteral* lit)
{
	ValaCodeWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = vala_character_literal_get_value (lit);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_string (self, _tmp1_);
}

static void
vala_code_writer_real_visit_integer_literal (ValaCodeVisitor* base,
                                             ValaIntegerLiteral* lit)
{
	ValaCodeWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = vala_integer_literal_get_value (lit);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_string (self, _tmp1_);
}

static void
vala_code_writer_real_visit_real_literal (ValaCodeVisitor* base,
                                          ValaRealLiteral* lit)
{
	ValaCodeWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = vala_real_literal_get_value (lit);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_string (self, _tmp1_);
}

static void
vala_code_writer_real_visit_string_literal (ValaCodeVisitor* base,
                                            ValaStringLiteral* lit)
{
	ValaCodeWriter * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	_tmp0_ = vala_string_literal_get_value (lit);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_string (self, _tmp1_);
}

static void
vala_code_writer_real_visit_null_literal (ValaCodeVisitor* base,
                                          ValaNullLiteral* lit)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (lit != NULL);
	vala_code_writer_write_string (self, "null");
}

static void
vala_code_writer_real_visit_member_access (ValaCodeVisitor* base,
                                           ValaMemberAccess* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_member_access_get_inner (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
		vala_code_writer_write_string (self, ".");
	}
	_tmp4_ = vala_member_access_get_member_name (expr);
	_tmp5_ = _tmp4_;
	vala_code_writer_write_identifier (self, _tmp5_);
}

static void
vala_code_writer_real_visit_method_call (ValaCodeVisitor* base,
                                         ValaMethodCall* expr)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean first = FALSE;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		vala_code_writer_write_string (self, "yield ");
	}
	_tmp2_ = vala_method_call_get_call (expr);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, " (");
	first = TRUE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp4_;
		gint _arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _arg_index = 0;
		_tmp4_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp4_;
		_tmp5_ = _arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_arg_size = _tmp7_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp10_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	vala_code_writer_write_string (self, ")");
}

static void
vala_code_writer_real_visit_element_access (ValaCodeVisitor* base,
                                            ValaElementAccess* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean first = FALSE;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_element_access_get_container (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "[");
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		gint _index_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _index_index = 0;
		_tmp2_ = vala_element_access_get_indices (expr);
		_index_list = _tmp2_;
		_tmp3_ = _index_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_index_size = _tmp5_;
		_index_index = -1;
		while (TRUE) {
			ValaExpression* index = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_index_index = _index_index + 1;
			if (!(_index_index < _index_size)) {
				break;
			}
			_tmp6_ = _index_list;
			_tmp7_ = vala_list_get (_tmp6_, _index_index);
			index = (ValaExpression*) _tmp7_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp8_ = index;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	vala_code_writer_write_string (self, "]");
}

static void
vala_code_writer_real_visit_slice_expression (ValaCodeVisitor* base,
                                              ValaSliceExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_slice_expression_get_container (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "[");
	_tmp2_ = vala_slice_expression_get_start (expr);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ":");
	_tmp4_ = vala_slice_expression_get_stop (expr);
	_tmp5_ = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) _tmp5_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "]");
}

static void
vala_code_writer_real_visit_base_access (ValaCodeVisitor* base,
                                         ValaBaseAccess* expr)
{
	ValaCodeWriter * self;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "base");
}

static void
vala_code_writer_real_visit_postfix_expression (ValaCodeVisitor* base,
                                                ValaPostfixExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_postfix_expression_get_inner (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	_tmp2_ = vala_postfix_expression_get_increment (expr);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		vala_code_writer_write_string (self, "++");
	} else {
		vala_code_writer_write_string (self, "--");
	}
}

static void
vala_code_writer_real_visit_object_creation_expression (ValaCodeVisitor* base,
                                                        ValaObjectCreationExpression* expr)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean first = FALSE;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_object_creation_expression_get_is_yield_expression (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		vala_code_writer_write_string (self, "yield ");
	}
	_tmp2_ = vala_object_creation_expression_get_struct_creation (expr);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		vala_code_writer_write_string (self, "new ");
	}
	_tmp4_ = vala_object_creation_expression_get_type_reference (expr);
	_tmp5_ = _tmp4_;
	vala_code_writer_write_type (self, _tmp5_);
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, ".new") != 0) {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		vala_code_writer_write_string (self, ".");
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		vala_code_writer_write_string (self, _tmp13_);
	}
	vala_code_writer_write_string (self, " (");
	first = TRUE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp14_;
		gint _arg_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _arg_index = 0;
		_tmp14_ = vala_object_creation_expression_get_argument_list (expr);
		_arg_list = _tmp14_;
		_tmp15_ = _arg_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_arg_size = _tmp17_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp18_;
			gpointer _tmp19_;
			ValaExpression* _tmp20_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp18_ = _arg_list;
			_tmp19_ = vala_list_get (_tmp18_, _arg_index);
			arg = (ValaExpression*) _tmp19_;
			if (!first) {
				vala_code_writer_write_string (self, ", ");
			}
			first = FALSE;
			_tmp20_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp20_, (ValaCodeVisitor*) self);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	vala_code_writer_write_string (self, ")");
}

static void
vala_code_writer_real_visit_sizeof_expression (ValaCodeVisitor* base,
                                               ValaSizeofExpression* expr)
{
	ValaCodeWriter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "sizeof (");
	_tmp0_ = vala_sizeof_expression_get_type_reference (expr);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_type (self, _tmp1_);
	vala_code_writer_write_string (self, ")");
}

static void
vala_code_writer_real_visit_typeof_expression (ValaCodeVisitor* base,
                                               ValaTypeofExpression* expr)
{
	ValaCodeWriter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "typeof (");
	_tmp0_ = vala_typeof_expression_get_type_reference (expr);
	_tmp1_ = _tmp0_;
	vala_code_writer_write_type (self, _tmp1_);
	vala_code_writer_write_string (self, ")");
}

static void
vala_code_writer_real_visit_unary_expression (ValaCodeVisitor* base,
                                              ValaUnaryExpression* expr)
{
	ValaCodeWriter * self;
	ValaUnaryOperator _tmp0_;
	ValaUnaryOperator _tmp1_;
	const gchar* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_unary_expression_get_operator (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_unary_operator_to_string (_tmp1_);
	vala_code_writer_write_string (self, _tmp2_);
	_tmp3_ = vala_unary_expression_get_inner (expr);
	_tmp4_ = _tmp3_;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_cast_expression (ValaCodeVisitor* base,
                                             ValaCastExpression* expr)
{
	ValaCodeWriter * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_cast_expression_get_is_non_null_cast (expr);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		vala_code_writer_write_string (self, "(!) ");
		_tmp2_ = vala_cast_expression_get_inner (expr);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
		return;
	}
	_tmp4_ = vala_cast_expression_get_is_silent_cast (expr);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_writer_write_string (self, "(");
		_tmp6_ = vala_cast_expression_get_type_reference (expr);
		_tmp7_ = _tmp6_;
		vala_code_writer_write_type (self, _tmp7_);
		vala_code_writer_write_string (self, ") ");
	}
	_tmp8_ = vala_cast_expression_get_inner (expr);
	_tmp9_ = _tmp8_;
	vala_code_node_accept ((ValaCodeNode*) _tmp9_, (ValaCodeVisitor*) self);
	_tmp10_ = vala_cast_expression_get_is_silent_cast (expr);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		vala_code_writer_write_string (self, " as ");
		_tmp12_ = vala_cast_expression_get_type_reference (expr);
		_tmp13_ = _tmp12_;
		vala_code_writer_write_type (self, _tmp13_);
	}
}

static void
vala_code_writer_real_visit_pointer_indirection (ValaCodeVisitor* base,
                                                 ValaPointerIndirection* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "*");
	_tmp0_ = vala_pointer_indirection_get_inner (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_addressof_expression (ValaCodeVisitor* base,
                                                  ValaAddressofExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "&");
	_tmp0_ = vala_addressof_expression_get_inner (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_reference_transfer_expression (ValaCodeVisitor* base,
                                                           ValaReferenceTransferExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "(owned) ");
	_tmp0_ = vala_reference_transfer_expression_get_inner (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_binary_expression (ValaCodeVisitor* base,
                                               ValaBinaryExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryOperator _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_binary_expression_get_left (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, " ");
	_tmp2_ = vala_binary_expression_get_operator (expr);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	vala_code_writer_write_string (self, _tmp4_);
	vala_code_writer_write_string (self, " ");
	_tmp5_ = vala_binary_expression_get_right (expr);
	_tmp6_ = _tmp5_;
	vala_code_node_accept ((ValaCodeNode*) _tmp6_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_type_check (ValaCodeVisitor* base,
                                        ValaTypeCheck* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_typecheck_get_expression (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, " is ");
	_tmp2_ = vala_typecheck_get_type_reference (expr);
	_tmp3_ = _tmp2_;
	vala_code_writer_write_type (self, _tmp3_);
}

static void
vala_code_writer_real_visit_conditional_expression (ValaCodeVisitor* base,
                                                    ValaConditionalExpression* expr)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (expr);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, "?");
	_tmp2_ = vala_conditional_expression_get_true_expression (expr);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, ":");
	_tmp4_ = vala_conditional_expression_get_false_expression (expr);
	_tmp5_ = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) _tmp5_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                               ValaLambdaExpression* expr)
{
	ValaCodeWriter * self;
	ValaList* params = NULL;
	ValaList* _tmp0_;
	gint i = 0;
	ValaBlock* _tmp18_;
	ValaBlock* _tmp19_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (expr != NULL);
	vala_code_writer_write_string (self, "(");
	_tmp0_ = vala_lambda_expression_get_parameters (expr);
	params = _tmp0_;
	i = 1;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _param_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _param_index = 0;
		_tmp1_ = params;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_param_list = _tmp2_;
		_tmp3_ = _param_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_param_size = _tmp5_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaParameter* _tmp8_;
			ValaParameterDirection _tmp9_;
			ValaParameterDirection _tmp10_;
			ValaParameter* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = vala_list_get (_tmp6_, _param_index);
			param = (ValaParameter*) _tmp7_;
			if (i > 1) {
				vala_code_writer_write_string (self, ", ");
			}
			_tmp8_ = param;
			_tmp9_ = vala_parameter_get_direction (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == VALA_PARAMETER_DIRECTION_REF) {
				vala_code_writer_write_string (self, "ref ");
			} else {
				ValaParameter* _tmp11_;
				ValaParameterDirection _tmp12_;
				ValaParameterDirection _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_direction (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_PARAMETER_DIRECTION_OUT) {
					vala_code_writer_write_string (self, "out ");
				}
			}
			_tmp14_ = param;
			_tmp15_ = vala_symbol_get_name ((ValaSymbol*) _tmp14_);
			_tmp16_ = _tmp15_;
			vala_code_writer_write_identifier (self, _tmp16_);
			_tmp17_ = i;
			i = _tmp17_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	vala_code_writer_write_string (self, ") =>");
	_tmp18_ = vala_lambda_expression_get_statement_body (expr);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaBlock* _tmp20_;
		ValaBlock* _tmp21_;
		_tmp20_ = vala_lambda_expression_get_statement_body (expr);
		_tmp21_ = _tmp20_;
		vala_code_node_accept ((ValaCodeNode*) _tmp21_, (ValaCodeVisitor*) self);
	} else {
		ValaExpression* _tmp22_;
		ValaExpression* _tmp23_;
		_tmp22_ = vala_lambda_expression_get_expression_body (expr);
		_tmp23_ = _tmp22_;
		if (_tmp23_ != NULL) {
			ValaExpression* _tmp24_;
			ValaExpression* _tmp25_;
			_tmp24_ = vala_lambda_expression_get_expression_body (expr);
			_tmp25_ = _tmp24_;
			vala_code_node_accept ((ValaCodeNode*) _tmp25_, (ValaCodeVisitor*) self);
		}
	}
	_vala_iterable_unref0 (params);
}

static void
vala_code_writer_real_visit_assignment (ValaCodeVisitor* base,
                                        ValaAssignment* a)
{
	ValaCodeWriter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaCodeWriter*) base;
	g_return_if_fail (a != NULL);
	_tmp0_ = vala_assignment_get_left (a);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, (ValaCodeVisitor*) self);
	vala_code_writer_write_string (self, " = ");
	_tmp2_ = vala_assignment_get_right (a);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_write_indent (ValaCodeWriter* self)
{
	FILE* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	if (!self->priv->bol) {
		FILE* _tmp0_;
		_tmp0_ = self->priv->stream;
		fputc ('\n', _tmp0_);
	}
	_tmp1_ = self->priv->stream;
	_tmp2_ = g_strnfill ((gsize) self->priv->indent, '\t');
	_tmp3_ = _tmp2_;
	fputs (_tmp3_, _tmp1_);
	_g_free0 (_tmp3_);
	self->priv->bol = FALSE;
}

static void
vala_code_writer_write_comment (ValaCodeWriter* self,
                                ValaComment* comment)
{
	gchar* replacement = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* fixed_content = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	{
		GRegex* _tmp0_;
		_tmp0_ = vala_code_writer_fix_indent_regex;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("\\n[\\t ]*", 0, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_code_writer_fix_indent_regex);
			vala_code_writer_fix_indent_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = g_strnfill ((gsize) self->priv->indent, '\t');
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("\n%s ", _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	replacement = _tmp7_;
	{
		gchar* _tmp8_ = NULL;
		GRegex* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp9_ = vala_code_writer_fix_indent_regex;
		_tmp10_ = vala_comment_get_content (comment);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_comment_get_content (comment);
		_tmp13_ = _tmp12_;
		_tmp14_ = strlen (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_regex_replace (_tmp9_, _tmp11_, (gssize) _tmp15_, 0, replacement, 0, &_inner_error0_);
		_tmp8_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp17_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (fixed_content);
		fixed_content = _tmp17_;
		_g_free0 (_tmp8_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (fixed_content);
		_g_free0 (replacement);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	vala_code_writer_write_indent (self);
	vala_code_writer_write_string (self, "/*");
	vala_code_writer_write_string (self, fixed_content);
	vala_code_writer_write_string (self, "*/");
	_g_free0 (fixed_content);
	_g_free0 (replacement);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_code_writer_write_identifier (ValaCodeWriter* self,
                                   const gchar* s)
{
	gchar* id = NULL;
	gint id_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	id = (gchar*) s;
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	id_length = (gint) _tmp1_;
	_tmp3_ = id;
	if (vala_scanner_get_identifier_or_keyword (_tmp3_, id_length) != VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_unichar_isdigit (string_get_char (s, (glong) 0));
	}
	if (_tmp2_) {
		FILE* _tmp4_;
		_tmp4_ = self->priv->stream;
		fputc ('@', _tmp4_);
	}
	vala_code_writer_write_string (self, s);
}

static void
vala_code_writer_write_return_type (ValaCodeWriter* self,
                                    ValaDataType* type)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (vala_data_type_is_weak (type)) {
		vala_code_writer_write_string (self, "unowned ");
	}
	vala_code_writer_write_type (self, type);
}

static void
vala_code_writer_write_type (ValaCodeWriter* self,
                             ValaDataType* type)
{
	ValaScope* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->current_scope;
	_tmp1_ = vala_data_type_to_qualified_string (type, _tmp0_);
	_tmp2_ = _tmp1_;
	vala_code_writer_write_string (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static void
vala_code_writer_write_type_suffix (ValaCodeWriter* self,
                                    ValaDataType* type)
{
	ValaArrayType* array_type = NULL;
	ValaArrayType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaArrayType* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (type) ? ((ValaArrayType*) type) : NULL);
	array_type = _tmp0_;
	_tmp2_ = array_type;
	if (_tmp2_ != NULL) {
		ValaArrayType* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = array_type;
		_tmp4_ = vala_array_type_get_fixed_length (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaArrayType* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		vala_code_writer_write_string (self, "[");
		_tmp6_ = array_type;
		_tmp7_ = vala_array_type_get_length (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_code_node_accept ((ValaCodeNode*) _tmp8_, (ValaCodeVisitor*) self);
		vala_code_writer_write_string (self, "]");
	}
	_vala_code_node_unref0 (array_type);
}

static void
vala_code_writer_write_string (ValaCodeWriter* self,
                               const gchar* s)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->stream;
	fputs (s, _tmp0_);
	self->priv->bol = FALSE;
}

static void
vala_code_writer_write_newline (ValaCodeWriter* self)
{
	FILE* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stream;
	fputc ('\n', _tmp0_);
	self->priv->bol = TRUE;
}

static void
vala_code_writer_write_code_block (ValaCodeWriter* self,
                                   ValaBlock* block)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (block == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		ValaCodeWriterType _tmp2_;
		_tmp2_ = self->priv->type;
		if (_tmp2_ != VALA_CODE_WRITER_TYPE_DUMP) {
			ValaCodeWriterType _tmp3_;
			_tmp3_ = self->priv->type;
			_tmp1_ = _tmp3_ != VALA_CODE_WRITER_TYPE_VAPIGEN;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		vala_code_writer_write_string (self, ";");
		return;
	}
	vala_code_node_accept ((ValaCodeNode*) block, (ValaCodeVisitor*) self);
}

static void
vala_code_writer_write_begin_block (ValaCodeWriter* self)
{
	FILE* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	if (!self->priv->bol) {
		FILE* _tmp0_;
		_tmp0_ = self->priv->stream;
		fputc (' ', _tmp0_);
	} else {
		vala_code_writer_write_indent (self);
	}
	_tmp1_ = self->priv->stream;
	fputc ('{', _tmp1_);
	vala_code_writer_write_newline (self);
	_tmp2_ = self->priv->indent;
	self->priv->indent = _tmp2_ + 1;
}

static void
vala_code_writer_write_end_block (ValaCodeWriter* self)
{
	gint _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->indent;
	self->priv->indent = _tmp0_ - 1;
	vala_code_writer_write_indent (self);
	_tmp1_ = self->priv->stream;
	fputc ('}', _tmp1_);
}

static gboolean
vala_code_writer_check_accessibility (ValaCodeWriter* self,
                                      ValaSymbol* sym)
{
	ValaCodeWriterType _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = self->priv->type;
	switch (_tmp0_) {
		case VALA_CODE_WRITER_TYPE_EXTERNAL:
		case VALA_CODE_WRITER_TYPE_VAPIGEN:
		{
			gboolean _tmp1_ = FALSE;
			ValaSymbolAccessibility _tmp2_;
			ValaSymbolAccessibility _tmp3_;
			_tmp2_ = vala_symbol_get_access (sym);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
				_tmp1_ = TRUE;
			} else {
				ValaSymbolAccessibility _tmp4_;
				ValaSymbolAccessibility _tmp5_;
				_tmp4_ = vala_symbol_get_access (sym);
				_tmp5_ = _tmp4_;
				_tmp1_ = _tmp5_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			result = _tmp1_;
			return result;
		}
		case VALA_CODE_WRITER_TYPE_INTERNAL:
		case VALA_CODE_WRITER_TYPE_FAST:
		{
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
			ValaSymbolAccessibility _tmp8_;
			ValaSymbolAccessibility _tmp9_;
			_tmp8_ = vala_symbol_get_access (sym);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == VALA_SYMBOL_ACCESSIBILITY_INTERNAL) {
				_tmp7_ = TRUE;
			} else {
				ValaSymbolAccessibility _tmp10_;
				ValaSymbolAccessibility _tmp11_;
				_tmp10_ = vala_symbol_get_access (sym);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
			}
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				ValaSymbolAccessibility _tmp12_;
				ValaSymbolAccessibility _tmp13_;
				_tmp12_ = vala_symbol_get_access (sym);
				_tmp13_ = _tmp12_;
				_tmp6_ = _tmp13_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			result = _tmp6_;
			return result;
		}
		case VALA_CODE_WRITER_TYPE_DUMP:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static gboolean
vala_code_writer_skip_since_tag_check (ValaCodeWriter* self,
                                       ValaSymbol* sym,
                                       const gchar* since_val)
{
	ValaSymbol* parent_symbol = NULL;
	ValaSymbol* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (since_val != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (sym);
	parent_symbol = _tmp0_;
	while (TRUE) {
		ValaSymbol* _tmp1_;
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaVersionAttribute* _tmp9_;
		ValaVersionAttribute* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp1_ = parent_symbol;
		_tmp2_ = vala_symbol_get_parent_symbol (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!(_tmp3_ != NULL)) {
			break;
		}
		_tmp4_ = parent_symbol;
		_tmp5_ = vala_symbol_get_parent_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _vala_code_node_ref0 (_tmp6_);
		_vala_code_node_unref0 (parent_symbol);
		parent_symbol = _tmp7_;
		_tmp8_ = parent_symbol;
		_tmp9_ = vala_symbol_get_version (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_version_attribute_get_since (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strcmp0 (_tmp13_, since_val) == 0;
		_g_free0 (_tmp13_);
		if (_tmp14_) {
			result = TRUE;
			_vala_code_node_unref0 (parent_symbol);
			return result;
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (parent_symbol);
	return result;
}

static gint
____lambda4_ (ValaCodeWriter* self,
              ValaAttribute* a,
              ValaAttribute* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = vala_attribute_get_name (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_attribute_get_name (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gint
_____lambda4__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ____lambda4_ ((ValaCodeWriter*) self, (ValaAttribute*) a, (ValaAttribute*) b);
	return result;
}

static gint
___lambda5_ (ValaCodeWriter* self,
             ValaAttribute* a,
             ValaAttribute* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = vala_attribute_get_name (a);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_attribute_get_name (b);
	_tmp4_ = _tmp3_;
	result = _tmp0_ (_tmp2_, _tmp4_);
	return result;
}

static gint
____lambda5__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda5_ ((ValaCodeWriter*) self, (ValaAttribute*) a, (ValaAttribute*) b);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
vala_code_writer_write_attributes (ValaCodeWriter* self,
                                   ValaCodeNode* node)
{
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaCodeWriterType _tmp4_;
	gboolean need_cheaders = FALSE;
	GSequence* attributes = NULL;
	GSequence* _tmp10_;
	GList* _tmp11_;
	gboolean _tmp17_ = FALSE;
	GSequenceIter* iter = NULL;
	GSequence* _tmp22_;
	GSequenceIter* _tmp23_;
	gboolean _tmp115_ = FALSE;
	ValaCodeWriterType _tmp116_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_SYMBOL (node) ? ((ValaSymbol*) node) : NULL);
	sym = _tmp0_;
	_tmp4_ = self->priv->type;
	if (_tmp4_ != VALA_CODE_WRITER_TYPE_FAST) {
		ValaSymbol* _tmp5_;
		_tmp5_ = sym;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaSymbol* _tmp6_;
		_tmp6_ = sym;
		_tmp2_ = !VALA_IS_NAMESPACE (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		_tmp7_ = sym;
		_tmp8_ = vala_symbol_get_parent_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp1_ = VALA_IS_NAMESPACE (_tmp9_);
	} else {
		_tmp1_ = FALSE;
	}
	need_cheaders = _tmp1_;
	_tmp10_ = g_sequence_new (_vala_code_node_unref0_);
	attributes = _tmp10_;
	_tmp11_ = node->attributes;
	{
		GList* attr_collection = NULL;
		GList* attr_it = NULL;
		attr_collection = _tmp11_;
		for (attr_it = attr_collection; attr_it != NULL; attr_it = attr_it->next) {
			ValaAttribute* _tmp12_;
			ValaAttribute* attr = NULL;
			_tmp12_ = _vala_code_node_ref0 ((ValaAttribute*) attr_it->data);
			attr = _tmp12_;
			{
				GSequence* _tmp13_;
				ValaAttribute* _tmp14_;
				ValaAttribute* _tmp15_;
				GSequenceIter* _tmp16_;
				_tmp13_ = attributes;
				_tmp14_ = attr;
				_tmp15_ = _vala_code_node_ref0 (_tmp14_);
				_tmp16_ = g_sequence_insert_sorted (_tmp13_, _tmp15_, _____lambda4__gcompare_data_func, self);
				_vala_code_node_unref0 (attr);
			}
		}
	}
	if (need_cheaders) {
		ValaAttribute* _tmp18_;
		_tmp18_ = vala_code_node_get_attribute (node, "CCode");
		_tmp17_ = _tmp18_ == NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GSequence* _tmp19_;
		ValaAttribute* _tmp20_;
		GSequenceIter* _tmp21_;
		_tmp19_ = attributes;
		_tmp20_ = vala_attribute_new ("CCode", NULL);
		_tmp21_ = g_sequence_insert_sorted (_tmp19_, _tmp20_, ____lambda5__gcompare_data_func, self);
	}
	_tmp22_ = attributes;
	_tmp23_ = g_sequence_get_begin_iter (_tmp22_);
	iter = _tmp23_;
	while (TRUE) {
		GSequenceIter* _tmp24_;
		ValaAttribute* attr = NULL;
		GSequenceIter* _tmp25_;
		gconstpointer _tmp26_;
		GSequenceIter* _tmp27_;
		GSequenceIter* _tmp28_;
		GSequence* keys = NULL;
		GSequence* _tmp29_;
		gboolean _tmp48_ = FALSE;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp58_ = FALSE;
		ValaAttribute* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		ValaAttribute* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		ValaSymbol* _tmp68_;
		gboolean _tmp83_ = FALSE;
		FILE* _tmp84_;
		ValaAttribute* _tmp85_;
		const gchar* _tmp86_;
		const gchar* _tmp87_;
		GSequence* _tmp88_;
		FILE* _tmp113_;
		gboolean _tmp114_ = FALSE;
		_tmp24_ = iter;
		if (!(!g_sequence_iter_is_end (_tmp24_))) {
			break;
		}
		_tmp25_ = iter;
		_tmp26_ = g_sequence_get (_tmp25_);
		attr = (ValaAttribute*) _tmp26_;
		_tmp27_ = iter;
		_tmp28_ = g_sequence_iter_next (_tmp27_);
		iter = _tmp28_;
		_tmp29_ = g_sequence_new (_g_free0_);
		keys = _tmp29_;
		{
			ValaIterator* _key_it = NULL;
			ValaAttribute* _tmp30_;
			ValaMap* _tmp31_;
			ValaMap* _tmp32_;
			ValaSet* _tmp33_;
			ValaSet* _tmp34_;
			ValaIterator* _tmp35_;
			ValaIterator* _tmp36_;
			_tmp30_ = attr;
			_tmp31_ = vala_attribute_get_args (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_map_get_keys (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_iterable_iterator ((ValaIterable*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_iterable_unref0 (_tmp34_);
			_key_it = _tmp36_;
			while (TRUE) {
				ValaIterator* _tmp37_;
				gchar* key = NULL;
				ValaIterator* _tmp38_;
				gpointer _tmp39_;
				gboolean _tmp40_ = FALSE;
				const gchar* _tmp41_;
				GSequence* _tmp43_;
				const gchar* _tmp44_;
				gchar* _tmp45_;
				GCompareFunc _tmp46_;
				GSequenceIter* _tmp47_;
				_tmp37_ = _key_it;
				if (!vala_iterator_next (_tmp37_)) {
					break;
				}
				_tmp38_ = _key_it;
				_tmp39_ = vala_iterator_get (_tmp38_);
				key = (gchar*) _tmp39_;
				_tmp41_ = key;
				if (g_strcmp0 (_tmp41_, "cheader_filename") == 0) {
					ValaSymbol* _tmp42_;
					_tmp42_ = sym;
					_tmp40_ = VALA_IS_NAMESPACE (_tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					_g_free0 (key);
					continue;
				}
				_tmp43_ = keys;
				_tmp44_ = key;
				_tmp45_ = g_strdup (_tmp44_);
				_tmp46_ = ((GCompareFunc) g_strcmp0);
				_tmp47_ = g_sequence_insert_sorted (_tmp43_, _tmp45_, (GCompareDataFunc) _tmp46_, NULL);
				_g_free0 (key);
			}
			_vala_iterator_unref0 (_key_it);
		}
		if (need_cheaders) {
			ValaAttribute* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			_tmp50_ = attr;
			_tmp51_ = vala_attribute_get_name (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp49_ = g_strcmp0 (_tmp52_, "CCode") == 0;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaAttribute* _tmp53_;
			_tmp53_ = attr;
			_tmp48_ = !vala_attribute_has_argument (_tmp53_, "cheader_filename");
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			GSequence* _tmp54_;
			gchar* _tmp55_;
			GCompareFunc _tmp56_;
			GSequenceIter* _tmp57_;
			_tmp54_ = keys;
			_tmp55_ = g_strdup ("cheader_filename");
			_tmp56_ = ((GCompareFunc) g_strcmp0);
			_tmp57_ = g_sequence_insert_sorted (_tmp54_, _tmp55_, (GCompareDataFunc) _tmp56_, NULL);
		}
		_tmp59_ = attr;
		_tmp60_ = vala_attribute_get_name (_tmp59_);
		_tmp61_ = _tmp60_;
		if (g_strcmp0 (_tmp61_, "CCode") == 0) {
			GSequence* _tmp62_;
			_tmp62_ = keys;
			_tmp58_ = g_sequence_get_length (_tmp62_) == 0;
		} else {
			_tmp58_ = FALSE;
		}
		if (_tmp58_) {
			_g_sequence_free0 (keys);
			continue;
		}
		_tmp63_ = attr;
		_tmp64_ = vala_attribute_get_name (_tmp63_);
		_tmp65_ = _tmp64_;
		if (g_strcmp0 (_tmp65_, "Source") == 0) {
			_g_sequence_free0 (keys);
			continue;
		}
		_tmp68_ = sym;
		if (_tmp68_ != NULL) {
			ValaAttribute* _tmp69_;
			ValaMap* _tmp70_;
			ValaMap* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			_tmp69_ = attr;
			_tmp70_ = vala_attribute_get_args (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_map_get_size (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp67_ = _tmp73_ == 1;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			ValaAttribute* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			_tmp74_ = attr;
			_tmp75_ = vala_attribute_get_name (_tmp74_);
			_tmp76_ = _tmp75_;
			_tmp66_ = g_strcmp0 (_tmp76_, "Version") == 0;
		} else {
			_tmp66_ = FALSE;
		}
		if (_tmp66_) {
			gchar* since_val = NULL;
			ValaAttribute* _tmp77_;
			gchar* _tmp78_;
			gboolean _tmp79_ = FALSE;
			const gchar* _tmp80_;
			_tmp77_ = attr;
			_tmp78_ = vala_attribute_get_string (_tmp77_, "since", NULL);
			since_val = _tmp78_;
			_tmp80_ = since_val;
			if (_tmp80_ != NULL) {
				ValaSymbol* _tmp81_;
				const gchar* _tmp82_;
				_tmp81_ = sym;
				_tmp82_ = since_val;
				_tmp79_ = vala_code_writer_skip_since_tag_check (self, _tmp81_, _tmp82_);
			} else {
				_tmp79_ = FALSE;
			}
			if (_tmp79_) {
				_g_free0 (since_val);
				_g_sequence_free0 (keys);
				continue;
			}
			_g_free0 (since_val);
		}
		if (!VALA_IS_PARAMETER (node)) {
			_tmp83_ = !VALA_IS_PROPERTY_ACCESSOR (node);
		} else {
			_tmp83_ = FALSE;
		}
		if (_tmp83_) {
			vala_code_writer_write_indent (self);
		}
		_tmp84_ = self->priv->stream;
		_tmp85_ = attr;
		_tmp86_ = vala_attribute_get_name (_tmp85_);
		_tmp87_ = _tmp86_;
		fprintf (_tmp84_, "[%s", _tmp87_);
		_tmp88_ = keys;
		if (g_sequence_get_length (_tmp88_) > 0) {
			FILE* _tmp89_;
			const gchar* separator = NULL;
			GSequenceIter* arg_iter = NULL;
			GSequence* _tmp90_;
			GSequenceIter* _tmp91_;
			FILE* _tmp112_;
			_tmp89_ = self->priv->stream;
			fputs (" (", _tmp89_);
			separator = "";
			_tmp90_ = keys;
			_tmp91_ = g_sequence_get_begin_iter (_tmp90_);
			arg_iter = _tmp91_;
			while (TRUE) {
				GSequenceIter* _tmp92_;
				const gchar* arg_name = NULL;
				GSequenceIter* _tmp93_;
				gconstpointer _tmp94_;
				GSequenceIter* _tmp95_;
				GSequenceIter* _tmp96_;
				const gchar* _tmp97_;
				_tmp92_ = arg_iter;
				if (!(!g_sequence_iter_is_end (_tmp92_))) {
					break;
				}
				_tmp93_ = arg_iter;
				_tmp94_ = g_sequence_get (_tmp93_);
				arg_name = (const gchar*) _tmp94_;
				_tmp95_ = arg_iter;
				_tmp96_ = g_sequence_iter_next (_tmp95_);
				arg_iter = _tmp96_;
				_tmp97_ = arg_name;
				if (g_strcmp0 (_tmp97_, "cheader_filename") == 0) {
					FILE* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					_tmp98_ = self->priv->stream;
					_tmp99_ = separator;
					_tmp100_ = sym;
					_tmp101_ = vala_code_writer_get_cheaders (self, _tmp100_);
					_tmp102_ = _tmp101_;
					fprintf (_tmp98_, "%scheader_filename = \"%s\"", _tmp99_, _tmp102_);
					_g_free0 (_tmp102_);
				} else {
					FILE* _tmp103_;
					const gchar* _tmp104_;
					const gchar* _tmp105_;
					ValaAttribute* _tmp106_;
					ValaMap* _tmp107_;
					ValaMap* _tmp108_;
					const gchar* _tmp109_;
					gpointer _tmp110_;
					gchar* _tmp111_;
					_tmp103_ = self->priv->stream;
					_tmp104_ = separator;
					_tmp105_ = arg_name;
					_tmp106_ = attr;
					_tmp107_ = vala_attribute_get_args (_tmp106_);
					_tmp108_ = _tmp107_;
					_tmp109_ = arg_name;
					_tmp110_ = vala_map_get (_tmp108_, _tmp109_);
					_tmp111_ = (gchar*) _tmp110_;
					fprintf (_tmp103_, "%s%s = %s", _tmp104_, _tmp105_, _tmp111_);
					_g_free0 (_tmp111_);
				}
				separator = ", ";
			}
			_tmp112_ = self->priv->stream;
			fputs (")", _tmp112_);
		}
		_tmp113_ = self->priv->stream;
		fputs ("]", _tmp113_);
		if (VALA_IS_PARAMETER (node)) {
			_tmp114_ = TRUE;
		} else {
			_tmp114_ = VALA_IS_PROPERTY_ACCESSOR (node);
		}
		if (_tmp114_) {
			vala_code_writer_write_string (self, " ");
		} else {
			vala_code_writer_write_newline (self);
		}
		_g_sequence_free0 (keys);
	}
	_tmp116_ = self->priv->type;
	if (_tmp116_ == VALA_CODE_WRITER_TYPE_FAST) {
		gboolean _tmp117_ = FALSE;
		if (VALA_IS_PARAMETER (node)) {
			_tmp117_ = TRUE;
		} else {
			_tmp117_ = VALA_IS_PROPERTY_ACCESSOR (node);
		}
		_tmp115_ = !_tmp117_;
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		ValaSourceReference* source_reference = NULL;
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		ValaSourceReference* _tmp120_;
		ValaSourceReference* _tmp121_;
		_tmp118_ = vala_code_node_get_source_reference (node);
		_tmp119_ = _tmp118_;
		_tmp120_ = _vala_source_reference_ref0 (_tmp119_);
		source_reference = _tmp120_;
		_tmp121_ = source_reference;
		if (_tmp121_ != NULL) {
			gchar* filename = NULL;
			ValaSourceReference* _tmp122_;
			ValaSourceFile* _tmp123_;
			ValaSourceFile* _tmp124_;
			const gchar* _tmp125_;
			const gchar* _tmp126_;
			gchar* _tmp127_;
			const gchar* _tmp128_;
			ValaCodeContext* _tmp129_;
			const gchar* _tmp130_;
			const gchar* _tmp131_;
			FILE* _tmp139_;
			const gchar* _tmp140_;
			ValaSourceReference* _tmp141_;
			ValaSourceLocation _tmp142_ = {0};
			ValaSourceLocation _tmp143_;
			ValaSourceReference* _tmp144_;
			ValaSourceLocation _tmp145_ = {0};
			ValaSourceLocation _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			vala_code_writer_write_indent (self);
			_tmp122_ = source_reference;
			_tmp123_ = vala_source_reference_get_file (_tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = vala_source_file_get_filename (_tmp124_);
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strdup (_tmp126_);
			filename = _tmp127_;
			_tmp128_ = filename;
			_tmp129_ = self->priv->context;
			_tmp130_ = vala_code_context_get_basedir (_tmp129_);
			_tmp131_ = _tmp130_;
			if (g_str_has_prefix (_tmp128_, _tmp131_)) {
				const gchar* _tmp132_;
				ValaCodeContext* _tmp133_;
				const gchar* _tmp134_;
				const gchar* _tmp135_;
				gint _tmp136_;
				gint _tmp137_;
				gchar* _tmp138_;
				_tmp132_ = filename;
				_tmp133_ = self->priv->context;
				_tmp134_ = vala_code_context_get_basedir (_tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = strlen (_tmp135_);
				_tmp137_ = _tmp136_;
				_tmp138_ = string_substring (_tmp132_, (glong) (_tmp137_ + 1), (glong) -1);
				_g_free0 (filename);
				filename = _tmp138_;
			}
			_tmp139_ = self->priv->stream;
			_tmp140_ = filename;
			_tmp141_ = source_reference;
			vala_source_reference_get_begin (_tmp141_, &_tmp142_);
			_tmp143_ = _tmp142_;
			_tmp144_ = source_reference;
			vala_source_reference_get_begin (_tmp144_, &_tmp145_);
			_tmp146_ = _tmp145_;
			_tmp147_ = g_strdup_printf ("[Source (filename = \"%s\", line = %i, column = %i)]", _tmp140_, _tmp143_.line, _tmp146_.column);
			_tmp148_ = _tmp147_;
			fputs (_tmp148_, _tmp139_);
			_g_free0 (_tmp148_);
			vala_code_writer_write_newline (self);
			_g_free0 (filename);
		}
		_vala_source_reference_unref0 (source_reference);
	}
	_g_sequence_free0 (attributes);
	_vala_code_node_unref0 (sym);
}

static void
vala_code_writer_write_accessibility (ValaCodeWriter* self,
                                      ValaSymbol* sym)
{
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaCodeWriterType _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_symbol_get_access (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_accessibility_to_string (_tmp1_);
	vala_code_writer_write_string (self, _tmp2_);
	vala_code_writer_write_string (self, " ");
	_tmp6_ = self->priv->type;
	if (_tmp6_ != VALA_CODE_WRITER_TYPE_EXTERNAL) {
		ValaCodeWriterType _tmp7_;
		_tmp7_ = self->priv->type;
		_tmp5_ = _tmp7_ != VALA_CODE_WRITER_TYPE_VAPIGEN;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = vala_symbol_get_external (sym);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = vala_symbol_get_external_package (sym);
		_tmp11_ = _tmp10_;
		_tmp3_ = !_tmp11_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		vala_code_writer_write_string (self, "extern ");
	}
}

static void
vala_code_writer_write_property_accessor_accessibility (ValaCodeWriter* self,
                                                        ValaSymbol* sym)
{
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_symbol_get_access (sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		return;
	}
	vala_code_writer_write_string (self, " ");
	_tmp2_ = vala_symbol_get_access (sym);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_accessibility_to_string (_tmp3_);
	vala_code_writer_write_string (self, _tmp4_);
}

static void
vala_code_writer_write_type_parameters (ValaCodeWriter* self,
                                        ValaList* type_params)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_params != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) type_params);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0) {
		gboolean first = FALSE;
		vala_code_writer_write_string (self, "<");
		first = TRUE;
		{
			ValaList* _type_param_list = NULL;
			ValaList* _tmp2_;
			gint _type_param_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _type_param_index = 0;
			_tmp2_ = _vala_iterable_ref0 (type_params);
			_type_param_list = _tmp2_;
			_tmp3_ = _type_param_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_type_param_size = _tmp5_;
			_type_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaTypeParameter* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				_type_param_index = _type_param_index + 1;
				if (!(_type_param_index < _type_param_size)) {
					break;
				}
				_tmp6_ = _type_param_list;
				_tmp7_ = vala_list_get (_tmp6_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp7_;
				if (first) {
					first = FALSE;
				} else {
					vala_code_writer_write_string (self, ",");
				}
				_tmp8_ = type_param;
				_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
				_tmp10_ = _tmp9_;
				vala_code_writer_write_identifier (self, _tmp10_);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
		vala_code_writer_write_string (self, ">");
	}
}

static void
vala_code_writer_class_init (ValaCodeWriterClass * klass,
                             gpointer klass_data)
{
	vala_code_writer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_code_writer_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCodeWriter_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_using_directive = (void (*) (ValaCodeVisitor*, ValaUsingDirective*)) vala_code_writer_real_visit_using_directive;
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*) (ValaCodeVisitor*, ValaNamespace*)) vala_code_writer_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_code_writer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_code_writer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_code_writer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_code_writer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_code_writer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_constant = (void (*) (ValaCodeVisitor*, ValaConstant*)) vala_code_writer_real_visit_constant;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_code_writer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*) (ValaCodeVisitor*, ValaDelegate*)) vala_code_writer_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_constructor = (void (*) (ValaCodeVisitor*, ValaConstructor*)) vala_code_writer_real_visit_constructor;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_code_writer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_code_writer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_code_writer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_code_writer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor*, ValaBlock*)) vala_code_writer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_empty_statement = (void (*) (ValaCodeVisitor*, ValaEmptyStatement*)) vala_code_writer_real_visit_empty_statement;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor*, ValaDeclarationStatement*)) vala_code_writer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor*, ValaLocalVariable*)) vala_code_writer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_initializer_list = (void (*) (ValaCodeVisitor*, ValaInitializerList*)) vala_code_writer_real_visit_initializer_list;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor*, ValaExpressionStatement*)) vala_code_writer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor*, ValaIfStatement*)) vala_code_writer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor*, ValaSwitchStatement*)) vala_code_writer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_section = (void (*) (ValaCodeVisitor*, ValaSwitchSection*)) vala_code_writer_real_visit_switch_section;
	((ValaCodeVisitorClass *) klass)->visit_switch_label = (void (*) (ValaCodeVisitor*, ValaSwitchLabel*)) vala_code_writer_real_visit_switch_label;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor*, ValaLoop*)) vala_code_writer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_while_statement = (void (*) (ValaCodeVisitor*, ValaWhileStatement*)) vala_code_writer_real_visit_while_statement;
	((ValaCodeVisitorClass *) klass)->visit_do_statement = (void (*) (ValaCodeVisitor*, ValaDoStatement*)) vala_code_writer_real_visit_do_statement;
	((ValaCodeVisitorClass *) klass)->visit_for_statement = (void (*) (ValaCodeVisitor*, ValaForStatement*)) vala_code_writer_real_visit_for_statement;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor*, ValaForeachStatement*)) vala_code_writer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor*, ValaBreakStatement*)) vala_code_writer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor*, ValaContinueStatement*)) vala_code_writer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor*, ValaReturnStatement*)) vala_code_writer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor*, ValaYieldStatement*)) vala_code_writer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_code_writer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_code_writer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_code_writer_real_visit_catch_clause;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor*, ValaLockStatement*)) vala_code_writer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_delete_statement = (void (*) (ValaCodeVisitor*, ValaDeleteStatement*)) vala_code_writer_real_visit_delete_statement;
	((ValaCodeVisitorClass *) klass)->visit_array_creation_expression = (void (*) (ValaCodeVisitor*, ValaArrayCreationExpression*)) vala_code_writer_real_visit_array_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_boolean_literal = (void (*) (ValaCodeVisitor*, ValaBooleanLiteral*)) vala_code_writer_real_visit_boolean_literal;
	((ValaCodeVisitorClass *) klass)->visit_character_literal = (void (*) (ValaCodeVisitor*, ValaCharacterLiteral*)) vala_code_writer_real_visit_character_literal;
	((ValaCodeVisitorClass *) klass)->visit_integer_literal = (void (*) (ValaCodeVisitor*, ValaIntegerLiteral*)) vala_code_writer_real_visit_integer_literal;
	((ValaCodeVisitorClass *) klass)->visit_real_literal = (void (*) (ValaCodeVisitor*, ValaRealLiteral*)) vala_code_writer_real_visit_real_literal;
	((ValaCodeVisitorClass *) klass)->visit_string_literal = (void (*) (ValaCodeVisitor*, ValaStringLiteral*)) vala_code_writer_real_visit_string_literal;
	((ValaCodeVisitorClass *) klass)->visit_null_literal = (void (*) (ValaCodeVisitor*, ValaNullLiteral*)) vala_code_writer_real_visit_null_literal;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_code_writer_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_code_writer_real_visit_method_call;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_code_writer_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_slice_expression = (void (*) (ValaCodeVisitor*, ValaSliceExpression*)) vala_code_writer_real_visit_slice_expression;
	((ValaCodeVisitorClass *) klass)->visit_base_access = (void (*) (ValaCodeVisitor*, ValaBaseAccess*)) vala_code_writer_real_visit_base_access;
	((ValaCodeVisitorClass *) klass)->visit_postfix_expression = (void (*) (ValaCodeVisitor*, ValaPostfixExpression*)) vala_code_writer_real_visit_postfix_expression;
	((ValaCodeVisitorClass *) klass)->visit_object_creation_expression = (void (*) (ValaCodeVisitor*, ValaObjectCreationExpression*)) vala_code_writer_real_visit_object_creation_expression;
	((ValaCodeVisitorClass *) klass)->visit_sizeof_expression = (void (*) (ValaCodeVisitor*, ValaSizeofExpression*)) vala_code_writer_real_visit_sizeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_typeof_expression = (void (*) (ValaCodeVisitor*, ValaTypeofExpression*)) vala_code_writer_real_visit_typeof_expression;
	((ValaCodeVisitorClass *) klass)->visit_unary_expression = (void (*) (ValaCodeVisitor*, ValaUnaryExpression*)) vala_code_writer_real_visit_unary_expression;
	((ValaCodeVisitorClass *) klass)->visit_cast_expression = (void (*) (ValaCodeVisitor*, ValaCastExpression*)) vala_code_writer_real_visit_cast_expression;
	((ValaCodeVisitorClass *) klass)->visit_pointer_indirection = (void (*) (ValaCodeVisitor*, ValaPointerIndirection*)) vala_code_writer_real_visit_pointer_indirection;
	((ValaCodeVisitorClass *) klass)->visit_addressof_expression = (void (*) (ValaCodeVisitor*, ValaAddressofExpression*)) vala_code_writer_real_visit_addressof_expression;
	((ValaCodeVisitorClass *) klass)->visit_reference_transfer_expression = (void (*) (ValaCodeVisitor*, ValaReferenceTransferExpression*)) vala_code_writer_real_visit_reference_transfer_expression;
	((ValaCodeVisitorClass *) klass)->visit_binary_expression = (void (*) (ValaCodeVisitor*, ValaBinaryExpression*)) vala_code_writer_real_visit_binary_expression;
	((ValaCodeVisitorClass *) klass)->visit_type_check = (void (*) (ValaCodeVisitor*, ValaTypeCheck*)) vala_code_writer_real_visit_type_check;
	((ValaCodeVisitorClass *) klass)->visit_conditional_expression = (void (*) (ValaCodeVisitor*, ValaConditionalExpression*)) vala_code_writer_real_visit_conditional_expression;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) vala_code_writer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor*, ValaAssignment*)) vala_code_writer_real_visit_assignment;
}

static void
vala_code_writer_instance_init (ValaCodeWriter * self,
                                gpointer klass)
{
	self->priv = vala_code_writer_get_instance_private (self);
	self->priv->bol = TRUE;
	self->priv->override_header = NULL;
	self->priv->header_to_override = NULL;
}

static void
vala_code_writer_finalize (ValaCodeVisitor * obj)
{
	ValaCodeWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CODE_WRITER, ValaCodeWriter);
	_vala_code_context_unref0 (self->priv->context);
	_fclose0 (self->priv->stream);
	_vala_scope_unref0 (self->priv->current_scope);
	_g_free0 (self->priv->override_header);
	_g_free0 (self->priv->header_to_override);
	VALA_CODE_VISITOR_CLASS (vala_code_writer_parent_class)->finalize (obj);
}

/**
 * Code visitor generating Vala API file for the public interface.
 */
GType
vala_code_writer_get_type (void)
{
	static volatile gsize vala_code_writer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeWriter), 0, (GInstanceInitFunc) vala_code_writer_instance_init, NULL };
		GType vala_code_writer_type_id;
		vala_code_writer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaCodeWriter", &g_define_type_info, 0);
		ValaCodeWriter_private_offset = g_type_add_instance_private (vala_code_writer_type_id, sizeof (ValaCodeWriterPrivate));
		g_once_init_leave (&vala_code_writer_type_id__volatile, vala_code_writer_type_id);
	}
	return vala_code_writer_type_id__volatile;
}

GType
vala_code_writer_type_get_type (void)
{
	static volatile gsize vala_code_writer_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_code_writer_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_CODE_WRITER_TYPE_EXTERNAL, "VALA_CODE_WRITER_TYPE_EXTERNAL", "external"}, {VALA_CODE_WRITER_TYPE_INTERNAL, "VALA_CODE_WRITER_TYPE_INTERNAL", "internal"}, {VALA_CODE_WRITER_TYPE_FAST, "VALA_CODE_WRITER_TYPE_FAST", "fast"}, {VALA_CODE_WRITER_TYPE_DUMP, "VALA_CODE_WRITER_TYPE_DUMP", "dump"}, {VALA_CODE_WRITER_TYPE_VAPIGEN, "VALA_CODE_WRITER_TYPE_VAPIGEN", "vapigen"}, {0, NULL, NULL}};
		GType vala_code_writer_type_type_id;
		vala_code_writer_type_type_id = g_enum_register_static ("ValaCodeWriterType", values);
		g_once_init_leave (&vala_code_writer_type_type_id__volatile, vala_code_writer_type_type_id);
	}
	return vala_code_writer_type_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

