/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};


static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);


static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}


/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp19_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				ValaScope* _tmp14_;
				ValaScope* _tmp15_;
				ValaParameter* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = param;
				_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
				_tmp18_ = _tmp17_;
				vala_scope_remove (_tmp15_, _tmp18_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp19_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp19_);
}


gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaParameter* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp11_ = param;
			_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}


static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaLocalVariable* _tmp42_;
	ValaLocalVariable* _tmp43_;
	ValaList* _tmp46_;
	ValaList* _tmp59_;
	ValaBlock* _tmp72_;
	ValaBlock* _tmp73_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			_tmp4_ = _p_index;
			_p_index = _tmp4_ + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			p = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp11_ = vala_method_get_base_interface_type (self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_method_get_base_interface_type (self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _param_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _param_index = 0;
		_tmp19_ = self->priv->parameters;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_param_list = _tmp20_;
		_tmp21_ = _param_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_param_size = _tmp23_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaParameter* param = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			_tmp24_ = _param_index;
			_param_index = _tmp24_ + 1;
			_tmp25_ = _param_index;
			_tmp26_ = _param_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _param_list;
			_tmp28_ = _param_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp31_;
		gint _error_type_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _error_type_index = 0;
		_tmp31_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp31_;
		_tmp32_ = _error_type_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_error_type_size = _tmp34_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaDataType* _tmp41_;
			_tmp35_ = _error_type_index;
			_error_type_index = _tmp35_ + 1;
			_tmp36_ = _error_type_index;
			_tmp37_ = _error_type_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _error_type_list;
			_tmp39_ = _error_type_index;
			_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
			error_type = (ValaDataType*) _tmp40_;
			_tmp41_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp41_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp42_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		_tmp44_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp45_ = _tmp44_;
		vala_code_node_accept ((ValaCodeNode*) _tmp45_, visitor);
	}
	_tmp46_ = self->priv->preconditions;
	if (_tmp46_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp47_;
			ValaList* _tmp48_;
			gint _precondition_size = 0;
			ValaList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _precondition_index = 0;
			_tmp47_ = self->priv->preconditions;
			_tmp48_ = _vala_iterable_ref0 (_tmp47_);
			_precondition_list = _tmp48_;
			_tmp49_ = _precondition_list;
			_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_precondition_size = _tmp51_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gint _tmp54_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp55_;
				gint _tmp56_;
				gpointer _tmp57_;
				ValaExpression* _tmp58_;
				_tmp52_ = _precondition_index;
				_precondition_index = _tmp52_ + 1;
				_tmp53_ = _precondition_index;
				_tmp54_ = _precondition_size;
				if (!(_tmp53_ < _tmp54_)) {
					break;
				}
				_tmp55_ = _precondition_list;
				_tmp56_ = _precondition_index;
				_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
				precondition = (ValaExpression*) _tmp57_;
				_tmp58_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp58_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp59_ = self->priv->postconditions;
	if (_tmp59_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp60_;
			ValaList* _tmp61_;
			gint _postcondition_size = 0;
			ValaList* _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			gint _postcondition_index = 0;
			_tmp60_ = self->priv->postconditions;
			_tmp61_ = _vala_iterable_ref0 (_tmp60_);
			_postcondition_list = _tmp61_;
			_tmp62_ = _postcondition_list;
			_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
			_tmp64_ = _tmp63_;
			_postcondition_size = _tmp64_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp68_;
				gint _tmp69_;
				gpointer _tmp70_;
				ValaExpression* _tmp71_;
				_tmp65_ = _postcondition_index;
				_postcondition_index = _tmp65_ + 1;
				_tmp66_ = _postcondition_index;
				_tmp67_ = _postcondition_size;
				if (!(_tmp66_ < _tmp67_)) {
					break;
				}
				_tmp68_ = _postcondition_list;
				_tmp69_ = _postcondition_index;
				_tmp70_ = vala_list_get (_tmp68_, _tmp69_);
				postcondition = (ValaExpression*) _tmp70_;
				_tmp71_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp71_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp73_ = _tmp72_;
	if (_tmp73_ != NULL) {
		ValaBlock* _tmp74_;
		ValaBlock* _tmp75_;
		_tmp74_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp75_ = _tmp74_;
		vala_code_node_accept ((ValaCodeNode*) _tmp75_, visitor);
	}
}


/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	ValaList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	gboolean _tmp34_;
	ValaList* method_type_args = NULL;
	ValaList* _tmp46_;
	ValaList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp68_;
	ValaDataType* _tmp69_;
	ValaObjectType* _tmp70_;
	ValaList* _tmp71_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	ValaDataType* _tmp74_;
	ValaDataType* _tmp75_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp84_;
	ValaIterator* _tmp85_;
	gint param_index = 0;
	ValaIterator* _tmp132_;
	gboolean _tmp161_;
	gboolean _tmp162_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaGenericType* _tmp23_;
				ValaObjectType* _tmp24_;
				ValaGenericType* _tmp25_;
				_tmp15_ = _type_parameter_index;
				_type_parameter_index = _tmp15_ + 1;
				_tmp16_ = _type_parameter_index;
				_tmp17_ = _type_parameter_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _type_parameter_list;
				_tmp19_ = _type_parameter_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				type_parameter = (ValaTypeParameter*) _tmp20_;
				_tmp21_ = type_parameter;
				_tmp22_ = vala_generic_type_new (_tmp21_);
				type_arg = _tmp22_;
				_tmp23_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp23_, TRUE);
				_tmp24_ = object_type;
				_tmp25_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp24_, (ValaDataType*) _tmp25_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp26_ = vala_method_get_type_parameters (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_method_get_type_parameters (base_method);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp29_ < _tmp33_;
	_vala_iterable_unref0 (_tmp31_);
	_vala_iterable_unref0 (_tmp27_);
	if (_tmp34_) {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp35_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gboolean _tmp44_;
		_tmp36_ = vala_method_get_type_parameters (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_method_get_type_parameters (base_method);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = _tmp39_ > _tmp43_;
		_vala_iterable_unref0 (_tmp41_);
		_vala_iterable_unref0 (_tmp37_);
		if (_tmp44_) {
			gchar* _tmp45_;
			_tmp45_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp45_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	_tmp46_ = vala_method_get_type_parameters (self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = _tmp49_ > 0;
	_vala_iterable_unref0 (_tmp47_);
	if (_tmp50_) {
		GEqualFunc _tmp51_;
		ValaArrayList* _tmp52_;
		_tmp51_ = g_direct_equal;
		_tmp52_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp51_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp52_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp53_;
			gint _type_parameter_size = 0;
			ValaList* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			gint _type_parameter_index = 0;
			_tmp53_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp53_;
			_tmp54_ = _type_parameter_list;
			_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
			_tmp56_ = _tmp55_;
			_type_parameter_size = _tmp56_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp60_;
				gint _tmp61_;
				gpointer _tmp62_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp63_;
				ValaGenericType* _tmp64_;
				ValaGenericType* _tmp65_;
				ValaList* _tmp66_;
				ValaGenericType* _tmp67_;
				_tmp57_ = _type_parameter_index;
				_type_parameter_index = _tmp57_ + 1;
				_tmp58_ = _type_parameter_index;
				_tmp59_ = _type_parameter_size;
				if (!(_tmp58_ < _tmp59_)) {
					break;
				}
				_tmp60_ = _type_parameter_list;
				_tmp61_ = _type_parameter_index;
				_tmp62_ = vala_list_get (_tmp60_, _tmp61_);
				type_parameter = (ValaTypeParameter*) _tmp62_;
				_tmp63_ = type_parameter;
				_tmp64_ = vala_generic_type_new (_tmp63_);
				type_arg = _tmp64_;
				_tmp65_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp65_, TRUE);
				_tmp66_ = method_type_args;
				_tmp67_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp66_, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp68_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp69_ = _tmp68_;
	_tmp70_ = object_type;
	_tmp71_ = method_type_args;
	_tmp72_ = vala_data_type_get_actual_type (_tmp69_, (ValaDataType*) _tmp70_, _tmp71_, (ValaCodeNode*) self);
	actual_base_type = _tmp72_;
	_tmp73_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = actual_base_type;
	if (!vala_data_type_equals (_tmp74_, _tmp75_)) {
		ValaDataType* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		ValaDataType* _tmp79_;
		ValaDataType* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp76_ = actual_base_type;
		_tmp77_ = vala_data_type_to_prototype_string (_tmp76_, NULL);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = vala_data_type_to_prototype_string (_tmp80_, NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp78_, _tmp82_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp83_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp78_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp84_ = self->priv->parameters;
	_tmp85_ = vala_iterable_iterator ((ValaIterable*) _tmp84_);
	method_params_it = _tmp85_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp86_;
		ValaList* _tmp87_;
		gint _base_param_size = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _base_param_index = 0;
		_tmp86_ = base_method->priv->parameters;
		_tmp87_ = _vala_iterable_ref0 (_tmp86_);
		_base_param_list = _tmp87_;
		_tmp88_ = _base_param_list;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_base_param_size = _tmp90_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp94_;
			gint _tmp95_;
			gpointer _tmp96_;
			ValaIterator* _tmp97_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp99_;
			gpointer _tmp100_;
			ValaParameter* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			ValaParameter* _tmp104_;
			gboolean _tmp105_;
			gboolean _tmp106_;
			ValaParameter* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			gint _tmp131_;
			_tmp91_ = _base_param_index;
			_base_param_index = _tmp91_ + 1;
			_tmp92_ = _base_param_index;
			_tmp93_ = _base_param_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _base_param_list;
			_tmp95_ = _base_param_index;
			_tmp96_ = vala_list_get (_tmp94_, _tmp95_);
			base_param = (ValaParameter*) _tmp96_;
			_tmp97_ = method_params_it;
			if (!vala_iterator_next (_tmp97_)) {
				gchar* _tmp98_;
				_tmp98_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp98_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp99_ = method_params_it;
			_tmp100_ = vala_iterator_get (_tmp99_);
			param = (ValaParameter*) _tmp100_;
			_tmp101_ = base_param;
			_tmp102_ = vala_parameter_get_ellipsis (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = param;
			_tmp105_ = vala_parameter_get_ellipsis (_tmp104_);
			_tmp106_ = _tmp105_;
			if (_tmp103_ != _tmp106_) {
				gchar* _tmp107_;
				_tmp107_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp107_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp108_ = base_param;
			_tmp109_ = vala_parameter_get_ellipsis (_tmp108_);
			_tmp110_ = _tmp109_;
			if (!_tmp110_) {
				ValaParameter* _tmp111_;
				ValaParameterDirection _tmp112_;
				ValaParameterDirection _tmp113_;
				ValaParameter* _tmp114_;
				ValaParameterDirection _tmp115_;
				ValaParameterDirection _tmp116_;
				ValaParameter* _tmp119_;
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaObjectType* _tmp122_;
				ValaList* _tmp123_;
				ValaDataType* _tmp124_;
				ValaDataType* _tmp125_;
				ValaParameter* _tmp126_;
				ValaDataType* _tmp127_;
				ValaDataType* _tmp128_;
				_tmp111_ = base_param;
				_tmp112_ = vala_parameter_get_direction (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = param;
				_tmp115_ = vala_parameter_get_direction (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp113_ != _tmp116_) {
					gint _tmp117_;
					gchar* _tmp118_;
					_tmp117_ = param_index;
					_tmp118_ = g_strdup_printf ("incompatible direction of parameter %d", _tmp117_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp118_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp119_ = base_param;
				_tmp120_ = vala_variable_get_variable_type ((ValaVariable*) _tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = object_type;
				_tmp123_ = method_type_args;
				_tmp124_ = vala_data_type_get_actual_type (_tmp121_, (ValaDataType*) _tmp122_, _tmp123_, (ValaCodeNode*) self);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp124_;
				_tmp125_ = actual_base_type;
				_tmp126_ = param;
				_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
				_tmp128_ = _tmp127_;
				if (!vala_data_type_equals (_tmp125_, _tmp128_)) {
					gint _tmp129_;
					gchar* _tmp130_;
					_tmp129_ = param_index;
					_tmp130_ = g_strdup_printf ("incompatible type of parameter %d", _tmp129_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp130_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp131_ = param_index;
			param_index = _tmp131_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp132_ = method_params_it;
	if (vala_iterator_next (_tmp132_)) {
		gchar* _tmp133_;
		_tmp133_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp133_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaList* _tmp134_;
		gint _method_error_type_size = 0;
		ValaList* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _method_error_type_index = 0;
		_tmp134_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_method_error_type_list = _tmp134_;
		_tmp135_ = _method_error_type_list;
		_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
		_tmp137_ = _tmp136_;
		_method_error_type_size = _tmp137_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp138_;
			gint _tmp139_;
			gint _tmp140_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp141_;
			gint _tmp142_;
			gpointer _tmp143_;
			gboolean match = FALSE;
			gboolean _tmp156_;
			_tmp138_ = _method_error_type_index;
			_method_error_type_index = _tmp138_ + 1;
			_tmp139_ = _method_error_type_index;
			_tmp140_ = _method_error_type_size;
			if (!(_tmp139_ < _tmp140_)) {
				break;
			}
			_tmp141_ = _method_error_type_list;
			_tmp142_ = _method_error_type_index;
			_tmp143_ = vala_list_get (_tmp141_, _tmp142_);
			method_error_type = (ValaDataType*) _tmp143_;
			match = FALSE;
			{
				ValaList* _base_method_error_type_list = NULL;
				ValaList* _tmp144_;
				gint _base_method_error_type_size = 0;
				ValaList* _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				gint _base_method_error_type_index = 0;
				_tmp144_ = vala_code_node_get_error_types ((ValaCodeNode*) base_method);
				_base_method_error_type_list = _tmp144_;
				_tmp145_ = _base_method_error_type_list;
				_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
				_tmp147_ = _tmp146_;
				_base_method_error_type_size = _tmp147_;
				_base_method_error_type_index = -1;
				while (TRUE) {
					gint _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					ValaDataType* base_method_error_type = NULL;
					ValaList* _tmp151_;
					gint _tmp152_;
					gpointer _tmp153_;
					ValaDataType* _tmp154_;
					ValaDataType* _tmp155_;
					_tmp148_ = _base_method_error_type_index;
					_base_method_error_type_index = _tmp148_ + 1;
					_tmp149_ = _base_method_error_type_index;
					_tmp150_ = _base_method_error_type_size;
					if (!(_tmp149_ < _tmp150_)) {
						break;
					}
					_tmp151_ = _base_method_error_type_list;
					_tmp152_ = _base_method_error_type_index;
					_tmp153_ = vala_list_get (_tmp151_, _tmp152_);
					base_method_error_type = (ValaDataType*) _tmp153_;
					_tmp154_ = method_error_type;
					_tmp155_ = base_method_error_type;
					if (vala_data_type_compatible (_tmp154_, _tmp155_)) {
						match = TRUE;
						_vala_code_node_unref0 (base_method_error_type);
						break;
					}
					_vala_code_node_unref0 (base_method_error_type);
				}
				_vala_iterable_unref0 (_base_method_error_type_list);
			}
			_tmp156_ = match;
			if (!_tmp156_) {
				ValaDataType* _tmp157_;
				gchar* _tmp158_;
				gchar* _tmp159_;
				gchar* _tmp160_;
				_tmp157_ = method_error_type;
				_tmp158_ = vala_code_node_to_string ((ValaCodeNode*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = g_strdup_printf ("incompatible error type `%s'", _tmp159_);
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp160_;
				_g_free0 (_tmp159_);
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	_tmp161_ = base_method->priv->_coroutine;
	_tmp162_ = self->priv->_coroutine;
	if (_tmp161_ != _tmp162_) {
		gchar* _tmp163_;
		_tmp163_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp163_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaTypeParameter* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp6_ = _parameter_index;
			_parameter_index = _tmp6_ + 1;
			_tmp7_ = _parameter_index;
			_tmp8_ = _parameter_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _parameter_list;
			_tmp10_ = _parameter_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			parameter = (ValaTypeParameter*) _tmp11_;
			_tmp12_ = parameter;
			_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (g_strcmp0 (_tmp14_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* error_types = NULL;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				gboolean _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = error_types;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = error_types;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = _tmp14_ == old_type;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp15_) {
					ValaList* _tmp16_;
					gint _tmp17_;
					_tmp16_ = error_types;
					_tmp17_ = i;
					vala_list_set (_tmp16_, _tmp17_, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static void
vala_method_find_base_methods (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_methods_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp7_ = self->priv->_is_virtual;
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_is_abstract;
				_tmp6_ = _tmp8_;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp9_;
				_tmp9_ = self->priv->_overrides;
				_tmp5_ = _tmp9_;
			}
			if (_tmp5_) {
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_virtual;
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp16_;
				_tmp16_ = self->priv->_is_abstract;
				_tmp14_ = _tmp16_;
			}
			if (_tmp14_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp37_;
	ValaClass* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp37_ = vala_class_get_base_class (cl);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaClass* _tmp39_;
		ValaClass* _tmp40_;
		_tmp39_ = vala_class_get_base_class (cl);
		_tmp40_ = _tmp39_;
		vala_method_find_base_class_method (self, _tmp40_);
	}
	_vala_code_node_unref0 (sym);
}


static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaDataType* _tmp84_;
	ValaDataType* _tmp85_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _type_index;
			_type_index = _tmp4_ + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
				gboolean _tmp13_ = FALSE;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaTypeSymbol* _tmp25_;
				ValaScope* _tmp26_;
				ValaScope* _tmp27_;
				const gchar* _tmp28_;
				const gchar* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp31_;
				ValaSymbol* _tmp38_;
				_tmp14_ = vala_method_get_base_interface_type (self);
				_tmp15_ = _tmp14_;
				if (_tmp15_ != NULL) {
					ValaDataType* _tmp16_;
					ValaDataType* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaTypeSymbol* _tmp19_;
					ValaDataType* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					ValaTypeSymbol* _tmp22_;
					_tmp16_ = vala_method_get_base_interface_type (self);
					_tmp17_ = _tmp16_;
					_tmp18_ = vala_data_type_get_data_type (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = type;
					_tmp21_ = vala_data_type_get_data_type (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp13_ = _tmp19_ != _tmp22_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp23_ = type;
				_tmp24_ = vala_data_type_get_data_type (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_scope_lookup (_tmp27_, _tmp29_);
				sym = _tmp30_;
				_tmp31_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_SIGNAL)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp32_;
					ValaSignal* _tmp33_;
					ValaSignal* _tmp34_;
					ValaMethod* _tmp35_;
					ValaMethod* _tmp36_;
					ValaSymbol* _tmp37_;
					_tmp32_ = sym;
					_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp33_;
					_tmp34_ = sig;
					_tmp35_ = vala_signal_get_default_handler (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp36_);
					_vala_code_node_unref0 (sym);
					sym = _tmp37_;
					_vala_code_node_unref0 (sig);
				}
				_tmp38_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, VALA_TYPE_METHOD)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp39_;
					ValaMethod* _tmp40_;
					gboolean _tmp41_ = FALSE;
					ValaMethod* _tmp42_;
					gboolean _tmp43_;
					_tmp39_ = sym;
					_tmp40_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp40_;
					_tmp42_ = base_method;
					_tmp43_ = _tmp42_->priv->_is_abstract;
					if (_tmp43_) {
						_tmp41_ = TRUE;
					} else {
						ValaMethod* _tmp44_;
						gboolean _tmp45_;
						_tmp44_ = base_method;
						_tmp45_ = _tmp44_->priv->_is_virtual;
						_tmp41_ = _tmp45_;
					}
					if (_tmp41_) {
						ValaDataType* _tmp46_;
						ValaDataType* _tmp47_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp67_;
						gchar* _tmp68_ = NULL;
						gboolean _tmp69_;
						ValaMethod* _tmp82_;
						ValaMethod* _tmp83_;
						_tmp46_ = vala_method_get_base_interface_type (self);
						_tmp47_ = _tmp46_;
						if (_tmp47_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							gboolean _tmp66_;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp48_;
								gint _m_size = 0;
								ValaList* _tmp49_;
								gint _tmp50_;
								gint _tmp51_;
								gint _m_index = 0;
								_tmp48_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp48_;
								_tmp49_ = _m_list;
								_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
								_tmp51_ = _tmp50_;
								_m_size = _tmp51_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp52_;
									gint _tmp53_;
									gint _tmp54_;
									ValaMethod* m = NULL;
									ValaList* _tmp55_;
									gint _tmp56_;
									gpointer _tmp57_;
									gboolean _tmp58_ = FALSE;
									ValaMethod* _tmp59_;
									ValaDataType* _tmp60_;
									ValaDataType* _tmp61_;
									_tmp52_ = _m_index;
									_m_index = _tmp52_ + 1;
									_tmp53_ = _m_index;
									_tmp54_ = _m_size;
									if (!(_tmp53_ < _tmp54_)) {
										break;
									}
									_tmp55_ = _m_list;
									_tmp56_ = _m_index;
									_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
									m = (ValaMethod*) _tmp57_;
									_tmp59_ = m;
									_tmp60_ = vala_method_get_base_interface_type (_tmp59_);
									_tmp61_ = _tmp60_;
									if (_tmp61_ != NULL) {
										ValaMethod* _tmp62_;
										ValaMethod* _tmp63_;
										ValaMethod* _tmp64_;
										ValaMethod* _tmp65_;
										_tmp62_ = base_method;
										_tmp63_ = m;
										_tmp64_ = vala_method_get_base_interface_method (_tmp63_);
										_tmp65_ = _tmp64_;
										_tmp58_ = _tmp62_ == _tmp65_;
									} else {
										_tmp58_ = FALSE;
									}
									if (_tmp58_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							_tmp66_ = has_explicit_implementation;
							if (_tmp66_) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp67_ = base_method;
						_tmp69_ = vala_method_compatible (self, _tmp67_, &_tmp68_);
						_g_free0 (invalid_match);
						invalid_match = _tmp68_;
						if (!_tmp69_) {
							ValaMethodType* base_method_type = NULL;
							ValaMethod* _tmp70_;
							ValaMethodType* _tmp71_;
							ValaSourceReference* _tmp72_;
							ValaSourceReference* _tmp73_;
							gchar* _tmp74_;
							gchar* _tmp75_;
							ValaMethodType* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							const gchar* _tmp79_;
							gchar* _tmp80_;
							gchar* _tmp81_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp70_ = base_method;
							_tmp71_ = vala_method_type_new (_tmp70_);
							base_method_type = _tmp71_;
							_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp73_ = _tmp72_;
							_tmp74_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp75_ = _tmp74_;
							_tmp76_ = base_method_type;
							_tmp77_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp76_, NULL);
							_tmp78_ = _tmp77_;
							_tmp79_ = invalid_match;
							_tmp80_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp75_, _tmp78_, _tmp79_);
							_tmp81_ = _tmp80_;
							vala_report_error (_tmp73_, _tmp81_);
							_g_free0 (_tmp81_);
							_g_free0 (_tmp78_);
							_g_free0 (_tmp75_);
							_vala_code_node_unref0 (base_method_type);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp82_ = base_method;
						self->priv->_base_interface_method = _tmp82_;
						_tmp83_ = base_method;
						vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp83_, "CCode", "instance_pos");
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp84_ = vala_method_get_base_interface_type (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_ != NULL) {
		ValaSourceReference* _tmp86_;
		ValaSourceReference* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		_tmp86_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp89_);
		_tmp91_ = _tmp90_;
		vala_report_error (_tmp87_, _tmp91_);
		_g_free0 (_tmp91_);
		_g_free0 (_tmp89_);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp11_ = FALSE;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp35_;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp73_;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp120_;
	ValaSemanticAnalyzer* _tmp121_;
	ValaSourceFile* _tmp122_;
	ValaSourceFile* _tmp123_;
	ValaSourceFile* _tmp124_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp125_;
	ValaSemanticAnalyzer* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaSymbol* _tmp128_;
	ValaSymbol* _tmp129_;
	ValaSourceReference* _tmp130_;
	ValaSourceReference* _tmp131_;
	ValaSemanticAnalyzer* _tmp138_;
	ValaSemanticAnalyzer* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	ValaDataType* _tmp144_;
	ValaDataType* _tmp145_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp146_;
	ValaAttribute* _tmp147_;
	ValaAttribute* _tmp148_;
	ValaDataType* _tmp155_;
	ValaDataType* _tmp156_;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	gboolean _tmp161_ = FALSE;
	ValaList* _tmp162_;
	gint _tmp163_;
	gint _tmp164_;
	gboolean optional_param = FALSE;
	ValaLocalVariable* _tmp259_;
	ValaLocalVariable* _tmp260_;
	ValaList* _tmp263_;
	ValaList* _tmp276_;
	ValaBlock* _tmp289_;
	ValaBlock* _tmp290_;
	ValaSemanticAnalyzer* _tmp293_;
	ValaSemanticAnalyzer* _tmp294_;
	ValaStruct* _tmp295_;
	ValaStruct* _tmp296_;
	gboolean _tmp332_ = FALSE;
	gboolean _tmp333_ = FALSE;
	ValaDataType* _tmp334_;
	ValaDataType* _tmp335_;
	ValaSemanticAnalyzer* _tmp383_;
	ValaSemanticAnalyzer* _tmp384_;
	ValaSourceFile* _tmp385_;
	ValaSemanticAnalyzer* _tmp386_;
	ValaSemanticAnalyzer* _tmp387_;
	ValaSymbol* _tmp388_;
	gboolean _tmp389_ = FALSE;
	gboolean _tmp390_ = FALSE;
	gboolean _tmp391_ = FALSE;
	gboolean _tmp392_;
	gboolean _tmp393_;
	ValaSemanticAnalyzer* _tmp409_;
	ValaSemanticAnalyzer* _tmp410_;
	ValaDataType* _tmp411_;
	ValaDataType* _tmp412_;
	ValaBlock* _tmp467_;
	ValaBlock* _tmp468_;
	gboolean _tmp509_ = FALSE;
	gboolean _tmp510_ = FALSE;
	gboolean _tmp511_ = FALSE;
	gboolean _tmp512_ = FALSE;
	gboolean _tmp513_ = FALSE;
	ValaAttribute* _tmp574_;
	gboolean _tmp575_;
	gboolean _tmp576_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		ValaList* _tmp9_;
		ValaList* _tmp10_;
		_tmp9_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		vala_collection_clear ((ValaCollection*) _tmp10_);
		_vala_iterable_unref0 (_tmp10_);
	}
	_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CLASS)) {
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_;
		_tmp15_ = self->priv->_is_abstract;
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp16_;
			_tmp16_ = self->priv->_is_virtual;
			_tmp14_ = _tmp16_;
		}
		_tmp11_ = _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaClass* _tmp19_;
		gboolean _tmp20_ = FALSE;
		ValaClass* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp17_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp19_;
		_tmp21_ = cl;
		_tmp22_ = vala_class_get_is_compact (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_) {
			ValaClass* _tmp24_;
			ValaClass* _tmp25_;
			ValaClass* _tmp26_;
			_tmp24_ = cl;
			_tmp25_ = vala_class_get_base_class (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp20_ = _tmp26_ != NULL;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			ValaSourceReference* _tmp27_;
			ValaSourceReference* _tmp28_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp28_ = _tmp27_;
			vala_report_error (_tmp28_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_;
		_tmp31_ = self->priv->_is_abstract;
		if (_tmp31_) {
			_tmp30_ = TRUE;
		} else {
			gboolean _tmp32_;
			_tmp32_ = self->priv->_is_virtual;
			_tmp30_ = _tmp32_;
		}
		_tmp29_ = _tmp30_;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp34_ = _tmp33_;
		vala_report_error (_tmp34_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp35_ = self->priv->_is_abstract;
	if (_tmp35_) {
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp37_ = _tmp36_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaClass* _tmp40_;
			ValaClass* _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp39_ = _tmp38_;
			_tmp40_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp40_;
			_tmp41_ = cl;
			_tmp42_ = vala_class_get_is_abstract (_tmp41_);
			_tmp43_ = _tmp42_;
			if (!_tmp43_) {
				ValaSourceReference* _tmp44_;
				ValaSourceReference* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp45_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp46_;
			ValaSymbol* _tmp47_;
			_tmp46_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp47_ = _tmp46_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp48_;
				ValaSourceReference* _tmp49_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp49_ = _tmp48_;
				vala_report_error (_tmp49_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp50_;
		_tmp50_ = self->priv->_is_virtual;
		if (_tmp50_) {
			gboolean _tmp51_ = FALSE;
			ValaSymbol* _tmp52_;
			ValaSymbol* _tmp53_;
			_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp53_ = _tmp52_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				_tmp54_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp55_ = _tmp54_;
				_tmp51_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_INTERFACE);
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp57_ = _tmp56_;
				vala_report_error (_tmp57_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp58_;
			_tmp58_ = self->priv->_overrides;
			if (_tmp58_) {
				ValaSymbol* _tmp59_;
				ValaSymbol* _tmp60_;
				_tmp59_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp60_ = _tmp59_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp61_;
					ValaSourceReference* _tmp62_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp62_ = _tmp61_;
					vala_report_error (_tmp62_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp63_;
				ValaSymbolAccessibility _tmp64_;
				_tmp63_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp64_ = _tmp63_;
				if (_tmp64_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp65_ = FALSE;
					ValaSymbol* _tmp66_;
					ValaSymbol* _tmp67_;
					_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp67_ = _tmp66_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp68_;
						ValaSymbol* _tmp69_;
						_tmp68_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp69_ = _tmp68_;
						_tmp65_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, VALA_TYPE_INTERFACE);
					} else {
						_tmp65_ = FALSE;
					}
					if (_tmp65_) {
						ValaSourceReference* _tmp70_;
						ValaSourceReference* _tmp71_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp71_ = _tmp70_;
						vala_report_error (_tmp71_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp73_ = self->priv->_is_abstract;
	if (_tmp73_) {
		ValaBlock* _tmp74_;
		ValaBlock* _tmp75_;
		_tmp74_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp75_ = _tmp74_;
		_tmp72_ = _tmp75_ != NULL;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		vala_report_error (_tmp77_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_ = FALSE;
		gboolean _tmp81_ = FALSE;
		gboolean _tmp82_;
		_tmp82_ = self->priv->_is_abstract;
		if (_tmp82_) {
			_tmp81_ = TRUE;
		} else {
			gboolean _tmp83_;
			_tmp83_ = self->priv->_is_virtual;
			_tmp81_ = _tmp83_;
		}
		if (_tmp81_) {
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp85_ = _tmp84_;
			_tmp80_ = _tmp85_;
		} else {
			_tmp80_ = FALSE;
		}
		if (_tmp80_) {
			gboolean _tmp86_;
			gboolean _tmp87_;
			_tmp86_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp87_ = _tmp86_;
			_tmp79_ = !_tmp87_;
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			ValaSymbol* _tmp88_;
			ValaSymbol* _tmp89_;
			gboolean _tmp90_;
			gboolean _tmp91_;
			_tmp88_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp89_ = _tmp88_;
			_tmp90_ = vala_symbol_get_external (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp78_ = !_tmp91_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			ValaSourceReference* _tmp92_;
			ValaSourceReference* _tmp93_;
			_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp93_ = _tmp92_;
			vala_report_error (_tmp93_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp94_ = FALSE;
			gboolean _tmp95_;
			gboolean _tmp96_;
			_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp96_ = _tmp95_;
			if (_tmp96_) {
				ValaBlock* _tmp97_;
				ValaBlock* _tmp98_;
				_tmp97_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp98_ = _tmp97_;
				_tmp94_ = _tmp98_ != NULL;
			} else {
				_tmp94_ = FALSE;
			}
			if (_tmp94_) {
				ValaSourceReference* _tmp99_;
				ValaSourceReference* _tmp100_;
				_tmp99_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp100_ = _tmp99_;
				vala_report_error (_tmp100_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_ = FALSE;
				gboolean _tmp103_ = FALSE;
				gboolean _tmp104_;
				_tmp104_ = self->priv->_is_abstract;
				if (!_tmp104_) {
					gboolean _tmp105_;
					gboolean _tmp106_;
					_tmp105_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp106_ = _tmp105_;
					_tmp103_ = !_tmp106_;
				} else {
					_tmp103_ = FALSE;
				}
				if (_tmp103_) {
					ValaSourceFileType _tmp107_;
					ValaSourceFileType _tmp108_;
					_tmp107_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp108_ = _tmp107_;
					_tmp102_ = _tmp108_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp102_ = FALSE;
				}
				if (_tmp102_) {
					ValaBlock* _tmp109_;
					ValaBlock* _tmp110_;
					_tmp109_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp110_ = _tmp109_;
					_tmp101_ = _tmp110_ == NULL;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaSourceReference* _tmp111_;
					ValaSourceReference* _tmp112_;
					_tmp111_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp112_ = _tmp111_;
					vala_report_error (_tmp112_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp115_ = self->priv->_coroutine;
	if (_tmp115_) {
		gboolean _tmp116_;
		gboolean _tmp117_;
		_tmp116_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp114_ = !_tmp117_;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		_tmp113_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp119_ = _tmp118_;
		vala_report_error (_tmp119_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp120_ = vala_code_context_get_analyzer (context);
	_tmp121_ = _tmp120_;
	_tmp122_ = vala_semantic_analyzer_get_current_source_file (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = _vala_source_file_ref0 (_tmp123_);
	old_source_file = _tmp124_;
	_tmp125_ = vala_code_context_get_analyzer (context);
	_tmp126_ = _tmp125_;
	_tmp127_ = vala_semantic_analyzer_get_current_symbol (_tmp126_);
	_tmp128_ = _tmp127_;
	_tmp129_ = _vala_code_node_ref0 (_tmp128_);
	old_symbol = _tmp129_;
	_tmp130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp131_ = _tmp130_;
	if (_tmp131_ != NULL) {
		ValaSemanticAnalyzer* _tmp132_;
		ValaSemanticAnalyzer* _tmp133_;
		ValaSourceReference* _tmp134_;
		ValaSourceReference* _tmp135_;
		ValaSourceFile* _tmp136_;
		ValaSourceFile* _tmp137_;
		_tmp132_ = vala_code_context_get_analyzer (context);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_source_reference_get_file (_tmp135_);
		_tmp137_ = _tmp136_;
		vala_semantic_analyzer_set_current_source_file (_tmp133_, _tmp137_);
	}
	_tmp138_ = vala_code_context_get_analyzer (context);
	_tmp139_ = _tmp138_;
	vala_semantic_analyzer_set_current_symbol (_tmp139_, (ValaSymbol*) self);
	_tmp140_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_method_get_returns_floating_reference (self);
	_tmp143_ = _tmp142_;
	vala_data_type_set_floating_reference (_tmp141_, _tmp143_);
	_tmp144_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp145_ = _tmp144_;
	vala_code_node_check ((ValaCodeNode*) _tmp145_, context);
	_tmp146_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp147_ = _vala_code_node_ref0 (_tmp146_);
	init_attr = _tmp147_;
	_tmp148_ = init_attr;
	if (_tmp148_ != NULL) {
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaSourceFile* _tmp151_;
		ValaSourceFile* _tmp152_;
		ValaCodeContext* _tmp153_;
		ValaCodeContext* _tmp154_;
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_source_reference_get_file (_tmp150_);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_source_file_get_context (_tmp152_);
		_tmp154_ = _tmp153_;
		vala_code_context_set_module_init_method (_tmp154_, self);
	}
	_tmp155_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp156_ = _tmp155_;
	if (_tmp156_ != NULL) {
		ValaDataType* _tmp157_;
		ValaDataType* _tmp158_;
		_tmp157_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp158_ = _tmp157_;
		vala_code_node_check ((ValaCodeNode*) _tmp158_, context);
	}
	_tmp162_ = self->priv->parameters;
	_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
	_tmp164_ = _tmp163_;
	if (_tmp164_ == 1) {
		ValaList* _tmp165_;
		gpointer _tmp166_;
		ValaParameter* _tmp167_;
		gboolean _tmp168_;
		gboolean _tmp169_;
		_tmp165_ = self->priv->parameters;
		_tmp166_ = vala_list_get (_tmp165_, 0);
		_tmp167_ = (ValaParameter*) _tmp166_;
		_tmp168_ = vala_parameter_get_ellipsis (_tmp167_);
		_tmp169_ = _tmp168_;
		_tmp161_ = _tmp169_;
		_vala_code_node_unref0 (_tmp167_);
	} else {
		_tmp161_ = FALSE;
	}
	if (_tmp161_) {
		ValaBlock* _tmp170_;
		ValaBlock* _tmp171_;
		_tmp170_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp171_ = _tmp170_;
		_tmp160_ = _tmp171_ != NULL;
	} else {
		_tmp160_ = FALSE;
	}
	if (_tmp160_) {
		ValaMemberBinding _tmp172_;
		_tmp172_ = self->priv->_binding;
		_tmp159_ = _tmp172_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp159_ = FALSE;
	}
	if (_tmp159_) {
		ValaList* _tmp173_;
		gpointer _tmp174_;
		ValaParameter* _tmp175_;
		ValaSourceReference* _tmp176_;
		ValaSourceReference* _tmp177_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp173_ = self->priv->parameters;
		_tmp174_ = vala_list_get (_tmp173_, 0);
		_tmp175_ = (ValaParameter*) _tmp174_;
		_tmp176_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		vala_report_error (_tmp177_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp175_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp178_;
		ValaList* _tmp179_;
		gint _param_size = 0;
		ValaList* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _param_index = 0;
		_tmp178_ = self->priv->parameters;
		_tmp179_ = _vala_iterable_ref0 (_tmp178_);
		_param_list = _tmp179_;
		_tmp180_ = _param_list;
		_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
		_tmp182_ = _tmp181_;
		_param_size = _tmp182_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp183_;
			gint _tmp184_;
			gint _tmp185_;
			ValaParameter* param = NULL;
			ValaList* _tmp186_;
			gint _tmp187_;
			gpointer _tmp188_;
			ValaParameter* _tmp189_;
			gboolean _tmp190_ = FALSE;
			gboolean _tmp191_;
			gboolean _tmp198_ = FALSE;
			gboolean _tmp199_ = FALSE;
			gboolean _tmp200_;
			gboolean _tmp201_;
			gboolean _tmp220_;
			gboolean _tmp221_ = FALSE;
			gboolean _tmp222_ = FALSE;
			gboolean _tmp223_;
			_tmp183_ = _param_index;
			_param_index = _tmp183_ + 1;
			_tmp184_ = _param_index;
			_tmp185_ = _param_size;
			if (!(_tmp184_ < _tmp185_)) {
				break;
			}
			_tmp186_ = _param_list;
			_tmp187_ = _param_index;
			_tmp188_ = vala_list_get (_tmp186_, _tmp187_);
			param = (ValaParameter*) _tmp188_;
			_tmp189_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp189_, context);
			_tmp191_ = self->priv->_coroutine;
			if (_tmp191_) {
				ValaParameter* _tmp192_;
				ValaParameterDirection _tmp193_;
				ValaParameterDirection _tmp194_;
				_tmp192_ = param;
				_tmp193_ = vala_parameter_get_direction (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp190_ = _tmp194_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp190_ = FALSE;
			}
			if (_tmp190_) {
				ValaParameter* _tmp195_;
				ValaSourceReference* _tmp196_;
				ValaSourceReference* _tmp197_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp195_ = param;
				_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp195_);
				_tmp197_ = _tmp196_;
				vala_report_error (_tmp197_, "Reference parameters are not supported for async methods");
			}
			_tmp200_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp201_ = _tmp200_;
			if (!_tmp201_) {
				gboolean _tmp202_;
				_tmp202_ = self->priv->_coroutine;
				_tmp199_ = _tmp202_;
			} else {
				_tmp199_ = FALSE;
			}
			if (_tmp199_) {
				gboolean _tmp203_ = FALSE;
				ValaParameter* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp204_ = param;
				_tmp205_ = vala_parameter_get_ellipsis (_tmp204_);
				_tmp206_ = _tmp205_;
				if (_tmp206_) {
					_tmp203_ = TRUE;
				} else {
					ValaParameter* _tmp207_;
					ValaDataType* _tmp208_;
					ValaDataType* _tmp209_;
					ValaTypeSymbol* _tmp210_;
					ValaTypeSymbol* _tmp211_;
					ValaSemanticAnalyzer* _tmp212_;
					ValaSemanticAnalyzer* _tmp213_;
					ValaDataType* _tmp214_;
					ValaTypeSymbol* _tmp215_;
					ValaTypeSymbol* _tmp216_;
					_tmp207_ = param;
					_tmp208_ = vala_variable_get_variable_type ((ValaVariable*) _tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = vala_data_type_get_data_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = vala_code_context_get_analyzer (context);
					_tmp213_ = _tmp212_;
					_tmp214_ = _tmp213_->va_list_type;
					_tmp215_ = vala_data_type_get_data_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp203_ = _tmp211_ == _tmp216_;
				}
				_tmp198_ = _tmp203_;
			} else {
				_tmp198_ = FALSE;
			}
			if (_tmp198_) {
				ValaParameter* _tmp217_;
				ValaSourceReference* _tmp218_;
				ValaSourceReference* _tmp219_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp217_ = param;
				_tmp218_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp217_);
				_tmp219_ = _tmp218_;
				vala_report_error (_tmp219_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp220_ = self->priv->_coroutine;
			if (_tmp220_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp223_ = optional_param;
			if (_tmp223_) {
				ValaParameter* _tmp224_;
				ValaExpression* _tmp225_;
				ValaExpression* _tmp226_;
				_tmp224_ = param;
				_tmp225_ = vala_variable_get_initializer ((ValaVariable*) _tmp224_);
				_tmp226_ = _tmp225_;
				_tmp222_ = _tmp226_ == NULL;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaParameter* _tmp227_;
				gboolean _tmp228_;
				gboolean _tmp229_;
				_tmp227_ = param;
				_tmp228_ = vala_parameter_get_ellipsis (_tmp227_);
				_tmp229_ = _tmp228_;
				_tmp221_ = !_tmp229_;
			} else {
				_tmp221_ = FALSE;
			}
			if (_tmp221_) {
				ValaParameter* _tmp230_;
				ValaSourceReference* _tmp231_;
				ValaSourceReference* _tmp232_;
				_tmp230_ = param;
				_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp230_);
				_tmp232_ = _tmp231_;
				vala_report_warning (_tmp232_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp233_;
				ValaExpression* _tmp234_;
				ValaExpression* _tmp235_;
				_tmp233_ = param;
				_tmp234_ = vala_variable_get_initializer ((ValaVariable*) _tmp233_);
				_tmp235_ = _tmp234_;
				if (_tmp235_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp236_;
		gint _error_type_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _error_type_index = 0;
		_tmp236_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp236_;
		_tmp237_ = _error_type_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_error_type_size = _tmp239_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			gint _tmp242_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp243_;
			gint _tmp244_;
			gpointer _tmp245_;
			ValaDataType* _tmp246_;
			ValaSemanticAnalyzer* _tmp247_;
			ValaSemanticAnalyzer* _tmp248_;
			ValaDataType* _tmp249_;
			_tmp240_ = _error_type_index;
			_error_type_index = _tmp240_ + 1;
			_tmp241_ = _error_type_index;
			_tmp242_ = _error_type_size;
			if (!(_tmp241_ < _tmp242_)) {
				break;
			}
			_tmp243_ = _error_type_list;
			_tmp244_ = _error_type_index;
			_tmp245_ = vala_list_get (_tmp243_, _tmp244_);
			error_type = (ValaDataType*) _tmp245_;
			_tmp246_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
			_tmp247_ = vala_code_context_get_analyzer (context);
			_tmp248_ = _tmp247_;
			_tmp249_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp248_, (ValaSymbol*) self, _tmp249_)) {
				ValaSourceReference* _tmp250_;
				ValaSourceReference* _tmp251_;
				ValaDataType* _tmp252_;
				gchar* _tmp253_;
				gchar* _tmp254_;
				gchar* _tmp255_;
				gchar* _tmp256_;
				gchar* _tmp257_;
				gchar* _tmp258_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp251_ = _tmp250_;
				_tmp252_ = error_type;
				_tmp253_ = vala_code_node_to_string ((ValaCodeNode*) _tmp252_);
				_tmp254_ = _tmp253_;
				_tmp255_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp256_ = _tmp255_;
				_tmp257_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp254_, _tmp256_);
				_tmp258_ = _tmp257_;
				vala_report_error (_tmp251_, _tmp258_);
				_g_free0 (_tmp258_);
				_g_free0 (_tmp256_);
				_g_free0 (_tmp254_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp259_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp260_ = _tmp259_;
	if (_tmp260_ != NULL) {
		ValaLocalVariable* _tmp261_;
		ValaLocalVariable* _tmp262_;
		_tmp261_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp262_ = _tmp261_;
		vala_code_node_check ((ValaCodeNode*) _tmp262_, context);
	}
	_tmp263_ = self->priv->preconditions;
	if (_tmp263_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp264_;
			ValaList* _tmp265_;
			gint _precondition_size = 0;
			ValaList* _tmp266_;
			gint _tmp267_;
			gint _tmp268_;
			gint _precondition_index = 0;
			_tmp264_ = self->priv->preconditions;
			_tmp265_ = _vala_iterable_ref0 (_tmp264_);
			_precondition_list = _tmp265_;
			_tmp266_ = _precondition_list;
			_tmp267_ = vala_collection_get_size ((ValaCollection*) _tmp266_);
			_tmp268_ = _tmp267_;
			_precondition_size = _tmp268_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp269_;
				gint _tmp270_;
				gint _tmp271_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp272_;
				gint _tmp273_;
				gpointer _tmp274_;
				ValaExpression* _tmp275_;
				_tmp269_ = _precondition_index;
				_precondition_index = _tmp269_ + 1;
				_tmp270_ = _precondition_index;
				_tmp271_ = _precondition_size;
				if (!(_tmp270_ < _tmp271_)) {
					break;
				}
				_tmp272_ = _precondition_list;
				_tmp273_ = _precondition_index;
				_tmp274_ = vala_list_get (_tmp272_, _tmp273_);
				precondition = (ValaExpression*) _tmp274_;
				_tmp275_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp275_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp276_ = self->priv->postconditions;
	if (_tmp276_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp277_;
			ValaList* _tmp278_;
			gint _postcondition_size = 0;
			ValaList* _tmp279_;
			gint _tmp280_;
			gint _tmp281_;
			gint _postcondition_index = 0;
			_tmp277_ = self->priv->postconditions;
			_tmp278_ = _vala_iterable_ref0 (_tmp277_);
			_postcondition_list = _tmp278_;
			_tmp279_ = _postcondition_list;
			_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
			_tmp281_ = _tmp280_;
			_postcondition_size = _tmp281_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp282_;
				gint _tmp283_;
				gint _tmp284_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp285_;
				gint _tmp286_;
				gpointer _tmp287_;
				ValaExpression* _tmp288_;
				_tmp282_ = _postcondition_index;
				_postcondition_index = _tmp282_ + 1;
				_tmp283_ = _postcondition_index;
				_tmp284_ = _postcondition_size;
				if (!(_tmp283_ < _tmp284_)) {
					break;
				}
				_tmp285_ = _postcondition_list;
				_tmp286_ = _postcondition_index;
				_tmp287_ = vala_list_get (_tmp285_, _tmp286_);
				postcondition = (ValaExpression*) _tmp287_;
				_tmp288_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp288_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp289_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp290_ = _tmp289_;
	if (_tmp290_ != NULL) {
		ValaBlock* _tmp291_;
		ValaBlock* _tmp292_;
		_tmp291_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp292_ = _tmp291_;
		vala_code_node_check ((ValaCodeNode*) _tmp292_, context);
	}
	_tmp293_ = vala_code_context_get_analyzer (context);
	_tmp294_ = _tmp293_;
	_tmp295_ = vala_semantic_analyzer_get_current_struct (_tmp294_);
	_tmp296_ = _tmp295_;
	if (_tmp296_ != NULL) {
		gboolean _tmp297_ = FALSE;
		gboolean _tmp298_ = FALSE;
		gboolean _tmp299_;
		_tmp299_ = self->priv->_is_abstract;
		if (_tmp299_) {
			_tmp298_ = TRUE;
		} else {
			gboolean _tmp300_;
			_tmp300_ = self->priv->_is_virtual;
			_tmp298_ = _tmp300_;
		}
		if (_tmp298_) {
			_tmp297_ = TRUE;
		} else {
			gboolean _tmp301_;
			_tmp301_ = self->priv->_overrides;
			_tmp297_ = _tmp301_;
		}
		if (_tmp297_) {
			ValaSourceReference* _tmp302_;
			ValaSourceReference* _tmp303_;
			gchar* _tmp304_;
			gchar* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp302_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp303_ = _tmp302_;
			_tmp304_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp305_);
			_tmp307_ = _tmp306_;
			vala_report_error (_tmp303_, _tmp307_);
			_g_free0 (_tmp307_);
			_g_free0 (_tmp305_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp308_ = FALSE;
		gboolean _tmp309_;
		_tmp309_ = self->priv->_overrides;
		if (_tmp309_) {
			ValaMethod* _tmp310_;
			ValaMethod* _tmp311_;
			_tmp310_ = vala_method_get_base_method (self);
			_tmp311_ = _tmp310_;
			_tmp308_ = _tmp311_ == NULL;
		} else {
			_tmp308_ = FALSE;
		}
		if (_tmp308_) {
			ValaSourceReference* _tmp312_;
			ValaSourceReference* _tmp313_;
			gchar* _tmp314_;
			gchar* _tmp315_;
			gchar* _tmp316_;
			gchar* _tmp317_;
			_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp313_ = _tmp312_;
			_tmp314_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp315_ = _tmp314_;
			_tmp316_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp315_);
			_tmp317_ = _tmp316_;
			vala_report_error (_tmp313_, _tmp317_);
			_g_free0 (_tmp317_);
			_g_free0 (_tmp315_);
		} else {
			gboolean _tmp318_ = FALSE;
			gboolean _tmp319_ = FALSE;
			gboolean _tmp320_ = FALSE;
			gboolean _tmp321_;
			_tmp321_ = self->priv->_is_abstract;
			if (_tmp321_) {
				_tmp320_ = TRUE;
			} else {
				gboolean _tmp322_;
				_tmp322_ = self->priv->_is_virtual;
				_tmp320_ = _tmp322_;
			}
			if (_tmp320_) {
				_tmp319_ = TRUE;
			} else {
				gboolean _tmp323_;
				_tmp323_ = self->priv->_overrides;
				_tmp319_ = _tmp323_;
			}
			if (_tmp319_) {
				ValaSymbolAccessibility _tmp324_;
				ValaSymbolAccessibility _tmp325_;
				_tmp324_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp325_ = _tmp324_;
				_tmp318_ = _tmp325_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp318_ = FALSE;
			}
			if (_tmp318_) {
				ValaSourceReference* _tmp326_;
				ValaSourceReference* _tmp327_;
				gchar* _tmp328_;
				gchar* _tmp329_;
				gchar* _tmp330_;
				gchar* _tmp331_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp326_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp327_ = _tmp326_;
				_tmp328_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp329_ = _tmp328_;
				_tmp330_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp329_);
				_tmp331_ = _tmp330_;
				vala_report_error (_tmp327_, _tmp331_);
				_g_free0 (_tmp331_);
				_g_free0 (_tmp329_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp334_ = vala_method_get_base_interface_type (self);
	_tmp335_ = _tmp334_;
	if (_tmp335_ != NULL) {
		ValaMethod* _tmp336_;
		ValaMethod* _tmp337_;
		_tmp336_ = vala_method_get_base_interface_method (self);
		_tmp337_ = _tmp336_;
		_tmp333_ = _tmp337_ != NULL;
	} else {
		_tmp333_ = FALSE;
	}
	if (_tmp333_) {
		ValaSymbol* _tmp338_;
		ValaSymbol* _tmp339_;
		_tmp338_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp339_ = _tmp338_;
		_tmp332_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp339_, VALA_TYPE_CLASS);
	} else {
		_tmp332_ = FALSE;
	}
	if (_tmp332_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp340_;
		ValaSymbol* _tmp341_;
		ValaClass* _tmp342_;
		_tmp340_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp341_ = _tmp340_;
		_tmp342_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp342_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp343_;
			ValaList* _tmp344_;
			gint _m_size = 0;
			ValaList* _tmp345_;
			gint _tmp346_;
			gint _tmp347_;
			gint _m_index = 0;
			_tmp343_ = cl;
			_tmp344_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp343_);
			_m_list = _tmp344_;
			_tmp345_ = _m_list;
			_tmp346_ = vala_collection_get_size ((ValaCollection*) _tmp345_);
			_tmp347_ = _tmp346_;
			_m_size = _tmp347_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp348_;
				gint _tmp349_;
				gint _tmp350_;
				ValaMethod* m = NULL;
				ValaList* _tmp351_;
				gint _tmp352_;
				gpointer _tmp353_;
				gboolean _tmp354_ = FALSE;
				ValaMethod* _tmp355_;
				_tmp348_ = _m_index;
				_m_index = _tmp348_ + 1;
				_tmp349_ = _m_index;
				_tmp350_ = _m_size;
				if (!(_tmp349_ < _tmp350_)) {
					break;
				}
				_tmp351_ = _m_list;
				_tmp352_ = _m_index;
				_tmp353_ = vala_list_get (_tmp351_, _tmp352_);
				m = (ValaMethod*) _tmp353_;
				_tmp355_ = m;
				if (_tmp355_ != self) {
					ValaMethod* _tmp356_;
					ValaMethod* _tmp357_;
					ValaMethod* _tmp358_;
					ValaMethod* _tmp359_;
					ValaMethod* _tmp360_;
					_tmp356_ = m;
					_tmp357_ = vala_method_get_base_interface_method (_tmp356_);
					_tmp358_ = _tmp357_;
					_tmp359_ = vala_method_get_base_interface_method (self);
					_tmp360_ = _tmp359_;
					_tmp354_ = _tmp358_ == _tmp360_;
				} else {
					_tmp354_ = FALSE;
				}
				if (_tmp354_) {
					ValaMethod* _tmp361_;
					ValaMethod* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaSourceReference* _tmp364_;
					ValaClass* _tmp365_;
					gchar* _tmp366_;
					gchar* _tmp367_;
					ValaMethod* _tmp368_;
					ValaMethod* _tmp369_;
					gchar* _tmp370_;
					gchar* _tmp371_;
					gchar* _tmp372_;
					gchar* _tmp373_;
					ValaMethod* _tmp374_;
					ValaSourceReference* _tmp375_;
					ValaSourceReference* _tmp376_;
					ValaMethod* _tmp377_;
					ValaMethod* _tmp378_;
					gchar* _tmp379_;
					gchar* _tmp380_;
					gchar* _tmp381_;
					gchar* _tmp382_;
					_tmp361_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp361_, TRUE);
					_tmp362_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp362_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp364_ = _tmp363_;
					_tmp365_ = cl;
					_tmp366_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = vala_method_get_base_interface_method (self);
					_tmp369_ = _tmp368_;
					_tmp370_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp369_);
					_tmp371_ = _tmp370_;
					_tmp372_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp367_, _tmp371_);
					_tmp373_ = _tmp372_;
					vala_report_error (_tmp364_, _tmp373_);
					_g_free0 (_tmp373_);
					_g_free0 (_tmp371_);
					_g_free0 (_tmp367_);
					_tmp374_ = m;
					_tmp375_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp374_);
					_tmp376_ = _tmp375_;
					_tmp377_ = vala_method_get_base_interface_method (self);
					_tmp378_ = _tmp377_;
					_tmp379_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp378_);
					_tmp380_ = _tmp379_;
					_tmp381_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp380_);
					_tmp382_ = _tmp381_;
					vala_report_notice (_tmp376_, _tmp382_);
					_g_free0 (_tmp382_);
					_g_free0 (_tmp380_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp383_ = vala_code_context_get_analyzer (context);
	_tmp384_ = _tmp383_;
	_tmp385_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp384_, _tmp385_);
	_tmp386_ = vala_code_context_get_analyzer (context);
	_tmp387_ = _tmp386_;
	_tmp388_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp387_, _tmp388_);
	_tmp392_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp393_ = _tmp392_;
	if (!_tmp393_) {
		gboolean _tmp394_;
		_tmp394_ = self->priv->_overrides;
		_tmp391_ = !_tmp394_;
	} else {
		_tmp391_ = FALSE;
	}
	if (_tmp391_) {
		gboolean _tmp395_;
		gboolean _tmp396_;
		_tmp395_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp396_ = _tmp395_;
		_tmp390_ = !_tmp396_;
	} else {
		_tmp390_ = FALSE;
	}
	if (_tmp390_) {
		ValaSymbol* _tmp397_;
		ValaSymbol* _tmp398_;
		_tmp397_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp398_ = _tmp397_;
		_tmp389_ = _tmp398_ != NULL;
		_vala_code_node_unref0 (_tmp398_);
	} else {
		_tmp389_ = FALSE;
	}
	if (_tmp389_) {
		ValaSourceReference* _tmp399_;
		ValaSourceReference* _tmp400_;
		gchar* _tmp401_;
		gchar* _tmp402_;
		ValaSymbol* _tmp403_;
		ValaSymbol* _tmp404_;
		gchar* _tmp405_;
		gchar* _tmp406_;
		gchar* _tmp407_;
		gchar* _tmp408_;
		_tmp399_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp400_ = _tmp399_;
		_tmp401_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp402_ = _tmp401_;
		_tmp403_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp404_ = _tmp403_;
		_tmp405_ = vala_symbol_get_full_name (_tmp404_);
		_tmp406_ = _tmp405_;
		_tmp407_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp402_, _tmp406_);
		_tmp408_ = _tmp407_;
		vala_report_warning (_tmp400_, _tmp408_);
		_g_free0 (_tmp408_);
		_g_free0 (_tmp406_);
		_vala_code_node_unref0 (_tmp404_);
		_g_free0 (_tmp402_);
	}
	_tmp409_ = vala_code_context_get_analyzer (context);
	_tmp410_ = _tmp409_;
	_tmp411_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp412_ = _tmp411_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp410_, (ValaSymbol*) self, _tmp412_)) {
		ValaSourceReference* _tmp413_;
		ValaSourceReference* _tmp414_;
		ValaDataType* _tmp415_;
		ValaDataType* _tmp416_;
		gchar* _tmp417_;
		gchar* _tmp418_;
		gchar* _tmp419_;
		gchar* _tmp420_;
		gchar* _tmp421_;
		gchar* _tmp422_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp413_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp414_ = _tmp413_;
		_tmp415_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp416_ = _tmp415_;
		_tmp417_ = vala_code_node_to_string ((ValaCodeNode*) _tmp416_);
		_tmp418_ = _tmp417_;
		_tmp419_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp420_ = _tmp419_;
		_tmp421_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp418_, _tmp420_);
		_tmp422_ = _tmp421_;
		vala_report_error (_tmp414_, _tmp422_);
		_g_free0 (_tmp422_);
		_g_free0 (_tmp420_);
		_g_free0 (_tmp418_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp423_;
		gint _precondition_size = 0;
		ValaList* _tmp424_;
		gint _tmp425_;
		gint _tmp426_;
		gint _precondition_index = 0;
		_tmp423_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp423_;
		_tmp424_ = _precondition_list;
		_tmp425_ = vala_collection_get_size ((ValaCollection*) _tmp424_);
		_tmp426_ = _tmp425_;
		_precondition_size = _tmp426_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp427_;
			gint _tmp428_;
			gint _tmp429_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp430_;
			gint _tmp431_;
			gpointer _tmp432_;
			ValaExpression* _tmp433_;
			gboolean _tmp434_;
			gboolean _tmp435_;
			ValaExpression* _tmp436_;
			ValaDataType* _tmp437_;
			ValaDataType* _tmp438_;
			ValaSemanticAnalyzer* _tmp439_;
			ValaSemanticAnalyzer* _tmp440_;
			ValaDataType* _tmp441_;
			_tmp427_ = _precondition_index;
			_precondition_index = _tmp427_ + 1;
			_tmp428_ = _precondition_index;
			_tmp429_ = _precondition_size;
			if (!(_tmp428_ < _tmp429_)) {
				break;
			}
			_tmp430_ = _precondition_list;
			_tmp431_ = _precondition_index;
			_tmp432_ = vala_list_get (_tmp430_, _tmp431_);
			precondition = (ValaExpression*) _tmp432_;
			_tmp433_ = precondition;
			_tmp434_ = vala_code_node_get_error ((ValaCodeNode*) _tmp433_);
			_tmp435_ = _tmp434_;
			if (_tmp435_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp436_ = precondition;
			_tmp437_ = vala_expression_get_value_type (_tmp436_);
			_tmp438_ = _tmp437_;
			_tmp439_ = vala_code_context_get_analyzer (context);
			_tmp440_ = _tmp439_;
			_tmp441_ = _tmp440_->bool_type;
			if (!vala_data_type_compatible (_tmp438_, _tmp441_)) {
				ValaExpression* _tmp442_;
				ValaSourceReference* _tmp443_;
				ValaSourceReference* _tmp444_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp442_ = precondition;
				_tmp443_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp442_);
				_tmp444_ = _tmp443_;
				vala_report_error (_tmp444_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp445_;
		gint _postcondition_size = 0;
		ValaList* _tmp446_;
		gint _tmp447_;
		gint _tmp448_;
		gint _postcondition_index = 0;
		_tmp445_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp445_;
		_tmp446_ = _postcondition_list;
		_tmp447_ = vala_collection_get_size ((ValaCollection*) _tmp446_);
		_tmp448_ = _tmp447_;
		_postcondition_size = _tmp448_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp449_;
			gint _tmp450_;
			gint _tmp451_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp452_;
			gint _tmp453_;
			gpointer _tmp454_;
			ValaExpression* _tmp455_;
			gboolean _tmp456_;
			gboolean _tmp457_;
			ValaExpression* _tmp458_;
			ValaDataType* _tmp459_;
			ValaDataType* _tmp460_;
			ValaSemanticAnalyzer* _tmp461_;
			ValaSemanticAnalyzer* _tmp462_;
			ValaDataType* _tmp463_;
			_tmp449_ = _postcondition_index;
			_postcondition_index = _tmp449_ + 1;
			_tmp450_ = _postcondition_index;
			_tmp451_ = _postcondition_size;
			if (!(_tmp450_ < _tmp451_)) {
				break;
			}
			_tmp452_ = _postcondition_list;
			_tmp453_ = _postcondition_index;
			_tmp454_ = vala_list_get (_tmp452_, _tmp453_);
			postcondition = (ValaExpression*) _tmp454_;
			_tmp455_ = postcondition;
			_tmp456_ = vala_code_node_get_error ((ValaCodeNode*) _tmp455_);
			_tmp457_ = _tmp456_;
			if (_tmp457_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp458_ = postcondition;
			_tmp459_ = vala_expression_get_value_type (_tmp458_);
			_tmp460_ = _tmp459_;
			_tmp461_ = vala_code_context_get_analyzer (context);
			_tmp462_ = _tmp461_;
			_tmp463_ = _tmp462_->bool_type;
			if (!vala_data_type_compatible (_tmp460_, _tmp463_)) {
				ValaExpression* _tmp464_;
				ValaSourceReference* _tmp465_;
				ValaSourceReference* _tmp466_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp464_ = postcondition;
				_tmp465_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp464_);
				_tmp466_ = _tmp465_;
				vala_report_error (_tmp466_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp467_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp468_ = _tmp467_;
	if (_tmp468_ != NULL) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp469_;
			ValaBlock* _tmp470_;
			ValaList* _tmp471_;
			gint _body_error_type_size = 0;
			ValaList* _tmp472_;
			gint _tmp473_;
			gint _tmp474_;
			gint _body_error_type_index = 0;
			_tmp469_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp470_ = _tmp469_;
			_tmp471_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp470_);
			_body_error_type_list = _tmp471_;
			_tmp472_ = _body_error_type_list;
			_tmp473_ = vala_collection_get_size ((ValaCollection*) _tmp472_);
			_tmp474_ = _tmp473_;
			_body_error_type_size = _tmp474_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp475_;
				gint _tmp476_;
				gint _tmp477_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp478_;
				gint _tmp479_;
				gpointer _tmp480_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp493_ = FALSE;
				ValaDataType* _tmp494_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp498_ = FALSE;
				gboolean _tmp499_;
				_tmp475_ = _body_error_type_index;
				_body_error_type_index = _tmp475_ + 1;
				_tmp476_ = _body_error_type_index;
				_tmp477_ = _body_error_type_size;
				if (!(_tmp476_ < _tmp477_)) {
					break;
				}
				_tmp478_ = _body_error_type_list;
				_tmp479_ = _body_error_type_index;
				_tmp480_ = vala_list_get (_tmp478_, _tmp479_);
				body_error_type = (ValaDataType*) _tmp480_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp481_;
					gint _method_error_type_size = 0;
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					gint _method_error_type_index = 0;
					_tmp481_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp481_;
					_tmp482_ = _method_error_type_list;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_method_error_type_size = _tmp484_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp485_;
						gint _tmp486_;
						gint _tmp487_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp488_;
						gint _tmp489_;
						gpointer _tmp490_;
						ValaDataType* _tmp491_;
						ValaDataType* _tmp492_;
						_tmp485_ = _method_error_type_index;
						_method_error_type_index = _tmp485_ + 1;
						_tmp486_ = _method_error_type_index;
						_tmp487_ = _method_error_type_size;
						if (!(_tmp486_ < _tmp487_)) {
							break;
						}
						_tmp488_ = _method_error_type_list;
						_tmp489_ = _method_error_type_index;
						_tmp490_ = vala_list_get (_tmp488_, _tmp489_);
						method_error_type = (ValaDataType*) _tmp490_;
						_tmp491_ = body_error_type;
						_tmp492_ = method_error_type;
						if (vala_data_type_compatible (_tmp491_, _tmp492_)) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp494_ = body_error_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp494_, VALA_TYPE_ERROR_TYPE)) {
					ValaDataType* _tmp495_;
					gboolean _tmp496_;
					gboolean _tmp497_;
					_tmp495_ = body_error_type;
					_tmp496_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp495_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp497_ = _tmp496_;
					_tmp493_ = _tmp497_;
				} else {
					_tmp493_ = FALSE;
				}
				is_dynamic_error = _tmp493_;
				_tmp499_ = can_propagate_error;
				if (!_tmp499_) {
					gboolean _tmp500_;
					_tmp500_ = is_dynamic_error;
					_tmp498_ = !_tmp500_;
				} else {
					_tmp498_ = FALSE;
				}
				if (_tmp498_) {
					ValaDataType* _tmp501_;
					ValaSourceReference* _tmp502_;
					ValaSourceReference* _tmp503_;
					ValaDataType* _tmp504_;
					gchar* _tmp505_;
					gchar* _tmp506_;
					gchar* _tmp507_;
					gchar* _tmp508_;
					_tmp501_ = body_error_type;
					_tmp502_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp501_);
					_tmp503_ = _tmp502_;
					_tmp504_ = body_error_type;
					_tmp505_ = vala_code_node_to_string ((ValaCodeNode*) _tmp504_);
					_tmp506_ = _tmp505_;
					_tmp507_ = g_strdup_printf ("unhandled error `%s'", _tmp506_);
					_tmp508_ = _tmp507_;
					vala_report_warning (_tmp503_, _tmp508_);
					_g_free0 (_tmp508_);
					_g_free0 (_tmp506_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
		ValaMemberBinding _tmp514_;
		_tmp514_ = self->priv->_binding;
		_tmp513_ = _tmp514_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp513_ = FALSE;
	}
	if (_tmp513_) {
		gboolean _tmp515_;
		_tmp515_ = self->priv->_overrides;
		_tmp512_ = !_tmp515_;
	} else {
		_tmp512_ = FALSE;
	}
	if (_tmp512_) {
		ValaSymbolAccessibility _tmp516_;
		ValaSymbolAccessibility _tmp517_;
		_tmp516_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp517_ = _tmp516_;
		_tmp511_ = _tmp517_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp511_ = FALSE;
	}
	if (_tmp511_) {
		ValaSymbol* _tmp518_;
		ValaSymbol* _tmp519_;
		_tmp518_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp519_ = _tmp518_;
		_tmp510_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp519_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
	} else {
		_tmp510_ = FALSE;
	}
	if (_tmp510_) {
		ValaSymbol* _tmp520_;
		ValaSymbol* _tmp521_;
		ValaAttribute* _tmp522_;
		_tmp520_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp521_ = _tmp520_;
		_tmp522_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp521_, "DBus");
		_tmp509_ = _tmp522_ != NULL;
	} else {
		_tmp509_ = FALSE;
	}
	if (_tmp509_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp523_;
		ValaAttribute* _tmp524_;
		gboolean _tmp525_ = FALSE;
		ValaAttribute* _tmp526_;
		_tmp523_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp524_ = _vala_code_node_ref0 (_tmp523_);
		dbus_attr = _tmp524_;
		_tmp526_ = dbus_attr;
		if (_tmp526_ == NULL) {
			_tmp525_ = TRUE;
		} else {
			ValaAttribute* _tmp527_;
			_tmp527_ = dbus_attr;
			_tmp525_ = vala_attribute_get_bool (_tmp527_, "visible", TRUE);
		}
		if (_tmp525_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			gboolean _tmp547_ = FALSE;
			gboolean _tmp548_;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			{
				ValaList* _error_type_list = NULL;
				ValaList* _tmp528_;
				gint _error_type_size = 0;
				ValaList* _tmp529_;
				gint _tmp530_;
				gint _tmp531_;
				gint _error_type_index = 0;
				_tmp528_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
				_error_type_list = _tmp528_;
				_tmp529_ = _error_type_list;
				_tmp530_ = vala_collection_get_size ((ValaCollection*) _tmp529_);
				_tmp531_ = _tmp530_;
				_error_type_size = _tmp531_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp532_;
					gint _tmp533_;
					gint _tmp534_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp535_;
					gint _tmp536_;
					gpointer _tmp537_;
					ValaDataType* _tmp538_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp539_;
					ValaErrorDomain* _tmp540_;
					ValaErrorDomain* _tmp541_;
					ValaErrorDomain* _tmp542_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp543_;
					gchar* _tmp544_;
					const gchar* _tmp545_;
					_tmp532_ = _error_type_index;
					_error_type_index = _tmp532_ + 1;
					_tmp533_ = _error_type_index;
					_tmp534_ = _error_type_size;
					if (!(_tmp533_ < _tmp534_)) {
						break;
					}
					_tmp535_ = _error_type_list;
					_tmp536_ = _error_type_index;
					_tmp537_ = vala_list_get (_tmp535_, _tmp536_);
					error_type = (ValaDataType*) _tmp537_;
					_tmp538_ = error_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp538_, VALA_TYPE_ERROR_TYPE)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp539_ = error_type;
					_tmp540_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp541_ = _tmp540_;
					error_domain = _tmp541_;
					_tmp542_ = error_domain;
					if (_tmp542_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp543_ = error_domain;
					_tmp544_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp543_);
					full_error_domain = _tmp544_;
					_tmp545_ = full_error_domain;
					if (g_strcmp0 (_tmp545_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp546_;
						_tmp546_ = full_error_domain;
						if (g_strcmp0 (_tmp546_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp548_ = throws_gerror;
			if (!_tmp548_) {
				gboolean _tmp549_ = FALSE;
				gboolean _tmp550_;
				_tmp550_ = throws_gioerror;
				if (_tmp550_) {
					gboolean _tmp551_;
					_tmp551_ = throws_gdbuserror;
					_tmp549_ = _tmp551_;
				} else {
					_tmp549_ = FALSE;
				}
				_tmp547_ = !_tmp549_;
			} else {
				_tmp547_ = FALSE;
			}
			if (_tmp547_) {
				ValaSourceReference* _tmp552_;
				ValaSourceReference* _tmp553_;
				_tmp552_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp553_ = _tmp552_;
				vala_report_warning (_tmp553_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp554_;
		ValaMethod* _tmp555_;
		gboolean _tmp564_;
		gboolean _tmp565_;
		gboolean _tmp568_;
		gboolean _tmp571_;
		_tmp554_ = vala_code_context_get_entry_point (context);
		_tmp555_ = _tmp554_;
		if (_tmp555_ != NULL) {
			ValaSourceReference* _tmp556_;
			ValaSourceReference* _tmp557_;
			ValaMethod* _tmp558_;
			ValaMethod* _tmp559_;
			gchar* _tmp560_;
			gchar* _tmp561_;
			gchar* _tmp562_;
			gchar* _tmp563_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp556_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp557_ = _tmp556_;
			_tmp558_ = vala_code_context_get_entry_point (context);
			_tmp559_ = _tmp558_;
			_tmp560_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp559_);
			_tmp561_ = _tmp560_;
			_tmp562_ = g_strdup_printf ("program already has an entry point `%s'", _tmp561_);
			_tmp563_ = _tmp562_;
			vala_report_error (_tmp557_, _tmp563_);
			_g_free0 (_tmp563_);
			_g_free0 (_tmp561_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp564_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp565_ = _tmp564_;
		if (_tmp565_) {
			ValaSourceReference* _tmp566_;
			ValaSourceReference* _tmp567_;
			_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp567_ = _tmp566_;
			vala_report_error (_tmp567_, "\"main\" method cannot throw errors");
		}
		_tmp568_ = self->priv->_is_inline;
		if (_tmp568_) {
			ValaSourceReference* _tmp569_;
			ValaSourceReference* _tmp570_;
			_tmp569_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp570_ = _tmp569_;
			vala_report_error (_tmp570_, "\"main\" method cannot be inline");
		}
		_tmp571_ = self->priv->_coroutine;
		if (_tmp571_) {
			ValaSourceReference* _tmp572_;
			ValaSourceReference* _tmp573_;
			_tmp572_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp573_ = _tmp572_;
			vala_report_error (_tmp573_, "\"main\" method cannot be async");
		}
	}
	_tmp574_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp574_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp575_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp576_ = _tmp575_;
	result = !_tmp576_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}


gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaParameter* _tmp12_;
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			gint _tmp18_;
			_tmp5_ = _param_index;
			_param_index = _tmp5_ + 1;
			_tmp6_ = _param_index;
			_tmp7_ = _param_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = _param_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			param = (ValaParameter*) _tmp10_;
			_tmp12_ = param;
			_tmp13_ = vala_variable_get_initializer ((ValaVariable*) _tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				_tmp11_ = TRUE;
			} else {
				ValaParameter* _tmp15_;
				gboolean _tmp16_;
				gboolean _tmp17_;
				_tmp15_ = param;
				_tmp16_ = vala_parameter_get_ellipsis (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_;
			}
			if (_tmp11_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp18_ = n;
			n = _tmp18_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}


ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp39_;
	ValaMethod* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp38_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ValaParameter* param = NULL;
				ValaList* _tmp19_;
				gint _tmp20_;
				gpointer _tmp21_;
				ValaMethod* _tmp22_;
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp16_ = _param_index;
				_param_index = _tmp16_ + 1;
				_tmp17_ = _param_index;
				_tmp18_ = _param_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _param_list;
				_tmp20_ = _param_index;
				_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
				param = (ValaParameter*) _tmp21_;
				_tmp22_ = self->priv->end_method;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_copy (_tmp23_);
				_tmp25_ = _tmp24_;
				vala_callable_add_parameter ((ValaCallable*) _tmp22_, _tmp25_);
				_vala_code_node_unref0 (_tmp25_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp26_;
			gint _param_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _param_index = 0;
			_tmp26_ = vala_method_get_type_parameters (self);
			_param_list = _tmp26_;
			_tmp27_ = _param_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_param_size = _tmp29_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				ValaMethod* _tmp36_;
				ValaTypeParameter* _tmp37_;
				_tmp30_ = _param_index;
				_param_index = _tmp30_ + 1;
				_tmp31_ = _param_index;
				_tmp32_ = _param_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _param_list;
				_tmp34_ = _param_index;
				_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
				param = (ValaTypeParameter*) _tmp35_;
				_tmp36_ = self->priv->end_method;
				_tmp37_ = param;
				vala_method_add_type_parameter (_tmp36_, _tmp37_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp38_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp38_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp39_ = self->priv->end_method;
	_tmp40_ = _vala_code_node_ref0 (_tmp39_);
	result = _tmp40_;
	return result;
}


ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}


ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp32_;
	ValaScope* _tmp33_;
	ValaScope* _tmp34_;
	ValaSymbol* _tmp35_;
	ValaDelegate* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaDelegateType* _tmp41_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp42_;
	ValaParameter* _tmp43_;
	ValaParameter* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaSourceReference* _tmp46_;
	ValaNullLiteral* _tmp47_;
	ValaNullLiteral* _tmp48_;
	ValaParameter* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaDelegateType* _tmp52_;
	ValaDataType* _tmp53_;
	ValaDataType* _tmp54_;
	ValaParameter* _tmp55_;
	ValaParameter* _tmp56_;
	ValaArrayList* _tmp57_;
	ValaParameter* _tmp58_;
	ValaParameter* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaParameter* param = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp16_ = _param_index;
			_param_index = _tmp16_ + 1;
			_tmp17_ = _param_index;
			_tmp18_ = _param_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _param_list;
			_tmp20_ = _param_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			_tmp23_ = vala_parameter_get_ellipsis (_tmp22_);
			_tmp24_ = _tmp23_;
			if (_tmp24_) {
				ValaParameter* _tmp25_;
				ValaParameter* _tmp26_;
				_tmp25_ = param;
				_tmp26_ = _vala_code_node_ref0 (_tmp25_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp26_;
			} else {
				ValaParameter* _tmp27_;
				ValaParameterDirection _tmp28_;
				ValaParameterDirection _tmp29_;
				_tmp27_ = param;
				_tmp28_ = vala_parameter_get_direction (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp30_;
					ValaParameter* _tmp31_;
					_tmp30_ = params;
					_tmp31_ = param;
					vala_collection_add ((ValaCollection*) _tmp30_, _tmp31_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp32_ = glib_ns;
	_tmp33_ = vala_symbol_get_scope (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_scope_lookup (_tmp34_, "AsyncReadyCallback");
	_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp37_ = vala_delegate_type_new (_tmp36_);
	_tmp38_ = _tmp37_;
	_vala_code_node_unref0 (_tmp36_);
	callback_type = _tmp38_;
	_tmp39_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp39_, TRUE);
	_tmp40_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp40_, TRUE);
	_tmp41_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp41_, TRUE);
	_tmp42_ = callback_type;
	_tmp43_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp42_, NULL);
	callback_param = _tmp43_;
	_tmp44_ = callback_param;
	_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_null_literal_new (_tmp46_);
	_tmp48_ = _tmp47_;
	vala_variable_set_initializer ((ValaVariable*) _tmp44_, (ValaExpression*) _tmp48_);
	_vala_code_node_unref0 (_tmp48_);
	_tmp49_ = callback_param;
	_tmp50_ = vala_variable_get_initializer ((ValaVariable*) _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = callback_type;
	_tmp53_ = vala_data_type_copy ((ValaDataType*) _tmp52_);
	_tmp54_ = _tmp53_;
	vala_expression_set_target_type (_tmp51_, _tmp54_);
	_vala_code_node_unref0 (_tmp54_);
	_tmp55_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp55_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp56_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp56_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp57_ = params;
	_tmp58_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp57_, _tmp58_);
	_tmp59_ = ellipsis;
	if (_tmp59_ != NULL) {
		ValaArrayList* _tmp60_;
		ValaParameter* _tmp61_;
		_tmp60_ = params;
		_tmp61_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp60_, _tmp61_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaParameter* param = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaParameter* _tmp34_;
			ValaParameterDirection _tmp35_;
			ValaParameterDirection _tmp36_;
			_tmp28_ = _param_index;
			_param_index = _tmp28_ + 1;
			_tmp29_ = _param_index;
			_tmp30_ = _param_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _param_list;
			_tmp32_ = _param_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			param = (ValaParameter*) _tmp33_;
			_tmp34_ = param;
			_tmp35_ = vala_parameter_get_direction (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp37_;
				ValaParameter* _tmp38_;
				_tmp37_ = params;
				_tmp38_ = param;
				vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}


void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				ValaLocalVariable* _tmp12_;
				_tmp6_ = _local_index;
				_local_index = _tmp6_ + 1;
				_tmp7_ = _local_index;
				_tmp8_ = _local_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _local_list;
				_tmp10_ = _local_index;
				_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
				local = (ValaLocalVariable*) _tmp11_;
				_tmp12_ = local;
				vala_collection_add (variables, _tmp12_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}


static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	gboolean _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_closure;
	if (_tmp0_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaParameter* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->parameters;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->parameters;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaParameter*) _tmp8_;
				_tmp10_ = vala_parameter_get_format_arg (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp12_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean result = FALSE;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ValaMethod* _tmp7_;
	ValaMethod* _tmp8_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaMethod* _tmp15_;
	ValaMethod* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ > 0;
	_vala_iterable_unref0 (_tmp1_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = vala_method_get_base_method (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		_tmp9_ = vala_method_get_base_method (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != self;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMethod* _tmp11_;
		ValaMethod* _tmp12_;
		_tmp11_ = vala_method_get_base_method (self);
		_tmp12_ = _tmp11_;
		_tmp5_ = vala_method_has_error_type_parameter (_tmp12_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	_tmp15_ = vala_method_get_base_interface_method (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		_tmp17_ = vala_method_get_base_interface_method (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ != self;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		_tmp19_ = vala_method_get_base_interface_method (self);
		_tmp20_ = _tmp19_;
		_tmp13_ = vala_method_has_error_type_parameter (_tmp20_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VOID_TYPE);
	return result;
}


ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_inline;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}


gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}


void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}


gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}


void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}


ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}


ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}


ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}


void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}


static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}


ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}


gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}


void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}


gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}


void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}


gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}


void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}


ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}


void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}


gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closure;
	result = _tmp0_;
	return result;
}


void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}


gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_coroutine;
	result = _tmp0_;
	return result;
}


void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}


gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_async_callback;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}


static void
vala_method_class_init (ValaMethodClass * klass)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}


static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}


static void
vala_method_instance_init (ValaMethod * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}



