/* documentationparser.c generated by valac, the Vala compiler
 * generated from documentationparser.vala, do not modify */

/* documentationparser.vala
 *
 * Copyright (C) 2008-2009 Didier Villevalois
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_DOCUMENTATION_PARSER_0_PROPERTY,
	VALADOC_DOCUMENTATION_PARSER_NUM_PROPERTIES
};
static GParamSpec* valadoc_documentation_parser_properties[VALADOC_DOCUMENTATION_PARSER_NUM_PROPERTIES];
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _valadoc_importer_internal_id_registrar_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_importer_internal_id_registrar_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _valadoc_api_source_comment_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_source_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocDocumentationParserPrivate {
	ValaHashMap* metadata;
	ValadocImporterInternalIdRegistrar* id_registrar;
	ValadocGtkdocParser* gtkdoc_parser;
	ValadocGtkdocMarkdownParser* gtkdoc_markdown_parser;
	ValadocSettings* _settings;
	ValadocErrorReporter* _reporter;
	ValadocApiTree* _tree;
	ValadocModuleLoader* _modules;
	ValadocContentContentFactory* _factory;
	ValadocWikiScanner* _wiki_scanner;
	ValadocCommentScanner* _comment_scanner;
	ValadocParser* _wiki_parser;
	ValadocParser* _comment_parser;
	ValadocParser* _parser;
	ValadocScanner* _scanner;
	ValaArrayList* _stack;
	ValadocRule* multiline_block_run;
	ValadocRule* multiline_run;
	gint current_level;
	gint* levels;
	gint levels_length1;
	gint _levels_size_;
};


static gint ValadocDocumentationParser_private_offset;
static gpointer valadoc_documentation_parser_parent_class = NULL;
static ValadocResourceLocatorIface * valadoc_documentation_parser_valadoc_resource_locator_parent_iface = NULL;

static void valadoc_documentation_parser_init_valadoc_rules (ValadocDocumentationParser* self);
static ValadocGirMetaData* valadoc_documentation_parser_get_metadata_for_comment (ValadocDocumentationParser* self,
                                                                           ValadocApiGirSourceComment* gir_comment);
static ValadocContentComment* valadoc_documentation_parser_parse_comment (ValadocDocumentationParser* self,
                                                                   const gchar* content,
                                                                   const gchar* filename,
                                                                   gint first_line,
                                                                   gint first_column,
                                                                   GError** error);
static ValadocContentPage* valadoc_documentation_parser_parse_wiki (ValadocDocumentationParser* self,
                                                             const gchar* content,
                                                             const gchar* filename,
                                                             GError** error);
static GObject* valadoc_documentation_parser_pop (ValadocDocumentationParser* self);
G_GNUC_INTERNAL void valadoc_api_item_parse_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_api_item_check_comments (ValadocApiItem* self,
                                      ValadocSettings* settings,
                                      ValadocDocumentationParser* parser);
G_GNUC_INTERNAL void valadoc_taglets_inherit_doc_transform (ValadocTagletsInheritDoc* self,
                                            ValadocApiTree* api_root,
                                            ValadocApiNode* container,
                                            const gchar* file_path,
                                            ValadocErrorReporter* reporter,
                                            ValadocSettings* settings);
static gchar* valadoc_documentation_parser_real_resolve (ValadocResourceLocator* base,
                                                  const gchar* path);
static void valadoc_documentation_parser_push (ValadocDocumentationParser* self,
                                        GObject* element);
static GObject* valadoc_documentation_parser_peek (ValadocDocumentationParser* self,
                                            gint offset);
static void valadoc_documentation_parser_new_list_item (ValadocDocumentationParser* self,
                                                 ValadocContentListBullet bullet,
                                                 GError** error);
static void _vala_array_add1 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static gchar* valadoc_documentation_parser_bullet_type_string (ValadocDocumentationParser* self,
                                                        ValadocContentListBullet bullet);
static void _vala_array_add2 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void valadoc_documentation_parser_finish_list (ValadocDocumentationParser* self);
static void valadoc_documentation_parser_add_content_string (ValadocDocumentationParser* self,
                                                      const gchar* str);
static void valadoc_documentation_parser_add_content_space (ValadocDocumentationParser* self,
                                                     ValadocToken* token,
                                                     GError** error);
static void valadoc_documentation_parser_add_text (ValadocDocumentationParser* self,
                                            ValadocToken* token,
                                            GError** error);
static void _valadoc_documentation_parser_add_content_space_valadoc_token_type_action (ValadocToken* token,
                                                                                gpointer self,
                                                                                GError** error);
static void _valadoc_documentation_parser_add_text_valadoc_token_type_action (ValadocToken* token,
                                                                       gpointer self,
                                                                       GError** error);
static void __lambda56_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda56__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda57_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda57__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda58_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda58__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda59_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda59__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda60_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda60__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda61_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda61__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda62_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda62__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda63_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda63__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda64_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda64__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda65_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda65__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda66_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda66__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda67_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda67__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda68_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda68__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda69_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda69__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda70_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda70__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda71_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda71__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda72_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda72__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda73_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda73__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda74_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda74__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda75_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda75__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda76_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda76__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda77_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda77__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda78_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda78__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda79_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda79__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda80_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda80__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda81_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda81__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda82_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda82__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda83_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda83__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda84_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda84__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda85_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda85__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda86_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda86__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda87_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda87__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda88_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda88__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda89_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda89__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda90_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda90__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda91_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda91__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda92_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda92__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda93_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda93__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda94_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda94__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda95_ (ValadocDocumentationParser* self,
                  ValadocToken* token,
                  GError** error);
static void ___lambda95__valadoc_token_type_action (ValadocToken* token,
                                             gpointer self,
                                             GError** error);
static void __lambda96_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda96__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda97_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda97__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda98_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda98__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda99_ (ValadocDocumentationParser* self,
                  GError** error);
static void ___lambda99__valadoc_rule_action (gpointer self,
                                       GError** error);
static void __lambda100_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda100__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda101_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda101__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda102_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda102__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda103_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda103__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda104_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda104__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda105_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda105__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda106_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda106__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda107_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda107__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda108_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda108__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda109_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda109__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda110_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda110__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda111_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda111__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda112_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda112__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda113_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda113__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda114_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda114__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda115_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda115__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda116_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda116__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda117_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda117__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda118_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda118__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda119_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda119__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda120_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda120__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda121_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda121__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda122_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda122__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda123_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda123__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda124_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda124__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda125_ (ValadocDocumentationParser* self,
                   ValadocToken* token,
                   GError** error);
static void ___lambda125__valadoc_token_type_action (ValadocToken* token,
                                              gpointer self,
                                              GError** error);
static void __lambda126_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda126__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda127_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda127__valadoc_rule_action (gpointer self,
                                        GError** error);
static void __lambda128_ (ValadocDocumentationParser* self,
                   GError** error);
static void ___lambda128__valadoc_rule_action (gpointer self,
                                        GError** error);
static void valadoc_documentation_parser_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static inline gpointer
valadoc_documentation_parser_get_instance_private (ValadocDocumentationParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocDocumentationParser_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}


ValadocDocumentationParser*
valadoc_documentation_parser_construct (GType object_type,
                                        ValadocSettings* settings,
                                        ValadocErrorReporter* reporter,
                                        ValadocApiTree* tree,
                                        ValadocModuleLoader* modules)
{
	ValadocDocumentationParser * self = NULL;
	ValadocSettings* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	ValadocApiTree* _tmp2_;
	ValadocModuleLoader* _tmp3_;
	ValadocSettings* _tmp4_;
	ValadocModuleLoader* _tmp5_;
	ValadocContentContentFactory* _tmp6_;
	ValadocSettings* _tmp7_;
	ValadocWikiScanner* _tmp8_;
	ValadocSettings* _tmp9_;
	ValadocWikiScanner* _tmp10_;
	ValadocErrorReporter* _tmp11_;
	ValadocParser* _tmp12_;
	ValadocWikiScanner* _tmp13_;
	ValadocParser* _tmp14_;
	ValadocSettings* _tmp15_;
	ValadocCommentScanner* _tmp16_;
	ValadocSettings* _tmp17_;
	ValadocCommentScanner* _tmp18_;
	ValadocErrorReporter* _tmp19_;
	ValadocParser* _tmp20_;
	ValadocCommentScanner* _tmp21_;
	ValadocParser* _tmp22_;
	ValadocGtkdocParser* _tmp23_;
	ValadocGtkdocMarkdownParser* _tmp24_;
	GHashFunc _tmp25_;
	GEqualFunc _tmp26_;
	GEqualFunc _tmp27_;
	ValaHashMap* _tmp28_;
	ValadocImporterInternalIdRegistrar* _tmp29_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	g_return_val_if_fail (tree != NULL, NULL);
	g_return_val_if_fail (modules != NULL, NULL);
	self = (ValadocDocumentationParser*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->_reporter);
	self->priv->_reporter = _tmp1_;
	_tmp2_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->priv->_tree);
	self->priv->_tree = _tmp2_;
	_tmp3_ = _g_object_ref0 (modules);
	_g_object_unref0 (self->priv->_modules);
	self->priv->_modules = _tmp3_;
	_tmp4_ = self->priv->_settings;
	_tmp5_ = self->priv->_modules;
	_tmp6_ = valadoc_content_content_factory_new (_tmp4_, (ValadocResourceLocator*) self, _tmp5_);
	_g_object_unref0 (self->priv->_factory);
	self->priv->_factory = _tmp6_;
	_tmp7_ = self->priv->_settings;
	_tmp8_ = valadoc_wiki_scanner_new (_tmp7_);
	_g_object_unref0 (self->priv->_wiki_scanner);
	self->priv->_wiki_scanner = _tmp8_;
	_tmp9_ = self->priv->_settings;
	_tmp10_ = self->priv->_wiki_scanner;
	_tmp11_ = self->priv->_reporter;
	_tmp12_ = valadoc_parser_new (_tmp9_, (ValadocScanner*) _tmp10_, _tmp11_);
	_valadoc_parser_unref0 (self->priv->_wiki_parser);
	self->priv->_wiki_parser = _tmp12_;
	_tmp13_ = self->priv->_wiki_scanner;
	_tmp14_ = self->priv->_wiki_parser;
	valadoc_scanner_set_parser ((ValadocScanner*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->_settings;
	_tmp16_ = valadoc_comment_scanner_new (_tmp15_);
	_g_object_unref0 (self->priv->_comment_scanner);
	self->priv->_comment_scanner = _tmp16_;
	_tmp17_ = self->priv->_settings;
	_tmp18_ = self->priv->_comment_scanner;
	_tmp19_ = self->priv->_reporter;
	_tmp20_ = valadoc_parser_new (_tmp17_, (ValadocScanner*) _tmp18_, _tmp19_);
	_valadoc_parser_unref0 (self->priv->_comment_parser);
	self->priv->_comment_parser = _tmp20_;
	_tmp21_ = self->priv->_comment_scanner;
	_tmp22_ = self->priv->_comment_parser;
	valadoc_scanner_set_parser ((ValadocScanner*) _tmp21_, _tmp22_);
	_tmp23_ = valadoc_gtkdoc_parser_new (settings, reporter, tree, modules);
	_g_object_unref0 (self->priv->gtkdoc_parser);
	self->priv->gtkdoc_parser = _tmp23_;
	_tmp24_ = valadoc_gtkdoc_markdown_parser_new (settings, reporter, tree, modules);
	_g_object_unref0 (self->priv->gtkdoc_markdown_parser);
	self->priv->gtkdoc_markdown_parser = _tmp24_;
	_tmp25_ = g_direct_hash;
	_tmp26_ = g_direct_equal;
	_tmp27_ = g_direct_equal;
	_tmp28_ = vala_hash_map_new (VALADOC_API_TYPE_SOURCE_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, VALADOC_TYPE_GIR_META_DATA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp25_, _tmp26_, _tmp27_);
	_vala_map_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp28_;
	_tmp29_ = valadoc_importer_internal_id_registrar_new ();
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	self->priv->id_registrar = _tmp29_;
	valadoc_documentation_parser_init_valadoc_rules (self);
	return self;
}


ValadocDocumentationParser*
valadoc_documentation_parser_new (ValadocSettings* settings,
                                  ValadocErrorReporter* reporter,
                                  ValadocApiTree* tree,
                                  ValadocModuleLoader* modules)
{
	return valadoc_documentation_parser_construct (VALADOC_TYPE_DOCUMENTATION_PARSER, settings, reporter, tree, modules);
}


static gpointer
_valadoc_api_source_comment_ref0 (gpointer self)
{
	return self ? valadoc_api_source_comment_ref (self) : NULL;
}


ValadocContentComment*
valadoc_documentation_parser_parse (ValadocDocumentationParser* self,
                                    ValadocApiNode* element,
                                    ValadocApiSourceComment* comment)
{
	ValadocContentComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (comment != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (comment, VALADOC_API_TYPE_GIR_SOURCE_COMMENT)) {
		ValadocApiGirSourceComment* gir_comment = NULL;
		ValadocApiGirSourceComment* _tmp0_;
		ValadocGirMetaData* metadata = NULL;
		ValadocApiGirSourceComment* _tmp1_;
		ValadocGirMetaData* _tmp2_;
		ValadocGirMetaData* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp0_ = _valadoc_api_source_comment_ref0 (G_TYPE_CHECK_INSTANCE_CAST (comment, VALADOC_API_TYPE_GIR_SOURCE_COMMENT, ValadocApiGirSourceComment));
		gir_comment = _tmp0_;
		_tmp1_ = gir_comment;
		_tmp2_ = valadoc_documentation_parser_get_metadata_for_comment (self, _tmp1_);
		metadata = _tmp2_;
		_tmp3_ = metadata;
		_tmp4_ = valadoc_gir_meta_data_get_is_docbook (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ValadocContentComment* doc_comment = NULL;
			ValadocGtkdocParser* _tmp6_;
			ValadocApiGirSourceComment* _tmp7_;
			ValadocGirMetaData* _tmp8_;
			ValadocImporterInternalIdRegistrar* _tmp9_;
			ValadocContentComment* _tmp10_;
			_tmp6_ = self->priv->gtkdoc_parser;
			_tmp7_ = gir_comment;
			_tmp8_ = metadata;
			_tmp9_ = self->priv->id_registrar;
			_tmp10_ = valadoc_gtkdoc_parser_parse (_tmp6_, element, _tmp7_, _tmp8_, _tmp9_);
			doc_comment = _tmp10_;
			result = doc_comment;
			_g_object_unref0 (metadata);
			_valadoc_api_source_comment_unref0 (gir_comment);
			return result;
		} else {
			ValadocContentComment* doc_comment = NULL;
			ValadocGtkdocMarkdownParser* _tmp11_;
			ValadocApiGirSourceComment* _tmp12_;
			ValadocGirMetaData* _tmp13_;
			ValadocImporterInternalIdRegistrar* _tmp14_;
			ValadocContentComment* _tmp15_;
			_tmp11_ = self->priv->gtkdoc_markdown_parser;
			_tmp12_ = gir_comment;
			_tmp13_ = metadata;
			_tmp14_ = self->priv->id_registrar;
			_tmp15_ = valadoc_gtkdoc_markdown_parser_parse (_tmp11_, element, _tmp12_, _tmp13_, _tmp14_, NULL);
			doc_comment = _tmp15_;
			result = doc_comment;
			_g_object_unref0 (metadata);
			_valadoc_api_source_comment_unref0 (gir_comment);
			return result;
		}
		_g_object_unref0 (metadata);
		_valadoc_api_source_comment_unref0 (gir_comment);
	} else {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		ValadocApiSourceFile* _tmp18_;
		ValadocApiSourceFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		ValadocContentComment* _tmp26_;
		ValadocContentComment* _tmp27_;
		_tmp16_ = valadoc_api_source_comment_get_content (comment);
		_tmp17_ = _tmp16_;
		_tmp18_ = valadoc_api_source_comment_get_file (comment);
		_tmp19_ = _tmp18_;
		_tmp20_ = valadoc_api_source_file_get_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = valadoc_api_source_comment_get_first_line (comment);
		_tmp23_ = _tmp22_;
		_tmp24_ = valadoc_api_source_comment_get_first_column (comment);
		_tmp25_ = _tmp24_;
		_tmp26_ = valadoc_documentation_parser_parse_comment_str (self, element, _tmp17_, _tmp21_, _tmp23_, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp21_);
		result = _tmp27_;
		return result;
	}
}


ValadocContentComment*
valadoc_documentation_parser_parse_comment_str (ValadocDocumentationParser* self,
                                                ValadocApiNode* element,
                                                const gchar* content,
                                                const gchar* filename,
                                                gint first_line,
                                                gint first_column)
{
	ValadocContentComment* result = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	{
		ValadocContentComment* doc_comment = NULL;
		ValadocContentComment* _tmp0_;
		_tmp0_ = valadoc_documentation_parser_parse_comment (self, content, filename, first_line, first_column, &_inner_error0_);
		doc_comment = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				goto __catch5_valadoc_parser_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = doc_comment;
		return result;
	}
	goto __finally5;
	__catch5_valadoc_parser_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		result = NULL;
		_g_error_free0 (_error_);
		return result;
	}
	__finally5:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}


ValadocContentPage*
valadoc_documentation_parser_parse_wikipage (ValadocDocumentationParser* self,
                                             ValadocApiPackage* pkg,
                                             ValadocWikiPage* page)
{
	ValadocContentPage* result = NULL;
	ValadocContentPage* _tmp0_;
	ValadocContentPage* _tmp1_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pkg != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = valadoc_wiki_page_get_documentation (page);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValadocContentPage* _tmp2_;
		ValadocContentPage* _tmp3_;
		ValadocContentPage* _tmp4_;
		_tmp2_ = valadoc_wiki_page_get_documentation (page);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = valadoc_wiki_page_get_documentation_str (page);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		result = NULL;
		return result;
	}
	{
		ValadocContentPage* documentation = NULL;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValadocContentPage* _tmp11_;
		ValadocContentPage* _tmp12_;
		_tmp7_ = valadoc_wiki_page_get_documentation_str (page);
		_tmp8_ = _tmp7_;
		_tmp9_ = valadoc_documentation_get_filename ((ValadocDocumentation*) page);
		_tmp10_ = _tmp9_;
		_tmp11_ = valadoc_documentation_parser_parse_wiki (self, _tmp8_, _tmp10_, &_inner_error0_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		documentation = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				goto __catch6_valadoc_parser_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = documentation;
		return result;
	}
	goto __finally6;
	__catch6_valadoc_parser_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		result = NULL;
		_g_error_free0 (_error_);
		return result;
	}
	__finally6:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}


static gpointer
_valadoc_parser_ref0 (gpointer self)
{
	return self ? valadoc_parser_ref (self) : NULL;
}


static ValadocContentComment*
valadoc_documentation_parser_parse_comment (ValadocDocumentationParser* self,
                                            const gchar* content,
                                            const gchar* filename,
                                            gint first_line,
                                            gint first_column,
                                            GError** error)
{
	ValadocContentComment* result = NULL;
	ValadocParser* _tmp0_;
	ValadocParser* _tmp1_;
	ValadocCommentScanner* _tmp2_;
	ValadocScanner* _tmp3_;
	ValaArrayList* _tmp4_;
	ValadocParser* _tmp5_;
	GObject* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = self->priv->_comment_parser;
	_tmp1_ = _valadoc_parser_ref0 (_tmp0_);
	_valadoc_parser_unref0 (self->priv->_parser);
	self->priv->_parser = _tmp1_;
	_tmp2_ = self->priv->_comment_scanner;
	_tmp3_ = _g_object_ref0 ((ValadocScanner*) _tmp2_);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp3_;
	_tmp4_ = self->priv->_stack;
	vala_collection_clear ((ValaCollection*) _tmp4_);
	_tmp5_ = self->priv->_comment_parser;
	valadoc_parser_parse (_tmp5_, content, filename, first_line, first_column, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = valadoc_documentation_parser_pop (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALADOC_CONTENT_TYPE_COMMENT, ValadocContentComment);
	return result;
}


static ValadocContentPage*
valadoc_documentation_parser_parse_wiki (ValadocDocumentationParser* self,
                                         const gchar* content,
                                         const gchar* filename,
                                         GError** error)
{
	ValadocContentPage* result = NULL;
	ValadocParser* _tmp0_;
	ValadocParser* _tmp1_;
	ValadocWikiScanner* _tmp2_;
	ValadocScanner* _tmp3_;
	ValaArrayList* _tmp4_;
	ValadocParser* _tmp5_;
	GObject* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = self->priv->_wiki_parser;
	_tmp1_ = _valadoc_parser_ref0 (_tmp0_);
	_valadoc_parser_unref0 (self->priv->_parser);
	self->priv->_parser = _tmp1_;
	_tmp2_ = self->priv->_wiki_scanner;
	_tmp3_ = _g_object_ref0 ((ValadocScanner*) _tmp2_);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp3_;
	_tmp4_ = self->priv->_stack;
	vala_collection_clear ((ValaCollection*) _tmp4_);
	_tmp5_ = self->priv->_wiki_parser;
	valadoc_parser_parse (_tmp5_, content, filename, 0, 0, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = valadoc_documentation_parser_pop (self);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALADOC_CONTENT_TYPE_PAGE, ValadocContentPage);
	return result;
}


void
valadoc_documentation_parser_check (ValadocDocumentationParser* self,
                                    ValadocApiNode* element,
                                    ValadocContentComment* comment)
{
	ValadocApiTree* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceFile* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocErrorReporter* _tmp5_;
	ValadocSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->_tree;
	_tmp1_ = valadoc_api_node_get_source_file (element);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_source_file_get_relative_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_reporter;
	_tmp6_ = self->priv->_settings;
	valadoc_content_content_element_check ((ValadocContentContentElement*) comment, _tmp0_, element, _tmp4_, _tmp5_, _tmp6_);
	_g_object_unref0 (_tmp2_);
}


void
valadoc_documentation_parser_check_wikipage (ValadocDocumentationParser* self,
                                             ValadocApiPackage* package,
                                             ValadocWikiPage* page)
{
	ValadocContentPage* _tmp0_;
	ValadocContentPage* _tmp1_;
	ValadocApiTree* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocErrorReporter* _tmp5_;
	ValadocSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = valadoc_wiki_page_get_documentation (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_tree;
	_tmp3_ = valadoc_wiki_page_get_path (page);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_reporter;
	_tmp6_ = self->priv->_settings;
	valadoc_content_content_element_check ((ValadocContentContentElement*) _tmp1_, _tmp2_, (ValadocApiNode*) package, _tmp4_, _tmp5_, _tmp6_);
}


void
valadoc_documentation_parser_transform_inheritdoc (ValadocDocumentationParser* self,
                                                   ValadocApiNode* taglet_owner,
                                                   ValadocTagletsInheritDoc* taglet)
{
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	ValadocApiNode* _tmp2_;
	ValadocApiNode* _tmp3_;
	ValadocSettings* _tmp4_;
	ValadocApiNode* _tmp5_;
	ValadocApiNode* _tmp6_;
	ValadocContentComment* _tmp7_;
	ValadocContentComment* _tmp8_;
	ValadocApiNode* _tmp9_;
	ValadocApiNode* _tmp10_;
	ValadocSettings* _tmp11_;
	ValadocApiTree* _tmp12_;
	ValadocApiSourceFile* _tmp13_;
	ValadocApiSourceFile* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	ValadocErrorReporter* _tmp17_;
	ValadocSettings* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (taglet_owner != NULL);
	g_return_if_fail (taglet != NULL);
	_tmp0_ = valadoc_taglets_inherit_doc_get_inherited (taglet);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = valadoc_taglets_inherit_doc_get_inherited (taglet);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_settings;
	valadoc_api_item_parse_comments ((ValadocApiItem*) _tmp3_, _tmp4_, self);
	_tmp5_ = valadoc_taglets_inherit_doc_get_inherited (taglet);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_node_get_documentation (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		return;
	}
	_tmp9_ = valadoc_taglets_inherit_doc_get_inherited (taglet);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_settings;
	valadoc_api_item_check_comments ((ValadocApiItem*) _tmp10_, _tmp11_, self);
	_tmp12_ = self->priv->_tree;
	_tmp13_ = valadoc_api_node_get_source_file (taglet_owner);
	_tmp14_ = _tmp13_;
	_tmp15_ = valadoc_api_source_file_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_reporter;
	_tmp18_ = self->priv->_settings;
	valadoc_taglets_inherit_doc_transform (taglet, _tmp12_, taglet_owner, _tmp16_, _tmp17_, _tmp18_);
	_g_free0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
}


static ValadocGirMetaData*
valadoc_documentation_parser_get_metadata_for_comment (ValadocDocumentationParser* self,
                                                       ValadocApiGirSourceComment* gir_comment)
{
	ValadocGirMetaData* result = NULL;
	ValadocGirMetaData* metadata = NULL;
	ValaHashMap* _tmp0_;
	ValadocApiSourceFile* _tmp1_;
	ValadocApiSourceFile* _tmp2_;
	gpointer _tmp3_;
	ValadocGirMetaData* _tmp4_;
	ValadocApiSourceFile* _tmp5_;
	ValadocApiSourceFile* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ValadocSettings* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocErrorReporter* _tmp11_;
	ValadocGirMetaData* _tmp12_;
	ValadocGirMetaData* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValaHashMap* _tmp24_;
	ValadocApiSourceFile* _tmp25_;
	ValadocApiSourceFile* _tmp26_;
	ValadocGirMetaData* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (gir_comment != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = valadoc_api_source_comment_get_file ((ValadocApiSourceComment*) gir_comment);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_map_get ((ValaMap*) _tmp0_, _tmp2_);
	metadata = (ValadocGirMetaData*) _tmp3_;
	_tmp4_ = metadata;
	if (_tmp4_ != NULL) {
		result = metadata;
		return result;
	}
	_tmp5_ = valadoc_api_source_comment_get_file ((ValadocApiSourceComment*) gir_comment);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_api_source_file_get_relative_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_settings;
	_tmp10_ = _tmp9_->metadata_directories;
	_tmp10__length1 = _tmp9_->metadata_directories_length1;
	_tmp11_ = self->priv->_reporter;
	_tmp12_ = valadoc_gir_meta_data_new (_tmp8_, _tmp10_, _tmp10__length1, _tmp11_);
	_g_object_unref0 (metadata);
	metadata = _tmp12_;
	_tmp13_ = metadata;
	_tmp14_ = valadoc_gir_meta_data_get_index_sgml (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValadocImporterInternalIdRegistrar* _tmp16_;
		ValadocGirMetaData* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		ValadocGirMetaData* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValadocErrorReporter* _tmp23_;
		_tmp16_ = self->priv->id_registrar;
		_tmp17_ = metadata;
		_tmp18_ = valadoc_gir_meta_data_get_index_sgml (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = metadata;
		_tmp21_ = valadoc_gir_meta_data_get_index_sgml_online (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_reporter;
		valadoc_importer_internal_id_registrar_read_index_sgml_file (_tmp16_, _tmp19_, _tmp22_, _tmp23_);
	}
	_tmp24_ = self->priv->metadata;
	_tmp25_ = valadoc_api_source_comment_get_file ((ValadocApiSourceComment*) gir_comment);
	_tmp26_ = _tmp25_;
	_tmp27_ = metadata;
	vala_map_set ((ValaMap*) _tmp24_, _tmp26_, _tmp27_);
	result = metadata;
	return result;
}


static gchar*
valadoc_documentation_parser_real_resolve (ValadocResourceLocator* base,
                                           const gchar* path)
{
	ValadocDocumentationParser * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValadocDocumentationParser*) base;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_strdup (path);
	result = _tmp0_;
	return result;
}


static void
valadoc_documentation_parser_push (ValadocDocumentationParser* self,
                                   GObject* element)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->_stack;
	vala_collection_add ((ValaCollection*) _tmp0_, element);
}


static GObject*
valadoc_documentation_parser_peek (ValadocDocumentationParser* self,
                                   gint offset)
{
	GObject* result = NULL;
	ValaArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gpointer _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ >= (-offset), "_stack.size >= - offset");
	_tmp3_ = self->priv->_stack;
	_tmp4_ = self->priv->_stack;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_list_get ((ValaList*) _tmp3_, _tmp6_ + offset);
	result = (GObject*) _tmp7_;
	return result;
}


static GObject*
valadoc_documentation_parser_pop (ValadocDocumentationParser* self)
{
	GObject* result = NULL;
	GObject* node = NULL;
	GObject* _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gpointer _tmp5_;
	GObject* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	node = _tmp0_;
	_tmp1_ = self->priv->_stack;
	_tmp2_ = self->priv->_stack;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_list_remove_at ((ValaList*) _tmp1_, _tmp4_ - 1);
	_tmp6_ = (GObject*) _tmp5_;
	_g_object_unref0 (_tmp6_);
	result = node;
	return result;
}


static void
_vala_array_add1 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add2 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
valadoc_documentation_parser_new_list_item (ValadocDocumentationParser* self,
                                            ValadocContentListBullet bullet,
                                            GError** error)
{
	ValadocContentListItem* new_item = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentListItem* _tmp1_;
	ValadocContentList* list = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	ValadocContentList* _tmp71_;
	ValaList* _tmp72_;
	ValaList* _tmp73_;
	ValadocContentListItem* _tmp74_;
	ValadocContentListItem* _tmp75_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_list_item (_tmp0_);
	new_item = _tmp1_;
	list = NULL;
	_tmp2_ = self->priv->levels;
	_tmp2__length1 = self->priv->levels_length1;
	if (_tmp2__length1 >= 1) {
		gint _tmp3_;
		gint* _tmp4_;
		gint _tmp4__length1;
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		_tmp3_ = self->priv->current_level;
		_tmp4_ = self->priv->levels;
		_tmp4__length1 = self->priv->levels_length1;
		_tmp5_ = self->priv->levels;
		_tmp5__length1 = self->priv->levels_length1;
		_tmp6_ = _tmp4_[_tmp5__length1 - 1];
		if (_tmp3_ > _tmp6_) {
			ValadocContentContentFactory* _tmp7_;
			ValadocContentList* _tmp8_;
			ValadocContentList* _tmp9_;
			ValadocContentListItem* current_item = NULL;
			GObject* _tmp10_;
			ValadocContentListItem* _tmp11_;
			ValadocContentListItem* _tmp12_;
			ValaList* _tmp13_;
			ValaList* _tmp14_;
			ValadocContentList* _tmp15_;
			ValadocContentList* _tmp16_;
			gint* _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			_tmp7_ = self->priv->_factory;
			_tmp8_ = valadoc_content_content_factory_create_list (_tmp7_);
			_g_object_unref0 (list);
			list = _tmp8_;
			_tmp9_ = list;
			valadoc_content_list_set_bullet (_tmp9_, bullet);
			_tmp10_ = valadoc_documentation_parser_peek (self, -1);
			_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALADOC_CONTENT_TYPE_LIST_ITEM) ? ((ValadocContentListItem*) _tmp10_) : NULL;
			if (_tmp11_ == NULL) {
				_g_object_unref0 (_tmp10_);
			}
			current_item = _tmp11_;
			_tmp12_ = current_item;
			_tmp13_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = list;
			vala_collection_add ((ValaCollection*) _tmp14_, (ValadocContentBlock*) _tmp15_);
			_tmp16_ = list;
			valadoc_documentation_parser_push (self, (GObject*) _tmp16_);
			_tmp17_ = self->priv->levels;
			_tmp17__length1 = self->priv->levels_length1;
			_tmp18_ = self->priv->current_level;
			_vala_array_add1 (&self->priv->levels, &self->priv->levels_length1, &self->priv->_levels_size_, _tmp18_);
			_g_object_unref0 (current_item);
		} else {
			gboolean poped_some_lists = FALSE;
			GObject* _tmp29_;
			ValadocContentList* _tmp30_;
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_;
			GObject* _tmp57_;
			GObject* _tmp58_;
			poped_some_lists = FALSE;
			while (TRUE) {
				gint _tmp19_;
				gint* _tmp20_;
				gint _tmp20__length1;
				gint* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				GObject* _tmp23_;
				GObject* _tmp24_;
				GObject* _tmp25_;
				GObject* _tmp26_;
				gint* _tmp27_;
				gint _tmp27__length1;
				gint _tmp28_;
				_tmp19_ = self->priv->current_level;
				_tmp20_ = self->priv->levels;
				_tmp20__length1 = self->priv->levels_length1;
				_tmp21_ = self->priv->levels;
				_tmp21__length1 = self->priv->levels_length1;
				_tmp22_ = _tmp20_[_tmp21__length1 - 1];
				if (!(_tmp19_ < _tmp22_)) {
					break;
				}
				_tmp23_ = valadoc_documentation_parser_pop (self);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
				_tmp25_ = valadoc_documentation_parser_pop (self);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
				_tmp27_ = self->priv->levels;
				_tmp27__length1 = self->priv->levels_length1;
				_tmp28_ = _tmp27__length1 - 1;
				self->priv->levels = g_renew (gint, self->priv->levels, _tmp27__length1 - 1);
				(_tmp28_ > self->priv->levels_length1) ? memset (self->priv->levels + self->priv->levels_length1, 0, sizeof (gint) * (_tmp28_ - self->priv->levels_length1)) : NULL;
				self->priv->levels_length1 = _tmp28_;
				self->priv->_levels_size_ = _tmp28_;
				poped_some_lists = TRUE;
			}
			_tmp29_ = valadoc_documentation_parser_peek (self, -2);
			_tmp30_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALADOC_CONTENT_TYPE_LIST) ? ((ValadocContentList*) _tmp29_) : NULL;
			if (_tmp30_ == NULL) {
				_g_object_unref0 (_tmp29_);
			}
			_g_object_unref0 (list);
			list = _tmp30_;
			_tmp32_ = poped_some_lists;
			if (!_tmp32_) {
				_tmp31_ = bullet == VALADOC_CONTENT_LIST_BULLET_NONE;
			} else {
				_tmp31_ = FALSE;
			}
			if (_tmp31_) {
				GObject* _tmp33_;
				ValadocContentListItem* _tmp34_;
				ValaList* _tmp35_;
				ValaList* _tmp36_;
				gpointer _tmp37_;
				ValadocContentParagraph* _tmp38_;
				ValaList* _tmp39_;
				ValaList* _tmp40_;
				ValadocContentContentFactory* _tmp41_;
				ValadocContentText* _tmp42_;
				ValadocContentText* _tmp43_;
				_tmp33_ = valadoc_documentation_parser_peek (self, -1);
				_tmp34_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALADOC_CONTENT_TYPE_LIST_ITEM, ValadocContentListItem);
				_tmp35_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_list_get (_tmp36_, 0);
				_tmp38_ = G_TYPE_CHECK_INSTANCE_CAST ((ValadocContentBlock*) _tmp37_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
				_tmp39_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = self->priv->_factory;
				_tmp42_ = valadoc_content_content_factory_create_text (_tmp41_, " ");
				_tmp43_ = _tmp42_;
				vala_collection_add ((ValaCollection*) _tmp40_, (ValadocContentInline*) _tmp43_);
				_g_object_unref0 (_tmp43_);
				_g_object_unref0 (_tmp38_);
				_g_object_unref0 (_tmp34_);
				_g_object_unref0 (list);
				_g_object_unref0 (new_item);
				return;
			} else {
				ValadocContentList* _tmp44_;
				ValadocContentListBullet _tmp45_;
				ValadocContentListBullet _tmp46_;
				_tmp44_ = list;
				_tmp45_ = valadoc_content_list_get_bullet (_tmp44_);
				_tmp46_ = _tmp45_;
				if (_tmp46_ != bullet) {
					ValadocParser* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					ValadocContentList* _tmp50_;
					ValadocContentListBullet _tmp51_;
					ValadocContentListBullet _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp47_ = self->priv->_parser;
					_tmp48_ = valadoc_documentation_parser_bullet_type_string (self, bullet);
					_tmp49_ = _tmp48_;
					_tmp50_ = list;
					_tmp51_ = valadoc_content_list_get_bullet (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = valadoc_documentation_parser_bullet_type_string (self, _tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = g_strdup_printf ("Invalid bullet type '%s': expected '%s'", _tmp49_, _tmp54_);
					_tmp56_ = _tmp55_;
					valadoc_parser_callback_error ((ValadocParserCallback*) _tmp47_, NULL, _tmp56_, &_inner_error0_);
					_g_free0 (_tmp56_);
					_g_free0 (_tmp54_);
					_g_free0 (_tmp49_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (list);
							_g_object_unref0 (new_item);
							return;
						} else {
							_g_object_unref0 (list);
							_g_object_unref0 (new_item);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					_g_object_unref0 (list);
					_g_object_unref0 (new_item);
					return;
				}
			}
			_tmp57_ = valadoc_documentation_parser_pop (self);
			_tmp58_ = _tmp57_;
			_g_object_unref0 (_tmp58_);
		}
	} else {
		ValadocContentContentFactory* _tmp59_;
		ValadocContentList* _tmp60_;
		ValadocContentList* _tmp61_;
		GObject* _tmp62_;
		ValadocContentBlockContent* _tmp63_;
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		ValadocContentList* _tmp66_;
		ValadocContentList* _tmp67_;
		gint* _tmp68_;
		gint* _tmp69_;
		gint _tmp69__length1;
		gint _tmp70_;
		_tmp59_ = self->priv->_factory;
		_tmp60_ = valadoc_content_content_factory_create_list (_tmp59_);
		_g_object_unref0 (list);
		list = _tmp60_;
		_tmp61_ = list;
		valadoc_content_list_set_bullet (_tmp61_, bullet);
		_tmp62_ = valadoc_documentation_parser_peek (self, -1);
		_tmp63_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
		_tmp64_ = valadoc_content_block_content_get_content (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = list;
		vala_collection_add ((ValaCollection*) _tmp65_, (ValadocContentBlock*) _tmp66_);
		_g_object_unref0 (_tmp63_);
		_tmp67_ = list;
		valadoc_documentation_parser_push (self, (GObject*) _tmp67_);
		_tmp68_ = g_new0 (gint, 0);
		self->priv->levels = (g_free (self->priv->levels), NULL);
		self->priv->levels = _tmp68_;
		self->priv->levels_length1 = 0;
		self->priv->_levels_size_ = self->priv->levels_length1;
		_tmp69_ = self->priv->levels;
		_tmp69__length1 = self->priv->levels_length1;
		_tmp70_ = self->priv->current_level;
		_vala_array_add2 (&self->priv->levels, &self->priv->levels_length1, &self->priv->_levels_size_, _tmp70_);
	}
	_tmp71_ = list;
	_tmp72_ = valadoc_content_list_get_items (_tmp71_);
	_tmp73_ = _tmp72_;
	_tmp74_ = new_item;
	vala_collection_add ((ValaCollection*) _tmp73_, _tmp74_);
	_tmp75_ = new_item;
	valadoc_documentation_parser_push (self, (GObject*) _tmp75_);
	_g_object_unref0 (list);
	_g_object_unref0 (new_item);
}


static gchar*
valadoc_documentation_parser_bullet_type_string (ValadocDocumentationParser* self,
                                                 ValadocContentListBullet bullet)
{
	gchar* result = NULL;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	switch (bullet) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (".");
			result = _tmp0_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("*");
			result = _tmp1_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("1.");
			result = _tmp2_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("a.");
			result = _tmp3_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("A.");
			result = _tmp4_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("i.");
			result = _tmp5_;
			return result;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("I.");
			result = _tmp6_;
			return result;
		}
		default:
		break;
	}
	_tmp7_ = g_strdup ("");
	result = _tmp7_;
	return result;
}


static void
valadoc_documentation_parser_finish_list (ValadocDocumentationParser* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GObject* _tmp0_;
		GObject* _tmp1_;
		gboolean _tmp2_;
		GObject* _tmp3_;
		GObject* _tmp4_;
		GObject* _tmp5_;
		GObject* _tmp6_;
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		_tmp0_ = valadoc_documentation_parser_peek (self, -1);
		_tmp1_ = _tmp0_;
		_tmp2_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALADOC_CONTENT_TYPE_LIST_ITEM);
		_g_object_unref0 (_tmp1_);
		if (_tmp2_) {
			break;
		}
		_tmp3_ = valadoc_documentation_parser_pop (self);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp4_);
		_tmp5_ = valadoc_documentation_parser_pop (self);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->levels;
		_tmp7__length1 = self->priv->levels_length1;
		_tmp8_ = _tmp7__length1 - 1;
		self->priv->levels = g_renew (gint, self->priv->levels, _tmp7__length1 - 1);
		(_tmp8_ > self->priv->levels_length1) ? memset (self->priv->levels + self->priv->levels_length1, 0, sizeof (gint) * (_tmp8_ - self->priv->levels_length1)) : NULL;
		self->priv->levels_length1 = _tmp8_;
		self->priv->_levels_size_ = _tmp8_;
	}
}


static void
valadoc_documentation_parser_add_content_string (ValadocDocumentationParser* self,
                                                 const gchar* str)
{
	ValadocContentText* text = NULL;
	GObject* _tmp0_;
	ValadocContentText* _tmp1_;
	ValadocContentText* _tmp2_;
	ValadocContentText* _tmp6_;
	ValadocContentText* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	text = _tmp1_;
	_tmp2_ = text;
	if (_tmp2_ == NULL) {
		ValadocContentContentFactory* _tmp3_;
		ValadocContentText* _tmp4_;
		ValadocContentText* _tmp5_;
		_tmp3_ = self->priv->_factory;
		_tmp4_ = valadoc_content_content_factory_create_text (_tmp3_, NULL);
		_g_object_unref0 (text);
		text = _tmp4_;
		_tmp5_ = text;
		valadoc_documentation_parser_push (self, (GObject*) _tmp5_);
	}
	_tmp6_ = text;
	_tmp7_ = text;
	_tmp8_ = valadoc_content_text_get_content (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, str, NULL);
	_tmp11_ = _tmp10_;
	valadoc_content_text_set_content (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_object_unref0 (text);
}


static void
valadoc_documentation_parser_add_content_space (ValadocDocumentationParser* self,
                                                ValadocToken* token,
                                                GError** error)
{
	GObject* head = NULL;
	GObject* _tmp0_;
	ValadocContentText* text_node = NULL;
	GObject* _tmp1_;
	ValadocContentText* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	head = _tmp0_;
	text_node = NULL;
	_tmp1_ = head;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALADOC_CONTENT_TYPE_TEXT)) {
		GObject* _tmp2_;
		ValadocContentText* _tmp3_;
		_tmp2_ = head;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText));
		_g_object_unref0 (text_node);
		text_node = _tmp3_;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		GObject* _tmp6_;
		_tmp6_ = head;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALADOC_CONTENT_TYPE_INLINE_CONTENT)) {
			GObject* _tmp7_;
			ValaList* _tmp8_;
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp7_ = head;
			_tmp8_ = valadoc_content_inline_content_get_content (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALADOC_CONTENT_TYPE_INLINE_CONTENT, ValadocContentInlineContent));
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_ > 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GObject* _tmp12_;
			ValaList* _tmp13_;
			ValaList* _tmp14_;
			gpointer _tmp15_;
			ValadocContentInline* _tmp16_;
			_tmp12_ = head;
			_tmp13_ = valadoc_content_inline_content_get_content (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_CONTENT_TYPE_INLINE_CONTENT, ValadocContentInlineContent));
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_list_last (_tmp14_);
			_tmp16_ = (ValadocContentInline*) _tmp15_;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_CONTENT_TYPE_TEXT);
			_g_object_unref0 (_tmp16_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			GObject* _tmp17_;
			ValaList* _tmp18_;
			ValaList* _tmp19_;
			gpointer _tmp20_;
			_tmp17_ = head;
			_tmp18_ = valadoc_content_inline_content_get_content (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALADOC_CONTENT_TYPE_INLINE_CONTENT, ValadocContentInlineContent));
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_list_last (_tmp19_);
			_g_object_unref0 (text_node);
			text_node = G_TYPE_CHECK_INSTANCE_CAST ((ValadocContentInline*) _tmp20_, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText);
		} else {
			ValadocContentContentFactory* _tmp21_;
			ValadocContentText* _tmp22_;
			GObject* _tmp23_;
			ValadocContentInlineContent* _tmp24_;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			ValadocContentText* _tmp27_;
			_tmp21_ = self->priv->_factory;
			_tmp22_ = valadoc_content_content_factory_create_text (_tmp21_, NULL);
			_g_object_unref0 (text_node);
			text_node = _tmp22_;
			_tmp23_ = valadoc_documentation_parser_peek (self, -1);
			_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_CONTENT_TYPE_INLINE_CONTENT, ValadocContentInlineContent);
			_tmp25_ = valadoc_content_inline_content_get_content (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = text_node;
			vala_collection_add ((ValaCollection*) _tmp26_, (ValadocContentInline*) _tmp27_);
			_g_object_unref0 (_tmp24_);
		}
	}
	_tmp28_ = text_node;
	_tmp29_ = valadoc_content_text_get_content (_tmp28_);
	_tmp30_ = _tmp29_;
	if (!g_str_has_suffix (_tmp30_, " ")) {
		ValadocContentText* _tmp31_;
		ValadocContentText* _tmp32_;
		const gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = text_node;
		_tmp32_ = text_node;
		_tmp33_ = valadoc_content_text_get_content (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp34_, " ", NULL);
		_tmp36_ = _tmp35_;
		valadoc_content_text_set_content (_tmp32_, _tmp36_);
		_g_free0 (_tmp36_);
	}
	_g_object_unref0 (text_node);
	_g_object_unref0 (head);
}


static void
valadoc_documentation_parser_add_text (ValadocDocumentationParser* self,
                                       ValadocToken* token,
                                       GError** error)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	valadoc_documentation_parser_add_content_string (self, _tmp0_);
}


static void
_valadoc_documentation_parser_add_content_space_valadoc_token_type_action (ValadocToken* token,
                                                                           gpointer self,
                                                                           GError** error)
{
	valadoc_documentation_parser_add_content_space ((ValadocDocumentationParser*) self, token, error);
}


static void
_valadoc_documentation_parser_add_text_valadoc_token_type_action (ValadocToken* token,
                                                                  gpointer self,
                                                                  GError** error)
{
	valadoc_documentation_parser_add_text ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda56_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_add_content_string (self, "\n");
}


static void
___lambda56__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda56_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda57_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentText* _tmp1_;
	ValadocContentText* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_text (_tmp0_, NULL);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda57__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda57_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda58_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	ValadocContentTaglet* taglet = NULL;
	ValadocContentContentFactory* _tmp0_;
	const gchar* _tmp1_;
	ValadocContentTaglet* _tmp2_;
	ValadocContentTaglet* _tmp3_;
	ValadocContentTaglet* _tmp8_;
	ValadocRule* taglet_rule = NULL;
	ValadocContentTaglet* _tmp9_;
	ValadocRule* _tmp10_;
	ValadocRule* _tmp11_;
	ValadocRule* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_token_to_string (token);
	_tmp2_ = valadoc_content_content_factory_create_taglet (_tmp0_, _tmp1_);
	taglet = _tmp2_;
	_tmp3_ = taglet;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALADOC_CONTENT_TYPE_INLINE)) {
		ValadocParser* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->_parser;
		_tmp5_ = valadoc_token_to_string (token);
		_tmp6_ = g_strdup_printf ("Invalid taglet in this context: %s", _tmp5_);
		_tmp7_ = _tmp6_;
		valadoc_parser_callback_error ((ValadocParserCallback*) _tmp4_, NULL, _tmp7_, &_inner_error0_);
		_g_free0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (taglet);
				return;
			} else {
				_g_object_unref0 (taglet);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp8_ = taglet;
	valadoc_documentation_parser_push (self, (GObject*) _tmp8_);
	_tmp9_ = taglet;
	_tmp10_ = self->priv->multiline_run;
	_tmp11_ = valadoc_content_taglet_get_parser_rule (_tmp9_, _tmp10_);
	taglet_rule = _tmp11_;
	_tmp12_ = taglet_rule;
	if (_tmp12_ != NULL) {
		ValadocParser* _tmp13_;
		ValadocTokenType* _tmp14_;
		GObject* _tmp15_;
		ValadocTokenType* _tmp16_;
		GObject* _tmp17_;
		GObject** _tmp18_;
		GObject** _tmp19_;
		gint _tmp19__length1;
		ValadocRule* _tmp20_;
		ValadocRule* _tmp21_;
		GObject* _tmp22_;
		GObject** _tmp23_;
		GObject** _tmp24_;
		gint _tmp24__length1;
		ValadocRule* _tmp25_;
		ValadocRule* _tmp26_;
		_tmp13_ = self->priv->_parser;
		_tmp14_ = valadoc_token_type_SPACE;
		_tmp15_ = _g_object_ref0 ((GObject*) _tmp14_);
		_tmp16_ = valadoc_token_type_EOL;
		_tmp17_ = _g_object_ref0 ((GObject*) _tmp16_);
		_tmp18_ = g_new0 (GObject*, 2 + 1);
		_tmp18_[0] = _tmp15_;
		_tmp18_[1] = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 2;
		_tmp20_ = valadoc_rule_one_of (_tmp19_, 2);
		_tmp21_ = taglet_rule;
		_tmp22_ = _g_object_ref0 ((GObject*) _tmp21_);
		_tmp23_ = g_new0 (GObject*, 2 + 1);
		_tmp23_[0] = (GObject*) _tmp20_;
		_tmp23_[1] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 2;
		_tmp25_ = valadoc_rule_seq (_tmp24_, 2);
		_tmp26_ = _tmp25_;
		valadoc_parser_callback_push_rule ((ValadocParserCallback*) _tmp13_, _tmp26_);
		_g_object_unref0 (_tmp26_);
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_object_unref), NULL);
		_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_g_object_unref0 (taglet_rule);
	_g_object_unref0 (taglet);
}


static void
___lambda58__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda58_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda59_ (ValadocDocumentationParser* self,
             GError** error)
{
	valadoc_documentation_parser_add_content_string (self, "{");
}


static void
___lambda59__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda59_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda60_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_BOLD);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda60__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda60_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda61_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_ITALIC);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda61__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda61_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda62_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_UNDERLINED);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda62__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda62_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda63_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentRun* _tmp1_;
	ValadocContentRun* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_run (_tmp0_, VALADOC_CONTENT_RUN_STYLE_MONOSPACED);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda63__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda63_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda64_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), TRUE);
}


static void
___lambda64__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda64_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda65_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GObject* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_EMBEDDED, ValadocContentEmbedded);
	_tmp2_ = valadoc_token_to_string (token);
	valadoc_content_embedded_set_url (_tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda65__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda65_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda66_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), FALSE);
}


static void
___lambda66__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda66_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda67_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentText* caption = NULL;
	GObject* _tmp0_;
	ValadocContentText* _tmp1_;
	GObject* _tmp2_;
	ValadocContentEmbedded* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	caption = _tmp1_;
	_tmp2_ = valadoc_documentation_parser_peek (self, -1);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALADOC_CONTENT_TYPE_EMBEDDED, ValadocContentEmbedded);
	_tmp4_ = valadoc_content_text_get_content (caption);
	_tmp5_ = _tmp4_;
	valadoc_content_embedded_set_caption (_tmp3_, _tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (caption);
}


static void
___lambda67__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda67_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda68_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), FALSE);
}


static void
___lambda68__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda68_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda69_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentEmbedded* _tmp1_;
	ValadocContentEmbedded* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_embedded (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda69__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda69_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda70_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), TRUE);
}


static void
___lambda70__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda70_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda71_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	gchar* url = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	_tmp1_ = g_strdup (_tmp0_);
	url = _tmp1_;
	_tmp2_ = url;
	if (g_str_has_suffix (_tmp2_, ".valadoc")) {
		ValadocContentWikiLink* link = NULL;
		ValadocContentContentFactory* _tmp3_;
		ValadocContentWikiLink* _tmp4_;
		ValadocContentWikiLink* _tmp5_;
		const gchar* _tmp6_;
		ValadocContentWikiLink* _tmp7_;
		_tmp3_ = self->priv->_factory;
		_tmp4_ = valadoc_content_content_factory_create_wiki_link (_tmp3_);
		link = _tmp4_;
		_tmp5_ = link;
		_tmp6_ = url;
		valadoc_content_wiki_link_set_name (_tmp5_, _tmp6_);
		_tmp7_ = link;
		valadoc_documentation_parser_push (self, (GObject*) _tmp7_);
		_g_object_unref0 (link);
	} else {
		ValadocContentLink* link = NULL;
		ValadocContentContentFactory* _tmp8_;
		ValadocContentLink* _tmp9_;
		ValadocContentLink* _tmp10_;
		const gchar* _tmp11_;
		ValadocContentLink* _tmp12_;
		_tmp8_ = self->priv->_factory;
		_tmp9_ = valadoc_content_content_factory_create_link (_tmp8_);
		link = _tmp9_;
		_tmp10_ = link;
		_tmp11_ = url;
		valadoc_content_link_set_url (_tmp10_, _tmp11_);
		_tmp12_ = link;
		valadoc_documentation_parser_push (self, (GObject*) _tmp12_);
		_g_object_unref0 (link);
	}
	_g_free0 (url);
}


static void
___lambda71__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda71_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda72_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), FALSE);
}


static void
___lambda72__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda72_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda73_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocScanner* _tmp0_;
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_url_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), FALSE);
}


static void
___lambda73__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda73_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda74_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	ValadocScanner* _tmp0_;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_code_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), TRUE);
}


static void
___lambda74__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda74_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda75_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GObject* _tmp0_;
	ValadocContentSourceCode* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_SOURCE_CODE, ValadocContentSourceCode);
	_tmp2_ = valadoc_token_to_string (token);
	valadoc_content_source_code_set_code (_tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda75__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda75_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda76_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	ValadocScanner* _tmp0_;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->_scanner;
	valadoc_wiki_scanner_set_code_escape_mode (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner), FALSE);
}


static void
___lambda76__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda76_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda77_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentSourceCode* _tmp1_;
	ValadocContentSourceCode* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_source_code (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda77__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda77_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda78_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentInline* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentInlineContent* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_INLINE, ValadocContentInline);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_INLINE_CONTENT, ValadocContentInlineContent);
	_tmp3_ = valadoc_content_inline_content_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, head);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (head);
}


static void
___lambda78__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda78_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda79_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentParagraph* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentBlockContent* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	ValadocContentParagraph* _tmp5_;
	ValadocContentText* last_element = NULL;
	ValadocContentParagraph* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	gpointer _tmp9_;
	ValadocContentInline* _tmp10_;
	ValadocContentText* _tmp11_;
	ValadocContentText* _tmp12_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp3_ = valadoc_content_block_content_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = head;
	vala_collection_add ((ValaCollection*) _tmp4_, (ValadocContentBlock*) _tmp5_);
	_g_object_unref0 (_tmp2_);
	_tmp6_ = head;
	_tmp7_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_list_last (_tmp8_);
	_tmp10_ = (ValadocContentInline*) _tmp9_;
	_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp10_) : NULL;
	if (_tmp11_ == NULL) {
		_g_object_unref0 (_tmp10_);
	}
	last_element = _tmp11_;
	_tmp12_ = last_element;
	if (_tmp12_ != NULL) {
		ValadocContentText* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = last_element;
		_tmp14_ = valadoc_content_text_get_content (_tmp13_);
		_tmp15_ = _tmp14_;
		g_strchomp (_tmp15_);
	}
	_g_object_unref0 (last_element);
	_g_object_unref0 (head);
}


static void
___lambda79__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda79_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda80_ (ValadocDocumentationParser* self,
             GError** error)
{
	GObject* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_HORIZONTAL_ALIGN_CENTER);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda80__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda80_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda81_ (ValadocDocumentationParser* self,
             GError** error)
{
	GObject* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_HORIZONTAL_ALIGN_RIGHT);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda81__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda81_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda82_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	ValadocContentParagraph* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda82__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda82_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda83_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	ValadocContentParagraph* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda83__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda83_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda84_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentWarning* head = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentWarning* _tmp1_;
	ValadocContentWarning* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GObject* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	GObject* _tmp7_;
	ValadocContentBlockContent* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentWarning* _tmp11_;
	ValadocContentText* last_element = NULL;
	ValadocContentWarning* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	gpointer _tmp15_;
	ValadocContentBlock* _tmp16_;
	ValadocContentText* _tmp17_;
	ValadocContentText* _tmp18_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_warning (_tmp0_);
	head = _tmp1_;
	_tmp2_ = head;
	_tmp3_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_documentation_parser_pop (self);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	vala_collection_add ((ValaCollection*) _tmp4_, (ValadocContentBlock*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = valadoc_documentation_parser_peek (self, -1);
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp9_ = valadoc_content_block_content_get_content (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = head;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentBlock*) _tmp11_);
	_g_object_unref0 (_tmp8_);
	_tmp12_ = head;
	_tmp13_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_list_last (_tmp14_);
	_tmp16_ = (ValadocContentBlock*) _tmp15_;
	_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp16_) : NULL;
	if (_tmp17_ == NULL) {
		_g_object_unref0 (_tmp16_);
	}
	last_element = _tmp17_;
	_tmp18_ = last_element;
	if (_tmp18_ != NULL) {
		ValadocContentText* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = last_element;
		_tmp20_ = valadoc_content_text_get_content (_tmp19_);
		_tmp21_ = _tmp20_;
		g_strchomp (_tmp21_);
	}
	_g_object_unref0 (last_element);
	_g_object_unref0 (head);
}


static void
___lambda84__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda84_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda85_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	ValadocContentParagraph* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda85__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda85_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda86_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentNote* head = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentNote* _tmp1_;
	ValadocContentNote* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GObject* _tmp5_;
	ValadocContentParagraph* _tmp6_;
	GObject* _tmp7_;
	ValadocContentBlockContent* _tmp8_;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	ValadocContentNote* _tmp11_;
	ValadocContentText* last_element = NULL;
	ValadocContentNote* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	gpointer _tmp15_;
	ValadocContentBlock* _tmp16_;
	ValadocContentText* _tmp17_;
	ValadocContentText* _tmp18_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_note (_tmp0_);
	head = _tmp1_;
	_tmp2_ = head;
	_tmp3_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = valadoc_documentation_parser_pop (self);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	vala_collection_add ((ValaCollection*) _tmp4_, (ValadocContentBlock*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = valadoc_documentation_parser_peek (self, -1);
	_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp9_ = valadoc_content_block_content_get_content (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = head;
	vala_collection_add ((ValaCollection*) _tmp10_, (ValadocContentBlock*) _tmp11_);
	_g_object_unref0 (_tmp8_);
	_tmp12_ = head;
	_tmp13_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_list_last (_tmp14_);
	_tmp16_ = (ValadocContentBlock*) _tmp15_;
	_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_CONTENT_TYPE_TEXT) ? ((ValadocContentText*) _tmp16_) : NULL;
	if (_tmp17_ == NULL) {
		_g_object_unref0 (_tmp16_);
	}
	last_element = _tmp17_;
	_tmp18_ = last_element;
	if (_tmp18_ != NULL) {
		ValadocContentText* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		_tmp19_ = last_element;
		_tmp20_ = valadoc_content_text_get_content (_tmp19_);
		_tmp21_ = _tmp20_;
		g_strchomp (_tmp21_);
	}
	_g_object_unref0 (last_element);
	_g_object_unref0 (head);
}


static void
___lambda86__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda86_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda87_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	gint _tmp0_;
	g_return_if_fail (token != NULL);
	_tmp0_ = self->priv->current_level;
	self->priv->current_level = _tmp0_ + 1;
}


static void
___lambda87__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda87_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda88_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_NONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda88__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda88_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda89_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_UNORDERED, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda89__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda89_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda90_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda90__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda90_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda91_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda91__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda91_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda92_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda92__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda92_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda93_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda93__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda93_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda94_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda94__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda94_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda95_ (ValadocDocumentationParser* self,
             ValadocToken* token,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda95__valadoc_token_type_action (ValadocToken* token,
                                        gpointer self,
                                        GError** error)
{
	__lambda95_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda96_ (ValadocDocumentationParser* self,
             GError** error)
{
	GError* _inner_error0_ = NULL;
	valadoc_documentation_parser_new_list_item (self, VALADOC_CONTENT_LIST_BULLET_NONE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}


static void
___lambda96__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda96_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda97_ (ValadocDocumentationParser* self,
             GError** error)
{
	ValadocContentParagraph* content = NULL;
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	GObject* _tmp2_;
	ValadocContentListItem* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	content = _tmp1_;
	_tmp2_ = valadoc_documentation_parser_peek (self, -1);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, VALADOC_CONTENT_TYPE_LIST_ITEM, ValadocContentListItem);
	_tmp4_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp3_);
	_tmp5_ = _tmp4_;
	vala_collection_add ((ValaCollection*) _tmp5_, (ValadocContentBlock*) content);
	_g_object_unref0 (_tmp3_);
	valadoc_documentation_parser_push (self, (GObject*) content);
	_g_object_unref0 (content);
}


static void
___lambda97__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda97_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda98_ (ValadocDocumentationParser* self,
             GError** error)
{
	GObject* _tmp0_;
	GObject* _tmp1_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static void
___lambda98__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda98_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda99_ (ValadocDocumentationParser* self,
             GError** error)
{
	self->priv->current_level = 0;
}


static void
___lambda99__valadoc_rule_action (gpointer self,
                                  GError** error)
{
	__lambda99_ ((ValadocDocumentationParser*) self, error);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static void
__lambda100_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValaList* content_list = NULL;
	GObject* _tmp0_;
	ValadocContentListItem* _tmp1_;
	ValaList* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	ValaList* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_LIST_ITEM, ValadocContentListItem);
	_tmp2_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	content_list = _tmp5_;
	_tmp7_ = content_list;
	_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ > 0) {
		ValaList* _tmp10_;
		gpointer _tmp11_;
		ValadocContentBlock* _tmp12_;
		_tmp10_ = content_list;
		_tmp11_ = vala_list_last (_tmp10_);
		_tmp12_ = (ValadocContentBlock*) _tmp11_;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_CONTENT_TYPE_TEXT);
		_g_object_unref0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaList* _tmp13_;
		gpointer _tmp14_;
		ValadocContentText* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = content_list;
		_tmp14_ = vala_list_last (_tmp13_);
		_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST ((ValadocContentBlock*) _tmp14_, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText);
		_tmp16_ = valadoc_content_text_get_content (_tmp15_);
		_tmp17_ = _tmp16_;
		g_strchomp (_tmp17_);
		_g_object_unref0 (_tmp15_);
	}
	_vala_iterable_unref0 (content_list);
}


static void
___lambda100__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda100_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda101_ (ValadocDocumentationParser* self,
              GError** error)
{
	valadoc_documentation_parser_finish_list (self);
}


static void
___lambda101__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda101_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda102_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_HORIZONTAL_ALIGN_RIGHT);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda102__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda102_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda103_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_style_attributes_set_horizontal_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_HORIZONTAL_ALIGN_CENTER);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda103__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda103_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda104_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_VERTICAL_ALIGN_TOP);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda104__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda104_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda105_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_style_attributes_set_vertical_align ((ValadocContentStyleAttributes*) _tmp1_, VALADOC_CONTENT_VERTICAL_ALIGN_BOTTOM);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda105__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda105_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda106_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	_tmp2_ = valadoc_token_to_string (token);
	valadoc_content_style_attributes_set_style ((ValadocContentStyleAttributes*) _tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda106__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda106_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda107_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_table_cell_set_rowspan (_tmp1_, valadoc_token_to_int (token));
	_g_object_unref0 (_tmp1_);
}


static void
___lambda107__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda107_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda108_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	valadoc_content_table_cell_set_colspan (_tmp1_, valadoc_token_to_int (token));
	_g_object_unref0 (_tmp1_);
}


static void
___lambda108__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda108_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda109_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentTableCell* _tmp1_;
	ValadocContentTableCell* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_table_cell (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda109__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda109_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda110_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentTableCell* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentTableRow* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	ValadocContentTableCell* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValadocContentTableCell* _tmp7_;
	ValaList* _tmp8_;
	ValaList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_CELL, ValadocContentTableCell);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_TABLE_ROW, ValadocContentTableRow);
	_tmp3_ = valadoc_content_table_row_get_cells (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = head;
	vala_collection_add ((ValaCollection*) _tmp4_, _tmp5_);
	_g_object_unref0 (_tmp2_);
	_tmp7_ = head;
	_tmp8_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		ValadocContentTableCell* _tmp12_;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gpointer _tmp15_;
		ValadocContentInline* _tmp16_;
		_tmp12_ = head;
		_tmp13_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_list_last (_tmp14_);
		_tmp16_ = (ValadocContentInline*) _tmp15_;
		_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALADOC_CONTENT_TYPE_TEXT);
		_g_object_unref0 (_tmp16_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValadocContentTableCell* _tmp17_;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gpointer _tmp20_;
		ValadocContentText* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp17_ = head;
		_tmp18_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_list_last (_tmp19_);
		_tmp21_ = G_TYPE_CHECK_INSTANCE_CAST ((ValadocContentInline*) _tmp20_, VALADOC_CONTENT_TYPE_TEXT, ValadocContentText);
		_tmp22_ = valadoc_content_text_get_content (_tmp21_);
		_tmp23_ = _tmp22_;
		g_strchomp (_tmp23_);
		_g_object_unref0 (_tmp21_);
	}
	_g_object_unref0 (head);
}


static void
___lambda110__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda110_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda111_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentTableRow* _tmp1_;
	ValadocContentTableRow* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_table_row (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda111__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda111_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda112_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentTableRow* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentTable* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TABLE_ROW, ValadocContentTableRow);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_TABLE, ValadocContentTable);
	_tmp3_ = valadoc_content_table_get_rows (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, head);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (head);
}


static void
___lambda112__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda112_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda113_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentTable* _tmp1_;
	ValadocContentTable* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_table (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda113__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda113_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda114_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentBlock* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentBlockContent* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_BLOCK, ValadocContentBlock);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp3_ = valadoc_content_block_content_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, head);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (head);
}


static void
___lambda114__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda114_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda115_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_HEADLINE, ValadocContentHeadline);
	valadoc_content_headline_set_level (_tmp1_, 1);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda115__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda115_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda116_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_HEADLINE, ValadocContentHeadline);
	valadoc_content_headline_set_level (_tmp1_, 2);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda116__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda116_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda117_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_HEADLINE, ValadocContentHeadline);
	valadoc_content_headline_set_level (_tmp1_, 3);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda117__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda117_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda118_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_HEADLINE, ValadocContentHeadline);
	valadoc_content_headline_set_level (_tmp1_, 4);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda118__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda118_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda119_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	GObject* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_documentation_parser_peek (self, -1);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_HEADLINE, ValadocContentHeadline);
	valadoc_content_headline_set_level (_tmp1_, 5);
	_g_object_unref0 (_tmp1_);
}


static void
___lambda119__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda119_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda120_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentHeadline* _tmp1_;
	ValadocContentHeadline* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_headline (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda120__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda120_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda121_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentBlock* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentBlockContent* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_BLOCK, ValadocContentBlock);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp3_ = valadoc_content_block_content_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, head);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (head);
}


static void
___lambda121__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda121_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda122_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentPage* _tmp1_;
	ValadocContentPage* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_page (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda122__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda122_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda123_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	ValadocContentParagraph* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda123__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda123_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda124_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentParagraph* p = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentBlockContent* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	p = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_PARAGRAPH, ValadocContentParagraph);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT, ValadocContentBlockContent);
	_tmp3_ = valadoc_content_block_content_get_content (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, (ValadocContentBlock*) p);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (p);
}


static void
___lambda124__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda124_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda125_ (ValadocDocumentationParser* self,
              ValadocToken* token,
              GError** error)
{
	gchar* tag_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ValadocContentTaglet* taglet = NULL;
	ValadocContentContentFactory* _tmp2_;
	const gchar* _tmp3_;
	ValadocContentTaglet* _tmp4_;
	ValadocContentTaglet* _tmp5_;
	ValadocContentTaglet* _tmp7_;
	ValadocRule* taglet_rule = NULL;
	ValadocContentTaglet* _tmp8_;
	ValadocRule* _tmp15_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (token != NULL);
	_tmp0_ = valadoc_token_to_string (token);
	_tmp1_ = g_strdup (_tmp0_);
	tag_name = _tmp1_;
	_tmp2_ = self->priv->_factory;
	_tmp3_ = tag_name;
	_tmp4_ = valadoc_content_content_factory_create_taglet (_tmp2_, _tmp3_);
	taglet = _tmp4_;
	_tmp5_ = taglet;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALADOC_CONTENT_TYPE_BLOCK)) {
		ValadocParser* _tmp6_;
		_tmp6_ = self->priv->_parser;
		valadoc_parser_callback_error ((ValadocParserCallback*) _tmp6_, token, "Invalid taglet in this context", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (taglet);
				_g_free0 (tag_name);
				return;
			} else {
				_g_object_unref0 (taglet);
				_g_free0 (tag_name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp7_ = taglet;
	valadoc_documentation_parser_push (self, (GObject*) _tmp7_);
	_tmp8_ = taglet;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALADOC_CONTENT_TYPE_BLOCK_CONTENT)) {
		ValadocContentTaglet* _tmp9_;
		ValadocRule* _tmp10_;
		ValadocRule* _tmp11_;
		_tmp9_ = taglet;
		_tmp10_ = self->priv->multiline_block_run;
		_tmp11_ = valadoc_content_taglet_get_parser_rule (_tmp9_, _tmp10_);
		_g_object_unref0 (taglet_rule);
		taglet_rule = _tmp11_;
	} else {
		ValadocContentTaglet* _tmp12_;
		ValadocRule* _tmp13_;
		ValadocRule* _tmp14_;
		_tmp12_ = taglet;
		_tmp13_ = self->priv->multiline_run;
		_tmp14_ = valadoc_content_taglet_get_parser_rule (_tmp12_, _tmp13_);
		_g_object_unref0 (taglet_rule);
		taglet_rule = _tmp14_;
	}
	_tmp15_ = taglet_rule;
	if (_tmp15_ != NULL) {
		ValadocParser* _tmp16_;
		ValadocTokenType* _tmp17_;
		GObject* _tmp18_;
		ValadocRule* _tmp19_;
		GObject* _tmp20_;
		GObject** _tmp21_;
		GObject** _tmp22_;
		gint _tmp22__length1;
		ValadocRule* _tmp23_;
		ValadocRule* _tmp24_;
		_tmp16_ = self->priv->_parser;
		_tmp17_ = valadoc_token_type_SPACE;
		_tmp18_ = _g_object_ref0 ((GObject*) _tmp17_);
		_tmp19_ = taglet_rule;
		_tmp20_ = _g_object_ref0 ((GObject*) _tmp19_);
		_tmp21_ = g_new0 (GObject*, 2 + 1);
		_tmp21_[0] = _tmp18_;
		_tmp21_[1] = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 2;
		_tmp23_ = valadoc_rule_seq (_tmp22_, 2);
		_tmp24_ = _tmp23_;
		valadoc_parser_callback_push_rule ((ValadocParserCallback*) _tmp16_, _tmp24_);
		_g_object_unref0 (_tmp24_);
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_g_object_unref0 (taglet_rule);
	_g_object_unref0 (taglet);
	_g_free0 (tag_name);
}


static void
___lambda125__valadoc_token_type_action (ValadocToken* token,
                                         gpointer self,
                                         GError** error)
{
	__lambda125_ ((ValadocDocumentationParser*) self, token, error);
}


static void
__lambda126_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentTaglet* head = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	_tmp0_ = valadoc_documentation_parser_pop (self);
	head = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALADOC_CONTENT_TYPE_TAGLET, ValadocContentTaglet);
	_tmp1_ = valadoc_documentation_parser_peek (self, -1);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALADOC_CONTENT_TYPE_COMMENT, ValadocContentComment);
	_tmp3_ = valadoc_content_comment_get_taglets (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp4_, head);
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (head);
}


static void
___lambda126__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda126_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda127_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentParagraph* _tmp1_;
	ValadocContentParagraph* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_paragraph (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda127__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda127_ ((ValadocDocumentationParser*) self, error);
}


static void
__lambda128_ (ValadocDocumentationParser* self,
              GError** error)
{
	ValadocContentContentFactory* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	_tmp0_ = self->priv->_factory;
	_tmp1_ = valadoc_content_content_factory_create_comment (_tmp0_);
	_tmp2_ = _tmp1_;
	valadoc_documentation_parser_push (self, (GObject*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void
___lambda128__valadoc_rule_action (gpointer self,
                                   GError** error)
{
	__lambda128_ ((ValadocDocumentationParser*) self, error);
}


static void
valadoc_documentation_parser_init_valadoc_rules (ValadocDocumentationParser* self)
{
	ValadocStubRule* run = NULL;
	ValadocStubRule* _tmp0_;
	ValadocRule* _tmp1_;
	ValadocRule* _tmp2_;
	ValadocTokenType* space = NULL;
	ValadocTokenType* _tmp3_;
	ValadocTokenType* _tmp4_;
	ValadocTokenType* word = NULL;
	ValadocTokenType* _tmp5_;
	ValadocTokenType* _tmp6_;
	ValadocTokenType* _tmp7_;
	ValadocTokenType* _tmp8_;
	ValadocRule* optional_invisible_spaces = NULL;
	ValadocTokenType* _tmp9_;
	GObject* _tmp10_;
	GObject** _tmp11_;
	GObject** _tmp12_;
	gint _tmp12__length1;
	ValadocRule* _tmp13_;
	GObject** _tmp14_;
	GObject** _tmp15_;
	gint _tmp15__length1;
	ValadocRule* _tmp16_;
	ValadocRule* _tmp17_;
	ValadocRule* optional_spaces = NULL;
	ValadocTokenType* _tmp18_;
	ValadocTokenType* _tmp19_;
	GObject** _tmp20_;
	GObject** _tmp21_;
	gint _tmp21__length1;
	ValadocRule* _tmp22_;
	GObject** _tmp23_;
	GObject** _tmp24_;
	gint _tmp24__length1;
	ValadocRule* _tmp25_;
	ValadocRule* _tmp26_;
	ValadocRule* text = NULL;
	ValadocTokenType* _tmp27_;
	ValadocTokenType* _tmp28_;
	ValadocTokenType* _tmp29_;
	ValadocTokenType* _tmp30_;
	ValadocTokenType* _tmp31_;
	ValadocTokenType* _tmp32_;
	ValadocTokenType* _tmp33_;
	ValadocTokenType* _tmp34_;
	ValadocTokenType* _tmp35_;
	ValadocTokenType* _tmp36_;
	ValadocTokenType* _tmp37_;
	ValadocTokenType* _tmp38_;
	ValadocTokenType* _tmp39_;
	ValadocTokenType* _tmp40_;
	ValadocTokenType* _tmp41_;
	ValadocTokenType* _tmp42_;
	ValadocTokenType* _tmp43_;
	ValadocTokenType* _tmp44_;
	ValadocTokenType* _tmp45_;
	ValadocTokenType* _tmp46_;
	ValadocTokenType* _tmp47_;
	ValadocTokenType* _tmp48_;
	ValadocTokenType* _tmp49_;
	ValadocTokenType* _tmp50_;
	ValadocTokenType* _tmp51_;
	ValadocTokenType* _tmp52_;
	ValadocTokenType* _tmp53_;
	ValadocTokenType* _tmp54_;
	ValadocTokenType* _tmp55_;
	ValadocTokenType* _tmp56_;
	ValadocTokenType* _tmp57_;
	ValadocTokenType* _tmp58_;
	GObject* _tmp59_;
	GObject** _tmp60_;
	GObject** _tmp61_;
	gint _tmp61__length1;
	ValadocRule* _tmp62_;
	GObject* _tmp63_;
	GObject** _tmp64_;
	GObject** _tmp65_;
	gint _tmp65__length1;
	ValadocRule* _tmp66_;
	GObject** _tmp67_;
	GObject** _tmp68_;
	gint _tmp68__length1;
	ValadocRule* _tmp69_;
	ValadocRule* _tmp70_;
	ValadocRule* _tmp71_;
	ValadocRule* _tmp72_;
	ValadocRule* _tmp73_;
	ValadocRule* _tmp74_;
	ValadocRule* run_with_spaces = NULL;
	GObject* _tmp75_;
	GObject* _tmp76_;
	GObject** _tmp77_;
	GObject** _tmp78_;
	gint _tmp78__length1;
	ValadocRule* _tmp79_;
	GObject** _tmp80_;
	GObject** _tmp81_;
	gint _tmp81__length1;
	ValadocRule* _tmp82_;
	GObject** _tmp83_;
	GObject** _tmp84_;
	gint _tmp84__length1;
	ValadocRule* _tmp85_;
	ValadocRule* _tmp86_;
	ValadocRule* _tmp87_;
	ValadocRule* _tmp88_;
	GObject* _tmp89_;
	ValadocTokenType* _tmp90_;
	ValadocTokenType* _tmp91_;
	GObject** _tmp92_;
	GObject** _tmp93_;
	gint _tmp93__length1;
	ValadocRule* _tmp94_;
	ValadocRule* _tmp95_;
	ValadocRule* _tmp96_;
	ValadocRule* inline_taglet = NULL;
	ValadocTokenType* _tmp97_;
	GObject* _tmp98_;
	ValadocTokenType* _tmp99_;
	GObject* _tmp100_;
	ValadocTokenType* _tmp101_;
	ValadocTokenType* _tmp102_;
	ValadocTokenType* _tmp103_;
	ValadocTokenType* _tmp104_;
	GObject* _tmp105_;
	GObject** _tmp106_;
	GObject** _tmp107_;
	gint _tmp107__length1;
	ValadocRule* _tmp108_;
	ValadocRule* _tmp109_;
	ValadocRule* _tmp110_;
	GObject** _tmp111_;
	GObject** _tmp112_;
	gint _tmp112__length1;
	ValadocRule* _tmp113_;
	ValadocRule* _tmp114_;
	ValadocRule* _tmp115_;
	ValadocRule* _tmp116_;
	ValadocRule* bold = NULL;
	ValadocTokenType* _tmp117_;
	GObject* _tmp118_;
	ValadocTokenType* _tmp119_;
	GObject* _tmp120_;
	GObject* _tmp121_;
	GObject* _tmp122_;
	ValadocTokenType* _tmp123_;
	GObject* _tmp124_;
	GObject** _tmp125_;
	GObject** _tmp126_;
	gint _tmp126__length1;
	ValadocRule* _tmp127_;
	GObject** _tmp128_;
	GObject** _tmp129_;
	gint _tmp129__length1;
	ValadocRule* _tmp130_;
	GObject** _tmp131_;
	GObject** _tmp132_;
	gint _tmp132__length1;
	ValadocRule* _tmp133_;
	ValadocRule* _tmp134_;
	ValadocRule* _tmp135_;
	ValadocRule* _tmp136_;
	ValadocRule* _tmp137_;
	ValadocRule* _tmp138_;
	ValadocRule* italic = NULL;
	ValadocTokenType* _tmp139_;
	GObject* _tmp140_;
	ValadocTokenType* _tmp141_;
	GObject* _tmp142_;
	GObject* _tmp143_;
	GObject* _tmp144_;
	ValadocTokenType* _tmp145_;
	GObject* _tmp146_;
	GObject** _tmp147_;
	GObject** _tmp148_;
	gint _tmp148__length1;
	ValadocRule* _tmp149_;
	GObject** _tmp150_;
	GObject** _tmp151_;
	gint _tmp151__length1;
	ValadocRule* _tmp152_;
	GObject** _tmp153_;
	GObject** _tmp154_;
	gint _tmp154__length1;
	ValadocRule* _tmp155_;
	ValadocRule* _tmp156_;
	ValadocRule* _tmp157_;
	ValadocRule* _tmp158_;
	ValadocRule* _tmp159_;
	ValadocRule* _tmp160_;
	ValadocRule* underlined = NULL;
	ValadocTokenType* _tmp161_;
	GObject* _tmp162_;
	ValadocTokenType* _tmp163_;
	GObject* _tmp164_;
	GObject* _tmp165_;
	GObject* _tmp166_;
	ValadocTokenType* _tmp167_;
	GObject* _tmp168_;
	GObject** _tmp169_;
	GObject** _tmp170_;
	gint _tmp170__length1;
	ValadocRule* _tmp171_;
	GObject** _tmp172_;
	GObject** _tmp173_;
	gint _tmp173__length1;
	ValadocRule* _tmp174_;
	GObject** _tmp175_;
	GObject** _tmp176_;
	gint _tmp176__length1;
	ValadocRule* _tmp177_;
	ValadocRule* _tmp178_;
	ValadocRule* _tmp179_;
	ValadocRule* _tmp180_;
	ValadocRule* _tmp181_;
	ValadocRule* _tmp182_;
	ValadocRule* monospace = NULL;
	ValadocTokenType* _tmp183_;
	GObject* _tmp184_;
	ValadocTokenType* _tmp185_;
	GObject* _tmp186_;
	GObject* _tmp187_;
	GObject* _tmp188_;
	ValadocTokenType* _tmp189_;
	GObject* _tmp190_;
	GObject** _tmp191_;
	GObject** _tmp192_;
	gint _tmp192__length1;
	ValadocRule* _tmp193_;
	GObject** _tmp194_;
	GObject** _tmp195_;
	gint _tmp195__length1;
	ValadocRule* _tmp196_;
	GObject** _tmp197_;
	GObject** _tmp198_;
	gint _tmp198__length1;
	ValadocRule* _tmp199_;
	ValadocRule* _tmp200_;
	ValadocRule* _tmp201_;
	ValadocRule* _tmp202_;
	ValadocRule* _tmp203_;
	ValadocRule* _tmp204_;
	ValadocRule* embedded = NULL;
	ValadocTokenType* _tmp205_;
	ValadocTokenType* _tmp206_;
	ValadocTokenType* _tmp207_;
	ValadocTokenType* _tmp208_;
	ValadocTokenType* _tmp209_;
	ValadocTokenType* _tmp210_;
	ValadocTokenType* _tmp211_;
	GObject* _tmp212_;
	GObject** _tmp213_;
	GObject** _tmp214_;
	gint _tmp214__length1;
	ValadocRule* _tmp215_;
	ValadocRule* _tmp216_;
	ValadocRule* _tmp217_;
	ValadocTokenType* _tmp218_;
	ValadocTokenType* _tmp219_;
	GObject** _tmp220_;
	GObject** _tmp221_;
	gint _tmp221__length1;
	ValadocRule* _tmp222_;
	ValadocRule* _tmp223_;
	ValadocRule* _tmp224_;
	ValadocRule* _tmp225_;
	ValadocRule* _tmp226_;
	ValadocRule* _tmp227_;
	ValadocRule* link = NULL;
	ValadocTokenType* _tmp228_;
	ValadocTokenType* _tmp229_;
	ValadocTokenType* _tmp230_;
	ValadocTokenType* _tmp231_;
	ValadocTokenType* _tmp232_;
	ValadocTokenType* _tmp233_;
	ValadocTokenType* _tmp234_;
	GObject* _tmp235_;
	GObject** _tmp236_;
	GObject** _tmp237_;
	gint _tmp237__length1;
	ValadocRule* _tmp238_;
	ValadocTokenType* _tmp239_;
	ValadocTokenType* _tmp240_;
	GObject** _tmp241_;
	GObject** _tmp242_;
	gint _tmp242__length1;
	ValadocRule* _tmp243_;
	ValadocRule* _tmp244_;
	ValadocRule* _tmp245_;
	ValadocRule* _tmp246_;
	ValadocRule* source_code = NULL;
	ValadocTokenType* _tmp247_;
	ValadocTokenType* _tmp248_;
	ValadocTokenType* _tmp249_;
	ValadocTokenType* _tmp250_;
	ValadocTokenType* _tmp251_;
	ValadocTokenType* _tmp252_;
	ValadocTokenType* _tmp253_;
	GObject** _tmp254_;
	GObject** _tmp255_;
	gint _tmp255__length1;
	ValadocRule* _tmp256_;
	ValadocRule* _tmp257_;
	ValadocRule* _tmp258_;
	ValadocRule* _tmp259_;
	ValadocRule* _tmp260_;
	ValadocRule* _tmp261_;
	ValadocRuleAction append_head_to_head2 = NULL;
	void* append_head_to_head2_target;
	GDestroyNotify append_head_to_head2_target_destroy_notify;
	ValadocRule* run_subrules = NULL;
	GObject* _tmp262_;
	GObject** _tmp263_;
	GObject** _tmp264_;
	gint _tmp264__length1;
	ValadocRule* _tmp265_;
	ValadocRule* _tmp266_;
	ValadocRule* _tmp267_;
	GObject* _tmp268_;
	GObject* _tmp269_;
	GObject* _tmp270_;
	GObject* _tmp271_;
	GObject* _tmp272_;
	GObject* _tmp273_;
	GObject* _tmp274_;
	GObject* _tmp275_;
	GObject** _tmp276_;
	GObject** _tmp277_;
	gint _tmp277__length1;
	ValadocRule* _tmp278_;
	ValadocRule* _tmp279_;
	ValadocRule* _tmp280_;
	GObject* _tmp281_;
	GObject** _tmp282_;
	GObject** _tmp283_;
	gint _tmp283__length1;
	ValadocRule* _tmp284_;
	GObject** _tmp285_;
	GObject** _tmp286_;
	gint _tmp286__length1;
	ValadocRule* _tmp287_;
	ValadocRule* _tmp288_;
	ValadocRule* run_arobase = NULL;
	ValadocTokenType* _tmp289_;
	ValadocTokenType* _tmp290_;
	GObject** _tmp291_;
	GObject** _tmp292_;
	gint _tmp292__length1;
	ValadocRule* _tmp293_;
	ValadocRule* _tmp294_;
	ValadocRule* _tmp295_;
	ValadocRule* _tmp296_;
	GObject* _tmp297_;
	GObject* _tmp298_;
	GObject* _tmp299_;
	GObject* _tmp300_;
	GObject* _tmp301_;
	GObject** _tmp302_;
	GObject** _tmp303_;
	gint _tmp303__length1;
	ValadocRule* _tmp304_;
	GObject** _tmp305_;
	GObject** _tmp306_;
	gint _tmp306__length1;
	ValadocRule* _tmp307_;
	GObject** _tmp308_;
	GObject** _tmp309_;
	gint _tmp309__length1;
	ValadocRule* _tmp310_;
	GObject** _tmp311_;
	GObject** _tmp312_;
	gint _tmp312__length1;
	ValadocRule* _tmp313_;
	ValadocRule* _tmp314_;
	ValadocRule* _tmp315_;
	ValadocRule* _tmp316_;
	ValadocRule* _tmp317_;
	ValadocRule* _tmp318_;
	ValadocRuleAction reduce_paragraph = NULL;
	void* reduce_paragraph_target;
	GDestroyNotify reduce_paragraph_target_destroy_notify;
	ValadocRule* paragraph = NULL;
	ValadocTokenType* _tmp319_;
	ValadocTokenType* _tmp320_;
	ValadocTokenType* _tmp321_;
	ValadocTokenType* _tmp322_;
	GObject** _tmp323_;
	GObject** _tmp324_;
	gint _tmp324__length1;
	ValadocRule* _tmp325_;
	GObject** _tmp326_;
	GObject** _tmp327_;
	gint _tmp327__length1;
	ValadocRule* _tmp328_;
	GObject* _tmp329_;
	ValadocTokenType* _tmp330_;
	ValadocTokenType* _tmp331_;
	GObject** _tmp332_;
	GObject** _tmp333_;
	gint _tmp333__length1;
	ValadocRule* _tmp334_;
	GObject** _tmp335_;
	GObject** _tmp336_;
	gint _tmp336__length1;
	ValadocRule* _tmp337_;
	ValadocRule* _tmp338_;
	ValadocRule* _tmp339_;
	ValadocRule* _tmp340_;
	ValadocRule* _tmp341_;
	ValadocRule* _tmp342_;
	ValadocRule* _tmp343_;
	ValadocRule* _tmp344_;
	ValadocRule* warning = NULL;
	ValadocTokenType* _tmp345_;
	GObject* _tmp346_;
	GObject* _tmp347_;
	GObject* _tmp348_;
	GObject** _tmp349_;
	GObject** _tmp350_;
	gint _tmp350__length1;
	ValadocRule* _tmp351_;
	ValadocTokenType* _tmp352_;
	ValadocTokenType* _tmp353_;
	GObject** _tmp354_;
	GObject** _tmp355_;
	gint _tmp355__length1;
	ValadocRule* _tmp356_;
	GObject** _tmp357_;
	GObject** _tmp358_;
	gint _tmp358__length1;
	ValadocRule* _tmp359_;
	ValadocRule* _tmp360_;
	ValadocRule* _tmp361_;
	ValadocRule* _tmp362_;
	ValadocRule* _tmp363_;
	ValadocRule* _tmp364_;
	ValadocRule* _tmp365_;
	ValadocRule* _tmp366_;
	ValadocRule* note = NULL;
	ValadocTokenType* _tmp367_;
	GObject* _tmp368_;
	GObject* _tmp369_;
	GObject* _tmp370_;
	GObject** _tmp371_;
	GObject** _tmp372_;
	gint _tmp372__length1;
	ValadocRule* _tmp373_;
	ValadocTokenType* _tmp374_;
	ValadocTokenType* _tmp375_;
	GObject** _tmp376_;
	GObject** _tmp377_;
	gint _tmp377__length1;
	ValadocRule* _tmp378_;
	GObject** _tmp379_;
	GObject** _tmp380_;
	gint _tmp380__length1;
	ValadocRule* _tmp381_;
	ValadocRule* _tmp382_;
	ValadocRule* _tmp383_;
	ValadocRule* _tmp384_;
	ValadocRule* _tmp385_;
	ValadocRule* _tmp386_;
	ValadocRule* _tmp387_;
	ValadocRule* _tmp388_;
	ValadocRule* indented_item = NULL;
	ValadocTokenType* _tmp389_;
	ValadocTokenType* _tmp390_;
	GObject** _tmp391_;
	GObject** _tmp392_;
	gint _tmp392__length1;
	ValadocRule* _tmp393_;
	ValadocTokenType* _tmp394_;
	ValadocTokenType* _tmp395_;
	ValadocTokenType* _tmp396_;
	ValadocTokenType* _tmp397_;
	ValadocTokenType* _tmp398_;
	ValadocTokenType* _tmp399_;
	ValadocTokenType* _tmp400_;
	ValadocTokenType* _tmp401_;
	ValadocTokenType* _tmp402_;
	ValadocTokenType* _tmp403_;
	ValadocTokenType* _tmp404_;
	ValadocTokenType* _tmp405_;
	ValadocTokenType* _tmp406_;
	ValadocTokenType* _tmp407_;
	ValadocTokenType* _tmp408_;
	ValadocTokenType* _tmp409_;
	ValadocTokenType* _tmp410_;
	ValadocTokenType* _tmp411_;
	ValadocTokenType* _tmp412_;
	ValadocTokenType* _tmp413_;
	ValadocTokenType* _tmp414_;
	ValadocTokenType* _tmp415_;
	ValadocTokenType* _tmp416_;
	ValadocTokenType* _tmp417_;
	GObject** _tmp418_;
	GObject** _tmp419_;
	gint _tmp419__length1;
	ValadocRule* _tmp420_;
	GObject* _tmp421_;
	GObject** _tmp422_;
	GObject** _tmp423_;
	gint _tmp423__length1;
	ValadocRule* _tmp424_;
	ValadocRule* _tmp425_;
	ValadocRule* _tmp426_;
	GObject* _tmp427_;
	GObject** _tmp428_;
	GObject** _tmp429_;
	gint _tmp429__length1;
	ValadocRule* _tmp430_;
	ValadocRule* _tmp431_;
	ValadocRule* _tmp432_;
	ValadocRule* _tmp433_;
	ValadocRule* _tmp434_;
	ValadocTokenType* _tmp435_;
	GObject* _tmp436_;
	GObject** _tmp437_;
	GObject** _tmp438_;
	gint _tmp438__length1;
	ValadocRule* _tmp439_;
	ValadocRule* _tmp440_;
	ValadocRule* _tmp441_;
	ValadocRule* _tmp442_;
	ValadocRule* _tmp443_;
	ValadocRule* _tmp444_;
	ValadocRule* _tmp445_;
	ValadocRule* _tmp446_;
	ValadocRule* indented_blocks = NULL;
	GObject* _tmp447_;
	GObject** _tmp448_;
	GObject** _tmp449_;
	gint _tmp449__length1;
	ValadocRule* _tmp450_;
	ValadocRule* _tmp451_;
	ValadocRule* _tmp452_;
	ValadocRule* _tmp453_;
	ValadocRule* _tmp454_;
	ValadocRule* _tmp455_;
	ValadocRule* table_cell_attributes = NULL;
	ValadocTokenType* _tmp456_;
	GObject* _tmp457_;
	ValadocTokenType* _tmp458_;
	ValadocTokenType* _tmp459_;
	ValadocTokenType* _tmp460_;
	ValadocTokenType* _tmp461_;
	GObject** _tmp462_;
	GObject** _tmp463_;
	gint _tmp463__length1;
	ValadocRule* _tmp464_;
	GObject** _tmp465_;
	GObject** _tmp466_;
	gint _tmp466__length1;
	ValadocRule* _tmp467_;
	ValadocTokenType* _tmp468_;
	ValadocTokenType* _tmp469_;
	ValadocTokenType* _tmp470_;
	ValadocTokenType* _tmp471_;
	GObject** _tmp472_;
	GObject** _tmp473_;
	gint _tmp473__length1;
	ValadocRule* _tmp474_;
	GObject** _tmp475_;
	GObject** _tmp476_;
	gint _tmp476__length1;
	ValadocRule* _tmp477_;
	GObject** _tmp478_;
	GObject** _tmp479_;
	gint _tmp479__length1;
	ValadocRule* _tmp480_;
	ValadocTokenType* _tmp481_;
	ValadocTokenType* _tmp482_;
	ValadocTokenType* _tmp483_;
	GObject** _tmp484_;
	GObject** _tmp485_;
	gint _tmp485__length1;
	ValadocRule* _tmp486_;
	GObject** _tmp487_;
	GObject** _tmp488_;
	gint _tmp488__length1;
	ValadocRule* _tmp489_;
	ValadocTokenType* _tmp490_;
	GObject* _tmp491_;
	ValadocTokenType* _tmp492_;
	ValadocTokenType* _tmp493_;
	ValadocTokenType* _tmp494_;
	GObject** _tmp495_;
	GObject** _tmp496_;
	gint _tmp496__length1;
	ValadocRule* _tmp497_;
	ValadocTokenType* _tmp498_;
	GObject* _tmp499_;
	ValadocTokenType* _tmp500_;
	ValadocTokenType* _tmp501_;
	ValadocTokenType* _tmp502_;
	GObject** _tmp503_;
	GObject** _tmp504_;
	gint _tmp504__length1;
	ValadocRule* _tmp505_;
	GObject** _tmp506_;
	GObject** _tmp507_;
	gint _tmp507__length1;
	ValadocRule* _tmp508_;
	GObject** _tmp509_;
	GObject** _tmp510_;
	gint _tmp510__length1;
	ValadocRule* _tmp511_;
	ValadocTokenType* _tmp512_;
	GObject* _tmp513_;
	GObject** _tmp514_;
	GObject** _tmp515_;
	gint _tmp515__length1;
	ValadocRule* _tmp516_;
	ValadocRule* _tmp517_;
	ValadocRule* _tmp518_;
	ValadocRule* _tmp519_;
	ValadocRule* table_cell = NULL;
	GObject* _tmp520_;
	GObject** _tmp521_;
	GObject** _tmp522_;
	gint _tmp522__length1;
	ValadocRule* _tmp523_;
	GObject* _tmp524_;
	GObject* _tmp525_;
	GObject** _tmp526_;
	GObject** _tmp527_;
	gint _tmp527__length1;
	ValadocRule* _tmp528_;
	ValadocTokenType* _tmp529_;
	GObject* _tmp530_;
	GObject** _tmp531_;
	GObject** _tmp532_;
	gint _tmp532__length1;
	ValadocRule* _tmp533_;
	ValadocRule* _tmp534_;
	ValadocRule* _tmp535_;
	ValadocRule* _tmp536_;
	ValadocRule* _tmp537_;
	ValadocRule* _tmp538_;
	ValadocRule* _tmp539_;
	ValadocRule* _tmp540_;
	ValadocRule* table_row = NULL;
	ValadocTokenType* _tmp541_;
	GObject* _tmp542_;
	GObject* _tmp543_;
	GObject** _tmp544_;
	GObject** _tmp545_;
	gint _tmp545__length1;
	ValadocRule* _tmp546_;
	ValadocTokenType* _tmp547_;
	GObject* _tmp548_;
	GObject** _tmp549_;
	GObject** _tmp550_;
	gint _tmp550__length1;
	ValadocRule* _tmp551_;
	ValadocRule* _tmp552_;
	ValadocRule* _tmp553_;
	ValadocRule* _tmp554_;
	ValadocRule* _tmp555_;
	ValadocRule* _tmp556_;
	ValadocRule* _tmp557_;
	ValadocRule* _tmp558_;
	ValadocRule* table = NULL;
	GObject* _tmp559_;
	GObject** _tmp560_;
	GObject** _tmp561_;
	gint _tmp561__length1;
	ValadocRule* _tmp562_;
	GObject** _tmp563_;
	GObject** _tmp564_;
	gint _tmp564__length1;
	ValadocRule* _tmp565_;
	ValadocRule* _tmp566_;
	ValadocRule* _tmp567_;
	ValadocRule* _tmp568_;
	ValadocRule* _tmp569_;
	ValadocRule* _tmp570_;
	ValadocRule* _tmp571_;
	ValadocRule* _tmp572_;
	ValadocRule* headline = NULL;
	ValadocTokenType* _tmp573_;
	ValadocTokenType* _tmp574_;
	GObject* _tmp575_;
	GObject* _tmp576_;
	GObject* _tmp577_;
	ValadocTokenType* _tmp578_;
	GObject* _tmp579_;
	ValadocTokenType* _tmp580_;
	GObject* _tmp581_;
	GObject** _tmp582_;
	GObject** _tmp583_;
	gint _tmp583__length1;
	ValadocRule* _tmp584_;
	ValadocTokenType* _tmp585_;
	ValadocTokenType* _tmp586_;
	GObject* _tmp587_;
	GObject* _tmp588_;
	GObject* _tmp589_;
	ValadocTokenType* _tmp590_;
	GObject* _tmp591_;
	ValadocTokenType* _tmp592_;
	GObject* _tmp593_;
	GObject** _tmp594_;
	GObject** _tmp595_;
	gint _tmp595__length1;
	ValadocRule* _tmp596_;
	ValadocTokenType* _tmp597_;
	ValadocTokenType* _tmp598_;
	GObject* _tmp599_;
	GObject* _tmp600_;
	GObject* _tmp601_;
	ValadocTokenType* _tmp602_;
	GObject* _tmp603_;
	ValadocTokenType* _tmp604_;
	GObject* _tmp605_;
	GObject** _tmp606_;
	GObject** _tmp607_;
	gint _tmp607__length1;
	ValadocRule* _tmp608_;
	ValadocTokenType* _tmp609_;
	ValadocTokenType* _tmp610_;
	GObject* _tmp611_;
	GObject* _tmp612_;
	GObject* _tmp613_;
	ValadocTokenType* _tmp614_;
	GObject* _tmp615_;
	ValadocTokenType* _tmp616_;
	GObject* _tmp617_;
	GObject** _tmp618_;
	GObject** _tmp619_;
	gint _tmp619__length1;
	ValadocRule* _tmp620_;
	ValadocTokenType* _tmp621_;
	ValadocTokenType* _tmp622_;
	GObject* _tmp623_;
	GObject* _tmp624_;
	GObject* _tmp625_;
	ValadocTokenType* _tmp626_;
	GObject* _tmp627_;
	ValadocTokenType* _tmp628_;
	GObject* _tmp629_;
	GObject** _tmp630_;
	GObject** _tmp631_;
	gint _tmp631__length1;
	ValadocRule* _tmp632_;
	GObject** _tmp633_;
	GObject** _tmp634_;
	gint _tmp634__length1;
	ValadocRule* _tmp635_;
	ValadocRule* _tmp636_;
	ValadocRule* _tmp637_;
	ValadocRule* _tmp638_;
	ValadocRule* _tmp639_;
	ValadocRule* _tmp640_;
	ValadocRule* _tmp641_;
	ValadocRule* _tmp642_;
	ValadocRule* blocks = NULL;
	GObject* _tmp643_;
	GObject* _tmp644_;
	GObject* _tmp645_;
	GObject* _tmp646_;
	GObject* _tmp647_;
	GObject* _tmp648_;
	GObject** _tmp649_;
	GObject** _tmp650_;
	gint _tmp650__length1;
	ValadocRule* _tmp651_;
	ValadocRule* _tmp652_;
	ValadocRule* _tmp653_;
	ValadocRule* _tmp654_;
	ValadocRule* page = NULL;
	GObject* _tmp655_;
	ValadocTokenType* _tmp656_;
	GObject* _tmp657_;
	GObject* _tmp658_;
	GObject** _tmp659_;
	GObject** _tmp660_;
	gint _tmp660__length1;
	ValadocRule* _tmp661_;
	GObject** _tmp662_;
	GObject** _tmp663_;
	gint _tmp663__length1;
	ValadocRule* _tmp664_;
	GObject** _tmp665_;
	GObject** _tmp666_;
	gint _tmp666__length1;
	ValadocRule* _tmp667_;
	GObject** _tmp668_;
	GObject** _tmp669_;
	gint _tmp669__length1;
	ValadocRule* _tmp670_;
	ValadocRule* _tmp671_;
	ValadocRule* _tmp672_;
	ValadocRule* _tmp673_;
	ValadocRule* _tmp674_;
	ValadocRule* _tmp675_;
	ValadocRule* description = NULL;
	GObject* _tmp676_;
	ValadocTokenType* _tmp677_;
	GObject* _tmp678_;
	GObject* _tmp679_;
	GObject** _tmp680_;
	GObject** _tmp681_;
	gint _tmp681__length1;
	ValadocRule* _tmp682_;
	GObject** _tmp683_;
	GObject** _tmp684_;
	gint _tmp684__length1;
	ValadocRule* _tmp685_;
	GObject** _tmp686_;
	GObject** _tmp687_;
	gint _tmp687__length1;
	ValadocRule* _tmp688_;
	GObject** _tmp689_;
	GObject** _tmp690_;
	gint _tmp690__length1;
	ValadocRule* _tmp691_;
	ValadocRule* _tmp692_;
	ValadocRule* _tmp693_;
	ValadocRule* _tmp694_;
	ValadocRule* _tmp695_;
	GObject* _tmp696_;
	GObject** _tmp697_;
	GObject** _tmp698_;
	gint _tmp698__length1;
	ValadocRule* _tmp699_;
	ValadocRule* _tmp700_;
	ValadocRule* _tmp701_;
	ValadocRule* _tmp702_;
	ValadocRule* _tmp703_;
	ValadocRule* _tmp704_;
	ValadocRule* _tmp705_;
	ValadocRule* taglet = NULL;
	ValadocTokenType* _tmp706_;
	GObject* _tmp707_;
	ValadocTokenType* _tmp708_;
	ValadocTokenType* _tmp709_;
	ValadocTokenType* _tmp710_;
	ValadocTokenType* _tmp711_;
	GObject* _tmp712_;
	GObject** _tmp713_;
	GObject** _tmp714_;
	gint _tmp714__length1;
	ValadocRule* _tmp715_;
	GObject** _tmp716_;
	GObject** _tmp717_;
	gint _tmp717__length1;
	ValadocRule* _tmp718_;
	GObject** _tmp719_;
	GObject** _tmp720_;
	gint _tmp720__length1;
	ValadocRule* _tmp721_;
	ValadocRule* _tmp722_;
	ValadocRule* _tmp723_;
	ValadocRule* _tmp724_;
	ValadocRule* _tmp725_;
	ValadocRule* _tmp726_;
	ValadocRule* ml_comment = NULL;
	ValadocTokenType* _tmp727_;
	GObject* _tmp728_;
	GObject* _tmp729_;
	GObject** _tmp730_;
	GObject** _tmp731_;
	gint _tmp731__length1;
	ValadocRule* _tmp732_;
	GObject* _tmp733_;
	GObject** _tmp734_;
	GObject** _tmp735_;
	gint _tmp735__length1;
	ValadocRule* _tmp736_;
	GObject** _tmp737_;
	GObject** _tmp738_;
	gint _tmp738__length1;
	ValadocRule* _tmp739_;
	GObject** _tmp740_;
	GObject** _tmp741_;
	gint _tmp741__length1;
	ValadocRule* _tmp742_;
	ValadocRule* _tmp743_;
	ValadocRule* _tmp744_;
	ValadocRule* _tmp745_;
	ValadocRule* sl_comment = NULL;
	GObject* _tmp746_;
	GObject** _tmp747_;
	GObject** _tmp748_;
	gint _tmp748__length1;
	ValadocRule* _tmp749_;
	ValadocRule* _tmp750_;
	ValadocRule* _tmp751_;
	ValadocRule* _tmp752_;
	ValadocRule* _tmp753_;
	ValadocRule* _tmp754_;
	ValadocRule* _tmp755_;
	ValadocRule* _tmp756_;
	ValadocRule* comment = NULL;
	GObject* _tmp757_;
	GObject* _tmp758_;
	GObject** _tmp759_;
	GObject** _tmp760_;
	gint _tmp760__length1;
	ValadocRule* _tmp761_;
	ValadocRule* _tmp762_;
	ValadocRule* _tmp763_;
	ValadocRule* _tmp764_;
	ValadocRule* _tmp765_;
	ValadocRule* _tmp766_;
	ValadocParser* _tmp767_;
	ValadocParser* _tmp768_;
	g_return_if_fail (self != NULL);
	_tmp0_ = valadoc_stub_rule_new ();
	run = _tmp0_;
	_tmp1_ = valadoc_rule_set_name ((ValadocRule*) run, "Run");
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = valadoc_token_type_SPACE;
	_tmp4_ = valadoc_token_type_action (_tmp3_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	space = _tmp4_;
	_tmp5_ = valadoc_token_type_any_word ();
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_token_type_action (_tmp6_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	word = _tmp8_;
	_tmp9_ = valadoc_token_type_SPACE;
	_tmp10_ = _g_object_ref0 ((GObject*) _tmp9_);
	_tmp11_ = g_new0 (GObject*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	_tmp13_ = valadoc_rule_many (_tmp12_, 1);
	_tmp14_ = g_new0 (GObject*, 1 + 1);
	_tmp14_[0] = (GObject*) _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	_tmp16_ = valadoc_rule_option (_tmp15_, 1);
	_tmp17_ = _tmp16_;
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_object_unref), NULL);
	optional_invisible_spaces = _tmp17_;
	_tmp18_ = valadoc_token_type_SPACE;
	_tmp19_ = valadoc_token_type_action (_tmp18_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	_tmp20_ = g_new0 (GObject*, 1 + 1);
	_tmp20_[0] = (GObject*) _tmp19_;
	_tmp21_ = _tmp20_;
	_tmp21__length1 = 1;
	_tmp22_ = valadoc_rule_many (_tmp21_, 1);
	_tmp23_ = g_new0 (GObject*, 1 + 1);
	_tmp23_[0] = (GObject*) _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 1;
	_tmp25_ = valadoc_rule_option (_tmp24_, 1);
	_tmp26_ = _tmp25_;
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp21_ = (_vala_array_free (_tmp21_, _tmp21__length1, (GDestroyNotify) g_object_unref), NULL);
	optional_spaces = _tmp26_;
	_tmp27_ = valadoc_token_type_BREAK;
	_tmp28_ = valadoc_token_type_action (_tmp27_, ___lambda56__valadoc_token_type_action, self);
	_tmp29_ = valadoc_token_type_CLOSED_BRACE;
	_tmp30_ = valadoc_token_type_action (_tmp29_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp31_ = valadoc_token_type_MINUS;
	_tmp32_ = valadoc_token_type_action (_tmp31_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp33_ = valadoc_token_type_ALIGN_BOTTOM;
	_tmp34_ = valadoc_token_type_action (_tmp33_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp35_ = valadoc_token_type_ALIGN_TOP;
	_tmp36_ = valadoc_token_type_action (_tmp35_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp37_ = valadoc_token_type_GREATER_THAN;
	_tmp38_ = valadoc_token_type_action (_tmp37_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp39_ = valadoc_token_type_LESS_THAN;
	_tmp40_ = valadoc_token_type_action (_tmp39_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp41_ = valadoc_token_type_DOUBLE_PIPE;
	_tmp42_ = valadoc_token_type_action (_tmp41_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp43_ = valadoc_token_type_PIPE;
	_tmp44_ = valadoc_token_type_action (_tmp43_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp45_ = valadoc_token_type_ALIGN_RIGHT;
	_tmp46_ = valadoc_token_type_action (_tmp45_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp47_ = valadoc_token_type_ALIGN_CENTER;
	_tmp48_ = valadoc_token_type_action (_tmp47_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp49_ = valadoc_token_type_EQUAL_1;
	_tmp50_ = valadoc_token_type_action (_tmp49_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp51_ = valadoc_token_type_EQUAL_2;
	_tmp52_ = valadoc_token_type_action (_tmp51_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp53_ = valadoc_token_type_EQUAL_3;
	_tmp54_ = valadoc_token_type_action (_tmp53_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp55_ = valadoc_token_type_EQUAL_4;
	_tmp56_ = valadoc_token_type_action (_tmp55_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp57_ = valadoc_token_type_EQUAL_5;
	_tmp58_ = valadoc_token_type_action (_tmp57_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp59_ = _g_object_ref0 ((GObject*) word);
	_tmp60_ = g_new0 (GObject*, 17 + 1);
	_tmp60_[0] = (GObject*) _tmp28_;
	_tmp60_[1] = (GObject*) _tmp30_;
	_tmp60_[2] = (GObject*) _tmp32_;
	_tmp60_[3] = (GObject*) _tmp34_;
	_tmp60_[4] = (GObject*) _tmp36_;
	_tmp60_[5] = (GObject*) _tmp38_;
	_tmp60_[6] = (GObject*) _tmp40_;
	_tmp60_[7] = (GObject*) _tmp42_;
	_tmp60_[8] = (GObject*) _tmp44_;
	_tmp60_[9] = (GObject*) _tmp46_;
	_tmp60_[10] = (GObject*) _tmp48_;
	_tmp60_[11] = (GObject*) _tmp50_;
	_tmp60_[12] = (GObject*) _tmp52_;
	_tmp60_[13] = (GObject*) _tmp54_;
	_tmp60_[14] = (GObject*) _tmp56_;
	_tmp60_[15] = (GObject*) _tmp58_;
	_tmp60_[16] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 17;
	_tmp62_ = valadoc_rule_one_of (_tmp61_, 17);
	_tmp63_ = _g_object_ref0 ((GObject*) space);
	_tmp64_ = g_new0 (GObject*, 1 + 1);
	_tmp64_[0] = _tmp63_;
	_tmp65_ = _tmp64_;
	_tmp65__length1 = 1;
	_tmp66_ = valadoc_rule_option (_tmp65_, 1);
	_tmp67_ = g_new0 (GObject*, 2 + 1);
	_tmp67_[0] = (GObject*) _tmp62_;
	_tmp67_[1] = (GObject*) _tmp66_;
	_tmp68_ = _tmp67_;
	_tmp68__length1 = 2;
	_tmp69_ = valadoc_rule_many (_tmp68_, 2);
	_tmp70_ = _tmp69_;
	_tmp71_ = valadoc_rule_set_name (_tmp70_, "Text");
	_tmp72_ = _tmp71_;
	_tmp73_ = valadoc_rule_set_start (_tmp72_, ___lambda57__valadoc_rule_action, self);
	_tmp74_ = _tmp73_;
	_g_object_unref0 (_tmp72_);
	_g_object_unref0 (_tmp70_);
	_tmp68_ = (_vala_array_free (_tmp68_, _tmp68__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp65_ = (_vala_array_free (_tmp65_, _tmp65__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_object_unref), NULL);
	text = _tmp74_;
	_tmp75_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp76_ = _g_object_ref0 ((GObject*) run);
	_tmp77_ = g_new0 (GObject*, 2 + 1);
	_tmp77_[0] = _tmp75_;
	_tmp77_[1] = _tmp76_;
	_tmp78_ = _tmp77_;
	_tmp78__length1 = 2;
	_tmp79_ = valadoc_rule_one_of (_tmp78_, 2);
	_tmp80_ = g_new0 (GObject*, 1 + 1);
	_tmp80_[0] = (GObject*) _tmp79_;
	_tmp81_ = _tmp80_;
	_tmp81__length1 = 1;
	_tmp82_ = valadoc_rule_many (_tmp81_, 1);
	_tmp83_ = g_new0 (GObject*, 1 + 1);
	_tmp83_[0] = (GObject*) _tmp82_;
	_tmp84_ = _tmp83_;
	_tmp84__length1 = 1;
	_tmp85_ = valadoc_rule_seq (_tmp84_, 1);
	_tmp86_ = _tmp85_;
	_tmp87_ = valadoc_rule_set_name (_tmp86_, "RunWithSpaces");
	_tmp88_ = _tmp87_;
	_g_object_unref0 (_tmp86_);
	_tmp84_ = (_vala_array_free (_tmp84_, _tmp84__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp78_ = (_vala_array_free (_tmp78_, _tmp78__length1, (GDestroyNotify) g_object_unref), NULL);
	run_with_spaces = _tmp88_;
	_tmp89_ = _g_object_ref0 ((GObject*) run_with_spaces);
	_tmp90_ = valadoc_token_type_EOL;
	_tmp91_ = valadoc_token_type_action (_tmp90_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	_tmp92_ = g_new0 (GObject*, 2 + 1);
	_tmp92_[0] = _tmp89_;
	_tmp92_[1] = (GObject*) _tmp91_;
	_tmp93_ = _tmp92_;
	_tmp93__length1 = 2;
	_tmp94_ = valadoc_rule_many (_tmp93_, 2);
	_tmp95_ = _tmp94_;
	_tmp96_ = valadoc_rule_set_name (_tmp95_, "MultiLineRun");
	_g_object_unref0 (self->priv->multiline_run);
	self->priv->multiline_run = _tmp96_;
	_g_object_unref0 (_tmp95_);
	_tmp93_ = (_vala_array_free (_tmp93_, _tmp93__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp97_ = valadoc_token_type_OPEN_BRACE;
	_tmp98_ = _g_object_ref0 ((GObject*) _tmp97_);
	_tmp99_ = valadoc_token_type_AROBASE;
	_tmp100_ = _g_object_ref0 ((GObject*) _tmp99_);
	_tmp101_ = valadoc_token_type_any_word ();
	_tmp102_ = _tmp101_;
	_tmp103_ = valadoc_token_type_action (_tmp102_, ___lambda58__valadoc_token_type_action, self);
	_tmp104_ = valadoc_token_type_CLOSED_BRACE;
	_tmp105_ = _g_object_ref0 ((GObject*) _tmp104_);
	_tmp106_ = g_new0 (GObject*, 3 + 1);
	_tmp106_[0] = _tmp100_;
	_tmp106_[1] = (GObject*) _tmp103_;
	_tmp106_[2] = _tmp105_;
	_tmp107_ = _tmp106_;
	_tmp107__length1 = 3;
	_tmp108_ = valadoc_rule_option (_tmp107_, 3);
	_tmp109_ = _tmp108_;
	_tmp110_ = valadoc_rule_set_skip (_tmp109_, ___lambda59__valadoc_rule_action, self);
	_tmp111_ = g_new0 (GObject*, 2 + 1);
	_tmp111_[0] = _tmp98_;
	_tmp111_[1] = (GObject*) _tmp110_;
	_tmp112_ = _tmp111_;
	_tmp112__length1 = 2;
	_tmp113_ = valadoc_rule_seq (_tmp112_, 2);
	_tmp114_ = _tmp113_;
	_tmp115_ = valadoc_rule_set_name (_tmp114_, "InlineTaglet");
	_tmp116_ = _tmp115_;
	_g_object_unref0 (_tmp114_);
	_tmp112_ = (_vala_array_free (_tmp112_, _tmp112__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp109_);
	_tmp107_ = (_vala_array_free (_tmp107_, _tmp107__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp102_);
	inline_taglet = _tmp116_;
	_tmp117_ = valadoc_token_type_SINGLE_QUOTE_2;
	_tmp118_ = _g_object_ref0 ((GObject*) _tmp117_);
	_tmp119_ = valadoc_token_type_SINGLE_QUOTE_2;
	_tmp120_ = _g_object_ref0 ((GObject*) _tmp119_);
	_tmp121_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp122_ = _g_object_ref0 ((GObject*) run);
	_tmp123_ = valadoc_token_type_SINGLE_QUOTE_2;
	_tmp124_ = _g_object_ref0 ((GObject*) _tmp123_);
	_tmp125_ = g_new0 (GObject*, 3 + 1);
	_tmp125_[0] = _tmp121_;
	_tmp125_[1] = _tmp122_;
	_tmp125_[2] = _tmp124_;
	_tmp126_ = _tmp125_;
	_tmp126__length1 = 3;
	_tmp127_ = valadoc_rule_seq (_tmp126_, 3);
	_tmp128_ = g_new0 (GObject*, 2 + 1);
	_tmp128_[0] = _tmp120_;
	_tmp128_[1] = (GObject*) _tmp127_;
	_tmp129_ = _tmp128_;
	_tmp129__length1 = 2;
	_tmp130_ = valadoc_rule_one_of (_tmp129_, 2);
	_tmp131_ = g_new0 (GObject*, 2 + 1);
	_tmp131_[0] = _tmp118_;
	_tmp131_[1] = (GObject*) _tmp130_;
	_tmp132_ = _tmp131_;
	_tmp132__length1 = 2;
	_tmp133_ = valadoc_rule_seq (_tmp132_, 2);
	_tmp134_ = _tmp133_;
	_tmp135_ = valadoc_rule_set_name (_tmp134_, "Bold");
	_tmp136_ = _tmp135_;
	_tmp137_ = valadoc_rule_set_start (_tmp136_, ___lambda60__valadoc_rule_action, self);
	_tmp138_ = _tmp137_;
	_g_object_unref0 (_tmp136_);
	_g_object_unref0 (_tmp134_);
	_tmp132_ = (_vala_array_free (_tmp132_, _tmp132__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp129_ = (_vala_array_free (_tmp129_, _tmp129__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp126_ = (_vala_array_free (_tmp126_, _tmp126__length1, (GDestroyNotify) g_object_unref), NULL);
	bold = _tmp138_;
	_tmp139_ = valadoc_token_type_SLASH_2;
	_tmp140_ = _g_object_ref0 ((GObject*) _tmp139_);
	_tmp141_ = valadoc_token_type_SLASH_2;
	_tmp142_ = _g_object_ref0 ((GObject*) _tmp141_);
	_tmp143_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp144_ = _g_object_ref0 ((GObject*) run);
	_tmp145_ = valadoc_token_type_SLASH_2;
	_tmp146_ = _g_object_ref0 ((GObject*) _tmp145_);
	_tmp147_ = g_new0 (GObject*, 3 + 1);
	_tmp147_[0] = _tmp143_;
	_tmp147_[1] = _tmp144_;
	_tmp147_[2] = _tmp146_;
	_tmp148_ = _tmp147_;
	_tmp148__length1 = 3;
	_tmp149_ = valadoc_rule_seq (_tmp148_, 3);
	_tmp150_ = g_new0 (GObject*, 2 + 1);
	_tmp150_[0] = _tmp142_;
	_tmp150_[1] = (GObject*) _tmp149_;
	_tmp151_ = _tmp150_;
	_tmp151__length1 = 2;
	_tmp152_ = valadoc_rule_one_of (_tmp151_, 2);
	_tmp153_ = g_new0 (GObject*, 2 + 1);
	_tmp153_[0] = _tmp140_;
	_tmp153_[1] = (GObject*) _tmp152_;
	_tmp154_ = _tmp153_;
	_tmp154__length1 = 2;
	_tmp155_ = valadoc_rule_seq (_tmp154_, 2);
	_tmp156_ = _tmp155_;
	_tmp157_ = valadoc_rule_set_name (_tmp156_, "Italic");
	_tmp158_ = _tmp157_;
	_tmp159_ = valadoc_rule_set_start (_tmp158_, ___lambda61__valadoc_rule_action, self);
	_tmp160_ = _tmp159_;
	_g_object_unref0 (_tmp158_);
	_g_object_unref0 (_tmp156_);
	_tmp154_ = (_vala_array_free (_tmp154_, _tmp154__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp151_ = (_vala_array_free (_tmp151_, _tmp151__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp148_ = (_vala_array_free (_tmp148_, _tmp148__length1, (GDestroyNotify) g_object_unref), NULL);
	italic = _tmp160_;
	_tmp161_ = valadoc_token_type_UNDERSCORE_2;
	_tmp162_ = _g_object_ref0 ((GObject*) _tmp161_);
	_tmp163_ = valadoc_token_type_UNDERSCORE_2;
	_tmp164_ = _g_object_ref0 ((GObject*) _tmp163_);
	_tmp165_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp166_ = _g_object_ref0 ((GObject*) run);
	_tmp167_ = valadoc_token_type_UNDERSCORE_2;
	_tmp168_ = _g_object_ref0 ((GObject*) _tmp167_);
	_tmp169_ = g_new0 (GObject*, 3 + 1);
	_tmp169_[0] = _tmp165_;
	_tmp169_[1] = _tmp166_;
	_tmp169_[2] = _tmp168_;
	_tmp170_ = _tmp169_;
	_tmp170__length1 = 3;
	_tmp171_ = valadoc_rule_seq (_tmp170_, 3);
	_tmp172_ = g_new0 (GObject*, 2 + 1);
	_tmp172_[0] = _tmp164_;
	_tmp172_[1] = (GObject*) _tmp171_;
	_tmp173_ = _tmp172_;
	_tmp173__length1 = 2;
	_tmp174_ = valadoc_rule_one_of (_tmp173_, 2);
	_tmp175_ = g_new0 (GObject*, 2 + 1);
	_tmp175_[0] = _tmp162_;
	_tmp175_[1] = (GObject*) _tmp174_;
	_tmp176_ = _tmp175_;
	_tmp176__length1 = 2;
	_tmp177_ = valadoc_rule_seq (_tmp176_, 2);
	_tmp178_ = _tmp177_;
	_tmp179_ = valadoc_rule_set_name (_tmp178_, "Underlined");
	_tmp180_ = _tmp179_;
	_tmp181_ = valadoc_rule_set_start (_tmp180_, ___lambda62__valadoc_rule_action, self);
	_tmp182_ = _tmp181_;
	_g_object_unref0 (_tmp180_);
	_g_object_unref0 (_tmp178_);
	_tmp176_ = (_vala_array_free (_tmp176_, _tmp176__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp173_ = (_vala_array_free (_tmp173_, _tmp173__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp170_ = (_vala_array_free (_tmp170_, _tmp170__length1, (GDestroyNotify) g_object_unref), NULL);
	underlined = _tmp182_;
	_tmp183_ = valadoc_token_type_BACK_QUOTE_2;
	_tmp184_ = _g_object_ref0 ((GObject*) _tmp183_);
	_tmp185_ = valadoc_token_type_BACK_QUOTE_2;
	_tmp186_ = _g_object_ref0 ((GObject*) _tmp185_);
	_tmp187_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp188_ = _g_object_ref0 ((GObject*) run);
	_tmp189_ = valadoc_token_type_BACK_QUOTE_2;
	_tmp190_ = _g_object_ref0 ((GObject*) _tmp189_);
	_tmp191_ = g_new0 (GObject*, 3 + 1);
	_tmp191_[0] = _tmp187_;
	_tmp191_[1] = _tmp188_;
	_tmp191_[2] = _tmp190_;
	_tmp192_ = _tmp191_;
	_tmp192__length1 = 3;
	_tmp193_ = valadoc_rule_seq (_tmp192_, 3);
	_tmp194_ = g_new0 (GObject*, 2 + 1);
	_tmp194_[0] = _tmp186_;
	_tmp194_[1] = (GObject*) _tmp193_;
	_tmp195_ = _tmp194_;
	_tmp195__length1 = 2;
	_tmp196_ = valadoc_rule_one_of (_tmp195_, 2);
	_tmp197_ = g_new0 (GObject*, 2 + 1);
	_tmp197_[0] = _tmp184_;
	_tmp197_[1] = (GObject*) _tmp196_;
	_tmp198_ = _tmp197_;
	_tmp198__length1 = 2;
	_tmp199_ = valadoc_rule_seq (_tmp198_, 2);
	_tmp200_ = _tmp199_;
	_tmp201_ = valadoc_rule_set_name (_tmp200_, "Monospace");
	_tmp202_ = _tmp201_;
	_tmp203_ = valadoc_rule_set_start (_tmp202_, ___lambda63__valadoc_rule_action, self);
	_tmp204_ = _tmp203_;
	_g_object_unref0 (_tmp202_);
	_g_object_unref0 (_tmp200_);
	_tmp198_ = (_vala_array_free (_tmp198_, _tmp198__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp195_ = (_vala_array_free (_tmp195_, _tmp195__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp192_ = (_vala_array_free (_tmp192_, _tmp192__length1, (GDestroyNotify) g_object_unref), NULL);
	monospace = _tmp204_;
	_tmp205_ = valadoc_token_type_DOUBLE_OPEN_BRACE;
	_tmp206_ = valadoc_token_type_action (_tmp205_, ___lambda64__valadoc_token_type_action, self);
	_tmp207_ = valadoc_token_type_any_word ();
	_tmp208_ = _tmp207_;
	_tmp209_ = valadoc_token_type_action (_tmp208_, ___lambda65__valadoc_token_type_action, self);
	_tmp210_ = valadoc_token_type_PIPE;
	_tmp211_ = valadoc_token_type_action (_tmp210_, ___lambda66__valadoc_token_type_action, self);
	_tmp212_ = _g_object_ref0 ((GObject*) text);
	_tmp213_ = g_new0 (GObject*, 2 + 1);
	_tmp213_[0] = (GObject*) _tmp211_;
	_tmp213_[1] = _tmp212_;
	_tmp214_ = _tmp213_;
	_tmp214__length1 = 2;
	_tmp215_ = valadoc_rule_option (_tmp214_, 2);
	_tmp216_ = _tmp215_;
	_tmp217_ = valadoc_rule_set_reduce (_tmp216_, ___lambda67__valadoc_rule_action, self);
	_tmp218_ = valadoc_token_type_DOUBLE_CLOSED_BRACE;
	_tmp219_ = valadoc_token_type_action (_tmp218_, ___lambda68__valadoc_token_type_action, self);
	_tmp220_ = g_new0 (GObject*, 4 + 1);
	_tmp220_[0] = (GObject*) _tmp206_;
	_tmp220_[1] = (GObject*) _tmp209_;
	_tmp220_[2] = (GObject*) _tmp217_;
	_tmp220_[3] = (GObject*) _tmp219_;
	_tmp221_ = _tmp220_;
	_tmp221__length1 = 4;
	_tmp222_ = valadoc_rule_seq (_tmp221_, 4);
	_tmp223_ = _tmp222_;
	_tmp224_ = valadoc_rule_set_name (_tmp223_, "Embedded");
	_tmp225_ = _tmp224_;
	_tmp226_ = valadoc_rule_set_start (_tmp225_, ___lambda69__valadoc_rule_action, self);
	_tmp227_ = _tmp226_;
	_g_object_unref0 (_tmp225_);
	_g_object_unref0 (_tmp223_);
	_tmp221_ = (_vala_array_free (_tmp221_, _tmp221__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp216_);
	_tmp214_ = (_vala_array_free (_tmp214_, _tmp214__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp208_);
	embedded = _tmp227_;
	_tmp228_ = valadoc_token_type_DOUBLE_OPEN_BRACKET;
	_tmp229_ = valadoc_token_type_action (_tmp228_, ___lambda70__valadoc_token_type_action, self);
	_tmp230_ = valadoc_token_type_any_word ();
	_tmp231_ = _tmp230_;
	_tmp232_ = valadoc_token_type_action (_tmp231_, ___lambda71__valadoc_token_type_action, self);
	_tmp233_ = valadoc_token_type_PIPE;
	_tmp234_ = valadoc_token_type_action (_tmp233_, ___lambda72__valadoc_token_type_action, self);
	_tmp235_ = _g_object_ref0 ((GObject*) run);
	_tmp236_ = g_new0 (GObject*, 2 + 1);
	_tmp236_[0] = (GObject*) _tmp234_;
	_tmp236_[1] = _tmp235_;
	_tmp237_ = _tmp236_;
	_tmp237__length1 = 2;
	_tmp238_ = valadoc_rule_option (_tmp237_, 2);
	_tmp239_ = valadoc_token_type_DOUBLE_CLOSED_BRACKET;
	_tmp240_ = valadoc_token_type_action (_tmp239_, ___lambda73__valadoc_token_type_action, self);
	_tmp241_ = g_new0 (GObject*, 4 + 1);
	_tmp241_[0] = (GObject*) _tmp229_;
	_tmp241_[1] = (GObject*) _tmp232_;
	_tmp241_[2] = (GObject*) _tmp238_;
	_tmp241_[3] = (GObject*) _tmp240_;
	_tmp242_ = _tmp241_;
	_tmp242__length1 = 4;
	_tmp243_ = valadoc_rule_seq (_tmp242_, 4);
	_tmp244_ = _tmp243_;
	_tmp245_ = valadoc_rule_set_name (_tmp244_, "Link");
	_tmp246_ = _tmp245_;
	_g_object_unref0 (_tmp244_);
	_tmp242_ = (_vala_array_free (_tmp242_, _tmp242__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp237_ = (_vala_array_free (_tmp237_, _tmp237__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp231_);
	link = _tmp246_;
	_tmp247_ = valadoc_token_type_TRIPLE_OPEN_BRACE;
	_tmp248_ = valadoc_token_type_action (_tmp247_, ___lambda74__valadoc_token_type_action, self);
	_tmp249_ = valadoc_token_type_any_word ();
	_tmp250_ = _tmp249_;
	_tmp251_ = valadoc_token_type_action (_tmp250_, ___lambda75__valadoc_token_type_action, self);
	_tmp252_ = valadoc_token_type_TRIPLE_CLOSED_BRACE;
	_tmp253_ = valadoc_token_type_action (_tmp252_, ___lambda76__valadoc_token_type_action, self);
	_tmp254_ = g_new0 (GObject*, 3 + 1);
	_tmp254_[0] = (GObject*) _tmp248_;
	_tmp254_[1] = (GObject*) _tmp251_;
	_tmp254_[2] = (GObject*) _tmp253_;
	_tmp255_ = _tmp254_;
	_tmp255__length1 = 3;
	_tmp256_ = valadoc_rule_seq (_tmp255_, 3);
	_tmp257_ = _tmp256_;
	_tmp258_ = valadoc_rule_set_name (_tmp257_, "SourceCode");
	_tmp259_ = _tmp258_;
	_tmp260_ = valadoc_rule_set_start (_tmp259_, ___lambda77__valadoc_rule_action, self);
	_tmp261_ = _tmp260_;
	_g_object_unref0 (_tmp259_);
	_g_object_unref0 (_tmp257_);
	_tmp255_ = (_vala_array_free (_tmp255_, _tmp255__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp250_);
	source_code = _tmp261_;
	append_head_to_head2 = ___lambda78__valadoc_rule_action;
	append_head_to_head2_target = g_object_ref (self);
	append_head_to_head2_target_destroy_notify = g_object_unref;
	_tmp262_ = _g_object_ref0 ((GObject*) text);
	_tmp263_ = g_new0 (GObject*, 1 + 1);
	_tmp263_[0] = _tmp262_;
	_tmp264_ = _tmp263_;
	_tmp264__length1 = 1;
	_tmp265_ = valadoc_rule_seq (_tmp264_, 1);
	_tmp266_ = _tmp265_;
	_tmp267_ = valadoc_rule_set_reduce (_tmp266_, append_head_to_head2, append_head_to_head2_target);
	_tmp268_ = _g_object_ref0 ((GObject*) inline_taglet);
	_tmp269_ = _g_object_ref0 ((GObject*) bold);
	_tmp270_ = _g_object_ref0 ((GObject*) italic);
	_tmp271_ = _g_object_ref0 ((GObject*) underlined);
	_tmp272_ = _g_object_ref0 ((GObject*) monospace);
	_tmp273_ = _g_object_ref0 ((GObject*) embedded);
	_tmp274_ = _g_object_ref0 ((GObject*) link);
	_tmp275_ = _g_object_ref0 ((GObject*) source_code);
	_tmp276_ = g_new0 (GObject*, 8 + 1);
	_tmp276_[0] = _tmp268_;
	_tmp276_[1] = _tmp269_;
	_tmp276_[2] = _tmp270_;
	_tmp276_[3] = _tmp271_;
	_tmp276_[4] = _tmp272_;
	_tmp276_[5] = _tmp273_;
	_tmp276_[6] = _tmp274_;
	_tmp276_[7] = _tmp275_;
	_tmp277_ = _tmp276_;
	_tmp277__length1 = 8;
	_tmp278_ = valadoc_rule_one_of (_tmp277_, 8);
	_tmp279_ = _tmp278_;
	_tmp280_ = valadoc_rule_set_reduce (_tmp279_, append_head_to_head2, append_head_to_head2_target);
	_tmp281_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp282_ = g_new0 (GObject*, 2 + 1);
	_tmp282_[0] = (GObject*) _tmp280_;
	_tmp282_[1] = _tmp281_;
	_tmp283_ = _tmp282_;
	_tmp283__length1 = 2;
	_tmp284_ = valadoc_rule_seq (_tmp283_, 2);
	_tmp285_ = g_new0 (GObject*, 2 + 1);
	_tmp285_[0] = (GObject*) _tmp267_;
	_tmp285_[1] = (GObject*) _tmp284_;
	_tmp286_ = _tmp285_;
	_tmp286__length1 = 2;
	_tmp287_ = valadoc_rule_one_of (_tmp286_, 2);
	_tmp288_ = _tmp287_;
	_tmp286_ = (_vala_array_free (_tmp286_, _tmp286__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp283_ = (_vala_array_free (_tmp283_, _tmp283__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp279_);
	_tmp277_ = (_vala_array_free (_tmp277_, _tmp277__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp266_);
	_tmp264_ = (_vala_array_free (_tmp264_, _tmp264__length1, (GDestroyNotify) g_object_unref), NULL);
	run_subrules = _tmp288_;
	_tmp289_ = valadoc_token_type_AROBASE;
	_tmp290_ = valadoc_token_type_action (_tmp289_, _valadoc_documentation_parser_add_text_valadoc_token_type_action, self);
	_tmp291_ = g_new0 (GObject*, 1 + 1);
	_tmp291_[0] = (GObject*) _tmp290_;
	_tmp292_ = _tmp291_;
	_tmp292__length1 = 1;
	_tmp293_ = valadoc_rule_seq (_tmp292_, 1);
	_tmp294_ = _tmp293_;
	_tmp295_ = valadoc_rule_set_reduce (_tmp294_, append_head_to_head2, append_head_to_head2_target);
	_tmp296_ = _tmp295_;
	_g_object_unref0 (_tmp294_);
	_tmp292_ = (_vala_array_free (_tmp292_, _tmp292__length1, (GDestroyNotify) g_object_unref), NULL);
	run_arobase = _tmp296_;
	_tmp297_ = _g_object_ref0 ((GObject*) run_subrules);
	_tmp298_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp299_ = _g_object_ref0 ((GObject*) run_arobase);
	_tmp300_ = _g_object_ref0 ((GObject*) run_subrules);
	_tmp301_ = _g_object_ref0 ((GObject*) optional_spaces);
	_tmp302_ = g_new0 (GObject*, 3 + 1);
	_tmp302_[0] = _tmp299_;
	_tmp302_[1] = _tmp300_;
	_tmp302_[2] = _tmp301_;
	_tmp303_ = _tmp302_;
	_tmp303__length1 = 3;
	_tmp304_ = valadoc_rule_one_of (_tmp303_, 3);
	_tmp305_ = g_new0 (GObject*, 1 + 1);
	_tmp305_[0] = (GObject*) _tmp304_;
	_tmp306_ = _tmp305_;
	_tmp306__length1 = 1;
	_tmp307_ = valadoc_rule_many (_tmp306_, 1);
	_tmp308_ = g_new0 (GObject*, 1 + 1);
	_tmp308_[0] = (GObject*) _tmp307_;
	_tmp309_ = _tmp308_;
	_tmp309__length1 = 1;
	_tmp310_ = valadoc_rule_option (_tmp309_, 1);
	_tmp311_ = g_new0 (GObject*, 3 + 1);
	_tmp311_[0] = _tmp297_;
	_tmp311_[1] = _tmp298_;
	_tmp311_[2] = (GObject*) _tmp310_;
	_tmp312_ = _tmp311_;
	_tmp312__length1 = 3;
	_tmp313_ = valadoc_rule_seq (_tmp312_, 3);
	_tmp314_ = _tmp313_;
	_tmp315_ = valadoc_rule_set_name (_tmp314_, "Run");
	_tmp316_ = _tmp315_;
	_tmp317_ = valadoc_stub_rule_set_rule (run, _tmp316_);
	_tmp318_ = _tmp317_;
	_g_object_unref0 (_tmp318_);
	_g_object_unref0 (_tmp316_);
	_g_object_unref0 (_tmp314_);
	_tmp312_ = (_vala_array_free (_tmp312_, _tmp312__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp309_ = (_vala_array_free (_tmp309_, _tmp309__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp306_ = (_vala_array_free (_tmp306_, _tmp306__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp303_ = (_vala_array_free (_tmp303_, _tmp303__length1, (GDestroyNotify) g_object_unref), NULL);
	reduce_paragraph = ___lambda79__valadoc_rule_action;
	reduce_paragraph_target = g_object_ref (self);
	reduce_paragraph_target_destroy_notify = g_object_unref;
	_tmp319_ = valadoc_token_type_ALIGN_CENTER;
	_tmp320_ = valadoc_token_type_action (_tmp319_, ___lambda80__valadoc_token_type_action, self);
	_tmp321_ = valadoc_token_type_ALIGN_RIGHT;
	_tmp322_ = valadoc_token_type_action (_tmp321_, ___lambda81__valadoc_token_type_action, self);
	_tmp323_ = g_new0 (GObject*, 2 + 1);
	_tmp323_[0] = (GObject*) _tmp320_;
	_tmp323_[1] = (GObject*) _tmp322_;
	_tmp324_ = _tmp323_;
	_tmp324__length1 = 2;
	_tmp325_ = valadoc_rule_one_of (_tmp324_, 2);
	_tmp326_ = g_new0 (GObject*, 1 + 1);
	_tmp326_[0] = (GObject*) _tmp325_;
	_tmp327_ = _tmp326_;
	_tmp327__length1 = 1;
	_tmp328_ = valadoc_rule_option (_tmp327_, 1);
	_tmp329_ = _g_object_ref0 ((GObject*) run);
	_tmp330_ = valadoc_token_type_EOL;
	_tmp331_ = valadoc_token_type_action (_tmp330_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	_tmp332_ = g_new0 (GObject*, 2 + 1);
	_tmp332_[0] = _tmp329_;
	_tmp332_[1] = (GObject*) _tmp331_;
	_tmp333_ = _tmp332_;
	_tmp333__length1 = 2;
	_tmp334_ = valadoc_rule_many (_tmp333_, 2);
	_tmp335_ = g_new0 (GObject*, 2 + 1);
	_tmp335_[0] = (GObject*) _tmp328_;
	_tmp335_[1] = (GObject*) _tmp334_;
	_tmp336_ = _tmp335_;
	_tmp336__length1 = 2;
	_tmp337_ = valadoc_rule_seq (_tmp336_, 2);
	_tmp338_ = _tmp337_;
	_tmp339_ = valadoc_rule_set_name (_tmp338_, "Paragraph");
	_tmp340_ = _tmp339_;
	_tmp341_ = valadoc_rule_set_start (_tmp340_, ___lambda82__valadoc_rule_action, self);
	_tmp342_ = _tmp341_;
	_tmp343_ = valadoc_rule_set_reduce (_tmp342_, reduce_paragraph, reduce_paragraph_target);
	_tmp344_ = _tmp343_;
	_g_object_unref0 (_tmp342_);
	_g_object_unref0 (_tmp340_);
	_g_object_unref0 (_tmp338_);
	_tmp336_ = (_vala_array_free (_tmp336_, _tmp336__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp333_ = (_vala_array_free (_tmp333_, _tmp333__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp327_ = (_vala_array_free (_tmp327_, _tmp327__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp324_ = (_vala_array_free (_tmp324_, _tmp324__length1, (GDestroyNotify) g_object_unref), NULL);
	paragraph = _tmp344_;
	_tmp345_ = valadoc_token_type_str ("Warning:");
	_tmp346_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp347_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp348_ = _g_object_ref0 ((GObject*) run);
	_tmp349_ = g_new0 (GObject*, 2 + 1);
	_tmp349_[0] = _tmp347_;
	_tmp349_[1] = _tmp348_;
	_tmp350_ = _tmp349_;
	_tmp350__length1 = 2;
	_tmp351_ = valadoc_rule_seq (_tmp350_, 2);
	_tmp352_ = valadoc_token_type_EOL;
	_tmp353_ = valadoc_token_type_action (_tmp352_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	_tmp354_ = g_new0 (GObject*, 2 + 1);
	_tmp354_[0] = (GObject*) _tmp351_;
	_tmp354_[1] = (GObject*) _tmp353_;
	_tmp355_ = _tmp354_;
	_tmp355__length1 = 2;
	_tmp356_ = valadoc_rule_many (_tmp355_, 2);
	_tmp357_ = g_new0 (GObject*, 3 + 1);
	_tmp357_[0] = (GObject*) _tmp345_;
	_tmp357_[1] = _tmp346_;
	_tmp357_[2] = (GObject*) _tmp356_;
	_tmp358_ = _tmp357_;
	_tmp358__length1 = 3;
	_tmp359_ = valadoc_rule_seq (_tmp358_, 3);
	_tmp360_ = _tmp359_;
	_tmp361_ = valadoc_rule_set_name (_tmp360_, "Warning");
	_tmp362_ = _tmp361_;
	_tmp363_ = valadoc_rule_set_start (_tmp362_, ___lambda83__valadoc_rule_action, self);
	_tmp364_ = _tmp363_;
	_tmp365_ = valadoc_rule_set_reduce (_tmp364_, ___lambda84__valadoc_rule_action, self);
	_tmp366_ = _tmp365_;
	_g_object_unref0 (_tmp364_);
	_g_object_unref0 (_tmp362_);
	_g_object_unref0 (_tmp360_);
	_tmp358_ = (_vala_array_free (_tmp358_, _tmp358__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp355_ = (_vala_array_free (_tmp355_, _tmp355__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp350_ = (_vala_array_free (_tmp350_, _tmp350__length1, (GDestroyNotify) g_object_unref), NULL);
	warning = _tmp366_;
	_tmp367_ = valadoc_token_type_str ("Note:");
	_tmp368_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp369_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp370_ = _g_object_ref0 ((GObject*) run);
	_tmp371_ = g_new0 (GObject*, 2 + 1);
	_tmp371_[0] = _tmp369_;
	_tmp371_[1] = _tmp370_;
	_tmp372_ = _tmp371_;
	_tmp372__length1 = 2;
	_tmp373_ = valadoc_rule_seq (_tmp372_, 2);
	_tmp374_ = valadoc_token_type_EOL;
	_tmp375_ = valadoc_token_type_action (_tmp374_, _valadoc_documentation_parser_add_content_space_valadoc_token_type_action, self);
	_tmp376_ = g_new0 (GObject*, 2 + 1);
	_tmp376_[0] = (GObject*) _tmp373_;
	_tmp376_[1] = (GObject*) _tmp375_;
	_tmp377_ = _tmp376_;
	_tmp377__length1 = 2;
	_tmp378_ = valadoc_rule_many (_tmp377_, 2);
	_tmp379_ = g_new0 (GObject*, 3 + 1);
	_tmp379_[0] = (GObject*) _tmp367_;
	_tmp379_[1] = _tmp368_;
	_tmp379_[2] = (GObject*) _tmp378_;
	_tmp380_ = _tmp379_;
	_tmp380__length1 = 3;
	_tmp381_ = valadoc_rule_seq (_tmp380_, 3);
	_tmp382_ = _tmp381_;
	_tmp383_ = valadoc_rule_set_name (_tmp382_, "Note");
	_tmp384_ = _tmp383_;
	_tmp385_ = valadoc_rule_set_start (_tmp384_, ___lambda85__valadoc_rule_action, self);
	_tmp386_ = _tmp385_;
	_tmp387_ = valadoc_rule_set_reduce (_tmp386_, ___lambda86__valadoc_rule_action, self);
	_tmp388_ = _tmp387_;
	_g_object_unref0 (_tmp386_);
	_g_object_unref0 (_tmp384_);
	_g_object_unref0 (_tmp382_);
	_tmp380_ = (_vala_array_free (_tmp380_, _tmp380__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp377_ = (_vala_array_free (_tmp377_, _tmp377__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp372_ = (_vala_array_free (_tmp372_, _tmp372__length1, (GDestroyNotify) g_object_unref), NULL);
	note = _tmp388_;
	_tmp389_ = valadoc_token_type_SPACE;
	_tmp390_ = valadoc_token_type_action (_tmp389_, ___lambda87__valadoc_token_type_action, self);
	_tmp391_ = g_new0 (GObject*, 1 + 1);
	_tmp391_[0] = (GObject*) _tmp390_;
	_tmp392_ = _tmp391_;
	_tmp392__length1 = 1;
	_tmp393_ = valadoc_rule_many (_tmp392_, 1);
	_tmp394_ = valadoc_token_type_str (".");
	_tmp395_ = _tmp394_;
	_tmp396_ = valadoc_token_type_action (_tmp395_, ___lambda88__valadoc_token_type_action, self);
	_tmp397_ = valadoc_token_type_str ("*");
	_tmp398_ = _tmp397_;
	_tmp399_ = valadoc_token_type_action (_tmp398_, ___lambda89__valadoc_token_type_action, self);
	_tmp400_ = valadoc_token_type_str ("#");
	_tmp401_ = _tmp400_;
	_tmp402_ = valadoc_token_type_action (_tmp401_, ___lambda90__valadoc_token_type_action, self);
	_tmp403_ = valadoc_token_type_str ("1.");
	_tmp404_ = _tmp403_;
	_tmp405_ = valadoc_token_type_action (_tmp404_, ___lambda91__valadoc_token_type_action, self);
	_tmp406_ = valadoc_token_type_str ("a.");
	_tmp407_ = _tmp406_;
	_tmp408_ = valadoc_token_type_action (_tmp407_, ___lambda92__valadoc_token_type_action, self);
	_tmp409_ = valadoc_token_type_str ("A.");
	_tmp410_ = _tmp409_;
	_tmp411_ = valadoc_token_type_action (_tmp410_, ___lambda93__valadoc_token_type_action, self);
	_tmp412_ = valadoc_token_type_str ("i.");
	_tmp413_ = _tmp412_;
	_tmp414_ = valadoc_token_type_action (_tmp413_, ___lambda94__valadoc_token_type_action, self);
	_tmp415_ = valadoc_token_type_str ("I.");
	_tmp416_ = _tmp415_;
	_tmp417_ = valadoc_token_type_action (_tmp416_, ___lambda95__valadoc_token_type_action, self);
	_tmp418_ = g_new0 (GObject*, 8 + 1);
	_tmp418_[0] = (GObject*) _tmp396_;
	_tmp418_[1] = (GObject*) _tmp399_;
	_tmp418_[2] = (GObject*) _tmp402_;
	_tmp418_[3] = (GObject*) _tmp405_;
	_tmp418_[4] = (GObject*) _tmp408_;
	_tmp418_[5] = (GObject*) _tmp411_;
	_tmp418_[6] = (GObject*) _tmp414_;
	_tmp418_[7] = (GObject*) _tmp417_;
	_tmp419_ = _tmp418_;
	_tmp419__length1 = 8;
	_tmp420_ = valadoc_rule_one_of (_tmp419_, 8);
	_tmp421_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp422_ = g_new0 (GObject*, 2 + 1);
	_tmp422_[0] = (GObject*) _tmp420_;
	_tmp422_[1] = _tmp421_;
	_tmp423_ = _tmp422_;
	_tmp423__length1 = 2;
	_tmp424_ = valadoc_rule_option (_tmp423_, 2);
	_tmp425_ = _tmp424_;
	_tmp426_ = valadoc_rule_set_skip (_tmp425_, ___lambda96__valadoc_rule_action, self);
	_tmp427_ = _g_object_ref0 ((GObject*) run);
	_tmp428_ = g_new0 (GObject*, 1 + 1);
	_tmp428_[0] = _tmp427_;
	_tmp429_ = _tmp428_;
	_tmp429__length1 = 1;
	_tmp430_ = valadoc_rule_seq (_tmp429_, 1);
	_tmp431_ = _tmp430_;
	_tmp432_ = valadoc_rule_set_start (_tmp431_, ___lambda97__valadoc_rule_action, self);
	_tmp433_ = _tmp432_;
	_tmp434_ = valadoc_rule_set_reduce (_tmp433_, ___lambda98__valadoc_rule_action, self);
	_tmp435_ = valadoc_token_type_EOL;
	_tmp436_ = _g_object_ref0 ((GObject*) _tmp435_);
	_tmp437_ = g_new0 (GObject*, 4 + 1);
	_tmp437_[0] = (GObject*) _tmp393_;
	_tmp437_[1] = (GObject*) _tmp426_;
	_tmp437_[2] = (GObject*) _tmp434_;
	_tmp437_[3] = _tmp436_;
	_tmp438_ = _tmp437_;
	_tmp438__length1 = 4;
	_tmp439_ = valadoc_rule_seq (_tmp438_, 4);
	_tmp440_ = _tmp439_;
	_tmp441_ = valadoc_rule_set_name (_tmp440_, "IndentedItem");
	_tmp442_ = _tmp441_;
	_tmp443_ = valadoc_rule_set_start (_tmp442_, ___lambda99__valadoc_rule_action, self);
	_tmp444_ = _tmp443_;
	_tmp445_ = valadoc_rule_set_reduce (_tmp444_, ___lambda100__valadoc_rule_action, self);
	_tmp446_ = _tmp445_;
	_g_object_unref0 (_tmp444_);
	_g_object_unref0 (_tmp442_);
	_g_object_unref0 (_tmp440_);
	_tmp438_ = (_vala_array_free (_tmp438_, _tmp438__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp433_);
	_g_object_unref0 (_tmp431_);
	_tmp429_ = (_vala_array_free (_tmp429_, _tmp429__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp425_);
	_tmp423_ = (_vala_array_free (_tmp423_, _tmp423__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp419_ = (_vala_array_free (_tmp419_, _tmp419__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp416_);
	_g_object_unref0 (_tmp413_);
	_g_object_unref0 (_tmp410_);
	_g_object_unref0 (_tmp407_);
	_g_object_unref0 (_tmp404_);
	_g_object_unref0 (_tmp401_);
	_g_object_unref0 (_tmp398_);
	_g_object_unref0 (_tmp395_);
	_tmp392_ = (_vala_array_free (_tmp392_, _tmp392__length1, (GDestroyNotify) g_object_unref), NULL);
	indented_item = _tmp446_;
	_tmp447_ = _g_object_ref0 ((GObject*) indented_item);
	_tmp448_ = g_new0 (GObject*, 1 + 1);
	_tmp448_[0] = _tmp447_;
	_tmp449_ = _tmp448_;
	_tmp449__length1 = 1;
	_tmp450_ = valadoc_rule_many (_tmp449_, 1);
	_tmp451_ = _tmp450_;
	_tmp452_ = valadoc_rule_set_name (_tmp451_, "IndentedBlocks");
	_tmp453_ = _tmp452_;
	_tmp454_ = valadoc_rule_set_reduce (_tmp453_, ___lambda101__valadoc_rule_action, self);
	_tmp455_ = _tmp454_;
	_g_object_unref0 (_tmp453_);
	_g_object_unref0 (_tmp451_);
	_tmp449_ = (_vala_array_free (_tmp449_, _tmp449__length1, (GDestroyNotify) g_object_unref), NULL);
	indented_blocks = _tmp455_;
	_tmp456_ = valadoc_token_type_LESS_THAN;
	_tmp457_ = _g_object_ref0 ((GObject*) _tmp456_);
	_tmp458_ = valadoc_token_type_ALIGN_RIGHT;
	_tmp459_ = valadoc_token_type_action (_tmp458_, ___lambda102__valadoc_token_type_action, self);
	_tmp460_ = valadoc_token_type_ALIGN_CENTER;
	_tmp461_ = valadoc_token_type_action (_tmp460_, ___lambda103__valadoc_token_type_action, self);
	_tmp462_ = g_new0 (GObject*, 2 + 1);
	_tmp462_[0] = (GObject*) _tmp459_;
	_tmp462_[1] = (GObject*) _tmp461_;
	_tmp463_ = _tmp462_;
	_tmp463__length1 = 2;
	_tmp464_ = valadoc_rule_one_of (_tmp463_, 2);
	_tmp465_ = g_new0 (GObject*, 1 + 1);
	_tmp465_[0] = (GObject*) _tmp464_;
	_tmp466_ = _tmp465_;
	_tmp466__length1 = 1;
	_tmp467_ = valadoc_rule_option (_tmp466_, 1);
	_tmp468_ = valadoc_token_type_ALIGN_TOP;
	_tmp469_ = valadoc_token_type_action (_tmp468_, ___lambda104__valadoc_token_type_action, self);
	_tmp470_ = valadoc_token_type_ALIGN_BOTTOM;
	_tmp471_ = valadoc_token_type_action (_tmp470_, ___lambda105__valadoc_token_type_action, self);
	_tmp472_ = g_new0 (GObject*, 2 + 1);
	_tmp472_[0] = (GObject*) _tmp469_;
	_tmp472_[1] = (GObject*) _tmp471_;
	_tmp473_ = _tmp472_;
	_tmp473__length1 = 2;
	_tmp474_ = valadoc_rule_one_of (_tmp473_, 2);
	_tmp475_ = g_new0 (GObject*, 1 + 1);
	_tmp475_[0] = (GObject*) _tmp474_;
	_tmp476_ = _tmp475_;
	_tmp476__length1 = 1;
	_tmp477_ = valadoc_rule_option (_tmp476_, 1);
	_tmp478_ = g_new0 (GObject*, 2 + 1);
	_tmp478_[0] = (GObject*) _tmp467_;
	_tmp478_[1] = (GObject*) _tmp477_;
	_tmp479_ = _tmp478_;
	_tmp479__length1 = 2;
	_tmp480_ = valadoc_rule_seq (_tmp479_, 2);
	_tmp481_ = valadoc_token_type_any_word ();
	_tmp482_ = _tmp481_;
	_tmp483_ = valadoc_token_type_action (_tmp482_, ___lambda106__valadoc_token_type_action, self);
	_tmp484_ = g_new0 (GObject*, 2 + 1);
	_tmp484_[0] = (GObject*) _tmp480_;
	_tmp484_[1] = (GObject*) _tmp483_;
	_tmp485_ = _tmp484_;
	_tmp485__length1 = 2;
	_tmp486_ = valadoc_rule_one_of (_tmp485_, 2);
	_tmp487_ = g_new0 (GObject*, 1 + 1);
	_tmp487_[0] = (GObject*) _tmp486_;
	_tmp488_ = _tmp487_;
	_tmp488__length1 = 1;
	_tmp489_ = valadoc_rule_option (_tmp488_, 1);
	_tmp490_ = valadoc_token_type_PIPE;
	_tmp491_ = _g_object_ref0 ((GObject*) _tmp490_);
	_tmp492_ = valadoc_token_type_any_number ();
	_tmp493_ = _tmp492_;
	_tmp494_ = valadoc_token_type_action (_tmp493_, ___lambda107__valadoc_token_type_action, self);
	_tmp495_ = g_new0 (GObject*, 2 + 1);
	_tmp495_[0] = _tmp491_;
	_tmp495_[1] = (GObject*) _tmp494_;
	_tmp496_ = _tmp495_;
	_tmp496__length1 = 2;
	_tmp497_ = valadoc_rule_seq (_tmp496_, 2);
	_tmp498_ = valadoc_token_type_MINUS;
	_tmp499_ = _g_object_ref0 ((GObject*) _tmp498_);
	_tmp500_ = valadoc_token_type_any_number ();
	_tmp501_ = _tmp500_;
	_tmp502_ = valadoc_token_type_action (_tmp501_, ___lambda108__valadoc_token_type_action, self);
	_tmp503_ = g_new0 (GObject*, 2 + 1);
	_tmp503_[0] = _tmp499_;
	_tmp503_[1] = (GObject*) _tmp502_;
	_tmp504_ = _tmp503_;
	_tmp504__length1 = 2;
	_tmp505_ = valadoc_rule_seq (_tmp504_, 2);
	_tmp506_ = g_new0 (GObject*, 2 + 1);
	_tmp506_[0] = (GObject*) _tmp497_;
	_tmp506_[1] = (GObject*) _tmp505_;
	_tmp507_ = _tmp506_;
	_tmp507__length1 = 2;
	_tmp508_ = valadoc_rule_one_of (_tmp507_, 2);
	_tmp509_ = g_new0 (GObject*, 1 + 1);
	_tmp509_[0] = (GObject*) _tmp508_;
	_tmp510_ = _tmp509_;
	_tmp510__length1 = 1;
	_tmp511_ = valadoc_rule_option (_tmp510_, 1);
	_tmp512_ = valadoc_token_type_GREATER_THAN;
	_tmp513_ = _g_object_ref0 ((GObject*) _tmp512_);
	_tmp514_ = g_new0 (GObject*, 4 + 1);
	_tmp514_[0] = _tmp457_;
	_tmp514_[1] = (GObject*) _tmp489_;
	_tmp514_[2] = (GObject*) _tmp511_;
	_tmp514_[3] = _tmp513_;
	_tmp515_ = _tmp514_;
	_tmp515__length1 = 4;
	_tmp516_ = valadoc_rule_seq (_tmp515_, 4);
	_tmp517_ = _tmp516_;
	_tmp518_ = valadoc_rule_set_name (_tmp517_, "CellAttributes");
	_tmp519_ = _tmp518_;
	_g_object_unref0 (_tmp517_);
	_tmp515_ = (_vala_array_free (_tmp515_, _tmp515__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp510_ = (_vala_array_free (_tmp510_, _tmp510__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp507_ = (_vala_array_free (_tmp507_, _tmp507__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp504_ = (_vala_array_free (_tmp504_, _tmp504__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp501_);
	_tmp496_ = (_vala_array_free (_tmp496_, _tmp496__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp493_);
	_tmp488_ = (_vala_array_free (_tmp488_, _tmp488__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp485_ = (_vala_array_free (_tmp485_, _tmp485__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp482_);
	_tmp479_ = (_vala_array_free (_tmp479_, _tmp479__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp476_ = (_vala_array_free (_tmp476_, _tmp476__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp473_ = (_vala_array_free (_tmp473_, _tmp473__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp466_ = (_vala_array_free (_tmp466_, _tmp466__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp463_ = (_vala_array_free (_tmp463_, _tmp463__length1, (GDestroyNotify) g_object_unref), NULL);
	table_cell_attributes = _tmp519_;
	_tmp520_ = _g_object_ref0 ((GObject*) table_cell_attributes);
	_tmp521_ = g_new0 (GObject*, 1 + 1);
	_tmp521_[0] = _tmp520_;
	_tmp522_ = _tmp521_;
	_tmp522__length1 = 1;
	_tmp523_ = valadoc_rule_option (_tmp522_, 1);
	_tmp524_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp525_ = _g_object_ref0 ((GObject*) run);
	_tmp526_ = g_new0 (GObject*, 3 + 1);
	_tmp526_[0] = (GObject*) _tmp523_;
	_tmp526_[1] = _tmp524_;
	_tmp526_[2] = _tmp525_;
	_tmp527_ = _tmp526_;
	_tmp527__length1 = 3;
	_tmp528_ = valadoc_rule_seq (_tmp527_, 3);
	_tmp529_ = valadoc_token_type_DOUBLE_PIPE;
	_tmp530_ = _g_object_ref0 ((GObject*) _tmp529_);
	_tmp531_ = g_new0 (GObject*, 2 + 1);
	_tmp531_[0] = (GObject*) _tmp528_;
	_tmp531_[1] = _tmp530_;
	_tmp532_ = _tmp531_;
	_tmp532__length1 = 2;
	_tmp533_ = valadoc_rule_seq (_tmp532_, 2);
	_tmp534_ = _tmp533_;
	_tmp535_ = valadoc_rule_set_name (_tmp534_, "Cell");
	_tmp536_ = _tmp535_;
	_tmp537_ = valadoc_rule_set_start (_tmp536_, ___lambda109__valadoc_rule_action, self);
	_tmp538_ = _tmp537_;
	_tmp539_ = valadoc_rule_set_reduce (_tmp538_, ___lambda110__valadoc_rule_action, self);
	_tmp540_ = _tmp539_;
	_g_object_unref0 (_tmp538_);
	_g_object_unref0 (_tmp536_);
	_g_object_unref0 (_tmp534_);
	_tmp532_ = (_vala_array_free (_tmp532_, _tmp532__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp527_ = (_vala_array_free (_tmp527_, _tmp527__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp522_ = (_vala_array_free (_tmp522_, _tmp522__length1, (GDestroyNotify) g_object_unref), NULL);
	table_cell = _tmp540_;
	_tmp541_ = valadoc_token_type_DOUBLE_PIPE;
	_tmp542_ = _g_object_ref0 ((GObject*) _tmp541_);
	_tmp543_ = _g_object_ref0 ((GObject*) table_cell);
	_tmp544_ = g_new0 (GObject*, 1 + 1);
	_tmp544_[0] = _tmp543_;
	_tmp545_ = _tmp544_;
	_tmp545__length1 = 1;
	_tmp546_ = valadoc_rule_many (_tmp545_, 1);
	_tmp547_ = valadoc_token_type_EOL;
	_tmp548_ = _g_object_ref0 ((GObject*) _tmp547_);
	_tmp549_ = g_new0 (GObject*, 3 + 1);
	_tmp549_[0] = _tmp542_;
	_tmp549_[1] = (GObject*) _tmp546_;
	_tmp549_[2] = _tmp548_;
	_tmp550_ = _tmp549_;
	_tmp550__length1 = 3;
	_tmp551_ = valadoc_rule_seq (_tmp550_, 3);
	_tmp552_ = _tmp551_;
	_tmp553_ = valadoc_rule_set_name (_tmp552_, "Row");
	_tmp554_ = _tmp553_;
	_tmp555_ = valadoc_rule_set_start (_tmp554_, ___lambda111__valadoc_rule_action, self);
	_tmp556_ = _tmp555_;
	_tmp557_ = valadoc_rule_set_reduce (_tmp556_, ___lambda112__valadoc_rule_action, self);
	_tmp558_ = _tmp557_;
	_g_object_unref0 (_tmp556_);
	_g_object_unref0 (_tmp554_);
	_g_object_unref0 (_tmp552_);
	_tmp550_ = (_vala_array_free (_tmp550_, _tmp550__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp545_ = (_vala_array_free (_tmp545_, _tmp545__length1, (GDestroyNotify) g_object_unref), NULL);
	table_row = _tmp558_;
	_tmp559_ = _g_object_ref0 ((GObject*) table_row);
	_tmp560_ = g_new0 (GObject*, 1 + 1);
	_tmp560_[0] = _tmp559_;
	_tmp561_ = _tmp560_;
	_tmp561__length1 = 1;
	_tmp562_ = valadoc_rule_many (_tmp561_, 1);
	_tmp563_ = g_new0 (GObject*, 1 + 1);
	_tmp563_[0] = (GObject*) _tmp562_;
	_tmp564_ = _tmp563_;
	_tmp564__length1 = 1;
	_tmp565_ = valadoc_rule_seq (_tmp564_, 1);
	_tmp566_ = _tmp565_;
	_tmp567_ = valadoc_rule_set_name (_tmp566_, "Table");
	_tmp568_ = _tmp567_;
	_tmp569_ = valadoc_rule_set_start (_tmp568_, ___lambda113__valadoc_rule_action, self);
	_tmp570_ = _tmp569_;
	_tmp571_ = valadoc_rule_set_reduce (_tmp570_, ___lambda114__valadoc_rule_action, self);
	_tmp572_ = _tmp571_;
	_g_object_unref0 (_tmp570_);
	_g_object_unref0 (_tmp568_);
	_g_object_unref0 (_tmp566_);
	_tmp564_ = (_vala_array_free (_tmp564_, _tmp564__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp561_ = (_vala_array_free (_tmp561_, _tmp561__length1, (GDestroyNotify) g_object_unref), NULL);
	table = _tmp572_;
	_tmp573_ = valadoc_token_type_EQUAL_1;
	_tmp574_ = valadoc_token_type_action (_tmp573_, ___lambda115__valadoc_token_type_action, self);
	_tmp575_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp576_ = _g_object_ref0 ((GObject*) run);
	_tmp577_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp578_ = valadoc_token_type_EQUAL_1;
	_tmp579_ = _g_object_ref0 ((GObject*) _tmp578_);
	_tmp580_ = valadoc_token_type_EOL;
	_tmp581_ = _g_object_ref0 ((GObject*) _tmp580_);
	_tmp582_ = g_new0 (GObject*, 6 + 1);
	_tmp582_[0] = (GObject*) _tmp574_;
	_tmp582_[1] = _tmp575_;
	_tmp582_[2] = _tmp576_;
	_tmp582_[3] = _tmp577_;
	_tmp582_[4] = _tmp579_;
	_tmp582_[5] = _tmp581_;
	_tmp583_ = _tmp582_;
	_tmp583__length1 = 6;
	_tmp584_ = valadoc_rule_seq (_tmp583_, 6);
	_tmp585_ = valadoc_token_type_EQUAL_2;
	_tmp586_ = valadoc_token_type_action (_tmp585_, ___lambda116__valadoc_token_type_action, self);
	_tmp587_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp588_ = _g_object_ref0 ((GObject*) run);
	_tmp589_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp590_ = valadoc_token_type_EQUAL_2;
	_tmp591_ = _g_object_ref0 ((GObject*) _tmp590_);
	_tmp592_ = valadoc_token_type_EOL;
	_tmp593_ = _g_object_ref0 ((GObject*) _tmp592_);
	_tmp594_ = g_new0 (GObject*, 6 + 1);
	_tmp594_[0] = (GObject*) _tmp586_;
	_tmp594_[1] = _tmp587_;
	_tmp594_[2] = _tmp588_;
	_tmp594_[3] = _tmp589_;
	_tmp594_[4] = _tmp591_;
	_tmp594_[5] = _tmp593_;
	_tmp595_ = _tmp594_;
	_tmp595__length1 = 6;
	_tmp596_ = valadoc_rule_seq (_tmp595_, 6);
	_tmp597_ = valadoc_token_type_EQUAL_3;
	_tmp598_ = valadoc_token_type_action (_tmp597_, ___lambda117__valadoc_token_type_action, self);
	_tmp599_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp600_ = _g_object_ref0 ((GObject*) run);
	_tmp601_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp602_ = valadoc_token_type_EQUAL_3;
	_tmp603_ = _g_object_ref0 ((GObject*) _tmp602_);
	_tmp604_ = valadoc_token_type_EOL;
	_tmp605_ = _g_object_ref0 ((GObject*) _tmp604_);
	_tmp606_ = g_new0 (GObject*, 6 + 1);
	_tmp606_[0] = (GObject*) _tmp598_;
	_tmp606_[1] = _tmp599_;
	_tmp606_[2] = _tmp600_;
	_tmp606_[3] = _tmp601_;
	_tmp606_[4] = _tmp603_;
	_tmp606_[5] = _tmp605_;
	_tmp607_ = _tmp606_;
	_tmp607__length1 = 6;
	_tmp608_ = valadoc_rule_seq (_tmp607_, 6);
	_tmp609_ = valadoc_token_type_EQUAL_4;
	_tmp610_ = valadoc_token_type_action (_tmp609_, ___lambda118__valadoc_token_type_action, self);
	_tmp611_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp612_ = _g_object_ref0 ((GObject*) run);
	_tmp613_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp614_ = valadoc_token_type_EQUAL_4;
	_tmp615_ = _g_object_ref0 ((GObject*) _tmp614_);
	_tmp616_ = valadoc_token_type_EOL;
	_tmp617_ = _g_object_ref0 ((GObject*) _tmp616_);
	_tmp618_ = g_new0 (GObject*, 6 + 1);
	_tmp618_[0] = (GObject*) _tmp610_;
	_tmp618_[1] = _tmp611_;
	_tmp618_[2] = _tmp612_;
	_tmp618_[3] = _tmp613_;
	_tmp618_[4] = _tmp615_;
	_tmp618_[5] = _tmp617_;
	_tmp619_ = _tmp618_;
	_tmp619__length1 = 6;
	_tmp620_ = valadoc_rule_seq (_tmp619_, 6);
	_tmp621_ = valadoc_token_type_EQUAL_5;
	_tmp622_ = valadoc_token_type_action (_tmp621_, ___lambda119__valadoc_token_type_action, self);
	_tmp623_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp624_ = _g_object_ref0 ((GObject*) run);
	_tmp625_ = _g_object_ref0 ((GObject*) optional_invisible_spaces);
	_tmp626_ = valadoc_token_type_EQUAL_5;
	_tmp627_ = _g_object_ref0 ((GObject*) _tmp626_);
	_tmp628_ = valadoc_token_type_EOL;
	_tmp629_ = _g_object_ref0 ((GObject*) _tmp628_);
	_tmp630_ = g_new0 (GObject*, 6 + 1);
	_tmp630_[0] = (GObject*) _tmp622_;
	_tmp630_[1] = _tmp623_;
	_tmp630_[2] = _tmp624_;
	_tmp630_[3] = _tmp625_;
	_tmp630_[4] = _tmp627_;
	_tmp630_[5] = _tmp629_;
	_tmp631_ = _tmp630_;
	_tmp631__length1 = 6;
	_tmp632_ = valadoc_rule_seq (_tmp631_, 6);
	_tmp633_ = g_new0 (GObject*, 5 + 1);
	_tmp633_[0] = (GObject*) _tmp584_;
	_tmp633_[1] = (GObject*) _tmp596_;
	_tmp633_[2] = (GObject*) _tmp608_;
	_tmp633_[3] = (GObject*) _tmp620_;
	_tmp633_[4] = (GObject*) _tmp632_;
	_tmp634_ = _tmp633_;
	_tmp634__length1 = 5;
	_tmp635_ = valadoc_rule_one_of (_tmp634_, 5);
	_tmp636_ = _tmp635_;
	_tmp637_ = valadoc_rule_set_name (_tmp636_, "Headline");
	_tmp638_ = _tmp637_;
	_tmp639_ = valadoc_rule_set_start (_tmp638_, ___lambda120__valadoc_rule_action, self);
	_tmp640_ = _tmp639_;
	_tmp641_ = valadoc_rule_set_reduce (_tmp640_, ___lambda121__valadoc_rule_action, self);
	_tmp642_ = _tmp641_;
	_g_object_unref0 (_tmp640_);
	_g_object_unref0 (_tmp638_);
	_g_object_unref0 (_tmp636_);
	_tmp634_ = (_vala_array_free (_tmp634_, _tmp634__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp631_ = (_vala_array_free (_tmp631_, _tmp631__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp619_ = (_vala_array_free (_tmp619_, _tmp619__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp607_ = (_vala_array_free (_tmp607_, _tmp607__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp595_ = (_vala_array_free (_tmp595_, _tmp595__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp583_ = (_vala_array_free (_tmp583_, _tmp583__length1, (GDestroyNotify) g_object_unref), NULL);
	headline = _tmp642_;
	_tmp643_ = _g_object_ref0 ((GObject*) indented_blocks);
	_tmp644_ = _g_object_ref0 ((GObject*) table);
	_tmp645_ = _g_object_ref0 ((GObject*) headline);
	_tmp646_ = _g_object_ref0 ((GObject*) warning);
	_tmp647_ = _g_object_ref0 ((GObject*) note);
	_tmp648_ = _g_object_ref0 ((GObject*) paragraph);
	_tmp649_ = g_new0 (GObject*, 6 + 1);
	_tmp649_[0] = _tmp643_;
	_tmp649_[1] = _tmp644_;
	_tmp649_[2] = _tmp645_;
	_tmp649_[3] = _tmp646_;
	_tmp649_[4] = _tmp647_;
	_tmp649_[5] = _tmp648_;
	_tmp650_ = _tmp649_;
	_tmp650__length1 = 6;
	_tmp651_ = valadoc_rule_one_of (_tmp650_, 6);
	_tmp652_ = _tmp651_;
	_tmp653_ = valadoc_rule_set_name (_tmp652_, "Blocks");
	_tmp654_ = _tmp653_;
	_g_object_unref0 (_tmp652_);
	_tmp650_ = (_vala_array_free (_tmp650_, _tmp650__length1, (GDestroyNotify) g_object_unref), NULL);
	blocks = _tmp654_;
	_tmp655_ = _g_object_ref0 ((GObject*) blocks);
	_tmp656_ = valadoc_token_type_EOL;
	_tmp657_ = _g_object_ref0 ((GObject*) _tmp656_);
	_tmp658_ = _g_object_ref0 ((GObject*) blocks);
	_tmp659_ = g_new0 (GObject*, 1 + 1);
	_tmp659_[0] = _tmp658_;
	_tmp660_ = _tmp659_;
	_tmp660__length1 = 1;
	_tmp661_ = valadoc_rule_option (_tmp660_, 1);
	_tmp662_ = g_new0 (GObject*, 2 + 1);
	_tmp662_[0] = _tmp657_;
	_tmp662_[1] = (GObject*) _tmp661_;
	_tmp663_ = _tmp662_;
	_tmp663__length1 = 2;
	_tmp664_ = valadoc_rule_many (_tmp663_, 2);
	_tmp665_ = g_new0 (GObject*, 1 + 1);
	_tmp665_[0] = (GObject*) _tmp664_;
	_tmp666_ = _tmp665_;
	_tmp666__length1 = 1;
	_tmp667_ = valadoc_rule_option (_tmp666_, 1);
	_tmp668_ = g_new0 (GObject*, 2 + 1);
	_tmp668_[0] = _tmp655_;
	_tmp668_[1] = (GObject*) _tmp667_;
	_tmp669_ = _tmp668_;
	_tmp669__length1 = 2;
	_tmp670_ = valadoc_rule_seq (_tmp669_, 2);
	_tmp671_ = _tmp670_;
	_tmp672_ = valadoc_rule_set_name (_tmp671_, "Page");
	_tmp673_ = _tmp672_;
	_tmp674_ = valadoc_rule_set_start (_tmp673_, ___lambda122__valadoc_rule_action, self);
	_tmp675_ = _tmp674_;
	_g_object_unref0 (_tmp673_);
	_g_object_unref0 (_tmp671_);
	_tmp669_ = (_vala_array_free (_tmp669_, _tmp669__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp666_ = (_vala_array_free (_tmp666_, _tmp666__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp663_ = (_vala_array_free (_tmp663_, _tmp663__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp660_ = (_vala_array_free (_tmp660_, _tmp660__length1, (GDestroyNotify) g_object_unref), NULL);
	page = _tmp675_;
	_tmp676_ = _g_object_ref0 ((GObject*) blocks);
	_tmp677_ = valadoc_token_type_EOL;
	_tmp678_ = _g_object_ref0 ((GObject*) _tmp677_);
	_tmp679_ = _g_object_ref0 ((GObject*) blocks);
	_tmp680_ = g_new0 (GObject*, 1 + 1);
	_tmp680_[0] = _tmp679_;
	_tmp681_ = _tmp680_;
	_tmp681__length1 = 1;
	_tmp682_ = valadoc_rule_option (_tmp681_, 1);
	_tmp683_ = g_new0 (GObject*, 2 + 1);
	_tmp683_[0] = _tmp678_;
	_tmp683_[1] = (GObject*) _tmp682_;
	_tmp684_ = _tmp683_;
	_tmp684__length1 = 2;
	_tmp685_ = valadoc_rule_many (_tmp684_, 2);
	_tmp686_ = g_new0 (GObject*, 1 + 1);
	_tmp686_[0] = (GObject*) _tmp685_;
	_tmp687_ = _tmp686_;
	_tmp687__length1 = 1;
	_tmp688_ = valadoc_rule_option (_tmp687_, 1);
	_tmp689_ = g_new0 (GObject*, 2 + 1);
	_tmp689_[0] = _tmp676_;
	_tmp689_[1] = (GObject*) _tmp688_;
	_tmp690_ = _tmp689_;
	_tmp690__length1 = 2;
	_tmp691_ = valadoc_rule_seq (_tmp690_, 2);
	_tmp692_ = _tmp691_;
	_tmp693_ = valadoc_rule_set_name (_tmp692_, "Description");
	_tmp694_ = _tmp693_;
	_g_object_unref0 (_tmp692_);
	_tmp690_ = (_vala_array_free (_tmp690_, _tmp690__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp687_ = (_vala_array_free (_tmp687_, _tmp687__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp684_ = (_vala_array_free (_tmp684_, _tmp684__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp681_ = (_vala_array_free (_tmp681_, _tmp681__length1, (GDestroyNotify) g_object_unref), NULL);
	description = _tmp694_;
	_tmp695_ = self->priv->multiline_run;
	_tmp696_ = _g_object_ref0 ((GObject*) _tmp695_);
	_tmp697_ = g_new0 (GObject*, 1 + 1);
	_tmp697_[0] = _tmp696_;
	_tmp698_ = _tmp697_;
	_tmp698__length1 = 1;
	_tmp699_ = valadoc_rule_seq (_tmp698_, 1);
	_tmp700_ = _tmp699_;
	_tmp701_ = valadoc_rule_set_start (_tmp700_, ___lambda123__valadoc_rule_action, self);
	_tmp702_ = _tmp701_;
	_tmp703_ = valadoc_rule_set_reduce (_tmp702_, ___lambda124__valadoc_rule_action, self);
	_tmp704_ = _tmp703_;
	_tmp705_ = valadoc_rule_set_name (_tmp704_, "BlockMultilineRun");
	_g_object_unref0 (self->priv->multiline_block_run);
	self->priv->multiline_block_run = _tmp705_;
	_g_object_unref0 (_tmp704_);
	_g_object_unref0 (_tmp702_);
	_g_object_unref0 (_tmp700_);
	_tmp698_ = (_vala_array_free (_tmp698_, _tmp698__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp706_ = valadoc_token_type_AROBASE;
	_tmp707_ = _g_object_ref0 ((GObject*) _tmp706_);
	_tmp708_ = valadoc_token_type_any_word ();
	_tmp709_ = _tmp708_;
	_tmp710_ = valadoc_token_type_action (_tmp709_, ___lambda125__valadoc_token_type_action, self);
	_tmp711_ = valadoc_token_type_EOL;
	_tmp712_ = _g_object_ref0 ((GObject*) _tmp711_);
	_tmp713_ = g_new0 (GObject*, 1 + 1);
	_tmp713_[0] = _tmp712_;
	_tmp714_ = _tmp713_;
	_tmp714__length1 = 1;
	_tmp715_ = valadoc_rule_many (_tmp714_, 1);
	_tmp716_ = g_new0 (GObject*, 1 + 1);
	_tmp716_[0] = (GObject*) _tmp715_;
	_tmp717_ = _tmp716_;
	_tmp717__length1 = 1;
	_tmp718_ = valadoc_rule_option (_tmp717_, 1);
	_tmp719_ = g_new0 (GObject*, 3 + 1);
	_tmp719_[0] = _tmp707_;
	_tmp719_[1] = (GObject*) _tmp710_;
	_tmp719_[2] = (GObject*) _tmp718_;
	_tmp720_ = _tmp719_;
	_tmp720__length1 = 3;
	_tmp721_ = valadoc_rule_seq (_tmp720_, 3);
	_tmp722_ = _tmp721_;
	_tmp723_ = valadoc_rule_set_name (_tmp722_, "Taglet");
	_tmp724_ = _tmp723_;
	_tmp725_ = valadoc_rule_set_reduce (_tmp724_, ___lambda126__valadoc_rule_action, self);
	_tmp726_ = _tmp725_;
	_g_object_unref0 (_tmp724_);
	_g_object_unref0 (_tmp722_);
	_tmp720_ = (_vala_array_free (_tmp720_, _tmp720__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp717_ = (_vala_array_free (_tmp717_, _tmp717__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp714_ = (_vala_array_free (_tmp714_, _tmp714__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp709_);
	taglet = _tmp726_;
	_tmp727_ = valadoc_token_type_EOL;
	_tmp728_ = _g_object_ref0 ((GObject*) _tmp727_);
	_tmp729_ = _g_object_ref0 ((GObject*) description);
	_tmp730_ = g_new0 (GObject*, 1 + 1);
	_tmp730_[0] = _tmp729_;
	_tmp731_ = _tmp730_;
	_tmp731__length1 = 1;
	_tmp732_ = valadoc_rule_option (_tmp731_, 1);
	_tmp733_ = _g_object_ref0 ((GObject*) taglet);
	_tmp734_ = g_new0 (GObject*, 1 + 1);
	_tmp734_[0] = _tmp733_;
	_tmp735_ = _tmp734_;
	_tmp735__length1 = 1;
	_tmp736_ = valadoc_rule_many (_tmp735_, 1);
	_tmp737_ = g_new0 (GObject*, 1 + 1);
	_tmp737_[0] = (GObject*) _tmp736_;
	_tmp738_ = _tmp737_;
	_tmp738__length1 = 1;
	_tmp739_ = valadoc_rule_option (_tmp738_, 1);
	_tmp740_ = g_new0 (GObject*, 3 + 1);
	_tmp740_[0] = _tmp728_;
	_tmp740_[1] = (GObject*) _tmp732_;
	_tmp740_[2] = (GObject*) _tmp739_;
	_tmp741_ = _tmp740_;
	_tmp741__length1 = 3;
	_tmp742_ = valadoc_rule_seq (_tmp741_, 3);
	_tmp743_ = _tmp742_;
	_tmp744_ = valadoc_rule_set_name (_tmp743_, "MultiLineComment");
	_tmp745_ = _tmp744_;
	_g_object_unref0 (_tmp743_);
	_tmp741_ = (_vala_array_free (_tmp741_, _tmp741__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp738_ = (_vala_array_free (_tmp738_, _tmp738__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp735_ = (_vala_array_free (_tmp735_, _tmp735__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp731_ = (_vala_array_free (_tmp731_, _tmp731__length1, (GDestroyNotify) g_object_unref), NULL);
	ml_comment = _tmp745_;
	_tmp746_ = _g_object_ref0 ((GObject*) run);
	_tmp747_ = g_new0 (GObject*, 1 + 1);
	_tmp747_[0] = _tmp746_;
	_tmp748_ = _tmp747_;
	_tmp748__length1 = 1;
	_tmp749_ = valadoc_rule_seq (_tmp748_, 1);
	_tmp750_ = _tmp749_;
	_tmp751_ = valadoc_rule_set_start (_tmp750_, ___lambda127__valadoc_rule_action, self);
	_tmp752_ = _tmp751_;
	_tmp753_ = valadoc_rule_set_reduce (_tmp752_, reduce_paragraph, reduce_paragraph_target);
	_tmp754_ = _tmp753_;
	_tmp755_ = valadoc_rule_set_name (_tmp754_, "SingleLineComment");
	_tmp756_ = _tmp755_;
	_g_object_unref0 (_tmp754_);
	_g_object_unref0 (_tmp752_);
	_g_object_unref0 (_tmp750_);
	_tmp748_ = (_vala_array_free (_tmp748_, _tmp748__length1, (GDestroyNotify) g_object_unref), NULL);
	sl_comment = _tmp756_;
	_tmp757_ = _g_object_ref0 ((GObject*) ml_comment);
	_tmp758_ = _g_object_ref0 ((GObject*) sl_comment);
	_tmp759_ = g_new0 (GObject*, 2 + 1);
	_tmp759_[0] = _tmp757_;
	_tmp759_[1] = _tmp758_;
	_tmp760_ = _tmp759_;
	_tmp760__length1 = 2;
	_tmp761_ = valadoc_rule_one_of (_tmp760_, 2);
	_tmp762_ = _tmp761_;
	_tmp763_ = valadoc_rule_set_name (_tmp762_, "Comment");
	_tmp764_ = _tmp763_;
	_tmp765_ = valadoc_rule_set_start (_tmp764_, ___lambda128__valadoc_rule_action, self);
	_tmp766_ = _tmp765_;
	_g_object_unref0 (_tmp764_);
	_g_object_unref0 (_tmp762_);
	_tmp760_ = (_vala_array_free (_tmp760_, _tmp760__length1, (GDestroyNotify) g_object_unref), NULL);
	comment = _tmp766_;
	_tmp767_ = self->priv->_comment_parser;
	valadoc_parser_set_root_rule (_tmp767_, comment);
	_tmp768_ = self->priv->_wiki_parser;
	valadoc_parser_set_root_rule (_tmp768_, page);
	_g_object_unref0 (comment);
	_g_object_unref0 (sl_comment);
	_g_object_unref0 (ml_comment);
	_g_object_unref0 (taglet);
	_g_object_unref0 (description);
	_g_object_unref0 (page);
	_g_object_unref0 (blocks);
	_g_object_unref0 (headline);
	_g_object_unref0 (table);
	_g_object_unref0 (table_row);
	_g_object_unref0 (table_cell);
	_g_object_unref0 (table_cell_attributes);
	_g_object_unref0 (indented_blocks);
	_g_object_unref0 (indented_item);
	_g_object_unref0 (note);
	_g_object_unref0 (warning);
	_g_object_unref0 (paragraph);
	(reduce_paragraph_target_destroy_notify == NULL) ? NULL : (reduce_paragraph_target_destroy_notify (reduce_paragraph_target), NULL);
	reduce_paragraph = NULL;
	reduce_paragraph_target = NULL;
	reduce_paragraph_target_destroy_notify = NULL;
	_g_object_unref0 (run_arobase);
	_g_object_unref0 (run_subrules);
	(append_head_to_head2_target_destroy_notify == NULL) ? NULL : (append_head_to_head2_target_destroy_notify (append_head_to_head2_target), NULL);
	append_head_to_head2 = NULL;
	append_head_to_head2_target = NULL;
	append_head_to_head2_target_destroy_notify = NULL;
	_g_object_unref0 (source_code);
	_g_object_unref0 (link);
	_g_object_unref0 (embedded);
	_g_object_unref0 (monospace);
	_g_object_unref0 (underlined);
	_g_object_unref0 (italic);
	_g_object_unref0 (bold);
	_g_object_unref0 (inline_taglet);
	_g_object_unref0 (run_with_spaces);
	_g_object_unref0 (text);
	_g_object_unref0 (optional_spaces);
	_g_object_unref0 (optional_invisible_spaces);
	_g_object_unref0 (word);
	_g_object_unref0 (space);
	_g_object_unref0 (run);
}


static void
valadoc_documentation_parser_class_init (ValadocDocumentationParserClass * klass)
{
	valadoc_documentation_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocDocumentationParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = valadoc_documentation_parser_finalize;
}


static void
valadoc_documentation_parser_valadoc_resource_locator_interface_init (ValadocResourceLocatorIface * iface)
{
	valadoc_documentation_parser_valadoc_resource_locator_parent_iface = g_type_interface_peek_parent (iface);
	iface->resolve = (gchar* (*) (ValadocResourceLocator*, const gchar*)) valadoc_documentation_parser_real_resolve;
}


static void
valadoc_documentation_parser_instance_init (ValadocDocumentationParser * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gint* _tmp2_;
	self->priv = valadoc_documentation_parser_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	self->priv->_stack = _tmp1_;
	self->priv->current_level = 0;
	_tmp2_ = g_new0 (gint, 0);
	self->priv->levels = _tmp2_;
	self->priv->levels_length1 = 0;
	self->priv->_levels_size_ = self->priv->levels_length1;
}


static void
valadoc_documentation_parser_finalize (GObject * obj)
{
	ValadocDocumentationParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_DOCUMENTATION_PARSER, ValadocDocumentationParser);
	_vala_map_unref0 (self->priv->metadata);
	_valadoc_importer_internal_id_registrar_unref0 (self->priv->id_registrar);
	_g_object_unref0 (self->priv->gtkdoc_parser);
	_g_object_unref0 (self->priv->gtkdoc_markdown_parser);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_reporter);
	_valadoc_api_tree_unref0 (self->priv->_tree);
	_g_object_unref0 (self->priv->_modules);
	_g_object_unref0 (self->priv->_factory);
	_g_object_unref0 (self->priv->_wiki_scanner);
	_g_object_unref0 (self->priv->_comment_scanner);
	_valadoc_parser_unref0 (self->priv->_wiki_parser);
	_valadoc_parser_unref0 (self->priv->_comment_parser);
	_valadoc_parser_unref0 (self->priv->_parser);
	_g_object_unref0 (self->priv->_scanner);
	_vala_iterable_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->multiline_block_run);
	_g_object_unref0 (self->priv->multiline_run);
	self->priv->levels = (g_free (self->priv->levels), NULL);
	G_OBJECT_CLASS (valadoc_documentation_parser_parent_class)->finalize (obj);
}


GType
valadoc_documentation_parser_get_type (void)
{
	static volatile gsize valadoc_documentation_parser_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_documentation_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocDocumentationParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_documentation_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocDocumentationParser), 0, (GInstanceInitFunc) valadoc_documentation_parser_instance_init, NULL };
		static const GInterfaceInfo valadoc_resource_locator_info = { (GInterfaceInitFunc) valadoc_documentation_parser_valadoc_resource_locator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_documentation_parser_type_id;
		valadoc_documentation_parser_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocDocumentationParser", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_documentation_parser_type_id, VALADOC_TYPE_RESOURCE_LOCATOR, &valadoc_resource_locator_info);
		ValadocDocumentationParser_private_offset = g_type_add_instance_private (valadoc_documentation_parser_type_id, sizeof (ValadocDocumentationParserPrivate));
		g_once_init_leave (&valadoc_documentation_parser_type_id__volatile, valadoc_documentation_parser_type_id);
	}
	return valadoc_documentation_parser_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



