/* interface.c generated by valac, the Vala compiler
 * generated from interface.vala, do not modify */

/* interface.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <vala.h>
#include <valacodegen.h>

enum  {
	VALADOC_API_INTERFACE_0_PROPERTY,
	VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY,
	VALADOC_API_INTERFACE_NODE_TYPE_PROPERTY,
	VALADOC_API_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_interface_properties[VALADOC_API_INTERFACE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))

struct _ValadocApiInterfacePrivate {
	gchar* interface_macro_name;
	gchar* dbus_name;
	gchar* cname;
	gchar* type_id;
	ValaArrayList* interfaces;
	ValaCollection* _full_implemented_interfaces;
	ValadocApiTypeReference* _base_type;
	ValaSet* _known_related_interfaces;
	ValaSet* _known_implementations;
};


static gint ValadocApiInterface_private_offset;
static gpointer valadoc_api_interface_parent_class = NULL;

static void valadoc_api_interface_real_accept (ValadocApiNode* base,
                                        ValadocApiVisitor* visitor);
static ValadocContentInline* valadoc_api_interface_real_build_signature (ValadocApiItem* base);
static void valadoc_api_interface_finalize (GObject * obj);
static void _vala_valadoc_api_interface_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_valadoc_api_interface_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);


static inline gpointer
valadoc_api_interface_get_instance_private (ValadocApiInterface* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiInterface_private_offset);
}


ValadocApiInterface*
valadoc_api_interface_construct (GType object_type,
                                 ValadocApiNode* parent,
                                 ValadocApiSourceFile* file,
                                 const gchar* name,
                                 ValadocApiSymbolAccessibility accessibility,
                                 ValadocApiSourceComment* comment,
                                 const gchar* cname,
                                 const gchar* type_macro_name,
                                 const gchar* is_type_macro_name,
                                 const gchar* type_cast_macro_name,
                                 const gchar* type_function_name,
                                 const gchar* interface_macro_name,
                                 const gchar* dbus_name,
                                 ValaInterface* data)
{
	ValadocApiInterface * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (interface_macro_name != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	self = (ValadocApiInterface*) valadoc_api_typesymbol_construct (object_type, parent, file, name, accessibility, comment, type_macro_name, is_type_macro_name, type_cast_macro_name, type_function_name, FALSE, (ValaTypeSymbol*) data);
	_tmp0_ = g_strdup (interface_macro_name);
	_g_free0 (self->priv->interface_macro_name);
	self->priv->interface_macro_name = _tmp0_;
	_tmp1_ = g_strdup (dbus_name);
	_g_free0 (self->priv->dbus_name);
	self->priv->dbus_name = _tmp1_;
	_tmp2_ = g_strdup (cname);
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp2_;
	_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) data);
	_g_free0 (self->priv->type_id);
	self->priv->type_id = _tmp3_;
	return self;
}


ValadocApiInterface*
valadoc_api_interface_new (ValadocApiNode* parent,
                           ValadocApiSourceFile* file,
                           const gchar* name,
                           ValadocApiSymbolAccessibility accessibility,
                           ValadocApiSourceComment* comment,
                           const gchar* cname,
                           const gchar* type_macro_name,
                           const gchar* is_type_macro_name,
                           const gchar* type_cast_macro_name,
                           const gchar* type_function_name,
                           const gchar* interface_macro_name,
                           const gchar* dbus_name,
                           ValaInterface* data)
{
	return valadoc_api_interface_construct (VALADOC_API_TYPE_INTERFACE, parent, file, name, accessibility, comment, cname, type_macro_name, is_type_macro_name, type_cast_macro_name, type_function_name, interface_macro_name, dbus_name, data);
}


/**
 * Add a newpreconditioned interface to the list
 */
void
valadoc_api_interface_add_interface (ValadocApiInterface* self,
                                     ValadocApiTypeReference* iface)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp0_, iface);
}


/**
 * Returns a list of newly preconditioned interfaces
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaCollection*
valadoc_api_interface_get_implemented_interface_list (ValadocApiInterface* self)
{
	ValaCollection* result = NULL;
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a list of all preconditioned interfaces
 */
ValaCollection*
valadoc_api_interface_get_full_implemented_interface_list (ValadocApiInterface* self)
{
	ValaCollection* result = NULL;
	ValaCollection* _tmp0_;
	ValaCollection* _tmp12_;
	ValaCollection* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_implemented_interfaces;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		ValaCollection* _tmp3_;
		ValaArrayList* _tmp4_;
		ValadocApiTypeReference* _tmp5_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->_full_implemented_interfaces);
		self->priv->_full_implemented_interfaces = (ValaCollection*) _tmp2_;
		_tmp3_ = self->priv->_full_implemented_interfaces;
		_tmp4_ = self->priv->interfaces;
		vala_collection_add_all (_tmp3_, (ValaCollection*) _tmp4_);
		_tmp5_ = self->priv->_base_type;
		if (_tmp5_ != NULL) {
			ValaCollection* _tmp6_;
			ValadocApiTypeReference* _tmp7_;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp9_;
			ValaCollection* _tmp10_;
			ValaCollection* _tmp11_;
			_tmp6_ = self->priv->_full_implemented_interfaces;
			_tmp7_ = self->priv->_base_type;
			_tmp8_ = valadoc_api_typereference_get_data_type (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = valadoc_api_class_get_full_implemented_interface_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp11_ = _tmp10_;
			vala_collection_add_all (_tmp6_, _tmp11_);
			_vala_iterable_unref0 (_tmp11_);
		}
	}
	_tmp12_ = self->priv->_full_implemented_interfaces;
	_tmp13_ = _vala_iterable_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}


/**
 * Returns the name of this interface as it is used in C.
 */
gchar*
valadoc_api_interface_get_cname (ValadocApiInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C symbol representing the runtime type id for this data type.
 */
gchar*
valadoc_api_interface_get_type_id (ValadocApiInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_id;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the dbus-name.
 */
gchar*
valadoc_api_interface_get_dbus_name (ValadocApiInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dbus_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the name of the GType macro which returns the interface struct.
 */
gchar*
valadoc_api_interface_get_interface_macro_name (ValadocApiInterface* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interface_macro_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_interface_real_accept (ValadocApiNode* base,
                                   ValadocApiVisitor* visitor)
{
	ValadocApiInterface * self;
	self = (ValadocApiInterface*) base;
	g_return_if_fail (visitor != NULL);
	valadoc_api_visitor_visit_interface (visitor, self);
}


/**
 * Returns a list of all known implementations of this interface
 */
ValaCollection*
valadoc_api_interface_get_known_implementations (ValadocApiInterface* self)
{
	ValaCollection* result = NULL;
	ValaSet* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_known_implementations;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a list of all known related (sub-)interfaces
 */
ValaCollection*
valadoc_api_interface_get_known_related_interfaces (ValadocApiInterface* self)
{
	ValaCollection* result = NULL;
	ValaSet* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_known_related_interfaces;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


void
valadoc_api_interface_register_related_interface (ValadocApiInterface* self,
                                                  ValadocApiInterface* iface)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->_known_related_interfaces;
	vala_collection_add ((ValaCollection*) _tmp0_, iface);
}


void
valadoc_api_interface_register_implementation (ValadocApiInterface* self,
                                               ValadocApiClass* cl)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->_known_implementations;
	vala_collection_add ((ValaCollection*) _tmp0_, cl);
}


/**
 * {@inheritDoc}
 */
static ValadocContentInline*
valadoc_api_interface_real_build_signature (ValadocApiItem* base)
{
	ValadocApiInterface * self;
	ValadocContentInline* result = NULL;
	ValadocApiSignatureBuilder* signature = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSymbolAccessibility _tmp2_;
	ValadocApiSymbolAccessibility _tmp3_;
	const gchar* _tmp4_;
	ValadocApiSignatureBuilder* _tmp5_;
	ValadocApiSignatureBuilder* _tmp6_;
	ValaList* type_parameters = NULL;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gboolean first = FALSE;
	ValadocApiTypeReference* _tmp30_;
	ValaArrayList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	ValadocApiSignatureBuilder* _tmp58_;
	ValadocContentRun* _tmp59_;
	self = (ValadocApiInterface*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	signature = _tmp0_;
	_tmp1_ = signature;
	_tmp2_ = valadoc_api_symbol_get_accessibility ((ValadocApiSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_symbol_accessibility_to_string (_tmp3_);
	valadoc_api_signature_builder_append_keyword (_tmp1_, _tmp4_, TRUE);
	_tmp5_ = signature;
	valadoc_api_signature_builder_append_keyword (_tmp5_, "interface", TRUE);
	_tmp6_ = signature;
	valadoc_api_signature_builder_append_symbol (_tmp6_, (ValadocApiNode*) self, TRUE);
	_tmp7_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) self, VALADOC_API_NODE_TYPE_TYPE_PARAMETER, FALSE);
	type_parameters = _tmp7_;
	_tmp8_ = type_parameters;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		ValadocApiSignatureBuilder* _tmp11_;
		gboolean first = FALSE;
		ValadocApiSignatureBuilder* _tmp29_;
		_tmp11_ = signature;
		valadoc_api_signature_builder_append (_tmp11_, "<", FALSE);
		first = TRUE;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			ValaList* _tmp13_;
			gint _param_size = 0;
			ValaList* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _param_index = 0;
			_tmp12_ = type_parameters;
			_tmp13_ = _vala_iterable_ref0 (_tmp12_);
			_param_list = _tmp13_;
			_tmp14_ = _param_list;
			_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
			_tmp16_ = _tmp15_;
			_param_size = _tmp16_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				ValadocApiItem* param = NULL;
				ValaList* _tmp20_;
				gint _tmp21_;
				gpointer _tmp22_;
				gboolean _tmp23_;
				ValadocApiSignatureBuilder* _tmp25_;
				ValadocApiItem* _tmp26_;
				ValadocContentInline* _tmp27_;
				ValadocContentInline* _tmp28_;
				_tmp17_ = _param_index;
				_param_index = _tmp17_ + 1;
				_tmp18_ = _param_index;
				_tmp19_ = _param_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _param_list;
				_tmp21_ = _param_index;
				_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
				param = (ValadocApiItem*) ((ValadocApiNode*) _tmp22_);
				_tmp23_ = first;
				if (!_tmp23_) {
					ValadocApiSignatureBuilder* _tmp24_;
					_tmp24_ = signature;
					valadoc_api_signature_builder_append (_tmp24_, ",", FALSE);
				}
				_tmp25_ = signature;
				_tmp26_ = param;
				_tmp27_ = valadoc_api_item_get_signature (_tmp26_);
				_tmp28_ = _tmp27_;
				valadoc_api_signature_builder_append_content (_tmp25_, _tmp28_, FALSE);
				first = FALSE;
				_g_object_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp29_ = signature;
		valadoc_api_signature_builder_append (_tmp29_, ">", FALSE);
	}
	first = TRUE;
	_tmp30_ = self->priv->_base_type;
	if (_tmp30_ != NULL) {
		ValadocApiSignatureBuilder* _tmp31_;
		ValadocApiSignatureBuilder* _tmp32_;
		ValadocApiTypeReference* _tmp33_;
		ValadocContentInline* _tmp34_;
		ValadocContentInline* _tmp35_;
		_tmp31_ = signature;
		valadoc_api_signature_builder_append (_tmp31_, ":", TRUE);
		_tmp32_ = signature;
		_tmp33_ = self->priv->_base_type;
		_tmp34_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp33_);
		_tmp35_ = _tmp34_;
		valadoc_api_signature_builder_append_content (_tmp32_, _tmp35_, TRUE);
		first = FALSE;
	}
	_tmp36_ = self->priv->interfaces;
	_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		gboolean _tmp39_;
		_tmp39_ = first;
		if (_tmp39_) {
			ValadocApiSignatureBuilder* _tmp40_;
			_tmp40_ = signature;
			valadoc_api_signature_builder_append (_tmp40_, ":", TRUE);
		}
		{
			ValaArrayList* _implemented_interface_list = NULL;
			ValaArrayList* _tmp41_;
			ValaArrayList* _tmp42_;
			gint _implemented_interface_size = 0;
			ValaArrayList* _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _implemented_interface_index = 0;
			_tmp41_ = self->priv->interfaces;
			_tmp42_ = _vala_iterable_ref0 (_tmp41_);
			_implemented_interface_list = _tmp42_;
			_tmp43_ = _implemented_interface_list;
			_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
			_tmp45_ = _tmp44_;
			_implemented_interface_size = _tmp45_;
			_implemented_interface_index = -1;
			while (TRUE) {
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				ValadocApiItem* implemented_interface = NULL;
				ValaArrayList* _tmp49_;
				gint _tmp50_;
				gpointer _tmp51_;
				gboolean _tmp52_;
				ValadocApiSignatureBuilder* _tmp54_;
				ValadocApiItem* _tmp55_;
				ValadocContentInline* _tmp56_;
				ValadocContentInline* _tmp57_;
				_tmp46_ = _implemented_interface_index;
				_implemented_interface_index = _tmp46_ + 1;
				_tmp47_ = _implemented_interface_index;
				_tmp48_ = _implemented_interface_size;
				if (!(_tmp47_ < _tmp48_)) {
					break;
				}
				_tmp49_ = _implemented_interface_list;
				_tmp50_ = _implemented_interface_index;
				_tmp51_ = vala_list_get ((ValaList*) _tmp49_, _tmp50_);
				implemented_interface = (ValadocApiItem*) ((ValadocApiTypeReference*) _tmp51_);
				_tmp52_ = first;
				if (!_tmp52_) {
					ValadocApiSignatureBuilder* _tmp53_;
					_tmp53_ = signature;
					valadoc_api_signature_builder_append (_tmp53_, ",", FALSE);
				}
				_tmp54_ = signature;
				_tmp55_ = implemented_interface;
				_tmp56_ = valadoc_api_item_get_signature (_tmp55_);
				_tmp57_ = _tmp56_;
				valadoc_api_signature_builder_append_content (_tmp54_, _tmp57_, TRUE);
				first = FALSE;
				_g_object_unref0 (implemented_interface);
			}
			_vala_iterable_unref0 (_implemented_interface_list);
		}
	}
	_tmp58_ = signature;
	_tmp59_ = valadoc_api_signature_builder_get (_tmp58_);
	result = (ValadocContentInline*) _tmp59_;
	_vala_iterable_unref0 (type_parameters);
	_valadoc_api_signature_builder_unref0 (signature);
	return result;
}


ValadocApiTypeReference*
valadoc_api_interface_get_base_type (ValadocApiInterface* self)
{
	ValadocApiTypeReference* result;
	ValadocApiTypeReference* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
valadoc_api_interface_set_base_type (ValadocApiInterface* self,
                                     ValadocApiTypeReference* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_interface_get_base_type (self) != value) {
		ValadocApiTypeReference* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_type);
		self->priv->_base_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_interface_properties[VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY]);
	}
}


static ValadocApiNodeType
valadoc_api_interface_real_get_node_type (ValadocApiNode* base)
{
	ValadocApiNodeType result;
	ValadocApiInterface* self;
	self = (ValadocApiInterface*) base;
	result = VALADOC_API_NODE_TYPE_INTERFACE;
	return result;
}


static void
valadoc_api_interface_class_init (ValadocApiInterfaceClass * klass)
{
	valadoc_api_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiInterface_private_offset);
	((ValadocApiNodeClass *) klass)->accept = (void (*) (ValadocApiNode*, ValadocApiVisitor*)) valadoc_api_interface_real_accept;
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_interface_real_build_signature;
	VALADOC_API_NODE_CLASS (klass)->get_node_type = valadoc_api_interface_real_get_node_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_interface_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_interface_finalize;
	/**
	 * A preconditioned class or null
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY, valadoc_api_interface_properties[VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY] = g_param_spec_object ("base-type", "base-type", "base-type", VALADOC_API_TYPE_TYPEREFERENCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_INTERFACE_NODE_TYPE_PROPERTY, valadoc_api_interface_properties[VALADOC_API_INTERFACE_NODE_TYPE_PROPERTY] = g_param_spec_enum ("node-type", "node-type", "node-type", VALADOC_API_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_api_interface_instance_init (ValadocApiInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashSet* _tmp7_;
	self->priv = valadoc_api_interface_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	self->priv->interfaces = _tmp1_;
	self->priv->_full_implemented_interfaces = NULL;
	_tmp2_ = g_direct_hash;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_set_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_, _tmp3_);
	self->priv->_known_related_interfaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_hash;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_set_new (VALADOC_API_TYPE_CLASS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp5_, _tmp6_);
	self->priv->_known_implementations = (ValaSet*) _tmp7_;
}


static void
valadoc_api_interface_finalize (GObject * obj)
{
	ValadocApiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
	_g_free0 (self->priv->interface_macro_name);
	_g_free0 (self->priv->dbus_name);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->type_id);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->_full_implemented_interfaces);
	_g_object_unref0 (self->priv->_base_type);
	_vala_iterable_unref0 (self->priv->_known_related_interfaces);
	_vala_iterable_unref0 (self->priv->_known_implementations);
	G_OBJECT_CLASS (valadoc_api_interface_parent_class)->finalize (obj);
}


/**
 * Represents a interface declaration in the source code.
 */
GType
valadoc_api_interface_get_type (void)
{
	static volatile gsize valadoc_api_interface_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiInterface), 0, (GInstanceInitFunc) valadoc_api_interface_instance_init, NULL };
		GType valadoc_api_interface_type_id;
		valadoc_api_interface_type_id = g_type_register_static (VALADOC_API_TYPE_TYPESYMBOL, "ValadocApiInterface", &g_define_type_info, 0);
		ValadocApiInterface_private_offset = g_type_add_instance_private (valadoc_api_interface_type_id, sizeof (ValadocApiInterfacePrivate));
		g_once_init_leave (&valadoc_api_interface_type_id__volatile, valadoc_api_interface_type_id);
	}
	return valadoc_api_interface_type_id__volatile;
}


static void
_vala_valadoc_api_interface_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	ValadocApiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
	switch (property_id) {
		case VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY:
		g_value_set_object (value, valadoc_api_interface_get_base_type (self));
		break;
		case VALADOC_API_INTERFACE_NODE_TYPE_PROPERTY:
		g_value_set_enum (value, valadoc_api_node_get_node_type ((ValadocApiNode*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_api_interface_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	ValadocApiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
	switch (property_id) {
		case VALADOC_API_INTERFACE_BASE_TYPE_PROPERTY:
		valadoc_api_interface_set_base_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



