/* valaswitchlabel.c generated by valac, the Vala compiler
 * generated from valaswitchlabel.vala, do not modify */

/* valaswitchlabel.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSwitchLabelPrivate {
	ValaExpression* _expression;
	ValaSwitchSection* _section;
};


static gpointer vala_switch_label_parent_class = NULL;

#define VALA_SWITCH_LABEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelPrivate))
static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_label_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_switch_label_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_switch_label_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_switch_label_finalize (ValaCodeNode * obj);


/**
 * Creates a new switch case label.
 *
 * @param expr   label expression
 * @param source reference to source code
 * @return       newly created switch case label
 */
ValaSwitchLabel* vala_switch_label_construct (GType object_type, ValaExpression* expr, ValaSourceReference* source) {
	ValaSwitchLabel* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expr != NULL, NULL);
	self = (ValaSwitchLabel*) vala_code_node_construct (object_type);
	_tmp0_ = expr;
	vala_switch_label_set_expression (self, _tmp0_);
	_tmp1_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaSwitchLabel* vala_switch_label_new (ValaExpression* expr, ValaSourceReference* source) {
	return vala_switch_label_construct (VALA_TYPE_SWITCH_LABEL, expr, source);
}


/**
 * Creates a new switch default label.
 *
 * @param source reference to source code
 * @return       newly created switch default label
 */
ValaSwitchLabel* vala_switch_label_construct_with_default (GType object_type, ValaSourceReference* source) {
	ValaSwitchLabel* self = NULL;
	ValaSourceReference* _tmp0_;
	self = (ValaSwitchLabel*) vala_code_node_construct (object_type);
	_tmp0_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	return self;
}


ValaSwitchLabel* vala_switch_label_new_with_default (ValaSourceReference* source) {
	return vala_switch_label_construct_with_default (VALA_TYPE_SWITCH_LABEL, source);
}


static void vala_switch_label_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchLabel * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_switch_label (_tmp0_, self);
}


static void vala_switch_label_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchLabel * self;
	ValaExpression* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_expression;
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_;
		ValaCodeVisitor* _tmp2_;
		ValaCodeVisitor* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp1_ = self->priv->_expression;
		_tmp2_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
		_tmp3_ = visitor;
		_tmp4_ = self->priv->_expression;
		vala_code_visitor_visit_end_full_expression (_tmp3_, _tmp4_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_switch_label_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSwitchLabel * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->_expression;
	if (_tmp0_ != NULL) {
		ValaExpression* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaSwitchStatement* switch_statement = NULL;
		ValaSwitchSection* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaSwitchStatement* _tmp6_;
		ValaExpression* _tmp7_;
		gboolean _tmp8_;
		ValaExpression* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaSwitchStatement* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		gboolean _tmp20_;
		_tmp1_ = self->priv->_expression;
		_tmp2_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp1_, _tmp2_);
		_tmp3_ = self->priv->_section;
		_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement));
		switch_statement = _tmp6_;
		_tmp7_ = self->priv->_expression;
		_tmp8_ = vala_expression_is_constant (_tmp7_);
		if (!_tmp8_) {
			ValaExpression* _tmp9_;
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp9_ = self->priv->_expression;
			_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp11_, "Expression must be constant");
			result = FALSE;
			_vala_code_node_unref0 (switch_statement);
			return result;
		}
		_tmp12_ = self->priv->_expression;
		_tmp13_ = vala_expression_get_value_type (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = switch_statement;
		_tmp16_ = vala_switch_statement_get_expression (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_expression_get_value_type (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_data_type_compatible (_tmp14_, _tmp19_);
		if (!_tmp20_) {
			ValaExpression* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaExpression* _tmp24_;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			ValaSwitchStatement* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp21_ = self->priv->_expression;
			_tmp22_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->priv->_expression;
			_tmp25_ = vala_expression_get_value_type (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_code_node_to_string ((ValaCodeNode*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = switch_statement;
			_tmp30_ = vala_switch_statement_get_expression (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_code_node_to_string ((ValaCodeNode*) _tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp28_, _tmp35_);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp23_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp28_);
			result = FALSE;
			_vala_code_node_unref0 (switch_statement);
			return result;
		}
		_vala_code_node_unref0 (switch_statement);
	}
	result = TRUE;
	return result;
}


static void vala_switch_label_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaSwitchLabel * self;
	ValaCodeGenerator* _tmp0_;
	self = (ValaSwitchLabel*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_switch_label ((ValaCodeVisitor*) _tmp0_, self);
}


ValaExpression* vala_switch_label_get_expression (ValaSwitchLabel* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


void vala_switch_label_set_expression (ValaSwitchLabel* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_expression);
	self->priv->_expression = _tmp1_;
}


ValaSwitchSection* vala_switch_label_get_section (ValaSwitchLabel* self) {
	ValaSwitchSection* result;
	ValaSwitchSection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_section;
	result = _tmp0_;
	return result;
}


void vala_switch_label_set_section (ValaSwitchLabel* self, ValaSwitchSection* value) {
	ValaSwitchSection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_section = _tmp0_;
}


static void vala_switch_label_class_init (ValaSwitchLabelClass * klass) {
	vala_switch_label_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_label_finalize;
	g_type_class_add_private (klass, sizeof (ValaSwitchLabelPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_label_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_label_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_switch_label_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_switch_label_real_emit;
}


static void vala_switch_label_instance_init (ValaSwitchLabel * self) {
	self->priv = VALA_SWITCH_LABEL_GET_PRIVATE (self);
}


static void vala_switch_label_finalize (ValaCodeNode * obj) {
	ValaSwitchLabel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel);
	_vala_code_node_unref0 (self->priv->_expression);
	VALA_CODE_NODE_CLASS (vala_switch_label_parent_class)->finalize (obj);
}


/**
 * Represents a switch label in the source code.
 */
GType vala_switch_label_get_type (void) {
	static volatile gsize vala_switch_label_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchLabel), 0, (GInstanceInitFunc) vala_switch_label_instance_init, NULL };
		GType vala_switch_label_type_id;
		vala_switch_label_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchLabel", &g_define_type_info, 0);
		g_once_init_leave (&vala_switch_label_type_id__volatile, vala_switch_label_type_id);
	}
	return vala_switch_label_type_id__volatile;
}



