/* valalambdaexpression.c generated by valac, the Vala compiler
 * generated from valalambdaexpression.vala, do not modify */

/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	ValaList* parameters;
};


static gpointer vala_lambda_expression_parent_class = NULL;

#define VALA_LAMBDA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionPrivate))
static void vala_lambda_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_lambda_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base);
static gchar* vala_lambda_expression_get_lambda_name (ValaLambdaExpression* self, ValaCodeContext* context);
static gboolean vala_lambda_expression_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_lambda_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_lambda_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new lambda expression.
 *
 * @param expression_body  expression body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression* vala_lambda_expression_construct (GType object_type, ValaExpression* expression_body, ValaSourceReference* source_reference) {
	ValaLambdaExpression* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (expression_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = expression_body;
	vala_lambda_expression_set_expression_body (self, _tmp1_);
	return self;
}


ValaLambdaExpression* vala_lambda_expression_new (ValaExpression* expression_body, ValaSourceReference* source_reference) {
	return vala_lambda_expression_construct (VALA_TYPE_LAMBDA_EXPRESSION, expression_body, source_reference);
}


/**
 * Creates a new lambda expression with statement body.
 *
 * @param statement_body   statement body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression* vala_lambda_expression_construct_with_statement_body (GType object_type, ValaBlock* statement_body, ValaSourceReference* source_reference) {
	ValaLambdaExpression* self = NULL;
	ValaBlock* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (statement_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	_tmp0_ = statement_body;
	vala_lambda_expression_set_statement_body (self, _tmp0_);
	_tmp1_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp1_);
	return self;
}


ValaLambdaExpression* vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body, ValaSourceReference* source_reference) {
	return vala_lambda_expression_construct_with_statement_body (VALA_TYPE_LAMBDA_EXPRESSION, statement_body, source_reference);
}


/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void vala_lambda_expression_add_parameter (ValaLambdaExpression* self, ValaParameter* param) {
	ValaList* _tmp0_;
	ValaParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = param;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
}


/**
 * Returns copy of parameter list.
 *
 * @return parameter list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_lambda_expression_get_parameters (ValaLambdaExpression* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_lambda_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLambdaExpression * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_lambda_expression (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_lambda_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_method;
	if (_tmp0_ == NULL) {
		ValaExpression* _tmp1_;
		_tmp1_ = self->priv->_expression_body;
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_;
			ValaCodeVisitor* _tmp3_;
			ValaCodeVisitor* _tmp4_;
			ValaExpression* _tmp5_;
			_tmp2_ = self->priv->_expression_body;
			_tmp3_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, _tmp3_);
			_tmp4_ = visitor;
			_tmp5_ = self->priv->_expression_body;
			vala_code_visitor_visit_end_full_expression (_tmp4_, _tmp5_);
		} else {
			ValaBlock* _tmp6_;
			_tmp6_ = self->priv->_statement_body;
			if (_tmp6_ != NULL) {
				ValaBlock* _tmp7_;
				ValaCodeVisitor* _tmp8_;
				_tmp7_ = self->priv->_statement_body;
				_tmp8_ = visitor;
				vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
			}
		}
	} else {
		ValaMethod* _tmp9_;
		ValaCodeVisitor* _tmp10_;
		_tmp9_ = self->priv->_method;
		_tmp10_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, _tmp10_);
	}
}


static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base) {
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	result = FALSE;
	return result;
}


static gchar* vala_lambda_expression_get_lambda_name (ValaLambdaExpression* self, ValaCodeContext* context) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ValaCodeContext* _tmp0_;
	ValaSemanticAnalyzer* _tmp1_;
	ValaSemanticAnalyzer* _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = context;
	_tmp1_ = vala_code_context_get_analyzer (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->next_lambda_id;
	_tmp4_ = g_strdup_printf ("_lambda%d_", _tmp3_);
	_result_ = _tmp4_;
	_tmp5_ = context;
	_tmp6_ = vala_code_context_get_analyzer (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->next_lambda_id;
	_tmp7_->next_lambda_id = _tmp8_ + 1;
	result = _result_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_lambda_expression_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDelegate* cb = NULL;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaDelegate* _tmp22_;
	ValaDataType* return_type = NULL;
	ValaDelegate* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaCodeContext* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaDataType* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaMethod* _tmp35_;
	ValaMethod* _tmp36_;
	ValaMethod* _tmp37_;
	ValaMethod* _tmp38_;
	ValaVersionAttribute* _tmp39_;
	ValaVersionAttribute* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	gboolean _tmp43_ = FALSE;
	ValaDelegate* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	ValaMethod* _tmp93_;
	ValaCodeContext* _tmp94_;
	ValaSemanticAnalyzer* _tmp95_;
	ValaSemanticAnalyzer* _tmp96_;
	ValaSymbol* _tmp97_;
	ValaSymbol* _tmp98_;
	ValaScope* _tmp99_;
	ValaScope* _tmp100_;
	ValaList* lambda_params = NULL;
	ValaList* _tmp101_;
	ValaIterator* lambda_param_it = NULL;
	ValaList* _tmp102_;
	ValaIterator* _tmp103_;
	gboolean _tmp104_ = FALSE;
	ValaDelegate* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	ValaIterator* _tmp164_;
	gboolean _tmp165_;
	ValaExpression* _tmp183_;
	ValaMethod* _tmp214_;
	ValaBlock* _tmp215_;
	ValaBlock* _tmp216_;
	ValaMethod* _tmp217_;
	ValaScope* _tmp218_;
	ValaScope* _tmp219_;
	ValaMethod* m = NULL;
	ValaCodeContext* _tmp220_;
	ValaSemanticAnalyzer* _tmp221_;
	ValaSemanticAnalyzer* _tmp222_;
	ValaCodeContext* _tmp223_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSemanticAnalyzer* _tmp225_;
	ValaSymbol* _tmp226_;
	ValaSymbol* _tmp227_;
	ValaMethod* _tmp228_;
	ValaMethod* _tmp229_;
	ValaMethod* _tmp254_;
	ValaMethod* _tmp255_;
	ValaCodeContext* _tmp256_;
	ValaMethod* _tmp257_;
	ValaMethodType* _tmp258_;
	ValaMethodType* _tmp259_;
	ValaDataType* _tmp260_;
	ValaDataType* _tmp261_;
	ValaDataType* _tmp262_;
	ValaDataType* _tmp263_;
	gboolean _tmp264_;
	gboolean _tmp265_;
	gboolean _tmp266_;
	gboolean _tmp267_;
	self = (ValaLambdaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Cannot convert lambda expression to `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "lambda expression not allowed in this context");
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE, ValaDelegate));
	cb = _tmp22_;
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_actual_type (_tmp25_, _tmp27_, NULL, (ValaCodeNode*) self);
	return_type = _tmp28_;
	_tmp29_ = context;
	_tmp30_ = vala_lambda_expression_get_lambda_name (self, _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = return_type;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_method_new (_tmp31_, _tmp32_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	vala_lambda_expression_set_method (self, _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_g_free0 (_tmp31_);
	_tmp37_ = self->priv->_method;
	vala_symbol_set_used ((ValaSymbol*) _tmp37_, TRUE);
	_tmp38_ = self->priv->_method;
	_tmp39_ = vala_symbol_get_version ((ValaSymbol*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	vala_version_attribute_check (_tmp40_, _tmp42_);
	_tmp44_ = cb;
	_tmp45_ = vala_delegate_get_has_target (_tmp44_);
	_tmp46_ = _tmp45_;
	if (!_tmp46_) {
		_tmp43_ = TRUE;
	} else {
		ValaCodeContext* _tmp47_;
		ValaSemanticAnalyzer* _tmp48_;
		ValaSemanticAnalyzer* _tmp49_;
		gboolean _tmp50_;
		_tmp47_ = context;
		_tmp48_ = vala_code_context_get_analyzer (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_semantic_analyzer_is_in_instance_method (_tmp49_);
		_tmp43_ = !_tmp50_;
	}
	if (_tmp43_) {
		ValaMethod* _tmp51_;
		_tmp51_ = self->priv->_method;
		vala_method_set_binding (_tmp51_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaSymbol* sym = NULL;
		ValaCodeContext* _tmp52_;
		ValaSemanticAnalyzer* _tmp53_;
		ValaSemanticAnalyzer* _tmp54_;
		ValaSymbol* _tmp55_;
		ValaSymbol* _tmp56_;
		ValaSymbol* _tmp57_;
		_tmp52_ = context;
		_tmp53_ = vala_code_context_get_analyzer (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_semantic_analyzer_get_current_symbol (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (_tmp56_);
		sym = _tmp57_;
		while (TRUE) {
			ValaMethod* _tmp58_;
			ValaParameter* _tmp59_;
			ValaParameter* _tmp60_;
			ValaSymbol* _tmp61_;
			ValaSymbol* _tmp89_;
			ValaSymbol* _tmp90_;
			ValaSymbol* _tmp91_;
			ValaSymbol* _tmp92_;
			_tmp58_ = self->priv->_method;
			_tmp59_ = vala_method_get_this_parameter (_tmp58_);
			_tmp60_ = _tmp59_;
			if (!(_tmp60_ == NULL)) {
				break;
			}
			_tmp61_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp61_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp62_;
				ValaProperty* _tmp63_;
				ValaMethod* _tmp64_;
				ValaProperty* _tmp65_;
				ValaParameter* _tmp66_;
				ValaParameter* _tmp67_;
				_tmp62_ = sym;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp63_;
				_tmp64_ = self->priv->_method;
				_tmp65_ = prop;
				_tmp66_ = vala_property_get_this_parameter (_tmp65_);
				_tmp67_ = _tmp66_;
				vala_method_set_this_parameter (_tmp64_, _tmp67_);
				_vala_code_node_unref0 (prop);
			} else {
				ValaSymbol* _tmp68_;
				_tmp68_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_CONSTRUCTOR)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp69_;
					ValaConstructor* _tmp70_;
					ValaMethod* _tmp71_;
					ValaConstructor* _tmp72_;
					ValaParameter* _tmp73_;
					ValaParameter* _tmp74_;
					_tmp69_ = sym;
					_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp70_;
					_tmp71_ = self->priv->_method;
					_tmp72_ = c;
					_tmp73_ = vala_constructor_get_this_parameter (_tmp72_);
					_tmp74_ = _tmp73_;
					vala_method_set_this_parameter (_tmp71_, _tmp74_);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp75_;
					_tmp75_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_DESTRUCTOR)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp76_;
						ValaDestructor* _tmp77_;
						ValaMethod* _tmp78_;
						ValaDestructor* _tmp79_;
						ValaParameter* _tmp80_;
						ValaParameter* _tmp81_;
						_tmp76_ = sym;
						_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp77_;
						_tmp78_ = self->priv->_method;
						_tmp79_ = d;
						_tmp80_ = vala_destructor_get_this_parameter (_tmp79_);
						_tmp81_ = _tmp80_;
						vala_method_set_this_parameter (_tmp78_, _tmp81_);
						_vala_code_node_unref0 (d);
					} else {
						ValaSymbol* _tmp82_;
						_tmp82_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp82_, VALA_TYPE_METHOD)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp83_;
							ValaMethod* _tmp84_;
							ValaMethod* _tmp85_;
							ValaMethod* _tmp86_;
							ValaParameter* _tmp87_;
							ValaParameter* _tmp88_;
							_tmp83_ = sym;
							_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp84_;
							_tmp85_ = self->priv->_method;
							_tmp86_ = m;
							_tmp87_ = vala_method_get_this_parameter (_tmp86_);
							_tmp88_ = _tmp87_;
							vala_method_set_this_parameter (_tmp85_, _tmp88_);
							_vala_code_node_unref0 (m);
						}
					}
				}
			}
			_tmp89_ = sym;
			_tmp90_ = vala_symbol_get_parent_symbol (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = _vala_code_node_ref0 (_tmp91_);
			_vala_code_node_unref0 (sym);
			sym = _tmp92_;
		}
		_vala_code_node_unref0 (sym);
	}
	_tmp93_ = self->priv->_method;
	_tmp94_ = context;
	_tmp95_ = vala_code_context_get_analyzer (_tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = vala_semantic_analyzer_get_current_symbol (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = vala_symbol_get_scope (_tmp98_);
	_tmp100_ = _tmp99_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp93_, _tmp100_);
	_tmp101_ = vala_lambda_expression_get_parameters (self);
	lambda_params = _tmp101_;
	_tmp102_ = lambda_params;
	_tmp103_ = vala_iterable_iterator ((ValaIterable*) _tmp102_);
	lambda_param_it = _tmp103_;
	_tmp105_ = cb;
	_tmp106_ = vala_delegate_get_sender_type (_tmp105_);
	_tmp107_ = _tmp106_;
	if (_tmp107_ != NULL) {
		ValaList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		ValaDelegate* _tmp111_;
		ValaList* _tmp112_;
		ValaList* _tmp113_;
		gint _tmp114_;
		gint _tmp115_;
		_tmp108_ = lambda_params;
		_tmp109_ = vala_collection_get_size ((ValaCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = cb;
		_tmp112_ = vala_callable_get_parameters ((ValaCallable*) _tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = vala_collection_get_size ((ValaCollection*) _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp104_ = _tmp110_ == (_tmp115_ + 1);
		_vala_iterable_unref0 (_tmp113_);
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaIterator* _tmp116_;
		ValaParameter* lambda_param = NULL;
		ValaIterator* _tmp117_;
		gpointer _tmp118_;
		ValaParameter* _tmp119_;
		ValaDelegate* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaMethod* _tmp123_;
		ValaParameter* _tmp124_;
		_tmp116_ = lambda_param_it;
		vala_iterator_next (_tmp116_);
		_tmp117_ = lambda_param_it;
		_tmp118_ = vala_iterator_get (_tmp117_);
		lambda_param = (ValaParameter*) _tmp118_;
		_tmp119_ = lambda_param;
		_tmp120_ = cb;
		_tmp121_ = vala_delegate_get_sender_type (_tmp120_);
		_tmp122_ = _tmp121_;
		vala_variable_set_variable_type ((ValaVariable*) _tmp119_, _tmp122_);
		_tmp123_ = self->priv->_method;
		_tmp124_ = lambda_param;
		vala_callable_add_parameter ((ValaCallable*) _tmp123_, _tmp124_);
		_vala_code_node_unref0 (lambda_param);
	}
	{
		ValaList* _cb_param_list = NULL;
		ValaDelegate* _tmp125_;
		ValaList* _tmp126_;
		gint _cb_param_size = 0;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _cb_param_index = 0;
		_tmp125_ = cb;
		_tmp126_ = vala_callable_get_parameters ((ValaCallable*) _tmp125_);
		_cb_param_list = _tmp126_;
		_tmp127_ = _cb_param_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_cb_param_size = _tmp129_;
		_cb_param_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			ValaParameter* cb_param = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaIterator* _tmp136_;
			gboolean _tmp137_;
			ValaParameter* lambda_param = NULL;
			ValaIterator* _tmp138_;
			gpointer _tmp139_;
			ValaParameter* _tmp140_;
			ValaParameterDirection _tmp141_;
			ValaParameterDirection _tmp142_;
			ValaParameter* _tmp143_;
			ValaParameterDirection _tmp144_;
			ValaParameterDirection _tmp145_;
			ValaParameter* _tmp154_;
			ValaParameter* _tmp155_;
			ValaDataType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaMethod* _tmp162_;
			ValaParameter* _tmp163_;
			_tmp130_ = _cb_param_index;
			_cb_param_index = _tmp130_ + 1;
			_tmp131_ = _cb_param_index;
			_tmp132_ = _cb_param_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _cb_param_list;
			_tmp134_ = _cb_param_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			cb_param = (ValaParameter*) _tmp135_;
			_tmp136_ = lambda_param_it;
			_tmp137_ = vala_iterator_next (_tmp136_);
			if (!_tmp137_) {
				_vala_code_node_unref0 (cb_param);
				break;
			}
			_tmp138_ = lambda_param_it;
			_tmp139_ = vala_iterator_get (_tmp138_);
			lambda_param = (ValaParameter*) _tmp139_;
			_tmp140_ = lambda_param;
			_tmp141_ = vala_parameter_get_direction (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = cb_param;
			_tmp144_ = vala_parameter_get_direction (_tmp143_);
			_tmp145_ = _tmp144_;
			if (_tmp142_ != _tmp145_) {
				ValaParameter* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				ValaParameter* _tmp149_;
				const gchar* _tmp150_;
				const gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp146_ = lambda_param;
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp146_);
				_tmp148_ = _tmp147_;
				_tmp149_ = lambda_param;
				_tmp150_ = vala_symbol_get_name ((ValaSymbol*) _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strdup_printf ("direction of parameter `%s' is incompatible with the target delegate", _tmp151_);
				_tmp153_ = _tmp152_;
				vala_report_error (_tmp148_, _tmp153_);
				_g_free0 (_tmp153_);
			}
			_tmp154_ = lambda_param;
			_tmp155_ = cb_param;
			_tmp156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp155_);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_data_type_get_actual_type (_tmp157_, _tmp159_, NULL, (ValaCodeNode*) self);
			_tmp161_ = _tmp160_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp154_, _tmp161_);
			_vala_code_node_unref0 (_tmp161_);
			_tmp162_ = self->priv->_method;
			_tmp163_ = lambda_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp162_, _tmp163_);
			_vala_code_node_unref0 (lambda_param);
			_vala_code_node_unref0 (cb_param);
		}
		_vala_iterable_unref0 (_cb_param_list);
	}
	_tmp164_ = lambda_param_it;
	_tmp165_ = vala_iterator_next (_tmp164_);
	if (_tmp165_) {
		ValaSourceReference* _tmp166_;
		ValaSourceReference* _tmp167_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp167_ = _tmp166_;
		vala_report_error (_tmp167_, "lambda expression: too many parameters");
		result = FALSE;
		_vala_iterator_unref0 (lambda_param_it);
		_vala_iterable_unref0 (lambda_params);
		_vala_code_node_unref0 (return_type);
		_vala_code_node_unref0 (cb);
		return result;
	}
	{
		ValaList* _error_type_list = NULL;
		ValaDelegate* _tmp168_;
		ValaList* _tmp169_;
		gint _error_type_size = 0;
		ValaList* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		gint _error_type_index = 0;
		_tmp168_ = cb;
		_tmp169_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp168_);
		_error_type_list = _tmp169_;
		_tmp170_ = _error_type_list;
		_tmp171_ = vala_collection_get_size ((ValaCollection*) _tmp170_);
		_tmp172_ = _tmp171_;
		_error_type_size = _tmp172_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp173_;
			gint _tmp174_;
			gint _tmp175_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp176_;
			gint _tmp177_;
			gpointer _tmp178_;
			ValaMethod* _tmp179_;
			ValaDataType* _tmp180_;
			ValaDataType* _tmp181_;
			ValaDataType* _tmp182_;
			_tmp173_ = _error_type_index;
			_error_type_index = _tmp173_ + 1;
			_tmp174_ = _error_type_index;
			_tmp175_ = _error_type_size;
			if (!(_tmp174_ < _tmp175_)) {
				break;
			}
			_tmp176_ = _error_type_list;
			_tmp177_ = _error_type_index;
			_tmp178_ = vala_list_get (_tmp176_, _tmp177_);
			error_type = (ValaDataType*) _tmp178_;
			_tmp179_ = self->priv->_method;
			_tmp180_ = error_type;
			_tmp181_ = vala_data_type_copy (_tmp180_);
			_tmp182_ = _tmp181_;
			vala_code_node_add_error_type ((ValaCodeNode*) _tmp179_, _tmp182_);
			_vala_code_node_unref0 (_tmp182_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp183_ = self->priv->_expression_body;
	if (_tmp183_ != NULL) {
		ValaBlock* block = NULL;
		ValaSourceReference* _tmp184_;
		ValaSourceReference* _tmp185_;
		ValaBlock* _tmp186_;
		ValaBlock* _tmp187_;
		ValaScope* _tmp188_;
		ValaScope* _tmp189_;
		ValaMethod* _tmp190_;
		ValaScope* _tmp191_;
		ValaScope* _tmp192_;
		ValaMethod* _tmp193_;
		ValaDataType* _tmp194_;
		ValaDataType* _tmp195_;
		ValaTypeSymbol* _tmp196_;
		ValaTypeSymbol* _tmp197_;
		ValaMethod* _tmp210_;
		ValaBlock* _tmp211_;
		_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_block_new (_tmp185_);
		block = _tmp186_;
		_tmp187_ = block;
		_tmp188_ = vala_symbol_get_scope ((ValaSymbol*) _tmp187_);
		_tmp189_ = _tmp188_;
		_tmp190_ = self->priv->_method;
		_tmp191_ = vala_symbol_get_scope ((ValaSymbol*) _tmp190_);
		_tmp192_ = _tmp191_;
		vala_scope_set_parent_scope (_tmp189_, _tmp192_);
		_tmp193_ = self->priv->_method;
		_tmp194_ = vala_callable_get_return_type ((ValaCallable*) _tmp193_);
		_tmp195_ = _tmp194_;
		_tmp196_ = vala_data_type_get_data_type (_tmp195_);
		_tmp197_ = _tmp196_;
		if (_tmp197_ != NULL) {
			ValaBlock* _tmp198_;
			ValaExpression* _tmp199_;
			ValaSourceReference* _tmp200_;
			ValaSourceReference* _tmp201_;
			ValaReturnStatement* _tmp202_;
			ValaReturnStatement* _tmp203_;
			_tmp198_ = block;
			_tmp199_ = self->priv->_expression_body;
			_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp201_ = _tmp200_;
			_tmp202_ = vala_return_statement_new (_tmp199_, _tmp201_);
			_tmp203_ = _tmp202_;
			vala_block_add_statement (_tmp198_, (ValaStatement*) _tmp203_);
			_vala_code_node_unref0 (_tmp203_);
		} else {
			ValaBlock* _tmp204_;
			ValaExpression* _tmp205_;
			ValaSourceReference* _tmp206_;
			ValaSourceReference* _tmp207_;
			ValaExpressionStatement* _tmp208_;
			ValaExpressionStatement* _tmp209_;
			_tmp204_ = block;
			_tmp205_ = self->priv->_expression_body;
			_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_expression_statement_new (_tmp205_, _tmp207_);
			_tmp209_ = _tmp208_;
			vala_block_add_statement (_tmp204_, (ValaStatement*) _tmp209_);
			_vala_code_node_unref0 (_tmp209_);
		}
		_tmp210_ = self->priv->_method;
		_tmp211_ = block;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp210_, _tmp211_);
		_vala_code_node_unref0 (block);
	} else {
		ValaMethod* _tmp212_;
		ValaBlock* _tmp213_;
		_tmp212_ = self->priv->_method;
		_tmp213_ = self->priv->_statement_body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp212_, _tmp213_);
	}
	_tmp214_ = self->priv->_method;
	_tmp215_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp214_);
	_tmp216_ = _tmp215_;
	_tmp217_ = self->priv->_method;
	_tmp218_ = vala_symbol_get_scope ((ValaSymbol*) _tmp217_);
	_tmp219_ = _tmp218_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp216_, _tmp219_);
	_tmp220_ = context;
	_tmp221_ = vala_code_context_get_analyzer (_tmp220_);
	_tmp222_ = _tmp221_;
	_tmp223_ = context;
	_tmp224_ = vala_code_context_get_analyzer (_tmp223_);
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_semantic_analyzer_get_current_symbol (_tmp225_);
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_semantic_analyzer_find_parent_method (_tmp222_, _tmp227_);
	m = _tmp228_;
	_tmp229_ = m;
	if (_tmp229_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaMethod* _tmp230_;
			ValaList* _tmp231_;
			gint _type_param_size = 0;
			ValaList* _tmp232_;
			gint _tmp233_;
			gint _tmp234_;
			gint _type_param_index = 0;
			_tmp230_ = m;
			_tmp231_ = vala_method_get_type_parameters (_tmp230_);
			_type_param_list = _tmp231_;
			_tmp232_ = _type_param_list;
			_tmp233_ = vala_collection_get_size ((ValaCollection*) _tmp232_);
			_tmp234_ = _tmp233_;
			_type_param_size = _tmp234_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp235_;
				gint _tmp236_;
				gint _tmp237_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp238_;
				gint _tmp239_;
				gpointer _tmp240_;
				ValaMethod* _tmp241_;
				ValaTypeParameter* _tmp242_;
				const gchar* _tmp243_;
				const gchar* _tmp244_;
				ValaTypeParameter* _tmp245_;
				ValaSourceReference* _tmp246_;
				ValaSourceReference* _tmp247_;
				ValaTypeParameter* _tmp248_;
				ValaTypeParameter* _tmp249_;
				ValaMethod* _tmp250_;
				ValaMethod* _tmp251_;
				ValaBlock* _tmp252_;
				ValaBlock* _tmp253_;
				_tmp235_ = _type_param_index;
				_type_param_index = _tmp235_ + 1;
				_tmp236_ = _type_param_index;
				_tmp237_ = _type_param_size;
				if (!(_tmp236_ < _tmp237_)) {
					break;
				}
				_tmp238_ = _type_param_list;
				_tmp239_ = _type_param_index;
				_tmp240_ = vala_list_get (_tmp238_, _tmp239_);
				type_param = (ValaTypeParameter*) _tmp240_;
				_tmp241_ = self->priv->_method;
				_tmp242_ = type_param;
				_tmp243_ = vala_symbol_get_name ((ValaSymbol*) _tmp242_);
				_tmp244_ = _tmp243_;
				_tmp245_ = type_param;
				_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp245_);
				_tmp247_ = _tmp246_;
				_tmp248_ = vala_typeparameter_new (_tmp244_, _tmp247_);
				_tmp249_ = _tmp248_;
				vala_method_add_type_parameter (_tmp241_, _tmp249_);
				_vala_code_node_unref0 (_tmp249_);
				_tmp250_ = self->priv->_method;
				vala_method_set_closure (_tmp250_, TRUE);
				_tmp251_ = m;
				_tmp252_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp251_);
				_tmp253_ = _tmp252_;
				vala_block_set_captured (_tmp253_, TRUE);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	_tmp254_ = self->priv->_method;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp254_);
	_tmp255_ = self->priv->_method;
	_tmp256_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp255_, _tmp256_);
	_tmp257_ = self->priv->_method;
	_tmp258_ = vala_method_type_new (_tmp257_);
	_tmp259_ = _tmp258_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp259_);
	_vala_code_node_unref0 (_tmp259_);
	_tmp260_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp261_ = _tmp260_;
	_tmp262_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp263_ = _tmp262_;
	_tmp264_ = vala_data_type_get_value_owned (_tmp263_);
	_tmp265_ = _tmp264_;
	vala_data_type_set_value_owned (_tmp261_, _tmp265_);
	_tmp266_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp267_ = _tmp266_;
	result = !_tmp267_;
	_vala_code_node_unref0 (m);
	_vala_iterator_unref0 (lambda_param_it);
	_vala_iterable_unref0 (lambda_params);
	_vala_code_node_unref0 (return_type);
	_vala_code_node_unref0 (cb);
	return result;
}


static void vala_lambda_expression_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaLambdaExpression * self;
	ValaCodeGenerator* _tmp0_;
	ValaCodeGenerator* _tmp1_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_lambda_expression ((ValaCodeVisitor*) _tmp0_, self);
	_tmp1_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp1_, (ValaExpression*) self);
}


static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_method;
	_tmp1_ = vala_method_get_closure (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaMethod* _tmp3_;
		ValaCollection* _tmp4_;
		_tmp3_ = self->priv->_method;
		_tmp4_ = collection;
		vala_method_get_captured_variables (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


ValaExpression* vala_lambda_expression_get_expression_body (ValaLambdaExpression* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression_body;
	result = _tmp0_;
	return result;
}


void vala_lambda_expression_set_expression_body (ValaLambdaExpression* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_expression_body);
	self->priv->_expression_body = _tmp1_;
}


ValaBlock* vala_lambda_expression_get_statement_body (ValaLambdaExpression* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_statement_body;
	result = _tmp0_;
	return result;
}


void vala_lambda_expression_set_statement_body (ValaLambdaExpression* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_statement_body);
	self->priv->_statement_body = _tmp1_;
}


ValaMethod* vala_lambda_expression_get_method (ValaLambdaExpression* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}


void vala_lambda_expression_set_method (ValaLambdaExpression* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_method);
	self->priv->_method = _tmp1_;
}


static void vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass) {
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_lambda_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaLambdaExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_lambda_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_lambda_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_lambda_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_lambda_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_lambda_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_lambda_expression_real_get_used_variables;
}


static void vala_lambda_expression_instance_init (ValaLambdaExpression * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_LAMBDA_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void vala_lambda_expression_finalize (ValaCodeNode * obj) {
	ValaLambdaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression);
	_vala_code_node_unref0 (self->priv->_expression_body);
	_vala_code_node_unref0 (self->priv->_statement_body);
	_vala_code_node_unref0 (self->priv->_method);
	_vala_iterable_unref0 (self->priv->parameters);
	VALA_CODE_NODE_CLASS (vala_lambda_expression_parent_class)->finalize (obj);
}


/**
 * Represents a lambda expression in the source code. Lambda expressions are
 * anonymous methods with implicitly typed parameters.
 */
GType vala_lambda_expression_get_type (void) {
	static volatile gsize vala_lambda_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_lambda_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_instance_init, NULL };
		GType vala_lambda_expression_type_id;
		vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_lambda_expression_type_id__volatile, vala_lambda_expression_type_id);
	}
	return vala_lambda_expression_type_id__volatile;
}



