/* list.c generated by valac, the Vala compiler
 * generated from list.vala, do not modify */

/* list.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valagee.h"

#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};


static gpointer vala_list_parent_class = NULL;

#define VALA_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LIST, ValaListPrivate))
static gpointer vala_list_real_get (ValaList* self, gint index);
static void vala_list_real_set (ValaList* self, gint index, gconstpointer item);
static gint vala_list_real_index_of (ValaList* self, gconstpointer item);
static void vala_list_real_insert (ValaList* self, gint index, gconstpointer item);
static gpointer vala_list_real_remove_at (ValaList* self, gint index);
static gpointer vala_list_real_first (ValaList* self);
static gpointer vala_list_real_last (ValaList* self);
static void vala_list_real_insert_all (ValaList* self, gint index, ValaCollection* collection);
static void vala_list_real_sort (ValaList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
G_GNUC_INTERNAL void vala_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaList* list, GCompareDataFunc compare, void* compare_target);


/**
 * Returns the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be returned
 *
 * @return      the item at the specified index in the list
 */
static gpointer vala_list_real_get (ValaList* self, gint index) {
	g_critical ("Type `%s' does not implement abstract method `vala_list_get'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer vala_list_get (ValaList* self, gint index) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_LIST_GET_CLASS (self)->get (self, index);
}


/**
 * Sets the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be set
 */
static void vala_list_real_set (ValaList* self, gint index, gconstpointer item) {
	g_critical ("Type `%s' does not implement abstract method `vala_list_set'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_list_set (ValaList* self, gint index, gconstpointer item) {
	g_return_if_fail (self != NULL);
	VALA_LIST_GET_CLASS (self)->set (self, index, item);
}


/**
 * Returns the index of the first occurrence of the specified item in
 * this list.
 *
 * @return the index of the first occurrence of the specified item, or
 *         -1 if the item could not be found
 */
static gint vala_list_real_index_of (ValaList* self, gconstpointer item) {
	gint _tmp0_ = 0;
	g_critical ("Type `%s' does not implement abstract method `vala_list_index_of'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gint vala_list_index_of (ValaList* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, 0);
	return VALA_LIST_GET_CLASS (self)->index_of (self, item);
}


/**
 * Inserts an item into this list at the specified position.
 *
 * @param index zero-based index at which item is inserted
 * @param item  item to insert into the list
 */
static void vala_list_real_insert (ValaList* self, gint index, gconstpointer item) {
	g_critical ("Type `%s' does not implement abstract method `vala_list_insert'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_list_insert (ValaList* self, gint index, gconstpointer item) {
	g_return_if_fail (self != NULL);
	VALA_LIST_GET_CLASS (self)->insert (self, index, item);
}


/**
 * Removes the item at the specified index of this list.
 *
 * @param index zero-based index of the item to be removed
 *
 * @return      the removed element
 */
static gpointer vala_list_real_remove_at (ValaList* self, gint index) {
	g_critical ("Type `%s' does not implement abstract method `vala_list_remove_at'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gpointer vala_list_remove_at (ValaList* self, gint index) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_LIST_GET_CLASS (self)->remove_at (self, index);
}


/**
 * Returns the first item of the list. Fails if the list is empty.
 *
 * @return      first item in the list
 */
static gpointer vala_list_real_first (ValaList* self) {
	gpointer result = NULL;
	gpointer _tmp0_;
	_tmp0_ = vala_list_get (self, 0);
	result = _tmp0_;
	return result;
}


gpointer vala_list_first (ValaList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_LIST_GET_CLASS (self)->first (self);
}


/**
 * Returns the last item of the list. Fails if the list is empty.
 *
 * @return      last item in the list
 */
static gpointer vala_list_real_last (ValaList* self) {
	gpointer result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
	_tmp0_ = vala_collection_get_size ((ValaCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_list_get (self, _tmp1_ - 1);
	result = _tmp2_;
	return result;
}


gpointer vala_list_last (ValaList* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_LIST_GET_CLASS (self)->last (self);
}


/**
 * Inserts items into this list for the input collection at the
 * specified position.
 *
 * @param index zero-based index of the items to be inserted
 * @param collection collection of items to be inserted
 */
static void vala_list_real_insert_all (ValaList* self, gint index, ValaCollection* collection) {
	g_return_if_fail (collection != NULL);
	{
		ValaIterator* iter = NULL;
		ValaCollection* _tmp0_;
		ValaIterator* _tmp1_;
		_tmp0_ = collection;
		_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
		iter = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaIterator* _tmp3_;
				gboolean _tmp4_;
				gpointer item = NULL;
				ValaIterator* _tmp5_;
				gpointer _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_;
				gint _tmp9_;
				if (!_tmp2_) {
				}
				_tmp2_ = FALSE;
				_tmp3_ = iter;
				_tmp4_ = vala_iterator_next (_tmp3_);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = iter;
				_tmp6_ = vala_iterator_get (_tmp5_);
				item = _tmp6_;
				_tmp7_ = index;
				_tmp8_ = item;
				vala_list_insert (self, _tmp7_, _tmp8_);
				_tmp9_ = index;
				index = _tmp9_ + 1;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			}
		}
		_vala_iterator_unref0 (iter);
	}
}


void vala_list_insert_all (ValaList* self, gint index, ValaCollection* collection) {
	g_return_if_fail (self != NULL);
	VALA_LIST_GET_CLASS (self)->insert_all (self, index, collection);
}


/**
 * Sorts items by comparing with the specified compare function.
 *
 * @param compare_func compare function to use to compare items
 */
static void vala_list_real_sort (ValaList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	GCompareDataFunc _tmp0_;
	void* _tmp0__target;
	_tmp0_ = compare_func;
	_tmp0__target = compare_func_target;
	vala_tim_sort_sort (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, self, _tmp0_, _tmp0__target);
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
}


void vala_list_sort (ValaList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify) {
	g_return_if_fail (self != NULL);
	VALA_LIST_GET_CLASS (self)->sort (self, compare_func, compare_func_target, compare_func_target_destroy_notify);
}


ValaList* vala_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	ValaList* self = NULL;
	self = (ValaList*) vala_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


static void vala_list_class_init (ValaListClass * klass) {
	vala_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaListPrivate));
	((ValaListClass *) klass)->get = (gpointer (*) (ValaList *, gint)) vala_list_real_get;
	((ValaListClass *) klass)->set = (void (*) (ValaList *, gint, gconstpointer)) vala_list_real_set;
	((ValaListClass *) klass)->index_of = (gint (*) (ValaList *, gconstpointer)) vala_list_real_index_of;
	((ValaListClass *) klass)->insert = (void (*) (ValaList *, gint, gconstpointer)) vala_list_real_insert;
	((ValaListClass *) klass)->remove_at = (gpointer (*) (ValaList *, gint)) vala_list_real_remove_at;
	((ValaListClass *) klass)->first = (gpointer (*) (ValaList *)) vala_list_real_first;
	((ValaListClass *) klass)->last = (gpointer (*) (ValaList *)) vala_list_real_last;
	((ValaListClass *) klass)->insert_all = (void (*) (ValaList *, gint, ValaCollection*)) vala_list_real_insert_all;
	((ValaListClass *) klass)->sort = (void (*) (ValaList *, GCompareDataFunc, void*, GDestroyNotify)) vala_list_real_sort;
}


static void vala_list_instance_init (ValaList * self) {
	self->priv = VALA_LIST_GET_PRIVATE (self);
}


/**
 * Represents a collection of items in a well-defined order.
 */
GType vala_list_get_type (void) {
	static volatile gsize vala_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaList), 0, (GInstanceInitFunc) vala_list_instance_init, NULL };
		GType vala_list_type_id;
		vala_list_type_id = g_type_register_static (VALA_TYPE_COLLECTION, "ValaList", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_list_type_id__volatile, vala_list_type_id);
	}
	return vala_list_type_id__volatile;
}



