/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_DELEGATE_0_PROPERTY,
	VALA_DELEGATE_NUM_PROPERTIES
};
static GParamSpec* vala_delegate_properties[VALA_DELEGATE_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaDelegatePrivate {
	ValaDataType* _sender_type;
	ValaList* type_parameters;
	ValaList* parameters;
	ValaDataType* _return_type;
	gboolean* _has_target;
};


static gpointer vala_delegate_parent_class = NULL;
static ValaCallableIface * vala_delegate_vala_callable_parent_iface = NULL;

#define VALA_DELEGATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE, ValaDelegatePrivate))
static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name);
static void vala_delegate_real_add_parameter (ValaCallable* base, ValaParameter* param);
static ValaList* vala_delegate_real_get_parameters (ValaCallable* base);
static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_delegate_finalize (ValaCodeNode * obj);


/**
 * Creates a new delegate.
 *
 * @param name              delegate type name
 * @param return_type       return type
 * @param source_reference  reference to source code
 * @return                  newly created delegate
 */
ValaDelegate* vala_delegate_construct (GType object_type, const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaDelegate* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	ValaDataType* _tmp3_;
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = return_type;
	vala_callable_set_return_type ((ValaCallable*) self, _tmp3_);
	return self;
}


ValaDelegate* vala_delegate_new (const gchar* name, ValaDataType* return_type, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p) {
	ValaList* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaTypeParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaTypeParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = p;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = p;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = p;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_delegate_get_type_parameters (ValaDelegate* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name) {
	ValaDelegate * self;
	gint result = 0;
	gint i = 0;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _parameter_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp5_ = _parameter_index;
			_parameter_index = _tmp5_ + 1;
			_tmp6_ = _parameter_index;
			_tmp7_ = _parameter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _parameter_list;
			_tmp9_ = _parameter_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			parameter = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = parameter;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Appends paramater to this callback function.
 *
 * @param param a formal parameter
 */
static void vala_delegate_real_add_parameter (ValaCallable* base, ValaParameter* param) {
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaParameter* _tmp7_;
	self = (ValaDelegate*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = param;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = param;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = param;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Return copy of parameter list.
 *
 * @return parameter list
 */
static ValaList* vala_delegate_real_get_parameters (ValaCallable* base) {
	ValaDelegate * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m, ValaDataType* dt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ValaMethod* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ValaList* method_params = NULL;
	ValaMethod* _tmp16_;
	ValaList* _tmp17_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp18_;
	ValaIterator* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaDataType* _tmp21_;
	gboolean first = FALSE;
	ValaIterator* _tmp70_;
	gboolean _tmp71_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp1_ = m;
	_tmp2_ = vala_method_get_coroutine (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValaSymbol* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = m;
	_tmp7_ = vala_callable_get_return_type ((ValaCallable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = dt;
	_tmp12_ = vala_data_type_get_actual_type (_tmp10_, _tmp11_, NULL, (ValaCodeNode*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_data_type_stricter (_tmp8_, _tmp13_);
	_tmp15_ = !_tmp14_;
	_vala_code_node_unref0 (_tmp13_);
	if (_tmp15_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = m;
	_tmp17_ = vala_callable_get_parameters ((ValaCallable*) _tmp16_);
	method_params = _tmp17_;
	_tmp18_ = method_params;
	_tmp19_ = vala_iterable_iterator ((ValaIterable*) _tmp18_);
	method_params_it = _tmp19_;
	_tmp21_ = self->priv->_sender_type;
	if (_tmp21_ != NULL) {
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp22_ = method_params;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->parameters;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp20_ = _tmp24_ == (_tmp27_ + 1);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaIterator* _tmp28_;
		ValaParameter* method_param = NULL;
		ValaIterator* _tmp29_;
		gpointer _tmp30_;
		ValaDataType* _tmp31_;
		ValaParameter* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		gboolean _tmp35_;
		_tmp28_ = method_params_it;
		vala_iterator_next (_tmp28_);
		_tmp29_ = method_params_it;
		_tmp30_ = vala_iterator_get (_tmp29_);
		method_param = (ValaParameter*) _tmp30_;
		_tmp31_ = self->priv->_sender_type;
		_tmp32_ = method_param;
		_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_data_type_stricter (_tmp31_, _tmp34_);
		if (!_tmp35_) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _param_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _param_index = 0;
		_tmp36_ = self->priv->parameters;
		_tmp37_ = _vala_iterable_ref0 (_tmp36_);
		_param_list = _tmp37_;
		_tmp38_ = _param_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_param_size = _tmp40_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			ValaParameter* param = NULL;
			ValaList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_;
			gboolean _tmp47_ = FALSE;
			gboolean _tmp48_ = FALSE;
			gboolean _tmp49_;
			ValaIterator* _tmp55_;
			gboolean _tmp56_;
			ValaParameter* method_param = NULL;
			ValaIterator* _tmp57_;
			gpointer _tmp58_;
			ValaParameter* _tmp59_;
			ValaDataType* _tmp60_;
			ValaDataType* _tmp61_;
			ValaDataType* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			ValaParameter* _tmp65_;
			ValaDataType* _tmp66_;
			ValaDataType* _tmp67_;
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp41_ = _param_index;
			_param_index = _tmp41_ + 1;
			_tmp42_ = _param_index;
			_tmp43_ = _param_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _param_list;
			_tmp45_ = _param_index;
			_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
			param = (ValaParameter*) _tmp46_;
			_tmp49_ = first;
			if (_tmp49_) {
				ValaMethod* _tmp50_;
				ValaMemberBinding _tmp51_;
				ValaMemberBinding _tmp52_;
				_tmp50_ = m;
				_tmp51_ = vala_method_get_binding (_tmp50_);
				_tmp52_ = _tmp51_;
				_tmp48_ = _tmp52_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp48_ = FALSE;
			}
			if (_tmp48_) {
				gboolean _tmp53_;
				gboolean _tmp54_;
				_tmp53_ = vala_delegate_get_has_target (self);
				_tmp54_ = _tmp53_;
				_tmp47_ = !_tmp54_;
			} else {
				_tmp47_ = FALSE;
			}
			if (_tmp47_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp55_ = method_params_it;
			_tmp56_ = vala_iterator_next (_tmp55_);
			if (!_tmp56_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp57_ = method_params_it;
			_tmp58_ = vala_iterator_get (_tmp57_);
			method_param = (ValaParameter*) _tmp58_;
			_tmp59_ = param;
			_tmp60_ = vala_variable_get_variable_type ((ValaVariable*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = dt;
			_tmp63_ = vala_data_type_get_actual_type (_tmp61_, _tmp62_, NULL, (ValaCodeNode*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = method_param;
			_tmp66_ = vala_variable_get_variable_type ((ValaVariable*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_data_type_stricter (_tmp64_, _tmp67_);
			_tmp69_ = !_tmp68_;
			_vala_code_node_unref0 (_tmp64_);
			if (_tmp69_) {
				result = FALSE;
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp70_ = method_params_it;
	_tmp71_ = vala_iterator_next (_tmp70_);
	if (_tmp71_) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaMethod* _tmp72_;
		ValaList* _tmp73_;
		gint _method_error_type_size = 0;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _method_error_type_index = 0;
		_tmp72_ = m;
		_tmp73_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp72_);
		_method_error_type_list = _tmp73_;
		_tmp74_ = _method_error_type_list;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_method_error_type_size = _tmp76_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp80_;
			gint _tmp81_;
			gpointer _tmp82_;
			gboolean match = FALSE;
			gboolean _tmp96_;
			_tmp77_ = _method_error_type_index;
			_method_error_type_index = _tmp77_ + 1;
			_tmp78_ = _method_error_type_index;
			_tmp79_ = _method_error_type_size;
			if (!(_tmp78_ < _tmp79_)) {
				break;
			}
			_tmp80_ = _method_error_type_list;
			_tmp81_ = _method_error_type_index;
			_tmp82_ = vala_list_get (_tmp80_, _tmp81_);
			method_error_type = (ValaDataType*) _tmp82_;
			match = FALSE;
			{
				ValaList* _delegate_error_type_list = NULL;
				ValaList* _tmp83_;
				gint _delegate_error_type_size = 0;
				ValaList* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _delegate_error_type_index = 0;
				_tmp83_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
				_delegate_error_type_list = _tmp83_;
				_tmp84_ = _delegate_error_type_list;
				_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
				_tmp86_ = _tmp85_;
				_delegate_error_type_size = _tmp86_;
				_delegate_error_type_index = -1;
				while (TRUE) {
					gint _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					ValaDataType* delegate_error_type = NULL;
					ValaList* _tmp90_;
					gint _tmp91_;
					gpointer _tmp92_;
					ValaDataType* _tmp93_;
					ValaDataType* _tmp94_;
					gboolean _tmp95_;
					_tmp87_ = _delegate_error_type_index;
					_delegate_error_type_index = _tmp87_ + 1;
					_tmp88_ = _delegate_error_type_index;
					_tmp89_ = _delegate_error_type_size;
					if (!(_tmp88_ < _tmp89_)) {
						break;
					}
					_tmp90_ = _delegate_error_type_list;
					_tmp91_ = _delegate_error_type_index;
					_tmp92_ = vala_list_get (_tmp90_, _tmp91_);
					delegate_error_type = (ValaDataType*) _tmp92_;
					_tmp93_ = method_error_type;
					_tmp94_ = delegate_error_type;
					_tmp95_ = vala_data_type_compatible (_tmp93_, _tmp94_);
					if (_tmp95_) {
						match = TRUE;
						_vala_code_node_unref0 (delegate_error_type);
						break;
					}
					_vala_code_node_unref0 (delegate_error_type);
				}
				_vala_iterable_unref0 (_delegate_error_type_list);
			}
			_tmp96_ = match;
			if (!_tmp96_) {
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}


static void vala_delegate_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_delegate (_tmp0_, self);
}


static void vala_delegate_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDelegate * self;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaCodeVisitor* _tmp15_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeParameter* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			p = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp14_, _tmp15_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _param_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _param_index = 0;
		_tmp16_ = self->priv->parameters;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_param_list = _tmp17_;
		_tmp18_ = _param_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_param_size = _tmp20_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			ValaParameter* param = NULL;
			ValaList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			ValaParameter* _tmp27_;
			ValaCodeVisitor* _tmp28_;
			_tmp21_ = _param_index;
			_param_index = _tmp21_ + 1;
			_tmp22_ = _param_index;
			_tmp23_ = _param_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _param_list;
			_tmp25_ = _param_index;
			_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
			param = (ValaParameter*) _tmp26_;
			_tmp27_ = param;
			_tmp28_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp27_, _tmp28_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp29_;
		gint _error_type_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _error_type_index = 0;
		_tmp29_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp29_;
		_tmp30_ = _error_type_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_error_type_size = _tmp32_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_;
			ValaDataType* _tmp39_;
			ValaCodeVisitor* _tmp40_;
			_tmp33_ = _error_type_index;
			_error_type_index = _tmp33_ + 1;
			_tmp34_ = _error_type_index;
			_tmp35_ = _error_type_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _error_type_list;
			_tmp37_ = _error_type_index;
			_tmp38_ = vala_list_get (_tmp36_, _tmp37_);
			error_type = (ValaDataType*) _tmp38_;
			_tmp39_ = error_type;
			_tmp40_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, _tmp40_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
}


static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base) {
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}


static void vala_delegate_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaDelegate * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaList* error_types = NULL;
	ValaList* _tmp4_;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_callable_set_return_type ((ValaCallable*) self, _tmp3_);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				gboolean _tmp16_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = error_types;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = error_types;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = old_type;
				_tmp16_ = _tmp14_ == _tmp15_;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp16_) {
					ValaList* _tmp17_;
					gint _tmp18_;
					ValaDataType* _tmp19_;
					_tmp17_ = error_types;
					_tmp18_ = i;
					_tmp19_ = new_type;
					vala_list_set (_tmp17_, _tmp18_, _tmp19_);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_delegate_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaDelegate * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaCodeContext* _tmp60_;
	ValaSemanticAnalyzer* _tmp61_;
	ValaSemanticAnalyzer* _tmp62_;
	ValaSourceFile* _tmp63_;
	gboolean _tmp64_;
	gboolean _tmp65_;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaCodeContext* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceReference* _tmp16_;
		ValaSourceFile* _tmp17_;
		ValaSourceFile* _tmp18_;
		_tmp12_ = context;
		_tmp13_ = vala_code_context_get_analyzer (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_source_reference_get_file (_tmp16_);
		_tmp18_ = _tmp17_;
		vala_semantic_analyzer_set_current_source_file (_tmp14_, _tmp18_);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _p_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _p_index = 0;
		_tmp19_ = self->priv->type_parameters;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_p_list = _tmp20_;
		_tmp21_ = _p_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_p_size = _tmp23_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaTypeParameter* _tmp30_;
			ValaCodeContext* _tmp31_;
			_tmp24_ = _p_index;
			_p_index = _tmp24_ + 1;
			_tmp25_ = _p_index;
			_tmp26_ = _p_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _p_list;
			_tmp28_ = _p_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			p = (ValaTypeParameter*) _tmp29_;
			_tmp30_ = p;
			_tmp31_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp30_, _tmp31_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp33_, _tmp34_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		gint _param_size = 0;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint _param_index = 0;
		_tmp35_ = self->priv->parameters;
		_tmp36_ = _vala_iterable_ref0 (_tmp35_);
		_param_list = _tmp36_;
		_tmp37_ = _param_list;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_param_size = _tmp39_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			ValaParameter* param = NULL;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaParameter* _tmp46_;
			ValaCodeContext* _tmp47_;
			_tmp40_ = _param_index;
			_param_index = _tmp40_ + 1;
			_tmp41_ = _param_index;
			_tmp42_ = _param_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _param_list;
			_tmp44_ = _param_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			param = (ValaParameter*) _tmp45_;
			_tmp46_ = param;
			_tmp47_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp46_, _tmp47_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp48_;
		gint _error_type_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _error_type_index = 0;
		_tmp48_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp48_;
		_tmp49_ = _error_type_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_error_type_size = _tmp51_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp55_;
			gint _tmp56_;
			gpointer _tmp57_;
			ValaDataType* _tmp58_;
			ValaCodeContext* _tmp59_;
			_tmp52_ = _error_type_index;
			_error_type_index = _tmp52_ + 1;
			_tmp53_ = _error_type_index;
			_tmp54_ = _error_type_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _error_type_list;
			_tmp56_ = _error_type_index;
			_tmp57_ = vala_list_get (_tmp55_, _tmp56_);
			error_type = (ValaDataType*) _tmp57_;
			_tmp58_ = error_type;
			_tmp59_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, _tmp59_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp60_ = context;
	_tmp61_ = vala_code_context_get_analyzer (_tmp60_);
	_tmp62_ = _tmp61_;
	_tmp63_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp62_, _tmp63_);
	_tmp64_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp65_ = _tmp64_;
	result = !_tmp65_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static ValaDataType* vala_delegate_real_get_return_type (ValaCallable* base) {
	ValaDataType* result;
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_delegate_real_set_return_type (ValaCallable* base, ValaDataType* value) {
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaDelegate*) base;
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp1_;
	_tmp2_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_delegate_get_has_target (ValaDelegate* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_target;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_has_target);
		self->priv->_has_target = _tmp2_;
	}
	_tmp3_ = self->priv->_has_target;
	result = *_tmp3_;
	return result;
}


void vala_delegate_set_has_target (ValaDelegate* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_has_target);
	self->priv->_has_target = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_) {
		vala_code_node_remove_attribute_argument ((ValaCodeNode*) self, "CCode", "has_target");
	} else {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", FALSE, NULL);
	}
}


ValaDataType* vala_delegate_get_sender_type (ValaDelegate* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sender_type;
	result = _tmp0_;
	return result;
}


void vala_delegate_set_sender_type (ValaDelegate* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp1_;
}


static void vala_delegate_class_init (ValaDelegateClass * klass) {
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_delegate_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegatePrivate));
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol *, const gchar*)) vala_delegate_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_delegate_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_delegate_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_delegate_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_delegate_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_delegate_real_check;
}


static void vala_delegate_vala_callable_interface_init (ValaCallableIface * iface) {
	vala_delegate_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable *, ValaParameter*)) vala_delegate_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable *)) vala_delegate_real_get_parameters;
	iface->get_return_type = vala_delegate_real_get_return_type;
	iface->set_return_type = vala_delegate_real_set_return_type;
}


static void vala_delegate_instance_init (ValaDelegate * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_DELEGATE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->parameters = (ValaList*) _tmp3_;
}


static void vala_delegate_finalize (ValaCodeNode * obj) {
	ValaDelegate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DELEGATE, ValaDelegate);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_has_target);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}


/**
 * Represents a function callback type.
 */
GType vala_delegate_get_type (void) {
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_delegate_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_type_add_interface_static (vala_delegate_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}



