/* valaassignment.c generated by valac, the Vala compiler
 * generated from valaassignment.vala, do not modify */

/* valaassignment.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>

enum  {
	VALA_ASSIGNMENT_0_PROPERTY,
	VALA_ASSIGNMENT_NUM_PROPERTIES
};
static GParamSpec* vala_assignment_properties[VALA_ASSIGNMENT_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaAssignmentPrivate {
	ValaAssignmentOperator _operator;
	ValaExpression* _left;
	ValaExpression* _right;
};


static gpointer vala_assignment_parent_class = NULL;

#define VALA_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ASSIGNMENT, ValaAssignmentPrivate))
static void vala_assignment_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_assignment_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_assignment_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_assignment_real_is_pure (ValaExpression* base);
static gboolean vala_assignment_real_is_accessible (ValaExpression* base, ValaSymbol* sym);
static gboolean vala_assignment_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean vala_assignment_is_array_add (ValaAssignment* self);
static void vala_assignment_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_assignment_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection);
static void vala_assignment_finalize (ValaCodeNode * obj);


/**
 * Creates a new assignment.
 *
 * @param left             left hand side
 * @param operator         assignment operator
 * @param right            right hand side
 * @param source_reference reference to source code
 * @return                 newly created assignment
 */
ValaAssignment* vala_assignment_construct (GType object_type, ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference) {
	ValaAssignment* self = NULL;
	ValaExpression* _tmp0_;
	ValaAssignmentOperator _tmp1_;
	ValaSourceReference* _tmp2_;
	ValaExpression* _tmp3_;
	g_return_val_if_fail (left != NULL, NULL);
	g_return_val_if_fail (right != NULL, NULL);
	self = (ValaAssignment*) vala_expression_construct (object_type);
	_tmp0_ = right;
	vala_assignment_set_right (self, _tmp0_);
	_tmp1_ = operator;
	vala_assignment_set_operator (self, _tmp1_);
	_tmp2_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	_tmp3_ = left;
	vala_assignment_set_left (self, _tmp3_);
	return self;
}


ValaAssignment* vala_assignment_new (ValaExpression* left, ValaExpression* right, ValaAssignmentOperator operator, ValaSourceReference* source_reference) {
	return vala_assignment_construct (VALA_TYPE_ASSIGNMENT, left, right, operator, source_reference);
}


static void vala_assignment_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAssignment * self;
	ValaCodeVisitor* _tmp0_;
	ValaCodeVisitor* _tmp1_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_assignment (_tmp0_, self);
	_tmp1_ = visitor;
	vala_code_visitor_visit_expression (_tmp1_, (ValaExpression*) self);
}


static void vala_assignment_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCodeVisitor* _tmp5_;
	self = (ValaAssignment*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_assignment_get_right (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp4_, _tmp5_);
}


static void vala_assignment_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	self = (ValaAssignment*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_assignment_set_left (self, _tmp3_);
	}
	_tmp4_ = vala_assignment_get_right (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = old_node;
	if (_tmp5_ == _tmp6_) {
		ValaExpression* _tmp7_;
		_tmp7_ = new_node;
		vala_assignment_set_right (self, _tmp7_);
	}
}


static gboolean vala_assignment_real_is_pure (ValaExpression* base) {
	ValaAssignment * self;
	gboolean result = FALSE;
	self = (ValaAssignment*) base;
	result = FALSE;
	return result;
}


static gboolean vala_assignment_real_is_accessible (ValaExpression* base, ValaSymbol* sym) {
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_assignment_get_left (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sym;
	_tmp4_ = vala_expression_is_accessible (_tmp2_, _tmp3_);
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_assignment_get_right (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = sym;
		_tmp8_ = vala_expression_is_accessible (_tmp6_, _tmp7_);
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_assignment_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaAssignment * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp103_;
	ValaExpression* _tmp104_;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	ValaCodeContext* _tmp107_;
	gboolean _tmp108_;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaExpression* _tmp322_;
	ValaExpression* _tmp323_;
	ValaCodeContext* _tmp324_;
	gboolean _tmp325_;
	gboolean _tmp326_ = FALSE;
	ValaAssignmentOperator _tmp327_;
	ValaExpression* _tmp390_;
	ValaExpression* _tmp391_;
	ValaSymbol* _tmp392_;
	ValaSymbol* _tmp393_;
	ValaExpression* _tmp847_;
	ValaExpression* _tmp848_;
	ValaDataType* _tmp849_;
	ValaDataType* _tmp850_;
	ValaExpression* _tmp859_;
	ValaExpression* _tmp860_;
	ValaList* _tmp861_;
	ValaList* _tmp862_;
	ValaExpression* _tmp863_;
	ValaExpression* _tmp864_;
	ValaList* _tmp865_;
	ValaList* _tmp866_;
	gboolean _tmp867_;
	gboolean _tmp868_;
	self = (ValaAssignment*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_TUPLE)) {
		ValaAssignmentOperator _tmp8_;
		_tmp8_ = self->priv->_operator;
		_tmp5_ = _tmp8_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaCodeNode* _tmp9_;
		ValaCodeNode* _tmp10_;
		_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_EXPRESSION_STATEMENT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaTuple* tuple = NULL;
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaTuple* _tmp13_;
		ValaLocalVariable* local = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaDeclarationStatement* _tmp27_;
		ValaDeclarationStatement* _tmp28_;
		ValaCodeContext* _tmp29_;
		ValaCodeContext* _tmp30_;
		ValaSemanticAnalyzer* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaBlock* _tmp33_;
		ValaDeclarationStatement* _tmp34_;
		gint i = 0;
		ValaExpressionStatement* stmt = NULL;
		ValaCodeContext* _tmp89_;
		ValaSemanticAnalyzer* _tmp90_;
		ValaSemanticAnalyzer* _tmp91_;
		ValaList* _tmp92_;
		ValaCodeNode* _tmp93_;
		ValaCodeNode* _tmp94_;
		ValaExpressionStatement* _tmp95_;
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaExpressionStatement* _tmp98_;
		ValaExpression* _tmp99_;
		ValaExpression* _tmp100_;
		ValaCodeContext* _tmp101_;
		gboolean _tmp102_;
		_tmp11_ = vala_assignment_get_left (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TUPLE, ValaTuple));
		tuple = _tmp13_;
		_tmp14_ = vala_code_node_get_temp_name ();
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_assignment_get_right (self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_assignment_get_right (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_local_variable_new (NULL, _tmp15_, _tmp17_, _tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp15_);
		local = _tmp23_;
		_tmp24_ = local;
		_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_declaration_statement_new ((ValaSymbol*) _tmp24_, _tmp26_);
		decl = _tmp27_;
		_tmp28_ = decl;
		_tmp29_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, _tmp29_);
		_tmp30_ = context;
		_tmp31_ = vala_code_context_get_analyzer (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->insert_block;
		_tmp34_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp33_, (ValaStatement*) _tmp34_);
		i = 0;
		stmt = NULL;
		{
			ValaList* _expr_list = NULL;
			ValaTuple* _tmp35_;
			ValaList* _tmp36_;
			gint _expr_size = 0;
			ValaList* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gint _expr_index = 0;
			_tmp35_ = tuple;
			_tmp36_ = vala_tuple_get_expressions (_tmp35_);
			_expr_list = _tmp36_;
			_tmp37_ = _expr_list;
			_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			_expr_size = _tmp39_;
			_expr_index = -1;
			while (TRUE) {
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				ValaExpression* expr = NULL;
				ValaList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				ValaExpressionStatement* _tmp46_;
				ValaMemberAccess* temp_access = NULL;
				ValaLocalVariable* _tmp54_;
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				ValaExpression* _tmp57_;
				ValaExpression* _tmp58_;
				ValaSourceReference* _tmp59_;
				ValaSourceReference* _tmp60_;
				ValaMemberAccess* _tmp61_;
				ValaElementAccess* ea = NULL;
				ValaMemberAccess* _tmp62_;
				ValaExpression* _tmp63_;
				ValaSourceReference* _tmp64_;
				ValaSourceReference* _tmp65_;
				ValaElementAccess* _tmp66_;
				ValaElementAccess* _tmp67_;
				gint _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				ValaExpression* _tmp71_;
				ValaSourceReference* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaIntegerLiteral* _tmp74_;
				ValaIntegerLiteral* _tmp75_;
				ValaAssignment* assign = NULL;
				ValaExpression* _tmp76_;
				ValaElementAccess* _tmp77_;
				ValaAssignmentOperator _tmp78_;
				ValaExpression* _tmp79_;
				ValaSourceReference* _tmp80_;
				ValaSourceReference* _tmp81_;
				ValaAssignment* _tmp82_;
				ValaAssignment* _tmp83_;
				ValaExpression* _tmp84_;
				ValaSourceReference* _tmp85_;
				ValaSourceReference* _tmp86_;
				ValaExpressionStatement* _tmp87_;
				gint _tmp88_;
				_tmp40_ = _expr_index;
				_expr_index = _tmp40_ + 1;
				_tmp41_ = _expr_index;
				_tmp42_ = _expr_size;
				if (!(_tmp41_ < _tmp42_)) {
					break;
				}
				_tmp43_ = _expr_list;
				_tmp44_ = _expr_index;
				_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
				expr = (ValaExpression*) _tmp45_;
				_tmp46_ = stmt;
				if (_tmp46_ != NULL) {
					ValaExpressionStatement* _tmp47_;
					ValaCodeContext* _tmp48_;
					ValaCodeContext* _tmp49_;
					ValaSemanticAnalyzer* _tmp50_;
					ValaSemanticAnalyzer* _tmp51_;
					ValaBlock* _tmp52_;
					ValaExpressionStatement* _tmp53_;
					_tmp47_ = stmt;
					_tmp48_ = context;
					vala_code_node_check ((ValaCodeNode*) _tmp47_, _tmp48_);
					_tmp49_ = context;
					_tmp50_ = vala_code_context_get_analyzer (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _tmp51_->insert_block;
					_tmp53_ = stmt;
					vala_expression_insert_statement ((ValaExpression*) self, _tmp52_, (ValaStatement*) _tmp53_);
				}
				_tmp54_ = local;
				_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_assignment_get_right (self);
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_member_access_new_simple (_tmp56_, _tmp60_);
				temp_access = _tmp61_;
				_tmp62_ = temp_access;
				_tmp63_ = expr;
				_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = vala_element_access_new ((ValaExpression*) _tmp62_, _tmp65_);
				ea = _tmp66_;
				_tmp67_ = ea;
				_tmp68_ = i;
				_tmp69_ = g_strdup_printf ("%i", _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = expr;
				_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_integer_literal_new (_tmp70_, _tmp73_);
				_tmp75_ = _tmp74_;
				vala_element_access_append_index (_tmp67_, (ValaExpression*) _tmp75_);
				_vala_code_node_unref0 (_tmp75_);
				_g_free0 (_tmp70_);
				_tmp76_ = expr;
				_tmp77_ = ea;
				_tmp78_ = self->priv->_operator;
				_tmp79_ = expr;
				_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = vala_assignment_new (_tmp76_, (ValaExpression*) _tmp77_, _tmp78_, _tmp81_);
				assign = _tmp82_;
				_tmp83_ = assign;
				_tmp84_ = expr;
				_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = vala_expression_statement_new ((ValaExpression*) _tmp83_, _tmp86_);
				_vala_code_node_unref0 (stmt);
				stmt = _tmp87_;
				_tmp88_ = i;
				i = _tmp88_ + 1;
				_vala_code_node_unref0 (assign);
				_vala_code_node_unref0 (ea);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (expr);
			}
			_vala_iterable_unref0 (_expr_list);
		}
		_tmp89_ = context;
		_tmp90_ = vala_code_context_get_analyzer (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = _tmp91_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp92_, (ValaCodeNode*) self);
		_tmp93_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp94_ = _tmp93_;
		_tmp95_ = stmt;
		_tmp96_ = vala_expression_statement_get_expression (_tmp95_);
		_tmp97_ = _tmp96_;
		vala_code_node_replace_expression (_tmp94_, (ValaExpression*) self, _tmp97_);
		_tmp98_ = stmt;
		_tmp99_ = vala_expression_statement_get_expression (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = context;
		_tmp102_ = vala_code_node_check ((ValaCodeNode*) _tmp100_, _tmp101_);
		result = _tmp102_;
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (tuple);
		return result;
	}
	_tmp103_ = vala_assignment_get_left (self);
	_tmp104_ = _tmp103_;
	vala_expression_set_lvalue (_tmp104_, TRUE);
	_tmp105_ = vala_assignment_get_left (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = context;
	_tmp108_ = vala_code_node_check ((ValaCodeNode*) _tmp106_, _tmp107_);
	if (!_tmp108_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp109_ = vala_assignment_get_left (self);
	_tmp110_ = _tmp109_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		ValaMemberAccess* _tmp113_;
		ValaMemberAccess* _tmp114_;
		ValaSymbol* _tmp115_;
		ValaSymbol* _tmp116_;
		gboolean _tmp119_ = FALSE;
		gboolean _tmp120_ = FALSE;
		gboolean _tmp121_ = FALSE;
		ValaMemberAccess* _tmp122_;
		ValaSymbol* _tmp123_;
		ValaSymbol* _tmp124_;
		ValaMemberAccess* _tmp145_;
		gboolean _tmp146_;
		gboolean _tmp147_;
		gboolean _tmp157_ = FALSE;
		ValaMemberAccess* _tmp158_;
		gboolean _tmp159_;
		gboolean _tmp160_;
		ValaMemberAccess* _tmp164_;
		ValaSymbol* _tmp165_;
		ValaSymbol* _tmp166_;
		_tmp111_ = vala_assignment_get_left (self);
		_tmp112_ = _tmp111_;
		_tmp113_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp113_;
		_tmp114_ = ma;
		_tmp115_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp114_);
		_tmp116_ = _tmp115_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp116_, VALA_TYPE_CONSTANT)) {
			ValaSourceReference* _tmp117_;
			ValaSourceReference* _tmp118_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp118_ = _tmp117_;
			vala_report_error (_tmp118_, "Assignment to constant after initialization");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp122_ = ma;
		_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp122_);
		_tmp124_ = _tmp123_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp124_, VALA_TYPE_SIGNAL)) {
			_tmp121_ = TRUE;
		} else {
			ValaMemberAccess* _tmp125_;
			ValaSymbol* _tmp126_;
			ValaSymbol* _tmp127_;
			_tmp125_ = ma;
			_tmp126_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp121_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp127_, VALA_TYPE_DYNAMIC_PROPERTY);
		}
		if (!_tmp121_) {
			ValaMemberAccess* _tmp128_;
			ValaDataType* _tmp129_;
			ValaDataType* _tmp130_;
			_tmp128_ = ma;
			_tmp129_ = vala_expression_get_value_type ((ValaExpression*) _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp120_ = _tmp130_ == NULL;
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			_tmp119_ = TRUE;
		} else {
			gboolean _tmp131_ = FALSE;
			gboolean _tmp132_ = FALSE;
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			if (_tmp135_ == NULL) {
				ValaMemberAccess* _tmp136_;
				const gchar* _tmp137_;
				const gchar* _tmp138_;
				_tmp136_ = ma;
				_tmp137_ = vala_member_access_get_member_name (_tmp136_);
				_tmp138_ = _tmp137_;
				_tmp132_ = g_strcmp0 (_tmp138_, "this") == 0;
			} else {
				_tmp132_ = FALSE;
			}
			if (_tmp132_) {
				ValaCodeContext* _tmp139_;
				ValaSemanticAnalyzer* _tmp140_;
				ValaSemanticAnalyzer* _tmp141_;
				gboolean _tmp142_;
				_tmp139_ = context;
				_tmp140_ = vala_code_context_get_analyzer (_tmp139_);
				_tmp141_ = _tmp140_;
				_tmp142_ = vala_semantic_analyzer_is_in_instance_method (_tmp141_);
				_tmp131_ = _tmp142_;
			} else {
				_tmp131_ = FALSE;
			}
			_tmp119_ = _tmp131_;
		}
		if (_tmp119_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp144_, "unsupported lvalue in assignment");
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp145_ = ma;
		_tmp146_ = vala_member_access_get_prototype_access (_tmp145_);
		_tmp147_ = _tmp146_;
		if (_tmp147_) {
			ValaSourceReference* _tmp148_;
			ValaSourceReference* _tmp149_;
			ValaMemberAccess* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp148_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp149_ = _tmp148_;
			_tmp150_ = ma;
			_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_symbol_get_full_name (_tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp154_);
			_tmp156_ = _tmp155_;
			vala_report_error (_tmp149_, _tmp156_);
			_g_free0 (_tmp156_);
			_g_free0 (_tmp154_);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp158_ = ma;
		_tmp159_ = vala_code_node_get_error ((ValaCodeNode*) _tmp158_);
		_tmp160_ = _tmp159_;
		if (_tmp160_) {
			_tmp157_ = TRUE;
		} else {
			ValaMemberAccess* _tmp161_;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			_tmp161_ = ma;
			_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp161_);
			_tmp163_ = _tmp162_;
			_tmp157_ = _tmp163_ == NULL;
		}
		if (_tmp157_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (ma);
			return result;
		}
		_tmp164_ = ma;
		_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp164_);
		_tmp166_ = _tmp165_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_DYNAMIC_SIGNAL)) {
			ValaCodeContext* _tmp167_;
			gboolean _tmp168_;
			gboolean _tmp169_;
			_tmp167_ = context;
			_tmp168_ = vala_code_context_get_deprecated (_tmp167_);
			_tmp169_ = _tmp168_;
			if (!_tmp169_) {
				ValaSourceReference* _tmp170_;
				ValaSourceReference* _tmp171_;
				_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp171_ = _tmp170_;
				vala_report_warning (_tmp171_, "deprecated syntax, use `connect' method instead");
			}
		} else {
			ValaMemberAccess* _tmp172_;
			ValaSymbol* _tmp173_;
			ValaSymbol* _tmp174_;
			_tmp172_ = ma;
			_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp172_);
			_tmp174_ = _tmp173_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp174_, VALA_TYPE_SIGNAL)) {
				ValaCodeContext* _tmp175_;
				gboolean _tmp176_;
				gboolean _tmp177_;
				ValaSignal* sig = NULL;
				ValaMemberAccess* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				ValaSignal* _tmp183_;
				ValaExpression* _tmp184_;
				ValaExpression* _tmp185_;
				ValaSignal* _tmp186_;
				ValaMemberAccess* _tmp187_;
				ValaExpression* _tmp188_;
				ValaExpression* _tmp189_;
				ValaDataType* _tmp190_;
				ValaDataType* _tmp191_;
				ValaDelegate* _tmp192_;
				ValaDelegate* _tmp193_;
				ValaDelegateType* _tmp194_;
				ValaDelegateType* _tmp195_;
				_tmp175_ = context;
				_tmp176_ = vala_code_context_get_deprecated (_tmp175_);
				_tmp177_ = _tmp176_;
				if (!_tmp177_) {
					ValaSourceReference* _tmp178_;
					ValaSourceReference* _tmp179_;
					_tmp178_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp179_ = _tmp178_;
					vala_report_warning (_tmp179_, "deprecated syntax, use `connect' method instead");
				}
				_tmp180_ = ma;
				_tmp181_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp183_;
				_tmp184_ = vala_assignment_get_right (self);
				_tmp185_ = _tmp184_;
				_tmp186_ = sig;
				_tmp187_ = ma;
				_tmp188_ = vala_member_access_get_inner (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = vala_expression_get_value_type (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = vala_signal_get_delegate (_tmp186_, _tmp191_, (ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_delegate_type_new (_tmp193_);
				_tmp195_ = _tmp194_;
				vala_expression_set_target_type (_tmp185_, (ValaDataType*) _tmp195_);
				_vala_code_node_unref0 (_tmp195_);
				_vala_code_node_unref0 (_tmp193_);
				_vala_code_node_unref0 (sig);
			} else {
				ValaMemberAccess* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp196_ = ma;
				_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp196_);
				_tmp198_ = _tmp197_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_DYNAMIC_PROPERTY)) {
				} else {
					ValaExpression* _tmp199_;
					ValaExpression* _tmp200_;
					ValaMemberAccess* _tmp201_;
					ValaDataType* _tmp202_;
					ValaDataType* _tmp203_;
					ValaDataType* _tmp204_;
					ValaDataType* _tmp205_;
					ValaExpression* _tmp206_;
					ValaExpression* _tmp207_;
					ValaMemberAccess* _tmp208_;
					ValaDataType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					ValaDataType* _tmp212_;
					_tmp199_ = vala_assignment_get_right (self);
					_tmp200_ = _tmp199_;
					_tmp201_ = ma;
					_tmp202_ = vala_expression_get_formal_value_type ((ValaExpression*) _tmp201_);
					_tmp203_ = _tmp202_;
					_tmp204_ = vala_data_type_copy (_tmp203_);
					_tmp205_ = _tmp204_;
					vala_expression_set_formal_target_type (_tmp200_, _tmp205_);
					_vala_code_node_unref0 (_tmp205_);
					_tmp206_ = vala_assignment_get_right (self);
					_tmp207_ = _tmp206_;
					_tmp208_ = ma;
					_tmp209_ = vala_expression_get_value_type ((ValaExpression*) _tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_data_type_copy (_tmp210_);
					_tmp212_ = _tmp211_;
					vala_expression_set_target_type (_tmp207_, _tmp212_);
					_vala_code_node_unref0 (_tmp212_);
				}
			}
		}
		_vala_code_node_unref0 (ma);
	} else {
		ValaExpression* _tmp213_;
		ValaExpression* _tmp214_;
		_tmp213_ = vala_assignment_get_left (self);
		_tmp214_ = _tmp213_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, VALA_TYPE_ELEMENT_ACCESS)) {
			ValaElementAccess* ea = NULL;
			ValaExpression* _tmp215_;
			ValaExpression* _tmp216_;
			ValaElementAccess* _tmp217_;
			ValaElementAccess* _tmp218_;
			ValaExpression* _tmp219_;
			ValaExpression* _tmp220_;
			ValaDataType* _tmp221_;
			ValaDataType* _tmp222_;
			ValaTypeSymbol* _tmp223_;
			ValaTypeSymbol* _tmp224_;
			ValaCodeContext* _tmp225_;
			ValaSemanticAnalyzer* _tmp226_;
			ValaSemanticAnalyzer* _tmp227_;
			ValaDataType* _tmp228_;
			ValaTypeSymbol* _tmp229_;
			ValaTypeSymbol* _tmp230_;
			_tmp215_ = vala_assignment_get_left (self);
			_tmp216_ = _tmp215_;
			_tmp217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp216_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
			ea = _tmp217_;
			_tmp218_ = ea;
			_tmp219_ = vala_element_access_get_container (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp221_ = vala_expression_get_value_type (_tmp220_);
			_tmp222_ = _tmp221_;
			_tmp223_ = vala_data_type_get_data_type (_tmp222_);
			_tmp224_ = _tmp223_;
			_tmp225_ = context;
			_tmp226_ = vala_code_context_get_analyzer (_tmp225_);
			_tmp227_ = _tmp226_;
			_tmp228_ = _tmp227_->string_type;
			_tmp229_ = vala_data_type_get_data_type (_tmp228_);
			_tmp230_ = _tmp229_;
			if (_tmp224_ == _tmp230_) {
				ValaElementAccess* _tmp231_;
				ValaSourceReference* _tmp232_;
				ValaSourceReference* _tmp233_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp231_ = ea;
				_tmp232_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp231_);
				_tmp233_ = _tmp232_;
				vala_report_error (_tmp233_, "strings are immutable");
				result = FALSE;
				_vala_code_node_unref0 (ea);
				return result;
			} else {
				gboolean _tmp234_ = FALSE;
				ValaElementAccess* _tmp235_;
				ValaExpression* _tmp236_;
				ValaExpression* _tmp237_;
				_tmp235_ = ea;
				_tmp236_ = vala_element_access_get_container (_tmp235_);
				_tmp237_ = _tmp236_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp237_, VALA_TYPE_MEMBER_ACCESS)) {
					ValaElementAccess* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSymbol* _tmp241_;
					ValaSymbol* _tmp242_;
					_tmp238_ = ea;
					_tmp239_ = vala_element_access_get_container (_tmp238_);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp234_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, VALA_TYPE_SIGNAL);
				} else {
					_tmp234_ = FALSE;
				}
				if (_tmp234_) {
					ValaMemberAccess* ma = NULL;
					ValaElementAccess* _tmp243_;
					ValaExpression* _tmp244_;
					ValaExpression* _tmp245_;
					ValaMemberAccess* _tmp246_;
					ValaSignal* sig = NULL;
					ValaElementAccess* _tmp247_;
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					ValaSymbol* _tmp250_;
					ValaSymbol* _tmp251_;
					ValaSignal* _tmp252_;
					ValaExpression* _tmp253_;
					ValaExpression* _tmp254_;
					ValaSignal* _tmp255_;
					ValaMemberAccess* _tmp256_;
					ValaExpression* _tmp257_;
					ValaExpression* _tmp258_;
					ValaDataType* _tmp259_;
					ValaDataType* _tmp260_;
					ValaDelegate* _tmp261_;
					ValaDelegate* _tmp262_;
					ValaDelegateType* _tmp263_;
					ValaDelegateType* _tmp264_;
					_tmp243_ = ea;
					_tmp244_ = vala_element_access_get_container (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp245_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
					ma = _tmp246_;
					_tmp247_ = ea;
					_tmp248_ = vala_element_access_get_container (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp251_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp252_;
					_tmp253_ = vala_assignment_get_right (self);
					_tmp254_ = _tmp253_;
					_tmp255_ = sig;
					_tmp256_ = ma;
					_tmp257_ = vala_member_access_get_inner (_tmp256_);
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_expression_get_value_type (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = vala_signal_get_delegate (_tmp255_, _tmp260_, (ValaCodeNode*) self);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_delegate_type_new (_tmp262_);
					_tmp264_ = _tmp263_;
					vala_expression_set_target_type (_tmp254_, (ValaDataType*) _tmp264_);
					_vala_code_node_unref0 (_tmp264_);
					_vala_code_node_unref0 (_tmp262_);
					_vala_code_node_unref0 (sig);
					_vala_code_node_unref0 (ma);
				} else {
					ValaElementAccess* _tmp265_;
					ValaExpression* _tmp266_;
					ValaExpression* _tmp267_;
					ValaDataType* _tmp268_;
					ValaDataType* _tmp269_;
					ValaSymbol* _tmp270_;
					ValaSymbol* _tmp271_;
					gboolean _tmp272_;
					_tmp265_ = ea;
					_tmp266_ = vala_element_access_get_container (_tmp265_);
					_tmp267_ = _tmp266_;
					_tmp268_ = vala_expression_get_value_type (_tmp267_);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_data_type_get_member (_tmp269_, "set");
					_tmp271_ = _tmp270_;
					_tmp272_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp271_, VALA_TYPE_METHOD);
					_vala_code_node_unref0 (_tmp271_);
					if (_tmp272_) {
						ValaMethodCall* set_call = NULL;
						ValaElementAccess* _tmp273_;
						ValaExpression* _tmp274_;
						ValaExpression* _tmp275_;
						ValaSourceReference* _tmp276_;
						ValaSourceReference* _tmp277_;
						ValaMemberAccess* _tmp278_;
						ValaMemberAccess* _tmp279_;
						ValaSourceReference* _tmp280_;
						ValaSourceReference* _tmp281_;
						ValaMethodCall* _tmp282_;
						ValaMethodCall* _tmp283_;
						ValaMethodCall* _tmp297_;
						ValaExpression* _tmp298_;
						ValaExpression* _tmp299_;
						ValaCodeNode* _tmp300_;
						ValaCodeNode* _tmp301_;
						ValaMethodCall* _tmp302_;
						ValaMethodCall* _tmp303_;
						ValaCodeContext* _tmp304_;
						gboolean _tmp305_;
						_tmp273_ = ea;
						_tmp274_ = vala_element_access_get_container (_tmp273_);
						_tmp275_ = _tmp274_;
						_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp277_ = _tmp276_;
						_tmp278_ = vala_member_access_new (_tmp275_, "set", _tmp277_);
						_tmp279_ = _tmp278_;
						_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp281_ = _tmp280_;
						_tmp282_ = vala_method_call_new ((ValaExpression*) _tmp279_, _tmp281_);
						_tmp283_ = _tmp282_;
						_vala_code_node_unref0 (_tmp279_);
						set_call = _tmp283_;
						{
							ValaList* _e_list = NULL;
							ValaElementAccess* _tmp284_;
							ValaList* _tmp285_;
							gint _e_size = 0;
							ValaList* _tmp286_;
							gint _tmp287_;
							gint _tmp288_;
							gint _e_index = 0;
							_tmp284_ = ea;
							_tmp285_ = vala_element_access_get_indices (_tmp284_);
							_e_list = _tmp285_;
							_tmp286_ = _e_list;
							_tmp287_ = vala_collection_get_size ((ValaCollection*) _tmp286_);
							_tmp288_ = _tmp287_;
							_e_size = _tmp288_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp289_;
								gint _tmp290_;
								gint _tmp291_;
								ValaExpression* e = NULL;
								ValaList* _tmp292_;
								gint _tmp293_;
								gpointer _tmp294_;
								ValaMethodCall* _tmp295_;
								ValaExpression* _tmp296_;
								_tmp289_ = _e_index;
								_e_index = _tmp289_ + 1;
								_tmp290_ = _e_index;
								_tmp291_ = _e_size;
								if (!(_tmp290_ < _tmp291_)) {
									break;
								}
								_tmp292_ = _e_list;
								_tmp293_ = _e_index;
								_tmp294_ = vala_list_get (_tmp292_, _tmp293_);
								e = (ValaExpression*) _tmp294_;
								_tmp295_ = set_call;
								_tmp296_ = e;
								vala_method_call_add_argument (_tmp295_, _tmp296_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp297_ = set_call;
						_tmp298_ = vala_assignment_get_right (self);
						_tmp299_ = _tmp298_;
						vala_method_call_add_argument (_tmp297_, _tmp299_);
						_tmp300_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp301_ = _tmp300_;
						_tmp302_ = set_call;
						vala_code_node_replace_expression (_tmp301_, (ValaExpression*) self, (ValaExpression*) _tmp302_);
						_tmp303_ = set_call;
						_tmp304_ = context;
						_tmp305_ = vala_code_node_check ((ValaCodeNode*) _tmp303_, _tmp304_);
						result = _tmp305_;
						_vala_code_node_unref0 (set_call);
						_vala_code_node_unref0 (ea);
						return result;
					} else {
						ValaExpression* _tmp306_;
						ValaExpression* _tmp307_;
						ValaExpression* _tmp308_;
						ValaExpression* _tmp309_;
						ValaDataType* _tmp310_;
						ValaDataType* _tmp311_;
						_tmp306_ = vala_assignment_get_right (self);
						_tmp307_ = _tmp306_;
						_tmp308_ = vala_assignment_get_left (self);
						_tmp309_ = _tmp308_;
						_tmp310_ = vala_expression_get_value_type (_tmp309_);
						_tmp311_ = _tmp310_;
						vala_expression_set_target_type (_tmp307_, _tmp311_);
					}
				}
			}
			_vala_code_node_unref0 (ea);
		} else {
			ValaExpression* _tmp312_;
			ValaExpression* _tmp313_;
			_tmp312_ = vala_assignment_get_left (self);
			_tmp313_ = _tmp312_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp313_, VALA_TYPE_POINTER_INDIRECTION)) {
				ValaExpression* _tmp314_;
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				_tmp314_ = vala_assignment_get_right (self);
				_tmp315_ = _tmp314_;
				_tmp316_ = vala_assignment_get_left (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_expression_get_value_type (_tmp317_);
				_tmp319_ = _tmp318_;
				vala_expression_set_target_type (_tmp315_, _tmp319_);
			} else {
				ValaSourceReference* _tmp320_;
				ValaSourceReference* _tmp321_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp321_ = _tmp320_;
				vala_report_error (_tmp321_, "unsupported lvalue in assignment");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp322_ = vala_assignment_get_right (self);
	_tmp323_ = _tmp322_;
	_tmp324_ = context;
	_tmp325_ = vala_code_node_check ((ValaCodeNode*) _tmp323_, _tmp324_);
	if (!_tmp325_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp327_ = self->priv->_operator;
	if (_tmp327_ != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
		ValaExpression* _tmp328_;
		ValaExpression* _tmp329_;
		_tmp328_ = vala_assignment_get_left (self);
		_tmp329_ = _tmp328_;
		_tmp326_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp329_, VALA_TYPE_MEMBER_ACCESS);
	} else {
		_tmp326_ = FALSE;
	}
	if (_tmp326_) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp330_;
		ValaExpression* _tmp331_;
		ValaMemberAccess* _tmp332_;
		ValaMemberAccess* _tmp333_;
		ValaSymbol* _tmp334_;
		ValaSymbol* _tmp335_;
		_tmp330_ = vala_assignment_get_left (self);
		_tmp331_ = _tmp330_;
		_tmp332_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		ma = _tmp332_;
		_tmp333_ = ma;
		_tmp334_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp333_);
		_tmp335_ = _tmp334_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_SIGNAL)) {
			ValaMemberAccess* old_value = NULL;
			ValaMemberAccess* _tmp336_;
			ValaExpression* _tmp337_;
			ValaExpression* _tmp338_;
			ValaMemberAccess* _tmp339_;
			const gchar* _tmp340_;
			const gchar* _tmp341_;
			ValaMemberAccess* _tmp342_;
			ValaBinaryExpression* bin = NULL;
			ValaMemberAccess* _tmp343_;
			ValaExpression* _tmp344_;
			ValaExpression* _tmp345_;
			ValaSourceReference* _tmp346_;
			ValaSourceReference* _tmp347_;
			ValaBinaryExpression* _tmp348_;
			ValaBinaryExpression* _tmp349_;
			ValaExpression* _tmp350_;
			ValaExpression* _tmp351_;
			ValaDataType* _tmp352_;
			ValaDataType* _tmp353_;
			ValaExpression* _tmp354_;
			ValaExpression* _tmp355_;
			ValaExpression* _tmp356_;
			ValaExpression* _tmp357_;
			ValaDataType* _tmp358_;
			ValaDataType* _tmp359_;
			ValaDataType* _tmp360_;
			ValaDataType* _tmp361_;
			ValaExpression* _tmp362_;
			ValaExpression* _tmp363_;
			ValaDataType* _tmp364_;
			ValaDataType* _tmp365_;
			ValaAssignmentOperator _tmp366_;
			ValaBinaryExpression* _tmp386_;
			ValaExpression* _tmp387_;
			ValaExpression* _tmp388_;
			ValaCodeContext* _tmp389_;
			_tmp336_ = ma;
			_tmp337_ = vala_member_access_get_inner (_tmp336_);
			_tmp338_ = _tmp337_;
			_tmp339_ = ma;
			_tmp340_ = vala_member_access_get_member_name (_tmp339_);
			_tmp341_ = _tmp340_;
			_tmp342_ = vala_member_access_new (_tmp338_, _tmp341_, NULL);
			old_value = _tmp342_;
			_tmp343_ = old_value;
			_tmp344_ = vala_assignment_get_right (self);
			_tmp345_ = _tmp344_;
			_tmp346_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp347_ = _tmp346_;
			_tmp348_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, (ValaExpression*) _tmp343_, _tmp345_, _tmp347_);
			bin = _tmp348_;
			_tmp349_ = bin;
			_tmp350_ = vala_assignment_get_right (self);
			_tmp351_ = _tmp350_;
			_tmp352_ = vala_expression_get_target_type (_tmp351_);
			_tmp353_ = _tmp352_;
			vala_expression_set_target_type ((ValaExpression*) _tmp349_, _tmp353_);
			_tmp354_ = vala_assignment_get_right (self);
			_tmp355_ = _tmp354_;
			_tmp356_ = vala_assignment_get_right (self);
			_tmp357_ = _tmp356_;
			_tmp358_ = vala_expression_get_target_type (_tmp357_);
			_tmp359_ = _tmp358_;
			_tmp360_ = vala_data_type_copy (_tmp359_);
			_tmp361_ = _tmp360_;
			vala_expression_set_target_type (_tmp355_, _tmp361_);
			_vala_code_node_unref0 (_tmp361_);
			_tmp362_ = vala_assignment_get_right (self);
			_tmp363_ = _tmp362_;
			_tmp364_ = vala_expression_get_target_type (_tmp363_);
			_tmp365_ = _tmp364_;
			vala_data_type_set_value_owned (_tmp365_, FALSE);
			_tmp366_ = self->priv->_operator;
			if (_tmp366_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				ValaBinaryExpression* _tmp367_;
				_tmp367_ = bin;
				vala_binary_expression_set_operator (_tmp367_, VALA_BINARY_OPERATOR_BITWISE_OR);
			} else {
				ValaAssignmentOperator _tmp368_;
				_tmp368_ = self->priv->_operator;
				if (_tmp368_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					ValaBinaryExpression* _tmp369_;
					_tmp369_ = bin;
					vala_binary_expression_set_operator (_tmp369_, VALA_BINARY_OPERATOR_BITWISE_AND);
				} else {
					ValaAssignmentOperator _tmp370_;
					_tmp370_ = self->priv->_operator;
					if (_tmp370_ == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						ValaBinaryExpression* _tmp371_;
						_tmp371_ = bin;
						vala_binary_expression_set_operator (_tmp371_, VALA_BINARY_OPERATOR_BITWISE_XOR);
					} else {
						ValaAssignmentOperator _tmp372_;
						_tmp372_ = self->priv->_operator;
						if (_tmp372_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
							ValaBinaryExpression* _tmp373_;
							_tmp373_ = bin;
							vala_binary_expression_set_operator (_tmp373_, VALA_BINARY_OPERATOR_PLUS);
						} else {
							ValaAssignmentOperator _tmp374_;
							_tmp374_ = self->priv->_operator;
							if (_tmp374_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
								ValaBinaryExpression* _tmp375_;
								_tmp375_ = bin;
								vala_binary_expression_set_operator (_tmp375_, VALA_BINARY_OPERATOR_MINUS);
							} else {
								ValaAssignmentOperator _tmp376_;
								_tmp376_ = self->priv->_operator;
								if (_tmp376_ == VALA_ASSIGNMENT_OPERATOR_MUL) {
									ValaBinaryExpression* _tmp377_;
									_tmp377_ = bin;
									vala_binary_expression_set_operator (_tmp377_, VALA_BINARY_OPERATOR_MUL);
								} else {
									ValaAssignmentOperator _tmp378_;
									_tmp378_ = self->priv->_operator;
									if (_tmp378_ == VALA_ASSIGNMENT_OPERATOR_DIV) {
										ValaBinaryExpression* _tmp379_;
										_tmp379_ = bin;
										vala_binary_expression_set_operator (_tmp379_, VALA_BINARY_OPERATOR_DIV);
									} else {
										ValaAssignmentOperator _tmp380_;
										_tmp380_ = self->priv->_operator;
										if (_tmp380_ == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											ValaBinaryExpression* _tmp381_;
											_tmp381_ = bin;
											vala_binary_expression_set_operator (_tmp381_, VALA_BINARY_OPERATOR_MOD);
										} else {
											ValaAssignmentOperator _tmp382_;
											_tmp382_ = self->priv->_operator;
											if (_tmp382_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												ValaBinaryExpression* _tmp383_;
												_tmp383_ = bin;
												vala_binary_expression_set_operator (_tmp383_, VALA_BINARY_OPERATOR_SHIFT_LEFT);
											} else {
												ValaAssignmentOperator _tmp384_;
												_tmp384_ = self->priv->_operator;
												if (_tmp384_ == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													ValaBinaryExpression* _tmp385_;
													_tmp385_ = bin;
													vala_binary_expression_set_operator (_tmp385_, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp386_ = bin;
			vala_assignment_set_right (self, (ValaExpression*) _tmp386_);
			_tmp387_ = vala_assignment_get_right (self);
			_tmp388_ = _tmp387_;
			_tmp389_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp388_, _tmp389_);
			vala_assignment_set_operator (self, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_code_node_unref0 (bin);
			_vala_code_node_unref0 (old_value);
		}
		_vala_code_node_unref0 (ma);
	}
	_tmp390_ = vala_assignment_get_left (self);
	_tmp391_ = _tmp390_;
	_tmp392_ = vala_expression_get_symbol_reference (_tmp391_);
	_tmp393_ = _tmp392_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp393_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaExpression* _tmp394_;
		ValaExpression* _tmp395_;
		ValaSymbol* _tmp396_;
		ValaSymbol* _tmp397_;
		ValaSignal* _tmp398_;
		ValaMethod* m = NULL;
		ValaExpression* _tmp399_;
		ValaExpression* _tmp400_;
		ValaSymbol* _tmp401_;
		ValaSymbol* _tmp402_;
		ValaMethod* _tmp403_;
		ValaMethod* _tmp404_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaSignal* _tmp409_;
		ValaDynamicSignal* _tmp410_;
		ValaMemberAccess* right_ma = NULL;
		ValaExpression* _tmp411_;
		ValaExpression* _tmp412_;
		ValaMemberAccess* _tmp413_;
		ValaDynamicSignal* _tmp414_;
		_tmp394_ = vala_assignment_get_left (self);
		_tmp395_ = _tmp394_;
		_tmp396_ = vala_expression_get_symbol_reference (_tmp395_);
		_tmp397_ = _tmp396_;
		_tmp398_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp397_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp398_;
		_tmp399_ = vala_assignment_get_right (self);
		_tmp400_ = _tmp399_;
		_tmp401_ = vala_expression_get_symbol_reference (_tmp400_);
		_tmp402_ = _tmp401_;
		_tmp403_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp402_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp402_) : NULL);
		m = _tmp403_;
		_tmp404_ = m;
		if (_tmp404_ == NULL) {
			ValaExpression* _tmp405_;
			ValaExpression* _tmp406_;
			ValaSourceReference* _tmp407_;
			ValaSourceReference* _tmp408_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp405_ = vala_assignment_get_right (self);
			_tmp406_ = _tmp405_;
			_tmp407_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp406_);
			_tmp408_ = _tmp407_;
			vala_report_error (_tmp408_, "unsupported expression for signal handler");
			result = FALSE;
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (sig);
			return result;
		}
		_tmp409_ = sig;
		_tmp410_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp409_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp409_) : NULL);
		dynamic_sig = _tmp410_;
		_tmp411_ = vala_assignment_get_right (self);
		_tmp412_ = _tmp411_;
		_tmp413_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp412_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp412_) : NULL);
		right_ma = _tmp413_;
		_tmp414_ = dynamic_sig;
		if (_tmp414_ != NULL) {
			gboolean first = FALSE;
			ValaExpression* _tmp435_;
			ValaExpression* _tmp436_;
			ValaSignal* _tmp437_;
			ValaSignal* _tmp438_;
			ValaSymbol* _tmp439_;
			ValaSymbol* _tmp440_;
			ValaObjectType* _tmp441_;
			ValaObjectType* _tmp442_;
			ValaDelegate* _tmp443_;
			ValaDelegate* _tmp444_;
			ValaDelegateType* _tmp445_;
			ValaDelegateType* _tmp446_;
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp415_;
				ValaExpression* _tmp416_;
				ValaExpression* _tmp417_;
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				ValaList* _tmp420_;
				gint _param_size = 0;
				ValaList* _tmp421_;
				gint _tmp422_;
				gint _tmp423_;
				gint _param_index = 0;
				_tmp415_ = dynamic_sig;
				_tmp416_ = vala_dynamic_signal_get_handler (_tmp415_);
				_tmp417_ = _tmp416_;
				_tmp418_ = vala_expression_get_value_type (_tmp417_);
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_data_type_get_parameters (_tmp419_);
				_param_list = _tmp420_;
				_tmp421_ = _param_list;
				_tmp422_ = vala_collection_get_size ((ValaCollection*) _tmp421_);
				_tmp423_ = _tmp422_;
				_param_size = _tmp423_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp424_;
					gint _tmp425_;
					gint _tmp426_;
					ValaParameter* param = NULL;
					ValaList* _tmp427_;
					gint _tmp428_;
					gpointer _tmp429_;
					gboolean _tmp430_;
					_tmp424_ = _param_index;
					_param_index = _tmp424_ + 1;
					_tmp425_ = _param_index;
					_tmp426_ = _param_size;
					if (!(_tmp425_ < _tmp426_)) {
						break;
					}
					_tmp427_ = _param_list;
					_tmp428_ = _param_index;
					_tmp429_ = vala_list_get (_tmp427_, _tmp428_);
					param = (ValaParameter*) _tmp429_;
					_tmp430_ = first;
					if (_tmp430_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp431_;
						ValaParameter* _tmp432_;
						ValaParameter* _tmp433_;
						ValaParameter* _tmp434_;
						_tmp431_ = dynamic_sig;
						_tmp432_ = param;
						_tmp433_ = vala_parameter_copy (_tmp432_);
						_tmp434_ = _tmp433_;
						vala_callable_add_parameter ((ValaCallable*) _tmp431_, _tmp434_);
						_vala_code_node_unref0 (_tmp434_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp435_ = vala_assignment_get_right (self);
			_tmp436_ = _tmp435_;
			_tmp437_ = sig;
			_tmp438_ = sig;
			_tmp439_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp438_);
			_tmp440_ = _tmp439_;
			_tmp441_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp440_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp442_ = _tmp441_;
			_tmp443_ = vala_signal_get_delegate (_tmp437_, (ValaDataType*) _tmp442_, (ValaCodeNode*) self);
			_tmp444_ = _tmp443_;
			_tmp445_ = vala_delegate_type_new (_tmp444_);
			_tmp446_ = _tmp445_;
			vala_expression_set_target_type (_tmp436_, (ValaDataType*) _tmp446_);
			_vala_code_node_unref0 (_tmp446_);
			_vala_code_node_unref0 (_tmp444_);
			_vala_code_node_unref0 (_tmp442_);
		} else {
			ValaExpression* _tmp447_;
			ValaExpression* _tmp448_;
			ValaDataType* _tmp449_;
			ValaDataType* _tmp450_;
			ValaExpression* _tmp451_;
			ValaExpression* _tmp452_;
			ValaDataType* _tmp453_;
			ValaDataType* _tmp454_;
			gboolean _tmp455_;
			_tmp447_ = vala_assignment_get_right (self);
			_tmp448_ = _tmp447_;
			_tmp449_ = vala_expression_get_value_type (_tmp448_);
			_tmp450_ = _tmp449_;
			_tmp451_ = vala_assignment_get_right (self);
			_tmp452_ = _tmp451_;
			_tmp453_ = vala_expression_get_target_type (_tmp452_);
			_tmp454_ = _tmp453_;
			_tmp455_ = vala_data_type_compatible (_tmp450_, _tmp454_);
			if (!_tmp455_) {
				ValaDelegateType* delegate_type = NULL;
				ValaExpression* _tmp456_;
				ValaExpression* _tmp457_;
				ValaDataType* _tmp458_;
				ValaDataType* _tmp459_;
				ValaDelegateType* _tmp460_;
				ValaExpression* _tmp461_;
				ValaExpression* _tmp462_;
				ValaSourceReference* _tmp463_;
				ValaSourceReference* _tmp464_;
				ValaExpression* _tmp465_;
				ValaExpression* _tmp466_;
				ValaDataType* _tmp467_;
				ValaDataType* _tmp468_;
				gchar* _tmp469_;
				gchar* _tmp470_;
				ValaExpression* _tmp471_;
				ValaExpression* _tmp472_;
				ValaDataType* _tmp473_;
				ValaDataType* _tmp474_;
				gchar* _tmp475_;
				gchar* _tmp476_;
				ValaDelegateType* _tmp477_;
				ValaMethod* _tmp478_;
				const gchar* _tmp479_;
				const gchar* _tmp480_;
				gchar* _tmp481_;
				gchar* _tmp482_;
				gchar* _tmp483_;
				gchar* _tmp484_;
				_tmp456_ = vala_assignment_get_right (self);
				_tmp457_ = _tmp456_;
				_tmp458_ = vala_expression_get_target_type (_tmp457_);
				_tmp459_ = _tmp458_;
				_tmp460_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp459_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				delegate_type = _tmp460_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp461_ = vala_assignment_get_right (self);
				_tmp462_ = _tmp461_;
				_tmp463_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp462_);
				_tmp464_ = _tmp463_;
				_tmp465_ = vala_assignment_get_right (self);
				_tmp466_ = _tmp465_;
				_tmp467_ = vala_expression_get_value_type (_tmp466_);
				_tmp468_ = _tmp467_;
				_tmp469_ = vala_code_node_to_string ((ValaCodeNode*) _tmp468_);
				_tmp470_ = _tmp469_;
				_tmp471_ = vala_assignment_get_right (self);
				_tmp472_ = _tmp471_;
				_tmp473_ = vala_expression_get_target_type (_tmp472_);
				_tmp474_ = _tmp473_;
				_tmp475_ = vala_code_node_to_string ((ValaCodeNode*) _tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = delegate_type;
				_tmp478_ = m;
				_tmp479_ = vala_symbol_get_name ((ValaSymbol*) _tmp478_);
				_tmp480_ = _tmp479_;
				_tmp481_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp477_, _tmp480_);
				_tmp482_ = _tmp481_;
				_tmp483_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp470_, _tmp476_, _tmp482_);
				_tmp484_ = _tmp483_;
				vala_report_error (_tmp464_, _tmp484_);
				_g_free0 (_tmp484_);
				_g_free0 (_tmp482_);
				_g_free0 (_tmp476_);
				_g_free0 (_tmp470_);
				result = FALSE;
				_vala_code_node_unref0 (delegate_type);
				_vala_code_node_unref0 (right_ma);
				_vala_code_node_unref0 (dynamic_sig);
				_vala_code_node_unref0 (m);
				_vala_code_node_unref0 (sig);
				return result;
			} else {
				gboolean _tmp485_ = FALSE;
				ValaMemberAccess* _tmp486_;
				_tmp486_ = right_ma;
				if (_tmp486_ != NULL) {
					ValaMemberAccess* _tmp487_;
					gboolean _tmp488_;
					gboolean _tmp489_;
					_tmp487_ = right_ma;
					_tmp488_ = vala_member_access_get_prototype_access (_tmp487_);
					_tmp489_ = _tmp488_;
					_tmp485_ = _tmp489_;
				} else {
					_tmp485_ = FALSE;
				}
				if (_tmp485_) {
					ValaExpression* _tmp490_;
					ValaExpression* _tmp491_;
					ValaSourceReference* _tmp492_;
					ValaSourceReference* _tmp493_;
					ValaMethod* _tmp494_;
					gchar* _tmp495_;
					gchar* _tmp496_;
					gchar* _tmp497_;
					gchar* _tmp498_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp490_ = vala_assignment_get_right (self);
					_tmp491_ = _tmp490_;
					_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp491_);
					_tmp493_ = _tmp492_;
					_tmp494_ = m;
					_tmp495_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp494_);
					_tmp496_ = _tmp495_;
					_tmp497_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp496_);
					_tmp498_ = _tmp497_;
					vala_report_error (_tmp493_, _tmp498_);
					_g_free0 (_tmp498_);
					_g_free0 (_tmp496_);
					result = FALSE;
					_vala_code_node_unref0 (right_ma);
					_vala_code_node_unref0 (dynamic_sig);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (sig);
					return result;
				}
			}
		}
		_vala_code_node_unref0 (right_ma);
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (sig);
	} else {
		ValaExpression* _tmp499_;
		ValaExpression* _tmp500_;
		_tmp499_ = vala_assignment_get_left (self);
		_tmp500_ = _tmp499_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp500_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp501_;
			ValaExpression* _tmp502_;
			ValaMemberAccess* _tmp503_;
			ValaMemberAccess* _tmp504_;
			ValaSymbol* _tmp505_;
			ValaSymbol* _tmp506_;
			gboolean _tmp651_ = FALSE;
			ValaExpression* _tmp652_;
			ValaExpression* _tmp653_;
			ValaDataType* _tmp654_;
			ValaDataType* _tmp655_;
			ValaMemberAccess* right_ma = NULL;
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			ValaMemberAccess* _tmp714_;
			gboolean _tmp715_ = FALSE;
			ValaMemberAccess* _tmp716_;
			_tmp501_ = vala_assignment_get_left (self);
			_tmp502_ = _tmp501_;
			_tmp503_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp502_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp503_;
			_tmp504_ = ma;
			_tmp505_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp504_);
			_tmp506_ = _tmp505_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp506_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaMemberAccess* _tmp507_;
				ValaSymbol* _tmp508_;
				ValaSymbol* _tmp509_;
				ValaProperty* _tmp510_;
				ValaDynamicProperty* dynamic_prop = NULL;
				ValaProperty* _tmp511_;
				ValaDynamicProperty* _tmp512_;
				ValaDynamicProperty* _tmp513_;
				gboolean _tmp528_ = FALSE;
				ValaProperty* _tmp529_;
				ValaPropertyAccessor* _tmp530_;
				ValaPropertyAccessor* _tmp531_;
				_tmp507_ = ma;
				_tmp508_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp507_);
				_tmp509_ = _tmp508_;
				_tmp510_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp509_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp510_;
				_tmp511_ = prop;
				_tmp512_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp511_, VALA_TYPE_DYNAMIC_PROPERTY) ? ((ValaDynamicProperty*) _tmp511_) : NULL);
				dynamic_prop = _tmp512_;
				_tmp513_ = dynamic_prop;
				if (_tmp513_ != NULL) {
					ValaDynamicProperty* _tmp514_;
					ValaExpression* _tmp515_;
					ValaExpression* _tmp516_;
					ValaDataType* _tmp517_;
					ValaDataType* _tmp518_;
					ValaDataType* _tmp519_;
					ValaDataType* _tmp520_;
					ValaExpression* _tmp521_;
					ValaExpression* _tmp522_;
					ValaDynamicProperty* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDataType* _tmp526_;
					ValaDataType* _tmp527_;
					_tmp514_ = dynamic_prop;
					_tmp515_ = vala_assignment_get_right (self);
					_tmp516_ = _tmp515_;
					_tmp517_ = vala_expression_get_value_type (_tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = vala_data_type_copy (_tmp518_);
					_tmp520_ = _tmp519_;
					vala_property_set_property_type ((ValaProperty*) _tmp514_, _tmp520_);
					_vala_code_node_unref0 (_tmp520_);
					_tmp521_ = vala_assignment_get_left (self);
					_tmp522_ = _tmp521_;
					_tmp523_ = dynamic_prop;
					_tmp524_ = vala_property_get_property_type ((ValaProperty*) _tmp523_);
					_tmp525_ = _tmp524_;
					_tmp526_ = vala_data_type_copy (_tmp525_);
					_tmp527_ = _tmp526_;
					vala_expression_set_value_type (_tmp522_, _tmp527_);
					_vala_code_node_unref0 (_tmp527_);
				}
				_tmp529_ = prop;
				_tmp530_ = vala_property_get_set_accessor (_tmp529_);
				_tmp531_ = _tmp530_;
				if (_tmp531_ == NULL) {
					_tmp528_ = TRUE;
				} else {
					gboolean _tmp532_ = FALSE;
					ValaProperty* _tmp533_;
					ValaPropertyAccessor* _tmp534_;
					ValaPropertyAccessor* _tmp535_;
					gboolean _tmp536_;
					gboolean _tmp537_;
					_tmp533_ = prop;
					_tmp534_ = vala_property_get_set_accessor (_tmp533_);
					_tmp535_ = _tmp534_;
					_tmp536_ = vala_property_accessor_get_writable (_tmp535_);
					_tmp537_ = _tmp536_;
					if (!_tmp537_) {
						gboolean _tmp538_ = FALSE;
						ValaCodeContext* _tmp539_;
						ValaSemanticAnalyzer* _tmp540_;
						ValaSemanticAnalyzer* _tmp541_;
						ValaMethod* _tmp542_;
						ValaMethod* _tmp543_;
						gboolean _tmp544_;
						_tmp539_ = context;
						_tmp540_ = vala_code_context_get_analyzer (_tmp539_);
						_tmp541_ = _tmp540_;
						_tmp542_ = vala_semantic_analyzer_find_current_method (_tmp541_);
						_tmp543_ = _tmp542_;
						_tmp544_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp543_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp543_);
						if (_tmp544_) {
							_tmp538_ = TRUE;
						} else {
							ValaCodeContext* _tmp545_;
							ValaSemanticAnalyzer* _tmp546_;
							ValaSemanticAnalyzer* _tmp547_;
							gboolean _tmp548_;
							_tmp545_ = context;
							_tmp546_ = vala_code_context_get_analyzer (_tmp545_);
							_tmp547_ = _tmp546_;
							_tmp548_ = vala_semantic_analyzer_is_in_constructor (_tmp547_);
							_tmp538_ = _tmp548_;
						}
						_tmp532_ = !_tmp538_;
					} else {
						_tmp532_ = FALSE;
					}
					_tmp528_ = _tmp532_;
				}
				if (_tmp528_) {
					ValaMemberAccess* _tmp549_;
					ValaMemberAccess* _tmp550_;
					ValaSourceReference* _tmp551_;
					ValaSourceReference* _tmp552_;
					ValaProperty* _tmp553_;
					gchar* _tmp554_;
					gchar* _tmp555_;
					gchar* _tmp556_;
					gchar* _tmp557_;
					_tmp549_ = ma;
					vala_code_node_set_error ((ValaCodeNode*) _tmp549_, TRUE);
					_tmp550_ = ma;
					_tmp551_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = prop;
					_tmp554_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp553_);
					_tmp555_ = _tmp554_;
					_tmp556_ = g_strdup_printf ("Property `%s' is read-only", _tmp555_);
					_tmp557_ = _tmp556_;
					vala_report_error (_tmp552_, _tmp557_);
					_g_free0 (_tmp557_);
					_g_free0 (_tmp555_);
					result = FALSE;
					_vala_code_node_unref0 (dynamic_prop);
					_vala_code_node_unref0 (prop);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp558_ = FALSE;
					gboolean _tmp559_ = FALSE;
					ValaCodeContext* _tmp560_;
					gboolean _tmp561_;
					gboolean _tmp562_;
					_tmp560_ = context;
					_tmp561_ = vala_code_context_get_deprecated (_tmp560_);
					_tmp562_ = _tmp561_;
					if (!_tmp562_) {
						ValaProperty* _tmp563_;
						ValaPropertyAccessor* _tmp564_;
						ValaPropertyAccessor* _tmp565_;
						gboolean _tmp566_;
						gboolean _tmp567_;
						_tmp563_ = prop;
						_tmp564_ = vala_property_get_set_accessor (_tmp563_);
						_tmp565_ = _tmp564_;
						_tmp566_ = vala_property_accessor_get_writable (_tmp565_);
						_tmp567_ = _tmp566_;
						_tmp559_ = !_tmp567_;
					} else {
						_tmp559_ = FALSE;
					}
					if (_tmp559_) {
						ValaCodeContext* _tmp568_;
						ValaSemanticAnalyzer* _tmp569_;
						ValaSemanticAnalyzer* _tmp570_;
						ValaMethod* _tmp571_;
						ValaMethod* _tmp572_;
						_tmp568_ = context;
						_tmp569_ = vala_code_context_get_analyzer (_tmp568_);
						_tmp570_ = _tmp569_;
						_tmp571_ = vala_semantic_analyzer_find_current_method (_tmp570_);
						_tmp572_ = _tmp571_;
						_tmp558_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp572_, VALA_TYPE_CREATION_METHOD);
						_vala_code_node_unref0 (_tmp572_);
					} else {
						_tmp558_ = FALSE;
					}
					if (_tmp558_) {
						ValaMemberAccess* _tmp573_;
						ValaExpression* _tmp574_;
						ValaExpression* _tmp575_;
						ValaSymbol* _tmp576_;
						ValaSymbol* _tmp577_;
						ValaCodeContext* _tmp578_;
						ValaSemanticAnalyzer* _tmp579_;
						ValaSemanticAnalyzer* _tmp580_;
						ValaMethod* _tmp581_;
						ValaMethod* _tmp582_;
						ValaParameter* _tmp583_;
						ValaParameter* _tmp584_;
						gboolean _tmp585_;
						_tmp573_ = ma;
						_tmp574_ = vala_member_access_get_inner (_tmp573_);
						_tmp575_ = _tmp574_;
						_tmp576_ = vala_expression_get_symbol_reference (_tmp575_);
						_tmp577_ = _tmp576_;
						_tmp578_ = context;
						_tmp579_ = vala_code_context_get_analyzer (_tmp578_);
						_tmp580_ = _tmp579_;
						_tmp581_ = vala_semantic_analyzer_find_current_method (_tmp580_);
						_tmp582_ = _tmp581_;
						_tmp583_ = vala_method_get_this_parameter (_tmp582_);
						_tmp584_ = _tmp583_;
						_tmp585_ = _tmp577_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp584_, VALA_TYPE_SYMBOL, ValaSymbol);
						_vala_code_node_unref0 (_tmp582_);
						if (_tmp585_) {
							ValaMemberAccess* _tmp586_;
							ValaSourceReference* _tmp587_;
							ValaSourceReference* _tmp588_;
							ValaProperty* _tmp589_;
							gchar* _tmp590_;
							gchar* _tmp591_;
							gchar* _tmp592_;
							gchar* _tmp593_;
							_tmp586_ = ma;
							_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
							_tmp588_ = _tmp587_;
							_tmp589_ = prop;
							_tmp590_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp589_);
							_tmp591_ = _tmp590_;
							_tmp592_ = g_strdup_printf ("Property `%s' is read-only", _tmp591_);
							_tmp593_ = _tmp592_;
							vala_report_error (_tmp588_, _tmp593_);
							_g_free0 (_tmp593_);
							_g_free0 (_tmp591_);
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						} else {
							ValaMemberAccess* _tmp594_;
							ValaSourceReference* _tmp595_;
							ValaSourceReference* _tmp596_;
							_tmp594_ = ma;
							_tmp595_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp594_);
							_tmp596_ = _tmp595_;
							vala_report_error (_tmp596_, "Cannot assign to construct-only properties, use Object (property: valu" \
"e) constructor chain up");
							result = FALSE;
							_vala_code_node_unref0 (dynamic_prop);
							_vala_code_node_unref0 (prop);
							_vala_code_node_unref0 (ma);
							return result;
						}
					}
				}
				_vala_code_node_unref0 (dynamic_prop);
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp597_ = FALSE;
				ValaMemberAccess* _tmp598_;
				ValaSymbol* _tmp599_;
				ValaSymbol* _tmp600_;
				_tmp598_ = ma;
				_tmp599_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp598_);
				_tmp600_ = _tmp599_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp600_, VALA_TYPE_VARIABLE)) {
					ValaExpression* _tmp601_;
					ValaExpression* _tmp602_;
					ValaDataType* _tmp603_;
					ValaDataType* _tmp604_;
					_tmp601_ = vala_assignment_get_right (self);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_expression_get_value_type (_tmp602_);
					_tmp604_ = _tmp603_;
					_tmp597_ = _tmp604_ == NULL;
				} else {
					_tmp597_ = FALSE;
				}
				if (_tmp597_) {
					ValaVariable* variable = NULL;
					ValaMemberAccess* _tmp605_;
					ValaSymbol* _tmp606_;
					ValaSymbol* _tmp607_;
					ValaVariable* _tmp608_;
					gboolean _tmp609_ = FALSE;
					ValaExpression* _tmp610_;
					ValaExpression* _tmp611_;
					ValaSymbol* _tmp612_;
					ValaSymbol* _tmp613_;
					_tmp605_ = ma;
					_tmp606_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp605_);
					_tmp607_ = _tmp606_;
					_tmp608_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_VARIABLE, ValaVariable));
					variable = _tmp608_;
					_tmp610_ = vala_assignment_get_right (self);
					_tmp611_ = _tmp610_;
					_tmp612_ = vala_expression_get_symbol_reference (_tmp611_);
					_tmp613_ = _tmp612_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp613_, VALA_TYPE_METHOD)) {
						ValaVariable* _tmp614_;
						ValaDataType* _tmp615_;
						ValaDataType* _tmp616_;
						_tmp614_ = variable;
						_tmp615_ = vala_variable_get_variable_type (_tmp614_);
						_tmp616_ = _tmp615_;
						_tmp609_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp616_, VALA_TYPE_DELEGATE_TYPE);
					} else {
						_tmp609_ = FALSE;
					}
					if (_tmp609_) {
						ValaMethod* m = NULL;
						ValaExpression* _tmp617_;
						ValaExpression* _tmp618_;
						ValaSymbol* _tmp619_;
						ValaSymbol* _tmp620_;
						ValaMethod* _tmp621_;
						ValaDelegateType* dt = NULL;
						ValaVariable* _tmp622_;
						ValaDataType* _tmp623_;
						ValaDataType* _tmp624_;
						ValaDelegateType* _tmp625_;
						ValaDelegate* cb = NULL;
						ValaDelegateType* _tmp626_;
						ValaDelegate* _tmp627_;
						ValaDelegate* _tmp628_;
						ValaDelegate* _tmp629_;
						ValaDelegate* _tmp630_;
						ValaMethod* _tmp631_;
						ValaDelegateType* _tmp632_;
						gboolean _tmp633_;
						ValaExpression* _tmp644_;
						ValaExpression* _tmp645_;
						ValaVariable* _tmp646_;
						ValaDataType* _tmp647_;
						ValaDataType* _tmp648_;
						_tmp617_ = vala_assignment_get_right (self);
						_tmp618_ = _tmp617_;
						_tmp619_ = vala_expression_get_symbol_reference (_tmp618_);
						_tmp620_ = _tmp619_;
						_tmp621_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp620_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp621_;
						_tmp622_ = variable;
						_tmp623_ = vala_variable_get_variable_type (_tmp622_);
						_tmp624_ = _tmp623_;
						_tmp625_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp624_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						dt = _tmp625_;
						_tmp626_ = dt;
						_tmp627_ = vala_delegate_type_get_delegate_symbol (_tmp626_);
						_tmp628_ = _tmp627_;
						_tmp629_ = _vala_code_node_ref0 (_tmp628_);
						cb = _tmp629_;
						_tmp630_ = cb;
						_tmp631_ = m;
						_tmp632_ = dt;
						_tmp633_ = vala_delegate_matches_method (_tmp630_, _tmp631_, (ValaDataType*) _tmp632_);
						if (!_tmp633_) {
							ValaSourceReference* _tmp634_;
							ValaSourceReference* _tmp635_;
							ValaMethod* _tmp636_;
							gchar* _tmp637_;
							gchar* _tmp638_;
							ValaDelegate* _tmp639_;
							gchar* _tmp640_;
							gchar* _tmp641_;
							gchar* _tmp642_;
							gchar* _tmp643_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp634_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp635_ = _tmp634_;
							_tmp636_ = m;
							_tmp637_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp636_);
							_tmp638_ = _tmp637_;
							_tmp639_ = cb;
							_tmp640_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp639_);
							_tmp641_ = _tmp640_;
							_tmp642_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp638_, _tmp641_);
							_tmp643_ = _tmp642_;
							vala_report_error (_tmp635_, _tmp643_);
							_g_free0 (_tmp643_);
							_g_free0 (_tmp641_);
							_g_free0 (_tmp638_);
							result = FALSE;
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (dt);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (variable);
							_vala_code_node_unref0 (ma);
							return result;
						}
						_tmp644_ = vala_assignment_get_right (self);
						_tmp645_ = _tmp644_;
						_tmp646_ = variable;
						_tmp647_ = vala_variable_get_variable_type (_tmp646_);
						_tmp648_ = _tmp647_;
						vala_expression_set_value_type (_tmp645_, _tmp648_);
						_vala_code_node_unref0 (cb);
						_vala_code_node_unref0 (dt);
						_vala_code_node_unref0 (m);
					} else {
						ValaSourceReference* _tmp649_;
						ValaSourceReference* _tmp650_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp649_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp650_ = _tmp649_;
						vala_report_error (_tmp650_, "Assignment: Invalid assignment attempt");
						result = FALSE;
						_vala_code_node_unref0 (variable);
						_vala_code_node_unref0 (ma);
						return result;
					}
					_vala_code_node_unref0 (variable);
				}
			}
			_tmp652_ = vala_assignment_get_left (self);
			_tmp653_ = _tmp652_;
			_tmp654_ = vala_expression_get_value_type (_tmp653_);
			_tmp655_ = _tmp654_;
			if (_tmp655_ != NULL) {
				ValaExpression* _tmp656_;
				ValaExpression* _tmp657_;
				ValaDataType* _tmp658_;
				ValaDataType* _tmp659_;
				_tmp656_ = vala_assignment_get_right (self);
				_tmp657_ = _tmp656_;
				_tmp658_ = vala_expression_get_value_type (_tmp657_);
				_tmp659_ = _tmp658_;
				_tmp651_ = _tmp659_ != NULL;
			} else {
				_tmp651_ = FALSE;
			}
			if (_tmp651_) {
				ValaExpression* _tmp660_;
				ValaExpression* _tmp661_;
				ValaDataType* _tmp662_;
				ValaDataType* _tmp663_;
				ValaExpression* _tmp664_;
				ValaExpression* _tmp665_;
				ValaDataType* _tmp666_;
				ValaDataType* _tmp667_;
				gboolean _tmp668_;
				ValaMemberAccess* _tmp685_;
				ValaSymbol* _tmp686_;
				ValaSymbol* _tmp687_;
				_tmp660_ = vala_assignment_get_right (self);
				_tmp661_ = _tmp660_;
				_tmp662_ = vala_expression_get_value_type (_tmp661_);
				_tmp663_ = _tmp662_;
				_tmp664_ = vala_assignment_get_left (self);
				_tmp665_ = _tmp664_;
				_tmp666_ = vala_expression_get_value_type (_tmp665_);
				_tmp667_ = _tmp666_;
				_tmp668_ = vala_data_type_compatible (_tmp663_, _tmp667_);
				if (!_tmp668_) {
					ValaSourceReference* _tmp669_;
					ValaSourceReference* _tmp670_;
					ValaExpression* _tmp671_;
					ValaExpression* _tmp672_;
					ValaDataType* _tmp673_;
					ValaDataType* _tmp674_;
					gchar* _tmp675_;
					gchar* _tmp676_;
					ValaExpression* _tmp677_;
					ValaExpression* _tmp678_;
					ValaDataType* _tmp679_;
					ValaDataType* _tmp680_;
					gchar* _tmp681_;
					gchar* _tmp682_;
					gchar* _tmp683_;
					gchar* _tmp684_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp669_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp670_ = _tmp669_;
					_tmp671_ = vala_assignment_get_right (self);
					_tmp672_ = _tmp671_;
					_tmp673_ = vala_expression_get_value_type (_tmp672_);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_code_node_to_string ((ValaCodeNode*) _tmp674_);
					_tmp676_ = _tmp675_;
					_tmp677_ = vala_assignment_get_left (self);
					_tmp678_ = _tmp677_;
					_tmp679_ = vala_expression_get_value_type (_tmp678_);
					_tmp680_ = _tmp679_;
					_tmp681_ = vala_code_node_to_string ((ValaCodeNode*) _tmp680_);
					_tmp682_ = _tmp681_;
					_tmp683_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp676_, _tmp682_);
					_tmp684_ = _tmp683_;
					vala_report_error (_tmp670_, _tmp684_);
					_g_free0 (_tmp684_);
					_g_free0 (_tmp682_);
					_g_free0 (_tmp676_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					return result;
				}
				_tmp685_ = ma;
				_tmp686_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp685_);
				_tmp687_ = _tmp686_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp687_, VALA_TYPE_PROPERTY)) {
					ValaExpression* _tmp688_;
					ValaExpression* _tmp689_;
					ValaDataType* _tmp690_;
					ValaDataType* _tmp691_;
					gboolean _tmp692_;
					_tmp688_ = vala_assignment_get_right (self);
					_tmp689_ = _tmp688_;
					_tmp690_ = vala_expression_get_value_type (_tmp689_);
					_tmp691_ = _tmp690_;
					_tmp692_ = vala_data_type_is_disposable (_tmp691_);
					if (_tmp692_) {
						gboolean _tmp693_ = FALSE;
						ValaExpression* _tmp694_;
						ValaExpression* _tmp695_;
						ValaDataType* _tmp696_;
						ValaDataType* _tmp697_;
						_tmp694_ = vala_assignment_get_left (self);
						_tmp695_ = _tmp694_;
						_tmp696_ = vala_expression_get_value_type (_tmp695_);
						_tmp697_ = _tmp696_;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp697_, VALA_TYPE_POINTER_TYPE)) {
							ValaExpression* _tmp698_;
							ValaExpression* _tmp699_;
							ValaDataType* _tmp700_;
							ValaDataType* _tmp701_;
							gboolean _tmp702_;
							gboolean _tmp703_;
							_tmp698_ = vala_assignment_get_left (self);
							_tmp699_ = _tmp698_;
							_tmp700_ = vala_expression_get_value_type (_tmp699_);
							_tmp701_ = _tmp700_;
							_tmp702_ = vala_data_type_get_value_owned (_tmp701_);
							_tmp703_ = _tmp702_;
							_tmp693_ = !_tmp703_;
						} else {
							_tmp693_ = FALSE;
						}
						if (_tmp693_) {
							ValaSourceReference* _tmp704_;
							ValaSourceReference* _tmp705_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp704_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp705_ = _tmp704_;
							vala_report_error (_tmp705_, "Invalid assignment from owned expression to unowned variable");
						}
					} else {
						ValaExpression* _tmp706_;
						ValaExpression* _tmp707_;
						ValaDataType* _tmp708_;
						ValaDataType* _tmp709_;
						gboolean _tmp710_;
						gboolean _tmp711_;
						_tmp706_ = vala_assignment_get_left (self);
						_tmp707_ = _tmp706_;
						_tmp708_ = vala_expression_get_value_type (_tmp707_);
						_tmp709_ = _tmp708_;
						_tmp710_ = vala_data_type_get_value_owned (_tmp709_);
						_tmp711_ = _tmp710_;
						if (_tmp711_) {
						}
					}
				}
			}
			_tmp712_ = vala_assignment_get_right (self);
			_tmp713_ = _tmp712_;
			_tmp714_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp713_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp713_) : NULL);
			right_ma = _tmp714_;
			_tmp716_ = right_ma;
			if (_tmp716_ != NULL) {
				ValaMemberAccess* _tmp717_;
				ValaSymbol* _tmp718_;
				ValaSymbol* _tmp719_;
				ValaMemberAccess* _tmp720_;
				ValaSymbol* _tmp721_;
				ValaSymbol* _tmp722_;
				_tmp717_ = ma;
				_tmp718_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp717_);
				_tmp719_ = _tmp718_;
				_tmp720_ = right_ma;
				_tmp721_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp720_);
				_tmp722_ = _tmp721_;
				_tmp715_ = _tmp719_ == _tmp722_;
			} else {
				_tmp715_ = FALSE;
			}
			if (_tmp715_) {
				gboolean _tmp723_ = FALSE;
				ValaMemberAccess* _tmp724_;
				ValaSymbol* _tmp725_;
				ValaSymbol* _tmp726_;
				_tmp724_ = ma;
				_tmp725_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp724_);
				_tmp726_ = _tmp725_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp726_, VALA_TYPE_LOCAL_VARIABLE)) {
					_tmp723_ = TRUE;
				} else {
					ValaMemberAccess* _tmp727_;
					ValaSymbol* _tmp728_;
					ValaSymbol* _tmp729_;
					_tmp727_ = ma;
					_tmp728_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp727_);
					_tmp729_ = _tmp728_;
					_tmp723_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp729_, VALA_TYPE_PARAMETER);
				}
				if (_tmp723_) {
					ValaSourceReference* _tmp730_;
					ValaSourceReference* _tmp731_;
					_tmp730_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp731_ = _tmp730_;
					vala_report_warning (_tmp731_, "Assignment to same variable");
				} else {
					ValaMemberAccess* _tmp732_;
					ValaSymbol* _tmp733_;
					ValaSymbol* _tmp734_;
					_tmp732_ = ma;
					_tmp733_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp732_);
					_tmp734_ = _tmp733_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp734_, VALA_TYPE_FIELD)) {
						ValaField* f = NULL;
						ValaMemberAccess* _tmp735_;
						ValaSymbol* _tmp736_;
						ValaSymbol* _tmp737_;
						ValaField* _tmp738_;
						ValaField* _tmp739_;
						ValaMemberBinding _tmp740_;
						ValaMemberBinding _tmp741_;
						_tmp735_ = ma;
						_tmp736_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp735_);
						_tmp737_ = _tmp736_;
						_tmp738_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_FIELD, ValaField));
						f = _tmp738_;
						_tmp739_ = f;
						_tmp740_ = vala_field_get_binding (_tmp739_);
						_tmp741_ = _tmp740_;
						if (_tmp741_ == VALA_MEMBER_BINDING_STATIC) {
							ValaSourceReference* _tmp742_;
							ValaSourceReference* _tmp743_;
							_tmp742_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp743_ = _tmp742_;
							vala_report_warning (_tmp743_, "Assignment to same variable");
						} else {
							ValaMemberAccess* ma_inner = NULL;
							ValaMemberAccess* _tmp744_;
							ValaExpression* _tmp745_;
							ValaExpression* _tmp746_;
							ValaMemberAccess* _tmp747_;
							ValaMemberAccess* right_ma_inner = NULL;
							ValaMemberAccess* _tmp748_;
							ValaExpression* _tmp749_;
							ValaExpression* _tmp750_;
							ValaMemberAccess* _tmp751_;
							gboolean _tmp752_ = FALSE;
							gboolean _tmp753_ = FALSE;
							gboolean _tmp754_ = FALSE;
							gboolean _tmp755_ = FALSE;
							gboolean _tmp756_ = FALSE;
							ValaMemberAccess* _tmp757_;
							_tmp744_ = ma;
							_tmp745_ = vala_member_access_get_inner (_tmp744_);
							_tmp746_ = _tmp745_;
							_tmp747_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp746_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp746_) : NULL);
							ma_inner = _tmp747_;
							_tmp748_ = right_ma;
							_tmp749_ = vala_member_access_get_inner (_tmp748_);
							_tmp750_ = _tmp749_;
							_tmp751_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp750_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp750_) : NULL);
							right_ma_inner = _tmp751_;
							_tmp757_ = ma_inner;
							if (_tmp757_ != NULL) {
								ValaMemberAccess* _tmp758_;
								const gchar* _tmp759_;
								const gchar* _tmp760_;
								_tmp758_ = ma_inner;
								_tmp759_ = vala_member_access_get_member_name (_tmp758_);
								_tmp760_ = _tmp759_;
								_tmp756_ = g_strcmp0 (_tmp760_, "this") == 0;
							} else {
								_tmp756_ = FALSE;
							}
							if (_tmp756_) {
								ValaMemberAccess* _tmp761_;
								ValaExpression* _tmp762_;
								ValaExpression* _tmp763_;
								_tmp761_ = ma_inner;
								_tmp762_ = vala_member_access_get_inner (_tmp761_);
								_tmp763_ = _tmp762_;
								_tmp755_ = _tmp763_ == NULL;
							} else {
								_tmp755_ = FALSE;
							}
							if (_tmp755_) {
								ValaMemberAccess* _tmp764_;
								_tmp764_ = right_ma_inner;
								_tmp754_ = _tmp764_ != NULL;
							} else {
								_tmp754_ = FALSE;
							}
							if (_tmp754_) {
								ValaMemberAccess* _tmp765_;
								const gchar* _tmp766_;
								const gchar* _tmp767_;
								_tmp765_ = right_ma_inner;
								_tmp766_ = vala_member_access_get_member_name (_tmp765_);
								_tmp767_ = _tmp766_;
								_tmp753_ = g_strcmp0 (_tmp767_, "this") == 0;
							} else {
								_tmp753_ = FALSE;
							}
							if (_tmp753_) {
								ValaMemberAccess* _tmp768_;
								ValaExpression* _tmp769_;
								ValaExpression* _tmp770_;
								_tmp768_ = right_ma_inner;
								_tmp769_ = vala_member_access_get_inner (_tmp768_);
								_tmp770_ = _tmp769_;
								_tmp752_ = _tmp770_ == NULL;
							} else {
								_tmp752_ = FALSE;
							}
							if (_tmp752_) {
								ValaSourceReference* _tmp771_;
								ValaSourceReference* _tmp772_;
								_tmp771_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp772_ = _tmp771_;
								vala_report_warning (_tmp772_, "Assignment to same variable");
							}
							_vala_code_node_unref0 (right_ma_inner);
							_vala_code_node_unref0 (ma_inner);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
			_vala_code_node_unref0 (right_ma);
			_vala_code_node_unref0 (ma);
		} else {
			ValaExpression* _tmp773_;
			ValaExpression* _tmp774_;
			_tmp773_ = vala_assignment_get_left (self);
			_tmp774_ = _tmp773_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp774_, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaElementAccess* ea = NULL;
				ValaExpression* _tmp775_;
				ValaExpression* _tmp776_;
				ValaElementAccess* _tmp777_;
				ValaExpression* _tmp778_;
				ValaExpression* _tmp779_;
				ValaDataType* _tmp780_;
				ValaDataType* _tmp781_;
				ValaExpression* _tmp782_;
				ValaExpression* _tmp783_;
				ValaDataType* _tmp784_;
				ValaDataType* _tmp785_;
				gboolean _tmp786_;
				ValaExpression* _tmp803_;
				ValaExpression* _tmp804_;
				ValaDataType* _tmp805_;
				ValaDataType* _tmp806_;
				gboolean _tmp807_;
				_tmp775_ = vala_assignment_get_left (self);
				_tmp776_ = _tmp775_;
				_tmp777_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp776_, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
				ea = _tmp777_;
				_tmp778_ = vala_assignment_get_right (self);
				_tmp779_ = _tmp778_;
				_tmp780_ = vala_expression_get_value_type (_tmp779_);
				_tmp781_ = _tmp780_;
				_tmp782_ = vala_assignment_get_left (self);
				_tmp783_ = _tmp782_;
				_tmp784_ = vala_expression_get_value_type (_tmp783_);
				_tmp785_ = _tmp784_;
				_tmp786_ = vala_data_type_compatible (_tmp781_, _tmp785_);
				if (!_tmp786_) {
					ValaSourceReference* _tmp787_;
					ValaSourceReference* _tmp788_;
					ValaExpression* _tmp789_;
					ValaExpression* _tmp790_;
					ValaDataType* _tmp791_;
					ValaDataType* _tmp792_;
					gchar* _tmp793_;
					gchar* _tmp794_;
					ValaExpression* _tmp795_;
					ValaExpression* _tmp796_;
					ValaDataType* _tmp797_;
					ValaDataType* _tmp798_;
					gchar* _tmp799_;
					gchar* _tmp800_;
					gchar* _tmp801_;
					gchar* _tmp802_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp787_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp788_ = _tmp787_;
					_tmp789_ = vala_assignment_get_right (self);
					_tmp790_ = _tmp789_;
					_tmp791_ = vala_expression_get_value_type (_tmp790_);
					_tmp792_ = _tmp791_;
					_tmp793_ = vala_code_node_to_string ((ValaCodeNode*) _tmp792_);
					_tmp794_ = _tmp793_;
					_tmp795_ = vala_assignment_get_left (self);
					_tmp796_ = _tmp795_;
					_tmp797_ = vala_expression_get_value_type (_tmp796_);
					_tmp798_ = _tmp797_;
					_tmp799_ = vala_code_node_to_string ((ValaCodeNode*) _tmp798_);
					_tmp800_ = _tmp799_;
					_tmp801_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp794_, _tmp800_);
					_tmp802_ = _tmp801_;
					vala_report_error (_tmp788_, _tmp802_);
					_g_free0 (_tmp802_);
					_g_free0 (_tmp800_);
					_g_free0 (_tmp794_);
					result = FALSE;
					_vala_code_node_unref0 (ea);
					return result;
				}
				_tmp803_ = vala_assignment_get_right (self);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_expression_get_value_type (_tmp804_);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_data_type_is_disposable (_tmp806_);
				if (_tmp807_) {
					ValaDataType* element_type = NULL;
					ValaElementAccess* _tmp808_;
					ValaExpression* _tmp809_;
					ValaExpression* _tmp810_;
					ValaDataType* _tmp811_;
					ValaDataType* _tmp812_;
					gboolean _tmp834_ = FALSE;
					ValaDataType* _tmp835_;
					_tmp808_ = ea;
					_tmp809_ = vala_element_access_get_container (_tmp808_);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_expression_get_value_type (_tmp810_);
					_tmp812_ = _tmp811_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp812_, VALA_TYPE_ARRAY_TYPE)) {
						ValaArrayType* array_type = NULL;
						ValaElementAccess* _tmp813_;
						ValaExpression* _tmp814_;
						ValaExpression* _tmp815_;
						ValaDataType* _tmp816_;
						ValaDataType* _tmp817_;
						ValaArrayType* _tmp818_;
						ValaArrayType* _tmp819_;
						ValaDataType* _tmp820_;
						ValaDataType* _tmp821_;
						ValaDataType* _tmp822_;
						_tmp813_ = ea;
						_tmp814_ = vala_element_access_get_container (_tmp813_);
						_tmp815_ = _tmp814_;
						_tmp816_ = vala_expression_get_value_type (_tmp815_);
						_tmp817_ = _tmp816_;
						_tmp818_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp817_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp818_;
						_tmp819_ = array_type;
						_tmp820_ = vala_array_type_get_element_type (_tmp819_);
						_tmp821_ = _tmp820_;
						_tmp822_ = _vala_code_node_ref0 (_tmp821_);
						_vala_code_node_unref0 (element_type);
						element_type = _tmp822_;
						_vala_code_node_unref0 (array_type);
					} else {
						ValaList* args = NULL;
						ValaElementAccess* _tmp823_;
						ValaExpression* _tmp824_;
						ValaExpression* _tmp825_;
						ValaDataType* _tmp826_;
						ValaDataType* _tmp827_;
						ValaList* _tmp828_;
						ValaList* _tmp829_;
						gint _tmp830_;
						gint _tmp831_;
						ValaList* _tmp832_;
						gpointer _tmp833_;
						_tmp823_ = ea;
						_tmp824_ = vala_element_access_get_container (_tmp823_);
						_tmp825_ = _tmp824_;
						_tmp826_ = vala_expression_get_value_type (_tmp825_);
						_tmp827_ = _tmp826_;
						_tmp828_ = vala_data_type_get_type_arguments (_tmp827_);
						args = _tmp828_;
						_tmp829_ = args;
						_tmp830_ = vala_collection_get_size ((ValaCollection*) _tmp829_);
						_tmp831_ = _tmp830_;
						_vala_assert (_tmp831_ == 1, "args.size == 1");
						_tmp832_ = args;
						_tmp833_ = vala_list_get (_tmp832_, 0);
						_vala_code_node_unref0 (element_type);
						element_type = (ValaDataType*) _tmp833_;
						_vala_iterable_unref0 (args);
					}
					_tmp835_ = element_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp835_, VALA_TYPE_POINTER_TYPE)) {
						ValaDataType* _tmp836_;
						gboolean _tmp837_;
						gboolean _tmp838_;
						_tmp836_ = element_type;
						_tmp837_ = vala_data_type_get_value_owned (_tmp836_);
						_tmp838_ = _tmp837_;
						_tmp834_ = !_tmp838_;
					} else {
						_tmp834_ = FALSE;
					}
					if (_tmp834_) {
						ValaSourceReference* _tmp839_;
						ValaSourceReference* _tmp840_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp839_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp840_ = _tmp839_;
						vala_report_error (_tmp840_, "Invalid assignment from owned expression to unowned variable");
						result = FALSE;
						_vala_code_node_unref0 (element_type);
						_vala_code_node_unref0 (ea);
						return result;
					}
					_vala_code_node_unref0 (element_type);
				} else {
					ValaExpression* _tmp841_;
					ValaExpression* _tmp842_;
					ValaDataType* _tmp843_;
					ValaDataType* _tmp844_;
					gboolean _tmp845_;
					gboolean _tmp846_;
					_tmp841_ = vala_assignment_get_left (self);
					_tmp842_ = _tmp841_;
					_tmp843_ = vala_expression_get_value_type (_tmp842_);
					_tmp844_ = _tmp843_;
					_tmp845_ = vala_data_type_get_value_owned (_tmp844_);
					_tmp846_ = _tmp845_;
					if (_tmp846_) {
					}
				}
				_vala_code_node_unref0 (ea);
			} else {
				result = TRUE;
				return result;
			}
		}
	}
	_tmp847_ = vala_assignment_get_left (self);
	_tmp848_ = _tmp847_;
	_tmp849_ = vala_expression_get_value_type (_tmp848_);
	_tmp850_ = _tmp849_;
	if (_tmp850_ != NULL) {
		ValaExpression* _tmp851_;
		ValaExpression* _tmp852_;
		ValaDataType* _tmp853_;
		ValaDataType* _tmp854_;
		ValaDataType* _tmp855_;
		ValaDataType* _tmp856_;
		ValaDataType* _tmp857_;
		ValaDataType* _tmp858_;
		_tmp851_ = vala_assignment_get_left (self);
		_tmp852_ = _tmp851_;
		_tmp853_ = vala_expression_get_value_type (_tmp852_);
		_tmp854_ = _tmp853_;
		_tmp855_ = vala_data_type_copy (_tmp854_);
		_tmp856_ = _tmp855_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp856_);
		_vala_code_node_unref0 (_tmp856_);
		_tmp857_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp858_ = _tmp857_;
		vala_data_type_set_value_owned (_tmp858_, FALSE);
	} else {
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
	}
	_tmp859_ = vala_assignment_get_left (self);
	_tmp860_ = _tmp859_;
	_tmp861_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp860_);
	_tmp862_ = _tmp861_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp862_);
	_vala_iterable_unref0 (_tmp862_);
	_tmp863_ = vala_assignment_get_right (self);
	_tmp864_ = _tmp863_;
	_tmp865_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp864_);
	_tmp866_ = _tmp865_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp866_);
	_vala_iterable_unref0 (_tmp866_);
	_tmp867_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp868_ = _tmp867_;
	result = !_tmp868_;
	return result;
}


static gboolean vala_assignment_is_array_add (ValaAssignment* self) {
	gboolean result = FALSE;
	ValaBinaryExpression* binary = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaBinaryExpression* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaBinaryExpression* _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BINARY_EXPRESSION) ? ((ValaBinaryExpression*) _tmp1_) : NULL);
	binary = _tmp2_;
	_tmp4_ = binary;
	if (_tmp4_ != NULL) {
		ValaBinaryExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp5_ = binary;
		_tmp6_ = vala_binary_expression_get_left (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_value_type (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaBinaryExpression* _tmp10_;
		ValaBinaryOperator _tmp11_;
		ValaBinaryOperator _tmp12_;
		_tmp10_ = binary;
		_tmp11_ = vala_binary_expression_get_operator (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_BINARY_OPERATOR_PLUS) {
			ValaExpression* _tmp13_;
			ValaExpression* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaBinaryExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaSymbol* _tmp21_;
			_tmp13_ = vala_assignment_get_left (self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_expression_get_symbol_reference (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = binary;
			_tmp18_ = vala_binary_expression_get_left (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_expression_get_symbol_reference (_tmp19_);
			_tmp21_ = _tmp20_;
			if (_tmp16_ == _tmp21_) {
				result = TRUE;
				_vala_code_node_unref0 (binary);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (binary);
	return result;
}


static gpointer _vala_target_value_ref0 (gpointer self) {
	return self ? vala_target_value_ref (self) : NULL;
}


static void vala_assignment_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	ValaPointerIndirection* pi = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaPointerIndirection* _tmp8_;
	ValaMemberAccess* _tmp9_;
	ValaExpression* _tmp151_;
	ValaExpression* _tmp152_;
	ValaCodeGenerator* _tmp153_;
	ValaCodeGenerator* _tmp154_;
	ValaCodeGenerator* _tmp155_;
	self = (ValaAssignment*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_POINTER_INDIRECTION) ? ((ValaPointerIndirection*) _tmp7_) : NULL);
	pi = _tmp8_;
	_tmp9_ = ma;
	if (_tmp9_ != NULL) {
		ValaLocalVariable* local = NULL;
		ValaMemberAccess* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaLocalVariable* _tmp13_;
		ValaParameter* param = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaParameter* _tmp17_;
		ValaField* field = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaField* _tmp21_;
		ValaProperty* property = NULL;
		ValaMemberAccess* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaProperty* _tmp25_;
		gboolean _tmp26_ = FALSE;
		gboolean _tmp27_ = FALSE;
		ValaField* _tmp28_;
		gboolean instance = FALSE;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gboolean _tmp40_ = FALSE;
		ValaAssignmentOperator _tmp41_;
		gboolean _tmp132_ = FALSE;
		gboolean _tmp133_ = FALSE;
		gboolean _tmp134_;
		_tmp10_ = ma;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp12_) : NULL);
		local = _tmp13_;
		_tmp14_ = ma;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp16_) : NULL);
		param = _tmp17_;
		_tmp18_ = ma;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp20_) : NULL);
		field = _tmp21_;
		_tmp22_ = ma;
		_tmp23_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp24_) : NULL);
		property = _tmp25_;
		_tmp28_ = field;
		if (_tmp28_ != NULL) {
			ValaField* _tmp29_;
			ValaMemberBinding _tmp30_;
			ValaMemberBinding _tmp31_;
			_tmp29_ = field;
			_tmp30_ = vala_field_get_binding (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp27_ = _tmp31_ != VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			_tmp26_ = TRUE;
		} else {
			gboolean _tmp32_ = FALSE;
			ValaProperty* _tmp33_;
			_tmp33_ = property;
			if (_tmp33_ != NULL) {
				ValaProperty* _tmp34_;
				ValaMemberBinding _tmp35_;
				ValaMemberBinding _tmp36_;
				_tmp34_ = property;
				_tmp35_ = vala_property_get_binding (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp32_ = _tmp36_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp32_ = FALSE;
			}
			_tmp26_ = _tmp32_;
		}
		instance = _tmp26_;
		_tmp41_ = self->priv->_operator;
		if (_tmp41_ == VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			gboolean _tmp42_ = FALSE;
			gboolean _tmp43_ = FALSE;
			ValaLocalVariable* _tmp44_;
			_tmp44_ = local;
			if (_tmp44_ != NULL) {
				_tmp43_ = TRUE;
			} else {
				ValaParameter* _tmp45_;
				_tmp45_ = param;
				_tmp43_ = _tmp45_ != NULL;
			}
			if (_tmp43_) {
				_tmp42_ = TRUE;
			} else {
				ValaField* _tmp46_;
				_tmp46_ = field;
				_tmp42_ = _tmp46_ != NULL;
			}
			_tmp40_ = _tmp42_;
		} else {
			_tmp40_ = FALSE;
		}
		if (_tmp40_) {
			gboolean _tmp47_;
			_tmp47_ = vala_assignment_is_array_add (self);
			_tmp39_ = !_tmp47_;
		} else {
			_tmp39_ = FALSE;
		}
		if (_tmp39_) {
			ValaField* _tmp48_;
			_tmp48_ = field;
			_tmp38_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_ARRAY_LENGTH_FIELD);
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			gboolean _tmp49_ = FALSE;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			gboolean _tmp54_;
			_tmp50_ = vala_assignment_get_left (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_expression_get_value_type (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_data_type_is_real_non_null_struct_type (_tmp53_);
			if (_tmp54_) {
				ValaExpression* _tmp55_;
				ValaExpression* _tmp56_;
				_tmp55_ = vala_assignment_get_right (self);
				_tmp56_ = _tmp55_;
				_tmp49_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_OBJECT_CREATION_EXPRESSION);
			} else {
				_tmp49_ = FALSE;
			}
			_tmp37_ = !_tmp49_;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_;
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaCodeGenerator* _tmp68_;
			ValaTargetValue* new_value = NULL;
			ValaExpression* _tmp69_;
			ValaExpression* _tmp70_;
			ValaTargetValue* _tmp71_;
			ValaTargetValue* _tmp72_;
			ValaTargetValue* _tmp73_;
			ValaLocalVariable* _tmp74_;
			ValaCodeNode* _tmp103_;
			ValaCodeNode* _tmp104_;
			ValaCodeGenerator* _tmp131_;
			_tmp58_ = instance;
			if (_tmp58_) {
				ValaMemberAccess* _tmp59_;
				ValaExpression* _tmp60_;
				ValaExpression* _tmp61_;
				_tmp59_ = ma;
				_tmp60_ = vala_member_access_get_inner (_tmp59_);
				_tmp61_ = _tmp60_;
				_tmp57_ = _tmp61_ != NULL;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp62_;
				ValaExpression* _tmp63_;
				ValaExpression* _tmp64_;
				ValaCodeGenerator* _tmp65_;
				_tmp62_ = ma;
				_tmp63_ = vala_member_access_get_inner (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = codegen;
				vala_code_node_emit ((ValaCodeNode*) _tmp64_, _tmp65_);
			}
			_tmp66_ = vala_assignment_get_right (self);
			_tmp67_ = _tmp66_;
			_tmp68_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp67_, _tmp68_);
			_tmp69_ = vala_assignment_get_right (self);
			_tmp70_ = _tmp69_;
			_tmp71_ = vala_expression_get_target_value (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = _vala_target_value_ref0 (_tmp72_);
			new_value = _tmp73_;
			_tmp74_ = local;
			if (_tmp74_ != NULL) {
				ValaCodeGenerator* _tmp75_;
				ValaLocalVariable* _tmp76_;
				ValaTargetValue* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaSourceReference* _tmp79_;
				_tmp75_ = codegen;
				_tmp76_ = local;
				_tmp77_ = new_value;
				_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp79_ = _tmp78_;
				vala_code_generator_store_local (_tmp75_, _tmp76_, _tmp77_, FALSE, _tmp79_);
			} else {
				ValaParameter* _tmp80_;
				_tmp80_ = param;
				if (_tmp80_ != NULL) {
					ValaCodeGenerator* _tmp81_;
					ValaParameter* _tmp82_;
					ValaTargetValue* _tmp83_;
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					_tmp81_ = codegen;
					_tmp82_ = param;
					_tmp83_ = new_value;
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					vala_code_generator_store_parameter (_tmp81_, _tmp82_, _tmp83_, FALSE, _tmp85_);
				} else {
					ValaField* _tmp86_;
					_tmp86_ = field;
					if (_tmp86_ != NULL) {
						ValaTargetValue* _tmp87_ = NULL;
						gboolean _tmp88_ = FALSE;
						gboolean _tmp89_;
						ValaCodeGenerator* _tmp98_;
						ValaField* _tmp99_;
						ValaTargetValue* _tmp100_;
						ValaSourceReference* _tmp101_;
						ValaSourceReference* _tmp102_;
						_tmp89_ = instance;
						if (_tmp89_) {
							ValaMemberAccess* _tmp90_;
							ValaExpression* _tmp91_;
							ValaExpression* _tmp92_;
							_tmp90_ = ma;
							_tmp91_ = vala_member_access_get_inner (_tmp90_);
							_tmp92_ = _tmp91_;
							_tmp88_ = _tmp92_ != NULL;
						} else {
							_tmp88_ = FALSE;
						}
						if (_tmp88_) {
							ValaMemberAccess* _tmp93_;
							ValaExpression* _tmp94_;
							ValaExpression* _tmp95_;
							ValaTargetValue* _tmp96_;
							ValaTargetValue* _tmp97_;
							_tmp93_ = ma;
							_tmp94_ = vala_member_access_get_inner (_tmp93_);
							_tmp95_ = _tmp94_;
							_tmp96_ = vala_expression_get_target_value (_tmp95_);
							_tmp97_ = _tmp96_;
							_tmp87_ = _tmp97_;
						} else {
							_tmp87_ = NULL;
						}
						_tmp98_ = codegen;
						_tmp99_ = field;
						_tmp100_ = new_value;
						_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp102_ = _tmp101_;
						vala_code_generator_store_field (_tmp98_, _tmp99_, _tmp87_, _tmp100_, _tmp102_);
					}
				}
			}
			_tmp103_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp104_ = _tmp103_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_EXPRESSION_STATEMENT)) {
				ValaLocalVariable* _tmp105_;
				_tmp105_ = local;
				if (_tmp105_ != NULL) {
					ValaCodeGenerator* _tmp106_;
					ValaLocalVariable* _tmp107_;
					ValaTargetValue* _tmp108_;
					ValaTargetValue* _tmp109_;
					_tmp106_ = codegen;
					_tmp107_ = local;
					_tmp108_ = vala_code_generator_load_local (_tmp106_, _tmp107_);
					_tmp109_ = _tmp108_;
					vala_expression_set_target_value ((ValaExpression*) self, _tmp109_);
					_vala_target_value_unref0 (_tmp109_);
				} else {
					ValaParameter* _tmp110_;
					_tmp110_ = param;
					if (_tmp110_ != NULL) {
						ValaCodeGenerator* _tmp111_;
						ValaParameter* _tmp112_;
						ValaTargetValue* _tmp113_;
						ValaTargetValue* _tmp114_;
						_tmp111_ = codegen;
						_tmp112_ = param;
						_tmp113_ = vala_code_generator_load_parameter (_tmp111_, _tmp112_);
						_tmp114_ = _tmp113_;
						vala_expression_set_target_value ((ValaExpression*) self, _tmp114_);
						_vala_target_value_unref0 (_tmp114_);
					} else {
						ValaField* _tmp115_;
						_tmp115_ = field;
						if (_tmp115_ != NULL) {
							ValaTargetValue* _tmp116_ = NULL;
							gboolean _tmp117_ = FALSE;
							gboolean _tmp118_;
							ValaCodeGenerator* _tmp127_;
							ValaField* _tmp128_;
							ValaTargetValue* _tmp129_;
							ValaTargetValue* _tmp130_;
							_tmp118_ = instance;
							if (_tmp118_) {
								ValaMemberAccess* _tmp119_;
								ValaExpression* _tmp120_;
								ValaExpression* _tmp121_;
								_tmp119_ = ma;
								_tmp120_ = vala_member_access_get_inner (_tmp119_);
								_tmp121_ = _tmp120_;
								_tmp117_ = _tmp121_ != NULL;
							} else {
								_tmp117_ = FALSE;
							}
							if (_tmp117_) {
								ValaMemberAccess* _tmp122_;
								ValaExpression* _tmp123_;
								ValaExpression* _tmp124_;
								ValaTargetValue* _tmp125_;
								ValaTargetValue* _tmp126_;
								_tmp122_ = ma;
								_tmp123_ = vala_member_access_get_inner (_tmp122_);
								_tmp124_ = _tmp123_;
								_tmp125_ = vala_expression_get_target_value (_tmp124_);
								_tmp126_ = _tmp125_;
								_tmp116_ = _tmp126_;
							} else {
								_tmp116_ = NULL;
							}
							_tmp127_ = codegen;
							_tmp128_ = field;
							_tmp129_ = vala_code_generator_load_field (_tmp127_, _tmp128_, _tmp116_);
							_tmp130_ = _tmp129_;
							vala_expression_set_target_value ((ValaExpression*) self, _tmp130_);
							_vala_target_value_unref0 (_tmp130_);
						}
					}
				}
			}
			_tmp131_ = codegen;
			vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp131_, (ValaExpression*) self);
			_vala_target_value_unref0 (new_value);
			_vala_code_node_unref0 (property);
			_vala_code_node_unref0 (field);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (pi);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			return;
		}
		_tmp134_ = instance;
		if (_tmp134_) {
			ValaMemberAccess* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			_tmp135_ = ma;
			_tmp136_ = vala_member_access_get_inner (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp133_ = _tmp137_ != NULL;
		} else {
			_tmp133_ = FALSE;
		}
		if (_tmp133_) {
			ValaProperty* _tmp138_;
			_tmp138_ = property;
			_tmp132_ = _tmp138_ != NULL;
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			ValaMemberAccess* _tmp139_;
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaCodeGenerator* _tmp142_;
			_tmp139_ = ma;
			_tmp140_ = vala_member_access_get_inner (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp141_, _tmp142_);
		} else {
			ValaMemberAccess* _tmp143_;
			ValaCodeGenerator* _tmp144_;
			_tmp143_ = ma;
			_tmp144_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp143_, _tmp144_);
		}
		_vala_code_node_unref0 (property);
		_vala_code_node_unref0 (field);
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	} else {
		ValaElementAccess* _tmp145_;
		_tmp145_ = ea;
		if (_tmp145_ != NULL) {
			ValaElementAccess* _tmp146_;
			ValaCodeGenerator* _tmp147_;
			_tmp146_ = ea;
			_tmp147_ = codegen;
			vala_code_node_emit ((ValaCodeNode*) _tmp146_, _tmp147_);
		} else {
			ValaPointerIndirection* _tmp148_;
			_tmp148_ = pi;
			if (_tmp148_ != NULL) {
				ValaPointerIndirection* _tmp149_;
				ValaCodeGenerator* _tmp150_;
				_tmp149_ = pi;
				_tmp150_ = codegen;
				vala_code_node_emit ((ValaCodeNode*) _tmp149_, _tmp150_);
			}
		}
	}
	_tmp151_ = vala_assignment_get_right (self);
	_tmp152_ = _tmp151_;
	_tmp153_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp152_, _tmp153_);
	_tmp154_ = codegen;
	vala_code_visitor_visit_assignment ((ValaCodeVisitor*) _tmp154_, self);
	_tmp155_ = codegen;
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) _tmp155_, (ValaExpression*) self);
	_vala_code_node_unref0 (pi);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


static void vala_assignment_real_get_defined_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaAssignment * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCollection* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaCollection* _tmp5_;
	ValaLocalVariable* local = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaLocalVariable* _tmp10_;
	ValaParameter* param = NULL;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaParameter* _tmp15_;
	ValaLocalVariable* _tmp16_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_right (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = collection;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp4_, _tmp5_);
	_tmp6_ = vala_assignment_get_left (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp9_) : NULL);
	local = _tmp10_;
	_tmp11_ = vala_assignment_get_left (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp14_) : NULL);
	param = _tmp15_;
	_tmp16_ = local;
	if (_tmp16_ != NULL) {
		ValaCollection* _tmp17_;
		ValaLocalVariable* _tmp18_;
		_tmp17_ = collection;
		_tmp18_ = local;
		vala_collection_add (_tmp17_, (ValaVariable*) _tmp18_);
	} else {
		gboolean _tmp19_ = FALSE;
		ValaParameter* _tmp20_;
		_tmp20_ = param;
		if (_tmp20_ != NULL) {
			ValaParameter* _tmp21_;
			ValaParameterDirection _tmp22_;
			ValaParameterDirection _tmp23_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_direction (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp19_ = _tmp23_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			ValaCollection* _tmp24_;
			ValaParameter* _tmp25_;
			_tmp24_ = collection;
			_tmp25_ = param;
			vala_collection_add (_tmp24_, (ValaVariable*) _tmp25_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static void vala_assignment_real_get_used_variables (ValaCodeNode* base, ValaCollection* collection) {
	ValaAssignment * self;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaMemberAccess* _tmp2_;
	ValaElementAccess* ea = NULL;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaElementAccess* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaMemberAccess* _tmp7_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaCollection* _tmp20_;
	self = (ValaAssignment*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_assignment_get_left (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1_) : NULL);
	ma = _tmp2_;
	_tmp3_ = vala_assignment_get_left (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp4_) : NULL);
	ea = _tmp5_;
	_tmp7_ = ma;
	if (_tmp7_ != NULL) {
		ValaMemberAccess* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		_tmp8_ = ma;
		_tmp9_ = vala_member_access_get_inner (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMemberAccess* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaCollection* _tmp14_;
		_tmp11_ = ma;
		_tmp12_ = vala_member_access_get_inner (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = collection;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, _tmp14_);
	} else {
		ValaElementAccess* _tmp15_;
		_tmp15_ = ea;
		if (_tmp15_ != NULL) {
			ValaElementAccess* _tmp16_;
			ValaCollection* _tmp17_;
			_tmp16_ = ea;
			_tmp17_ = collection;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp16_, _tmp17_);
		}
	}
	_tmp18_ = vala_assignment_get_right (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = collection;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp19_, _tmp20_);
	_vala_code_node_unref0 (ea);
	_vala_code_node_unref0 (ma);
}


ValaExpression* vala_assignment_get_left (ValaAssignment* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_left (ValaAssignment* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp1_;
	_tmp2_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaAssignmentOperator vala_assignment_get_operator (ValaAssignment* self) {
	ValaAssignmentOperator result;
	ValaAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_operator (ValaAssignment* self, ValaAssignmentOperator value) {
	ValaAssignmentOperator _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_operator = _tmp0_;
}


ValaExpression* vala_assignment_get_right (ValaAssignment* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void vala_assignment_set_right (ValaAssignment* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp1_;
	_tmp2_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_assignment_class_init (ValaAssignmentClass * klass) {
	vala_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaAssignmentPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_assignment_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_assignment_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_assignment_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_assignment_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_assignment_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_assignment_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_assignment_real_get_used_variables;
}


static void vala_assignment_instance_init (ValaAssignment * self) {
	self->priv = VALA_ASSIGNMENT_GET_PRIVATE (self);
}


static void vala_assignment_finalize (ValaCodeNode * obj) {
	ValaAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ASSIGNMENT, ValaAssignment);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the source code.
 *
 * Supports =, |=, &=, ^=, +=, -=, *=, /=, %=, <<=, >>=.
 */
GType vala_assignment_get_type (void) {
	static volatile gsize vala_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaAssignment), 0, (GInstanceInitFunc) vala_assignment_instance_init, NULL };
		GType vala_assignment_type_id;
		vala_assignment_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_assignment_type_id__volatile, vala_assignment_type_id);
	}
	return vala_assignment_type_id__volatile;
}


GType vala_assignment_operator_get_type (void) {
	static volatile gsize vala_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_ASSIGNMENT_OPERATOR_NONE, "VALA_ASSIGNMENT_OPERATOR_NONE", "none"}, {VALA_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_ASSIGNMENT_OPERATOR_ADD, "VALA_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_ASSIGNMENT_OPERATOR_SUB, "VALA_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_ASSIGNMENT_OPERATOR_MUL, "VALA_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_ASSIGNMENT_OPERATOR_DIV, "VALA_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_ASSIGNMENT_OPERATOR_PERCENT, "VALA_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_assignment_operator_type_id;
		vala_assignment_operator_type_id = g_enum_register_static ("ValaAssignmentOperator", values);
		g_once_init_leave (&vala_assignment_operator_type_id__volatile, vala_assignment_operator_type_id);
	}
	return vala_assignment_operator_type_id__volatile;
}



