/* gtkdoccommentscanner.c generated by valac, the Vala compiler
 * generated from gtkdoccommentscanner.vala, do not modify */

/* gtkcommentscanner.vala
 *
 * Copyright (C) 2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>

enum  {
	VALADOC_GTKDOC_TOKEN_0_PROPERTY,
	VALADOC_GTKDOC_TOKEN_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_token_properties[VALADOC_GTKDOC_TOKEN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValadocGtkdocParamSpecToken ValadocGtkdocParamSpecToken;
enum  {
	VALADOC_GTKDOC_SCANNER_0_PROPERTY,
	VALADOC_GTKDOC_SCANNER_NUM_PROPERTIES
};
static GParamSpec* valadoc_gtkdoc_scanner_properties[VALADOC_GTKDOC_SCANNER_NUM_PROPERTIES];
#define _valadoc_gtkdoc_token_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_gtkdoc_token_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ValadocGtkdocParamSpecScanner ValadocGtkdocParamSpecScanner;

struct _ValadocGtkdocParamSpecToken {
	GParamSpec parent_instance;
};

struct _ValadocGtkdocScannerPrivate {
	const gchar* content;
	const gchar* pos;
	gint column;
	gint line;
	ValadocGtkdocToken* tmp_token;
};

struct _ValadocGtkdocParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer valadoc_gtkdoc_token_parent_class = NULL;
static gpointer valadoc_gtkdoc_scanner_parent_class = NULL;

static void valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj);
#define VALADOC_GTKDOC_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_GTKDOC_TYPE_SCANNER, ValadocGtkdocScannerPrivate))
static inline gunichar valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self);
static inline gunichar valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self);
static inline gboolean valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self, gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self, gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self, gunichar c);
static inline gboolean valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self, gunichar c);
static inline gint valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self, const gchar* a, const gchar* b);
static inline gint valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self);
static inline gint valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self, gunichar c, ValadocGtkdocTokenType type);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self);
static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self);
static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self);
static void valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj);


GType valadoc_gtkdoc_token_type_get_type (void) {
	static volatile gsize valadoc_gtkdoc_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN", "xml-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE", "xml-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT", "xml-comment"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION", "gtkdoc-function"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST", "gtkdoc-const"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE", "gtkdoc-type"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM", "gtkdoc-param"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN", "gtkdoc-source-open"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE", "gtkdoc-source-close"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL", "gtkdoc-signal"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY", "gtkdoc-property"}, {VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH", "gtkdoc-paragraph"}, {VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE", "newline"}, {VALADOC_GTKDOC_TOKEN_TYPE_SPACE, "VALADOC_GTKDOC_TOKEN_TYPE_SPACE", "space"}, {VALADOC_GTKDOC_TOKEN_TYPE_WORD, "VALADOC_GTKDOC_TOKEN_TYPE_WORD", "word"}, {VALADOC_GTKDOC_TOKEN_TYPE_EOF, "VALADOC_GTKDOC_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType valadoc_gtkdoc_token_type_type_id;
		valadoc_gtkdoc_token_type_type_id = g_enum_register_static ("ValadocGtkdocTokenType", values);
		g_once_init_leave (&valadoc_gtkdoc_token_type_type_id__volatile, valadoc_gtkdoc_token_type_type_id);
	}
	return valadoc_gtkdoc_token_type_type_id__volatile;
}


static gpointer _vala_map_ref0 (gpointer self) {
	return self ? vala_map_ref (self) : NULL;
}


ValadocGtkdocToken* valadoc_gtkdoc_token_construct (GType object_type, ValadocGtkdocTokenType type, const gchar* content, ValaHashMap* attributes, const gchar* start, gint length, gint line, gint first_column, gint last_column) {
	ValadocGtkdocToken* self = NULL;
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	ValadocGtkdocTokenType _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	self = (ValadocGtkdocToken*) g_type_create_instance (object_type);
	_tmp0_ = attributes;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	_vala_map_unref0 (self->attributes);
	self->attributes = _tmp1_;
	_tmp2_ = content;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->content);
	self->content = _tmp3_;
	_tmp4_ = length;
	self->length = _tmp4_;
	_tmp5_ = start;
	self->start = _tmp5_;
	_tmp6_ = type;
	self->type = _tmp6_;
	_tmp7_ = line;
	self->line = _tmp7_;
	_tmp8_ = first_column;
	self->first_column = _tmp8_;
	_tmp9_ = last_column;
	self->last_column = _tmp9_;
	return self;
}


ValadocGtkdocToken* valadoc_gtkdoc_token_new (ValadocGtkdocTokenType type, const gchar* content, ValaHashMap* attributes, const gchar* start, gint length, gint line, gint first_column, gint last_column) {
	return valadoc_gtkdoc_token_construct (VALADOC_GTKDOC_TYPE_TOKEN, type, content, attributes, start, length, line, first_column, last_column);
}


gchar* valadoc_gtkdoc_token_to_string (ValadocGtkdocToken* self) {
	gchar* result = NULL;
	ValadocGtkdocTokenType _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN:
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->content;
			_tmp2_ = g_strdup_printf ("`<%s>'", _tmp1_);
			result = _tmp2_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE:
		{
			const gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->content;
			_tmp4_ = g_strdup_printf ("`</%s>'", _tmp3_);
			result = _tmp4_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("<XML-COMMENT>");
			result = _tmp5_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->content;
			_tmp7_ = g_strdup_printf ("`%s ()'", _tmp6_);
			result = _tmp7_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST:
		{
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->content;
			_tmp9_ = g_strdup_printf ("`%%%s'", _tmp8_);
			result = _tmp9_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE:
		{
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->content;
			_tmp11_ = g_strdup_printf ("`#%s'", _tmp10_);
			result = _tmp11_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup ("<GTKDOC-PARAM>");
			result = _tmp12_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("[|");
			result = _tmp13_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup ("|]");
			result = _tmp14_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL:
		{
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp15_ = self->content;
			_tmp16_ = g_strdup_printf ("`::%s'", _tmp15_);
			result = _tmp16_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY:
		{
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = self->content;
			_tmp18_ = g_strdup_printf ("`:%s'", _tmp17_);
			result = _tmp18_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH:
		{
			gchar* _tmp19_;
			_tmp19_ = g_strdup ("<GKTDOC-PARAGRAPH>");
			result = _tmp19_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup ("<NEWLNIE>");
			result = _tmp20_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_SPACE:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("<SPACE>");
			result = _tmp21_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_WORD:
		{
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp22_ = self->content;
			_tmp23_ = g_strdup_printf ("`%s'", _tmp22_);
			result = _tmp23_;
			return result;
		}
		case VALADOC_GTKDOC_TOKEN_TYPE_EOF:
		{
			gchar* _tmp24_;
			_tmp24_ = g_strdup ("<EOF>");
			result = _tmp24_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void valadoc_gtkdoc_value_token_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void valadoc_gtkdoc_value_token_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_token_unref (value->data[0].v_pointer);
	}
}


static void valadoc_gtkdoc_value_token_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_token_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer valadoc_gtkdoc_value_token_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* valadoc_gtkdoc_value_token_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValadocGtkdocToken * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_token_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* valadoc_gtkdoc_value_token_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValadocGtkdocToken ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* valadoc_gtkdoc_param_spec_token (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValadocGtkdocParamSpecToken* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer valadoc_gtkdoc_value_get_token (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN), NULL);
	return value->data[0].v_pointer;
}


void valadoc_gtkdoc_value_set_token (GValue* value, gpointer v_object) {
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_token_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}


void valadoc_gtkdoc_value_take_token (GValue* value, gpointer v_object) {
	ValadocGtkdocToken * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_TOKEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_TOKEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_token_unref (old);
	}
}


static void valadoc_gtkdoc_token_class_init (ValadocGtkdocTokenClass * klass) {
	valadoc_gtkdoc_token_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocTokenClass *) klass)->finalize = valadoc_gtkdoc_token_finalize;
}


static void valadoc_gtkdoc_token_instance_init (ValadocGtkdocToken * self) {
	self->ref_count = 1;
}


static void valadoc_gtkdoc_token_finalize (ValadocGtkdocToken * obj) {
	ValadocGtkdocToken * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_TOKEN, ValadocGtkdocToken);
	g_signal_handlers_destroy (self);
	_g_free0 (self->content);
	_vala_map_unref0 (self->attributes);
}


GType valadoc_gtkdoc_token_get_type (void) {
	static volatile gsize valadoc_gtkdoc_token_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_token_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_token_init, valadoc_gtkdoc_value_token_free_value, valadoc_gtkdoc_value_token_copy_value, valadoc_gtkdoc_value_token_peek_pointer, "p", valadoc_gtkdoc_value_token_collect_value, "p", valadoc_gtkdoc_value_token_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocTokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocToken), 0, (GInstanceInitFunc) valadoc_gtkdoc_token_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_gtkdoc_token_type_id;
		valadoc_gtkdoc_token_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocToken", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_token_type_id__volatile, valadoc_gtkdoc_token_type_id);
	}
	return valadoc_gtkdoc_token_type_id__volatile;
}


gpointer valadoc_gtkdoc_token_ref (gpointer instance) {
	ValadocGtkdocToken * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void valadoc_gtkdoc_token_unref (gpointer instance) {
	ValadocGtkdocToken * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_TOKEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


ValadocGtkdocScanner* valadoc_gtkdoc_scanner_construct (GType object_type) {
	ValadocGtkdocScanner* self = NULL;
	self = (ValadocGtkdocScanner*) g_type_create_instance (object_type);
	return self;
}


ValadocGtkdocScanner* valadoc_gtkdoc_scanner_new (void) {
	return valadoc_gtkdoc_scanner_construct (VALADOC_GTKDOC_TYPE_SCANNER);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gchar* valadoc_gtkdoc_scanner_unescape (const gchar* txt) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* pos = NULL;
	gunichar c = 0U;
	g_return_val_if_fail (txt != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = txt;
	start = _tmp1_;
	{
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = txt;
		pos = _tmp2_;
		_tmp3_ = TRUE;
		while (TRUE) {
			const gchar* _tmp6_;
			gunichar _tmp7_;
			gunichar _tmp8_;
			gunichar _tmp9_;
			if (!_tmp3_) {
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = pos;
				_tmp5_ = g_utf8_next_char (_tmp4_);
				pos = _tmp5_;
			}
			_tmp3_ = FALSE;
			_tmp6_ = pos;
			_tmp7_ = string_get_char (_tmp6_, (glong) 0);
			c = _tmp7_;
			_tmp8_ = c;
			if (!(_tmp8_ != ((gunichar) '\0'))) {
				break;
			}
			_tmp9_ = c;
			if (_tmp9_ == ((gunichar) '&')) {
				const gchar* _tmp10_;
				gboolean _tmp11_;
				_tmp10_ = pos;
				_tmp11_ = g_str_has_prefix (_tmp10_, "&solidus;");
				if (_tmp11_) {
					GString* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					GString* _tmp18_;
					_tmp12_ = builder;
					_tmp13_ = start;
					_tmp14_ = pos;
					_tmp15_ = start;
					g_string_append_len (_tmp12_, _tmp13_, (gssize) (((gchar*) _tmp14_) - ((gchar*) _tmp15_)));
					_tmp16_ = pos;
					start = (const gchar*) (((gchar*) _tmp16_) + 9);
					_tmp17_ = pos;
					pos = (const gchar*) (((gchar*) _tmp17_) + 8);
					_tmp18_ = builder;
					g_string_append_unichar (_tmp18_, 8260U);
				} else {
					const gchar* _tmp19_;
					gboolean _tmp20_;
					_tmp19_ = pos;
					_tmp20_ = g_str_has_prefix (_tmp19_, "&percnt;");
					if (_tmp20_) {
						GString* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						GString* _tmp27_;
						_tmp21_ = builder;
						_tmp22_ = start;
						_tmp23_ = pos;
						_tmp24_ = start;
						g_string_append_len (_tmp21_, _tmp22_, (gssize) (((gchar*) _tmp23_) - ((gchar*) _tmp24_)));
						_tmp25_ = pos;
						start = (const gchar*) (((gchar*) _tmp25_) + 8);
						_tmp26_ = pos;
						pos = (const gchar*) (((gchar*) _tmp26_) + 7);
						_tmp27_ = builder;
						g_string_append_c (_tmp27_, '%');
					} else {
						const gchar* _tmp28_;
						gboolean _tmp29_;
						_tmp28_ = pos;
						_tmp29_ = g_str_has_prefix (_tmp28_, "&commat;");
						if (_tmp29_) {
							GString* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							GString* _tmp36_;
							_tmp30_ = builder;
							_tmp31_ = start;
							_tmp32_ = pos;
							_tmp33_ = start;
							g_string_append_len (_tmp30_, _tmp31_, (gssize) (((gchar*) _tmp32_) - ((gchar*) _tmp33_)));
							_tmp34_ = pos;
							start = (const gchar*) (((gchar*) _tmp34_) + 8);
							_tmp35_ = pos;
							pos = (const gchar*) (((gchar*) _tmp35_) + 7);
							_tmp36_ = builder;
							g_string_append_c (_tmp36_, '@');
						} else {
							const gchar* _tmp37_;
							gboolean _tmp38_;
							_tmp37_ = pos;
							_tmp38_ = g_str_has_prefix (_tmp37_, "&nbsp;");
							if (_tmp38_) {
								GString* _tmp39_;
								const gchar* _tmp40_;
								const gchar* _tmp41_;
								const gchar* _tmp42_;
								const gchar* _tmp43_;
								const gchar* _tmp44_;
								GString* _tmp45_;
								_tmp39_ = builder;
								_tmp40_ = start;
								_tmp41_ = pos;
								_tmp42_ = start;
								g_string_append_len (_tmp39_, _tmp40_, (gssize) (((gchar*) _tmp41_) - ((gchar*) _tmp42_)));
								_tmp43_ = pos;
								start = (const gchar*) (((gchar*) _tmp43_) + 6);
								_tmp44_ = pos;
								pos = (const gchar*) (((gchar*) _tmp44_) + 5);
								_tmp45_ = builder;
								g_string_append_c (_tmp45_, ' ');
							} else {
								const gchar* _tmp46_;
								gboolean _tmp47_;
								_tmp46_ = pos;
								_tmp47_ = g_str_has_prefix (_tmp46_, "&quot;");
								if (_tmp47_) {
									GString* _tmp48_;
									const gchar* _tmp49_;
									const gchar* _tmp50_;
									const gchar* _tmp51_;
									const gchar* _tmp52_;
									const gchar* _tmp53_;
									GString* _tmp54_;
									_tmp48_ = builder;
									_tmp49_ = start;
									_tmp50_ = pos;
									_tmp51_ = start;
									g_string_append_len (_tmp48_, _tmp49_, (gssize) (((gchar*) _tmp50_) - ((gchar*) _tmp51_)));
									_tmp52_ = pos;
									start = (const gchar*) (((gchar*) _tmp52_) + 6);
									_tmp53_ = pos;
									pos = (const gchar*) (((gchar*) _tmp53_) + 5);
									_tmp54_ = builder;
									g_string_append_c (_tmp54_, '"');
								} else {
									const gchar* _tmp55_;
									gboolean _tmp56_;
									_tmp55_ = pos;
									_tmp56_ = g_str_has_prefix (_tmp55_, "&apos;");
									if (_tmp56_) {
										GString* _tmp57_;
										const gchar* _tmp58_;
										const gchar* _tmp59_;
										const gchar* _tmp60_;
										const gchar* _tmp61_;
										const gchar* _tmp62_;
										GString* _tmp63_;
										_tmp57_ = builder;
										_tmp58_ = start;
										_tmp59_ = pos;
										_tmp60_ = start;
										g_string_append_len (_tmp57_, _tmp58_, (gssize) (((gchar*) _tmp59_) - ((gchar*) _tmp60_)));
										_tmp61_ = pos;
										start = (const gchar*) (((gchar*) _tmp61_) + 6);
										_tmp62_ = pos;
										pos = (const gchar*) (((gchar*) _tmp62_) + 5);
										_tmp63_ = builder;
										g_string_append_c (_tmp63_, '\'');
									} else {
										const gchar* _tmp64_;
										gboolean _tmp65_;
										_tmp64_ = pos;
										_tmp65_ = g_str_has_prefix (_tmp64_, "&lpar;");
										if (_tmp65_) {
											GString* _tmp66_;
											const gchar* _tmp67_;
											const gchar* _tmp68_;
											const gchar* _tmp69_;
											const gchar* _tmp70_;
											const gchar* _tmp71_;
											GString* _tmp72_;
											_tmp66_ = builder;
											_tmp67_ = start;
											_tmp68_ = pos;
											_tmp69_ = start;
											g_string_append_len (_tmp66_, _tmp67_, (gssize) (((gchar*) _tmp68_) - ((gchar*) _tmp69_)));
											_tmp70_ = pos;
											start = (const gchar*) (((gchar*) _tmp70_) + 6);
											_tmp71_ = pos;
											pos = (const gchar*) (((gchar*) _tmp71_) + 5);
											_tmp72_ = builder;
											g_string_append_c (_tmp72_, '(');
										} else {
											const gchar* _tmp73_;
											gboolean _tmp74_;
											_tmp73_ = pos;
											_tmp74_ = g_str_has_prefix (_tmp73_, "&rpar;");
											if (_tmp74_) {
												GString* _tmp75_;
												const gchar* _tmp76_;
												const gchar* _tmp77_;
												const gchar* _tmp78_;
												const gchar* _tmp79_;
												const gchar* _tmp80_;
												GString* _tmp81_;
												_tmp75_ = builder;
												_tmp76_ = start;
												_tmp77_ = pos;
												_tmp78_ = start;
												g_string_append_len (_tmp75_, _tmp76_, (gssize) (((gchar*) _tmp77_) - ((gchar*) _tmp78_)));
												_tmp79_ = pos;
												start = (const gchar*) (((gchar*) _tmp79_) + 6);
												_tmp80_ = pos;
												pos = (const gchar*) (((gchar*) _tmp80_) + 5);
												_tmp81_ = builder;
												g_string_append_c (_tmp81_, ')');
											} else {
												const gchar* _tmp82_;
												gboolean _tmp83_;
												_tmp82_ = pos;
												_tmp83_ = g_str_has_prefix (_tmp82_, "&num;");
												if (_tmp83_) {
													GString* _tmp84_;
													const gchar* _tmp85_;
													const gchar* _tmp86_;
													const gchar* _tmp87_;
													const gchar* _tmp88_;
													const gchar* _tmp89_;
													GString* _tmp90_;
													_tmp84_ = builder;
													_tmp85_ = start;
													_tmp86_ = pos;
													_tmp87_ = start;
													g_string_append_len (_tmp84_, _tmp85_, (gssize) (((gchar*) _tmp86_) - ((gchar*) _tmp87_)));
													_tmp88_ = pos;
													start = (const gchar*) (((gchar*) _tmp88_) + 5);
													_tmp89_ = pos;
													pos = (const gchar*) (((gchar*) _tmp89_) + 4);
													_tmp90_ = builder;
													g_string_append_c (_tmp90_, '#');
												} else {
													const gchar* _tmp91_;
													gboolean _tmp92_;
													_tmp91_ = pos;
													_tmp92_ = g_str_has_prefix (_tmp91_, "&amp;");
													if (_tmp92_) {
														GString* _tmp93_;
														const gchar* _tmp94_;
														const gchar* _tmp95_;
														const gchar* _tmp96_;
														const gchar* _tmp97_;
														const gchar* _tmp98_;
														GString* _tmp99_;
														_tmp93_ = builder;
														_tmp94_ = start;
														_tmp95_ = pos;
														_tmp96_ = start;
														g_string_append_len (_tmp93_, _tmp94_, (gssize) (((gchar*) _tmp95_) - ((gchar*) _tmp96_)));
														_tmp97_ = pos;
														start = (const gchar*) (((gchar*) _tmp97_) + 5);
														_tmp98_ = pos;
														pos = (const gchar*) (((gchar*) _tmp98_) + 4);
														_tmp99_ = builder;
														g_string_append_c (_tmp99_, '&');
													} else {
														const gchar* _tmp100_;
														gboolean _tmp101_;
														_tmp100_ = pos;
														_tmp101_ = g_str_has_prefix (_tmp100_, "&ast;");
														if (_tmp101_) {
															GString* _tmp102_;
															const gchar* _tmp103_;
															const gchar* _tmp104_;
															const gchar* _tmp105_;
															const gchar* _tmp106_;
															const gchar* _tmp107_;
															GString* _tmp108_;
															_tmp102_ = builder;
															_tmp103_ = start;
															_tmp104_ = pos;
															_tmp105_ = start;
															g_string_append_len (_tmp102_, _tmp103_, (gssize) (((gchar*) _tmp104_) - ((gchar*) _tmp105_)));
															_tmp106_ = pos;
															start = (const gchar*) (((gchar*) _tmp106_) + 5);
															_tmp107_ = pos;
															pos = (const gchar*) (((gchar*) _tmp107_) + 4);
															_tmp108_ = builder;
															g_string_append_c (_tmp108_, '*');
														} else {
															const gchar* _tmp109_;
															gboolean _tmp110_;
															_tmp109_ = pos;
															_tmp110_ = g_str_has_prefix (_tmp109_, "&pi;");
															if (_tmp110_) {
																GString* _tmp111_;
																const gchar* _tmp112_;
																const gchar* _tmp113_;
																const gchar* _tmp114_;
																const gchar* _tmp115_;
																const gchar* _tmp116_;
																GString* _tmp117_;
																_tmp111_ = builder;
																_tmp112_ = start;
																_tmp113_ = pos;
																_tmp114_ = start;
																g_string_append_len (_tmp111_, _tmp112_, (gssize) (((gchar*) _tmp113_) - ((gchar*) _tmp114_)));
																_tmp115_ = pos;
																start = (const gchar*) (((gchar*) _tmp115_) + 4);
																_tmp116_ = pos;
																pos = (const gchar*) (((gchar*) _tmp116_) + 3);
																_tmp117_ = builder;
																g_string_append_unichar (_tmp117_, 960U);
															} else {
																const gchar* _tmp118_;
																gboolean _tmp119_;
																_tmp118_ = pos;
																_tmp119_ = g_str_has_prefix (_tmp118_, "&lt;");
																if (_tmp119_) {
																	GString* _tmp120_;
																	const gchar* _tmp121_;
																	const gchar* _tmp122_;
																	const gchar* _tmp123_;
																	const gchar* _tmp124_;
																	const gchar* _tmp125_;
																	GString* _tmp126_;
																	_tmp120_ = builder;
																	_tmp121_ = start;
																	_tmp122_ = pos;
																	_tmp123_ = start;
																	g_string_append_len (_tmp120_, _tmp121_, (gssize) (((gchar*) _tmp122_) - ((gchar*) _tmp123_)));
																	_tmp124_ = pos;
																	start = (const gchar*) (((gchar*) _tmp124_) + 4);
																	_tmp125_ = pos;
																	pos = (const gchar*) (((gchar*) _tmp125_) + 3);
																	_tmp126_ = builder;
																	g_string_append_c (_tmp126_, '<');
																} else {
																	const gchar* _tmp127_;
																	gboolean _tmp128_;
																	_tmp127_ = pos;
																	_tmp128_ = g_str_has_prefix (_tmp127_, "&gt;");
																	if (_tmp128_) {
																		GString* _tmp129_;
																		const gchar* _tmp130_;
																		const gchar* _tmp131_;
																		const gchar* _tmp132_;
																		const gchar* _tmp133_;
																		const gchar* _tmp134_;
																		GString* _tmp135_;
																		_tmp129_ = builder;
																		_tmp130_ = start;
																		_tmp131_ = pos;
																		_tmp132_ = start;
																		g_string_append_len (_tmp129_, _tmp130_, (gssize) (((gchar*) _tmp131_) - ((gchar*) _tmp132_)));
																		_tmp133_ = pos;
																		start = (const gchar*) (((gchar*) _tmp133_) + 4);
																		_tmp134_ = pos;
																		pos = (const gchar*) (((gchar*) _tmp134_) + 3);
																		_tmp135_ = builder;
																		g_string_append_c (_tmp135_, '>');
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	if ((&txt) == (&start)) {
		const gchar* _tmp136_;
		gchar* _tmp137_;
		_tmp136_ = txt;
		_tmp137_ = g_strdup (_tmp136_);
		result = _tmp137_;
		_g_string_free0 (builder);
		return result;
	} else {
		GString* _tmp138_;
		const gchar* _tmp139_;
		const gchar* _tmp140_;
		const gchar* _tmp141_;
		GString* _tmp142_;
		gchar* _tmp143_;
		_tmp138_ = builder;
		_tmp139_ = start;
		_tmp140_ = pos;
		_tmp141_ = start;
		g_string_append_len (_tmp138_, _tmp139_, (gssize) (((gchar*) _tmp140_) - ((gchar*) _tmp141_)));
		_tmp142_ = builder;
		_tmp143_ = _tmp142_->str;
		_tmp142_->str = NULL;
		result = _tmp143_;
		_g_string_free0 (builder);
		return result;
	}
	_g_string_free0 (builder);
}


void valadoc_gtkdoc_scanner_reset (ValadocGtkdocScanner* self, const gchar* content) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = content;
	self->priv->content = _tmp0_;
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
	self->priv->tmp_token = NULL;
	_tmp1_ = content;
	self->priv->pos = _tmp1_;
	self->priv->column = 0;
	self->priv->line = 0;
}


static inline gunichar valadoc_gtkdoc_scanner_next_char (ValadocGtkdocScanner* self) {
	gunichar result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gunichar _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_utf8_next_char (_tmp0_);
	self->priv->pos = _tmp1_;
	_tmp2_ = self->priv->column;
	self->priv->column = _tmp2_ + 1;
	_tmp3_ = self->priv->pos;
	_tmp4_ = string_get_char (_tmp3_, (glong) 0);
	result = _tmp4_;
	return result;
}


static inline gunichar valadoc_gtkdoc_scanner_get (ValadocGtkdocScanner* self) {
	gunichar result = 0U;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->pos;
	_tmp1_ = string_get_char (_tmp0_, (glong) 0);
	result = _tmp1_;
	return result;
}


static inline gboolean valadoc_gtkdoc_scanner_letter (ValadocGtkdocScanner* self, gunichar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = c;
	if (_tmp2_ >= ((gunichar) 'a')) {
		gunichar _tmp3_;
		_tmp3_ = c;
		_tmp1_ = _tmp3_ <= ((gunichar) 'z');
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gunichar _tmp5_;
		_tmp5_ = c;
		if (_tmp5_ >= ((gunichar) 'A')) {
			gunichar _tmp6_;
			_tmp6_ = c;
			_tmp4_ = _tmp6_ <= ((gunichar) 'Z');
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean valadoc_gtkdoc_scanner_letter_or_number (ValadocGtkdocScanner* self, gunichar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gunichar _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = c;
	if (_tmp3_ >= ((gunichar) 'a')) {
		gunichar _tmp4_;
		_tmp4_ = c;
		_tmp2_ = _tmp4_ <= ((gunichar) 'z');
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_;
		_tmp6_ = c;
		if (_tmp6_ >= ((gunichar) 'A')) {
			gunichar _tmp7_;
			_tmp7_ = c;
			_tmp5_ = _tmp7_ <= ((gunichar) 'Z');
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gunichar _tmp9_;
		_tmp9_ = c;
		if (_tmp9_ >= ((gunichar) '0')) {
			gunichar _tmp10_;
			_tmp10_ = c;
			_tmp8_ = _tmp10_ <= ((gunichar) '9');
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	result = _tmp0_;
	return result;
}


static inline gboolean valadoc_gtkdoc_scanner_space (ValadocGtkdocScanner* self, gunichar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	if (_tmp1_ == ((gunichar) ' ')) {
		_tmp0_ = TRUE;
	} else {
		gunichar _tmp2_;
		_tmp2_ = c;
		_tmp0_ = _tmp2_ == ((gunichar) '\t');
	}
	result = _tmp0_;
	return result;
}


static inline gboolean valadoc_gtkdoc_scanner_space_or_newline (ValadocGtkdocScanner* self, gunichar c) {
	gboolean result = FALSE;
	gunichar _tmp0_;
	gunichar _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = c;
	if (_tmp0_ == ((gunichar) '\n')) {
		gint _tmp1_;
		_tmp1_ = self->priv->line;
		self->priv->line = _tmp1_ + 1;
		self->priv->column = 0;
		result = TRUE;
		return result;
	}
	_tmp2_ = c;
	_tmp3_ = valadoc_gtkdoc_scanner_space (self, _tmp2_);
	result = _tmp3_;
	return result;
}


static inline gint valadoc_gtkdoc_scanner_offset (ValadocGtkdocScanner* self, const gchar* a, const gchar* b) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = b;
	result = (gint) (((gchar*) _tmp0_) - ((gchar*) _tmp1_));
	return result;
}


static inline gint valadoc_gtkdoc_scanner_vararg_prefix (ValadocGtkdocScanner* self) {
	gint result = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_str_has_prefix (_tmp0_, "...");
	if (_tmp1_) {
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_next_char (self);
		result = 3;
		return result;
	}
	result = 0;
	return result;
}


static inline gint valadoc_gtkdoc_scanner_id_prefix (ValadocGtkdocScanner* self) {
	gint result = 0;
	gunichar c = 0U;
	gunichar _tmp0_;
	gboolean _tmp1_ = FALSE;
	gunichar _tmp2_;
	gboolean _tmp3_;
	gint start = 0;
	gint _tmp5_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	c = _tmp0_;
	_tmp2_ = c;
	_tmp3_ = valadoc_gtkdoc_scanner_letter (self, _tmp2_);
	if (!_tmp3_) {
		gunichar _tmp4_;
		_tmp4_ = c;
		_tmp1_ = _tmp4_ != ((gunichar) '_');
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = 0;
		return result;
	}
	_tmp5_ = self->priv->column;
	start = _tmp5_;
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_;
		gunichar _tmp8_;
		_tmp7_ = valadoc_gtkdoc_scanner_next_char (self);
		c = _tmp7_;
		_tmp8_ = c;
		if (_tmp8_ == ((gunichar) '_')) {
			_tmp6_ = TRUE;
		} else {
			gunichar _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = c;
			_tmp10_ = valadoc_gtkdoc_scanner_letter_or_number (self, _tmp9_);
			_tmp6_ = _tmp10_;
		}
		if (!_tmp6_) {
			break;
		}
	}
	_tmp11_ = self->priv->column;
	_tmp12_ = start;
	result = _tmp11_ - _tmp12_;
	return result;
}


static inline gint valadoc_gtkdoc_scanner_g_id_prefix (ValadocGtkdocScanner* self) {
	gint result = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gunichar c = 0U;
	gunichar _tmp1_;
	gunichar _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = valadoc_gtkdoc_scanner_get (self);
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = valadoc_gtkdoc_scanner_letter (self, _tmp2_);
	if (!_tmp3_) {
		result = 0;
		return result;
	}
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gunichar _tmp6_;
		gunichar _tmp7_;
		_tmp6_ = valadoc_gtkdoc_scanner_next_char (self);
		c = _tmp6_;
		_tmp7_ = c;
		if (_tmp7_ == ((gunichar) '_')) {
			_tmp5_ = TRUE;
		} else {
			gunichar _tmp8_;
			_tmp8_ = c;
			_tmp5_ = _tmp8_ == ((gunichar) '-');
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			gunichar _tmp9_;
			gboolean _tmp10_;
			_tmp9_ = c;
			_tmp10_ = valadoc_gtkdoc_scanner_letter_or_number (self, _tmp9_);
			_tmp4_ = _tmp10_;
		}
		if (!_tmp4_) {
			break;
		}
	}
	_tmp11_ = self->priv->pos;
	_tmp12_ = start;
	_tmp13_ = valadoc_gtkdoc_scanner_offset (self, _tmp11_, _tmp12_);
	result = _tmp13_;
	return result;
}


static inline gint valadoc_gtkdoc_scanner_skip_spaces_and_newlines (ValadocGtkdocScanner* self) {
	gint result = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gunichar _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = valadoc_gtkdoc_scanner_get (self);
	_tmp2_ = valadoc_gtkdoc_scanner_space_or_newline (self, _tmp1_);
	if (_tmp2_) {
		while (TRUE) {
			gunichar _tmp3_;
			gboolean _tmp4_;
			_tmp3_ = valadoc_gtkdoc_scanner_next_char (self);
			_tmp4_ = valadoc_gtkdoc_scanner_space_or_newline (self, _tmp3_);
			if (!_tmp4_) {
				break;
			}
		}
	}
	_tmp5_ = self->priv->pos;
	_tmp6_ = start;
	_tmp7_ = valadoc_gtkdoc_scanner_offset (self, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_function_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint id_len = 0;
	gint _tmp2_;
	gint _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	gunichar _tmp6_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	gunichar _tmp11_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	id_len = 0;
	_tmp2_ = valadoc_gtkdoc_scanner_id_prefix (self);
	id_len = _tmp2_;
	_tmp3_ = id_len;
	if (_tmp3_ == 0) {
		result = NULL;
		return result;
	}
	_tmp4_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp5_ = _tmp4_;
	_valadoc_gtkdoc_token_unref0 (_tmp5_);
	_tmp6_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp6_ != ((gunichar) '(')) {
		gint _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = column_start;
		self->priv->column = _tmp7_;
		_tmp8_ = start;
		self->priv->pos = _tmp8_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp9_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_tmp10_ = _tmp9_;
	_valadoc_gtkdoc_token_unref0 (_tmp10_);
	_tmp11_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp11_ != ((gunichar) ')')) {
		gint _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = column_start;
		self->priv->column = _tmp12_;
		_tmp13_ = start;
		self->priv->pos = _tmp13_;
		result = NULL;
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp14_ = start;
	_tmp15_ = id_len;
	_tmp16_ = string_substring (_tmp14_, (glong) 0, (glong) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = start;
	_tmp19_ = self->priv->pos;
	_tmp20_ = start;
	_tmp21_ = valadoc_gtkdoc_scanner_offset (self, _tmp19_, _tmp20_);
	_tmp22_ = self->priv->line;
	_tmp23_ = column_start;
	_tmp24_ = self->priv->column;
	_tmp25_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_FUNCTION, _tmp17_, NULL, _tmp18_, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp17_);
	result = _tmp26_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (ValadocGtkdocScanner* self, gunichar c, ValadocGtkdocTokenType type) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	gunichar _tmp1_;
	const gchar* start = NULL;
	const gchar* _tmp2_;
	gint column_start = 0;
	gint _tmp3_;
	gint id_len = 0;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* separator = NULL;
	const gchar* _tmp12_;
	gunichar _tmp13_;
	ValadocGtkdocTokenType _tmp46_;
	const gchar* _tmp47_;
	gint _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	ValadocGtkdocToken* _tmp58_;
	ValadocGtkdocToken* _tmp59_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	_tmp1_ = c;
	if (_tmp0_ != _tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->pos;
	start = _tmp2_;
	_tmp3_ = self->priv->column;
	column_start = _tmp3_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	_tmp4_ = valadoc_gtkdoc_scanner_id_prefix (self);
	id_len = _tmp4_;
	_tmp5_ = id_len;
	if (_tmp5_ == 0) {
		gboolean _tmp6_ = FALSE;
		ValadocGtkdocTokenType _tmp7_;
		_tmp7_ = type;
		if (_tmp7_ == VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM) {
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = valadoc_gtkdoc_scanner_vararg_prefix (self);
			id_len = _tmp8_;
			_tmp9_ = id_len;
			_tmp6_ = _tmp9_ == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = column_start;
			self->priv->column = _tmp10_;
			_tmp11_ = start;
			self->priv->pos = _tmp11_;
			result = NULL;
			return result;
		}
	}
	_tmp12_ = self->priv->pos;
	separator = _tmp12_;
	_tmp13_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp13_ == ((gunichar) ':')) {
		gint separator_len = 0;
		gunichar _tmp14_;
		gint id_len2 = 0;
		gint _tmp16_;
		gint _tmp17_;
		separator_len = 1;
		_tmp14_ = valadoc_gtkdoc_scanner_next_char (self);
		if (_tmp14_ == ((gunichar) ':')) {
			gint _tmp15_;
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp15_ = separator_len;
			separator_len = _tmp15_ + 1;
		}
		_tmp16_ = valadoc_gtkdoc_scanner_g_id_prefix (self);
		id_len2 = _tmp16_;
		_tmp17_ = id_len2;
		if (_tmp17_ == 0) {
			const gchar* _tmp18_;
			_tmp18_ = separator;
			self->priv->pos = _tmp18_;
		} else {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			_tmp19_ = id_len;
			_tmp20_ = id_len2;
			_tmp21_ = separator_len;
			id_len = _tmp19_ + (_tmp20_ + _tmp21_);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		const gchar* _tmp23_;
		gboolean _tmp24_;
		_tmp23_ = self->priv->pos;
		_tmp24_ = g_str_has_prefix (_tmp23_, "->");
		if (_tmp24_) {
			_tmp22_ = TRUE;
		} else {
			const gchar* _tmp25_;
			gboolean _tmp26_;
			_tmp25_ = self->priv->pos;
			_tmp26_ = g_str_has_prefix (_tmp25_, ".");
			_tmp22_ = _tmp26_;
		}
		if (_tmp22_) {
			const gchar* sep_start = NULL;
			const gchar* _tmp27_;
			gint sep_column_start = 0;
			gint _tmp28_;
			gint separator_len = 0;
			const gchar* _tmp29_;
			gboolean _tmp30_;
			ValadocGtkdocToken* func_token = NULL;
			ValadocGtkdocToken* _tmp31_;
			ValadocGtkdocToken* _tmp32_;
			_tmp27_ = self->priv->pos;
			sep_start = _tmp27_;
			_tmp28_ = self->priv->column;
			sep_column_start = _tmp28_;
			separator_len = 1;
			_tmp29_ = self->priv->pos;
			_tmp30_ = g_str_has_prefix (_tmp29_, "->");
			if (_tmp30_) {
				separator_len = 2;
				valadoc_gtkdoc_scanner_next_char (self);
			}
			valadoc_gtkdoc_scanner_next_char (self);
			_tmp31_ = valadoc_gtkdoc_scanner_function_prefix (self);
			func_token = _tmp31_;
			_tmp32_ = func_token;
			if (_tmp32_ == NULL) {
				gint id_len2 = 0;
				gint _tmp33_;
				gint _tmp34_;
				_tmp33_ = valadoc_gtkdoc_scanner_id_prefix (self);
				id_len2 = _tmp33_;
				_tmp34_ = id_len2;
				if (_tmp34_ > 0) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					_tmp35_ = id_len;
					_tmp36_ = separator_len;
					_tmp37_ = id_len2;
					id_len = _tmp35_ + (_tmp36_ + _tmp37_);
				} else {
					gint _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = sep_column_start;
					self->priv->column = _tmp38_;
					_tmp39_ = sep_start;
					self->priv->pos = _tmp39_;
				}
			} else {
				gint _tmp40_;
				gint _tmp41_;
				ValadocGtkdocToken* _tmp42_;
				const gchar* _tmp43_;
				gint _tmp44_;
				gint _tmp45_;
				_tmp40_ = id_len;
				_tmp41_ = separator_len;
				_tmp42_ = func_token;
				_tmp43_ = _tmp42_->content;
				_tmp44_ = strlen (_tmp43_);
				_tmp45_ = _tmp44_;
				id_len = _tmp40_ + (_tmp41_ + _tmp45_);
			}
			_valadoc_gtkdoc_token_unref0 (func_token);
		}
	}
	_tmp46_ = type;
	_tmp47_ = start;
	_tmp48_ = id_len;
	_tmp49_ = string_substring (_tmp47_, (glong) 1, (glong) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = start;
	_tmp52_ = self->priv->pos;
	_tmp53_ = start;
	_tmp54_ = valadoc_gtkdoc_scanner_offset (self, _tmp52_, _tmp53_);
	_tmp55_ = self->priv->line;
	_tmp56_ = column_start;
	_tmp57_ = self->priv->column;
	_tmp58_ = valadoc_gtkdoc_token_new (_tmp46_, _tmp50_, NULL, _tmp51_, _tmp54_, _tmp55_, _tmp56_, _tmp57_);
	_tmp59_ = _tmp58_;
	_g_free0 (_tmp50_);
	result = _tmp59_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_property_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	gint _tmp2_;
	gint id_len = 0;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp0_ != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->column;
	column_start = _tmp2_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	_tmp3_ = valadoc_gtkdoc_scanner_g_id_prefix (self);
	id_len = _tmp3_;
	_tmp4_ = id_len;
	if (_tmp4_ == 0) {
		gint _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = column_start;
		self->priv->column = _tmp5_;
		_tmp6_ = start;
		self->priv->pos = _tmp6_;
		result = NULL;
		return result;
	}
	_tmp7_ = start;
	_tmp8_ = id_len;
	_tmp9_ = string_substring (_tmp7_, (glong) 1, (glong) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = start;
	_tmp12_ = self->priv->pos;
	_tmp13_ = start;
	_tmp14_ = valadoc_gtkdoc_scanner_offset (self, _tmp12_, _tmp13_);
	_tmp15_ = self->priv->line;
	_tmp16_ = column_start;
	_tmp17_ = self->priv->column;
	_tmp18_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PROPERTY, _tmp10_, NULL, _tmp11_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp10_);
	result = _tmp19_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint column_start = 0;
	gint _tmp2_;
	gunichar _tmp3_;
	const gchar* _tmp6_;
	gint id_len = 0;
	gint _tmp7_;
	gint _tmp8_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	ValadocGtkdocToken* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp0_ != ((gunichar) ':')) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->column;
	column_start = _tmp2_;
	_tmp3_ = valadoc_gtkdoc_scanner_next_char (self);
	if (_tmp3_ != ((gunichar) ':')) {
		gint _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = column_start;
		self->priv->column = _tmp4_;
		_tmp5_ = start;
		self->priv->pos = _tmp5_;
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->pos;
	start = _tmp6_;
	valadoc_gtkdoc_scanner_next_char (self);
	id_len = 0;
	_tmp7_ = valadoc_gtkdoc_scanner_g_id_prefix (self);
	id_len = _tmp7_;
	_tmp8_ = id_len;
	if (_tmp8_ == 0) {
		gint _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = column_start;
		self->priv->column = _tmp9_;
		_tmp10_ = start;
		self->priv->pos = _tmp10_;
		result = NULL;
		return result;
	}
	_tmp11_ = start;
	_tmp12_ = id_len;
	_tmp13_ = string_substring (_tmp11_, (glong) 1, (glong) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = start;
	_tmp16_ = self->priv->pos;
	_tmp17_ = start;
	_tmp18_ = valadoc_gtkdoc_scanner_offset (self, _tmp16_, _tmp17_);
	_tmp19_ = self->priv->line;
	_tmp20_ = column_start;
	_tmp21_ = self->priv->column;
	_tmp22_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SIGNAL, _tmp14_, NULL, _tmp15_, _tmp18_, _tmp19_, _tmp20_, _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp14_);
	result = _tmp23_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_const_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '%', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_CONST);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_param_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '@', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAM);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_type_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_gtkdoc_symbolic_link_prefix (self, (gunichar) '#', VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_TYPE);
	result = _tmp0_;
	return result;
}


static inline ValadocGtkdocToken* valadoc_gtkdoc_scanner_xml_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint line_start = 0;
	gint _tmp2_;
	gint column_start = 0;
	gint _tmp3_;
	gunichar _tmp4_;
	gboolean close = FALSE;
	gunichar _tmp55_;
	const gchar* id_start = NULL;
	const gchar* _tmp56_;
	gint id_len = 0;
	gint _tmp57_;
	gint _tmp58_;
	ValaHashMap* map = NULL;
	GHashFunc _tmp61_;
	GEqualFunc _tmp62_;
	GEqualFunc _tmp63_;
	ValaHashMap* _tmp64_;
	gboolean open_and_close = FALSE;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_;
	gunichar _tmp97_;
	gboolean _tmp101_;
	gboolean _tmp114_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp0_ != ((gunichar) '<')) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->line;
	line_start = _tmp2_;
	_tmp3_ = self->priv->column;
	column_start = _tmp3_;
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp4_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp4_ == ((gunichar) '!')) {
		gunichar _tmp5_;
		const gchar* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		_tmp5_ = valadoc_gtkdoc_scanner_next_char (self);
		if (_tmp5_ == ((gunichar) '-')) {
			gunichar _tmp6_;
			_tmp6_ = valadoc_gtkdoc_scanner_next_char (self);
			if (_tmp6_ != ((gunichar) '-')) {
				gint _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = column_start;
				self->priv->column = _tmp7_;
				_tmp8_ = start;
				self->priv->pos = _tmp8_;
				result = NULL;
				return result;
			}
			{
				gunichar c = 0U;
				gunichar _tmp9_;
				_tmp9_ = valadoc_gtkdoc_scanner_next_char (self);
				c = _tmp9_;
				{
					gboolean _tmp10_ = FALSE;
					_tmp10_ = TRUE;
					while (TRUE) {
						gunichar _tmp12_;
						gunichar _tmp13_;
						if (!_tmp10_) {
							gunichar _tmp11_;
							_tmp11_ = valadoc_gtkdoc_scanner_next_char (self);
							c = _tmp11_;
						}
						_tmp10_ = FALSE;
						_tmp12_ = c;
						if (!(_tmp12_ != ((gunichar) '\0'))) {
							break;
						}
						_tmp13_ = c;
						if (_tmp13_ == ((gunichar) '\n')) {
							gint _tmp14_;
							_tmp14_ = self->priv->line;
							self->priv->line = _tmp14_ + 1;
							self->priv->column = 0;
						} else {
							const gchar* _tmp15_;
							gboolean _tmp16_;
							_tmp15_ = self->priv->pos;
							_tmp16_ = g_str_has_prefix (_tmp15_, "-->");
							if (_tmp16_) {
								const gchar* _tmp17_;
								const gchar* _tmp18_;
								const gchar* _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gint _tmp23_;
								ValadocGtkdocToken* _tmp24_;
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								valadoc_gtkdoc_scanner_next_char (self);
								_tmp17_ = start;
								_tmp18_ = self->priv->pos;
								_tmp19_ = start;
								_tmp20_ = valadoc_gtkdoc_scanner_offset (self, _tmp18_, _tmp19_);
								_tmp21_ = self->priv->line;
								_tmp22_ = column_start;
								_tmp23_ = self->priv->column;
								_tmp24_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_COMMENT, "", NULL, _tmp17_, _tmp20_, _tmp21_, _tmp22_, _tmp23_);
								result = _tmp24_;
								return result;
							}
						}
					}
				}
			}
		} else {
			const gchar* _tmp25_;
			gboolean _tmp26_;
			_tmp25_ = self->priv->pos;
			_tmp26_ = g_str_has_prefix (_tmp25_, "[CDATA[");
			if (_tmp26_) {
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				valadoc_gtkdoc_scanner_next_char (self);
				{
					gunichar c = 0U;
					gunichar _tmp27_;
					_tmp27_ = valadoc_gtkdoc_scanner_next_char (self);
					c = _tmp27_;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gunichar _tmp30_;
							gunichar _tmp31_;
							if (!_tmp28_) {
								gunichar _tmp29_;
								_tmp29_ = valadoc_gtkdoc_scanner_next_char (self);
								c = _tmp29_;
							}
							_tmp28_ = FALSE;
							_tmp30_ = c;
							if (!(_tmp30_ != ((gunichar) '\0'))) {
								break;
							}
							_tmp31_ = c;
							if (_tmp31_ == ((gunichar) '\n')) {
								gint _tmp32_;
								_tmp32_ = self->priv->line;
								self->priv->line = _tmp32_ + 1;
								self->priv->column = 0;
							} else {
								const gchar* _tmp33_;
								gboolean _tmp34_;
								_tmp33_ = self->priv->pos;
								_tmp34_ = g_str_has_prefix (_tmp33_, "]]>");
								if (_tmp34_) {
									gchar* content = NULL;
									const gchar* _tmp35_;
									const gchar* _tmp36_;
									const gchar* _tmp37_;
									gint _tmp38_;
									gchar* _tmp39_;
									const gchar* _tmp40_;
									gchar* _tmp41_;
									gchar* _tmp42_;
									const gchar* _tmp43_;
									const gchar* _tmp44_;
									const gchar* _tmp45_;
									gint _tmp46_;
									gint _tmp47_;
									gint _tmp48_;
									gint _tmp49_;
									ValadocGtkdocToken* _tmp50_;
									ValadocGtkdocToken* _tmp51_;
									_tmp35_ = start;
									_tmp36_ = self->priv->pos;
									_tmp37_ = start;
									_tmp38_ = valadoc_gtkdoc_scanner_offset (self, _tmp36_, _tmp37_);
									_tmp39_ = string_substring (_tmp35_, (glong) 9, (glong) (_tmp38_ - 9));
									content = _tmp39_;
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									valadoc_gtkdoc_scanner_next_char (self);
									_tmp40_ = content;
									_tmp41_ = valadoc_gtkdoc_scanner_unescape (_tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = start;
									_tmp44_ = self->priv->pos;
									_tmp45_ = start;
									_tmp46_ = valadoc_gtkdoc_scanner_offset (self, _tmp44_, _tmp45_);
									_tmp47_ = self->priv->line;
									_tmp48_ = column_start;
									_tmp49_ = self->priv->column;
									_tmp50_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp42_, NULL, _tmp43_, _tmp46_, _tmp47_, _tmp48_, _tmp49_);
									_tmp51_ = _tmp50_;
									_g_free0 (_tmp42_);
									result = _tmp51_;
									_g_free0 (content);
									return result;
								}
							}
						}
					}
				}
			}
		}
		_tmp52_ = start;
		self->priv->pos = _tmp52_;
		_tmp53_ = column_start;
		self->priv->column = _tmp53_;
		_tmp54_ = line_start;
		self->priv->line = _tmp54_;
		result = NULL;
		return result;
	}
	close = FALSE;
	_tmp55_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp55_ == ((gunichar) '/')) {
		valadoc_gtkdoc_scanner_next_char (self);
		close = TRUE;
	}
	_tmp56_ = self->priv->pos;
	id_start = _tmp56_;
	id_len = 0;
	_tmp57_ = valadoc_gtkdoc_scanner_id_prefix (self);
	id_len = _tmp57_;
	_tmp58_ = id_len;
	if (_tmp58_ == 0) {
		gint _tmp59_;
		const gchar* _tmp60_;
		_tmp59_ = column_start;
		self->priv->column = _tmp59_;
		_tmp60_ = start;
		self->priv->pos = _tmp60_;
		result = NULL;
		return result;
	}
	_tmp61_ = g_str_hash;
	_tmp62_ = g_str_equal;
	_tmp63_ = g_direct_equal;
	_tmp64_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp61_, _tmp62_, _tmp63_);
	map = _tmp64_;
	while (TRUE) {
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_;
		gchar* name = NULL;
		gchar* val = NULL;
		const gchar* att_pos = NULL;
		const gchar* _tmp68_;
		gint att_id_len = 0;
		gint _tmp69_;
		gint _tmp70_;
		const gchar* _tmp71_;
		gint _tmp72_;
		gchar* _tmp73_;
		gunichar _tmp74_;
		gunichar _tmp75_;
		gunichar c = 0U;
		gunichar _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp85_;
		const gchar* _tmp86_;
		const gchar* _tmp87_;
		gint _tmp88_;
		gchar* _tmp89_;
		gunichar _tmp90_;
		ValaHashMap* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp93_;
		_tmp66_ = close;
		if (_tmp66_ == FALSE) {
			gint _tmp67_;
			_tmp67_ = valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
			_tmp65_ = _tmp67_ > 0;
		} else {
			_tmp65_ = FALSE;
		}
		if (!_tmp65_) {
			break;
		}
		_tmp68_ = self->priv->pos;
		att_pos = _tmp68_;
		att_id_len = 0;
		_tmp69_ = valadoc_gtkdoc_scanner_id_prefix (self);
		att_id_len = _tmp69_;
		_tmp70_ = att_id_len;
		if (_tmp70_ == 0) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		_tmp71_ = att_pos;
		_tmp72_ = att_id_len;
		_tmp73_ = string_substring (_tmp71_, (glong) 0, (glong) _tmp72_);
		_g_free0 (name);
		name = _tmp73_;
		_tmp74_ = valadoc_gtkdoc_scanner_get (self);
		if (_tmp74_ != ((gunichar) '=')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
		_tmp75_ = valadoc_gtkdoc_scanner_get (self);
		if (_tmp75_ != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		_tmp76_ = valadoc_gtkdoc_scanner_next_char (self);
		c = _tmp76_;
		_tmp77_ = self->priv->pos;
		att_pos = _tmp77_;
		{
			gboolean _tmp78_ = FALSE;
			_tmp78_ = TRUE;
			while (TRUE) {
				gboolean _tmp80_ = FALSE;
				gboolean _tmp81_ = FALSE;
				gunichar _tmp82_;
				if (!_tmp78_) {
					gunichar _tmp79_;
					_tmp79_ = valadoc_gtkdoc_scanner_next_char (self);
					c = _tmp79_;
				}
				_tmp78_ = FALSE;
				_tmp82_ = c;
				if (_tmp82_ != ((gunichar) '\0')) {
					gunichar _tmp83_;
					_tmp83_ = c;
					_tmp81_ = _tmp83_ != ((gunichar) '\n');
				} else {
					_tmp81_ = FALSE;
				}
				if (_tmp81_) {
					gunichar _tmp84_;
					_tmp84_ = c;
					_tmp80_ = _tmp84_ != ((gunichar) '"');
				} else {
					_tmp80_ = FALSE;
				}
				if (!_tmp80_) {
					break;
				}
			}
		}
		_tmp85_ = att_pos;
		_tmp86_ = self->priv->pos;
		_tmp87_ = att_pos;
		_tmp88_ = valadoc_gtkdoc_scanner_offset (self, _tmp86_, _tmp87_);
		_tmp89_ = string_substring (_tmp85_, (glong) 0, (glong) _tmp88_);
		_g_free0 (val);
		val = _tmp89_;
		_tmp90_ = valadoc_gtkdoc_scanner_get (self);
		if (_tmp90_ != ((gunichar) '"')) {
			_g_free0 (val);
			_g_free0 (name);
			break;
		}
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp91_ = map;
		_tmp92_ = name;
		_tmp93_ = val;
		vala_map_set ((ValaMap*) _tmp91_, _tmp92_, _tmp93_);
		_g_free0 (val);
		_g_free0 (name);
	}
	valadoc_gtkdoc_scanner_skip_spaces_and_newlines (self);
	open_and_close = FALSE;
	_tmp95_ = close;
	if (!_tmp95_) {
		gunichar _tmp96_;
		_tmp96_ = valadoc_gtkdoc_scanner_get (self);
		_tmp94_ = _tmp96_ == ((gunichar) '/');
	} else {
		_tmp94_ = FALSE;
	}
	if (_tmp94_) {
		open_and_close = TRUE;
		valadoc_gtkdoc_scanner_next_char (self);
	}
	_tmp97_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp97_ != ((gunichar) '>')) {
		gint _tmp98_;
		gint _tmp99_;
		const gchar* _tmp100_;
		_tmp98_ = line_start;
		self->priv->line = _tmp98_;
		_tmp99_ = column_start;
		self->priv->column = _tmp99_;
		_tmp100_ = start;
		self->priv->pos = _tmp100_;
		result = NULL;
		_vala_map_unref0 (map);
		return result;
	}
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp101_ = open_and_close;
	if (_tmp101_) {
		const gchar* _tmp102_;
		gint _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		const gchar* _tmp106_;
		const gchar* _tmp107_;
		const gchar* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		ValadocGtkdocToken* _tmp113_;
		_tmp102_ = id_start;
		_tmp103_ = id_len;
		_tmp104_ = string_substring (_tmp102_, (glong) 0, (glong) _tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = start;
		_tmp107_ = self->priv->pos;
		_tmp108_ = start;
		_tmp109_ = valadoc_gtkdoc_scanner_offset (self, _tmp107_, _tmp108_);
		_tmp110_ = self->priv->line;
		_tmp111_ = column_start;
		_tmp112_ = self->priv->column;
		_tmp113_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp105_, NULL, _tmp106_, _tmp109_, _tmp110_, _tmp111_, _tmp112_);
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = _tmp113_;
		_g_free0 (_tmp105_);
	}
	_tmp114_ = close;
	if (_tmp114_) {
		const gchar* _tmp115_;
		gint _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		const gchar* _tmp119_;
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		gint _tmp122_;
		gint _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		ValadocGtkdocToken* _tmp126_;
		ValadocGtkdocToken* _tmp127_;
		_tmp115_ = id_start;
		_tmp116_ = id_len;
		_tmp117_ = string_substring (_tmp115_, (glong) 0, (glong) _tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = start;
		_tmp120_ = self->priv->pos;
		_tmp121_ = start;
		_tmp122_ = valadoc_gtkdoc_scanner_offset (self, _tmp120_, _tmp121_);
		_tmp123_ = self->priv->line;
		_tmp124_ = column_start;
		_tmp125_ = self->priv->column;
		_tmp126_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_CLOSE, _tmp118_, NULL, _tmp119_, _tmp122_, _tmp123_, _tmp124_, _tmp125_);
		_tmp127_ = _tmp126_;
		_g_free0 (_tmp118_);
		result = _tmp127_;
		_vala_map_unref0 (map);
		return result;
	} else {
		const gchar* _tmp128_;
		gint _tmp129_;
		gchar* _tmp130_;
		gchar* _tmp131_;
		ValaHashMap* _tmp132_;
		const gchar* _tmp133_;
		const gchar* _tmp134_;
		const gchar* _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _tmp139_;
		ValadocGtkdocToken* _tmp140_;
		ValadocGtkdocToken* _tmp141_;
		_tmp128_ = id_start;
		_tmp129_ = id_len;
		_tmp130_ = string_substring (_tmp128_, (glong) 0, (glong) _tmp129_);
		_tmp131_ = _tmp130_;
		_tmp132_ = map;
		_tmp133_ = start;
		_tmp134_ = self->priv->pos;
		_tmp135_ = start;
		_tmp136_ = valadoc_gtkdoc_scanner_offset (self, _tmp134_, _tmp135_);
		_tmp137_ = self->priv->line;
		_tmp138_ = column_start;
		_tmp139_ = self->priv->column;
		_tmp140_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_XML_OPEN, _tmp131_, _tmp132_, _tmp133_, _tmp136_, _tmp137_, _tmp138_, _tmp139_);
		_tmp141_ = _tmp140_;
		_g_free0 (_tmp131_);
		result = _tmp141_;
		_vala_map_unref0 (map);
		return result;
	}
	_vala_map_unref0 (map);
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_newline_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	gint _tmp2_;
	gunichar _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp0_ != ((gunichar) '\n')) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->line;
	self->priv->line = _tmp2_ + 1;
	self->priv->column = 0;
	{
		gunichar c = 0U;
		gunichar _tmp3_;
		_tmp3_ = valadoc_gtkdoc_scanner_next_char (self);
		c = _tmp3_;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gunichar _tmp7_;
				if (!_tmp4_) {
					gunichar _tmp5_;
					_tmp5_ = valadoc_gtkdoc_scanner_next_char (self);
					c = _tmp5_;
				}
				_tmp4_ = FALSE;
				_tmp7_ = c;
				if (_tmp7_ == ((gunichar) ' ')) {
					_tmp6_ = TRUE;
				} else {
					gunichar _tmp8_;
					_tmp8_ = c;
					_tmp6_ = _tmp8_ == ((gunichar) '\t');
				}
				if (!_tmp6_) {
					break;
				}
			}
		}
	}
	_tmp9_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp9_ == ((gunichar) '\n')) {
		gint _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		ValadocGtkdocToken* _tmp18_;
		valadoc_gtkdoc_scanner_next_char (self);
		_tmp10_ = self->priv->line;
		self->priv->line = _tmp10_ + 1;
		self->priv->column = 0;
		_tmp11_ = start;
		_tmp12_ = self->priv->pos;
		_tmp13_ = start;
		_tmp14_ = valadoc_gtkdoc_scanner_offset (self, _tmp12_, _tmp13_);
		_tmp15_ = self->priv->line;
		_tmp16_ = self->priv->column;
		_tmp17_ = self->priv->column;
		_tmp18_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_PARAGRAPH, "\n\n", NULL, _tmp11_, _tmp14_, _tmp15_, _tmp16_, _tmp17_);
		result = _tmp18_;
		return result;
	} else {
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		ValadocGtkdocToken* _tmp26_;
		_tmp19_ = start;
		_tmp20_ = self->priv->pos;
		_tmp21_ = start;
		_tmp22_ = valadoc_gtkdoc_scanner_offset (self, _tmp20_, _tmp21_);
		_tmp23_ = self->priv->line;
		_tmp24_ = self->priv->column;
		_tmp25_ = self->priv->column;
		_tmp26_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_NEWLINE, "\n", NULL, _tmp19_, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
		result = _tmp26_;
		return result;
	}
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_eof_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	gunichar _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = valadoc_gtkdoc_scanner_get (self);
	if (_tmp0_ != ((gunichar) '\0')) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->pos;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	_tmp4_ = self->priv->column;
	_tmp5_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_EOF, "", NULL, _tmp1_, 1, _tmp2_, _tmp3_, _tmp4_);
	result = _tmp5_;
	return result;
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_space_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gint len = 0;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	{
		gunichar c = 0U;
		gunichar _tmp2_;
		_tmp2_ = valadoc_gtkdoc_scanner_get (self);
		c = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				gunichar _tmp6_;
				if (!_tmp3_) {
					gunichar _tmp4_;
					_tmp4_ = valadoc_gtkdoc_scanner_next_char (self);
					c = _tmp4_;
				}
				_tmp3_ = FALSE;
				_tmp6_ = c;
				if (_tmp6_ == ((gunichar) ' ')) {
					_tmp5_ = TRUE;
				} else {
					gunichar _tmp7_;
					_tmp7_ = c;
					_tmp5_ = _tmp7_ == ((gunichar) '\t');
				}
				if (!_tmp5_) {
					break;
				}
			}
		}
	}
	_tmp8_ = self->priv->pos;
	_tmp9_ = start;
	_tmp10_ = valadoc_gtkdoc_scanner_offset (self, _tmp8_, _tmp9_);
	len = _tmp10_;
	_tmp11_ = len;
	if (_tmp11_ == 0) {
		gint _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = column_start;
		self->priv->column = _tmp12_;
		_tmp13_ = start;
		self->priv->pos = _tmp13_;
		result = NULL;
		return result;
	}
	_tmp14_ = start;
	_tmp15_ = len;
	_tmp16_ = string_substring (_tmp14_, (glong) 0, (glong) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = start;
	_tmp19_ = self->priv->pos;
	_tmp20_ = start;
	_tmp21_ = valadoc_gtkdoc_scanner_offset (self, _tmp19_, _tmp20_);
	_tmp22_ = self->priv->line;
	_tmp23_ = column_start;
	_tmp24_ = self->priv->column;
	_tmp25_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_SPACE, _tmp17_, NULL, _tmp18_, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp17_);
	result = _tmp26_;
	return result;
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_word_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gint column_start = 0;
	gint _tmp1_;
	gunichar c = 0U;
	gunichar _tmp2_;
	gboolean _tmp3_ = FALSE;
	gunichar _tmp4_;
	gint len = 0;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	const gchar* _tmp26_;
	gint _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	ValadocGtkdocToken* _tmp39_;
	ValadocGtkdocToken* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->column;
	column_start = _tmp1_;
	_tmp2_ = valadoc_gtkdoc_scanner_get (self);
	c = _tmp2_;
	_tmp4_ = c;
	if (_tmp4_ == ((gunichar) '<')) {
		_tmp3_ = TRUE;
	} else {
		gunichar _tmp5_;
		_tmp5_ = c;
		_tmp3_ = _tmp5_ == ((gunichar) '@');
	}
	if (_tmp3_) {
		valadoc_gtkdoc_scanner_next_char (self);
	}
	{
		gunichar _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = valadoc_gtkdoc_scanner_get (self);
		c = _tmp6_;
		_tmp7_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gunichar _tmp14_;
			if (!_tmp7_) {
				gunichar _tmp8_;
				_tmp8_ = valadoc_gtkdoc_scanner_next_char (self);
				c = _tmp8_;
			}
			_tmp7_ = FALSE;
			_tmp14_ = c;
			if (_tmp14_ != ((gunichar) ' ')) {
				gunichar _tmp15_;
				_tmp15_ = c;
				_tmp13_ = _tmp15_ != ((gunichar) '\t');
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gunichar _tmp16_;
				_tmp16_ = c;
				_tmp12_ = _tmp16_ != ((gunichar) '\n');
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gunichar _tmp17_;
				_tmp17_ = c;
				_tmp11_ = _tmp17_ != ((gunichar) '\0');
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gunichar _tmp18_;
				_tmp18_ = c;
				_tmp10_ = _tmp18_ != ((gunichar) '<');
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gunichar _tmp19_;
				_tmp19_ = c;
				_tmp9_ = _tmp19_ != ((gunichar) '@');
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
		}
	}
	_tmp20_ = self->priv->pos;
	_tmp21_ = start;
	_tmp22_ = valadoc_gtkdoc_scanner_offset (self, _tmp20_, _tmp21_);
	len = _tmp22_;
	_tmp23_ = len;
	if (_tmp23_ == 0) {
		gint _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = column_start;
		self->priv->column = _tmp24_;
		_tmp25_ = start;
		self->priv->pos = _tmp25_;
		result = NULL;
		return result;
	}
	_tmp26_ = start;
	_tmp27_ = len;
	_tmp28_ = string_substring (_tmp26_, (glong) 0, (glong) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = valadoc_gtkdoc_scanner_unescape (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = start;
	_tmp33_ = self->priv->pos;
	_tmp34_ = start;
	_tmp35_ = valadoc_gtkdoc_scanner_offset (self, _tmp33_, _tmp34_);
	_tmp36_ = self->priv->line;
	_tmp37_ = column_start;
	_tmp38_ = self->priv->column;
	_tmp39_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_WORD, _tmp31_, NULL, _tmp32_, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
	_tmp40_ = _tmp39_;
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	result = _tmp40_;
	return result;
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* start = NULL;
	const gchar* _tmp2_;
	gint column_start = 0;
	gint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_str_has_prefix (_tmp0_, "|[");
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->pos;
	start = _tmp2_;
	_tmp3_ = self->priv->column;
	column_start = _tmp3_;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp4_ = start;
	_tmp5_ = self->priv->pos;
	_tmp6_ = start;
	_tmp7_ = valadoc_gtkdoc_scanner_offset (self, _tmp5_, _tmp6_);
	_tmp8_ = self->priv->line;
	_tmp9_ = column_start;
	_tmp10_ = self->priv->column;
	_tmp11_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_OPEN, "|[", NULL, _tmp4_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	result = _tmp11_;
	return result;
}


static ValadocGtkdocToken* valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* start = NULL;
	const gchar* _tmp2_;
	gint column_start = 0;
	gint _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pos;
	_tmp1_ = g_str_has_prefix (_tmp0_, "]|");
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->pos;
	start = _tmp2_;
	_tmp3_ = self->priv->column;
	column_start = _tmp3_;
	valadoc_gtkdoc_scanner_next_char (self);
	valadoc_gtkdoc_scanner_next_char (self);
	_tmp4_ = start;
	_tmp5_ = self->priv->pos;
	_tmp6_ = start;
	_tmp7_ = valadoc_gtkdoc_scanner_offset (self, _tmp5_, _tmp6_);
	_tmp8_ = self->priv->line;
	_tmp9_ = column_start;
	_tmp10_ = self->priv->column;
	_tmp11_ = valadoc_gtkdoc_token_new (VALADOC_GTKDOC_TOKEN_TYPE_GTKDOC_SOURCE_CLOSE, "]|", NULL, _tmp4_, _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	result = _tmp11_;
	return result;
}


static gpointer _valadoc_gtkdoc_token_ref0 (gpointer self) {
	return self ? valadoc_gtkdoc_token_ref (self) : NULL;
}


ValadocGtkdocToken* valadoc_gtkdoc_scanner_next (ValadocGtkdocScanner* self) {
	ValadocGtkdocToken* result = NULL;
	ValadocGtkdocToken* _tmp0_;
	ValadocGtkdocToken* token = NULL;
	ValadocGtkdocToken* _tmp3_;
	ValadocGtkdocToken* _tmp4_;
	ValadocGtkdocToken* _tmp5_;
	ValadocGtkdocToken* _tmp6_;
	ValadocGtkdocToken* _tmp7_;
	ValadocGtkdocToken* _tmp8_;
	ValadocGtkdocToken* _tmp9_;
	ValadocGtkdocToken* _tmp10_;
	ValadocGtkdocToken* _tmp11_;
	ValadocGtkdocToken* _tmp12_;
	ValadocGtkdocToken* _tmp13_;
	ValadocGtkdocToken* _tmp14_;
	ValadocGtkdocToken* _tmp15_;
	ValadocGtkdocToken* _tmp16_;
	ValadocGtkdocToken* _tmp17_;
	ValadocGtkdocToken* _tmp18_;
	ValadocGtkdocToken* _tmp19_;
	ValadocGtkdocToken* _tmp20_;
	ValadocGtkdocToken* _tmp21_;
	ValadocGtkdocToken* _tmp22_;
	ValadocGtkdocToken* _tmp23_;
	ValadocGtkdocToken* _tmp24_;
	ValadocGtkdocToken* _tmp25_;
	ValadocGtkdocToken* _tmp26_;
	ValadocGtkdocToken* _tmp27_;
	ValadocGtkdocToken* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->tmp_token;
	if (_tmp0_ != NULL) {
		ValadocGtkdocToken* tmp = NULL;
		ValadocGtkdocToken* _tmp1_;
		ValadocGtkdocToken* _tmp2_;
		_tmp1_ = self->priv->tmp_token;
		_tmp2_ = _valadoc_gtkdoc_token_ref0 (_tmp1_);
		tmp = _tmp2_;
		_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
		self->priv->tmp_token = NULL;
		result = tmp;
		return result;
	}
	_tmp3_ = valadoc_gtkdoc_scanner_function_prefix (self);
	token = _tmp3_;
	_tmp4_ = token;
	if (_tmp4_ != NULL) {
		result = token;
		return result;
	}
	_tmp5_ = valadoc_gtkdoc_scanner_xml_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp5_;
	_tmp6_ = token;
	if (_tmp6_ != NULL) {
		result = token;
		return result;
	}
	_tmp7_ = valadoc_gtkdoc_scanner_gtkdoc_param_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp7_;
	_tmp8_ = token;
	if (_tmp8_ != NULL) {
		result = token;
		return result;
	}
	_tmp9_ = valadoc_gtkdoc_scanner_gtkdoc_const_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp9_;
	_tmp10_ = token;
	if (_tmp10_ != NULL) {
		result = token;
		return result;
	}
	_tmp11_ = valadoc_gtkdoc_scanner_gtkdoc_type_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp11_;
	_tmp12_ = token;
	if (_tmp12_ != NULL) {
		result = token;
		return result;
	}
	_tmp13_ = valadoc_gtkdoc_scanner_space_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp13_;
	_tmp14_ = token;
	if (_tmp14_ != NULL) {
		result = token;
		return result;
	}
	_tmp15_ = valadoc_gtkdoc_scanner_newline_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp15_;
	_tmp16_ = token;
	if (_tmp16_ != NULL) {
		result = token;
		return result;
	}
	_tmp17_ = valadoc_gtkdoc_scanner_gtkdoc_signal_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp17_;
	_tmp18_ = token;
	if (_tmp18_ != NULL) {
		result = token;
		return result;
	}
	_tmp19_ = valadoc_gtkdoc_scanner_gtkdoc_property_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp19_;
	_tmp20_ = token;
	if (_tmp20_ != NULL) {
		result = token;
		return result;
	}
	_tmp21_ = valadoc_gtkdoc_scanner_gtkdoc_source_open_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp21_;
	_tmp22_ = token;
	if (_tmp22_ != NULL) {
		result = token;
		return result;
	}
	_tmp23_ = valadoc_gtkdoc_scanner_gtkdoc_source_close_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp23_;
	_tmp24_ = token;
	if (_tmp24_ != NULL) {
		result = token;
		return result;
	}
	_tmp25_ = valadoc_gtkdoc_scanner_eof_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp25_;
	_tmp26_ = token;
	if (_tmp26_ != NULL) {
		result = token;
		return result;
	}
	_tmp27_ = valadoc_gtkdoc_scanner_word_prefix (self);
	_valadoc_gtkdoc_token_unref0 (token);
	token = _tmp27_;
	_tmp28_ = token;
	if (_tmp28_ != NULL) {
		result = token;
		return result;
	}
	g_assert_not_reached ();
	_valadoc_gtkdoc_token_unref0 (token);
}


static void valadoc_gtkdoc_value_scanner_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void valadoc_gtkdoc_value_scanner_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		valadoc_gtkdoc_scanner_unref (value->data[0].v_pointer);
	}
}


static void valadoc_gtkdoc_value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer valadoc_gtkdoc_value_scanner_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* valadoc_gtkdoc_value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValadocGtkdocScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_gtkdoc_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* valadoc_gtkdoc_value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValadocGtkdocScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* valadoc_gtkdoc_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValadocGtkdocParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer valadoc_gtkdoc_value_get_scanner (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void valadoc_gtkdoc_value_set_scanner (GValue* value, gpointer v_object) {
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_gtkdoc_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}


void valadoc_gtkdoc_value_take_scanner (GValue* value, gpointer v_object) {
	ValadocGtkdocScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_GTKDOC_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_GTKDOC_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_gtkdoc_scanner_unref (old);
	}
}


static void valadoc_gtkdoc_scanner_class_init (ValadocGtkdocScannerClass * klass) {
	valadoc_gtkdoc_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValadocGtkdocScannerClass *) klass)->finalize = valadoc_gtkdoc_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValadocGtkdocScannerPrivate));
}


static void valadoc_gtkdoc_scanner_instance_init (ValadocGtkdocScanner * self) {
	self->priv = VALADOC_GTKDOC_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void valadoc_gtkdoc_scanner_finalize (ValadocGtkdocScanner * obj) {
	ValadocGtkdocScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_GTKDOC_TYPE_SCANNER, ValadocGtkdocScanner);
	g_signal_handlers_destroy (self);
	_valadoc_gtkdoc_token_unref0 (self->priv->tmp_token);
}


GType valadoc_gtkdoc_scanner_get_type (void) {
	static volatile gsize valadoc_gtkdoc_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_gtkdoc_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_gtkdoc_value_scanner_init, valadoc_gtkdoc_value_scanner_free_value, valadoc_gtkdoc_value_scanner_copy_value, valadoc_gtkdoc_value_scanner_peek_pointer, "p", valadoc_gtkdoc_value_scanner_collect_value, "p", valadoc_gtkdoc_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocGtkdocScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_gtkdoc_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocGtkdocScanner), 0, (GInstanceInitFunc) valadoc_gtkdoc_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType valadoc_gtkdoc_scanner_type_id;
		valadoc_gtkdoc_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocGtkdocScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&valadoc_gtkdoc_scanner_type_id__volatile, valadoc_gtkdoc_scanner_type_id);
	}
	return valadoc_gtkdoc_scanner_type_id__volatile;
}


gpointer valadoc_gtkdoc_scanner_ref (gpointer instance) {
	ValadocGtkdocScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void valadoc_gtkdoc_scanner_unref (gpointer instance) {
	ValadocGtkdocScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_GTKDOC_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



