/* valablock.c generated by valac, the Vala compiler
 * generated from valablock.vala, do not modify */

/* valablock.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALA_BLOCK_DUMMY_PROPERTY,
	VALA_BLOCK_LAST_PROPERTY
};
static GParamSpec* vala_block_properties[VALA_BLOCK_LAST_PROPERTY];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaBlockPrivate {
	gboolean _contains_jump_statement;
	gboolean _captured;
	ValaList* statement_list;
	ValaList* local_variables;
	ValaList* local_constants;
};


static gpointer vala_block_parent_class = NULL;
static ValaStatementIface * vala_block_vala_statement_parent_iface = NULL;

#define VALA_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BLOCK, ValaBlockPrivate))
static void vala_block_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_block_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_block_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_block_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_block_finalize (ValaCodeNode * obj);


/**
 * Creates a new block.
 *
 * @param source_reference  reference to source code
 */
ValaBlock* vala_block_construct (GType object_type, ValaSourceReference* source_reference) {
	ValaBlock* self = NULL;
	ValaSourceReference* _tmp0_;
	_tmp0_ = source_reference;
	self = (ValaBlock*) vala_symbol_construct (object_type, NULL, _tmp0_, NULL);
	return self;
}


ValaBlock* vala_block_new (ValaSourceReference* source_reference) {
	return vala_block_construct (VALA_TYPE_BLOCK, source_reference);
}


/**
 * Append a statement to this block.
 *
 * @param stmt a statement
 */
void vala_block_add_statement (ValaBlock* self, ValaStatement* stmt) {
	ValaStatement* _tmp0_;
	ValaList* _tmp1_;
	ValaStatement* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = self->priv->statement_list;
	_tmp2_ = stmt;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
}


void vala_block_insert_statement (ValaBlock* self, gint index, ValaStatement* stmt) {
	ValaStatement* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	ValaStatement* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	_tmp0_ = stmt;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = self->priv->statement_list;
	_tmp2_ = index;
	_tmp3_ = stmt;
	vala_list_insert (_tmp1_, _tmp2_, _tmp3_);
}


/**
 * Returns a copy of the list of statements.
 *
 * @return statement list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaList* vala_block_get_statements (ValaBlock* self) {
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_STATEMENT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	list = _tmp1_;
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _stmt_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _stmt_index = 0;
		_tmp2_ = self->priv->statement_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_stmt_list = _tmp3_;
		_tmp4_ = _stmt_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_stmt_size = _tmp6_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaStatementList* stmt_list = NULL;
			ValaStatement* _tmp13_;
			ValaStatementList* _tmp14_;
			ValaStatementList* _tmp15_;
			_tmp7_ = _stmt_index;
			_stmt_index = _tmp7_ + 1;
			_tmp8_ = _stmt_index;
			_tmp9_ = _stmt_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _stmt_list;
			_tmp11_ = _stmt_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			stmt = (ValaStatement*) _tmp12_;
			_tmp13_ = stmt;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_STATEMENT_LIST) ? ((ValaStatementList*) _tmp13_) : NULL);
			stmt_list = _tmp14_;
			_tmp15_ = stmt_list;
			if (_tmp15_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp16_ = FALSE;
						_tmp16_ = TRUE;
						while (TRUE) {
							gint _tmp18_;
							ValaStatementList* _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							ValaArrayList* _tmp22_;
							ValaStatementList* _tmp23_;
							gint _tmp24_;
							ValaStatement* _tmp25_;
							ValaStatement* _tmp26_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = i;
								i = _tmp17_ + 1;
							}
							_tmp16_ = FALSE;
							_tmp18_ = i;
							_tmp19_ = stmt_list;
							_tmp20_ = vala_statement_list_get_length (_tmp19_);
							_tmp21_ = _tmp20_;
							if (!(_tmp18_ < _tmp21_)) {
								break;
							}
							_tmp22_ = list;
							_tmp23_ = stmt_list;
							_tmp24_ = i;
							_tmp25_ = vala_statement_list_get (_tmp23_, _tmp24_);
							_tmp26_ = _tmp25_;
							vala_collection_add ((ValaCollection*) _tmp22_, _tmp26_);
							_vala_code_node_unref0 (_tmp26_);
						}
					}
				}
			} else {
				ValaArrayList* _tmp27_;
				ValaStatement* _tmp28_;
				_tmp27_ = list;
				_tmp28_ = stmt;
				vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
			}
			_vala_code_node_unref0 (stmt_list);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	result = (ValaList*) list;
	return result;
}


/**
 * Add a local variable to this block.
 *
 * @param local a variable declarator
 */
void vala_block_add_local_variable (ValaBlock* self, ValaLocalVariable* local) {
	ValaSymbol* parent_block = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaList* _tmp29_;
	ValaLocalVariable* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent_block = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaLocalVariable* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		gboolean _tmp16_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp5_ = parent_block;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_BLOCK)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = parent_block;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_METHOD);
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = parent_block;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY_ACCESSOR);
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = parent_block;
		_tmp9_ = vala_symbol_get_scope (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = local;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_scope_lookup (_tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ != NULL;
		_vala_code_node_unref0 (_tmp15_);
		if (_tmp16_) {
			ValaLocalVariable* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaLocalVariable* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp17_ = local;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = local;
			_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("Local variable `%s' conflicts with a local variable or constant declar" \
"ed in a parent scope", _tmp22_);
			_tmp24_ = _tmp23_;
			vala_report_error (_tmp19_, _tmp24_);
			_g_free0 (_tmp24_);
			break;
		}
		_tmp25_ = parent_block;
		_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		_vala_code_node_unref0 (parent_block);
		parent_block = _tmp28_;
	}
	_tmp29_ = self->priv->local_variables;
	_tmp30_ = local;
	vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
	_vala_code_node_unref0 (parent_block);
}


void vala_block_remove_local_variable (ValaBlock* self, ValaLocalVariable* local) {
	ValaList* _tmp0_;
	ValaLocalVariable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->local_variables;
	_tmp1_ = local;
	vala_collection_remove ((ValaCollection*) _tmp0_, _tmp1_);
}


/**
 * Returns a copy of the list of local variables.
 *
 * @return variable declarator list
 */
ValaList* vala_block_get_local_variables (ValaBlock* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->local_variables;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void vala_block_add_local_constant (ValaBlock* self, ValaConstant* constant) {
	ValaSymbol* parent_block = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaList* _tmp29_;
	ValaConstant* _tmp30_;
	ValaScope* _tmp31_;
	ValaScope* _tmp32_;
	ValaConstant* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	ValaConstant* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	parent_block = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaConstant* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaSymbol* _tmp14_;
		ValaSymbol* _tmp15_;
		gboolean _tmp16_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp5_ = parent_block;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_BLOCK)) {
			_tmp4_ = TRUE;
		} else {
			ValaSymbol* _tmp6_;
			_tmp6_ = parent_block;
			_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_METHOD);
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp7_;
			_tmp7_ = parent_block;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY_ACCESSOR);
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = parent_block;
		_tmp9_ = vala_symbol_get_scope (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = constant;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_scope_lookup (_tmp10_, _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_ != NULL;
		_vala_code_node_unref0 (_tmp15_);
		if (_tmp16_) {
			ValaConstant* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaConstant* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp17_ = constant;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = constant;
			_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf ("Local constant `%s' conflicts with a local variable or constant declar" \
"ed in a parent scope", _tmp22_);
			_tmp24_ = _tmp23_;
			vala_report_error (_tmp19_, _tmp24_);
			_g_free0 (_tmp24_);
			break;
		}
		_tmp25_ = parent_block;
		_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _vala_code_node_ref0 (_tmp27_);
		_vala_code_node_unref0 (parent_block);
		parent_block = _tmp28_;
	}
	_tmp29_ = self->priv->local_constants;
	_tmp30_ = constant;
	vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
	_tmp31_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = constant;
	_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = constant;
	vala_scope_add (_tmp32_, _tmp35_, (ValaSymbol*) _tmp36_);
	_vala_code_node_unref0 (parent_block);
}


static void vala_block_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBlock * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaBlock*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_block (_tmp0_, self);
}


static void vala_block_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBlock * self;
	self = (ValaBlock*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _stmt_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _stmt_index = 0;
		_tmp0_ = self->priv->statement_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_stmt_list = _tmp1_;
		_tmp2_ = _stmt_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_stmt_size = _tmp4_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaStatement* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _stmt_index;
			_stmt_index = _tmp5_ + 1;
			_tmp6_ = _stmt_index;
			_tmp7_ = _stmt_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _stmt_list;
			_tmp9_ = _stmt_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			stmt = (ValaStatement*) _tmp10_;
			_tmp11_ = stmt;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
}


static gboolean vala_block_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaBlock * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSemanticAnalyzer* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaBlock* old_insert_block = NULL;
	ValaCodeContext* _tmp17_;
	ValaSemanticAnalyzer* _tmp18_;
	ValaSemanticAnalyzer* _tmp19_;
	ValaBlock* _tmp20_;
	ValaBlock* _tmp21_;
	ValaCodeContext* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSemanticAnalyzer* _tmp24_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaBlock* _tmp28_;
	ValaCodeContext* _tmp76_;
	ValaSemanticAnalyzer* _tmp77_;
	ValaSemanticAnalyzer* _tmp78_;
	ValaSymbol* _tmp79_;
	ValaCodeContext* _tmp80_;
	ValaSemanticAnalyzer* _tmp81_;
	ValaSemanticAnalyzer* _tmp82_;
	ValaBlock* _tmp83_;
	ValaBlock* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	self = (ValaBlock*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_symbol_get_scope (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_symbol_set_owner ((ValaSymbol*) self, _tmp10_);
	_tmp11_ = context;
	_tmp12_ = vala_code_context_get_analyzer (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_semantic_analyzer_get_current_symbol (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _vala_code_node_ref0 (_tmp15_);
	old_symbol = _tmp16_;
	_tmp17_ = context;
	_tmp18_ = vala_code_context_get_analyzer (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->insert_block;
	_tmp21_ = _vala_code_node_ref0 (_tmp20_);
	old_insert_block = _tmp21_;
	_tmp22_ = context;
	_tmp23_ = vala_code_context_get_analyzer (_tmp22_);
	_tmp24_ = _tmp23_;
	vala_semantic_analyzer_set_current_symbol (_tmp24_, (ValaSymbol*) self);
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = _vala_code_node_ref0 (self);
	_vala_code_node_unref0 (_tmp27_->insert_block);
	_tmp27_->insert_block = _tmp28_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp29_ = FALSE;
			_tmp29_ = TRUE;
			while (TRUE) {
				gint _tmp31_;
				ValaList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ValaList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_;
				ValaStatement* _tmp38_;
				ValaCodeContext* _tmp39_;
				if (!_tmp29_) {
					gint _tmp30_;
					_tmp30_ = i;
					i = _tmp30_ + 1;
				}
				_tmp29_ = FALSE;
				_tmp31_ = i;
				_tmp32_ = self->priv->statement_list;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				if (!(_tmp31_ < _tmp34_)) {
					break;
				}
				_tmp35_ = self->priv->statement_list;
				_tmp36_ = i;
				_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
				_tmp38_ = (ValaStatement*) _tmp37_;
				_tmp39_ = context;
				vala_code_node_check ((ValaCodeNode*) _tmp38_, _tmp39_);
				_vala_code_node_unref0 (_tmp38_);
			}
		}
	}
	{
		ValaList* _local_list = NULL;
		ValaList* _tmp40_;
		gint _local_size = 0;
		ValaList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _local_index = 0;
		_tmp40_ = vala_block_get_local_variables (self);
		_local_list = _tmp40_;
		_tmp41_ = _local_list;
		_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_local_size = _tmp43_;
		_local_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			ValaLocalVariable* local = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaLocalVariable* _tmp50_;
			_tmp44_ = _local_index;
			_local_index = _tmp44_ + 1;
			_tmp45_ = _local_index;
			_tmp46_ = _local_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _local_list;
			_tmp48_ = _local_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			local = (ValaLocalVariable*) _tmp49_;
			_tmp50_ = local;
			vala_symbol_set_active ((ValaSymbol*) _tmp50_, FALSE);
			_vala_code_node_unref0 (local);
		}
		_vala_iterable_unref0 (_local_list);
	}
	{
		ValaList* _constant_list = NULL;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		gint _constant_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _constant_index = 0;
		_tmp51_ = self->priv->local_constants;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_constant_list = _tmp52_;
		_tmp53_ = _constant_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_constant_size = _tmp55_;
		_constant_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaConstant* constant = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaConstant* _tmp62_;
			_tmp56_ = _constant_index;
			_constant_index = _tmp56_ + 1;
			_tmp57_ = _constant_index;
			_tmp58_ = _constant_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _constant_list;
			_tmp60_ = _constant_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			constant = (ValaConstant*) _tmp61_;
			_tmp62_ = constant;
			vala_symbol_set_active ((ValaSymbol*) _tmp62_, FALSE);
			_vala_code_node_unref0 (constant);
		}
		_vala_iterable_unref0 (_constant_list);
	}
	{
		ValaList* _stmt_list = NULL;
		ValaList* _tmp63_;
		gint _stmt_size = 0;
		ValaList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _stmt_index = 0;
		_tmp63_ = vala_block_get_statements (self);
		_stmt_list = _tmp63_;
		_tmp64_ = _stmt_list;
		_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		_stmt_size = _tmp66_;
		_stmt_index = -1;
		while (TRUE) {
			gint _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			ValaStatement* stmt = NULL;
			ValaList* _tmp70_;
			gint _tmp71_;
			gpointer _tmp72_;
			ValaStatement* _tmp73_;
			ValaList* _tmp74_;
			ValaList* _tmp75_;
			_tmp67_ = _stmt_index;
			_stmt_index = _tmp67_ + 1;
			_tmp68_ = _stmt_index;
			_tmp69_ = _stmt_size;
			if (!(_tmp68_ < _tmp69_)) {
				break;
			}
			_tmp70_ = _stmt_list;
			_tmp71_ = _stmt_index;
			_tmp72_ = vala_list_get (_tmp70_, _tmp71_);
			stmt = (ValaStatement*) _tmp72_;
			_tmp73_ = stmt;
			_tmp74_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp73_);
			_tmp75_ = _tmp74_;
			vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp75_);
			_vala_iterable_unref0 (_tmp75_);
			_vala_code_node_unref0 (stmt);
		}
		_vala_iterable_unref0 (_stmt_list);
	}
	_tmp76_ = context;
	_tmp77_ = vala_code_context_get_analyzer (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp78_, _tmp79_);
	_tmp80_ = context;
	_tmp81_ = vala_code_context_get_analyzer (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = old_insert_block;
	_tmp84_ = _vala_code_node_ref0 (_tmp83_);
	_vala_code_node_unref0 (_tmp82_->insert_block);
	_tmp82_->insert_block = _tmp84_;
	_tmp85_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp86_ = _tmp85_;
	result = !_tmp86_;
	_vala_code_node_unref0 (old_insert_block);
	_vala_code_node_unref0 (old_symbol);
	return result;
}


static void vala_block_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaBlock * self;
	ValaCodeGenerator* _tmp0_;
	self = (ValaBlock*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = codegen;
	vala_code_visitor_visit_block ((ValaCodeVisitor*) _tmp0_, self);
}


void vala_block_insert_before (ValaBlock* self, ValaStatement* stmt, ValaStatement* new_stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (stmt != NULL);
	g_return_if_fail (new_stmt != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaStatementList* stmt_list = NULL;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaStatement* _tmp9_;
				ValaStatementList* _tmp10_;
				ValaStatementList* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->statement_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->statement_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaStatement*) _tmp8_;
				_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STATEMENT_LIST) ? ((ValaStatementList*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_vala_code_node_unref0 (_tmp9_);
				}
				stmt_list = _tmp10_;
				_tmp11_ = stmt_list;
				if (_tmp11_ != NULL) {
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								gint _tmp14_;
								ValaStatementList* _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								ValaStatementList* _tmp18_;
								gint _tmp19_;
								ValaStatement* _tmp20_;
								ValaStatement* _tmp21_;
								ValaStatement* _tmp22_;
								gboolean _tmp23_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = j;
									j = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = j;
								_tmp15_ = stmt_list;
								_tmp16_ = vala_statement_list_get_length (_tmp15_);
								_tmp17_ = _tmp16_;
								if (!(_tmp14_ < _tmp17_)) {
									break;
								}
								_tmp18_ = stmt_list;
								_tmp19_ = j;
								_tmp20_ = vala_statement_list_get (_tmp18_, _tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = stmt;
								_tmp23_ = _tmp21_ == _tmp22_;
								_vala_code_node_unref0 (_tmp21_);
								if (_tmp23_) {
									ValaStatementList* _tmp24_;
									gint _tmp25_;
									ValaStatement* _tmp26_;
									ValaStatement* _tmp27_;
									_tmp24_ = stmt_list;
									_tmp25_ = j;
									_tmp26_ = new_stmt;
									vala_statement_list_insert (_tmp24_, _tmp25_, _tmp26_);
									_tmp27_ = new_stmt;
									vala_code_node_set_parent_node ((ValaCodeNode*) _tmp27_, (ValaCodeNode*) self);
									break;
								}
							}
						}
					}
				} else {
					ValaList* _tmp28_;
					gint _tmp29_;
					gpointer _tmp30_;
					ValaStatement* _tmp31_;
					ValaStatement* _tmp32_;
					gboolean _tmp33_;
					_tmp28_ = self->priv->statement_list;
					_tmp29_ = i;
					_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
					_tmp31_ = (ValaStatement*) _tmp30_;
					_tmp32_ = stmt;
					_tmp33_ = _tmp31_ == _tmp32_;
					_vala_code_node_unref0 (_tmp31_);
					if (_tmp33_) {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaStatementList* _tmp36_;
						ValaStatementList* _tmp37_;
						ValaStatement* _tmp38_;
						ValaStatementList* _tmp39_;
						ValaStatement* _tmp40_;
						ValaList* _tmp41_;
						gint _tmp42_;
						ValaStatementList* _tmp43_;
						ValaStatement* _tmp44_;
						_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp35_ = _tmp34_;
						_tmp36_ = vala_statement_list_new (_tmp35_);
						_vala_code_node_unref0 (stmt_list);
						stmt_list = _tmp36_;
						_tmp37_ = stmt_list;
						_tmp38_ = new_stmt;
						vala_statement_list_add (_tmp37_, _tmp38_);
						_tmp39_ = stmt_list;
						_tmp40_ = stmt;
						vala_statement_list_add (_tmp39_, _tmp40_);
						_tmp41_ = self->priv->statement_list;
						_tmp42_ = i;
						_tmp43_ = stmt_list;
						vala_list_set (_tmp41_, _tmp42_, (ValaStatement*) _tmp43_);
						_tmp44_ = new_stmt;
						vala_code_node_set_parent_node ((ValaCodeNode*) _tmp44_, (ValaCodeNode*) self);
					}
				}
				_vala_code_node_unref0 (stmt_list);
			}
		}
	}
}


void vala_block_replace_statement (ValaBlock* self, ValaStatement* old_stmt, ValaStatement* new_stmt) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_stmt != NULL);
	g_return_if_fail (new_stmt != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaStatementList* stmt_list = NULL;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaStatement* _tmp9_;
				ValaStatementList* _tmp10_;
				ValaStatementList* _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->statement_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->statement_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaStatement*) _tmp8_;
				_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_STATEMENT_LIST) ? ((ValaStatementList*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_vala_code_node_unref0 (_tmp9_);
				}
				stmt_list = _tmp10_;
				_tmp11_ = stmt_list;
				if (_tmp11_ != NULL) {
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp12_ = FALSE;
							_tmp12_ = TRUE;
							while (TRUE) {
								gint _tmp14_;
								ValaStatementList* _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								ValaStatementList* _tmp18_;
								gint _tmp19_;
								ValaStatement* _tmp20_;
								ValaStatement* _tmp21_;
								ValaStatement* _tmp22_;
								gboolean _tmp23_;
								if (!_tmp12_) {
									gint _tmp13_;
									_tmp13_ = j;
									j = _tmp13_ + 1;
								}
								_tmp12_ = FALSE;
								_tmp14_ = j;
								_tmp15_ = stmt_list;
								_tmp16_ = vala_statement_list_get_length (_tmp15_);
								_tmp17_ = _tmp16_;
								if (!(_tmp14_ < _tmp17_)) {
									break;
								}
								_tmp18_ = stmt_list;
								_tmp19_ = j;
								_tmp20_ = vala_statement_list_get (_tmp18_, _tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = old_stmt;
								_tmp23_ = _tmp21_ == _tmp22_;
								_vala_code_node_unref0 (_tmp21_);
								if (_tmp23_) {
									ValaStatementList* _tmp24_;
									gint _tmp25_;
									ValaStatement* _tmp26_;
									ValaStatement* _tmp27_;
									_tmp24_ = stmt_list;
									_tmp25_ = j;
									_tmp26_ = new_stmt;
									vala_statement_list_set (_tmp24_, _tmp25_, _tmp26_);
									_tmp27_ = new_stmt;
									vala_code_node_set_parent_node ((ValaCodeNode*) _tmp27_, (ValaCodeNode*) self);
									break;
								}
							}
						}
					}
				} else {
					ValaList* _tmp28_;
					gint _tmp29_;
					gpointer _tmp30_;
					ValaStatement* _tmp31_;
					ValaStatement* _tmp32_;
					gboolean _tmp33_;
					_tmp28_ = self->priv->statement_list;
					_tmp29_ = i;
					_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
					_tmp31_ = (ValaStatement*) _tmp30_;
					_tmp32_ = old_stmt;
					_tmp33_ = _tmp31_ == _tmp32_;
					_vala_code_node_unref0 (_tmp31_);
					if (_tmp33_) {
						ValaList* _tmp34_;
						gint _tmp35_;
						ValaStatement* _tmp36_;
						ValaStatement* _tmp37_;
						_tmp34_ = self->priv->statement_list;
						_tmp35_ = i;
						_tmp36_ = new_stmt;
						vala_list_set (_tmp34_, _tmp35_, _tmp36_);
						_tmp37_ = new_stmt;
						vala_code_node_set_parent_node ((ValaCodeNode*) _tmp37_, (ValaCodeNode*) self);
						_vala_code_node_unref0 (stmt_list);
						break;
					}
				}
				_vala_code_node_unref0 (stmt_list);
			}
		}
	}
}


gboolean vala_block_get_contains_jump_statement (ValaBlock* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_contains_jump_statement;
	result = _tmp0_;
	return result;
}


void vala_block_set_contains_jump_statement (ValaBlock* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_contains_jump_statement = _tmp0_;
}


gboolean vala_block_get_captured (ValaBlock* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void vala_block_set_captured (ValaBlock* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_captured = _tmp0_;
}


static void vala_block_class_init (ValaBlockClass * klass) {
	vala_block_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaBlockPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_block_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_block_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_block_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_block_real_emit;
}


static void vala_block_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_block_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_block_instance_init (ValaBlock * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->priv = VALA_BLOCK_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_STATEMENT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->statement_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->local_variables = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->local_constants = (ValaList*) _tmp5_;
}


static void vala_block_finalize (ValaCodeNode * obj) {
	ValaBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BLOCK, ValaBlock);
	_vala_iterable_unref0 (self->priv->statement_list);
	_vala_iterable_unref0 (self->priv->local_variables);
	_vala_iterable_unref0 (self->priv->local_constants);
	VALA_CODE_NODE_CLASS (vala_block_parent_class)->finalize (obj);
}


/**
 * Represents a source code block.
 */
GType vala_block_get_type (void) {
	static volatile gsize vala_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBlock), 0, (GInstanceInitFunc) vala_block_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_block_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_block_type_id;
		vala_block_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaBlock", &g_define_type_info, 0);
		g_type_add_interface_static (vala_block_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_block_type_id__volatile, vala_block_type_id);
	}
	return vala_block_type_id__volatile;
}



