Debugging uzbl
==============

Uzbl offers lots of information about what is going on, but debugging what is
going wrong is not always the easiest thing. Depending on the problem you are
having, different things are useful.

Reporting issues
----------------

Issues should come with the output of the `--bug-info` flag to `uzbl-core` which
prints out relevant information for how uzbl was built.

Event stream
------------

First, there is uzbl's event stream which is accessible with the `-p` or
`--print-events` flag to `uzbl-core`. The default bindings use `<Ctrl><Alt>t` to
launch a terminal which just shows everything placed into uzbl's event stream.
See the [README](README.md) file for a list of events that are builtin to uzbl.
Any events which don't show up there are generated by the configuration or the
event manager via the `event` command.

***WARNING***: This stream contains everything from passwords (through the
keyboard events) to cookies, so when sending it in with a report, be careful to
scrub it of any private information that may be in the stream.

Usually the stream will be the best place to look for information to assist in
debugging issues with websites such as why resources aren't loading.

Uzbl logging
------------

When the event stream seems to be correct, but uzbl itself is behaving oddly,
the `-v` or `--verbose` flag which causes it to print out internal information
which is usually related to uzbl enacting policy decisions made by an external
event manager or the configuration itself.

Event manager logging
---------------------

The event manager is where lots of the actual behavior and policies of uzbl are
implemented. This includes things such as keybindings, cookie management, the
prompt in the status bar, and policy decisions. Debugging the event manager can
get tricky, but it does provide a `-v` or `--verbose` option to be more verbose
as to what it is doing (specifically, it prints out the information it receives
from uzbl and its replies back). It is best to couple with the `-n` or
`--no-daemon` option to keep the daemon in the foreground.

***WARNING***: The event stream here holds the same caveat as uzbl's event
stream. Passwords, cookies, and other potentially private information is
included.

One thing to keep in mind is that when the event manager is restarted, all uzbl
instances using the old event managers *will cease to behave properly* because
there is no longer an event manager to react to your input. You may still
control it via its fifo or socket, but these sockets do not receive `request`
messages.

Minimal test cases
------------------

Minimal test cases are very useful and can be made using custom configuration
files passed to uzbl via the `-c` flag. Coupled with `--named` to get a
predictable socket name, commands can be sent using a program or text file. When
reporting bugs, these can help immensely in finding problems.

Sandbox
-------

The Makefile contains special build targets to install and run the local build
in a isolated environment dubbed the sandbox. `virtualenv` is used to create
the python environment for the sandbox and will need to be installed on your
system.

To start uzbl in the sandbox use ```make test-uzbl-browser-sandbox```
