//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#include "pxr/usd/usdRi/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdRiTokensType::UsdRiTokensType() :
    analytic("analytic", TfToken::Immortal),
    analyticApex("analytic:apex", TfToken::Immortal),
    analyticBlurAmount("analytic:blur:amount", TfToken::Immortal),
    analyticBlurExponent("analytic:blur:exponent", TfToken::Immortal),
    analyticBlurFarDistance("analytic:blur:farDistance", TfToken::Immortal),
    analyticBlurFarValue("analytic:blur:farValue", TfToken::Immortal),
    analyticBlurMidpoint("analytic:blur:midpoint", TfToken::Immortal),
    analyticBlurMidValue("analytic:blur:midValue", TfToken::Immortal),
    analyticBlurNearDistance("analytic:blur:nearDistance", TfToken::Immortal),
    analyticBlurNearValue("analytic:blur:nearValue", TfToken::Immortal),
    analyticBlurSMult("analytic:blur:sMult", TfToken::Immortal),
    analyticBlurTMult("analytic:blur:tMult", TfToken::Immortal),
    analyticDensityExponent("analytic:density:exponent", TfToken::Immortal),
    analyticDensityFarDistance("analytic:density:farDistance", TfToken::Immortal),
    analyticDensityFarValue("analytic:density:farValue", TfToken::Immortal),
    analyticDensityMidpoint("analytic:density:midpoint", TfToken::Immortal),
    analyticDensityMidValue("analytic:density:midValue", TfToken::Immortal),
    analyticDensityNearDistance("analytic:density:nearDistance", TfToken::Immortal),
    analyticDensityNearValue("analytic:density:nearValue", TfToken::Immortal),
    analyticDirectional("analytic:directional", TfToken::Immortal),
    analyticShearX("analytic:shearX", TfToken::Immortal),
    analyticShearY("analytic:shearY", TfToken::Immortal),
    analyticUseLightDirection("analytic:useLightDirection", TfToken::Immortal),
    aovName("aovName", TfToken::Immortal),
    argsPath("argsPath", TfToken::Immortal),
    barnMode("barnMode", TfToken::Immortal),
    beginDistance("beginDistance", TfToken::Immortal),
    bspline("bspline", TfToken::Immortal),
    catmull_rom("catmull-rom", TfToken::Immortal),
    catmullRom("catmull-rom", TfToken::Immortal),
    clamp("clamp", TfToken::Immortal),
    colorContrast("color:contrast", TfToken::Immortal),
    colorMidpoint("color:midpoint", TfToken::Immortal),
    colorRamp("colorRamp", TfToken::Immortal),
    colorRampColors("colorRamp:colors", TfToken::Immortal),
    colorRampInterpolation("colorRamp:interpolation", TfToken::Immortal),
    colorRampKnots("colorRamp:knots", TfToken::Immortal),
    colorSaturation("color:saturation", TfToken::Immortal),
    colorTint("color:tint", TfToken::Immortal),
    colorWhitepoint("color:whitepoint", TfToken::Immortal),
    cone("cone", TfToken::Immortal),
    constant("constant", TfToken::Immortal),
    cookieMode("cookieMode", TfToken::Immortal),
    day("day", TfToken::Immortal),
    depth("depth", TfToken::Immortal),
    distanceToLight("distanceToLight", TfToken::Immortal),
    edgeScaleBack("edgeScale:back", TfToken::Immortal),
    edgeScaleBottom("edgeScale:bottom", TfToken::Immortal),
    edgeScaleFront("edgeScale:front", TfToken::Immortal),
    edgeScaleLeft("edgeScale:left", TfToken::Immortal),
    edgeScaleRight("edgeScale:right", TfToken::Immortal),
    edgeScaleTop("edgeScale:top", TfToken::Immortal),
    edgeThickness("edgeThickness", TfToken::Immortal),
    endDistance("endDistance", TfToken::Immortal),
    falloff("falloff", TfToken::Immortal),
    falloffFloats("falloff:floats", TfToken::Immortal),
    falloffInterpolation("falloff:interpolation", TfToken::Immortal),
    falloffKnots("falloff:knots", TfToken::Immortal),
    filePath("filePath", TfToken::Immortal),
    haziness("haziness", TfToken::Immortal),
    height("height", TfToken::Immortal),
    hour("hour", TfToken::Immortal),
    infoArgsPath("info:argsPath", TfToken::Immortal),
    infoFilePath("info:filePath", TfToken::Immortal),
    infoOslPath("info:oslPath", TfToken::Immortal),
    infoSloPath("info:sloPath", TfToken::Immortal),
    inPrimaryHit("inPrimaryHit", TfToken::Immortal),
    inReflection("inReflection", TfToken::Immortal),
    inRefraction("inRefraction", TfToken::Immortal),
    interpolation("interpolation", TfToken::Immortal),
    invert("invert", TfToken::Immortal),
    latitude("latitude", TfToken::Immortal),
    linear("linear", TfToken::Immortal),
    longitude("longitude", TfToken::Immortal),
    max("max", TfToken::Immortal),
    min("min", TfToken::Immortal),
    month("month", TfToken::Immortal),
    multiply("multiply", TfToken::Immortal),
    noEffect("noEffect", TfToken::Immortal),
    noLight("noLight", TfToken::Immortal),
    off("off", TfToken::Immortal),
    onVolumeBoundaries("onVolumeBoundaries", TfToken::Immortal),
    outputsRiDisplacement("outputs:ri:displacement", TfToken::Immortal),
    outputsRiSurface("outputs:ri:surface", TfToken::Immortal),
    outputsRiVolume("outputs:ri:volume", TfToken::Immortal),
    physical("physical", TfToken::Immortal),
    positions("positions", TfToken::Immortal),
    preBarnEffect("preBarnEffect", TfToken::Immortal),
    radial("radial", TfToken::Immortal),
    radius("radius", TfToken::Immortal),
    rampMode("rampMode", TfToken::Immortal),
    refineBack("refine:back", TfToken::Immortal),
    refineBottom("refine:bottom", TfToken::Immortal),
    refineFront("refine:front", TfToken::Immortal),
    refineLeft("refine:left", TfToken::Immortal),
    refineRight("refine:right", TfToken::Immortal),
    refineTop("refine:top", TfToken::Immortal),
    repeat("repeat", TfToken::Immortal),
    riCombineMode("ri:combineMode", TfToken::Immortal),
    riDensity("ri:density", TfToken::Immortal),
    riDiffuse("ri:diffuse", TfToken::Immortal),
    riExposure("ri:exposure", TfToken::Immortal),
    riIntensity("ri:intensity", TfToken::Immortal),
    riIntensityNearDist("ri:intensityNearDist", TfToken::Immortal),
    riInvert("ri:invert", TfToken::Immortal),
    riLightGroup("ri:lightGroup", TfToken::Immortal),
    riPortalIntensity("ri:portal:intensity", TfToken::Immortal),
    riPortalTint("ri:portal:tint", TfToken::Immortal),
    riSamplingFixedSampleCount("ri:sampling:fixedSampleCount", TfToken::Immortal),
    riSamplingImportanceMultiplier("ri:sampling:importanceMultiplier", TfToken::Immortal),
    riShadowThinShadow("ri:shadow:thinShadow", TfToken::Immortal),
    riSpecular("ri:specular", TfToken::Immortal),
    riTextureGamma("ri:texture:gamma", TfToken::Immortal),
    riTextureSaturation("ri:texture:saturation", TfToken::Immortal),
    riTraceLightPaths("ri:trace:lightPaths", TfToken::Immortal),
    scaleDepth("scale:depth", TfToken::Immortal),
    scaleHeight("scale:height", TfToken::Immortal),
    scaleWidth("scale:width", TfToken::Immortal),
    screen("screen", TfToken::Immortal),
    skyTint("skyTint", TfToken::Immortal),
    spherical("spherical", TfToken::Immortal),
    spline("spline", TfToken::Immortal),
    sunDirection("sunDirection", TfToken::Immortal),
    sunSize("sunSize", TfToken::Immortal),
    sunTint("sunTint", TfToken::Immortal),
    textureFillColor("texture:fillColor", TfToken::Immortal),
    textureInvertU("texture:invertU", TfToken::Immortal),
    textureInvertV("texture:invertV", TfToken::Immortal),
    textureMap("texture:map", TfToken::Immortal),
    textureOffsetU("texture:offsetU", TfToken::Immortal),
    textureOffsetV("texture:offsetV", TfToken::Immortal),
    texturePremultipliedAlpha("texture:premultipliedAlpha", TfToken::Immortal),
    textureScaleU("texture:scaleU", TfToken::Immortal),
    textureScaleV("texture:scaleV", TfToken::Immortal),
    textureWrapMode("texture:wrapMode", TfToken::Immortal),
    useColor("useColor", TfToken::Immortal),
    useThroughput("useThroughput", TfToken::Immortal),
    values("values", TfToken::Immortal),
    width("width", TfToken::Immortal),
    year("year", TfToken::Immortal),
    zone("zone", TfToken::Immortal),
    allTokens({
        analytic,
        analyticApex,
        analyticBlurAmount,
        analyticBlurExponent,
        analyticBlurFarDistance,
        analyticBlurFarValue,
        analyticBlurMidpoint,
        analyticBlurMidValue,
        analyticBlurNearDistance,
        analyticBlurNearValue,
        analyticBlurSMult,
        analyticBlurTMult,
        analyticDensityExponent,
        analyticDensityFarDistance,
        analyticDensityFarValue,
        analyticDensityMidpoint,
        analyticDensityMidValue,
        analyticDensityNearDistance,
        analyticDensityNearValue,
        analyticDirectional,
        analyticShearX,
        analyticShearY,
        analyticUseLightDirection,
        aovName,
        argsPath,
        barnMode,
        beginDistance,
        bspline,
        catmull_rom,
        catmullRom,
        clamp,
        colorContrast,
        colorMidpoint,
        colorRamp,
        colorRampColors,
        colorRampInterpolation,
        colorRampKnots,
        colorSaturation,
        colorTint,
        colorWhitepoint,
        cone,
        constant,
        cookieMode,
        day,
        depth,
        distanceToLight,
        edgeScaleBack,
        edgeScaleBottom,
        edgeScaleFront,
        edgeScaleLeft,
        edgeScaleRight,
        edgeScaleTop,
        edgeThickness,
        endDistance,
        falloff,
        falloffFloats,
        falloffInterpolation,
        falloffKnots,
        filePath,
        haziness,
        height,
        hour,
        infoArgsPath,
        infoFilePath,
        infoOslPath,
        infoSloPath,
        inPrimaryHit,
        inReflection,
        inRefraction,
        interpolation,
        invert,
        latitude,
        linear,
        longitude,
        max,
        min,
        month,
        multiply,
        noEffect,
        noLight,
        off,
        onVolumeBoundaries,
        outputsRiDisplacement,
        outputsRiSurface,
        outputsRiVolume,
        physical,
        positions,
        preBarnEffect,
        radial,
        radius,
        rampMode,
        refineBack,
        refineBottom,
        refineFront,
        refineLeft,
        refineRight,
        refineTop,
        repeat,
        riCombineMode,
        riDensity,
        riDiffuse,
        riExposure,
        riIntensity,
        riIntensityNearDist,
        riInvert,
        riLightGroup,
        riPortalIntensity,
        riPortalTint,
        riSamplingFixedSampleCount,
        riSamplingImportanceMultiplier,
        riShadowThinShadow,
        riSpecular,
        riTextureGamma,
        riTextureSaturation,
        riTraceLightPaths,
        scaleDepth,
        scaleHeight,
        scaleWidth,
        screen,
        skyTint,
        spherical,
        spline,
        sunDirection,
        sunSize,
        sunTint,
        textureFillColor,
        textureInvertU,
        textureInvertV,
        textureMap,
        textureOffsetU,
        textureOffsetV,
        texturePremultipliedAlpha,
        textureScaleU,
        textureScaleV,
        textureWrapMode,
        useColor,
        useThroughput,
        values,
        width,
        year,
        zone
    })
{
}

TfStaticData<UsdRiTokensType> UsdRiTokens;

PXR_NAMESPACE_CLOSE_SCOPE
