# Tiny Render Delegate
Tiny is a simple render delegate that can be used either as a starting
point when building render delegates or as a tool to experiment with the Hydra
ecosystem.

The Tiny render delegate will not render, instead this render delegate 
will output messages in the console when events are received from Hydra. 
These events might be create a primitive, a render pass, 
or just generate a image. 

## Using Tiny
Tiny is a render delegate that is registered as a plugin. It can be used inside 
Usdview and/or it can be instanced directly (see testHdTiny). 

Since Tiny lives in the Extras folder (compared to other render delegates
like HdEmbree/HdStorm/HdPrman), if you want to use Tiny in Usdview, 
you will need to tell the plugin system to load Tiny explicitely.

    setenv PXR_PLUGINPATH_NAME <inst>/share/usd/examples/plugin/hdTiny/resources

The testHdTiny will compile and run on all platforms: Windows, Linux and Mac.

## Features
- Render delegate
- Plugin registration
- Mesh
- Render Pass

## Output
When running Hydra with the Tiny render delegate, you should expect to see an 
output to the terminal with the events generated by Hydra core 
similar to the following :

    Creating Tiny RenderDelegate
    Create Tiny Rprim type=mesh id=/MyCube1 instancerId=
    Create RenderPass with Collection=geometry
    * (multithreaded) Sync Tiny Mesh id=/MyCube1
    => CommitResources RenderDelegate
    => Execute RenderPass
    Destroy Tiny Rprim id=/MyCube1
    Destroying Tiny RenderDelegate
    Destroying renderPass
