//
// Copyright 2017 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#ifndef HDSTORM_RENDERER_PLUGIN_H
#define HDSTORM_RENDERER_PLUGIN_H

#include "pxr/pxr.h"
#include "pxr/imaging/hd/rendererPlugin.h"

PXR_NAMESPACE_OPEN_SCOPE

class HdStormRendererPlugin final : public HdRendererPlugin {
public:
    HdStormRendererPlugin()          = default;
    virtual ~HdStormRendererPlugin() = default;

    virtual HdRenderDelegate *CreateRenderDelegate() override;
    virtual HdRenderDelegate *CreateRenderDelegate(
        HdRenderSettingsMap const& settingsMap) override;

    virtual void DeleteRenderDelegate(HdRenderDelegate *renderDelegate) 
        override;

    virtual bool IsSupported() const override;

private:
    HdStormRendererPlugin(const HdStormRendererPlugin &)             = delete;
    HdStormRendererPlugin &operator =(const HdStormRendererPlugin &) = delete;
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif // HDSTORM_RENDERER_PLUGIN_H
