//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#ifndef HDST_DRAW_ITEM_H
#define HDST_DRAW_ITEM_H

#include "pxr/pxr.h"
#include "pxr/imaging/hdSt/api.h"
#include "pxr/imaging/hd/drawItem.h"

PXR_NAMESPACE_OPEN_SCOPE


class HdRenderIndex;
typedef boost::shared_ptr<class HdSt_GeometricShader> HdSt_GeometricShaderSharedPtr;
typedef boost::shared_ptr<class HdStShaderCode> HdStShaderCodeSharedPtr;

class HdStDrawItem : public HdDrawItem {
public:
    HF_MALLOC_TAG_NEW("new HdStDrawItem");

    HDST_API
    HdStDrawItem(HdRprimSharedData const *sharedData);

    HDST_API
    ~HdStDrawItem();

    void SetGeometricShader(HdSt_GeometricShaderSharedPtr const &shader) {
        _geometricShader = shader;
    }

    HdSt_GeometricShaderSharedPtr const &GetGeometricShader() const {
        return _geometricShader;
    }

    HdStShaderCodeSharedPtr const &GetMaterialShader() const {
        return _materialShader;
    }

    void SetMaterialShader(HdStShaderCodeSharedPtr const &shader) {
        _materialShader = shader;
    }

    /// Set the material shader by retriving an appropriate sprim from
    /// the render index (using a fallback sprim as necessary) and
    /// including optional mixin code.
    void SetMaterialShaderFromRenderIndex(
        const HdRenderIndex &renderIndex,
        const SdfPath &materialId,
        std::string mixinSource = std::string());

protected:
    size_t _GetBufferArraysHash() const override;

private:
    HdSt_GeometricShaderSharedPtr _geometricShader;
    HdStShaderCodeSharedPtr _materialShader;
};


PXR_NAMESPACE_CLOSE_SCOPE

#endif //HDST_DRAW_ITEM_H
