//
// Copyright 2016 Pixar
//
// Licensed under the Apache License, Version 2.0 (the "Apache License")
// with the following modification; you may not use this file except in
// compliance with the Apache License and the following modification to it:
// Section 6. Trademarks. is deleted and replaced with:
//
// 6. Trademarks. This License does not grant permission to use the trade
//    names, trademarks, service marks, or product names of the Licensor
//    and its affiliates, except as required to comply with Section 4(c) of
//    the License and to reproduce the content of the NOTICE file.
//
// You may obtain a copy of the Apache License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the Apache License with the above modification is
// distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied. See the Apache License for the specific
// language governing permissions and limitations under the Apache License.
//
#include "pxr/imaging/hd/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdTokens, HD_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdReprTokens, HD_REPR_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdPerfTokens, HD_PERF_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdShaderTokens, HD_SHADER_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdRenderTagTokens, HD_RENDERTAG_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdMaterialTagTokens, HD_MATERIALTAG_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdMaterialTerminalTokens, HD_MATERIAL_TERMINAL_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdOptionTokens, HD_OPTION_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdPrimTypeTokens, HD_PRIMTYPE_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdPrimvarRoleTokens, HD_PRIMVAR_ROLE_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdAovTokens, HD_AOV_TOKENS);

TF_DEFINE_PUBLIC_TOKENS(HdRenderSettingsTokens, HD_RENDER_SETTINGS_TOKENS);

TfToken HdAovTokensMakePrimvar(TfToken const& primvar)
{
    return TfToken(
        HdAovTokens->primvars.GetString() +
        primvar.GetString());
}

TfToken HdAovTokensMakeLpe(TfToken const& lpe)
{
    return TfToken(
        HdAovTokens->lpe.GetString() +
        lpe.GetString());
}

TfToken HdAovTokensMakeShader(TfToken const& shader)
{
    return TfToken(
        HdAovTokens->shader.GetString() +
        shader.GetString());
}

PXR_NAMESPACE_CLOSE_SCOPE

