/* i386-dos32.tmt.h
   created from i386-dos32.tmt.bin, 22954 (0x59aa) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_DOS32_TMT_SIZE    22954
#define STUB_I386_DOS32_TMT_ADLER32 0xd6b55d27
#define STUB_I386_DOS32_TMT_CRC32   0xc8143bd6

unsigned char stub_i386_dos32_tmt[22954] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 248, 31,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,191,  0,  0,  0,  0, 87,141,183,  0,  0,  0,  0,
/* 0x0040 */ 129,239,  0,  0,  0,  0, 25,237,185,  0,  0,  0,  0,253,243,164,
/* 0x0050 */ 252,141,119,  1, 95, 87, 87,233,252,255,255,255, 85, 80, 88, 33,
/* 0x0060 */ 161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0070 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,235,  3,164,235,
/* 0x0080 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0090 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x00a0 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x00b0 */   7,139, 30,131,238,252, 17,219,115,255,  1,219,115,255,117,  9,
/* 0x00c0 */ 139, 30,131,238,252, 17,219,115,255, 49,201,131,232,  3,114, 13,
/* 0x00d0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,137,197,  1,219,117,
/* 0x00e0 */   7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,
/* 0x00f0 */ 131,238,252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,
/* 0x0100 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x0110 */  17,219,115, 48,  1,219,115, 48,117,  9,139, 30,131,238,252, 17,
/* 0x0120 */ 219,115, 48, 65, 65,131,193,  2,129,253,  0,243,255,255,131,209,
/* 0x0130 */   1, 86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,
/* 0x0140 */ 131,253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,
/* 0x0150 */ 247,233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,
/* 0x0160 */ 131,233,  4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,
/* 0x0170 */   3,138,  6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252,
/* 0x0180 */  17,219,114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,
/* 0x0190 */   1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,
/* 0x01a0 */   7,139, 30,131,238,252, 17,219,114, 15,  1,219,115, 11,117, 15,
/* 0x01b0 */ 139, 30,131,238,252, 17,219,114, 15, 72,  1,219,117,  7,139, 30,
/* 0x01c0 */ 131,238,252, 17,219, 17,192,235,255, 49,201,131,232,  3,114, 17,
/* 0x01d0 */ 193,224,  8,138,  6, 70,131,240,255,116,255,209,248,137,197,235,
/* 0x01e0 */  11,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,
/* 0x01f0 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,117,255, 65,  1,219,
/* 0x0200 */ 117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,139,
/* 0x0210 */  30,131,238,252, 17,219,115, 68,  1,219,115, 68,117,  9,139, 30,
/* 0x0220 */ 131,238,252, 17,219,115, 68, 65, 65,131,193,  2,129,253,  0,251,
/* 0x0230 */ 255,255,131,209,  1, 86,141, 52, 47,243,164, 94,233,252,255,255,
/* 0x0240 */ 255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,136,
/* 0x0250 */   7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,137,
/* 0x0260 */   7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,255,
/* 0x0270 */ 235,  3,164,235,  3,138,  6, 70,136,  7, 71,  1,219,117,  7,139,
/* 0x0280 */  30,131,238,252, 17,219,114,  1, 49,192, 64,138,  7,114,255,184,
/* 0x0290 */   1,  0,  0,  0,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x02a0 */ 192,  1,219,117,  7,139, 30,131,238,252, 17,219,114, 30,  1,219,
/* 0x02b0 */ 115, 11,117, 30,139, 30,131,238,252, 17,219,114, 30, 72,  1,219,
/* 0x02c0 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,235,255,  1,219,117,
/* 0x02d0 */   7,139, 30,131,238,252, 17,219, 17,201,235,255, 49,201,131,232,
/* 0x02e0 */   3,114, 17,193,224,  8,138,  6, 70,131,240,255,116,255,209,248,
/* 0x02f0 */ 137,197,235, 11,  1,219,117,  7,139, 30,131,238,252, 17,219,114,
/* 0x0300 */ 204, 65,  1,219,117,  7,139, 30,131,238,252, 17,219,114,190,  1,
/* 0x0310 */ 219,117,  7,139, 30,131,238,252, 17,219, 17,201,  1,219,117,  7,
/* 0x0320 */ 139, 30,131,238,252, 17,219,115, 81,  1,219,115, 81,117,  9,139,
/* 0x0330 */  30,131,238,252, 17,219,115, 81, 65, 65,131,193,  2,129,253,  0,
/* 0x0340 */ 251,255,255,131,209,  2, 86,141, 52, 47,243,164, 94,233,252,255,
/* 0x0350 */ 255,255,141, 20, 47,131,253,252,138,  4, 15,118,255,138,  2, 66,
/* 0x0360 */ 136,  7, 71, 73,117,247,233,252,255,255,255,139,  2,131,194,  4,
/* 0x0370 */ 137,  7,131,199,  4,131,233,  4,119,241,  1,207,233,252,255,255,
/* 0x0380 */ 255,137,229,141,156, 36,  0,  0,  0,  0, 49,192, 80, 57,220,117,
/* 0x0390 */ 251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,195,  4, 83,104,  0,
/* 0x03a0 */   0,  0,  0, 86,131,195,  4, 83, 80,199,  3,  0,  0,  0,  0,137,
/* 0x03b0 */ 229,139, 85,  0,172, 74,136,193, 36,  7,192,233,  3,187,  0,253,
/* 0x03c0 */ 255,255,211,227,141,164, 92,144,241,255,255,131,228,224,106,  0,
/* 0x03d0 */ 106,  0,137,227, 83,131,195,  4,139, 77,  0,255, 49, 87, 83,131,
/* 0x03e0 */ 195,  4,136, 67,  2,172, 74,136,193, 36, 15,136,  3,192,233,  4,
/* 0x03f0 */ 136, 75,  1, 82, 86, 83, 80, 85, 87,191,  0,  0,  0,  0, 86, 83,
/* 0x0400 */ 131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,141,
/* 0x0410 */  66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,137,
/* 0x0420 */ 195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,224,
/* 0x0430 */ 139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,132,
/* 0x0440 */   0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,  0,
/* 0x0450 */   0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,  0,
/* 0x0460 */   0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68, 36,
/* 0x0470 */  64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,  0,
/* 0x0480 */   0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,
/* 0x0490 */   0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,  4,
/* 0x04a0 */ 131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,  0,
/* 0x04b0 */   0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,235,
/* 0x04c0 */   3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56, 15,
/* 0x04d0 */ 132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0, 69,
/* 0x04e0 */   9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,  0,
/* 0x04f0 */  57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,  0,
/* 0x0500 */   0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68, 36,
/* 0x0510 */  76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,124,
/* 0x0520 */  36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56, 15,
/* 0x0530 */ 132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x0540 */ 182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,193,
/* 0x0550 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,  2,
/* 0x0560 */   0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76, 36,
/* 0x0570 */  80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,139,
/* 0x0580 */  68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249, 15,
/* 0x0590 */ 182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,105,
/* 0x05a0 */ 192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,  0,
/* 0x05b0 */   0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92, 43,
/* 0x05c0 */  68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137, 68,
/* 0x05d0 */  36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,137,
/* 0x05e0 */ 251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,  0,
/* 0x05f0 */  15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,  0,
/* 0x0600 */   0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76, 36,
/* 0x0610 */  20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,141,
/* 0x0620 */   4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,  0,
/* 0x0630 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x0640 */   9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,193,
/* 0x0650 */ 232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,255,
/* 0x0660 */ 255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,
/* 0x0670 */ 141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0, 15,
/* 0x0680 */ 132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,255,
/* 0x0690 */ 255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124,
/* 0x06a0 */  36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68, 36,
/* 0x06b0 */  76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36, 92,
/* 0x06c0 */  15,130, 63,254,255,255,129,124, 36, 52,255,255,255,  0,119, 12,
/* 0x06d0 */  59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,124,
/* 0x06e0 */ 184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36, 92,
/* 0x06f0 */ 139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233, 46,
/* 0x0700 */   8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139, 68,
/* 0x0710 */  36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,  0,
/* 0x0720 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x0730 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,183,
/* 0x0740 */ 209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,  0,
/* 0x0750 */   8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,243,
/* 0x0760 */ 129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136, 26,
/* 0x0770 */  66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,142,
/* 0x0780 */  41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,131,
/* 0x0790 */ 108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68, 36,
/* 0x07a0 */  48,137,200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,  1,
/* 0x07b0 */ 235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,193,
/* 0x07c0 */ 232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,102,
/* 0x07d0 */ 137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56, 15,
/* 0x07e0 */ 132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x07f0 */   8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,193,
/* 0x0800 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,  2,
/* 0x0810 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,193,
/* 0x0820 */ 248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139, 84,
/* 0x0830 */  36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76, 36,
/* 0x0840 */  68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84, 36,
/* 0x0850 */  64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,254,
/* 0x0860 */ 255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,  0,
/* 0x0870 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48,
/* 0x0880 */  69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0890 */  68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,  8,
/* 0x08a0 */   0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36, 44,
/* 0x08b0 */ 141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141, 92,
/* 0x08c0 */  25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,124,
/* 0x08d0 */  36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,
/* 0x08e0 */   0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,  3,
/* 0x08f0 */ 116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68, 36,
/* 0x0900 */  16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,  0,
/* 0x0910 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x0920 */  68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202,
/* 0x0930 */  15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36,
/* 0x0940 */  48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 86,
/* 0x0950 */   1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,194,
/* 0x0960 */   3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,254,
/* 0x0970 */   3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,184,
/* 0x0980 */   3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,  0,
/* 0x0990 */ 141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,
/* 0x09a0 */ 235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x09b0 */  79,141,  4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,255,
/* 0x09c0 */ 255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29, 59,
/* 0x09d0 */ 108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x09e0 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x09f0 */ 102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,
/* 0x0a00 */ 114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x0a10 */ 102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,131,
/* 0x0a20 */ 250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,208,
/* 0x0a30 */ 131,227,  1,209,248,131,203,  2,131,250, 13,141,120,255, 15,143,
/* 0x0a40 */  66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,  4,
/* 0x0a50 */  94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,184,
/* 0x0a60 */   1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137, 68,
/* 0x0a70 */  36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x0a80 */ 137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,129,
/* 0x0a90 */ 124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28, 14,
/* 0x0aa0 */ 119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36, 48,
/* 0x0ab0 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x0ac0 */  68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0ad0 */  68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,
/* 0x0ae0 */ 193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36, 28,
/* 0x0af0 */   9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,193,
/* 0x0b00 */ 232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,128,  1,
/* 0x0b10 */   0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,137,
/* 0x0b20 */ 218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,131,
/* 0x0b30 */ 134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,193,
/* 0x0b40 */ 248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,  0,
/* 0x0b50 */ 139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,255,
/* 0x0b60 */   0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,  0,
/* 0x0b70 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48,
/* 0x0b80 */  69,102,139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,202,
/* 0x0b90 */  15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68, 36,
/* 0x0ba0 */  52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x0bb0 */ 135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,  0,
/* 0x0bc0 */   0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,  0,
/* 0x0bd0 */   0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68, 36,
/* 0x0be0 */  76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,136,
/* 0x0bf0 */   2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255, 41,
/* 0x0c00 */ 198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,254,
/* 0x0c10 */ 255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132, 50,
/* 0x0c20 */   1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9,
/* 0x0c30 */  68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,202,
/* 0x0c40 */  15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68, 36,
/* 0x0c50 */  52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,
/* 0x0c60 */ 139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,102,
/* 0x0c70 */ 137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233, 67,
/* 0x0c80 */ 252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100, 36,
/* 0x0c90 */  48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,  0,
/* 0x0ca0 */ 137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,208,
/* 0x0cb0 */  57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,211,102,193,
/* 0x0cc0 */ 232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,102,
/* 0x0cd0 */ 137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,100,
/* 0x0ce0 */  36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,
/* 0x0cf0 */ 139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x0d00 */ 193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,  8,
/* 0x0d10 */   0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,  0,
/* 0x0d20 */   0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84, 36,
/* 0x0d30 */  68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96, 15,
/* 0x0d40 */ 159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 76,
/* 0x0d50 */ 233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,  1,
/* 0x0d60 */   0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,255,
/* 0x0d70 */ 255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36, 72,
/* 0x0d80 */ 119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,  3,
/* 0x0d90 */ 148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,251,
/* 0x0da0 */ 136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,249,
/* 0x0db0 */ 255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,233,
/* 0x0dc0 */   2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36, 52,
/* 0x0dd0 */ 102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,199,
/* 0x0de0 */  68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,  0,
/* 0x0df0 */   0,137, 92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,233,
/* 0x0e00 */ 177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,
/* 0x0e10 */ 232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,255,
/* 0x0e20 */ 255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x0e30 */ 129,251,255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,165,
/* 0x0e40 */   0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,232, 11, 15,
/* 0x0e50 */ 183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,137,
/* 0x0e60 */ 198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x0e70 */ 135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92, 36,
/* 0x0e80 */  64,233,159,254,255,255,141, 80,251,129,124, 36, 52,255,255,255,
/* 0x0e90 */   0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,193,100, 36,
/* 0x0ea0 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x0eb0 */ 209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,  7,
/* 0x0ec0 */  41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,227,
/* 0x0ed0 */   4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,  0,
/* 0x0ee0 */ 137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,254,
/* 0x0ef0 */ 255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68,
/* 0x0f00 */  36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,198,
/* 0x0f10 */ 137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68, 36,
/* 0x0f20 */  60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,255,
/* 0x0f30 */ 255, 91, 94, 95, 93, 85, 87,191,  0,  0,  0,  0, 86, 83,131,236,
/* 0x0f40 */ 100,139, 84, 36,120,199, 68, 36, 92,  0,  0,  0,  0,141, 66,  4,
/* 0x0f50 */ 137, 68, 36, 96,184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,
/* 0x0f60 */ 227,137,217, 73,137, 76, 36, 88, 15,182, 74,  1,211,224,139,140,
/* 0x0f70 */  36,144,  0,  0,  0, 72,137, 68, 36, 84,139,132, 36,132,  0,  0,
/* 0x0f80 */   0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,  0,199,  0,  0,  0,
/* 0x0f90 */   0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,  1,  0,  0,  0,137,
/* 0x0fa0 */ 116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,199, 68, 36, 64,  1,
/* 0x0fb0 */   0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,199,  1,  0,  0,  0,
/* 0x0fc0 */   0, 15,182, 74,  1,  1,241,211,224,141,136, 54,  7,  0,  0, 57,
/* 0x0fd0 */  76, 36, 92,115, 14,139, 68, 36, 96,102,199,  0,  0,  4,131,192,
/* 0x0fe0 */   2,226,246,139,108, 36,124,199, 68, 36, 48,  0,  0,  0,  0,199,
/* 0x0ff0 */  68, 36, 52,255,255,255,255,186,  0,  0,  0,  0,137,235,  3,156,
/* 0x1000 */  36,128,  0,  0,  0,137, 92, 36, 56, 59,108, 36, 56, 15,132,128,
/* 0x1010 */   8,  0,  0,193,100, 36, 48,  8, 66, 15,182, 69,  0, 69,  9, 68,
/* 0x1020 */  36, 48,131,250,  4,126,226,139,180, 36,140,  0,  0,  0, 57,116,
/* 0x1030 */  36, 92, 15,131,226,  1,  0,  0,139,132, 36,136,  0,  0,  0,137,
/* 0x1040 */  68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,139, 68, 36, 76,139,
/* 0x1050 */  76, 36, 96,193,224,  4,137, 84, 36, 44,  1,208,129,124, 36, 52,
/* 0x1060 */ 255,255,255,  0,141, 52, 65,119, 29, 59,108, 36, 56, 15,132, 32,
/* 0x1070 */   8,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x1080 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 22,193,232, 11,
/* 0x1090 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 80,  2,  0,  0,
/* 0x10a0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,138, 76, 36, 80,193,
/* 0x10b0 */ 248,  5,187,  1,  0,  0,  0,141,  4,  2,102,137,  6,139, 68, 36,
/* 0x10c0 */  92, 35, 68, 36, 84,139,116, 36, 96,211,224,137,249, 15,182,209,
/* 0x10d0 */ 185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,  1,208,105,192,  0,
/* 0x10e0 */   6,  0,  0,131,124, 36, 76,  6,141,132, 48,108, 14,  0,  0,137,
/* 0x10f0 */  68, 36, 20, 15,142, 72,  1,  0,  0,139, 68, 36, 92, 43, 68, 36,
/* 0x1100 */  72,139,148, 36,136,  0,  0,  0, 15,182,  4, 16,137, 68, 36, 40,
/* 0x1110 */ 235, 46,137, 68, 36, 52,184,  0,  8,  0,  0, 41,216,137,251,193,
/* 0x1120 */ 248,  5,133,210,141,  4,  1,102,137,134,  0,  2,  0,  0, 15,133,
/* 0x1130 */ 106,  1,  0,  0,129,251,255,  0,  0,  0, 15,143,143,  0,  0,  0,
/* 0x1140 */ 209,100, 36, 40,139, 84, 36, 40,141, 60, 27,139, 76, 36, 20,129,
/* 0x1150 */ 226,  0,  1,  0,  0,129,124, 36, 52,255,255,255,  0,141,  4, 81,
/* 0x1160 */ 141, 52, 56,119, 29, 59,108, 36, 56, 15,132, 36,  7,  0,  0,193,
/* 0x1170 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x1180 */  36, 48,139, 68, 36, 52,102,139,142,  0,  2,  0,  0,193,232, 11,
/* 0x1190 */  15,183,217, 15,175,195, 57, 68, 36, 48, 15,130,114,255,255,255,
/* 0x11a0 */  41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,141, 95,
/* 0x11b0 */   1,102, 41,193,133,210,102,137,142,  0,  2,  0,  0, 15,132,219,
/* 0x11c0 */   0,  0,  0,129,251,255,  0,  0,  0, 15,142,113,255,255,255,139,
/* 0x11d0 */  84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,
/* 0x11e0 */   3,137, 84, 36, 24, 15,143,215,  0,  0,  0,199, 68, 36, 76,  0,
/* 0x11f0 */   0,  0,  0,139,132, 36,140,  0,  0,  0, 57, 68, 36, 92, 15,130,
/* 0x1200 */  63,254,255,255,129,124, 36, 52,255,255,255,  0,119, 12, 59,108,
/* 0x1210 */  36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,108, 36,124,184,  0,
/* 0x1220 */   0,  0,  0,139,148, 36,132,  0,  0,  0,139, 92, 36, 92,139,140,
/* 0x1230 */  36,144,  0,  0,  0,137, 42,137, 25,131,196,100,233, 46,  8,  0,
/* 0x1240 */   0,129,124, 36, 52,255,255,255,  0,141, 52, 27,139, 68, 36, 20,
/* 0x1250 */ 141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 52,  6,  0,  0,193,
/* 0x1260 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x1270 */  36, 48,139, 68, 36, 52,102,139, 11,193,232, 11, 15,183,209, 15,
/* 0x1280 */ 175,194, 57, 68, 36, 48,115, 79,137, 68, 36, 52,184,  0,  8,  0,
/* 0x1290 */   0, 41,208,193,248,  5,141,  4,  1,102,137,  3,137,243,129,251,
/* 0x12a0 */ 255,  0,  0,  0,126,155,139, 84, 36, 24,137,223,136, 26, 66,255,
/* 0x12b0 */  68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,142, 41,255,
/* 0x12c0 */ 255,255,131,124, 36, 76,  9, 15,143,107,  6,  0,  0,131,108, 36,
/* 0x12d0 */  76,  3,233, 28,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,
/* 0x12e0 */ 200,102,193,232,  5,102, 41,193,102,137, 11,141, 94,  1,235,174,
/* 0x12f0 */ 139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,208,102,193,232,  5,
/* 0x1300 */ 139, 76, 36, 76,102, 41,194,129,251,255,255,255,  0,102,137, 22,
/* 0x1310 */ 139,116, 36, 96,141, 60, 78,119, 27, 59,108, 36, 56, 15,132,112,
/* 0x1320 */   5,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x1330 */  68, 36, 48, 69,102,139,151,128,  1,  0,  0,137,216,193,232, 11,
/* 0x1340 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,228,  2,  0,  0,
/* 0x1350 */ 137,198,184,  0,  8,  0,  0, 41,200,139, 92, 36, 96,193,248,  5,
/* 0x1360 */ 131,124, 36, 76,  6,141,  4,  2,139, 76, 36, 72,139, 84, 36, 68,
/* 0x1370 */ 102,137,135,128,  1,  0,  0,139, 68, 36, 64,137, 76, 36, 68,137,
/* 0x1380 */  68, 36, 60,184,  0,  0,  0,  0, 15,159,192,137, 84, 36, 64,141,
/* 0x1390 */   4, 64,129,195,100,  6,  0,  0,137, 68, 36, 76,129,254,255,255,
/* 0x13a0 */ 255,  0,119, 27, 59,108, 36, 56, 15,132,229,  4,  0,  0,193,100,
/* 0x13b0 */  36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,
/* 0x13c0 */ 139, 19,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x13d0 */  48, 15,131,102,  3,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x13e0 */  41,200,193,100, 36, 44,  4,193,248,  5,139, 76, 36, 44,141,  4,
/* 0x13f0 */   2,199, 68, 36, 32,  0,  0,  0,  0,102,137,  3,141, 92, 25,  4,
/* 0x1400 */ 137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,  0,139,124, 36, 36,
/* 0x1410 */ 186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x1420 */  41,200,193,248,  5, 79,141,  4,  2,137,242,102,137,  3,116, 97,
/* 0x1430 */ 129,124, 36, 52,255,255,255,  0,141, 52, 18,139, 68, 36, 16,141,
/* 0x1440 */  28,  6,119, 29, 59,108, 36, 56, 15,132, 69,  4,  0,  0,193,100,
/* 0x1450 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x1460 */  48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,
/* 0x1470 */ 193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,
/* 0x1480 */ 208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 86,  1,117,
/* 0x1490 */ 159,138, 76, 36, 36,184,  1,  0,  0,  0,211,224, 41,194,  3, 84,
/* 0x14a0 */  36, 32,131,124, 36, 76,  3,137, 84, 36, 12, 15,143,254,  3,  0,
/* 0x14b0 */   0,131, 68, 36, 76,  7,131,250,  3,137,208,126,  5,184,  3,  0,
/* 0x14c0 */   0,  0,139, 92, 36, 96,193,224,  7,191,  6,  0,  0,  0,141,132,
/* 0x14d0 */  24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,  0,  0,  0,235, 25,
/* 0x14e0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,
/* 0x14f0 */   4,  2,102,137,  3,137,240,116, 97,129,124, 36, 52,255,255,255,
/* 0x1500 */   0,141, 52,  0,139, 68, 36,  8,141, 28,  6,119, 29, 59,108, 36,
/* 0x1510 */  56, 15,132,124,  3,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,
/* 0x1520 */   8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,
/* 0x1530 */  19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,160,
/* 0x1540 */  41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x1550 */ 194, 79,102,137, 19,141, 70,  1,117,159,141, 80,192,131,250,  3,
/* 0x1560 */ 137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,211,137,208,131,227,
/* 0x1570 */   1,209,248,131,203,  2,131,250, 13,141,120,255, 15,143, 66,  4,
/* 0x1580 */   0,  0,137,249,139,116, 36, 96,211,227,  1,210,141,  4, 94,137,
/* 0x1590 */  92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,  4, 36,184,  1,  0,
/* 0x15a0 */   0,  0,199, 68, 36, 28,  1,  0,  0,  0,235, 33,137, 68, 36, 52,
/* 0x15b0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,  3,
/* 0x15c0 */ 137,240,209,100, 36, 28, 79, 15,132,211,  2,  0,  0,129,124, 36,
/* 0x15d0 */  52,255,255,255,  0,141, 52,  0,139, 12, 36,141, 28, 14,119, 29,
/* 0x15e0 */  59,108, 36, 56, 15,132,169,  2,  0,  0,193,100, 36, 48,  8,193,
/* 0x15f0 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x1600 */  52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x1610 */  48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,
/* 0x1620 */   5,102, 41,194,141, 70,  1,102,137, 19,139, 92, 36, 28,  9, 92,
/* 0x1630 */  36,  4,235,142, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x1640 */ 102, 41,194,129,251,255,255,255,  0,102,137,151,128,  1,  0,  0,
/* 0x1650 */  15,134,107,  1,  0,  0,102,139,143,152,  1,  0,  0,137,218,193,
/* 0x1660 */ 234, 11, 15,183,193, 15,175,208, 57, 84, 36, 48, 15,131,134,  1,
/* 0x1670 */   0,  0,190,  0,  8,  0,  0,137,211, 41,198,137,240,193,248,  5,
/* 0x1680 */ 141,  4,  1,139, 76, 36, 44,102,137,135,152,  1,  0,  0,139, 68,
/* 0x1690 */  36, 76,193,224,  5,  3, 68, 36, 96,129,250,255,255,255,  0,141,
/* 0x16a0 */  60, 72,119, 27, 59,108, 36, 56, 15,132,229,  1,  0,  0,193,100,
/* 0x16b0 */  36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,
/* 0x16c0 */ 139,151,224,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x16d0 */ 193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,137, 68, 36, 52,184,
/* 0x16e0 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,224,
/* 0x16f0 */   1,  0,  0,139, 68, 36, 92,133,192, 15,132,148,  1,  0,  0,131,
/* 0x1700 */ 124, 36, 76,  6,184,  0,  0,  0,  0,139,156, 36,136,  0,  0,  0,
/* 0x1710 */ 139, 84, 36, 24, 15,159,192,141, 68,  0,  9,137, 68, 36, 76,139,
/* 0x1720 */  68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,137,248,136,  2, 66,
/* 0x1730 */ 255, 68, 36, 92,137, 84, 36, 24,233,182,250,255,255, 41,198, 41,
/* 0x1740 */  68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,254,255,255,
/* 0x1750 */ 255,  0,102,137, 19,119, 27, 59,108, 36, 56, 15,132, 50,  1,  0,
/* 0x1760 */   0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36,
/* 0x1770 */  48, 69,102,139, 83,  2,137,240,193,232, 11, 15,183,202, 15,175,
/* 0x1780 */ 193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,137, 68, 36, 52,184,
/* 0x1790 */   0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,116,
/* 0x17a0 */  36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,  0,  0,102,137, 67,
/* 0x17b0 */   2,141,156, 30,  4,  1,  0,  0,137, 92, 36, 16,233, 67,252,255,
/* 0x17c0 */ 255, 59,108, 36, 56, 15,132,200,  0,  0,  0,193,100, 36, 48,  8,
/* 0x17d0 */ 193,227,  8,102,139,143,152,  1,  0,  0, 15,182, 69,  0,137,218,
/* 0x17e0 */   9, 68, 36, 48,193,234, 11, 15,183,193, 69, 15,175,208, 57, 84,
/* 0x17f0 */  36, 48, 15,130,122,254,255,255,137,200, 41,211,102,193,232,  5,
/* 0x1800 */  41, 84, 36, 48,102, 41,193,129,251,255,255,255,  0,102,137,143,
/* 0x1810 */ 152,  1,  0,  0,119, 23, 59,108, 36, 56,116,119,193,100, 36, 48,
/* 0x1820 */   8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,
/* 0x1830 */ 176,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x1840 */  68, 36, 48, 15,131, 22,  1,  0,  0,137,198,184,  0,  8,  0,  0,
/* 0x1850 */  41,200,193,248,  5,141,  4,  2,102,137,135,176,  1,  0,  0,139,
/* 0x1860 */  68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,137, 84, 36, 68,131,
/* 0x1870 */ 124, 36, 76,  6,184,  0,  0,  0,  0,139, 92, 36, 96, 15,159,192,
/* 0x1880 */ 129,195,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36, 76,233,  9,
/* 0x1890 */ 251,255,255,131,196,100,184,  1,  0,  0,  0,233,207,  1,  0,  0,
/* 0x18a0 */ 139,116, 36,  4, 70,137,116, 36, 72, 15,132, 85,249,255,255,139,
/* 0x18b0 */  76, 36, 12,139, 68, 36, 92,131,193,  2, 57, 68, 36, 72,119,211,
/* 0x18c0 */ 137,194,139,132, 36,136,  0,  0,  0, 43, 68, 36, 72,  3,148, 36,
/* 0x18d0 */ 136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56, 64,137,251,136, 26,
/* 0x18e0 */  66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,132,  3,249,255,255,
/* 0x18f0 */ 139,180, 36,140,  0,  0,  0, 57,116, 36, 92,114,219,233,  2,249,
/* 0x1900 */ 255,255, 41,198, 41, 68, 36, 48,137,208,137,116, 36, 52,102,193,
/* 0x1910 */ 232,  5,199, 68, 36, 32, 16,  0,  0,  0,102, 41,194,199, 68, 36,
/* 0x1920 */  36,  8,  0,  0,  0,102,137, 83,  2,129,195,  4,  2,  0,  0,137,
/* 0x1930 */  92, 36, 16,233,212,250,255,255,131,108, 36, 76,  6,233,177,248,
/* 0x1940 */ 255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,
/* 0x1950 */ 102, 41,194,102,137,151,224,  1,  0,  0,233, 16,255,255,255, 41,
/* 0x1960 */ 195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,
/* 0x1970 */ 255,255,255,  0,102,137,151,176,  1,  0,  0, 15,134,165,  0,  0,
/* 0x1980 */   0,102,139,151,200,  1,  0,  0,137,216,193,232, 11, 15,183,202,
/* 0x1990 */  15,175,193, 57, 68, 36, 48, 15,131,169,  0,  0,  0,137,198,184,
/* 0x19a0 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,200,
/* 0x19b0 */   1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,137, 92, 36, 64,233,
/* 0x19c0 */ 159,254,255,255,141, 80,251,129,124, 36, 52,255,255,255,  0,119,
/* 0x19d0 */  29, 59,108, 36, 56, 15,132,184,254,255,255,193,100, 36, 48,  8,
/* 0x19e0 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,209,108,
/* 0x19f0 */  36, 52,  1,219,139, 68, 36, 52, 57, 68, 36, 48,114,  7, 41, 68,
/* 0x1a00 */  36, 48,131,203,  1, 74,117,191,139, 84, 36, 96,193,227,  4,191,
/* 0x1a10 */   4,  0,  0,  0,137, 92, 36,  4,129,194, 68,  6,  0,  0,137, 20,
/* 0x1a20 */  36,233,119,251,255,255, 59,108, 36, 56, 15,132, 99,254,255,255,
/* 0x1a30 */ 193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48,
/* 0x1a40 */  69,233, 59,255,255,255,137,222, 41, 68, 36, 48, 41,198,137,208,
/* 0x1a50 */ 102,193,232,  5,139, 76, 36, 64,102, 41,194,139, 68, 36, 60,102,
/* 0x1a60 */ 137,151,200,  1,  0,  0,137, 76, 36, 60,233, 72,255,255,255, 91,
/* 0x1a70 */  94, 95, 93,  3,115,252,  3,123,248, 49,192,141,140, 36,  0,255,
/* 0x1a80 */ 255,255,137,236, 80, 57,204,117,251,137,236, 49,201, 93,137,254,
/* 0x1a90 */  43,119,252, 95,185,  0,  0,  0,  0,138,  7, 71, 44,232, 60,  1,
/* 0x1aa0 */ 119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,102,193,232,  8,
/* 0x1ab0 */ 134,196,193,192, 16,134,196, 41,248,128,235,232,  1,232,137,  7,
/* 0x1ac0 */ 131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,176,232,176,233,
/* 0x1ad0 */ 242,174,117,  6,128, 63,  0,117,255,139,  7,102,193,232,  8,134,
/* 0x1ae0 */ 196,193,192, 16,134,196, 41,248,  1,232,171,235,  4,185,  0,  0,
/* 0x1af0 */   0,  0,235, 31,138,  7, 71, 60,128,114, 10, 60,143,119,  6,128,
/* 0x1b00 */ 127,254, 15,116,  5, 44,232, 60,  1,119,255,131,249,  4,114,  4,
/* 0x1b10 */ 139,  7, 44,  0,117,255,134,196,193,192, 16,134,196, 41,248,  1,
/* 0x1b20 */ 232,131,233,  4,171,131,233,  1,114,  4,138,  7, 71,235, 13,131,
/* 0x1b30 */ 233,  1,115,  6,141,125,252, 49,192,138,  6, 70,  9,192,116,  1,
/* 0x1b40 */  60,239,119, 17,  1,199,139,  7,134,196,193,192, 16,134,196,  1,
/* 0x1b50 */ 232,137,  7,235,226, 36, 15,193,224, 16,102,139,  6,131,198,  2,
/* 0x1b60 */   9,192,117, 12,139,  6,131,198,  4,235, 12,233,252,255,255,255,
/* 0x1b70 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x1b80 */  50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,105,111,110,115,
/* 0x1b90 */  58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32, 32,
/* 0x1ba0 */  32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86, 77,
/* 0x1bb0 */  65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,
/* 0x1bc0 */  32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,110,
/* 0x1bd0 */  32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 84, 77, 84, 77,
/* 0x1be0 */  65, 73, 78, 49, 32, 32, 32, 32, 32, 32, 48, 49, 50, 32, 32, 48,
/* 0x1bf0 */  32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c00 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 84, 77, 84,
/* 0x1c10 */  77, 65, 73, 78, 49, 65, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x1c20 */  32, 32, 48, 32, 32, 48, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c30 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 84, 77, 84,
/* 0x1c40 */  77, 65, 73, 78, 49, 66, 32, 32, 32, 32, 32, 48,101, 32, 32, 48,
/* 0x1c50 */  32, 32, 48, 32, 32, 48, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 84, 77, 84,
/* 0x1c70 */  67, 65, 76, 84, 49, 32, 32, 32, 32, 32, 32, 48, 49, 32, 32, 48,
/* 0x1c80 */  32, 32, 48, 32, 32, 48, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1c90 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32, 84, 77, 84,
/* 0x1ca0 */  77, 65, 73, 78, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x1cb0 */  32, 32, 48, 32, 32, 48, 53, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1cc0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32, 85, 80, 88,
/* 0x1cd0 */  49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 50, 48, 32, 32,
/* 0x1ce0 */  48, 32, 32, 48, 32, 32, 48, 53, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x1cf0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 84, 77,
/* 0x1d00 */  84, 67, 85, 84, 80, 79, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x1d10 */  32, 32, 48, 32, 32, 48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1d20 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 78, 50, 66,
/* 0x1d30 */  83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48,
/* 0x1d40 */  32, 32, 48, 32, 32, 48, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1d50 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 78, 50, 66,
/* 0x1d60 */  70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x1d70 */  32, 32, 48, 32, 32, 48, 55,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1d80 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 78, 50, 66,
/* 0x1d90 */  70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48,
/* 0x1da0 */  32, 32, 48, 32, 32, 48, 56, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1db0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78, 50, 66,
/* 0x1dc0 */  68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48,
/* 0x1dd0 */  32, 32, 48, 32, 32, 48, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1de0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 78, 50, 66,
/* 0x1df0 */  83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x1e00 */  32, 32, 48, 32, 32, 48, 57, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1e10 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 78, 50, 66,
/* 0x1e20 */  70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48,
/* 0x1e30 */  32, 32, 48, 32, 32, 48, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1e40 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 78, 50, 66,
/* 0x1e50 */  68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48,
/* 0x1e60 */  32, 32, 48, 32, 32, 48, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1e70 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32, 78, 50, 66,
/* 0x1e80 */  83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48,
/* 0x1e90 */  32, 32, 48, 32, 32, 48, 97,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ea0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32, 78, 50, 66,
/* 0x1eb0 */  70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48,
/* 0x1ec0 */  32, 32, 48, 32, 32, 48, 98, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1ed0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32, 78, 50, 66,
/* 0x1ee0 */  68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 51,101, 32, 32,
/* 0x1ef0 */  48, 32, 32, 48, 32, 32, 48, 99, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x1f00 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32, 78, 50,
/* 0x1f10 */  66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32,
/* 0x1f20 */  48, 32, 32, 48, 32, 32, 48, 49, 48, 55, 32, 32, 50, 42, 42, 48,
/* 0x1f30 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56, 32, 78,
/* 0x1f40 */  50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32,
/* 0x1f50 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 52, 32, 32, 50, 42, 42,
/* 0x1f60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32,
/* 0x1f70 */  78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x1f80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 51, 32, 32, 50, 42,
/* 0x1f90 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48,
/* 0x1fa0 */  32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x1fb0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 53, 32, 32, 50,
/* 0x1fc0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x1fd0 */  49, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x1fe0 */  48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 56, 32, 32,
/* 0x1ff0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2000 */  50, 50, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32,
/* 0x2010 */  32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51, 49, 32,
/* 0x2020 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2030 */  32, 50, 51, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 32, 32, 32,
/* 0x2040 */  32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 51,
/* 0x2050 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2060 */  83, 10, 32, 50, 52, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 32,
/* 0x2070 */  32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2080 */  49, 53, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2090 */  78, 84, 83, 10, 32, 50, 53, 32, 78, 50, 66, 68, 69, 67, 54, 48,
/* 0x20a0 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x20b0 */  49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x20c0 */  78, 84, 83, 10, 32, 50, 54, 32, 78, 50, 68, 83, 77, 65, 49, 48,
/* 0x20d0 */  32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x20e0 */  48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x20f0 */  69, 78, 84, 83, 10, 32, 50, 55, 32, 78, 50, 68, 70, 65, 83, 49,
/* 0x2100 */  48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2110 */  32, 48, 49, 54,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2120 */  84, 69, 78, 84, 83, 10, 32, 50, 56, 32, 78, 50, 68, 70, 65, 83,
/* 0x2130 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48,
/* 0x2140 */  32, 32, 48, 49, 55, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2150 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 68, 68, 69,
/* 0x2160 */  67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32,
/* 0x2170 */  48, 32, 32, 48, 49, 55, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2180 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50, 68, 83,
/* 0x2190 */  77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x21a0 */  32, 48, 32, 32, 48, 49, 56, 50, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x21b0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 68,
/* 0x21c0 */  70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48,
/* 0x21d0 */  32, 32, 48, 32, 32, 48, 49, 56, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x21e0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78, 50,
/* 0x21f0 */  68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32,
/* 0x2200 */  48, 32, 32, 48, 32, 32, 48, 49, 57, 48, 32, 32, 50, 42, 42, 48,
/* 0x2210 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32, 78,
/* 0x2220 */  50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32,
/* 0x2230 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 57,100, 32, 32, 50, 42, 42,
/* 0x2240 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52, 32,
/* 0x2250 */  78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x2260 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97, 32, 32, 50, 42,
/* 0x2270 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 53,
/* 0x2280 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2290 */  53, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 57, 32, 32,
/* 0x22a0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x22b0 */  51, 54, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32,
/* 0x22c0 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 48, 98, 32,
/* 0x22d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x22e0 */  32, 51, 55, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 32, 32, 32,
/* 0x22f0 */  32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 49, 56,
/* 0x2300 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2310 */  10, 32, 51, 56, 32, 78, 50, 68, 83, 77, 65, 53, 48, 32, 32, 32,
/* 0x2320 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 50,
/* 0x2330 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2340 */  83, 10, 32, 51, 57, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 32,
/* 0x2350 */  32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2360 */  50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2370 */  84, 83, 10, 32, 52, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 32,
/* 0x2380 */  32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2390 */  50, 50, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x23a0 */  78, 84, 83, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 54, 48,
/* 0x23b0 */  32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x23c0 */  48, 50, 51, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x23d0 */  69, 78, 84, 83, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 54,
/* 0x23e0 */  48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48,
/* 0x23f0 */  32, 32, 48, 50, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2400 */  78, 84, 69, 78, 84, 83, 10, 32, 52, 51, 32, 78, 50, 68, 70, 65,
/* 0x2410 */  83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32,
/* 0x2420 */  32, 48, 32, 32, 48, 50, 53, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2430 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 52, 32, 78, 50, 68,
/* 0x2440 */  68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32,
/* 0x2450 */  32, 48, 32, 32, 48, 50, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2460 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 69,
/* 0x2470 */  83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48,
/* 0x2480 */  32, 32, 48, 32, 32, 48, 50, 55, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x2490 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50,
/* 0x24a0 */  69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x24b0 */  48, 32, 32, 48, 32, 32, 48, 50, 55, 51, 32, 32, 50, 42, 42, 48,
/* 0x24c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55, 32, 78,
/* 0x24d0 */  50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32,
/* 0x24e0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 53, 32, 32, 50, 42, 42,
/* 0x24f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32,
/* 0x2500 */  78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x2510 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 98, 32, 32, 50, 42,
/* 0x2520 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57,
/* 0x2530 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2540 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56, 54, 32, 32, 50,
/* 0x2550 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x2560 */  48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x2570 */  48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56, 98, 32, 32,
/* 0x2580 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2590 */  53, 49, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32,
/* 0x25a0 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 57, 52, 32,
/* 0x25b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x25c0 */  32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 32, 32, 32,
/* 0x25d0 */  32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 97, 49,
/* 0x25e0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x25f0 */  10, 32, 53, 51, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 32, 32,
/* 0x2600 */  32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 97,
/* 0x2610 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2620 */  83, 10, 32, 53, 52, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 32,
/* 0x2630 */  32, 32, 32, 32, 48, 53,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2640 */  50, 98,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2650 */  78, 84, 83, 10, 32, 53, 53, 32, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x2660 */  32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2670 */  48, 51, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2680 */  69, 78, 84, 83, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65, 83, 52,
/* 0x2690 */  48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32,
/* 0x26a0 */  32, 48, 51, 50, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x26b0 */  84, 69, 78, 84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 83, 77, 65,
/* 0x26c0 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48,
/* 0x26d0 */  32, 32, 48, 51, 51, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x26e0 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 70, 65,
/* 0x26f0 */  83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32,
/* 0x2700 */  48, 32, 32, 48, 51, 51, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2710 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50, 69, 68,
/* 0x2720 */  69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32,
/* 0x2730 */  32, 48, 32, 32, 48, 51, 51,100, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2740 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 48, 32, 78, 50, 69,
/* 0x2750 */  83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48,
/* 0x2760 */  32, 32, 48, 32, 32, 48, 51, 52, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x2770 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32, 78, 50,
/* 0x2780 */  69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32,
/* 0x2790 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 53, 50, 32, 32, 50, 42, 42,
/* 0x27a0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 50, 32,
/* 0x27b0 */  78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x27c0 */  54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 54, 98, 32, 32, 50,
/* 0x27d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x27e0 */  51, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32,
/* 0x27f0 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 56, 49, 32, 32, 50,
/* 0x2800 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x2810 */  52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 32, 32, 32,
/* 0x2820 */  48, 50,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 56, 49, 32,
/* 0x2830 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2840 */  32, 54, 53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32,
/* 0x2850 */  32, 32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 97,
/* 0x2860 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2870 */  83, 10, 32, 54, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x2880 */  32, 32, 32, 32, 48, 98, 51,101, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2890 */  48, 51,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x28a0 */  69, 78, 84, 83, 10, 32, 54, 55, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x28b0 */  67, 50, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32, 48, 32, 32,
/* 0x28c0 */  48, 32, 32, 48,102, 51, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x28d0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 56, 32, 76, 90, 77, 65,
/* 0x28e0 */  95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97, 32, 32, 48,
/* 0x28f0 */  32, 32, 48, 32, 32, 48, 49, 97, 55, 51, 32, 32, 50, 42, 42, 48,
/* 0x2900 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 57, 32, 84,
/* 0x2910 */  77, 84, 77, 65, 73, 78, 53, 32, 32, 32, 32, 32, 32, 48, 54, 32,
/* 0x2920 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 56,100, 32, 32, 50, 42,
/* 0x2930 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 48,
/* 0x2940 */  32, 84, 77, 84, 67, 65, 76, 84, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x2950 */  49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57, 51, 32, 32,
/* 0x2960 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2970 */  55, 49, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 32, 32, 32, 32,
/* 0x2980 */  32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 57, 52,
/* 0x2990 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x29a0 */  10, 32, 55, 50, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 32, 32,
/* 0x29b0 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x29c0 */  97, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x29d0 */  84, 83, 10, 32, 55, 51, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32,
/* 0x29e0 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x29f0 */  49, 97, 97, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2a00 */  69, 78, 84, 83, 10, 32, 55, 52, 32, 67, 84, 66, 83, 72, 82, 48,
/* 0x2a10 */  49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32,
/* 0x2a20 */  32, 48, 49, 97, 97, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2a30 */  78, 84, 69, 78, 84, 83, 10, 32, 55, 53, 32, 67, 84, 66, 82, 79,
/* 0x2a40 */  82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2a50 */  48, 32, 32, 48, 49, 97, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2a60 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 54, 32, 67, 84, 66,
/* 0x2a70 */  83, 87, 65, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x2a80 */  32, 32, 48, 32, 32, 48, 49, 97, 98, 50, 32, 32, 50, 42, 42, 48,
/* 0x2a90 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 67,
/* 0x2aa0 */  65, 76, 76, 84, 82, 48, 50, 32, 32, 32, 32, 32, 32, 48, 49, 48,
/* 0x2ab0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 98, 55, 32, 32, 50,
/* 0x2ac0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2ad0 */  56, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2ae0 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 55, 32,
/* 0x2af0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2b00 */  32, 55, 57, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 32, 32, 32,
/* 0x2b10 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99,
/* 0x2b20 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b30 */  83, 10, 32, 56, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 32, 32,
/* 0x2b40 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2b50 */  97, 99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2b60 */  78, 84, 83, 10, 32, 56, 49, 32, 67, 65, 76, 76, 84, 82, 49, 49,
/* 0x2b70 */  32, 32, 32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2b80 */  48, 49, 97,100, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2b90 */  84, 69, 78, 84, 83, 10, 32, 56, 50, 32, 67, 84, 67, 76, 69, 86,
/* 0x2ba0 */  69, 50, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x2bb0 */  32, 32, 48, 49, 97,100, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2bc0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 51, 32, 67, 65, 76, 76,
/* 0x2bd0 */  84, 82, 49, 50, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2be0 */  32, 48, 32, 32, 48, 49, 97,100, 57, 32, 32, 50, 42, 42, 48, 32,
/* 0x2bf0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 52, 32, 67, 84,
/* 0x2c00 */  66, 83, 72, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32, 32,
/* 0x2c10 */  48, 32, 32, 48, 32, 32, 48, 49, 97,100, 98, 32, 32, 50, 42, 42,
/* 0x2c20 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 53, 32,
/* 0x2c30 */  67, 84, 66, 82, 79, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2c40 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,100,102, 32, 32, 50,
/* 0x2c50 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2c60 */  54, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x2c70 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101, 49, 32,
/* 0x2c80 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2c90 */  32, 56, 55, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 32, 32, 32,
/* 0x2ca0 */  32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101,
/* 0x2cb0 */  54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2cc0 */  83, 10, 32, 56, 56, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32,
/* 0x2cd0 */  32, 32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2ce0 */  97,101,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2cf0 */  78, 84, 83, 10, 32, 56, 57, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x2d00 */  48, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2d10 */  48, 49, 97,102, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2d20 */  84, 69, 78, 84, 83, 10, 32, 57, 48, 32, 99,116,111,107, 51, 50,
/* 0x2d30 */  46, 50, 48, 32, 32, 32, 32, 32, 48, 50, 48, 32, 32, 48, 32, 32,
/* 0x2d40 */  48, 32, 32, 48, 49, 98, 48, 53, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2d50 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 49, 32, 99,116,111,
/* 0x2d60 */ 107, 51, 50, 46, 51, 48, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48,
/* 0x2d70 */  32, 32, 48, 32, 32, 48, 49, 98, 50, 53, 32, 32, 50, 42, 42, 48,
/* 0x2d80 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 50, 32, 99,
/* 0x2d90 */ 116,111,107, 51, 50, 46, 52, 48, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x2da0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 50,102, 32, 32, 50, 42,
/* 0x2db0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 51,
/* 0x2dc0 */  32, 84, 77, 84, 82, 69, 76, 79, 67, 32, 32, 32, 32, 32, 32, 48,
/* 0x2dd0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 51, 52, 32, 32,
/* 0x2de0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2df0 */  57, 52, 32, 82, 69, 76, 79, 67, 51, 50, 48, 32, 32, 32, 32, 32,
/* 0x2e00 */  32, 48, 50, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 51,
/* 0x2e10 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2e20 */  83, 10, 32, 57, 53, 32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 32,
/* 0x2e30 */  32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2e40 */  98, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2e50 */  78, 84, 83, 10, 32, 57, 54, 32, 82, 69, 76, 79, 67, 51, 50, 74,
/* 0x2e60 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2e70 */  48, 49, 98, 54, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2e80 */  84, 69, 78, 84, 83, 10, 32, 57, 55, 32, 82, 69, 76, 51, 50, 69,
/* 0x2e90 */  78, 68, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32,
/* 0x2ea0 */  32, 48, 49, 98, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2eb0 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 56, 32, 84, 77, 84, 74, 85,
/* 0x2ec0 */  77, 80, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x2ed0 */  48, 32, 32, 48, 49, 98, 54, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2ee0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32,
/* 0x2ef0 */  84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f00 */ 108, 32, 32, 32, 32,100, 32, 32, 84, 77, 84, 67, 85, 84, 80, 79,
/* 0x2f10 */  32, 48, 32, 84, 77, 84, 67, 85, 84, 80, 79, 10, 48, 48, 48, 48,
/* 0x2f20 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x2f30 */  83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48,
/* 0x2f40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2f50 */  32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 66,
/* 0x2f60 */  70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2f70 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32,
/* 0x2f80 */  48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x2f90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68,
/* 0x2fa0 */  69, 67, 50, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10,
/* 0x2fb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x2fc0 */  32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 66, 68,
/* 0x2fd0 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x2fe0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 48,
/* 0x2ff0 */  32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3000 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x3010 */  83, 54, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48,
/* 0x3020 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3030 */  78, 50, 66, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 66, 68, 69,
/* 0x3040 */  67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3050 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 48, 32,
/* 0x3060 */  78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3070 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83,
/* 0x3080 */  49, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48,
/* 0x3090 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x30a0 */  50, 68, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67,
/* 0x30b0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x30c0 */  32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 48, 32, 78,
/* 0x30d0 */  50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51,
/* 0x30f0 */  48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x3100 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3110 */  68, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 53,
/* 0x3120 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3130 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50,
/* 0x3140 */  68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3150 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48,
/* 0x3160 */  32, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48,
/* 0x3170 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3180 */  83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48,
/* 0x3190 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x31a0 */  32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 69,
/* 0x31b0 */  70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x31c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32,
/* 0x31d0 */  48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68,
/* 0x31f0 */  69, 67, 50, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10,
/* 0x3200 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3210 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 69, 68,
/* 0x3220 */  69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3230 */  32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 48,
/* 0x3240 */  32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3250 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65,
/* 0x3260 */  83, 54, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48,
/* 0x3270 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3280 */  78, 50, 69, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 69, 68, 69,
/* 0x3290 */  67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x32a0 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 48, 32,
/* 0x32b0 */  67, 65, 76, 76, 84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x32c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x32d0 */  49, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x32f0 */  65, 76, 76, 84, 82, 49, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x3300 */  49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3310 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 48, 32, 67,
/* 0x3320 */  65, 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3330 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x3340 */  48, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 48,
/* 0x3350 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3360 */  99,116,111,107, 51, 50, 46, 49, 48, 32, 48, 32, 99,116,111,107,
/* 0x3370 */  51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3380 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48,
/* 0x3390 */  32, 48, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48,
/* 0x33a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,
/* 0x33b0 */ 111,107, 51, 50, 46, 52, 48, 32, 48, 32, 99,116,111,107, 51, 50,
/* 0x33c0 */  46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x33d0 */  32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51, 50, 48, 32, 48, 32,
/* 0x33e0 */  82, 69, 76, 79, 67, 51, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x33f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51,
/* 0x3400 */  50, 74, 32, 48, 32, 82, 69, 76, 79, 67, 51, 50, 74, 10, 48, 48,
/* 0x3410 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 84,
/* 0x3420 */  77, 84, 77, 65, 73, 78, 49, 32, 48, 32, 84, 77, 84, 77, 65, 73,
/* 0x3430 */  78, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3440 */  32,100, 32, 32, 84, 77, 84, 77, 65, 73, 78, 49, 65, 32, 48, 32,
/* 0x3450 */  84, 77, 84, 77, 65, 73, 78, 49, 65, 10, 48, 48, 48, 48, 48, 48,
/* 0x3460 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 84, 77, 84, 77, 65,
/* 0x3470 */  73, 78, 49, 66, 32, 48, 32, 84, 77, 84, 77, 65, 73, 78, 49, 66,
/* 0x3480 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3490 */  32, 32, 84, 77, 84, 67, 65, 76, 84, 49, 32, 48, 32, 84, 77, 84,
/* 0x34a0 */  67, 65, 76, 84, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x34b0 */  32, 32, 32, 32,100, 32, 32, 84, 77, 84, 77, 65, 73, 78, 50, 32,
/* 0x34c0 */  48, 32, 84, 77, 84, 77, 65, 73, 78, 50, 10, 48, 48, 48, 48, 48,
/* 0x34d0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49,
/* 0x34e0 */  72, 69, 65, 68, 32, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10,
/* 0x34f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3500 */  32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70,
/* 0x3510 */  65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3520 */  32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48,
/* 0x3530 */  32, 78, 50, 66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3540 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65,
/* 0x3550 */  83, 50, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48,
/* 0x3560 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3570 */  78, 50, 66, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77,
/* 0x3580 */  65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3590 */  32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32,
/* 0x35a0 */  78, 50, 66, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x35b0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x35c0 */  52, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48,
/* 0x35d0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x35e0 */  50, 66, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83,
/* 0x35f0 */  52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3600 */  32,100, 32, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78,
/* 0x3610 */  50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3620 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53,
/* 0x3630 */  48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3650 */  66, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54,
/* 0x3660 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3670 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50,
/* 0x3680 */  66, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3690 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48,
/* 0x36a0 */  32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48,
/* 0x36b0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x36c0 */  83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48,
/* 0x36d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x36e0 */  32, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68,
/* 0x36f0 */  70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3700 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32,
/* 0x3710 */  48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x3720 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70,
/* 0x3730 */  65, 83, 51, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10,
/* 0x3740 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3750 */  32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83,
/* 0x3760 */  77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3770 */  32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48,
/* 0x3780 */  32, 78, 50, 68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3790 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77,
/* 0x37a0 */  65, 53, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48,
/* 0x37b0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x37c0 */  78, 50, 68, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65,
/* 0x37d0 */  83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x37e0 */  32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32,
/* 0x37f0 */  78, 50, 68, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83,
/* 0x3810 */  54, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48,
/* 0x3820 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3830 */  50, 69, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83,
/* 0x3840 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3850 */  32,100, 32, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78,
/* 0x3860 */  50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3870 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50,
/* 0x3880 */  48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48,
/* 0x3890 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x38a0 */  69, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51,
/* 0x38b0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x38c0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50,
/* 0x38d0 */  69, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x38e0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x38f0 */  32, 48, 32, 78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48,
/* 0x3900 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3910 */  70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48,
/* 0x3920 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3930 */  32, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69,
/* 0x3940 */  83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3950 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32,
/* 0x3960 */  48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x3970 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83,
/* 0x3980 */  77, 65, 54, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10,
/* 0x3990 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x39a0 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70,
/* 0x39b0 */  65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x39c0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48,
/* 0x39d0 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48,
/* 0x39e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x39f0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3a00 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3a10 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3a20 */  49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3a30 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3a40 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90,
/* 0x3a50 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a60 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3a70 */  69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x3a80 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3a90 */ 100, 32, 32, 84, 77, 84, 77, 65, 73, 78, 53, 32, 48, 32, 84, 77,
/* 0x3aa0 */  84, 77, 65, 73, 78, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3ab0 */ 108, 32, 32, 32, 32,100, 32, 32, 84, 77, 84, 67, 65, 76, 84, 50,
/* 0x3ac0 */  32, 48, 32, 84, 77, 84, 67, 65, 76, 84, 50, 10, 48, 48, 48, 48,
/* 0x3ad0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 67,
/* 0x3ae0 */  76, 69, 86, 69, 49, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69, 49,
/* 0x3af0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3b00 */  32, 32, 67, 65, 76, 76, 84, 82, 48, 49, 32, 48, 32, 67, 65, 76,
/* 0x3b10 */  76, 84, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3b20 */  32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 48, 49, 32,
/* 0x3b30 */  48, 32, 67, 84, 66, 83, 72, 82, 48, 49, 10, 48, 48, 48, 48, 48,
/* 0x3b40 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 82,
/* 0x3b50 */  79, 82, 48, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 10,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b70 */  32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 48, 32, 67, 84, 66, 83,
/* 0x3b80 */  87, 65, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b90 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 48,
/* 0x3ba0 */  32, 67, 65, 76, 76, 84, 82, 48, 50, 10, 48, 48, 48, 48, 48, 48,
/* 0x3bb0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x3bc0 */  82, 69, 56, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 56, 10, 48,
/* 0x3bd0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3be0 */  67, 65, 76, 76, 84, 82, 69, 57, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x3bf0 */  82, 69, 57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3c00 */  32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 48, 32,
/* 0x3c10 */  67, 84, 67, 76, 69, 86, 69, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3c30 */  49, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 50, 10, 48, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3c50 */  84, 66, 83, 72, 82, 49, 49, 32, 48, 32, 67, 84, 66, 83, 72, 82,
/* 0x3c60 */  49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3c70 */  32,100, 32, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32, 48, 32, 67,
/* 0x3c80 */  84, 66, 82, 79, 82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c90 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65, 49,
/* 0x3ca0 */  49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 49, 49, 10, 48, 48, 48,
/* 0x3cb0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,
/* 0x3cc0 */ 111,107, 51, 50, 46, 51, 48, 32, 48, 32, 99,116,111,107, 51, 50,
/* 0x3cd0 */  46, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3ce0 */  32, 32,100, 32, 32, 84, 77, 84, 82, 69, 76, 79, 67, 32, 48, 32,
/* 0x3cf0 */  84, 77, 84, 82, 69, 76, 79, 67, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 51, 50, 66,
/* 0x3d10 */  73, 71, 32, 48, 32, 82, 69, 76, 51, 50, 66, 73, 71, 10, 48, 48,
/* 0x3d20 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82,
/* 0x3d30 */  69, 76, 51, 50, 69, 78, 68, 32, 48, 32, 82, 69, 76, 51, 50, 69,
/* 0x3d40 */  78, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3d50 */  32,100, 32, 32, 84, 77, 84, 74, 85, 77, 80, 49, 32, 48, 32, 84,
/* 0x3d60 */  77, 84, 74, 85, 77, 80, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x3d80 */  32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48,
/* 0x3d90 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3da0 */  78, 68, 42, 32, 48, 32, 99,111,112,121, 95,100,101,115,116, 10,
/* 0x3db0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3dc0 */  32, 42, 85, 78, 68, 42, 32, 48, 32, 98,121,116,101,115, 95,116,
/* 0x3dd0 */ 111, 95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3de0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x3df0 */ 108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,
/* 0x3e00 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3e10 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,
/* 0x3e20 */ 117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e30 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,
/* 0x3e40 */ 122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3e50 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3e60 */  32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,
/* 0x3e70 */ 101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3e80 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,
/* 0x3e90 */ 101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x3eb0 */  32, 48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,
/* 0x3ec0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x3ed0 */  85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108, 95,
/* 0x3ee0 */ 101,110,116,114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x3ef0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 84,
/* 0x3f00 */  77, 84, 77, 65, 73, 78, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x3f10 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f20 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x3f40 */  32, 32, 32, 32, 32, 32, 99,111,112,121, 95,115,111,117,114, 99,
/* 0x3f50 */ 101, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54,
/* 0x3f60 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,
/* 0x3f70 */ 121, 95,100,101,115,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x3f80 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x3f90 */  84, 77, 84, 77, 65, 73, 78, 49, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x3fa0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fb0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x3fc0 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x3fd0 */  32, 32, 32, 32, 32, 32, 32, 32, 98,121,116,101,115, 95,116,111,
/* 0x3fe0 */  95, 99,111,112,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x3ff0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 84,
/* 0x4000 */  77, 84, 77, 65, 73, 78, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4010 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4020 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4030 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32,
/* 0x4040 */  32, 32, 32, 32, 32, 32, 84, 77, 84, 67, 85, 84, 80, 79, 10, 10,
/* 0x4050 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4060 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 49, 48,
/* 0x4070 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4090 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x40a0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x40b0 */  50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x40c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x40d0 */  91, 78, 50, 66, 70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x40e0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4100 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4110 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x4120 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4130 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65,
/* 0x4140 */  50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4150 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4160 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4170 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4180 */  32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4190 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x41a0 */  82, 32, 91, 78, 50, 66, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70,
/* 0x41b0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x41c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x41d0 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x41e0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x41f0 */  49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4200 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83,
/* 0x4210 */  77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4220 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4230 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4240 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4250 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76,
/* 0x4260 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4270 */  70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 51, 48, 93, 58, 10,
/* 0x4280 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4290 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x42a0 */  10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95,
/* 0x42b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x42c0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95,
/* 0x42d0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x42e0 */  78, 50, 66, 68, 69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x42f0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4300 */  32, 91, 78, 50, 66, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70,
/* 0x4310 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4320 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 49, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4340 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 54,
/* 0x4350 */  48, 10, 48, 48, 48, 48, 48, 48, 50,102, 32, 82, 95, 51, 56, 54,
/* 0x4360 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66,
/* 0x4370 */  68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4380 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4390 */  50, 66, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x43a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x43b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x43c0 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x43d0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10,
/* 0x43e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x43f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 52, 48,
/* 0x4400 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4420 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x4430 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4440 */  50, 66, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x4450 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4460 */  32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x4470 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4480 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x4490 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x44a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x44b0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x44c0 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x44d0 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x44e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x44f0 */  66, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4500 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4510 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4520 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4530 */  32, 32, 32, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x4540 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4550 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49,
/* 0x4560 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4570 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65,
/* 0x4580 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4590 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x45a0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x45b0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x45c0 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x45d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x45e0 */  79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 49, 48, 93, 58, 10, 79,
/* 0x45f0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4600 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4620 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x4630 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4640 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x4650 */  70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4660 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4670 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4680 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4690 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x46a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x46b0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 50, 48, 93, 58,
/* 0x46c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x46d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x46e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x46f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x4700 */  83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4710 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4720 */  50, 68, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4730 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4740 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4760 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 10,
/* 0x4770 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4780 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 51, 48,
/* 0x4790 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x47a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x47b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x47c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x47d0 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x47e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x47f0 */  91, 78, 50, 68, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4800 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4810 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4820 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4830 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x4840 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x4850 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4860 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4870 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4880 */  68, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4890 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48a0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x48b0 */  48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x48c0 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x48d0 */  48, 48, 48, 48, 50, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x48e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x48f0 */  48, 10, 48, 48, 48, 48, 48, 48, 52, 51, 32, 82, 95, 51, 56, 54,
/* 0x4900 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x4910 */  68, 69, 67, 53, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4920 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4930 */  50, 68, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4940 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4950 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4960 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4970 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10,
/* 0x4980 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4990 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 52, 48,
/* 0x49a0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x49b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x49c0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x49d0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x49e0 */  50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x49f0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4a00 */  32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x4a10 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4a20 */  70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x4a30 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4a40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4a50 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x4a60 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4a70 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4a80 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4a90 */  68, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4aa0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ab0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4ac0 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4ad0 */  32, 32, 32, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x4ae0 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x4af0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49,
/* 0x4b00 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4b10 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65,
/* 0x4b20 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4b30 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b40 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x4b50 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4b60 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x4b70 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4b80 */  79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 49, 48, 93, 58, 10, 79,
/* 0x4b90 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4bb0 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4bc0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x4bd0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4be0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x4bf0 */  70, 65, 83, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4c00 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c10 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4c30 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x4c40 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4c50 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 50, 48, 93, 58,
/* 0x4c60 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4c70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4c80 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x4c90 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x4ca0 */  83, 77, 65, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4cb0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4cc0 */  50, 69, 70, 65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4cd0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ce0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4cf0 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4d00 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 10, 10,
/* 0x4d10 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4d20 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 51, 48,
/* 0x4d30 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4d50 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x4d60 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4d70 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4d80 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4d90 */  91, 78, 50, 69, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4da0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4db0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4dc0 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4dd0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x4de0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x4df0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x4e00 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4e10 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4e20 */  69, 68, 69, 67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4e30 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e40 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4e50 */  48,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4e60 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x4e70 */  48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4e80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 53,
/* 0x4e90 */  48, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32, 82, 95, 51, 56, 54,
/* 0x4ea0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x4eb0 */  68, 69, 67, 54, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4ec0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4ed0 */  50, 69, 83, 77, 65, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4ee0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ef0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4f00 */  48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4f10 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10,
/* 0x4f20 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4f30 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 52, 48,
/* 0x4f40 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4f50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4f60 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x4f70 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4f80 */  50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,101,
/* 0x4f90 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4fa0 */  32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76,
/* 0x4fb0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4fc0 */  70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 54, 48, 93, 58, 10,
/* 0x4fd0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4ff0 */  10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95,
/* 0x5000 */  80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x5010 */  69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5020 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5030 */  69, 70, 65, 83, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5040 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5050 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5060 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48,
/* 0x5080 */  48, 48, 48, 48, 49, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51,
/* 0x5090 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49,
/* 0x50a0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x50b0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65,
/* 0x50c0 */  83, 54, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x50d0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x50e0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x50f0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5100 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5110 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5120 */  79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 93, 58,
/* 0x5130 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5150 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54,
/* 0x5160 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109,
/* 0x5170 */  97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116, 10, 48,
/* 0x5180 */  48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x5190 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95,117,
/* 0x51a0 */  95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95,
/* 0x51b0 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51c0 */ 108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48,
/* 0x51d0 */  48, 50, 97, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x51e0 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,112,114,111,112,101,
/* 0x51f0 */ 114,116,105,101,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5200 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67,
/* 0x5210 */  65, 76, 76, 84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5220 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5230 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5240 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x5250 */  32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,110,
/* 0x5260 */ 103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5270 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67,
/* 0x5280 */  76, 69, 86, 69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5290 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x52a0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x52b0 */  50, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x52c0 */  32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48,
/* 0x52d0 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x52e0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x52f0 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5300 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x5310 */  84, 82, 48, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5320 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5330 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102,
/* 0x5340 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5350 */  32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76,
/* 0x5360 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5370 */  70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58, 10,
/* 0x5380 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5390 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x53a0 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x53b0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x53c0 */ 101,114, 95,108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67,
/* 0x53d0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x53e0 */  82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79, 70,
/* 0x53f0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5400 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5410 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5420 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x5430 */  49, 51, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5440 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76,
/* 0x5450 */  69, 86, 69, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5460 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5470 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x5480 */  32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5490 */  32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,
/* 0x54a0 */  48, 48, 48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x54b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x54c0 */  49, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x54d0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84,
/* 0x54e0 */  82, 49, 51, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x54f0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5500 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x5510 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5520 */  32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5530 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5540 */  79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10,
/* 0x5550 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x5560 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x5570 */  10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95,
/* 0x5580 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,
/* 0x5590 */ 101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x55a0 */  48, 54, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x55b0 */  32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10,
/* 0x55c0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x55d0 */  68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49,
/* 0x55e0 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x55f0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5600 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95,
/* 0x5610 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5620 */  99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x5630 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x5640 */  82, 32, 91, 99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79,
/* 0x5650 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5660 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5670 */  48, 48, 48, 48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5680 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51,
/* 0x5690 */  50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95,
/* 0x56a0 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56b0 */  99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x56c0 */  48,101, 32, 82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32,
/* 0x56d0 */  32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10,
/* 0x56e0 */  48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x56f0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51,
/* 0x5700 */  50, 46, 52, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5710 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,
/* 0x5720 */ 111,107, 51, 50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5730 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5740 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5750 */  48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5760 */  32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10,
/* 0x5770 */  48, 48, 48, 48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5780 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51,
/* 0x5790 */  50, 46, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x57a0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,
/* 0x57b0 */ 111,107, 51, 50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x57c0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x57d0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x57e0 */  48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x57f0 */  32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10,
/* 0x5800 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5810 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 51, 50,
/* 0x5820 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5830 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5840 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95,
/* 0x5850 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5860 */  82, 69, 76, 79, 67, 51, 50, 74, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x5870 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x5880 */  32, 91, 82, 69, 76, 51, 50, 66, 73, 71, 93, 58, 10, 79, 70, 70,
/* 0x5890 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x58a0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x58b0 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x58c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50,
/* 0x58d0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x58e0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67,
/* 0x58f0 */  51, 50, 74, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x5900 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5910 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x5920 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5930 */  32, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79,
/* 0x5940 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5950 */  79, 82, 32, 91, 84, 77, 84, 74, 85, 77, 80, 49, 93, 58, 10, 79,
/* 0x5960 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5970 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5980 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5990 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,
/* 0x59a0 */ 110, 97,108, 95,101,110,116,114,121, 10
};
